#=head1 NAME

C<Parse::Token> - Dfinition des tokens utiliss par C<Parse::Lex>

#=head1 SYNOPSIS

	require 5.005;

	use Parse::Lex;
	@token = qw(
	    ADDOP    [-+]
	    INTEGER  [1-9][0-9]*
	   );

	$lexer = Parse::Lex->new(@token);
	$lexer->from(\*DATA);

	$content = $INTEGER->next;
	if ($INTEGER->status) {
	  print "$content\n";
	}
	$content = $ADDOP->next;
	if ($ADDOP->status) {
	  print "$content\n";
	}
	if ($INTEGER->isnext(\$content)) {
	  print "$content\n";
	}
	__END__
	1+2

#=head1 DESCRIPTION

La classe C<Parse::Token> et ses drives permettent de dfinir les
tokens utiliss par C<Parse::Lex> ou C<Parse::LexEvent>.

La cration des tokens peut se faire au moyen des mthodes C<new()> ou
C<factory()>.  La mthode C<Lex::new()> du package C<Parse::Lex> cre
indirectement des instances des tokens  reconnatre.

Les mthodes C<next()> ou C<isnext()> du package C<Parse::Token>
permettent d'interfacer l'analyseur lexical avec un analyseur
syntaxique de type rcursif descendant. Pour un interfaage avec
C<byacc> voir le package C<Parse::YYLex>.

L'inclusion de C<Parse::Token> se fait indirectement par un C<use
Parse::Lex> ou C<use Parse::LexEvent>.

#=head1 Mthodes

#=over 4

#=item action

Retourne la fonction anonyme dfinie dans l'objet C<Parse::Token>.	

#=item factory LIST

#=item factory ARRAY_REF

La mthode C<factory(LIST)> cre et retourne une liste de tokens 
partir d'une liste de spcifications incluant par token : un nom, une
expression rgulire et ventuellement une fonction anonyme. La liste
peut inclure des objets de la classe C<Parse::Token> ou d'une classe
qui en drive.

C<factory(ARRAY_REF)> permet de crer des tokens  partir de
spcifications de type attribut-valeur :

	Parse::Token->factory([Type => 'Simple', 
                               Name => 'EXAMPLE', 
			       Regex => '.+']);

C<Type> indique le type de chaque token  crer (le prfixe de package 
n'est pas indiqu).

C<factory()> cre une srie de tokens mais n'importe pas ces tokens
dans le package d'appel.

On pourra pas exemple crire :

	%keywords = 
	  qw (
	      PROC  undef
	      FUNC  undef
	      RETURN undef
	      IF    undef
	      ELSE  undef
	      WHILE undef
	      PRINT undef
	      READ  undef
	     );
	@tokens = Parse::Token->factory(%keywords);

et installer ces tokens dans une table des symboles de la manire
suivante :

	foreach $name (keys %keywords) {
	  ${$name} = pop @tokens;
	  $symbol{"\L$name"} = [${$name}, ''];
	}

C<${$name}> est l'instance token.

Lors de la phase d'analyse lexicale on pourra utiliser les tokens de
la manire suivante :

	qw(IDENT [a-zA-Z][a-zA-Z0-9_]*),  sub {		      
	   $symbol{$_[1]} = [] unless defined $symbol{$_[1]};
	   my $type = $symbol{$_[1]}[0];
	   $lexer->setToken((not defined $type) ? $VAR : $type);
	   $_[1];  # THE TOKEN TEXT
	 }

Ce qui permet d'indiquer que tout symbole dont le type est inconnu est
une variable.

Dans cet exemple nous avons utilis C<$_[1]> qui correspond au texte
reconnu par l'expression rgulire.  Ce texte associ au token doit
tre retourn par la fonction anonyme.

#=item get EXPR

Permet d'obtenir la valeur de l'attribut rsultant de l'valuation
d'EXPR.  Il est galement possible d'utiliser le nom de l'attribut
comme nom de mthode.

#=item getText

Retourne la chane de caractres reconnue au moyen de l'objet
C<Parse::Token>.

Synonyme de la mthode C<text()>.

#=item isnext EXPR

#=item isnext

Retourne le statut du token. La chane consomme est disponible dans
EXPR s'il s'agit d'une rfrence  un scalaire.

#=item name

Retourne le nom du token.

#=item next

Active la recherche du token dfini par l'expression rgulire
contenue dans l'objet. Si ce token est reconnu sur le flot de
caractre  analyser alors C<next()> retourne la chane trouve et met le
statut de l'objet  vrai.

#=item new SYMBOL_NAME, REGEXP, SUB

#=item new SYMBOL_NAME, REGEXP

Cre un objet de type C<Parse::Token::Simple> ou
C<Parse::Token::Segmented>. Les arguments de la mthode C<new()> sont
dans l'ordre : un nom symbolique, une expression rgulire et
ventuellement une fonction anonyme.  Les sous-classes de
C<Parse::Token> permettent une spcification des tokens au moyen d'une
liste d'attribut-valeurs.

REGEXP est soit une expression rgulire simple, soit une rfrence 
un tableau contenant de une  trois expressions rgulires.  Dans le
permier cas l'instance appartient  la classe C<Parse::Token::Simple>
Dans le second cas l'instance appartient  la classe
C<Parse::Token::Segmented>.  Les tokens de ce type permettent de
reconnatre des structures de type chane de caractres dlimite par
des guillemets, des commentaires d'un programme C, etc.  Les
expressions rgulires sont utilises pour reconnatre :

1. le dbut du token, 

2. le "corps" du token, si cette seconde expression est absente
C<Parse::Lex> utilise C<(?:.*?)>,

3. la fin du token, si cette dernire expression est absente on
utilise la premire.  La fin du token ne peut tre  cheval sur
plusieurs enregistrements.

Exemple.

	  qw(STRING), [qw(" (?:[^"\\\\]+|\\\\(?:.|\n))* ")],

Les expressions rgulires peuvent reconnatre des chanes multilignes
dlimites par des guillemets, sachant que le contre-oblique est
utilis pour littraliser les guillemets qui apparaissent au sein de
la chane. Remarquez le quadruplement du contre-oblique.

Voici une variante de l'exemple prcdent qui utilise l'option C<s>
pour inclure la nouvelle-ligne dans les caractres reconnus par "C<.>" :

	  qw(STRING), [qw(" (?s:[^"\\\\]+|\\\\.)* ")],

(Remarques. Il est possible d'crire des expressions rgulires plus
performantes en terme de temps d'excution, mais ce n'est pas notre
objectif ici, voir I<Mastering Regular Expressions>.)

La fonction anonyme est excute au moment ou le token est reconnu par
l'analyseur lexical. Cette fonction possde deux arguments : C<$_[0]>
contient l'instance de token, C<$_[1]> contient la chane reconnue par
l'expression rgulire. Le scalaire retourn par la fonction anonyme
dfinit la chane de caractres place dans l'instance token.

Dans la fonction anonyme vous pouvez utiliser les variables
positionnelles C<$1>, C<$2>, ... qui correspondent aux parenthses
places dans l'expression rgulire.

#=item regexp

Retourne l'expression rgulire dfinie dans l'objet C<Parse::Token>.

#=item set LISTE

Permet de dcorer un token au moyen d'une liste d'attribut-valeurs.

Un nom d'attribut peut tre utilis comme nom de mthode.

#=item setText EXPR

La valeur de EXPR dfinit la chane de caractres associe au 
token.

Synonyme de la mthode C<text(EXPR)>.

#=item status EXPR

#=item status

Indique si la dernire recherche du token a russie ou choue.
C<status EXPR> permet de forcer le statut  la valeur dnote
par EXPR.

#=item text EXPR

#=item text

C<text()> Retourne la chane de caractres reconnue au moyen du
token. La valeur de EXPR permet de dfinir la chane de caractres
associe au token.

#=item trace OUTPUT 

#=item trace 

Mthode de classe qui active/dsactive une trace de l'analyse
lexicale. 

C<OUTPUT> peut tre un nom de fichier ou une rfrence  un
filehandle vers laquelle la trace va tre dirige.

#=back

#=head1 Sous-classes de Parse::Token

Des sous-classes de la classe C<Parse::Token> sont en cours de
dfinition. Elles permettent de reconnatre des structures
particulires comme, par exemple, les chanes de caractres entre
guillemets, les commentaires C, etc. Voici les sous-classes sur
lesquelles je travaille actuellement :

C<Parse::Token::Action> : permet d'insrer des expressions Perl entre
deux tokens de l'analyseur lexical.

C<Parse::Token::Simple> : les tokens de cette classe sont dfinis au
moyen d'une seule expression rgulire.

C<Parse::Token::Segmented> : les tokens de cette classe sont dfinis au
moyen de trois expressions rgulires. La lecture de nouvelles donnes
est automatique.

C<Parse::Token::Delimited> : permet de reconnatre, par exemple, des
commentaires C.

C<Parse::Token::Quoted> : permet de reconnatre, par exemple, des
chanes de caractres entre guillemets.

C<Parse::Token::Nested> : permet de reconnatre des structures
imbriques, telles que les expressions parenthses. NON DFINIE.

La cration de ces classes est rcente et comporte sans aucun doute
des bugs. 

#=head2 Parse::Token::Action 

Les tokens de la classe C<Parse::Token::Action> permettent d'insrer
des expressions Perl quelconque au sein d'un analyseur lexical.  Une
expression peut tre utilise par exemple pour imprimer des variables
internes  l'analyseur :

#=over 

#=item *

C<$LEX_BUFFER> : contenu du buffer  analyser

#=item *

C<$LEX_LENGTH> : longueur de la chane de caractres en cours d'analyse

#=item *

C<$LEX_RECORD> : numro de l'enregistrement en cours d'analyse

#=item *

C<$LEX_OFFSET> : nombre de caractre dj consomms depuis le dbut de
l'analyse

#=item *

C<$LEX_POS> : position atteinte par l'analyse en nombre de caractres
depuis le dbut du buffer.

#=back

Le constructeur de la classe accepte les attributs suivants : 

#=over 

#=item *

C<Name> : le nom du token

#=item * 

C<Expr> : une expression Perl 

#=back

Exemple :

	$ACTION = new Parse::Token::Action(
				      Name => 'ACTION',
				      Expr => q!print "LEX_POS: $LEX_POS\n" .
				      "LEX_BUFFER: $LEX_BUFFER\n" .
				      "LEX_LENGTH: $LEX_LENGTH\n" .
				      "LEX_RECORD: $LEX_RECORD\n" .
				      "LEX_OFFSET: $LEX_OFFSET\n" 
				      ;!,
				     );

#=head2 Parse::Token::Simple

Le constructeur de la classe accepte les attributs suivants : 

#=over

#=item * 

C<Handler> : la valeur indique un nom fonction  appeler lors d'une
analyse conduite par un analyseur de la classe C<Parse::LexEvent>.

#=item * 

C<Name> : la valeur associe est le nom du token.

#=item * 

C<Regex> : La valeur associe est une expression rgulire
correspondant au motif  reconnatre.

#=item * 

C<ReadMore> : si la valeur associe est 1, la reconnaissance du token
se poursuit aprs la lecture d'un nouvel enregistrement.  Les chanes
reconnues sont concatnes. Cet attribut n'a d'effet que lors de
l'analyse d'un flot de caractres.

#=item * 

C<Sub> : la valeur associe doit tre une fonction anonyme  excuter
 l'issue de la reconnaissance du token. Cette fonction n'est utilise
qu'avec les analyseurs de la classe C<Parse::Lex> ou C<Parse::CLex>.

#=back

Exemple.
      new Parse::Token::Simple(Name => 'remainder', 
			       Regex => '[^/\'\"]+', 
			       ReadMore => 1);

#=head2 Parse::Token::Segmented

La dfinition de ces tokens comporte trois expressions
rgulires. Lors de l'analyse d'un flot de donnes, de nouvelles
donnes sont lues tant que la fin du token n'est pas atteinte.

Le constructeur de la classe accepte les attributs suivants : 

#=over

#=item * 

C<Handler> : la valeur indique un nom fonction  appeler lors d'une
analyse conduite par un analyseur de la classe C<Parse::LexEvent>.

#=item * 

C<Name> : la valeur associe est le nom du token.

#=item * 

C<Regex> : La valeur associe doit tre une rfrence  un tableau qui 
contient trois expressions rgulires.

#=item * 

C<Sub> : la valeur associe doit tre une fonction anonyme  excuter
 l'issue de la reconnaissance du token. Cette fonction n'est utilise
avec les analyseurs de la classe C<Parse::Lex> ou C<Parse::CLex>.

#=back

#=head2 Parse::Token::Quoted

C<Parse::Token::Quoted> est une sous-classe de
C<Parse::Token::Segmented>. Elle permet de reconnatre des chanes de
caractres entre guillemets ou apostrophes.

Exemples.

      ---------------------------------------------------------
	Dbut	Fin	Littralisation
      ---------------------------------------------------------
	'	'	''		
	"	"	""		
	"	"	\		
      ---------------------------------------------------------

Le constructeur de la classe accepte les attributs suivants : 

#=over

#=item * 

C<End> : La valeur associe est une expression rgulire permettant
de reconnatre la fin du token.

#=item * 

C<Escape> : La valeur associe indique le caractre utilis pour
littralisater le dlimiteur. Par dfaut on considre qu'un doublement
du caractre de fin littralise ce caractre.

#=item * 

C<Handler> : la valeur indique un nom fonction  appeler lors d'une
analyse conduite par un analyseur de la classe C<Parse::LexEvent>.

#=item * 

C<Name> : la valeur associe est le nom du token.

#=item * 

C<Start> : La valeur associe est une expression rgulire permettant
de reconnatre le dbut du token.

#=item * 

C<Sub> : la valeur associe doit tre une fonction anonyme  excuter
 l'issue de la reconnaissance du token. Cette fonction n'est utilise
avec les analyseurs de la classe C<Parse::Lex> ou C<Parse::CLex>.

#=back

Exemple.
      new Parse::Token::Quoted(Name => 'squotes', 
			       Handler => 'string',
			       Escape => '\\',
			       Quote => qq!\'!, 
			      );

#=head2 Parse::Token::Delimited

C<Parse::Token::Delimited> est une sous-classe de
C<Parse::Token::Segmented>. Elle permet, par exemple, de reconnatre
des commentaires C.

Exemples.

      ---------------------------------------------------------
	Dbut	Fin	Contrainte
			Sur le contenu	
      ---------------------------------------------------------
	/*	*/			Commentaire C
	<!--	-->	Pas de '--'	Commentaire XML
	<!--	-->	           	Commentaire SGML
	<?  ?>				Processing instruction
					en SGML/XML
      ---------------------------------------------------------

Le constructeur de la classe accepte les attributs suivants : 

#=over 4

#=item * 

C<End> : La valeur associe est une expression rgulire permettant
de reconnatre la fin du token.

#=item * 

C<Handler> : la valeur indique un nom fonction  appeler lors d'une
analyse conduite par un analyseur de la classe C<Parse::LexEvent>.

#=item * 

C<Name> : la valeur associe est le nom du token.

#=item * 

C<Start> : La valeur associe est une expression rgulire permettant
de reconnatre le dbut du token.

#=item * 

C<Sub> : la valeur associe doit tre une fonction anonyme  excuter
 l'issue de la reconnaissance du token. Cette fonction n'est utilise
avec les analyseurs de la classe C<Parse::Lex> ou C<Parse::CLex>.

#=back

Exemple.
      new Parse::Token::Delimited(Name => 'comment',
				  Start => '/[*]', 
				  End => '[*]/'
				 );

#=head2 Parse::Token::Nested - Non dfinie

Exemples.

      ----------------------------------------------------------
	Dbut	Fin	Contrainte
			Sur le contenu	
      ----------------------------------------------------------
	(	)			Symbolic Expressions
	{	}			Rich Text Format Groups
      ----------------------------------------------------------


#=head1 BUGS

L'implmentation des sous-classes de tokens n'est pas complte pour
les analyseurs de la classe C<Parse::CLex>. Je n'ai d'ailleurs pas
trop envi de le faire, sachant qu'une implmentation pour les classes
C<Parse::Lex> et C<Parse::LexEvent> ne parat tout  fait suffisante.

#=head1 AUTEUR

Philippe Verdret

#=head1 REMERCIEMENTS

La version 2.0 doit beaucoup aux suggestions de Vladimir Alexiev.
Ocrat a largement contribu  l'amlioration de cette documentation.
Merci galement aux nombreuses personnes qui m'ont fait des remarques
et parfois envoys des corrections de bugs.

#=head1 REFERENCES

Friedl, J.E.F. Mastering Regular Expressions. O'Reilly & Associates
1996.

Mason, T. & Brown, D. - Lex & Yacc. O'Reilly & Associates, Inc. 1990.

#=head1 COPYRIGHT

Copyright (c) 1995-1999 Philippe Verdret. All rights reserved.
This module is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

#=cut
