/*
 * Decompiled with CFR 0.152.
 */
package com.ctreber.aclib.gui;

import com.ctreber.aclib.gui.MonitoredObject;

public class MODouble
extends MonitoredObject {
    private double fDouble;
    private boolean fCheckRange = false;
    private double fMin;
    private double fMax;

    public MODouble() {
    }

    public MODouble(double d) {
        this.fDouble = d;
    }

    public MODouble(double d, double d2, double d3) {
        this.fMin = d2;
        this.fMax = d3;
        this.fCheckRange = true;
        this.set(d);
    }

    public void set(double d) {
        if (!this.checkRange(d)) {
            throw new IllegalArgumentException("Argument '" + d + "' out of range [" + MODouble.niceFormat(this.fMin) + "; " + MODouble.niceFormat(this.fMax) + "]");
        }
        this.fDouble = d;
        this.fireValueChanged();
    }

    private static String niceFormat(double d) {
        if (d == Double.MAX_VALUE) {
            return "Infinity";
        }
        if (d == Double.MIN_VALUE) {
            return "-Infinity";
        }
        return Double.toString(d);
    }

    public double get() {
        return this.fDouble;
    }

    private boolean checkRange(double d) {
        return !this.fCheckRange || this.fMin <= d && d <= this.fMax;
    }

    public boolean checkRange() {
        return this.checkRange(this.fDouble);
    }
}

