/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.geom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.geom.AbstractPolyline;
import net.sourceforge.plantuml.geom.InflationTransform;
import net.sourceforge.plantuml.geom.LineSegmentInt;
import net.sourceforge.plantuml.geom.Point2DInt;
import net.sourceforge.plantuml.geom.Pointable;
import net.sourceforge.plantuml.geom.Polyline;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolylineImpl
extends AbstractPolyline
implements Polyline {
    private final List<Point2DInt> intermediates = new ArrayList<Point2DInt>();

    public PolylineImpl(Pointable pointable, Pointable pointable2) {
        super(pointable, pointable2);
    }

    @Override
    public int nbSegments() {
        return this.intermediates.size() + 1;
    }

    @Override
    public List<LineSegmentInt> segments() {
        ArrayList<LineSegmentInt> arrayList = new ArrayList<LineSegmentInt>();
        Point2DInt point2DInt = this.getStart().getPosition();
        for (Point2DInt point2DInt2 : this.intermediates) {
            arrayList.add(new LineSegmentInt(point2DInt, point2DInt2));
            point2DInt = point2DInt2;
        }
        arrayList.add(new LineSegmentInt(point2DInt, this.getEnd().getPosition()));
        return Collections.unmodifiableList(arrayList);
    }

    public void addIntermediate(Point2DInt point2DInt) {
        assert (!this.intermediates.contains(point2DInt));
        this.intermediates.add(point2DInt);
    }

    public void inflate(InflationTransform inflationTransform) {
        List<LineSegmentInt> list = inflationTransform.inflate(this.segments());
        this.intermediates.clear();
        for (int i = 1; i < list.size() - 1; ++i) {
            this.addIntermediate(list.get(i).getP1());
        }
    }

    public final Collection<Point2DInt> getIntermediates() {
        return Collections.unmodifiableCollection(this.intermediates);
    }
}

