/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.objectdiagram;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.UniqueSequence;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;

public abstract class AbstractClassOrObjectDiagram
extends AbstractEntityDiagram {
    private final List<Association> assocations = new ArrayList<Association>();

    public final boolean insertBetween(IEntity iEntity, IEntity iEntity2, IEntity iEntity3) {
        Link link = this.foundLink(iEntity, iEntity2);
        if (link == null) {
            return false;
        }
        Link link2 = new Link(iEntity, iEntity3, link.getType(), link.getLabel(), link.getLength(), link.getQualifier1(), null, link.getLabeldistance(), link.getLabelangle());
        Link link3 = new Link(iEntity3, iEntity2, link.getType(), link.getLabel(), link.getLength(), null, link.getQualifier2(), link.getLabeldistance(), link.getLabelangle());
        this.addLink(link2);
        this.addLink(link3);
        this.removeLink(link);
        return true;
    }

    private Link foundLink(IEntity iEntity, IEntity iEntity2) {
        List<Link> list = this.getLinks();
        for (int i = list.size() - 1; i >= 0; --i) {
            Link link = list.get(i);
            if (!link.isBetween(iEntity, iEntity2)) continue;
            return link;
        }
        return null;
    }

    public int getNbOfHozizontalLollipop(IEntity iEntity) {
        if (iEntity.getEntityType() == LeafType.LOLLIPOP) {
            throw new IllegalArgumentException();
        }
        int n = 0;
        for (Link link : this.getLinks()) {
            if (link.getLength() != 1 || !link.contains(iEntity) || !link.containsType(LeafType.LOLLIPOP)) continue;
            ++n;
        }
        return n;
    }

    public boolean associationClass(int n, Code code, Code code2, IEntity iEntity, LinkType linkType, Display display) {
        Object object;
        IEntity iEntity2 = this.getOrCreateLeaf(code, null, null);
        IEntity iEntity3 = this.getOrCreateLeaf(code2, null, null);
        ArrayList<Association> arrayList = new ArrayList<Association>();
        for (Association association : this.assocations) {
            if (!association.sameCouple(iEntity2, iEntity3)) continue;
            arrayList.add(association);
        }
        if (arrayList.size() > 1) {
            return false;
        }
        if (arrayList.size() == 0) {
            object = new Association(n, iEntity2, iEntity3, iEntity);
            ((Association)object).createNew(n, linkType, display);
            this.assocations.add((Association)object);
            return true;
        }
        assert (arrayList.size() == 1);
        object = ((Association)arrayList.get(0)).createSecondAssociation(n, iEntity, display);
        ((Association)object).createInSecond(linkType, display);
        this.assocations.add((Association)object);
        return true;
    }

    class Association {
        private IEntity entity1;
        private IEntity entity2;
        private IEntity associed;
        private IEntity point;
        private Link existingLink;
        private Link entity1ToPoint;
        private Link pointToEntity2;
        private Link pointToAssocied;
        private Association other;

        public Association(int n, IEntity iEntity, IEntity iEntity2, IEntity iEntity3) {
            this.entity1 = iEntity;
            this.entity2 = iEntity2;
            this.associed = iEntity3;
            this.point = AbstractClassOrObjectDiagram.this.getOrCreateLeaf(UniqueSequence.getCode("apoint"), LeafType.POINT_FOR_ASSOCIATION, null);
        }

        public Association createSecondAssociation(int n, IEntity iEntity, Display display) {
            Association association = new Association(n, this.entity1, this.entity2, iEntity);
            association.existingLink = this.existingLink;
            association.other = this;
            if (this.existingLink.getLength() == 1) {
                this.entity1ToPoint.setLength(2);
                this.pointToEntity2.setLength(2);
                this.pointToAssocied.setLength(1);
            }
            return association;
        }

        void createNew(int n, LinkType linkType, Display display) {
            this.existingLink = AbstractClassOrObjectDiagram.this.foundLink(this.entity1, this.entity2);
            if (this.existingLink == null) {
                this.existingLink = new Link(this.entity1, this.entity2, new LinkType(LinkDecor.NONE, LinkDecor.NONE), null, 2);
            } else {
                AbstractClassOrObjectDiagram.this.removeLink(this.existingLink);
            }
            this.entity1ToPoint = new Link(this.entity1, this.point, this.existingLink.getType().getPart2(), this.existingLink.getLabel(), this.existingLink.getLength(), this.existingLink.getQualifier1(), null, this.existingLink.getLabeldistance(), this.existingLink.getLabelangle());
            this.entity1ToPoint.setLinkArrow(this.existingLink.getLinkArrow());
            this.pointToEntity2 = new Link(this.point, this.entity2, this.existingLink.getType().getPart1(), null, this.existingLink.getLength(), null, this.existingLink.getQualifier2(), this.existingLink.getLabeldistance(), this.existingLink.getLabelangle());
            AbstractClassOrObjectDiagram.this.addLink(this.entity1ToPoint);
            AbstractClassOrObjectDiagram.this.addLink(this.pointToEntity2);
            int n2 = 1;
            if (this.existingLink.getLength() == 1 && this.entity1 != this.entity2) {
                n2 = 2;
            }
            if (this.existingLink.getLength() == 2 && this.entity1 == this.entity2) {
                n2 = 2;
            }
            this.pointToAssocied = n == 1 ? new Link(this.point, this.associed, linkType, display, n2) : new Link(this.associed, this.point, linkType, display, n2);
            AbstractClassOrObjectDiagram.this.addLink(this.pointToAssocied);
        }

        void createInSecond(LinkType linkType, Display display) {
            this.existingLink = AbstractClassOrObjectDiagram.this.foundLink(this.entity1, this.entity2);
            if (this.existingLink == null) {
                this.existingLink = new Link(this.entity1, this.entity2, new LinkType(LinkDecor.NONE, LinkDecor.NONE), null, 2);
            } else {
                AbstractClassOrObjectDiagram.this.removeLink(this.existingLink);
            }
            this.entity1ToPoint = new Link(this.entity1, this.point, this.existingLink.getType().getPart2(), this.existingLink.getLabel(), 2, this.existingLink.getQualifier1(), null, this.existingLink.getLabeldistance(), this.existingLink.getLabelangle());
            this.pointToEntity2 = new Link(this.point, this.entity2, this.existingLink.getType().getPart1(), null, 2, null, this.existingLink.getQualifier2(), this.existingLink.getLabeldistance(), this.existingLink.getLabelangle());
            AbstractClassOrObjectDiagram.this.addLink(this.entity1ToPoint);
            AbstractClassOrObjectDiagram.this.addLink(this.pointToEntity2);
            if (this.other.pointToAssocied.getEntity1().getEntityType() == LeafType.POINT_FOR_ASSOCIATION) {
                AbstractClassOrObjectDiagram.this.removeLink(this.other.pointToAssocied);
                this.other.pointToAssocied = this.other.pointToAssocied.getInv();
                AbstractClassOrObjectDiagram.this.addLink(this.other.pointToAssocied);
            }
            this.pointToAssocied = new Link(this.point, this.associed, linkType, display, 1);
            AbstractClassOrObjectDiagram.this.addLink(this.pointToAssocied);
            Link link = new Link(this.other.point, this.point, new LinkType(LinkDecor.NONE, LinkDecor.NONE), null, 1);
            link.setInvis(true);
            AbstractClassOrObjectDiagram.this.addLink(link);
        }

        boolean sameCouple(IEntity iEntity, IEntity iEntity2) {
            if (this.entity1 == iEntity && this.entity2 == iEntity2) {
                return true;
            }
            return this.entity1 == iEntity2 && this.entity2 == iEntity;
        }
    }
}

