/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Iterator;
import net.sourceforge.plantuml.svek.ClusterPosition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrontierCalculator {
    private static final double DELTA = 18.0;
    private ClusterPosition core;
    private final ClusterPosition initial;

    public FrontierCalculator(ClusterPosition clusterPosition, Collection<ClusterPosition> collection, Collection<Point2D> collection2) {
        boolean bl;
        this.initial = clusterPosition;
        for (ClusterPosition object : collection) {
            if (this.core == null) {
                this.core = object;
                continue;
            }
            this.core = this.core.merge(object);
        }
        if (this.core == null) {
            Iterator<Point2D> iterator = clusterPosition.getPointCenter();
            this.core = new ClusterPosition(((Point2D)((Object)iterator)).getX() - 1.0, ((Point2D)((Object)iterator)).getY() - 1.0, ((Point2D)((Object)iterator)).getX() + 1.0, ((Point2D)((Object)iterator)).getY() + 1.0);
        }
        for (Point2D point2D : collection2) {
            this.core = this.core.merge(point2D);
        }
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        for (Point2D point2D : collection2) {
            if (point2D.getX() == this.core.getMinX()) {
                bl2 = true;
            }
            if (point2D.getX() == this.core.getMaxX()) {
                bl = true;
            }
            if (point2D.getY() == this.core.getMinY()) {
                bl4 = true;
            }
            if (point2D.getY() != this.core.getMaxY()) continue;
            bl5 = true;
        }
        if (!bl2) {
            this.core = this.core.withMinX(clusterPosition.getMinX());
        }
        if (!bl) {
            this.core = this.core.withMaxX(clusterPosition.getMaxX());
        }
        if (!bl4) {
            this.core = this.core.withMinY(clusterPosition.getMinY());
        }
        if (!bl5) {
            this.core = this.core.withMaxY(clusterPosition.getMaxY());
        }
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        for (Point2D point2D : collection2) {
            if (point2D.getY() == this.core.getMinY() || point2D.getY() == this.core.getMaxY()) {
                if (Math.abs(point2D.getX() - this.core.getMaxX()) < 18.0) {
                    bl7 = true;
                }
                if (Math.abs(point2D.getX() - this.core.getMinX()) < 18.0) {
                    bl6 = true;
                }
            }
            if (point2D.getX() != this.core.getMinX() && point2D.getX() != this.core.getMaxX()) continue;
            if (Math.abs(point2D.getY() - this.core.getMaxY()) < 18.0) {
                bl9 = true;
            }
            if (!(Math.abs(point2D.getY() - this.core.getMinY()) < 18.0)) continue;
            bl8 = true;
        }
        for (Point2D point2D : collection2) {
            if (point2D.getY() == this.core.getMinY() && (point2D.getX() == this.core.getMinX() || point2D.getX() == this.core.getMaxX())) {
                bl8 = false;
            }
            if (point2D.getY() != this.core.getMaxY() || point2D.getX() != this.core.getMinX() && point2D.getX() != this.core.getMaxX()) continue;
            bl9 = false;
        }
        if (bl7) {
            this.core = this.core.addMaxX(18.0);
        }
        if (bl6) {
            this.core = this.core.addMinX(-18.0);
        }
        if (bl9) {
            this.core = this.core.addMaxY(18.0);
        }
        if (bl8) {
            this.core = this.core.addMinY(-18.0);
        }
    }

    public ClusterPosition getSuggestedPosition() {
        return this.core;
    }

    public void ensureMinWidth(double d) {
        double d2 = this.core.getMaxX() - this.core.getMinX() - d;
        if (d2 < 0.0) {
            double d3 = this.core.getMinX() + d2 / 2.0;
            double d4 = this.core.getMaxX() - d2 / 2.0;
            double d5 = d3 - this.initial.getMinX();
            if (d5 < 0.0) {
                d3 -= d5;
                d4 -= d5;
            }
            this.core = this.core.withMinX(d3);
            this.core = this.core.withMaxX(d4);
        }
    }
}

