/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineConfigurable;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Member;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class EntityImageState
extends AbstractEntityImage {
    private final TextBlock desc;
    private final TextBlock fields;
    private final Url url;
    private static final int MIN_WIDTH = 50;
    private static final int MIN_HEIGHT = 50;
    private final boolean withSymbol;
    private static final double smallRadius = 3.0;
    private static final double smallLine = 3.0;
    private static final double smallMarginX = 7.0;
    private static final double smallMarginY = 4.0;
    private final LineConfigurable lineConfig;

    public EntityImageState(IEntity iEntity, ISkinParam iSkinParam) {
        super(iEntity, iSkinParam);
        this.lineConfig = iEntity;
        Stereotype stereotype = iEntity.getStereotype();
        this.withSymbol = stereotype != null && stereotype.isWithOOSymbol();
        this.desc = TextBlockUtils.create(iEntity.getDisplay(), new FontConfiguration(SkinParamUtils.getFont(this.getSkinParam(), FontParam.STATE, stereotype), SkinParamUtils.getFontColor(this.getSkinParam(), FontParam.STATE, stereotype)), HorizontalAlignment.CENTER, iSkinParam);
        Display display = Display.empty();
        for (Member member : iEntity.getFieldsToDisplay()) {
            display = display.addAll(Display.getWithNewlines(member.getDisplay(true)));
        }
        this.url = iEntity.getUrl99();
        this.fields = TextBlockUtils.create(display, new FontConfiguration(SkinParamUtils.getFont(this.getSkinParam(), FontParam.STATE_ATTRIBUTE, stereotype), SkinParamUtils.getFontColor(this.getSkinParam(), FontParam.STATE_ATTRIBUTE, stereotype)), HorizontalAlignment.LEFT, iSkinParam);
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = Dimension2DDouble.mergeTB(this.desc.calculateDimension(stringBounder), this.fields.calculateDimension(stringBounder));
        double d = 0.0;
        if (this.withSymbol) {
            d += 10.0;
        }
        Dimension2D dimension2D2 = Dimension2DDouble.delta(dimension2D, 20.0 + d);
        return Dimension2DDouble.atLeast(dimension2D2, 50.0, 50.0);
    }

    public final void drawU(UGraphic uGraphic) {
        double d;
        HtmlColor htmlColor;
        if (this.url != null) {
            uGraphic.startUrl(this.url);
        }
        StringBounder stringBounder = uGraphic.getStringBounder();
        Dimension2D dimension2D = this.calculateDimension(stringBounder);
        Dimension2D dimension2D2 = this.desc.calculateDimension(stringBounder);
        double d2 = dimension2D.getWidth();
        double d3 = dimension2D.getHeight();
        URectangle uRectangle = new URectangle(d2, d3, 25.0, 25.0);
        if (this.getSkinParam().shadowing()) {
            uRectangle.setDeltaShadow(4.0);
        }
        if ((htmlColor = this.lineConfig.getSpecificLineColor()) == null) {
            htmlColor = SkinParamUtils.getColor(this.getSkinParam(), ColorParam.stateBorder, this.getStereo());
        }
        uGraphic = uGraphic.apply(this.getStroke()).apply(new UChangeColor(htmlColor));
        HtmlColor htmlColor2 = this.getEntity().getSpecificBackColor();
        if (htmlColor2 == null) {
            htmlColor2 = SkinParamUtils.getColor(this.getSkinParam(), ColorParam.stateBackground, this.getStereo());
        }
        uGraphic = uGraphic.apply(new UChangeBackColor(htmlColor2));
        uGraphic.draw(uRectangle);
        double d4 = 5.0 + dimension2D2.getHeight() + 5.0;
        uGraphic.apply(new UTranslate(0.0, d4)).draw(new ULine(d2, 0.0));
        uGraphic = uGraphic.apply(new UStroke());
        if (this.withSymbol) {
            d = dimension2D.getWidth();
            double d5 = dimension2D.getHeight();
            EntityImageState.drawSymbol(uGraphic, d, d5);
        }
        d = (d2 - dimension2D2.getWidth()) / 2.0;
        this.desc.drawU(uGraphic.apply(new UTranslate(d, 5.0)));
        double d6 = d4 + 5.0;
        this.fields.drawU(uGraphic.apply(new UTranslate(5.0, d6)));
        if (this.url != null) {
            uGraphic.closeAction();
        }
    }

    private UStroke getStroke() {
        UStroke uStroke = this.lineConfig.getSpecificLineStroke();
        if (uStroke == null) {
            uStroke = new UStroke(1.5);
        }
        return uStroke;
    }

    public static void drawSymbol(UGraphic uGraphic, double d, double d2) {
        UEllipse uEllipse = new UEllipse(6.0, 6.0);
        uGraphic.apply(new UTranslate(d -= 22.0, d2 -= 10.0)).draw(uEllipse);
        uGraphic.apply(new UTranslate(d + 3.0 + 6.0, d2)).draw(uEllipse);
        uGraphic.apply(new UTranslate(d + 6.0, d2 + 3.0)).draw(new ULine(3.0, 0.0));
    }

    public ShapeType getShapeType() {
        return ShapeType.ROUND_RECTANGLE;
    }

    public int getShield() {
        return 0;
    }
}

