#!/usr/bin/perl

package eBay::API::XML::DataType::SpellingSuggestionType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. SpellingSuggestionType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::SpellingSuggestionType

=head1 DESCRIPTION

Suggested spelling of mispelled search terms, along with the number of matching items that would have been returned if the suggestions had been used.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::SpellingSuggestionType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");



my @gaProperties = ( [ 'MatchingItemCount', 'xs:int', '', '', '' ]
	, [ 'Text', 'xs:string', '1', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setMatchingItemCount()

The number of matching items if the suggested spelling of the search term or terms had 
been used. If multiple terms are used, MatchingItemCount applies to the terms taken as a unit.

#    Argument: 'xs:int'

=cut

sub setMatchingItemCount {
  my $self = shift;
  $self->{'MatchingItemCount'} = shift
}

=head2 getMatchingItemCount()

  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ItemReturnCategories, none, ReturnAll

#    Returns: 'xs:int'

=cut

sub getMatchingItemCount {
  my $self = shift;
  return $self->{'MatchingItemCount'};
}


=head2 setText()

Suggestion for a different spelling of the search term or terms. The suggestions are given in Text tags
and the suggestion for the first word is given before the suggestion for subsequent words.
Suggestions are based on correctly-spelled terms in items, so suggestions vary over time and depend on 
whether a word or word combination is in one or more items.

#    Argument: reference to an array  
                      of 'xs:string'

=cut

sub setText {
  my $self = shift;
  $self->{'Text'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getText()

  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ItemReturnCategories, none, ReturnAll

#    Returns: reference to an array  
                      of 'xs:string'

=cut

sub getText {
  my $self = shift;
  return $self->_getDataTypeArray('Text');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
