#!/bin/bash
#
###############################################################
#
# This will build the CD iso image in /tmp
# 
# it will execute:
# - ./customize-livecd.sh
# - ./runme.sh
# - ./restore-system.sh
#
# Urs Beyerle, PSI
#
###############################################################

function usage() {

   ## Usage
   # ----------------------------------------------------------

   cat <<EOF

   Options:

    -h:         print this screen
    -sl:        customize for CentOS Live CD
    -mini:      build a MINI-CD ROM
    
    Additionally Options for MINI-CD:

    -nomove:    do NOT move to /mini to save diskspace 
    -rootlogin: directly login as root


EOF

}

### read options from command-line
PSI=""
while [ $# -gt 0 ]; do

    case "$1" in
       -h)
            usage; exit;;
       -psi)
            PSI="-psi"; shift; continue;;
       -sl)
            SL="-sl"; shift; continue;;
       -mini)
            MINI="-mini"; shift; continue;;
       -nomove)
            NOMOVE="-nomove"; shift; continue;;
       -rootlogin)
            ROOTLOGIN="-rootlogin"; shift; continue;;
       *)
            usage; exit;;
    esac

done

### only build for SL or SPI
if [ ! $PSI ] && [ ! $SL ]; then
    usage 
    exit
fi

### definitions
BOOT_OTPIONS="max_loop=32 vga=791 initrd=boot/initrd.gz init=linuxrc load_ramdisk=1 prompt_ramdisk=0 ramdisk_size=40000 root=/dev/ram0 rw"

[ $PSI ] && BOOT_OTPIONS="psi $BOOT_OTPIONS"

ARCH=$( /bin/arch )
[ "$ARCH" != "x86_64" ] && ARCH=i686


### check if I run inside my directory
if [ ! -x $( basename $0 ) ]; then
    echo "Please run $( basename $0 ) within its directory"
    exit 1
fi

### write my version to /etc/livecd-release
my_pwd=$( pwd )
my_version=${my_pwd##*/}
echo $my_version > /etc/livecd-release

### start

echo
echo "--------------------------------------------"
echo "Build of LiveCD started"
echo "($my_version)"
echo "--------------------------------------------"

if [ $PSI ]; then
    echo "**** Build for PSI ****"
    echo "--------------------------------------------"
fi

if [ $SL ]; then
    echo "**** Build for CentOS ****"
    echo "--------------------------------------------"
fi

if [ $MINI ]; then
    echo "**** Build for MINI-CD ****"
    echo "--------------------------------------------"
fi

# clean up build script directory
echo "remove all *~ files in $( pwd )" 
find . | grep "~$" | while read f; do rm -f "$f"; done

echo
echo "--------------------------------------------"
echo "run customize-livecd.sh $PSI"
echo "--------------------------------------------"
./customize-livecd.sh $PSI


if [ $MINI ]; then
    echo "--------------------------------------------"
    echo "Run ./mini_livecd.sh $PSI $ROOTLOGIN $NOMOVE"
    echo "--------------------------------------------"
    ./mini_livecd.sh $PSI $ROOTLOGIN $NOMOVE
fi


echo
echo "--------------------------------------------"
echo "cd linux-live.sl4"
echo "--------------------------------------------"
cd linux-live.sl4
echo "Set kernel boot options in cd-root/isolinux.cfg"
sed -i "s|append .*|append $BOOT_OTPIONS|" cd-root/isolinux.cfg

echo "Set 'Welcome ... to' in splash.cfg"
if [ $PSI ]; then
    sed -i "s|Welcome to.*CentOS4 LiveCD|Welcome to PSI SL4 LiveCD|" cd-root/boot/splash.cfg
else
    sed -i "s|Welcome to.*CentOS4 LiveCD|Welcome to SL4 LiveCD|" cd-root/boot/splash.cfg
fi

if [ "$ARCH" = "x86_64" ]; then
    sed -i "s|LiveCD.*|LiveCD 64bit|" cd-root/boot/splash.cfg
else
    sed -i "s|LiveCD.*|LiveCD |" cd-root/boot/splash.cfg
fi

echo
echo "--------------------------------------------"
echo "Execute ./runme.sh"
echo "--------------------------------------------"
./runme.sh

echo
echo "--------------------------------------------"
echo "Now fix things again to make this system bootable"
echo "--------------------------------------------"
cd ..
./restore-system.sh


echo "--------------------------------------------"
echo "End of Build LiveCD" 
echo "See /tmp for the ISO image"
echo "--------------------------------------------"
