/*
* Copyright (c) 2024-2026, Intel Corporation
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
* THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
* OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*/
//!
//! \file     nvlMediaKernel_av1brc_init.h
//! \brief    File holds the Firmware for the media kernels for HuC
//! \details  File holds the Firmware for the media kernels for HuC which is 
//!           a programmable Microcontroller added to the VDBox pipeline.
//!

/* Media Kernel Version - 20251205 */

#pragma once


/*==========================================================================================================================================================
Kernel begins from here. Do not remove this comment.
==========================================================================================================================================================*/

const uint32_t __MediaKernels_av1brc_init_nvl [] = 
{
    0x00002000, 0x000000c0, 0x00002a80, 0x00000040,
    0x00002400, 0x000020c0, 0x00002440, 0x00000940,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x672efcfa, 0x15010f66, 0x00002ac0, 0x66c0200f,
    0x6601c883, 0xffffff25, 0xc0220f9f, 0x00b800eb,
    0xb8c08e00, 0xe88e0028, 0x8e0010b8, 0x0018b8d8,
    0x20b8d08e, 0x66e08e00, 0x000080ea, 0x90000800,
    0x2ad0002f, 0x2e660000, 0x00841f0f, 0x00000000,
    0x00000000, 0x00000000, 0x2a802400, 0x00409b00,
    0x000029fd, 0x00409300, 0x00002000, 0x00409300,
    0x0000ffdf, 0x00cf9302, 0x2a802400, 0x00409300,
    0x001ffcbc, 0x0af6e800, 0xb8660000, 0xebf4dead,
    0xccccf4fd, 0x006afacf, 0x2ae9006a, 0xfa000001,
    0x016a006a, 0x000120e9, 0x006afa00, 0x16e9026a,
    0xfa000001, 0x036a006a, 0x00010ce9, 0x006afa00,
    0x02e9046a, 0xfa000001, 0x056a006a, 0x0000f8e9,
    0x006afa00, 0xeee9066a, 0xfa000000, 0x076a006a,
    0x0000e4e9, 0x086afa00, 0x0000dce9, 0x006afa00,
    0xd2e9096a, 0xfa000000, 0xcae90a6a, 0xfa000000,
    0xc2e90b6a, 0xfa000000, 0xbae90c6a, 0xfa000000,
    0xb2e90d6a, 0xfa000000, 0xaae90e6a, 0xfa000000,
    0x0f6a006a, 0x0000a0e9, 0x006afa00, 0x96e9106a,
    0xfa000000, 0x8ee9116a, 0xfa000000, 0x126a006a,
    0x000084e9, 0x006afa00, 0x7deb136a, 0x6a006afa,
    0xfa76eb14, 0x156a006a, 0x6afa6feb, 0xeb166a00,
    0x006afa68, 0x61eb176a, 0x6a006afa, 0xfa5aeb18,
    0x196a006a, 0x6afa53eb, 0xeb1a6a00, 0x006afa4c,
    0x45eb1b6a, 0x6a006afa, 0xfa3eeb1c, 0x1d6a006a,
    0x6afa37eb, 0xeb1e6a00, 0x006afa30, 0x29eb1f6a,
    0xd06860fa, 0xe8000000, 0x00000074, 0x6104c483,
    0x6a60facf, 0x0956e84c, 0xc4830000, 0xfacf6104,
    0xff68006a, 0xeb000000, 0x31e8600b, 0x61000000,
    0xcf08c483, 0x0056e860, 0x83610000, 0xcccf08c4,
    0x83e58955, 0xc76608ec, 0x07fff845, 0xc0fa45c7,
    0x0f000020, 0x83f85d01, 0xc35d08c4, 0xcccccccc,
    0x83e58955, 0x458b08ec, 0x084d8d28, 0xff240c89,
    0x28c08514, 0xc4830000, 0x90c35d08, 0x90909090,
    0x5de58955, 0x909090c3, 0x90909090, 0x90909090,
    0x5de58955, 0xccccccc3, 0xcccccccc, 0xcccccccc,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0xccccccc3, 0xcccccccc,
    0xb0e58955, 0xe6a1e6ff, 0x90c35d21, 0x90909090,
    0xb8e58955, 0x00020000, 0xe00380b9, 0x64c129fe,
    0xffff01c7, 0xe0b900ff, 0x29fee003, 0x01c764c1,
    0x00000001, 0xe00320b9, 0x64c129fe, 0x00d001c7,
    0xc35d0002, 0x90909090, 0x90909090, 0x90909090,
    0xb0e58955, 0xe6a1e6ff, 0x0000b821, 0x30b90002,
    0x29fee000, 0x098b64c1, 0xe000f0b9, 0x64c129fe,
    0x01ff01c7, 0xe0b90000, 0x29fee000, 0x01c764c1,
    0xffffffff, 0xe00080b9, 0x64c129fe, 0x000001c7,
    0x80b90000, 0x29fee003, 0x01c764c1, 0x00ffffff,
    0xe003e0b9, 0x64c129fe, 0x000101c7, 0x20b90000,
    0x29fee003, 0x01c764c1, 0x000200d0, 0xccccc35d,
    0x53e58955, 0x4d8b5657, 0x08458b10, 0x890c558b,
    0x03e783c7, 0x04be4574, 0x29000000, 0x89ce39fe,
    0x890277cf, 0x89f929f7, 0x74ff85c6, 0x90909009,
    0x4f461688, 0xcf89fa75, 0x7502efc1, 0x03e18327,
    0x0010840f, 0x90900000, 0x90909090, 0x90909090,
    0x49461688, 0x5f5efa75, 0x89c35d5b, 0xc1cf89c6,
    0xd97402ef, 0xc1c2b60f, 0xc38918e2, 0x0908e3c1,
    0xc1da09c2, 0xd00910e0, 0x90909090, 0x90909090,
    0xc6830689, 0xf8754f04, 0x8b08458b, 0xe1830c55,
    0xebbd7503, 0x909090c1, 0x90909090, 0x90909090,
    0x53e58955, 0x4d8b5657, 0x0c558b10, 0x8908458b,
    0x03e683d6, 0xe783c789, 0x75fe3903, 0x74f68559,
    0x0004bb6e, 0xf3290000, 0xcf89cb39, 0xdf890277,
    0xc689f929, 0x840fff85, 0x0000000e, 0x90909090,
    0x881ab60f, 0x4f42461e, 0xcf89f675, 0x0f02efc1,
    0x00001884, 0x90909000, 0x90909090, 0x90909090,
    0x1e891a8b, 0x8304c683, 0x754f04c2, 0x03e183f3,
    0x0c75c985, 0xc68914eb, 0x840fc985, 0x0000000a,
    0x881ab60f, 0x4942461e, 0x5f5ef675, 0x89c35d5b,
    0xc1cf89c6, 0xc87502ef, 0x9090d3eb, 0x90909090,
    0x53e58955, 0x4d8b5657, 0x0c558b10, 0x3908458b,
    0x8d7d76d0, 0xd6390834, 0xca017676, 0xe783d789,
    0x83f08903, 0xc73903e0, 0xff854875, 0xcf391e74,
    0x0277c889, 0xc129f889, 0x840fc085, 0x0000000c,
    0xff5ab60f, 0x4eff5e88, 0xf475484a, 0xe8c1c889,
    0x18840f02, 0x90000000, 0x90909090, 0x90909090,
    0x89fc7a8b, 0xc683fc7e, 0xfcc283fc, 0x83f17548,
    0xc98503e1, 0x0012840f, 0x90900000, 0x90909090,
    0xff42b60f, 0x4eff4688, 0xf475494a, 0x7aebf089,
    0xe683d689, 0x83c78903, 0xfe3903e7, 0xf6855875,
    0x04bb6d74, 0x29000000, 0x89cb39f3, 0x890277cf,
    0x89f929df, 0x0fff85c6, 0x00000d84, 0x90909000,
    0x881ab60f, 0x4f42461e, 0xcf89f675, 0x0f02efc1,
    0x00001884, 0x90909000, 0x90909090, 0x90909090,
    0x1e891a8b, 0x8304c683, 0x754f04c2, 0x03e183f3,
    0x0c75c985, 0xc68914eb, 0x840fc985, 0x0000000a,
    0x881ab60f, 0x4942461e, 0x5f5ef675, 0x89c35d5b,
    0xc1cf89c6, 0xc87502ef, 0x9090d3eb, 0x90909090,
    0x53e58955, 0x8b505657, 0xc985084d, 0x000002b8,
    0xdf840f00, 0x8b000000, 0xf6850c75, 0x00d4880f,
    0x558b0000, 0x76f23914, 0x83ca8960, 0x277403e2,
    0x000004bf, 0x39d72900, 0x77f289f7, 0x29fa8902,
    0x0fd285d6, 0x00000e84, 0x90909000, 0x90909090,
    0x410001c6, 0x89f9754a, 0x02eac1f2, 0x90900e74,
    0x000001c7, 0xc1830000, 0xf4754a04, 0x0f03e683,
    0x00008184, 0x90909000, 0x90909090, 0x90909090,
    0x410001c6, 0xebf9754e, 0x105d8b6d, 0xe083c889,
    0xbe237403, 0x00000004, 0xd639c629, 0x0277d089,
    0xc229f089, 0x840fc085, 0x0000000a, 0x90909090,
    0x48411988, 0xd089fa75, 0x0f02e8c1, 0x00002784,
    0xf3b60f00, 0xe7c1df89, 0xf0758918, 0x08f065c1,
    0x7d03f709, 0x10e6c1f0, 0x9090fe09, 0x90909090,
    0xc1833189, 0xf8754804, 0xe283c031, 0x90077403,
    0x4a411988, 0xc483fa75, 0x5b5f5e04, 0x9090c35d,
    0x53e58955, 0x4d8b5657, 0xb8c98508, 0x00000002,
    0x00f1840f, 0x7d8b0000, 0x0fff850c, 0x0000e688,
    0x10758b00, 0x840ff685, 0x00000080, 0x3914558b,
    0x897977fa, 0x03e083f0, 0xe783cf89, 0x75f83903,
    0x74c0854f, 0x0004bf25, 0xc7290000, 0xd089d739,
    0xf8890277, 0xc085c229, 0x000c840f, 0x90900000,
    0x881eb60f, 0x48464119, 0xd089f675, 0x0f02e8c1,
    0x00001884, 0x90909000, 0x90909090, 0x90909090,
    0x39893e8b, 0x8304c183, 0x754804c6, 0x03e283f3,
    0xd285c031, 0x006d840f, 0x90900000, 0x90909090,
    0x881eb60f, 0x4a464119, 0x5bebf675, 0xe283ca89,
    0xbe247403, 0x00000004, 0xfe39d629, 0x0277fa89,
    0xd729f289, 0x840fd285, 0x0000000b, 0x90909090,
    0x410001c6, 0x89f9754a, 0x02eac1fa, 0x90900e74,
    0x000001c7, 0xc1830000, 0xf4754a04, 0x0f03e783,
    0x00001284, 0x90909000, 0x90909090, 0x90909090,
    0x410001c6, 0x5ef9754f, 0xc35d5b5f, 0x90909090,
    0x57e58955, 0x08558b56, 0x02b8d285, 0x0f000000,
    0x00008284, 0x0c4d8b00, 0x7b78c985, 0x8510758b,
    0x8b1974f6, 0xcf39147d, 0xec831277, 0x52565704,
    0xfffc9be8, 0x10c483ff, 0x5bebc031, 0xe683d689,
    0xbf247403, 0x00000004, 0xcf39f729, 0x0277ce89,
    0xf129fe89, 0x840ff685, 0x0000000b, 0x90909090,
    0x420002c6, 0x89f9754e, 0x02eec1ce, 0x90900e74,
    0x000002c7, 0xc2830000, 0xf4754e04, 0x0f03e183,
    0x00001284, 0x90909000, 0x90909090, 0x90909090,
    0x420002c6, 0x5ef97549, 0xccc35d5f, 0xcccccccc,
    0xb8e58955, 0x00020000, 0x100100b9, 0x64c129ff,
    0x000101c7, 0x00b90000, 0x29ff1000, 0x0004bac1,
    0xc229ff10, 0x0002c764, 0x64000200, 0x100001c7,
    0x0cb90002, 0x29ff1000, 0x01c764c1, 0x00000000,
    0x100008b9, 0x64c129ff, 0x000001c7, 0x14b90000,
    0x29ff1000, 0x01c764c1, 0x00000000, 0x100010b9,
    0x64c129ff, 0x000001c7, 0x1cb90000, 0x29ff1000,
    0x01c764c1, 0x00000000, 0x100018b9, 0x64c129ff,
    0x000001c7, 0x24b90000, 0x29ff1000, 0x01c764c1,
    0x00000000, 0x100020b9, 0x64c129ff, 0x000001c7,
    0x2cb90000, 0x29ff1000, 0x01c764c1, 0x00000000,
    0x100028b9, 0x64c129ff, 0x000001c7, 0x34b90000,
    0x29ff1000, 0x01c764c1, 0x00000000, 0x100030b9,
    0x64c129ff, 0x000001c7, 0x3cb90000, 0x29ff1000,
    0x01c764c1, 0x00000000, 0x100038b9, 0x64c129ff,
    0x000001c7, 0x44b90000, 0x29ff1000, 0x01c764c1,
    0x00000000, 0x100040b9, 0x64c129ff, 0x000001c7,
    0x4cb90000, 0x29ff1000, 0x01c764c1, 0x00000000,
    0x100048b9, 0x64c129ff, 0x000001c7, 0x54b90000,
    0x29ff1000, 0x01c764c1, 0x00000000, 0x100050b9,
    0x64c129ff, 0x000001c7, 0x5cb90000, 0x29ff1000,
    0x01c764c1, 0x00000000, 0x100058b9, 0x64c129ff,
    0x000001c7, 0x64b90000, 0x29ff1000, 0x01c764c1,
    0x00000000, 0x100060b9, 0x64c129ff, 0x000001c7,
    0x6cb90000, 0x29ff1000, 0x01c764c1, 0x00000000,
    0x100068b9, 0x64c129ff, 0x000001c7, 0x74b90000,
    0x29ff1000, 0x01c764c1, 0x00000000, 0x100070b9,
    0x64c129ff, 0x000001c7, 0x7cb90000, 0x29ff1000,
    0x01c764c1, 0x00000000, 0x100078b9, 0x64c129ff,
    0x000001c7, 0xc35d0000, 0x90909090, 0x90909090,
    0x56e58955, 0x2000a150, 0xf8830000, 0x850b7402,
    0xe80c75c0, 0x00000138, 0x91e805eb, 0x8d000000,
    0x046af875, 0x6a006a56, 0x1072e800, 0xc4830000,
    0x56046a10, 0x006a006a, 0x001103e8, 0x10c48300,
    0x6a56046a, 0xe8006a00, 0x00001054, 0xb810c483,
    0x00020000, 0xe000b0b9, 0x64c129fe, 0x000001c7,
    0xc4830000, 0xc35d5e04, 0x90909090, 0x90909090,
    0x83e58955, 0x55e808ec, 0xe8fffff6, 0xfffffda0,
    0xfff81be8, 0x0000b8ff, 0xb8b90002, 0x29ffe0d3,
    0x01c764c1, 0x0000004c, 0x90909090, 0x90909090,
    0xfcebf4fb, 0xcccccccc, 0xcccccccc, 0xcccccccc,
    0x56e58955, 0x81c0e483, 0x0005c0ec, 0x12bee800,
    0x748d0000, 0x40684024, 0x56000005, 0x006a006a,
    0x000fcbe8, 0x10c48300, 0x4575c085, 0x382444c7,
    0x00002000, 0x8d08ec83, 0x50402444, 0x015ee856,
    0xc4830000, 0x05406810, 0x6a560000, 0xe8006a00,
    0x0000103c, 0x8510c483, 0x832875c0, 0x00680cec,
    0xe8100000, 0x00001248, 0x8d10c483, 0x5d5efc65,
    0x0cec83c3, 0x00000068, 0x1232e804, 0xc4830000,
    0x83a9eb10, 0x00680cec, 0xe8040000, 0x00001220,
    0xeb10c483, 0x909090c6, 0x90909090, 0x90909090,
    0x56e58955, 0x81c0e483, 0x0005c0ec, 0x121ee800,
    0x44c70000, 0x20003824, 0xec830000, 0x24448d08,
    0x24748d40, 0xe8565048, 0x00000aa4, 0x6810c483,
    0x00000540, 0x6a006a56, 0x0fb2e800, 0xc4830000,
    0x75c08510, 0x0cec8316, 0x00000068, 0x11bee810,
    0xc4830000, 0xfc658d10, 0x83c35d5e, 0x00680cec,
    0xe8040000, 0x000011a8, 0xeb10c483, 0xccccccd8,
    0x56e58955, 0x8b08458b, 0x1c798308, 0x31167400,
    0x207983c0, 0x0f0e7400, 0x815251b7, 0x0000fffa,
    0xeb217600, 0x1c41c73c, 0x0000001e, 0x012041c7,
    0xb8000000, 0x00000001, 0x5251b70f, 0x00fffa81,
    0x1d770000, 0x5071b70f, 0x00fffe81, 0x11770000,
    0x77d63966, 0x97b9800c, 0x11000000, 0x5d5e1873,
    0x5041c7c3, 0x00ff0000, 0x000001b8, 0x97b98000,
    0x11000000, 0x81c6e872, 0x00000097, 0x0001b810,
    0x5d5e0000, 0x909090c3, 0x90909090, 0x90909090,
    0x8be58955, 0x558b084d, 0x04eb5d0c, 0x90909090,
    0x53e58955, 0xec835657, 0x89ce895c, 0x1a8bbc55,
    0x851c538b, 0x8b1a74d2, 0x01b0204b, 0x1174c985,
    0x0ff04d89, 0x81527bb7, 0x0000ffff, 0xeb2b7600,
    0x1c43c752, 0x0000001e, 0x012043c7, 0xba000000,
    0x0000001e, 0x000001b9, 0x89c03100, 0xb70ff04d,
    0xff81527b, 0x000000ff, 0xb70f2977, 0xf981504b,
    0x000000ff, 0x39661d77, 0x801877f9, 0x000097bb,
    0x1f771000, 0x7d89c084, 0xd84d89e4, 0x75f07d8b,
    0xc719eb44, 0x00005043, 0xbb8000ff, 0x00000097,
    0x81097211, 0x000097c3, 0x1003c600, 0x680cec83,
    0x01000000, 0x001057e8, 0x10c48300, 0x8bbc458b,
    0x1c538b18, 0x0f207b8b, 0x895043b7, 0xb70fd845,
    0x45895243, 0x10468be4, 0x8bcc4589, 0x06890443,
    0x8908438b, 0x4689e045, 0x0c438b04, 0x89d04589,
    0x4b8b0846, 0xdc4d8910, 0x8b0c4e89, 0x45891443,
    0x104689e8, 0x89184b8b, 0x5589144e, 0x185689c8,
    0x89f07d89, 0xb70f1c7e, 0x8966444b, 0x0003e48e,
    0x43b70f00, 0xa0458948, 0xe6868966, 0x0f000003,
    0x894a43b7, 0x8966a445, 0x0003e886, 0x43b70f00,
    0xb045894c, 0xea868966, 0x0f000003, 0x894e43b7,
    0x8966d445, 0x0003ec86, 0xd8458b00, 0xee868966,
    0x8b000003, 0x8966e445, 0x0003f086, 0x53b70f00,
    0xb4558954, 0xf2968966, 0x0f000003, 0x895a43b7,
    0x8966c045, 0x00041686, 0x43b70f00, 0xa845895c,
    0x22868966, 0x0f000004, 0x895e43b7, 0x8966ac45,
    0x00042486, 0x53b70f00, 0x96896662, 0x00000426,
    0x8910c1f6, 0x0f75ec75, 0x7520c1f6, 0x40c1f617,
    0x0cc0940f, 0x3102eb02, 0xe04589c0, 0x04468688,
    0x49eb0000, 0x89e0458b, 0x05e9c1c1, 0x86c6c101,
    0x00000446, 0x044e8901, 0x89d04d8b, 0x05e8c1c8,
    0x4d89c101, 0x084e89d0, 0x89dc4d8b, 0x05e8c1c8,
    0x4d89c101, 0x0c4e89dc, 0x89e84d8b, 0x05e8c1c8,
    0x4d89c101, 0x104e89e8, 0x458901b0, 0xf04d8be0,
    0xf7dc458b, 0xc87d8be1, 0xeed1fe89, 0xd283f001,
    0x74ff8500, 0x57006a36, 0x95e85052, 0x83000013,
    0x458910c4, 0xc445c7b8, 0x00000000, 0xf7e8458b,
    0xf001f065, 0x6a00d283, 0x50525700, 0x001373e8,
    0x10c48300, 0x458bc189, 0xc710ebb8, 0x0000c445,
    0x4d8b0000, 0x4daf0fe8, 0x8bf101f0, 0xaf0fd455,
    0xeac1b055, 0x8bc78908, 0x0e74ec75, 0x4d89f889,
    0x31d189d4, 0x8bf1f7d2, 0x1ebad44d, 0x83000000,
    0x1e770af8, 0x000016ba, 0x08f88300, 0x10ba1477,
    0x83000000, 0x0a7706f8, 0x000008ba, 0x05f88300,
    0x96890672, 0x000003b0, 0xbe89f889, 0x000001b4,
    0x89207e89, 0xbe89244e, 0x00000164, 0x85f04d8b,
    0xb6840fc9, 0x8b000000, 0xd231c845, 0x4d8bf1f7,
    0x1ff883cc, 0x1eb8057c, 0x0f000000, 0x00a993b6,
    0xc9850000, 0xd1891475, 0xf980c9fe, 0xcc4d8b77,
    0x83880876, 0x000000a9, 0xaf0fc289, 0x89c985fa,
    0x0001c0be, 0xa4968900, 0x89000003, 0xa88b8ac8,
    0x88000000, 0x0004898e, 0x89767400, 0xc04d8bc3,
    0x0f9cc183, 0x1fb9f9af, 0x8951eb85, 0xc1e1f7f8,
    0x968905ea, 0x000001b8, 0x8b284e8b, 0xaf0fc475,
    0xe8458bf1, 0xd989e1f7, 0xc101e9d1, 0x458bf211,
    0x34708bec, 0x5253006a, 0x1256e851, 0xc4830000,
    0xec4d8b10, 0x29284189, 0xec458bc6, 0x8b307089,
    0x6371ec75, 0x294005c6, 0xeb010000, 0xc8458b5a,
    0x83cc4d8b, 0x8d0f1ff8, 0xffffff4a, 0xffff4ae9,
    0xbc86c7ff, 0x00000001, 0x85000000, 0x198e0fd2,
    0x8d000000, 0x0001c48e, 0x90909000, 0x90909090,
    0x000001c7, 0xc1830000, 0xf4754a04, 0x83c04d8b,
    0xaf0f9cc1, 0x851fb9f9, 0xf88951eb, 0xeac1e1f7,
    0xb8968905, 0x8b000001, 0x4503a045, 0xa84503a4,
    0x8dac4d8b, 0x3d010144, 0x0000ffff, 0x8bbc7d8b,
    0x0572e455, 0x00ffffb8, 0x86896600, 0x000003f4,
    0x03e07d80, 0x458b1a75, 0xf88366b4, 0x85870f04,
    0x89000005, 0xf2b70fc3, 0xd189f039, 0x1beb1b76,
    0xb60f0f8b, 0x00009599, 0x81b60f00, 0x00000094,
    0x39f2b70f, 0x77d189f0, 0x0fc18902, 0x39d855b7,
    0x89097ff3, 0x89d889c6, 0xf089e445, 0x458bd039,
    0x8bc588d8, 0x0272ec75, 0xd339cd88, 0x0443ae88,
    0x057c0000, 0x89e45d8b, 0x458688d8, 0x88000004,
    0x00043dae, 0x3f868800, 0x66000004, 0x042086c7,
    0x00200000, 0xbe0f3f8b, 0xc1897847, 0x8b1ff9c1,
    0xaf0fdc5d, 0x83e3f7cb, 0xca1132c0, 0x646a006a,
    0x0de85052, 0x83000010, 0x868910c4, 0x0000010c,
    0x7047be0f, 0xf9c1c189, 0xcbaf0f1f, 0xc083e3f7,
    0x6aca1132, 0x52646a00, 0x0fe6e850, 0xc4830000,
    0xec868910, 0x0f000000, 0x897947be, 0x1ff9c1c1,
    0xf7cbaf0f, 0x32c083e3, 0x006aca11, 0x5052646a,
    0x000fbfe8, 0x10c48300, 0x01108689, 0xbe0f0000,
    0xc1897147, 0x0f1ff9c1, 0xe3f7cbaf, 0x1132c083,
    0x6a006aca, 0xe8505264, 0x00000f98, 0x8910c483,
    0x0000f086, 0x47be0f00, 0xc1c1897a, 0xaf0f1ff9,
    0x83e3f7cb, 0xca1132c0, 0x646a006a, 0x71e85052,
    0x8300000f, 0x868910c4, 0x00000114, 0x7247be0f,
    0xf9c1c189, 0xcbaf0f1f, 0xc083e3f7, 0x6aca1132,
    0x52646a00, 0x0f4ae850, 0xc4830000, 0xf4868910,
    0x0f000000, 0x897b47be, 0x1ff9c1c1, 0xf7cbaf0f,
    0x32c083e3, 0x006aca11, 0x5052646a, 0x000f23e8,
    0x10c48300, 0x01188689, 0xbe0f0000, 0xc1897347,
    0x0f1ff9c1, 0xe3f7cbaf, 0x1132c083, 0x6a006aca,
    0xe8505264, 0x00000efc, 0x8910c483, 0x0000f886,
    0x87be0f00, 0x0000008c, 0xf9c1c189, 0xd05d8b1f,
    0xf7cbaf0f, 0x32c083e3, 0x006aca11, 0x5052646a,
    0x000ecfe8, 0x10c48300, 0x00cc8689, 0xbe0f0000,
    0xc1897c47, 0x0f1ff9c1, 0xe3f7cbaf, 0x1132c083,
    0x6a006aca, 0xe8505264, 0x00000ea8, 0x8910c483,
    0x00008c86, 0x87be0f00, 0x00000084, 0xf9c1c189,
    0x0fe3f71f, 0xd101cbaf, 0x646a006a, 0x81e85051,
    0x8300000e, 0x868910c4, 0x000000ac, 0x8d87be0f,
    0x89000000, 0x1ff9c1c1, 0xf7cbaf0f, 0x32c083e3,
    0x006aca11, 0x5052646a, 0x000e57e8, 0x10c48300,
    0x00d08689, 0xbe0f0000, 0xc1897d47, 0x0f1ff9c1,
    0xe3f7cbaf, 0x1132c083, 0x6a006aca, 0xe8505264,
    0x00000e30, 0x8910c483, 0x00009086, 0x87be0f00,
    0x00000085, 0xf9c1c189, 0x0fe3f71f, 0xd101cbaf,
    0x646a006a, 0x09e85051, 0x8300000e, 0x868910c4,
    0x000000b0, 0x8e87be0f, 0x89000000, 0x1ff9c1c1,
    0xf7cbaf0f, 0x32c083e3, 0x006aca11, 0x5052646a,
    0x000ddfe8, 0x10c48300, 0x00d48689, 0xbe0f0000,
    0xc1897e47, 0x0f1ff9c1, 0xe3f7cbaf, 0x1132c083,
    0x6a006aca, 0xe8505264, 0x00000db8, 0x8910c483,
    0x00009486, 0x87be0f00, 0x00000086, 0xf9c1c189,
    0x0fe3f71f, 0xd101cbaf, 0x646a006a, 0x91e85051,
    0x8300000d, 0x868910c4, 0x000000b4, 0x8f87be0f,
    0x89000000, 0x1ff9c1c1, 0xf7cbaf0f, 0x32c083e3,
    0x006aca11, 0x5052646a, 0x000d67e8, 0x10c48300,
    0x00d88689, 0xbe0f0000, 0xc1897f47, 0x0f1ff9c1,
    0xe3f7cbaf, 0x1132c083, 0x6a006aca, 0xe8505264,
    0x00000d40, 0x8910c483, 0x00009886, 0x87be0f00,
    0x00000087, 0xf9c1c189, 0x0fe3f71f, 0xd101cbaf,
    0x646a006a, 0x19e85051, 0x8300000d, 0x868910c4,
    0x000000b8, 0x9087be0f, 0x89000000, 0x1ff9c1c1,
    0xf7cbaf0f, 0x32c083e3, 0x006aca11, 0x5052646a,
    0x000cefe8, 0x10c48300, 0x00dc8689, 0xbe0f0000,
    0x00008087, 0xc1c18900, 0xaf0f1ff9, 0x83e3f7cb,
    0xca1132c0, 0x646a006a, 0xc5e85052, 0x8300000c,
    0x868910c4, 0x0000009c, 0x8887be0f, 0x89000000,
    0x1ff9c1c1, 0xaf0fe3f7, 0x6ad101cb, 0x51646a00,
    0x0c9ee850, 0xc4830000, 0xbc868910, 0x0f000000,
    0x009187be, 0xc1890000, 0x0f1ff9c1, 0xe3f7cbaf,
    0x1132c083, 0x6a006aca, 0xe8505264, 0x00000c74,
    0x8910c483, 0x0000e086, 0x87be0f00, 0x00000081,
    0xf9c1c189, 0xcbaf0f1f, 0xc083e3f7, 0x6aca1132,
    0x52646a00, 0x0c4ae850, 0xc4830000, 0xa0868910,
    0x0f000000, 0x008987be, 0xc1890000, 0xf71ff9c1,
    0xcbaf0fe3, 0x006ad101, 0x5051646a, 0x000c23e8,
    0x10c48300, 0x00c08689, 0xbe0f0000, 0x00009287,
    0xc1c18900, 0xaf0f1ff9, 0x83e3f7cb, 0xca1132c0,
    0x646a006a, 0xf9e85052, 0x8300000b, 0x868910c4,
    0x000000e4, 0x8287be0f, 0x89000000, 0x1ff9c1c1,
    0xf7cbaf0f, 0x32c083e3, 0x006aca11, 0x5052646a,
    0x000bcfe8, 0x10c48300, 0x00a48689, 0xbe0f0000,
    0x00008a87, 0xc1c18900, 0xe3f71ff9, 0x01cbaf0f,
    0x6a006ad1, 0xe8505164, 0x00000ba8, 0x8910c483,
    0x0000c486, 0x87be0f00, 0x00000093, 0xf9c1c189,
    0xcbaf0f1f, 0xc083e3f7, 0x6aca1132, 0x52646a00,
    0x0b7ee850, 0xc4830000, 0xe8868910, 0x0f000000,
    0x008387be, 0xc1890000, 0x0f1ff9c1, 0xe3f7cbaf,
    0x1132c083, 0x6a006aca, 0xe8505264, 0x00000b54,
    0x8910c483, 0x0000a886, 0x87be0f00, 0x0000008b,
    0xf9c1c189, 0x0fe3f71f, 0xd101cbaf, 0x646a006a,
    0x2de85051, 0x8300000b, 0x868910c4, 0x000000c8,
    0x5e5cc483, 0xc35d5b5f, 0x0ffc588d, 0xf039f2b7,
    0x860fd189, 0xfffffa91, 0xfffa8ee9, 0x909090ff,
    0x53e58955, 0xec835657, 0x0c7d8b1c, 0x6808758b,
    0x00000504, 0x0468006a, 0x56000005, 0xffef2fe8,
    0x10c483ff, 0xfa89f189, 0xfff613e8, 0x0f078bff,
    0x009798b6, 0xdb850000, 0x044b9e88, 0x840f0000,
    0x00000032, 0x0098808a, 0x86880000, 0x0000045f,
    0x0f01fb80, 0x00001d84, 0xff438d00, 0x9090c931,
    0xb60f178b, 0x00990a94, 0x94880000, 0x0004600e,
    0xc8394100, 0x468bea75, 0x087e8b04, 0x89284689,
    0x0003c086, 0x204e8b00, 0x8bec4d89, 0xc101244e,
    0x05c60773, 0x00002940, 0x29d23101, 0x310d72f9,
    0x46be80d2, 0x01000004, 0xca890274, 0x89e85d89,
    0x00008886, 0x84968900, 0x0f000000, 0x0422beb7,
    0xb70f0000, 0x0004249e, 0x86b70f00, 0x000003f4,
    0xe88eb70f, 0x0f000003, 0x03e696b7, 0xf9010000,
    0x5d89d101, 0x9b148de4, 0x8d890c8d, 0x8c8d890c,
    0x00012c91, 0xec65f700, 0x5251006a, 0x0b02e850,
    0xc4830000, 0x2cc86910, 0x89000001, 0x0c8df04d,
    0x890c8d80, 0xead1ca89, 0x0274ff85, 0x5d8bcf89,
    0x745e89f0, 0x896c4e89, 0x8e897056, 0x00000164,
    0x8b787e89, 0xc985e44d, 0xe0c10674, 0x800c8d02,
    0x8b7c4e89, 0x0003ea86, 0xfa868900, 0x8b000003,
    0x008b0c45, 0x5848b70f, 0xfe8e8966, 0x80000003,
    0x000446be, 0x20750300, 0xf2beb70f, 0x83000003,
    0x5d8b04ff, 0x893177e8, 0x8eb70ffa, 0x000003ee,
    0xc889cf39, 0x3deb3273, 0x94b8b60f, 0x0f000000,
    0x009590b6, 0x5d8b0000, 0x8eb70fe8, 0x000003ee,
    0xc889cf39, 0x1deb1273, 0x0ffc578d, 0x03ee8eb7,
    0xcf390000, 0x0d72c889, 0xf086b70f, 0x39000003,
    0x890277c7, 0x7cca39f8, 0x8eb70f0d, 0x000003f0,
    0x027fca39, 0x8688d189, 0x00000443, 0x04458e88,
    0x86880000, 0x0000043d, 0x043f8e88, 0xc2890000,
    0x8808c280, 0x00043e96, 0x80c28900, 0x96880cc2,
    0x00000440, 0x86881004, 0x00000441, 0x044986c6,
    0xc6ff0000, 0x00043c86, 0x86c7ff00, 0x00000168,
    0x00000001, 0x044e86c6, 0xc7ff0000, 0x00011c86,
    0xffffff00, 0x3086c7ff, 0xff000001, 0xc7ffffff,
    0x00014486, 0xffffff00, 0x2086c7ff, 0xff000001,
    0xc7ffffff, 0x00013486, 0xffffff00, 0x4886c7ff,
    0xff000001, 0xc7ffffff, 0x00012486, 0xffffff00,
    0x3886c7ff, 0xff000001, 0xc7ffffff, 0x00014c86,
    0xffffff00, 0x2886c7ff, 0xff000001, 0xc7ffffff,
    0x00013c86, 0xffffff00, 0x5086c7ff, 0xff000001,
    0xc7ffffff, 0x00012c86, 0xffffff00, 0x4086c7ff,
    0xff000001, 0xc7ffffff, 0x00015486, 0xffffff00,
    0xebf981ff, 0x7c000000, 0x00eab905, 0xfb800000,
    0x62820f02, 0x0f000001, 0x046086b6, 0xc0850000,
    0x0153840f, 0x45890000, 0x06598de4, 0x0f1ac183,
    0x045fbeb6, 0x458b0000, 0x71e7f7ec, 0x4005c607,
    0x01000029, 0x8906e8c1, 0x00015886, 0x02e7c100,
    0x897f3c8d, 0x06e8c1f8, 0x29f4c083, 0x88c329c1,
    0x0004438e, 0xf05d8900, 0x04459e88, 0x458b0000,
    0xe45d8bec, 0x0771e3f7, 0x294005c6, 0xc1010000,
    0x868906e8, 0x0000015c, 0xd231f889, 0x0ff3f766,
    0x428dd0b7, 0xfa8366f4, 0xe07d8919, 0xc2890f72,
    0x011eeac1, 0x02fac1c2, 0x890cc283, 0xe85d8bd0,
    0x01f0558b, 0x4f8688c8, 0x80000004, 0x820f03fb,
    0x000000a9, 0x61beb60f, 0x85000004, 0x9a840fff,
    0x8b000000, 0xe7f7ec45, 0x05c60771, 0x00002940,
    0x06e8c101, 0x01608689, 0x458b0000, 0x66d231e0,
    0xb70ff7f7, 0xf4428dd0, 0x19fa8366, 0xc2890f72,
    0x011eeac1, 0x02fac1c2, 0x890cc283, 0xf0558bd0,
    0x8688c801, 0x00000450, 0x7204fb80, 0xbeb60f50,
    0x00000462, 0x4574ff85, 0xf7ec458b, 0xc60771e7,
    0x00294005, 0xe8c10100, 0x84868906, 0x8b000001,
    0xd231e045, 0x0ff7f766, 0x428dd0b7, 0xfa8366f4,
    0x890f7219, 0x1eeac1c2, 0xfac1c201, 0x0cc28302,
    0x558bd089, 0x88c801f0, 0x00045186, 0x3d8e8800,
    0x88000004, 0x00043f96, 0x0c458b00, 0x808a008b,
    0x00000096, 0x04728688, 0x86c70000, 0x0000048b,
    0xffffffff, 0x048f86c7, 0x00ff0000, 0x86c60000,
    0x00000493, 0xc486c700, 0x00000004, 0xc6000000,
    0x0004c886, 0xc4830000, 0x5b5f5e1c, 0xccccc35d,
    0x53e58955, 0x4d8b5657, 0x0c7d8b14, 0x01085d8b,
    0xc60773cf, 0x00294005, 0xfb830100, 0x0002b80f,
    0x75770000, 0x8510558b, 0xbe6e74d2, 0x00020000,
    0x100000b8, 0x8bf029ff, 0x29849d34, 0xc6010000,
    0x03368b64, 0x29449d04, 0x8b640000, 0x0fde2918,
    0xfb81c092, 0x00020000, 0xc0843a72, 0xf7393675,
    0x000002b8, 0x2e870f00, 0x85000000, 0x1d840fc9,
    0x03000000, 0x00b80c5d, 0x29000200, 0x90f631c3,
    0x6433048d, 0x0489008b, 0x04c68332, 0xf072ce39,
    0x05ebc031, 0x000002b8, 0x5b5f5e00, 0x9090c35d,
    0x53e58955, 0x4d8b5657, 0x0c7d8b14, 0x01085d8b,
    0xc60773cf, 0x00294005, 0xfb830100, 0x0002b80f,
    0x75770000, 0x8510558b, 0xbe6e74d2, 0x00020000,
    0x100000b8, 0x8bf029ff, 0x29849d34, 0xc6010000,
    0x03368b64, 0x29449d04, 0x8b640000, 0x0fde2918,
    0xfb81c092, 0x00020000, 0xc0843a72, 0xf7393675,
    0x000002b8, 0x2e870f00, 0x85000000, 0x1d840fc9,
    0x03000000, 0x00b80c5d, 0x29000200, 0x90f631c3,
    0x8d32048b, 0x8964333c, 0x04c68307, 0xf072ce39,
    0x05ebc031, 0x000002b8, 0x5b5f5e00, 0x9090c35d,
    0x53e58955, 0x4d8b5657, 0x08458b14, 0x8b0c758b,
    0x29448514, 0x00bf0000, 0x29000200, 0x00c281fa,
    0x64ff1000, 0xfa893a8b, 0x920ff201, 0x72ce01c3,
    0x74db8404, 0x4005c607, 0x01000029, 0x8485048b,
    0xbb000029, 0x00020000, 0x0005d829, 0x64ff1000,
    0xfb29188b, 0x000002b8, 0x394a7200, 0x8b4677de,
    0x090f1045, 0x020000be, 0xd300bf00, 0xf729ffe0,
    0xba178964, 0xffe0d308, 0x8964f229, 0xd310b802,
    0xf029ffe0, 0xb8088964, 0xffe0d064, 0xc764f029,
    0x01800400, 0xd314b800, 0xf029ffe0, 0x0100c764,
    0x31000000, 0x5b5f5ec0, 0x9090c35d, 0x90909090,
    0x53e58955, 0x4d8b5657, 0x08458b14, 0x8b0c758b,
    0x29448514, 0x00bf0000, 0x29000200, 0x00c281fa,
    0x64ff1000, 0xfa893a8b, 0x920ff201, 0x72ce01c3,
    0x74db8404, 0x4005c607, 0x01000029, 0x8485048b,
    0xbb000029, 0x00020000, 0x0005d829, 0x64ff1000,
    0xfb29188b, 0x000002b8, 0x394a7200, 0x8b4677de,
    0x090f1045, 0x020000be, 0xd300bf00, 0xf729ffe0,
    0xba178964, 0xffe0d308, 0x8964f229, 0xd310b802,
    0xf029ffe0, 0xb8088964, 0xffe0d064, 0xc764f029,
    0x01800400, 0xd314b800, 0xf029ffe0, 0x0300c764,
    0x31000000, 0x5b5f5ec0, 0xccccc35d, 0xcccccccc,
    0x8be58955, 0xc0830845, 0xc0e08304, 0x5d40c083,
    0x909090c3, 0x90909090, 0x90909090, 0x90909090,
    0xb8e58955, 0x00020000, 0xe0d000b9, 0x64c129ff,
    0x450b018b, 0x01896408, 0x9090c35d, 0x90909090,
    0xb8e58955, 0x00020000, 0xe0d000b9, 0x64c129ff,
    0xff25018b, 0x6400ffff, 0xc35d0189, 0x90909090,
    0x56e58955, 0x8b08558b, 0x4ab60f32, 0xc1c88908,
    0x048a03e8, 0xfecc8806, 0x086288c4, 0x7508fc80,
    0x0842c607, 0x32894600, 0xe180d1f6, 0x24e8d207,
    0xc35d5e01, 0x90909090, 0x90909090, 0x90909090,
    0x53e58955, 0xf608458b, 0x74010c45, 0xb1108b10,
    0x08482a07, 0x000001bb, 0x08e3d300, 0x08488a1a,
    0x4888c1fe, 0x08f98008, 0x088b3975, 0x502bca89,
    0x02fa8304, 0x7980207c, 0x1a7500fe, 0x00ff7980,
    0x118a1475, 0x7703fa80, 0x0151880d, 0x01c6088b,
    0x41088b03, 0x518d0889, 0xc6108901, 0xc6000141,
    0x5b000840, 0x9090c35d, 0x90909090, 0x90909090,
    0x53e58955, 0x458b5657, 0x0fc08510, 0x0000a984,
    0x0c558b00, 0xe908758b, 0x00000018, 0x90909090,
    0x8901798d, 0x0141c63a, 0x0842c600, 0x840f4800,
    0x00000086, 0xb60f3e8b, 0xcb89084e, 0x0f03ebc1,
    0x881f1cb6, 0x88c7fecf, 0xff80087e, 0xc6077508,
    0x47000846, 0xd1f63e89, 0x0f07e180, 0xb60ffbb6,
    0xcfa30fc9, 0x3a8b1073, 0x4a2a07b1, 0x0001bb08,
    0xe3d30000, 0xb60f1f08, 0xc1fe084a, 0x80084a88,
    0xa97508f9, 0xcf890a8b, 0x83047a2b, 0x907c02ff,
    0x00fe7980, 0x79808a75, 0x847500ff, 0x8019b60f,
    0x870f03fb, 0xffffff78, 0x8b015988, 0x0301c60a,
    0x89410a8b, 0xff66e90a, 0x5f5effff, 0x90c35d5b,
    0x53e58955, 0x458b5657, 0x880f4810, 0x00000072,
    0x8b0c558b, 0x15e90875, 0x90000000, 0x90909090,
    0x8901798d, 0x0141c63e, 0x0846c600, 0x52784800,
    0x73c2a30f, 0xb13e8b10, 0x084e2a07, 0x000001bb,
    0x08e3d300, 0x4eb60f1f, 0x88c1fe08, 0xf980084e,
    0x8bda7508, 0x2bcf890e, 0xff83047e, 0x80c17c02,
    0x7500fe79, 0xff7980bb, 0x0fb57500, 0xfb8019b6,
    0x88ad7703, 0x0e8b0159, 0x8b0301c6, 0x0e89410e,
    0x5f5e9eeb, 0x90c35d5b, 0x90909090, 0x90909090,
    0x53e58955, 0xec835657, 0x087d8b08, 0x420c558b,
    0xffffffb9, 0xb91c747f, 0xffffffff, 0x9090d089,
    0x8541f8d1, 0x81f975c0, 0xffffffe1, 0xf4840f7f,
    0x89000000, 0xffbef055, 0xd3ffffff, 0xec4d89e6,
    0xe901598d, 0x0000001c, 0x90909090, 0x90909090,
    0x8901418d, 0x0141c607, 0x0847c600, 0x4bd23100,
    0x527edb85, 0x7501fb83, 0xb1178b10, 0x084f2a07,
    0x000001b8, 0x08e0d300, 0x57b60f02, 0x88c2fe08,
    0xfa800857, 0x8bd87508, 0x2bc8890f, 0xf8830447,
    0x80bd7c02, 0x7500fe79, 0xff7980b7, 0x0fb17500,
    0xfa8011b6, 0x88a97703, 0x078b0151, 0x8b0300c6,
    0x0f89410f, 0x75039aeb, 0xec5d8bf0, 0x9017eb4b,
    0x8901418d, 0x0141c607, 0x0847c600, 0x4bd23100,
    0x00a6880f, 0xa30f0000, 0x8b1373de, 0x2807b107,
    0x0001bad1, 0xe2d30000, 0xb60f1008, 0xc2fe0857,
    0x80085788, 0xd77508fa, 0xc8890f8b, 0x8304472b,
    0xbc7c02f8, 0x00fe7980, 0x7980b675, 0xb07500ff,
    0x8011b60f, 0xa87703fa, 0x8b015188, 0x0300c607,
    0x89410f8b, 0x8b99eb0f, 0x2a07b107, 0x01ba084f,
    0xd3000000, 0x8a1008e2, 0xc0fe0847, 0x3c084788,
    0x8b397508, 0x2bc18907, 0xf983044f, 0x80207c02,
    0x7500fe78, 0xff78801a, 0x8a147500, 0x03f98008,
    0x48880d77, 0xc6078b01, 0x078b0300, 0x8d078940,
    0x0f890148, 0x000140c6, 0x000847c6, 0x5e08c483,
    0xc35d5b5f, 0x24548b56, 0x24448b14, 0xc1d18910,
    0xc8311ff9, 0xc829ca31, 0x5489ca19, 0x44891424,
    0xce891024, 0x0c24548b, 0x0824448b, 0xf9c1d189,
    0x31c8311f, 0x19c829ca, 0x245489ca, 0x2444890c,
    0x53ce3108, 0x18245c8b, 0x0fcbbd0f, 0x00008f84,
    0x24448b00, 0xd1e8d314, 0xd3d1f7e8, 0x8bc309e3,
    0x8b102454, 0x390c2444, 0xf73773da, 0xd1f757f3,
    0xe8d3e8d1, 0x64f7c789, 0x5c8b1824, 0x4c8b1024,
    0xc3291424, 0x448bd119, 0xaf0f1c24, 0x83c129c7,
    0xd23100df, 0xf001f889, 0xf031f211, 0x5b5ff231,
    0xda29c35e, 0xf757f3f7, 0x0de8d1d1, 0x80000000,
    0xc789e8d3, 0x182464f7, 0x10245c8b, 0x14244c8b,
    0xd119c329, 0x1c24448b, 0x29c7af0f, 0x00df83c1,
    0xf889d231, 0xf211f001, 0xf231f031, 0xc35e5b5f,
    0x1024448b, 0x14244c8b, 0xf1f7d231, 0x448bc389,
    0xf1f70c24, 0xf001da89, 0xf031f211, 0x5e5bf231,
    0xccccccc3, 0x245c8b53, 0xcbbd0f14, 0x448b7d74,
    0xe8d31024, 0xd1f7e8d1, 0xc309e3d3, 0x0c24548b,
    0x0824448b, 0x2e73da39, 0xf757f3f7, 0xd3e8d1d1,
    0xf7c789e8, 0x8b142464, 0x8b0c245c, 0x2910244c,
    0x8bd119c3, 0x0f182444, 0xc129c7af, 0x3100df83,
    0x5ff889d2, 0xda29c35b, 0xf757f3f7, 0x0de8d1d1,
    0x80000000, 0xc789e8d3, 0x142464f7, 0x0c245c8b,
    0x10244c8b, 0xd119c329, 0x1824448b, 0x29c7af0f,
    0x00df83c1, 0xf889d231, 0x8bc35b5f, 0x8b0c2444,
    0x3110244c, 0x89f1f7d2, 0x24448bc3, 0x89f1f708,
    0xccc35bda, 0xcccccccc, 0xcccccccc, 0xcccccccc,
    0xcccccccc, 0xcccccccc, 0xcccccccc, 0xcccccccc,
    0xcccccccc, 0xcccccccc, 0xcccccccc, 0xcccccccc,
    0x00080095, 0x00008e00, 0x0008009f, 0x00008e00,
    0x000800a9, 0x00008e00, 0x000800b3, 0x00008e00,
    0x000800bd, 0x00008e00, 0x000800c7, 0x00008e00,
    0x000800d1, 0x00008e00, 0x000800db, 0x00008e00,
    0x000800e5, 0x00008e00, 0x000800ed, 0x00008e00,
    0x000800f7, 0x00008e00, 0x000800ff, 0x00008e00,
    0x00080107, 0x00008e00, 0x0008010f, 0x00008e00,
    0x00080117, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080129, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x000801b1, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x000801a0, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x000801bf, 0x00008e00,
    0x00000250, 0x00000260, 0x00000280, 0x00000270,
    0x00000290, 0x000002a0, 0x000002b0, 0x000002c0,
    0x000002d0, 0x000002e0, 0x000002f0, 0x00000300,
    0x00000310, 0x00000320, 0x00000330, 0x00000080,
    0x00000350, 0x00000080, 0x00000080, 0x00000080,
    0x00000080, 0x00000080, 0x00000080, 0x00000080,
    0x00000080, 0x00000080, 0x00000080, 0x00000080,
    0x00000080, 0x00000080, 0x00000080, 0x00000080,
    0x00000000, 0x00000004, 0x0000000c, 0x00000014,
    0x0000001c, 0x00000024, 0x0000002c, 0x00000034,
    0x0000003c, 0x00000044, 0x0000004c, 0x00000054,
    0x0000005c, 0x00000064, 0x0000006c, 0x00000074,
    0x0000007c, 0x00000000, 0x00000008, 0x00000010,
    0x00000018, 0x00000020, 0x00000028, 0x00000030,
    0x00000038, 0x00000040, 0x00000048, 0x00000050,
    0x00000058, 0x00000060, 0x00000068, 0x00000070,
    0x00000078, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000
};
