# Localizing Ghostty: The Translators' Guide

First of all, thanks for helping us localize Ghostty!

To begin contributing, please make sure that you have installed `gettext`
on your system, which should be available under the `gettext` package
for most Linux and macOS package managers.

You can install `gettext` on Windows in a few ways:

- Through [an installer](https://mlocati.github.io/articles/gettext-iconv-windows.html);
- Through package managers like Scoop (`scoop install gettext`) and
  WinGet (`winget install gettext`) which repackages the aforementioned installer;
- Through Unix-like environments like [Cygwin](https://cygwin.com/cygwin/packages/summary/gettext.html)
  and [MSYS2](https://packages.msys2.org/base/gettext).

> [!WARNING]
>
> Unlike what some tutorials suggest, **we do not recommend installing `gettext`
> through GnuWin32**, since it hasn't been updated since 2010 and very likely
> does not work on modern Windows versions.

You can verify that `gettext` has been successfully installed by running the
command `gettext -V`. If everything went correctly, you should see an output like this:

```console
$ gettext -V
gettext (GNU gettext-runtime) 0.21.1
Copyright (C) 1995-2022 Free Software Foundation, Inc.
License GPLv3+: GNU GPL version 3 or later <https://gnu.org/licenses/gpl.html>
This is free software: you are free to change and redistribute it.
There is NO WARRANTY, to the extent permitted by law.
Written by Ulrich Drepper.
```

With this, you're ready to localize!

## Editing translation files

All translation files lie in the `po/` directory, including the main _template_
file called `com.mitchellh.ghostty.pot`. **Do not edit this file.** The
template is generated automatically from Ghostty's code and resources, and are
intended to be regenerated by code contributors. If there is a problem with
the template file, please reach out to a code contributor.

Instead, only edit the translation file corresponding to your language/locale,
identified via the its _locale name_: for example, `de_DE.UTF-8.po` would be
the translation file for German (language code `de`) as spoken in Germany
(country code `DE`). The GNU `gettext` manual contains
[further information about locale names](https://www.gnu.org/software/gettext/manual/gettext.html#Locale-Names-1),
including a list of language and country codes.

> [!NOTE]
>
> If the translation file for your locale does not yet exist, see the
> ["Creating new translation files" section](#creating-new-translation-files)
> of this document on how to create one.

The `.po` file contains a list of entries that look like this:

```po
#. Translators: the category in the right-click context menu that contains split items for all directions
#: src/apprt/gtk/ui/1.0/menu-surface-context-menu.blp:38
#  译注：其他终端程序对 Split 皆有不同翻译，此处采取最直观的翻译方式
msgctxt "Context menu"
msgid "Split"
msgstr "分屏"
```

The `msgid` line contains the original string in English, and the `msgstr` line
should contain the translation for your language. Occasionally there will also
be a `msgctxt` line that differentiates strings that are identical in English,
based on its context.

Lines beginning with `#` are comments, of which there are several kinds:

- Pay attention to comments beginning with `#.`. They are comments left
  by _developers_ providing more context to the string.

- Comments that begin with `#:` are _source comments_: they link
  the string to source code or resource files. You normally don't need to
  consider these in your translations.

- You may also leave comments of your own to be read by _other translators_,
  beginning with `# `. These comments are specific to your locale and don't
  affect translators in other locales.

The first entry of the `.po` file has an empty `msgid`. This entry is special
as it stores the metadata related to the `.po` file itself. You usually do
not need to modify it.

## Creating new translation files

You can use the `msginit` tool to create new translation files.

Run the command below, optionally replacing `$LANG` with the name of a locale
that is _different_ to your system locale, or if the `LANG` environmental
variable is not set.

```console
$ msginit -i po/com.mitchellh.ghostty.pot -l $LANG -o "po/$LANG.po"
```

> [!NOTE]
>
> Ghostty enforces the convention that all parts of the locale, including the
> language code, country code, encoding, and possible regional variants
> **must** be communicated in the file name. Files like `pt.po` are not
> acceptable, while `pt_BR.UTF-8.po` is.
>
> This is to allow us to more easily accommodate regional variants of a
> language in the future, and to reject translations that may not be applicable
> to all speakers of a language (e.g. an unqualified `zh.po` may contain
> terminology specific to Chinese speakers in Mainland China, which are not
> found in Taiwan. Using `zh_CN.UTF-8.po` would allow that difference to be
> communicated.)

> [!WARNING]
>
> **Make sure your selected locale uses the UTF-8 encoding, as it is the sole
> encoding supported by Ghostty and its dependencies.**
>
> For backwards compatibility reasons, some locales may default to a non-UTF-8
> encoding when an encoding is not specified. For instance, `de_DE` defaults
> to using the legacy ISO-8859-1 encoding, which is incompatible with UTF-8.
> You need to manually instruct `msginit` to use UTF-8 in these instances,
> by appending `.UTF-8` to the end of the locale name (e.g. `de_DE.UTF-8`).

`msginit` may prompt you for other information such as your email address,
which should be filled in accordingly. You can then add your translations
within the newly created translation file.

Afterwards, you need to update the list of known locales within Ghostty's
build system. To do so, open `src/os/i18n.zig` and find the list
of locales under the `locales` variable, then add the full locale name
into the list.

The order matters, so make sure to place your locale in the correct position.
Read the comment above the variable for more details on the order. If you're
unsure, place it at the end of the list.

```zig
const locales = [_][]const u8{
    "zh_CN.UTF-8",
    // <- Add your locale here (probably)
}
```

You should then be able to run `zig build` and see your translations in action.

Before opening a pull request with the new translation file, you should also add
your locale to the `CODEOWNERS` file. Find the `# Localization` section near the
bottom and add a line like so (where `xx_YY` is your locale):

```diff
 # Localization
 /po/README_TRANSLATORS.md @ghostty-org/localization
 /po/com.mitchellh.ghostty.pot @ghostty-org/localization
 /po/zh_CN.UTF-8.po @ghostty-org/zh_CN
+/po/xx_YY.UTF-8.po @ghostty-org/xx_YY
```

## Style Guide

These are general style guidelines for translations. Naturally, the specific
recommended standards will differ based on the specific language/locale,
but these should serve as a baseline for the tone and voice of any translation.

- **Prefer an instructive, yet professional tone.**

  In languages that exhibit distinctions based on formality,
  prefer the formality that is expected of instructive material on the internet.
  The user should be considered an equal peer of the program and the translator,
  not an esteemed customer.

- **Use simple to understand language and avoid jargon.**

  Explain concepts that may be familiar in an English-speaking context,
  but are uncommon in your language.

- **Do not overly literally translate foreign concepts to your language.**

  Care should be taken so that your translations make sense to a reader without
  any background knowledge of the English source text. To _localize_ is to
  transfer a concept between languages, not to translate each word at face value.

- **Be consistent with stylistic and tonal choices.**

  Consult the translations made by previous translators, and try to emulate them.
  Do not overwrite someone else's hard work without substantial justification.

- **Make Ghostty fit in with surrounding applications.**

  Follow existing translations for terms and concepts if possible, even when
  they are suboptimal. Follow the writing styles prescribed by the human
  interface guidelines of each platform Ghostty is available for, including the
  [GNOME Human Interface Guidelines](https://developer.gnome.org/hig/guidelines/writing-style.html)
  on Linux, and [Apple's Human Interface Guidelines](https://developer.apple.com/design/human-interface-guidelines/writing)
  on macOS.
