// -*- C++ -*-
#include "Rivet/Analysis.hh"
#include "Rivet/Projections/FinalState.hh"
#include "Rivet/Projections/UnstableParticles.hh"

namespace Rivet {


  /// @brief e+e- > Delta++ pbar- pi-
  class BESIII_2023_I2661512 : public Analysis {
  public:

    /// Constructor
    RIVET_DEFAULT_ANALYSIS_CTOR(BESIII_2023_I2661512);


    /// @name Analysis methods
    /// @{

    /// Book histograms and initialise projections before the run
    void init() {
      declare(FinalState(), "FS");
      declare(UnstableParticles(Cuts::abspid==2224), "UFS");
      for (size_t ih=0; ih<2; ++ih) {
        book(_sigma[ih], 1+ih, 1, 1);
        for (const string& en : _sigma[ih].binning().edges<0>()) {
          double eval = stod(en);
          if (isCompatibleWithSqrtS(eval))  _sqs = en;
        }
      }
      raiseBeamErrorIf(_sqs.empty());
    }

    void findChildren(const Particle& p,map<long,int>& nRes, int& ncount) const {
      for (const Particle &child : p.children()) {
        if (child.children().empty()) {
          --nRes[child.pid()];
          --ncount;
        }
        else {
          findChildren(child, nRes, ncount);
        }
      }
    }

    /// Perform the per-event analysis
    void analyze(const Event& event) {
      const FinalState& fs = apply<FinalState>(event, "FS");
      map<long,int> nCount;
      int ntotal(0);
      for (const Particle& p : fs.particles()) {
        nCount[p.pid()] += 1;
        ++ntotal;
      }
      // loop over delta++
      for (const Particle& p : apply<FinalState>(event, "UFS").particles()) {
        int sign =-p.pid()/p.abspid();
        map<long,int> nRes = nCount;
        int ncount = ntotal;
        findChildren(p, nRes, ncount);
        bool matched = true;
        for (const auto& val : nRes) {
          if (val.first== 211*sign || val.first==2212*sign) {
            if (val.second !=1) {
              matched = false;
              break;
            }
          }
          else if (val.second!=0) {
            matched = false;
            break;
          }
        }
        if (matched) {
          size_t ih = _sqs == "2.6454"s;
          _sigma[ih]->fill(_sqs);
          break;
        }
      }
    }


    /// Normalise histograms etc., after the run
    void finalize() {
      scale(_sigma, crossSection()/ sumOfWeights() /picobarn);
    }

    /// @}


    /// @name Histograms
    /// @{
    BinnedHistoPtr<string> _sigma[2];
    string _sqs = "";
    /// @}


  };


  RIVET_DECLARE_PLUGIN(BESIII_2023_I2661512);

}
