/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.log;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.felix.log.LogException;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogLevel;

final class LogEntryImpl
implements LogEntry {
    private static final AtomicLong m_sequenceGenerator = new AtomicLong();
    private final String m_name;
    private final Bundle m_bundle;
    private final Throwable m_exception;
    private final LogLevel m_level;
    private final int m_legacyLevel;
    private final String m_message;
    private final ServiceReference<?> m_serviceReference;
    private final long m_time;
    private final long m_sequence;
    private final String m_threadInfo;
    private final StackTraceElement m_stackTraceElement;
    private volatile String _toString;

    LogEntryImpl(String name, Bundle bundle, ServiceReference<?> sr, LogLevel level, String message, Throwable exception, StackTraceElement stackTraceElement) {
        this.m_name = name;
        this.m_bundle = bundle;
        this.m_exception = LogException.getException(exception);
        this.m_level = level;
        this.m_legacyLevel = level.ordinal();
        this.m_message = message;
        this.m_serviceReference = sr;
        this.m_time = System.currentTimeMillis();
        this.m_sequence = m_sequenceGenerator.getAndIncrement();
        this.m_threadInfo = Thread.currentThread().getName();
        this.m_stackTraceElement = stackTraceElement;
    }

    LogEntryImpl(String name, Bundle bundle, ServiceReference<?> sr, int legacyLevel, String message, Throwable exception, StackTraceElement stackTraceElement) {
        this.m_name = name;
        this.m_bundle = bundle;
        this.m_exception = LogException.getException(exception);
        LogLevel level = LogLevel.TRACE;
        switch (legacyLevel) {
            case 1: {
                level = LogLevel.ERROR;
                break;
            }
            case 2: {
                level = LogLevel.WARN;
                break;
            }
            case 3: {
                level = LogLevel.INFO;
                break;
            }
            case 4: {
                level = LogLevel.DEBUG;
            }
        }
        this.m_level = level;
        this.m_legacyLevel = level == LogLevel.TRACE ? legacyLevel : level.ordinal();
        this.m_message = message;
        this.m_serviceReference = sr;
        this.m_time = System.currentTimeMillis();
        this.m_sequence = m_sequenceGenerator.getAndIncrement();
        this.m_threadInfo = Thread.currentThread().getName();
        this.m_stackTraceElement = stackTraceElement;
    }

    @Override
    public Bundle getBundle() {
        return this.m_bundle;
    }

    @Override
    public ServiceReference<?> getServiceReference() {
        return this.m_serviceReference;
    }

    @Override
    public int getLevel() {
        if (this.m_legacyLevel != this.m_level.ordinal()) {
            return this.m_legacyLevel;
        }
        return this.m_level.ordinal();
    }

    @Override
    public String getMessage() {
        return this.m_message;
    }

    @Override
    public Throwable getException() {
        return this.m_exception;
    }

    @Override
    public long getTime() {
        return this.m_time;
    }

    @Override
    public LogLevel getLogLevel() {
        return this.m_level;
    }

    @Override
    public String getLoggerName() {
        return this.m_name;
    }

    @Override
    public long getSequence() {
        return this.m_sequence;
    }

    @Override
    public String getThreadInfo() {
        return this.m_threadInfo;
    }

    @Override
    public StackTraceElement getLocation() {
        return this.m_stackTraceElement;
    }

    public String toString() {
        if (this._toString == null) {
            this._toString = this.m_time + "#" + this.m_sequence + " [" + this.m_threadInfo + "] " + (Object)((Object)this.m_level) + " (" + this.m_legacyLevel + ") [" + this.m_bundle.getBundleId() + ":" + this.m_name + "] " + this.m_stackTraceElement.getClassName() + ":" + this.m_stackTraceElement.getLineNumber() + " > " + this.m_message + (this.m_exception != null ? "\n" + this.exceptionString(this.m_exception) : "");
        }
        return this._toString;
    }

    String exceptionString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }
}

