/*
 * Decompiled with CFR 0.152.
 */
package com.infor.core.diag;

import java.util.Formatter;
import org.apache.commons.lang.Validate;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FormattingLogger {
    private Logger log;
    private StringBuilder sb;
    private Formatter formatter;
    private boolean debug = false;
    private boolean info = false;

    private FormattingLogger(Logger log) {
        Validate.notNull((Object)log);
        this.log = log;
        this.debug = log.isDebugEnabled();
        this.info = log.isInfoEnabled();
        this.sb = new StringBuilder();
        this.formatter = new Formatter(this.sb);
    }

    private FormattingLogger(Class<?> cls) {
        this(Logger.getLogger(cls));
    }

    public static FormattingLogger getLogger(Class<?> cls) {
        return new FormattingLogger(cls);
    }

    private String format(String fmt, Object ... args) {
        this.sb.setLength(0);
        return this.formatter.format(fmt, args).toString();
    }

    public void debug(String fmt, Throwable t, Object ... args) {
        String msg = args.length == 0 ? fmt : this.format(fmt, args);
        this.log.debug((Object)msg, t);
    }

    public void debug(String fmt, Object ... args) {
        String msg = args.length == 0 ? fmt : this.format(fmt, args);
        this.log.debug((Object)msg);
    }

    public void info(String fmt, Throwable t, Object ... args) {
        String msg = args.length == 0 ? fmt : this.format(fmt, args);
        this.log.info((Object)msg, t);
    }

    public void info(String fmt, Object ... args) {
        String msg = args.length == 0 ? fmt : this.format(fmt, args);
        this.log.info((Object)msg);
    }

    public void error(String fmt, Throwable t, Object ... args) {
        String msg = args.length == 0 ? fmt : this.format(fmt, args);
        this.log.error((Object)msg, t);
    }

    public void error(String fmt, Object ... args) {
        String msg = args.length == 0 ? fmt : this.format(fmt, args);
        this.log.error((Object)msg);
    }

    public void warn(String fmt, Throwable t, Object ... args) {
        String msg = args.length == 0 ? fmt : this.format(fmt, args);
        this.log.warn((Object)msg, t);
    }

    public void warn(String fmt, Object ... args) {
        String msg = args.length == 0 ? fmt : this.format(fmt, args);
        this.log.warn((Object)msg);
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isInfo() {
        return this.info;
    }

    public Level getLevel() {
        return this.log.getLevel();
    }

    public void setLevel(Level level) {
        this.log.setLevel(level);
    }
}

