/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math;

import org.jquantlib.math.Constants;
import org.jquantlib.math.distributions.GammaFunction;

public class RegularisedIncompleteBeta {
    private double tolerance_;
    private int maxIterations_;
    private static final GammaFunction _gammaFunction = new GammaFunction();

    public RegularisedIncompleteBeta(double tolerance, int maxIterations) {
        this.checkMaxIterations(maxIterations);
        this.tolerance_ = tolerance;
        this.maxIterations_ = maxIterations;
    }

    public RegularisedIncompleteBeta() {
        this.tolerance_ = 1.0E-16;
        this.maxIterations_ = 100;
    }

    private double betaContinuedFraction(double a, double b, double x, double accuracy, int maxIteration) {
        this.checkMaxIterations(maxIteration);
        double qab = a + b;
        double qap = a + 1.0;
        double qam = a - 1.0;
        double c = 1.0;
        double d = 1.0 - qab * x / qap;
        if (Math.abs(d) < Constants.QL_EPSILON) {
            d = Constants.QL_EPSILON;
        }
        double result = d = 1.0 / d;
        for (int m = 1; m <= maxIteration; ++m) {
            int m2 = 2 * m;
            double aa = (double)m * (b - (double)m) * x / ((qam + (double)m2) * (a + (double)m2));
            if (Math.abs(d = 1.0 + aa * d) < Constants.QL_EPSILON) {
                d = Constants.QL_EPSILON;
            }
            if (Math.abs(c = 1.0 + aa / c) < Constants.QL_EPSILON) {
                c = Constants.QL_EPSILON;
            }
            d = 1.0 / d;
            result *= d * c;
            aa = -(a + (double)m) * (qab + (double)m) * x / ((a + (double)m2) * (qap + (double)m2));
            if (Math.abs(d = 1.0 + aa * d) < Constants.QL_EPSILON) {
                d = Constants.QL_EPSILON;
            }
            if (Math.abs(c = 1.0 + aa / c) < Constants.QL_EPSILON) {
                c = Constants.QL_EPSILON;
            }
            d = 1.0 / d;
            double del = d * c;
            result *= del;
            if (!(Math.abs(del - 1.0) < accuracy)) continue;
            return result;
        }
        throw new ArithmeticException("a or b too big, or maxIteration too small in betacf");
    }

    public double evaluate(double x, double a, double b) {
        this.checkMaxIterations(this.maxIterations_);
        if (!(a > 0.0)) {
            throw new ArithmeticException("a must be greater than zero");
        }
        if (!(b > 0.0)) {
            throw new ArithmeticException("b must be greater than zero");
        }
        if (x == 0.0) {
            return 0.0;
        }
        if (x == 1.0) {
            return 1.0;
        }
        if (!(x > 0.0) || !(x < 1.0)) {
            throw new ArithmeticException("x must be in [0,1]");
        }
        double result = Math.exp(_gammaFunction.logValue(a + b) - _gammaFunction.logValue(a) - _gammaFunction.logValue(b) + a * Math.log(x) + b * Math.log(1.0 - x));
        if (x < (a + 1.0) / (a + b + 2.0)) {
            return result * this.betaContinuedFraction(a, b, x, this.tolerance_, this.maxIterations_) / a;
        }
        return 1.0 - result * this.betaContinuedFraction(b, a, 1.0 - x, this.tolerance_, this.maxIterations_) / b;
    }

    private void checkMaxIterations(int maxIterations) {
        if (maxIterations < 1) {
            throw new IllegalArgumentException("Expected maxIterations>0, " + maxIterations);
        }
    }
}

