/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures.volatilities;

import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.quotes.Handle;
import org.jquantlib.termstructures.BlackVarianceTermStructure;
import org.jquantlib.termstructures.BlackVolTermStructure;
import org.jquantlib.termstructures.TermStructure;
import org.jquantlib.util.Date;
import org.jquantlib.util.TypedVisitor;
import org.jquantlib.util.Visitor;

public class ImpliedVolTermStructure
extends BlackVarianceTermStructure {
    private Handle<BlackVolTermStructure> originalTS;

    public ImpliedVolTermStructure(Handle<BlackVolTermStructure> originalTS, Date referenceDate) {
        super(referenceDate);
        this.originalTS = originalTS;
        originalTS.addObserver(this);
    }

    @Override
    protected double blackVarianceImpl(double t, double strike) {
        double timeShift = this.dayCounter().yearFraction(this.originalTS.getLink().referenceDate(), this.referenceDate());
        return this.originalTS.getLink().blackForwardVariance(timeShift, timeShift + t, strike, true);
    }

    @Override
    public double maxStrike() {
        return this.originalTS.getLink().maxStrike();
    }

    @Override
    public double minStrike() {
        return this.originalTS.getLink().minStrike();
    }

    @Override
    public Date maxDate() {
        return this.originalTS.getLink().maxDate();
    }

    @Override
    public DayCounter dayCounter() {
        return this.originalTS.getLink().dayCounter();
    }

    @Override
    public void accept(TypedVisitor<TermStructure> v) {
        Visitor<TermStructure> v1;
        Visitor<TermStructure> visitor = v1 = v != null ? v.getVisitor(this.getClass()) : null;
        if (v1 != null) {
            v1.visit(this);
        } else {
            super.accept(v);
        }
    }
}

