/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time.calendars;

import org.jquantlib.time.Weekday;
import org.jquantlib.time.WesternCalendar;
import org.jquantlib.time.calendars.DelegateCalendar;
import org.jquantlib.util.Date;
import org.jquantlib.util.Month;

public class Japan
extends DelegateCalendar {
    private static final Japan SETTLEMENT_CALENDAR = new Japan(Market.SETTLEMENT);

    private Japan(Market market) {
        JapanSettlementCalendar delegate;
        switch (market) {
            case SETTLEMENT: {
                delegate = new JapanSettlementCalendar();
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown market");
            }
        }
        this.setDelegate(delegate);
    }

    public static Japan getCalendar(Market market) {
        switch (market) {
            case SETTLEMENT: {
                return SETTLEMENT_CALENDAR;
            }
        }
        throw new IllegalArgumentException("unknown market");
    }

    private static final class JapanSettlementCalendar
    extends WesternCalendar {
        private JapanSettlementCalendar() {
        }

        @Override
        public String getName() {
            return "Japan";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.getWeekday();
            int d = date.getDayOfMonth();
            Month m = date.getMonthEnum();
            int y = date.getYear();
            double exact_vernal_equinox_time = 20.69115;
            double exact_autumnal_equinox_time = 23.09;
            double diff_per_year = 0.242194;
            double moving_amount = (double)(y - 2000) * 0.242194;
            int number_of_leap_years = (y - 2000) / 4 + (y - 2000) / 100 - (y - 2000) / 400;
            int ve = (int)(20.69115 + moving_amount - (double)number_of_leap_years);
            int ae = (int)(23.09 + moving_amount - (double)number_of_leap_years);
            return !(this.isWeekend(w) || d == 1 && m == Month.JANUARY || d == 2 && m == Month.JANUARY || d == 3 && m == Month.JANUARY || w == Weekday.MONDAY && d >= 8 && d <= 14 && m == Month.JANUARY && y >= 2000 || (d == 15 || d == 16 && w == Weekday.MONDAY) && m == Month.JANUARY && y < 2000 || (d == 11 || d == 12 && w == Weekday.MONDAY) && m == Month.FEBRUARY || (d == ve || d == ve + 1 && w == Weekday.MONDAY) && m == Month.MARCH || (d == 29 || d == 30 && w == Weekday.MONDAY) && m == Month.APRIL || d == 3 && m == Month.MAY || d == 4 && m == Month.MAY || (d == 5 || d == 6 && w == Weekday.MONDAY) && m == Month.MAY || w == Weekday.MONDAY && d >= 15 && d <= 21 && m == Month.JULY && y >= 2003 || (d == 20 || d == 21 && w == Weekday.MONDAY) && m == Month.JULY && y >= 1996 && y < 2003 || w == Weekday.MONDAY && d >= 15 && d <= 21 && m == Month.SEPTEMBER && y >= 2003 || (d == 15 || d == 16 && w == Weekday.MONDAY) && m == Month.SEPTEMBER && y < 2003 || w == Weekday.TUESDAY && d + 1 == ae && d >= 16 && d <= 22 && m == Month.SEPTEMBER && y >= 2003 || (d == ae || d == ae + 1 && w == Weekday.MONDAY) && m == Month.SEPTEMBER || w == Weekday.MONDAY && d >= 8 && d <= 14 && m == Month.OCTOBER && y >= 2000 || (d == 10 || d == 11 && w == Weekday.MONDAY) && m == Month.OCTOBER && y < 2000 || (d == 3 || d == 4 && w == Weekday.MONDAY) && m == Month.NOVEMBER || (d == 23 || d == 24 && w == Weekday.MONDAY) && m == Month.NOVEMBER || (d == 23 || d == 24 && w == Weekday.MONDAY) && m == Month.DECEMBER && y >= 1989 || d == 31 && m == Month.DECEMBER || d == 10 && m == Month.APRIL && y == 1959 || d == 24 && m == Month.FEBRUARY && y == 1989 || d == 12 && m == Month.NOVEMBER && y == 1990 || d == 9 && m == Month.JUNE && y == 1993) && (d != 6 || m != Month.MAY || y != 2008 && y != 2009);
        }
    }

    public static enum Market {
        SETTLEMENT;

    }
}

