/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.solvers1D;

import org.jquantlib.math.AbstractSolver1D;
import org.jquantlib.math.Closeness;
import org.jquantlib.math.Constants;
import org.jquantlib.math.UnaryFunctionDouble;

public class Brent
extends AbstractSolver1D<UnaryFunctionDouble> {
    @Override
    protected double solveImpl(UnaryFunctionDouble f, double xAccuracy) {
        double d = 0.0;
        double e = 0.0;
        this.root_ = this.xMax_;
        double froot = this.fxMax_;
        while (this.evaluationNumber_ <= this.getMaxEvaluations()) {
            if (froot > 0.0 && this.fxMax_ > 0.0 || froot < 0.0 && this.fxMax_ < 0.0) {
                this.xMax_ = this.xMin_;
                this.fxMax_ = this.fxMin_;
                e = d = this.root_ - this.xMin_;
            }
            if (Math.abs(this.fxMax_) < Math.abs(froot)) {
                this.xMin_ = this.root_;
                this.root_ = this.xMax_;
                this.xMax_ = this.xMin_;
                this.fxMin_ = froot;
                froot = this.fxMax_;
                this.fxMax_ = this.fxMin_;
            }
            double xAcc1 = 2.0 * Constants.QL_EPSILON * Math.abs(this.root_) + 0.5 * xAccuracy;
            double xMid = (this.xMax_ - this.root_) / 2.0;
            if (Math.abs(xMid) <= xAcc1 || froot == 0.0) {
                return this.root_;
            }
            if (Math.abs(e) >= xAcc1 && Math.abs(this.fxMin_) > Math.abs(froot)) {
                double min2;
                double q;
                double p;
                double s = froot / this.fxMin_;
                if (Closeness.isClose(this.xMin_, this.xMax_)) {
                    p = 2.0 * xMid * s;
                    q = 1.0 - s;
                } else {
                    q = this.fxMin_ / this.fxMax_;
                    double r = froot / this.fxMax_;
                    p = s * (2.0 * xMid * q * (q - r) - (this.root_ - this.xMin_) * (r - 1.0));
                    q = (q - 1.0) * (r - 1.0) * (s - 1.0);
                }
                if (p > 0.0) {
                    q = -q;
                }
                p = Math.abs(p);
                double min1 = 3.0 * xMid * q - Math.abs(xAcc1 * q);
                double d2 = min1 < (min2 = Math.abs(e * q)) ? min1 : min2;
                if (2.0 * p < d2) {
                    e = d;
                    d = p / q;
                } else {
                    e = d = xMid;
                }
            } else {
                e = d = xMid;
            }
            this.xMin_ = this.root_;
            this.fxMin_ = froot;
            this.root_ = Math.abs(d) > xAcc1 ? (this.root_ += d) : (this.root_ += this.sign(xAcc1, xMid));
            froot = f.evaluate(this.root_);
            ++this.evaluationNumber_;
        }
        throw new ArithmeticException("maximum number of function evaluations (" + this.getMaxEvaluations() + ") exceeded");
    }

    private double sign(double a, double b) {
        return b >= 0.0 ? Math.abs(a) : -Math.abs(a);
    }
}

