/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.solvers1D;

import org.jquantlib.math.AbstractSolver1D;
import org.jquantlib.math.distributions.Derivative;

public class NewtonSafe
extends AbstractSolver1D<Derivative> {
    @Override
    protected double solveImpl(Derivative f, double xAccuracy) {
        double dxold;
        double xh;
        double xl;
        if (this.fxMin_ < 0.0) {
            xl = this.xMin_;
            xh = this.xMax_;
        } else {
            xh = this.xMin_;
            xl = this.xMax_;
        }
        double dx = dxold = this.xMax_ - this.xMin_;
        double froot = f.evaluate(this.root_);
        double dfroot = f.derivative(this.root_);
        ++this.evaluationNumber_;
        while (this.evaluationNumber_ <= this.getMaxEvaluations()) {
            if (((this.root_ - xh) * dfroot - froot) * ((this.root_ - xl) * dfroot - froot) > 0.0 || Math.abs(2.0 * froot) > Math.abs(dxold * dfroot)) {
                dxold = dx;
                dx = (xh - xl) / 2.0;
                this.root_ = xl + dx;
            } else {
                dxold = dx;
                dx = froot / dfroot;
                this.root_ -= dx;
            }
            if (Math.abs(dx) < xAccuracy) {
                return this.root_;
            }
            froot = f.evaluate(this.root_);
            dfroot = f.derivative(this.root_);
            ++this.evaluationNumber_;
            if (froot < 0.0) {
                xl = this.root_;
                continue;
            }
            xh = this.root_;
        }
        throw new ArithmeticException("maximum number of function evaluations (" + this.getMaxEvaluations() + ") exceeded");
    }
}

