/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.updatesite;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.updatesite.Activator;
import org.eclipse.equinox.internal.p2.updatesite.SiteCategory;
import org.eclipse.equinox.internal.p2.updatesite.SiteFeature;
import org.eclipse.equinox.internal.p2.updatesite.SiteModel;
import org.eclipse.equinox.internal.p2.updatesite.UpdateSite;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.equinox.internal.provisional.p2.core.VersionRange;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.MetadataFactory;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.LatestIUVersionQuery;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.CompositeQuery;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.equinox.p2.publisher.AbstractPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.eclipse.URLEntry;
import org.eclipse.equinox.spi.p2.publisher.LocalizationHelper;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;

public class SiteXMLAction
extends AbstractPublisherAction {
    private static final String QUALIFIER = "qualifier";
    protected UpdateSite updateSite;
    private SiteCategory defaultCategory;
    private HashSet defaultCategorySet;
    protected URI location;
    private String categoryQualifier = null;

    public SiteXMLAction(URI location, String categoryQualifier) {
        this.location = location;
        this.categoryQualifier = categoryQualifier;
    }

    public SiteXMLAction(UpdateSite updateSite, String categoryQualifier) {
        this.updateSite = updateSite;
        this.categoryQualifier = categoryQualifier;
    }

    private void initialize() {
        if (this.defaultCategory != null) {
            return;
        }
        this.defaultCategory = new SiteCategory();
        this.defaultCategory.setDescription("Default category for otherwise uncategorized features");
        this.defaultCategory.setLabel("Uncategorized");
        this.defaultCategory.setName("Default");
        this.defaultCategorySet = new HashSet(1);
        this.defaultCategorySet.add(this.defaultCategory);
    }

    public IStatus perform(IPublisherInfo info, IPublisherResult results, IProgressMonitor monitor) {
        if (this.updateSite == null) {
            try {
                this.updateSite = UpdateSite.load(this.location, monitor);
            }
            catch (ProvisionException e) {
                return new Status(4, Activator.ID, "Error generating site xml action.", (Throwable)e);
            }
            catch (OperationCanceledException operationCanceledException) {
                return Status.CANCEL_STATUS;
            }
        }
        this.initialize();
        return this.generateCategories(info, results, monitor);
    }

    private IStatus generateCategories(IPublisherInfo info, IPublisherResult results, IProgressMonitor monitor) {
        HashMap<SiteCategory, HashSet<IInstallableUnit>> categoriesToFeatureIUs = new HashMap<SiteCategory, HashSet<IInstallableUnit>>();
        Map featuresToCategories = this.getFeatureToCategoryMappings(info);
        Iterator i = featuresToCategories.keySet().iterator();
        while (i.hasNext()) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            SiteFeature feature = (SiteFeature)i.next();
            IInstallableUnit iu = this.getFeatureIU(feature, info, results);
            if (iu == null) continue;
            Set categories = (Set)featuresToCategories.get(feature);
            if (categories == null || categories.isEmpty()) {
                categories = this.defaultCategorySet;
            }
            Iterator it = categories.iterator();
            while (it.hasNext()) {
                SiteCategory category = (SiteCategory)it.next();
                HashSet<IInstallableUnit> featureIUs = (HashSet<IInstallableUnit>)categoriesToFeatureIUs.get(category);
                if (featureIUs == null) {
                    featureIUs = new HashSet<IInstallableUnit>();
                    categoriesToFeatureIUs.put(category, featureIUs);
                }
                featureIUs.add(iu);
            }
        }
        this.generateCategoryIUs(categoriesToFeatureIUs, results);
        return Status.OK_STATUS;
    }

    private IInstallableUnit getFeatureIU(SiteFeature feature, IPublisherInfo publisherInfo, IPublisherResult results) {
        String id = String.valueOf(feature.getFeatureIdentifier()) + ".feature.group";
        String versionString = feature.getFeatureVersion();
        Version version = versionString != null && versionString.length() > 0 ? new Version(versionString) : Version.emptyVersion;
        InstallableUnitQuery query = null;
        Collector collector = null;
        if (version.equals((Object)Version.emptyVersion)) {
            query = new CompositeQuery(new Query[]{new InstallableUnitQuery(id), new LatestIUVersionQuery()});
            collector = new Collector();
        } else if (version.getQualifier() != null && version.getQualifier().endsWith(QUALIFIER)) {
            String v = versionString.substring(0, versionString.indexOf(QUALIFIER));
            InstallableUnitQuery qualifierQuery = new InstallableUnitQuery(id, v){
                private String qualifierVersion;
                {
                    this.qualifierVersion = string.endsWith(".") ? string.substring(0, string.length() - 1) : string;
                }

                public boolean isMatch(Object object) {
                    if (super.isMatch(object)) {
                        IInstallableUnit candidate = (IInstallableUnit)object;
                        return candidate.getVersion().toString().startsWith(this.qualifierVersion);
                    }
                    return false;
                }
            };
            query = new CompositeQuery(new Query[]{qualifierQuery, new LatestIUVersionQuery()});
            collector = new Collector();
        } else {
            query = new InstallableUnitQuery(id, version);
            collector = new Collector(){

                public boolean accept(Object object) {
                    super.accept(object);
                    return false;
                }
            };
        }
        collector = results.query((Query)query, collector, null);
        if (collector.size() == 0) {
            collector = publisherInfo.getMetadataRepository().query((Query)query, collector, null);
        }
        if (collector.size() == 0 && publisherInfo.getContextMetadataRepository() != null) {
            collector = publisherInfo.getContextMetadataRepository().query((Query)query, collector, null);
        }
        if (collector.size() == 1) {
            return (IInstallableUnit)collector.iterator().next();
        }
        return null;
    }

    protected Map getFeatureToCategoryMappings(IPublisherInfo info) {
        File siteFile;
        URLEntry[] associatedSites;
        HashMap mappings = new HashMap();
        if (this.updateSite == null) {
            return mappings;
        }
        SiteModel site = this.updateSite.getSite();
        if (site == null) {
            return mappings;
        }
        String mirrors = site.getMirrorsURI();
        if (mirrors != null) {
            int index = mirrors.indexOf("site.xml");
            if (index != -1) {
                mirrors = String.valueOf(mirrors.substring(0, index)) + mirrors.substring(index + "site.xml".length());
            }
            info.getMetadataRepository().setProperty("p2.mirrorsURL", mirrors);
            if (info.getArtifactRepository() != null) {
                info.getArtifactRepository().setProperty("p2.mirrorsURL", mirrors);
            }
        }
        if ((associatedSites = site.getAssociatedSites()) != null) {
            int i = 0;
            while (i < associatedSites.length) {
                this.generateSiteReference(associatedSites[i].getURL(), associatedSites[i].getAnnotation(), null, info.getMetadataRepository());
                ++i;
            }
        }
        if ((siteFile = URIUtil.toFile((URI)this.updateSite.getLocation())) != null && siteFile.exists()) {
            String[] keyStrings;
            File siteParent = siteFile.getParentFile();
            List messageKeys = site.getMessageKeys();
            if (siteParent.isDirectory()) {
                keyStrings = messageKeys.toArray(new String[messageKeys.size()]);
                site.setLocalizations(LocalizationHelper.getDirPropertyLocalizations((File)siteParent, (String)"site", null, (String[])keyStrings));
            } else if (siteFile.getName().endsWith(".jar")) {
                keyStrings = messageKeys.toArray(new String[messageKeys.size()]);
                site.setLocalizations(LocalizationHelper.getJarPropertyLocalizations((File)siteParent, (String)"site", null, (String[])keyStrings));
            }
        }
        SiteFeature[] features = site.getFeatures();
        int i = 0;
        while (i < features.length) {
            String[] categoryNames = features[i].getCategoryNames();
            HashSet<SiteCategory> categories = new HashSet<SiteCategory>();
            mappings.put(features[i], categories);
            int j = 0;
            while (j < categoryNames.length) {
                SiteCategory category = site.getCategory(categoryNames[j]);
                if (category != null) {
                    categories.add(category);
                }
                ++j;
            }
            ++i;
        }
        return mappings;
    }

    private void generateSiteReference(String location, String label, String featureId, IMetadataRepository metadataRepo) {
        if (metadataRepo == null) {
            return;
        }
        try {
            URI associateLocation = new URI(location);
            metadataRepo.addReference(associateLocation, label, 0, 1);
            metadataRepo.addReference(associateLocation, label, 1, 1);
        }
        catch (URISyntaxException uRISyntaxException) {
            String message = "Invalid site reference: " + location;
            if (featureId != null) {
                message = String.valueOf(message) + " in feature: " + featureId;
            }
            LogHelper.log((IStatus)new Status(4, Activator.ID, message));
        }
    }

    protected void generateCategoryIUs(Map categoriesToFeatures, IPublisherResult result) {
        Iterator it = categoriesToFeatures.keySet().iterator();
        while (it.hasNext()) {
            SiteCategory category = (SiteCategory)it.next();
            result.addIU(this.createCategoryIU(category, (Set)categoriesToFeatures.get(category), null), "non_root");
        }
    }

    public IInstallableUnit createCategoryIU(SiteCategory category, Set featureIUs, IInstallableUnit parentCategory) {
        MetadataFactory.InstallableUnitDescription cat = new MetadataFactory.InstallableUnitDescription();
        cat.setSingleton(true);
        String categoryId = this.buildCategoryId(category.getName());
        cat.setId(categoryId);
        cat.setVersion(Version.createOSGi((int)0, (int)0, (int)0, (String)SiteXMLAction.getDateQualifier()));
        String label = category.getLabel();
        cat.setProperty("org.eclipse.equinox.p2.name", label != null ? label : category.getName());
        cat.setProperty("org.eclipse.equinox.p2.description", category.getDescription());
        ArrayList<IRequiredCapability> reqsConfigurationUnits = new ArrayList<IRequiredCapability>(featureIUs.size());
        Iterator iterator = featureIUs.iterator();
        while (iterator.hasNext()) {
            IInstallableUnit iu = (IInstallableUnit)iterator.next();
            VersionRange range = new VersionRange(iu.getVersion(), true, iu.getVersion(), true);
            reqsConfigurationUnits.add(MetadataFactory.createRequiredCapability((String)"org.eclipse.equinox.p2.iu", (String)iu.getId(), (VersionRange)range, (String)iu.getFilter(), (boolean)false, (boolean)false));
        }
        if (parentCategory != null) {
            reqsConfigurationUnits.add(MetadataFactory.createRequiredCapability((String)"org.eclipse.equinox.p2.iu", (String)parentCategory.getId(), (VersionRange)VersionRange.emptyRange, (String)parentCategory.getFilter(), (boolean)false, (boolean)false));
        }
        cat.setRequiredCapabilities(reqsConfigurationUnits.toArray(new IRequiredCapability[reqsConfigurationUnits.size()]));
        ArrayList<IProvidedCapability> providedCapabilities = new ArrayList<IProvidedCapability>();
        providedCapabilities.add(PublisherHelper.createSelfCapability((String)categoryId, (Version)cat.getVersion()));
        Map localizations = category.getLocalizations();
        if (localizations != null) {
            Iterator iter = localizations.keySet().iterator();
            while (iter.hasNext()) {
                Locale locale = (Locale)iter.next();
                Properties translatedStrings = (Properties)localizations.get(locale);
                Enumeration<?> propertyKeys = translatedStrings.propertyNames();
                while (propertyKeys.hasMoreElements()) {
                    String nextKey = (String)propertyKeys.nextElement();
                    cat.setProperty(String.valueOf(locale.toString()) + '.' + nextKey, translatedStrings.getProperty(nextKey));
                }
                providedCapabilities.add(PublisherHelper.makeTranslationCapability((String)categoryId, (Locale)locale));
            }
        }
        cat.setCapabilities(providedCapabilities.toArray(new IProvidedCapability[providedCapabilities.size()]));
        cat.setArtifacts(new IArtifactKey[0]);
        cat.setProperty("org.eclipse.equinox.p2.type.category", "true");
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)cat);
    }

    private String buildCategoryId(String categoryName) {
        if (this.categoryQualifier != null) {
            if (this.categoryQualifier.length() > 0) {
                return String.valueOf(this.categoryQualifier) + "." + categoryName;
            }
            return categoryName;
        }
        if (this.updateSite != null) {
            return String.valueOf(URIUtil.toUnencodedString((URI)this.updateSite.getLocation())) + "." + categoryName;
        }
        return categoryName;
    }

    private static String getDateQualifier() {
        Calendar calendar = Calendar.getInstance();
        int monthNbr = calendar.get(2) + 1;
        String month = String.valueOf(monthNbr < 10 ? "0" : "") + monthNbr;
        int dayNbr = calendar.get(5);
        String day = String.valueOf(dayNbr < 10 ? "0" : "") + dayNbr;
        int hourNbr = calendar.get(11);
        String hour = String.valueOf(hourNbr < 10 ? "0" : "") + hourNbr;
        int minuteNbr = calendar.get(12);
        String minute = String.valueOf(minuteNbr < 10 ? "0" : "") + minuteNbr;
        int secondNbr = calendar.get(13);
        String second = String.valueOf(secondNbr < 10 ? "0" : "") + secondNbr;
        return calendar.get(1) + month + day + hour + minute + second;
    }
}

