/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.Bitmap;
import netscape.application.Color;
import netscape.application.ColorChooser;
import netscape.application.DragDestination;
import netscape.application.DragSession;
import netscape.application.DragWell;
import netscape.application.Graphics;
import netscape.application.Image;
import netscape.application.MouseEvent;
import netscape.application.Rect;
import netscape.application.Target;
import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;
import netscape.util.InconsistencyException;

public class ColorWell
extends DragWell
implements DragDestination,
Target {
    Target target;
    String command;
    int origX;
    int origY;
    static final String TARGET_KEY = "target";
    static final String COMMAND_KEY = "command";
    public static final String SHOW_COLOR_CHOOSER = "showColorChooser";

    public ColorWell() {
        this(0, 0, 0, 0);
    }

    public ColorWell(Rect rect) {
        this(rect.x, rect.y, rect.width, rect.height);
    }

    public ColorWell(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this.setColor(Color.blue);
        this._setupKeyboard();
    }

    public void setColor(Color color) {
        if (color != null) {
            this.setData(color);
            this.draw();
        }
    }

    public Color color() {
        return (Color)this.data();
    }

    public void setData(Object object) {
        if (!(object instanceof Color)) {
            throw new InconsistencyException("ColorWells can only contain colors");
        }
        super.setData(object);
    }

    public Image image() {
        Bitmap bitmap = new Bitmap(12, 12);
        Graphics graphics = new Graphics(bitmap);
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, 12, 12);
        graphics.setColor((Color)this.data);
        graphics.fillRect(1, 1, 10, 10);
        graphics.dispose();
        bitmap.setTransparent(false);
        return bitmap;
    }

    public void setImage(Image image) {
        throw new InconsistencyException("Can't set image on ColorWell");
    }

    public void setDataType(String string) {
        throw new InconsistencyException("Can't set data type on ColorWell");
    }

    public String dataType() {
        return "netscape.application.Color";
    }

    public void setTarget(Target target) {
        this.target = target;
    }

    public Target target() {
        return this.target;
    }

    public void setCommand(String string) {
        this.command = string;
    }

    public String command() {
        return this.command;
    }

    public void drawView(Graphics graphics) {
        graphics.setColor(this.color());
        graphics.fillRect(this.border.leftMargin(), this.border.topMargin(), this.bounds.width - this.border.widthMargin(), this.bounds.height - this.border.heightMargin());
        this.border.drawInRect(graphics, 0, 0, this.bounds.width, this.bounds.height);
    }

    public boolean mouseDown(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return false;
        }
        this.origX = mouseEvent.x;
        this.origY = mouseEvent.y;
        return true;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (Math.abs(mouseEvent.x - this.origX) > 3 || Math.abs(mouseEvent.y - this.origY) > 3) {
            new DragSession(this, this.image(), mouseEvent.x - 6, mouseEvent.y - 6, mouseEvent.x, mouseEvent.y, this.dataType(), this.data);
        }
    }

    public void mouseUp(MouseEvent mouseEvent) {
        ColorChooser colorChooser = this.rootView().colorChooser();
        colorChooser.setColor(this.color());
        this.rootView().showColorChooser();
    }

    public DragDestination acceptsDrag(DragSession dragSession, int n, int n2) {
        if ("netscape.application.Color".equals(dragSession.dataType())) {
            return this;
        }
        return null;
    }

    public boolean dragEntered(DragSession dragSession) {
        return true;
    }

    public boolean dragMoved(DragSession dragSession) {
        return true;
    }

    public void dragExited(DragSession dragSession) {
    }

    public boolean dragDropped(DragSession dragSession) {
        if (!this.isEnabled() || dragSession.source() == this) {
            return false;
        }
        Object object = dragSession.data();
        if (object == null || !(object instanceof Color)) {
            return false;
        }
        this.setColor((Color)object);
        this.sendCommand();
        return true;
    }

    public void sendCommand() {
        if (this.target != null) {
            this.target.performCommand(this.command, this);
        }
    }

    public void performCommand(String string, Object object) {
        if (SHOW_COLOR_CHOOSER.equals(string) && this.rootView() != null) {
            this.rootView().showColorChooser();
        }
    }

    public void describeClassInfo(ClassInfo classInfo) {
        super.describeClassInfo(classInfo);
        classInfo.addClass("netscape.application.ColorWell", 1);
        classInfo.addField(TARGET_KEY, (byte)18);
        classInfo.addField(COMMAND_KEY, (byte)16);
    }

    public void encode(Encoder encoder) throws CodingException {
        super.encode(encoder);
        encoder.encodeObject(TARGET_KEY, (Codable)((Object)this.target));
        encoder.encodeString(COMMAND_KEY, this.command);
    }

    public void decode(Decoder decoder) throws CodingException {
        super.decode(decoder);
        this.target = (Target)decoder.decodeObject(TARGET_KEY);
        this.command = decoder.decodeString(COMMAND_KEY);
    }

    void _setupKeyboard() {
        this.removeAllCommandsForKeys();
        this.setCommandForKey(SHOW_COLOR_CHOOSER, 10, 0);
    }

    public boolean canBecomeSelectedView() {
        return true;
    }
}

