/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.Graphics;
import netscape.application.Image;
import netscape.application.ListItem;
import netscape.application.Popup;
import netscape.application.Rect;
import netscape.util.ClassInfo;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;

public class PopupItem
extends ListItem {
    Popup popup;
    static final String POPUP_KEY = "popup";

    public void setPopup(Popup popup) {
        this.popup = popup;
    }

    public Popup popup() {
        return this.popup;
    }

    public void drawInRect(Graphics graphics, Rect rect) {
        PopupItem popupItem;
        super.drawInRect(graphics, rect);
        if (this.popup != null && (popupItem = (PopupItem)this.popup.selectedItem()).equals(this)) {
            int n;
            int n2;
            Image image = this.popup.popupImage();
            if (image != null) {
                n2 = image.width();
                n = image.height();
            } else {
                n = 0;
                n2 = 0;
            }
            if (this.selected) {
                graphics.setColor(this.selectedColor);
            } else {
                graphics.setColor(this.listView.backgroundColor());
            }
            graphics.fillRect(rect.x + rect.width - n2 - 4, rect.y, n2 + 4, rect.height);
            if (image != null) {
                image.drawAt(graphics, rect.x + rect.width - n2 - 2, rect.y + (rect.height - n) / 2);
            }
        }
    }

    public void describeClassInfo(ClassInfo classInfo) {
        super.describeClassInfo(classInfo);
        classInfo.addClass("netscape.application.PopupItem", 1);
        classInfo.addField(POPUP_KEY, (byte)18);
    }

    public void encode(Encoder encoder) throws CodingException {
        super.encode(encoder);
        encoder.encodeObject(POPUP_KEY, this.popup);
    }

    public void decode(Decoder decoder) throws CodingException {
        super.decode(decoder);
        this.popup = (Popup)decoder.decodeObject(POPUP_KEY);
    }
}

