/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;
import netscape.util.Vector;

public class Size
implements Codable {
    public int width;
    public int height;
    private static Vector _sizeCache = new Vector();
    private static boolean _cacheSizes = true;
    static final String WIDTH_KEY = "width";
    static final String HEIGHT_KEY = "height";

    public Size() {
    }

    public Size(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public Size(Size size) {
        this.width = size.width;
        this.height = size.height;
    }

    public boolean isEmpty() {
        return this.width == 0 || this.height == 0;
    }

    public String toString() {
        return "(" + this.width + ", " + this.height + ")";
    }

    public void sizeTo(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public void sizeBy(int n, int n2) {
        this.sizeTo(this.width + n, this.height + n2);
    }

    public void union(Size size) {
        if (this.width < size.width) {
            this.width = size.width;
        }
        if (this.height < size.height) {
            this.height = size.height;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof Size)) {
            return false;
        }
        Size size = (Size)object;
        return size.width == this.width && size.height == this.height;
    }

    public int hashCode() {
        return this.width ^ this.height;
    }

    public void describeClassInfo(ClassInfo classInfo) {
        classInfo.addClass("netscape.application.Size", 1);
        classInfo.addField(WIDTH_KEY, (byte)8);
        classInfo.addField(HEIGHT_KEY, (byte)8);
    }

    public void encode(Encoder encoder) throws CodingException {
        encoder.encodeInt(WIDTH_KEY, this.width);
        encoder.encodeInt(HEIGHT_KEY, this.height);
    }

    public void decode(Decoder decoder) throws CodingException {
        this.width = decoder.decodeInt(WIDTH_KEY);
        this.height = decoder.decodeInt(HEIGHT_KEY);
    }

    public void finishDecoding() throws CodingException {
    }

    static Size newSize(int n, int n2) {
        Size size;
        Vector vector = _sizeCache;
        synchronized (vector) {
            if (!_cacheSizes || _sizeCache.isEmpty()) {
                Size size2 = new Size(n, n2);
                Object var4_4 = null;
                return size2;
            }
            size = (Size)_sizeCache.removeLastElement();
        }
        size.sizeTo(n, n2);
        return size;
    }

    static Size newSize(Size size) {
        if (size == null) {
            return Size.newSize(0, 0);
        }
        return Size.newSize(size.width, size.height);
    }

    static Size newSize() {
        return Size.newSize(0, 0);
    }

    static void returnSize(Size size) {
        if (!_cacheSizes) {
            return;
        }
        Vector vector = _sizeCache;
        synchronized (vector) {
            if (_sizeCache.count() < 30) {
                _sizeCache.addElement(size);
            }
            return;
        }
    }

    static void returnSizes(Vector vector) {
        if (vector == null || !_cacheSizes) {
            return;
        }
        int n = vector.count();
        while (n-- > 0) {
            Size.returnSize((Size)vector.elementAt(n));
        }
        vector.removeAllElements();
    }

    static void setShouldCacheSizes(boolean bl) {
        Vector vector = _sizeCache;
        synchronized (vector) {
            _cacheSizes = bl;
            if (!_cacheSizes) {
                _sizeCache.removeAllElements();
            }
            return;
        }
    }
}

