/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.distributions;

import org.jquantlib.math.UnaryFunctionInteger;
import org.jquantlib.math.distributions.IncompleteGamma;

public class CumulativePoissonDistribution
implements UnaryFunctionInteger {
    private static final double accuracy = 1.0E-15;
    private static final int maxIteration = 100;
    private final double mu;

    public CumulativePoissonDistribution(double mu) {
        this.mu = mu;
    }

    @Override
    public double evaluate(int k) {
        if (k < 0) {
            throw new ArithmeticException("k must be >= 1, but is " + k);
        }
        IncompleteGamma incmplgamma = new IncompleteGamma();
        return 1.0 - incmplgamma.incompleteGammaFunction((double)k + 1.0, this.mu, 1.0E-15, 100);
    }
}

