/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures.yieldcurves;

import org.jquantlib.daycounters.Actual365Fixed;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.calendars.Target;
import org.jquantlib.util.Date;

public abstract class ZeroYieldStructure
extends YieldTermStructure {
    public ZeroYieldStructure() {
        this(Actual365Fixed.getDayCounter());
    }

    public ZeroYieldStructure(DayCounter dc) {
        super(dc);
        throw new UnsupportedOperationException("Work in progress");
    }

    public ZeroYieldStructure(Date refDate, Calendar cal) {
        this(refDate, cal, (DayCounter)Actual365Fixed.getDayCounter());
    }

    public ZeroYieldStructure(Date refDate, DayCounter dc) {
        this(refDate, (Calendar)Target.getCalendar(), dc);
    }

    public ZeroYieldStructure(Date refDate) {
        this(refDate, (Calendar)Target.getCalendar(), (DayCounter)Actual365Fixed.getDayCounter());
    }

    public ZeroYieldStructure(Date refDate, Calendar cal, DayCounter dc) {
        super(refDate, cal, dc);
        throw new UnsupportedOperationException("Work in progress");
    }

    public ZeroYieldStructure(int settlementDays, Calendar cal) {
        this(settlementDays, cal, (DayCounter)Actual365Fixed.getDayCounter());
    }

    public ZeroYieldStructure(int settlementDays, Calendar cal, DayCounter dc) {
        super(settlementDays, cal, dc);
        throw new UnsupportedOperationException("Work in progress");
    }

    @Override
    protected final double discountImpl(double t) {
        double r = this.zeroYieldImpl(t);
        return Math.exp(-r * t);
    }

    protected abstract double zeroYieldImpl(double var1);
}

