package aQute.lib.bundle.support;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;

class ConsoleInputStream extends InputStream {
	Console	console;

	ConsoleInputStream(Console console) {
		this.console = console;
	}

	public int read() {
		return console.read();
	}
}

class ConsoleOutputStream extends OutputStream {
	Console	console;

	ConsoleOutputStream(Console console) {
		this.console = console;
	}

	public void write(int c) {
		System.out.println("x" + (char) c);
		console.append("" + (char) c);
	}
}

public class Console extends TextArea implements KeyListener {
	String				line;
	Vector				history;
	char				buffer[]	= new char[1024];
	int					inp;
	int					outp;
	ConsoleInputStream	in;
	ConsoleOutputStream	out;
	Frame				frame;
	String				name;

	public Console(String name) {
		super(24, 80);
		this.name = name;
		setFont(new Font("Monospaces", Font.PLAIN, 12));
		setEditable(true);
		addKeyListener(this);
		prompt();
		in = new ConsoleInputStream(this);
		out = new ConsoleOutputStream(this);
	}

	void open() {
		if (frame == null) {
			frame = new Frame(name);
			frame.setBounds(100, 100, 400, 400);
			frame.add(this);
			frame.pack();
		}
		frame.show();
		requestFocus();
	}

	ConsoleInputStream getInputStream() {
		return in;
	}

	ConsoleOutputStream getOutputStream() {
		return out;
	}

	synchronized char read() {
		try {
			while (inp == outp)
				wait();

			char c = buffer[outp];
			outp = (outp + 1) % buffer.length;
			notify();
			return c;
		} catch (InterruptedException e) {
			return 0;
		}
	}

	synchronized void write(char c) {
		int t = (inp + 1) % buffer.length;
		if (t == outp)
			return;

		buffer[t] = c;
		inp = t;
		notify();
	}

	void prompt() {
		print("> ");
	}

	public void keyPressed(KeyEvent keyevent) {
		write(keyevent.getKeyChar());
		keyevent.consume();
	}

	public void println(String s) {
		print(s + "\n");
	}

	public synchronized void print(String s) {
		append(s);
	}

	public void keyTyped(KeyEvent keyevent) {
	}

	public void keyReleased(KeyEvent keyevent) {
	}
}