/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.PropMap;
import com.sun.java.util.jar.pack.UnpackerImpl;
import com.sun.java.util.jar.pack.Utils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarOutputStream;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;

class NativeUnpack {
    private long unpackerPtr;
    private BufferedInputStream in;
    private int _verbose;
    private long _byteCount;
    private int _segCount;
    private int _fileCount;
    private long _estByteLimit;
    private int _estSegLimit;
    private int _estFileLimit;
    private int _prevPercent = -1;
    private final CRC32 _crc32 = new CRC32();
    private static final int MAX_BUFFER_SIZE = 0x100000;
    private byte[] _buf = new byte[16384];
    private List<byte[]> _extra_buf = new LinkedList<byte[]>();
    private byte[] _current_buf;
    private int _current_buf_pos;
    private UnpackerImpl _p200;
    private PropMap _props;

    private static synchronized native void initIDs();

    private synchronized native long start(ByteBuffer var1, long var2);

    private synchronized native boolean getNextFile(Object[] var1);

    private synchronized native ByteBuffer getUnusedInput();

    synchronized native long finish();

    protected synchronized native boolean setOption(String var1, String var2);

    protected synchronized native String getOption(String var1);

    NativeUnpack(UnpackerImpl unpackerImpl) {
        this._p200 = unpackerImpl;
        this._props = unpackerImpl.props;
        unpackerImpl._nunp = this;
    }

    private static Object currentInstance() {
        UnpackerImpl unpackerImpl = (UnpackerImpl)Utils.getTLGlobals();
        return unpackerImpl == null ? null : unpackerImpl._nunp;
    }

    private synchronized long getUnpackerPtr() {
        return this.unpackerPtr;
    }

    private long readInputFn(ByteBuffer byteBuffer, long l) throws IOException {
        if (this.in == null) {
            return 0L;
        }
        long l2 = byteBuffer.capacity() - byteBuffer.position();
        assert (l <= l2);
        long l3 = 0L;
        int n = 0;
        while (l3 < l) {
            int n2;
            ++n;
            int n3 = this._buf.length;
            if ((long)n3 > l2 - l3) {
                n3 = (int)(l2 - l3);
            }
            if ((n2 = this.in.read(this._buf, 0, n3)) <= 0) break;
            assert ((l3 += (long)n2) <= l2);
            byteBuffer.put(this._buf, 0, n2);
        }
        if (this._verbose > 1) {
            Utils.log.fine("readInputFn(" + l + "," + l2 + ") => " + l3 + " steps=" + n);
        }
        this._estByteLimit = l2 > 100L ? this._byteCount + l2 : (this._byteCount + l3) * 20L;
        this._byteCount += l3;
        this.updateProgress();
        return l3;
    }

    private void updateProgress() {
        double d = this._segCount;
        if (this._estByteLimit > 0L && this._byteCount > 0L) {
            d += (double)this._byteCount / (double)this._estByteLimit;
        }
        double d2 = this._fileCount;
        double d3 = 0.33 * d / (double)Math.max(this._estSegLimit, 1) + 0.67 * d2 / (double)Math.max(this._estFileLimit, 1);
        int n = (int)Math.round(100.0 * d3);
        if (n > 100) {
            n = 100;
        }
        if (n > this._prevPercent) {
            this._prevPercent = n;
            this._props.setInteger("unpack.progress", n);
            if (this._verbose > 0) {
                Utils.log.info("progress = " + n);
            }
        }
    }

    private void copyInOption(String string) {
        boolean bl;
        String string2 = this._props.getProperty(string);
        if (this._verbose > 0) {
            Utils.log.info("set " + string + "=" + string2);
        }
        if (string2 != null && !(bl = this.setOption(string, string2))) {
            Utils.log.warning("Invalid option " + string + "=" + string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void run(InputStream inputStream, JarOutputStream jarOutputStream, ByteBuffer byteBuffer) throws IOException {
        BufferedInputStream bufferedInputStream;
        this.in = bufferedInputStream = new BufferedInputStream(inputStream);
        this._verbose = this._props.getInteger("com.sun.java.util.jar.pack.verbose");
        int n = "keep".equals(this._props.getProperty("com.sun.java.util.jar.pack.unpack.modification.time", "0")) ? 0 : this._props.getTime("com.sun.java.util.jar.pack.unpack.modification.time");
        this.copyInOption("com.sun.java.util.jar.pack.verbose");
        this.copyInOption("unpack.deflate.hint");
        if (n == 0) {
            this.copyInOption("com.sun.java.util.jar.pack.unpack.modification.time");
        }
        this.updateProgress();
        while (true) {
            long l;
            long l2 = this.start(byteBuffer, 0L);
            try {
                this._estByteLimit = 0L;
                this._byteCount = 0L;
                ++this._segCount;
                int n2 = (int)(l2 >>> 32);
                int n3 = (int)(l2 >>> 0);
                this._estSegLimit = this._segCount + n2;
                double d = this._fileCount + n3;
                this._estFileLimit = (int)(d * (double)this._estSegLimit / (double)this._segCount);
                int[] nArray = new int[]{0, 0, 0, 0};
                Object[] objectArray = new Object[]{nArray, null, null, null};
                while (this.getNextFile(objectArray)) {
                    String string = (String)objectArray[1];
                    long l3 = ((long)nArray[0] << 32) + ((long)nArray[1] << 32 >>> 32);
                    long l4 = n != 0 ? (long)n : (long)nArray[2];
                    boolean bl = nArray[3] != 0;
                    ByteBuffer byteBuffer2 = (ByteBuffer)objectArray[2];
                    ByteBuffer byteBuffer3 = (ByteBuffer)objectArray[3];
                    this.writeEntry(jarOutputStream, string, l4, l3, bl, byteBuffer2, byteBuffer3);
                    ++this._fileCount;
                    this.updateProgress();
                }
                byteBuffer = this.getUnusedInput();
            }
            finally {
                l = this.finish();
            }
            if (this._verbose > 0) {
                Utils.log.info("bytes consumed = " + l);
            }
            if (byteBuffer == null && !Utils.isPackMagic(Utils.readMagic(bufferedInputStream))) break;
            if (this._verbose <= 0 || byteBuffer == null) continue;
            Utils.log.info("unused input = " + byteBuffer);
        }
    }

    void run(InputStream inputStream, JarOutputStream jarOutputStream) throws IOException {
        this.run(inputStream, jarOutputStream, null);
    }

    void run(File file, JarOutputStream jarOutputStream) throws IOException {
        ByteBuffer byteBuffer = null;
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            this.run(fileInputStream, jarOutputStream, byteBuffer);
        }
    }

    private void writeEntry(JarOutputStream jarOutputStream, String string, long l, long l2, boolean bl, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws IOException {
        if (l2 < 0L || l2 > Integer.MAX_VALUE) {
            throw new IOException("file too large: " + l2);
        }
        int n = (int)l2;
        if (this._verbose > 1) {
            Utils.log.fine("Writing entry: " + string + " size=" + n + (bl ? " deflated" : ""));
        }
        ZipEntry zipEntry = new ZipEntry(string);
        zipEntry.setTime(l * 1000L);
        zipEntry.setSize(n);
        if (n == 0) {
            zipEntry.setMethod(0);
            zipEntry.setCompressedSize(n);
            zipEntry.setCrc(0L);
            jarOutputStream.putNextEntry(zipEntry);
        } else if (!bl) {
            zipEntry.setMethod(0);
            zipEntry.setCompressedSize(n);
            this.writeEntryData(jarOutputStream, zipEntry, byteBuffer, byteBuffer2, n, true);
        } else {
            zipEntry.setMethod(8);
            this.writeEntryData(jarOutputStream, zipEntry, byteBuffer, byteBuffer2, n, false);
        }
        jarOutputStream.closeEntry();
        if (this._verbose > 0) {
            Utils.log.info("Writing " + Utils.zeString(zipEntry));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeEntryData(JarOutputStream jarOutputStream, ZipEntry zipEntry, ByteBuffer byteBuffer, ByteBuffer byteBuffer2, int n3, boolean bl) throws IOException {
        this.prepareReadBuffers(n3);
        try {
            int n4 = n3;
            n4 -= this.readDataByteBuffer(byteBuffer);
            n4 -= this.readDataByteBuffer(byteBuffer2);
            n4 -= this.readDataInputStream(n4);
            if ((long)n4 != 0L) {
                throw new IOException("invalid size: " + n3);
            }
            if (bl) {
                this._crc32.reset();
                this.processReadData((byArray, n, n2) -> this._crc32.update(byArray, n, n2));
                zipEntry.setCrc(this._crc32.getValue());
            }
            jarOutputStream.putNextEntry(zipEntry);
            this.processReadData((byArray, n, n2) -> jarOutputStream.write(byArray, n, n2));
        }
        finally {
            this.resetReadBuffers();
        }
    }

    private void prepareReadBuffers(int n) {
        if (this._buf.length < n && this._buf.length < 0x100000) {
            long l;
            for (l = (long)this._buf.length; l < (long)n && l < 0x100000L; l <<= 1) {
            }
            int n2 = (int)Long.min(l, 0x100000L);
            this._buf = new byte[n2];
        }
        this.resetReadBuffers();
    }

    private void resetReadBuffers() {
        this._extra_buf.clear();
        this._current_buf = this._buf;
        this._current_buf_pos = 0;
    }

    private int readDataByteBuffer(ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer == null) {
            return 0;
        }
        return this.readData(byteBuffer.remaining(), (byArray, n, n2) -> {
            byteBuffer.get(byArray, n, n2);
            return n2;
        });
    }

    private int readDataInputStream(int n3) throws IOException {
        return this.readData(n3, (byArray, n, n2) -> this.in.read(byArray, n, n2));
    }

    private int readData(int n, ReadDataCB readDataCB) throws IOException {
        int n2;
        int n3;
        for (n2 = n; n2 > 0; n2 -= n3) {
            int n4;
            int n5;
            if (this._current_buf_pos == this._current_buf.length) {
                byte[] byArray = new byte[Integer.min(n2, 0x100000)];
                this._extra_buf.add(byArray);
                this._current_buf = byArray;
                this._current_buf_pos = 0;
            }
            if ((n3 = readDataCB.read(this._current_buf, this._current_buf_pos, n5 = Integer.min(n4 = this._current_buf.length - this._current_buf_pos, n2))) <= 0) {
                throw new IOException("EOF at end of archive");
            }
            this._current_buf_pos += n3;
        }
        return n - n2;
    }

    private void processReadData(ProcessDataCB processDataCB) throws IOException {
        processDataCB.apply(this._buf, 0, this._buf == this._current_buf ? this._current_buf_pos : this._buf.length);
        for (byte[] byArray : this._extra_buf) {
            processDataCB.apply(byArray, 0, byArray.length);
        }
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("unpack");
                return null;
            }
        });
        NativeUnpack.initIDs();
    }

    private static interface ProcessDataCB {
        public void apply(byte[] var1, int var2, int var3) throws IOException;
    }

    private static interface ReadDataCB {
        public int read(byte[] var1, int var2, int var3) throws IOException;
    }
}

