/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Vector;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.Config;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.internal.HostAddress;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.ccache.CCacheOutputStream;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class HostAddresses
implements Cloneable {
    private static boolean DEBUG = Krb5.DEBUG;
    private HostAddress[] addresses = null;
    private volatile int hashCode = 0;

    public HostAddresses(HostAddress[] hostAddressArray) throws IOException {
        if (hostAddressArray != null) {
            this.addresses = new HostAddress[hostAddressArray.length];
            for (int i = 0; i < hostAddressArray.length; ++i) {
                if (hostAddressArray[i] == null) {
                    throw new IOException("Cannot create a HostAddress");
                }
                this.addresses[i] = (HostAddress)hostAddressArray[i].clone();
            }
        }
    }

    public HostAddresses() throws UnknownHostException {
        this.addresses = new HostAddress[1];
        this.addresses[0] = new HostAddress();
    }

    private HostAddresses(int n) {
    }

    public HostAddresses(PrincipalName principalName) throws UnknownHostException, KrbException {
        String[] stringArray = principalName.getNameStrings();
        if (principalName.getNameType() != 3 || stringArray.length < 2) {
            throw new KrbException(60, "Bad name");
        }
        String string = stringArray[1];
        InetAddress[] inetAddressArray = InetAddress.getAllByName(string);
        HostAddress[] hostAddressArray = new HostAddress[inetAddressArray.length];
        for (int i = 0; i < inetAddressArray.length; ++i) {
            hostAddressArray[i] = new HostAddress(inetAddressArray[i]);
        }
        this.addresses = hostAddressArray;
    }

    public Object clone() {
        HostAddresses hostAddresses = new HostAddresses(0);
        if (this.addresses != null) {
            hostAddresses.addresses = new HostAddress[this.addresses.length];
            for (int i = 0; i < this.addresses.length; ++i) {
                hostAddresses.addresses[i] = (HostAddress)this.addresses[i].clone();
            }
        }
        return hostAddresses;
    }

    public boolean inList(HostAddress hostAddress) {
        if (this.addresses != null) {
            for (int i = 0; i < this.addresses.length; ++i) {
                if (!this.addresses[i].equals(hostAddress)) continue;
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int n = 17;
            if (this.addresses != null) {
                for (int i = 0; i < this.addresses.length; ++i) {
                    n = 37 * n + this.addresses[i].hashCode();
                }
            }
            this.hashCode = n;
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof HostAddresses)) {
            return false;
        }
        HostAddresses hostAddresses = (HostAddresses)object;
        if (this.addresses == null && hostAddresses.addresses != null || this.addresses != null && hostAddresses.addresses == null) {
            return false;
        }
        if (this.addresses != null && hostAddresses.addresses != null) {
            if (this.addresses.length != hostAddresses.addresses.length) {
                return false;
            }
            for (int i = 0; i < this.addresses.length; ++i) {
                if (this.addresses[i].equals(hostAddresses.addresses[i])) continue;
                return false;
            }
        }
        return true;
    }

    public HostAddresses(DerValue derValue) throws Asn1Exception, IOException {
        Vector<HostAddress> vector = new Vector<HostAddress>();
        DerValue derValue2 = null;
        while (derValue.getData().available() > 0) {
            derValue2 = derValue.getData().getDerValue();
            vector.addElement(new HostAddress(derValue2));
        }
        if (vector.size() > 0) {
            this.addresses = new HostAddress[vector.size()];
            vector.copyInto(this.addresses);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        if (this.addresses != null && this.addresses.length > 0) {
            for (int i = 0; i < this.addresses.length; ++i) {
                derOutputStream.write(this.addresses[i].asn1Encode());
            }
        }
        derOutputStream2.write((byte)48, derOutputStream);
        return derOutputStream2.toByteArray();
    }

    public static HostAddresses parse(DerInputStream derInputStream, byte by, boolean bl) throws Asn1Exception, IOException {
        if (bl && ((byte)derInputStream.peekByte() & 0x1F) != by) {
            return null;
        }
        DerValue derValue = derInputStream.getDerValue();
        if (by != (derValue.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        return new HostAddresses(derValue2);
    }

    public void writeAddrs(CCacheOutputStream cCacheOutputStream) throws IOException {
        if (this.addresses == null || this.addresses.length == 0) {
            cCacheOutputStream.write32(0);
            return;
        }
        cCacheOutputStream.write32(this.addresses.length);
        for (int i = 0; i < this.addresses.length; ++i) {
            cCacheOutputStream.write16(this.addresses[i].addrType);
            cCacheOutputStream.write32(this.addresses[i].address.length);
            cCacheOutputStream.write(this.addresses[i].address, 0, this.addresses[i].address.length);
        }
    }

    public InetAddress[] getInetAddresses() {
        if (this.addresses == null || this.addresses.length == 0) {
            return null;
        }
        ArrayList<InetAddress> arrayList = new ArrayList<InetAddress>(this.addresses.length);
        for (int i = 0; i < this.addresses.length; ++i) {
            try {
                if (this.addresses[i].addrType != 2 && this.addresses[i].addrType != 24) continue;
                arrayList.add(this.addresses[i].getInetAddress());
                continue;
            }
            catch (UnknownHostException unknownHostException) {
                return null;
            }
        }
        InetAddress[] inetAddressArray = new InetAddress[arrayList.size()];
        return arrayList.toArray(inetAddressArray);
    }

    public static HostAddresses getLocalAddresses() throws IOException {
        LinkedHashSet<InetAddress> linkedHashSet = new LinkedHashSet<InetAddress>();
        try {
            String string;
            if (DEBUG) {
                System.out.println(">>> KrbKdcReq local addresses are:");
            }
            if ((string = Config.getInstance().getAll("libdefaults", "extra_addresses")) != null) {
                for (String string2 : string.split("\\s+")) {
                    linkedHashSet.add(InetAddress.getByName(string2));
                    if (!DEBUG) continue;
                    System.out.println("   extra_addresses: " + InetAddress.getByName(string2));
                }
            }
            for (NetworkInterface networkInterface : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                if (DEBUG) {
                    System.out.println("   NetworkInterface " + networkInterface + ":");
                    System.out.println("      " + Collections.list(networkInterface.getInetAddresses()));
                }
                linkedHashSet.addAll(Collections.list(networkInterface.getInetAddresses()));
            }
            return new HostAddresses(linkedHashSet.toArray(new InetAddress[linkedHashSet.size()]));
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    public HostAddresses(InetAddress[] inetAddressArray) {
        if (inetAddressArray == null) {
            this.addresses = null;
            return;
        }
        this.addresses = new HostAddress[inetAddressArray.length];
        for (int i = 0; i < inetAddressArray.length; ++i) {
            this.addresses[i] = new HostAddress(inetAddressArray[i]);
        }
    }

    public String toString() {
        return Arrays.toString(this.addresses);
    }
}

