/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.lookup;

import java.awt.event.KeyEvent;
import org.apache.commons.text.lookup.ConstantStringLookup;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ConstantStringLookupTest {
    public static final String FIELD = "Field that can be read";
    private static final String PRIVATE_FIELD = "PRIVATE";
    private ConstantStringLookup stringLookup;

    @AfterEach
    public void afterEach() {
        ConstantStringLookup.clear();
    }

    @BeforeEach
    public void beforeEach() {
        this.stringLookup = ConstantStringLookup.INSTANCE;
    }

    @Test
    public void testLookupCache() {
        this.testLookupConstant();
        this.testLookupConstant();
    }

    @Test
    public void testLookupConstant() {
        Assertions.assertEquals((Object)FIELD, (Object)this.stringLookup.lookup(this.variable("FIELD")), (String)"Wrong value of constant");
    }

    @Test
    public void testLookupInvalidSyntax() {
        Assertions.assertNull((Object)this.stringLookup.lookup("InvalidVariableName"), (String)"Non null return value for invalid variable name");
    }

    @Test
    public void testLookupNonExisting() {
        Assertions.assertNull((Object)this.stringLookup.lookup(this.variable("NO_FIELD")), (String)"Non null return value for non existing constant");
    }

    @Test
    public void testLookupNonString() {
        String ref = KeyEvent.class.getName() + ".VK_ESCAPE";
        String expected = Integer.toString(27);
        Assertions.assertEquals((Object)expected, (Object)this.stringLookup.lookup(ref), (String)"Wrong result of first lookup");
        Assertions.assertEquals((Object)expected, (Object)this.stringLookup.lookup(ref), (String)"Wrong result of 2nd lookup");
    }

    @Test
    public void testLookupNull() {
        Assertions.assertNull((Object)this.stringLookup.lookup(null), (String)"Non null return value for null variable");
    }

    @Test
    public void testLookupPrivate() {
        Assertions.assertNull((Object)this.stringLookup.lookup(this.variable("PRIVATE_FIELD")), (String)"Non null return value for non accessible field");
    }

    @Test
    public void testLookupUnknownClass() {
        Assertions.assertNull((Object)this.stringLookup.lookup("org.apache.commons.configuration.NonExistingConfig.Field that can be read"), (String)"Non null return value for unknown class");
    }

    private String variable(String field) {
        return this.getClass().getName() + '.' + field;
    }
}

