/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.CompileTimeFunction;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.ZeroOrOne;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AnyURIValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticBaseURI
extends CompileTimeFunction {
    String staticBaseURI;

    @Override
    public void bindStaticContext(StaticContext env) throws XPathException {
        if (this.staticBaseURI == null) {
            this.staticBaseURI = env.getBaseURI();
        }
    }

    @Override
    public Expression preEvaluate(ExpressionVisitor visitor) throws XPathException {
        if (this.staticBaseURI != null) {
            return Literal.makeLiteral(new AnyURIValue(this.staticBaseURI), this.getContainer());
        }
        String baseURI = visitor.getStaticContext().getBaseURI();
        if (baseURI == null) {
            return Literal.makeEmptySequence(this.getContainer());
        }
        return Literal.makeLiteral(new AnyURIValue(baseURI), this.getContainer());
    }

    @Override
    public ZeroOrOne<AnyURIValue> call(XPathContext context, Sequence[] arguments) throws XPathException {
        if (this.staticBaseURI == null) {
            return ZeroOrOne.empty();
        }
        return new ZeroOrOne<AnyURIValue>(new AnyURIValue(this.staticBaseURI));
    }
}

