// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package controltoweriface provides an interface to enable mocking the AWS Control Tower service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package controltoweriface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/controltower"
)

// ControlTowerAPI provides an interface to enable mocking the
// controltower.ControlTower service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// AWS Control Tower.
//	func myFunc(svc controltoweriface.ControlTowerAPI) bool {
//	    // Make svc.DeleteLandingZone request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := controltower.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockControlTowerClient struct {
//	    controltoweriface.ControlTowerAPI
//	}
//	func (m *mockControlTowerClient) DeleteLandingZone(input *controltower.DeleteLandingZoneInput) (*controltower.DeleteLandingZoneOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockControlTowerClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ControlTowerAPI interface {
	DeleteLandingZone(*controltower.DeleteLandingZoneInput) (*controltower.DeleteLandingZoneOutput, error)
	DeleteLandingZoneWithContext(aws.Context, *controltower.DeleteLandingZoneInput, ...request.Option) (*controltower.DeleteLandingZoneOutput, error)
	DeleteLandingZoneRequest(*controltower.DeleteLandingZoneInput) (*request.Request, *controltower.DeleteLandingZoneOutput)

	DisableBaseline(*controltower.DisableBaselineInput) (*controltower.DisableBaselineOutput, error)
	DisableBaselineWithContext(aws.Context, *controltower.DisableBaselineInput, ...request.Option) (*controltower.DisableBaselineOutput, error)
	DisableBaselineRequest(*controltower.DisableBaselineInput) (*request.Request, *controltower.DisableBaselineOutput)

	DisableControl(*controltower.DisableControlInput) (*controltower.DisableControlOutput, error)
	DisableControlWithContext(aws.Context, *controltower.DisableControlInput, ...request.Option) (*controltower.DisableControlOutput, error)
	DisableControlRequest(*controltower.DisableControlInput) (*request.Request, *controltower.DisableControlOutput)

	EnableBaseline(*controltower.EnableBaselineInput) (*controltower.EnableBaselineOutput, error)
	EnableBaselineWithContext(aws.Context, *controltower.EnableBaselineInput, ...request.Option) (*controltower.EnableBaselineOutput, error)
	EnableBaselineRequest(*controltower.EnableBaselineInput) (*request.Request, *controltower.EnableBaselineOutput)

	EnableControl(*controltower.EnableControlInput) (*controltower.EnableControlOutput, error)
	EnableControlWithContext(aws.Context, *controltower.EnableControlInput, ...request.Option) (*controltower.EnableControlOutput, error)
	EnableControlRequest(*controltower.EnableControlInput) (*request.Request, *controltower.EnableControlOutput)

	GetBaseline(*controltower.GetBaselineInput) (*controltower.GetBaselineOutput, error)
	GetBaselineWithContext(aws.Context, *controltower.GetBaselineInput, ...request.Option) (*controltower.GetBaselineOutput, error)
	GetBaselineRequest(*controltower.GetBaselineInput) (*request.Request, *controltower.GetBaselineOutput)

	GetBaselineOperation(*controltower.GetBaselineOperationInput) (*controltower.GetBaselineOperationOutput, error)
	GetBaselineOperationWithContext(aws.Context, *controltower.GetBaselineOperationInput, ...request.Option) (*controltower.GetBaselineOperationOutput, error)
	GetBaselineOperationRequest(*controltower.GetBaselineOperationInput) (*request.Request, *controltower.GetBaselineOperationOutput)

	GetControlOperation(*controltower.GetControlOperationInput) (*controltower.GetControlOperationOutput, error)
	GetControlOperationWithContext(aws.Context, *controltower.GetControlOperationInput, ...request.Option) (*controltower.GetControlOperationOutput, error)
	GetControlOperationRequest(*controltower.GetControlOperationInput) (*request.Request, *controltower.GetControlOperationOutput)

	GetEnabledBaseline(*controltower.GetEnabledBaselineInput) (*controltower.GetEnabledBaselineOutput, error)
	GetEnabledBaselineWithContext(aws.Context, *controltower.GetEnabledBaselineInput, ...request.Option) (*controltower.GetEnabledBaselineOutput, error)
	GetEnabledBaselineRequest(*controltower.GetEnabledBaselineInput) (*request.Request, *controltower.GetEnabledBaselineOutput)

	GetEnabledControl(*controltower.GetEnabledControlInput) (*controltower.GetEnabledControlOutput, error)
	GetEnabledControlWithContext(aws.Context, *controltower.GetEnabledControlInput, ...request.Option) (*controltower.GetEnabledControlOutput, error)
	GetEnabledControlRequest(*controltower.GetEnabledControlInput) (*request.Request, *controltower.GetEnabledControlOutput)

	GetLandingZoneOperation(*controltower.GetLandingZoneOperationInput) (*controltower.GetLandingZoneOperationOutput, error)
	GetLandingZoneOperationWithContext(aws.Context, *controltower.GetLandingZoneOperationInput, ...request.Option) (*controltower.GetLandingZoneOperationOutput, error)
	GetLandingZoneOperationRequest(*controltower.GetLandingZoneOperationInput) (*request.Request, *controltower.GetLandingZoneOperationOutput)

	ListBaselines(*controltower.ListBaselinesInput) (*controltower.ListBaselinesOutput, error)
	ListBaselinesWithContext(aws.Context, *controltower.ListBaselinesInput, ...request.Option) (*controltower.ListBaselinesOutput, error)
	ListBaselinesRequest(*controltower.ListBaselinesInput) (*request.Request, *controltower.ListBaselinesOutput)

	ListBaselinesPages(*controltower.ListBaselinesInput, func(*controltower.ListBaselinesOutput, bool) bool) error
	ListBaselinesPagesWithContext(aws.Context, *controltower.ListBaselinesInput, func(*controltower.ListBaselinesOutput, bool) bool, ...request.Option) error

	ListEnabledBaselines(*controltower.ListEnabledBaselinesInput) (*controltower.ListEnabledBaselinesOutput, error)
	ListEnabledBaselinesWithContext(aws.Context, *controltower.ListEnabledBaselinesInput, ...request.Option) (*controltower.ListEnabledBaselinesOutput, error)
	ListEnabledBaselinesRequest(*controltower.ListEnabledBaselinesInput) (*request.Request, *controltower.ListEnabledBaselinesOutput)

	ListEnabledBaselinesPages(*controltower.ListEnabledBaselinesInput, func(*controltower.ListEnabledBaselinesOutput, bool) bool) error
	ListEnabledBaselinesPagesWithContext(aws.Context, *controltower.ListEnabledBaselinesInput, func(*controltower.ListEnabledBaselinesOutput, bool) bool, ...request.Option) error

	ListEnabledControls(*controltower.ListEnabledControlsInput) (*controltower.ListEnabledControlsOutput, error)
	ListEnabledControlsWithContext(aws.Context, *controltower.ListEnabledControlsInput, ...request.Option) (*controltower.ListEnabledControlsOutput, error)
	ListEnabledControlsRequest(*controltower.ListEnabledControlsInput) (*request.Request, *controltower.ListEnabledControlsOutput)

	ListEnabledControlsPages(*controltower.ListEnabledControlsInput, func(*controltower.ListEnabledControlsOutput, bool) bool) error
	ListEnabledControlsPagesWithContext(aws.Context, *controltower.ListEnabledControlsInput, func(*controltower.ListEnabledControlsOutput, bool) bool, ...request.Option) error

	ListLandingZones(*controltower.ListLandingZonesInput) (*controltower.ListLandingZonesOutput, error)
	ListLandingZonesWithContext(aws.Context, *controltower.ListLandingZonesInput, ...request.Option) (*controltower.ListLandingZonesOutput, error)
	ListLandingZonesRequest(*controltower.ListLandingZonesInput) (*request.Request, *controltower.ListLandingZonesOutput)

	ListLandingZonesPages(*controltower.ListLandingZonesInput, func(*controltower.ListLandingZonesOutput, bool) bool) error
	ListLandingZonesPagesWithContext(aws.Context, *controltower.ListLandingZonesInput, func(*controltower.ListLandingZonesOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*controltower.ListTagsForResourceInput) (*controltower.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *controltower.ListTagsForResourceInput, ...request.Option) (*controltower.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*controltower.ListTagsForResourceInput) (*request.Request, *controltower.ListTagsForResourceOutput)

	ResetEnabledBaseline(*controltower.ResetEnabledBaselineInput) (*controltower.ResetEnabledBaselineOutput, error)
	ResetEnabledBaselineWithContext(aws.Context, *controltower.ResetEnabledBaselineInput, ...request.Option) (*controltower.ResetEnabledBaselineOutput, error)
	ResetEnabledBaselineRequest(*controltower.ResetEnabledBaselineInput) (*request.Request, *controltower.ResetEnabledBaselineOutput)

	ResetLandingZone(*controltower.ResetLandingZoneInput) (*controltower.ResetLandingZoneOutput, error)
	ResetLandingZoneWithContext(aws.Context, *controltower.ResetLandingZoneInput, ...request.Option) (*controltower.ResetLandingZoneOutput, error)
	ResetLandingZoneRequest(*controltower.ResetLandingZoneInput) (*request.Request, *controltower.ResetLandingZoneOutput)

	TagResource(*controltower.TagResourceInput) (*controltower.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *controltower.TagResourceInput, ...request.Option) (*controltower.TagResourceOutput, error)
	TagResourceRequest(*controltower.TagResourceInput) (*request.Request, *controltower.TagResourceOutput)

	UntagResource(*controltower.UntagResourceInput) (*controltower.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *controltower.UntagResourceInput, ...request.Option) (*controltower.UntagResourceOutput, error)
	UntagResourceRequest(*controltower.UntagResourceInput) (*request.Request, *controltower.UntagResourceOutput)

	UpdateEnabledBaseline(*controltower.UpdateEnabledBaselineInput) (*controltower.UpdateEnabledBaselineOutput, error)
	UpdateEnabledBaselineWithContext(aws.Context, *controltower.UpdateEnabledBaselineInput, ...request.Option) (*controltower.UpdateEnabledBaselineOutput, error)
	UpdateEnabledBaselineRequest(*controltower.UpdateEnabledBaselineInput) (*request.Request, *controltower.UpdateEnabledBaselineOutput)
}

var _ ControlTowerAPI = (*controltower.ControlTower)(nil)
