/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.shorts;

import it.unimi.dsi.fastutil.bytes.ByteSpliterator;
import it.unimi.dsi.fastutil.ints.IntSpliterator;
import it.unimi.dsi.fastutil.ints.IntSpliterators;
import it.unimi.dsi.fastutil.shorts.ShortArrays;
import it.unimi.dsi.fastutil.shorts.ShortComparator;
import it.unimi.dsi.fastutil.shorts.ShortConsumer;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import it.unimi.dsi.fastutil.shorts.ShortPredicate;
import it.unimi.dsi.fastutil.shorts.ShortSpliterator;
import it.unimi.dsi.fastutil.shorts.ShortSpliterators;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.IntConsumer;
import java.util.function.IntPredicate;

public final class ShortSpliterators {
    static final int BASE_SPLITERATOR_CHARACTERISTICS = 256;
    public static final int COLLECTION_SPLITERATOR_CHARACTERISTICS = 320;
    public static final int LIST_SPLITERATOR_CHARACTERISTICS = 16720;
    public static final int SET_SPLITERATOR_CHARACTERISTICS = 321;
    private static final int SORTED_CHARACTERISTICS = 20;
    public static final int SORTED_SET_SPLITERATOR_CHARACTERISTICS = 341;
    public static final EmptySpliterator EMPTY_SPLITERATOR = new EmptySpliterator();

    private ShortSpliterators() {
    }

    public static ShortSpliterator singleton(short element) {
        return new SingletonSpliterator(element);
    }

    public static ShortSpliterator singleton(short element, ShortComparator comparator) {
        return new SingletonSpliterator(element, comparator);
    }

    public static ShortSpliterator wrap(short[] array, int offset, int length) {
        ShortArrays.ensureOffsetLength(array, offset, length);
        return new ArraySpliterator(array, offset, length, 0);
    }

    public static ShortSpliterator wrap(short[] array) {
        return new ArraySpliterator(array, 0, array.length, 0);
    }

    public static ShortSpliterator wrap(short[] array, int offset, int length, int additionalCharacteristics) {
        ShortArrays.ensureOffsetLength(array, offset, length);
        return new ArraySpliterator(array, offset, length, additionalCharacteristics);
    }

    public static ShortSpliterator wrapPreSorted(short[] array, int offset, int length, int additionalCharacteristics, ShortComparator comparator) {
        ShortArrays.ensureOffsetLength(array, offset, length);
        return new ArraySpliteratorWithComparator(array, offset, length, additionalCharacteristics, comparator);
    }

    public static ShortSpliterator wrapPreSorted(short[] array, int offset, int length, ShortComparator comparator) {
        return ShortSpliterators.wrapPreSorted(array, offset, length, 0, comparator);
    }

    public static ShortSpliterator wrapPreSorted(short[] array, ShortComparator comparator) {
        return ShortSpliterators.wrapPreSorted(array, 0, array.length, comparator);
    }

    public static ShortSpliterator asShortSpliterator(Spliterator i) {
        if (i instanceof ShortSpliterator) {
            return (ShortSpliterator)i;
        }
        return new SpliteratorWrapper(i);
    }

    public static ShortSpliterator asShortSpliterator(Spliterator i, ShortComparator comparatorOverride) {
        if (i instanceof ShortSpliterator) {
            throw new IllegalArgumentException("Cannot override comparator on instance that is already a " + ShortSpliterator.class.getSimpleName());
        }
        if (i instanceof Spliterator.OfInt) {
            return new PrimitiveSpliteratorWrapperWithComparator((Spliterator.OfInt)i, comparatorOverride);
        }
        return new SpliteratorWrapperWithComparator(i, comparatorOverride);
    }

    public static ShortSpliterator narrow(Spliterator.OfInt i) {
        return new PrimitiveSpliteratorWrapper(i);
    }

    public static IntSpliterator widen(ShortSpliterator i) {
        return IntSpliterators.wrap(i);
    }

    public static void onEachMatching(ShortSpliterator spliterator, ShortPredicate predicate, ShortConsumer action) {
        Objects.requireNonNull(predicate);
        Objects.requireNonNull(action);
        spliterator.forEachRemaining(value -> {
            if (predicate.test(value)) {
                action.accept(value);
            }
        });
    }

    public static void onEachMatching(ShortSpliterator spliterator, IntPredicate predicate, IntConsumer action) {
        Objects.requireNonNull(predicate);
        Objects.requireNonNull(action);
        spliterator.forEachRemaining(value -> {
            if (predicate.test(value)) {
                action.accept(value);
            }
        });
    }

    public static ShortSpliterator fromTo(short from, short to) {
        return new IntervalSpliterator(from, to);
    }

    public static ShortSpliterator concat(ShortSpliterator ... a) {
        return ShortSpliterators.concat(a, 0, a.length);
    }

    public static ShortSpliterator concat(ShortSpliterator[] a, int offset, int length) {
        return new SpliteratorConcatenator(a, offset, length);
    }

    public static ShortSpliterator asSpliterator(ShortIterator iter, long size, int additionalCharacterisitcs) {
        return new SpliteratorFromIterator(iter, size, additionalCharacterisitcs);
    }

    public static ShortSpliterator asSpliteratorFromSorted(ShortIterator iter, long size, int additionalCharacterisitcs, ShortComparator comparator) {
        return new SpliteratorFromIteratorWithComparator(iter, size, additionalCharacterisitcs, comparator);
    }

    public static ShortSpliterator asSpliteratorUnknownSize(ShortIterator iter, int characterisitcs) {
        return new SpliteratorFromIterator(iter, characterisitcs);
    }

    public static ShortSpliterator asSpliteratorFromSortedUnknownSize(ShortIterator iter, int additionalCharacterisitcs, ShortComparator comparator) {
        return new SpliteratorFromIteratorWithComparator(iter, additionalCharacterisitcs, comparator);
    }

    public static ShortIterator asIterator(ShortSpliterator spliterator) {
        return new IteratorFromSpliterator(spliterator);
    }

    public static ShortSpliterator wrap(ByteSpliterator spliterator) {
        return new ByteSpliteratorWrapper(spliterator);
    }
}

