/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Date;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.filechooser.FileSystemView;
import javax.swing.table.AbstractTableModel;

class AquaFileSystemModel
extends AbstractTableModel
implements PropertyChangeListener {
    private final JTable fFileList;
    private LoadFilesThread loadThread = null;
    private Vector<File> files = null;
    JFileChooser filechooser = null;
    Vector<SortableFile> fileCache = null;
    Object fileCacheLock;
    Vector<File> directories = null;
    int fetchID = 0;
    private final boolean[] fSortAscending = new boolean[]{true, true};
    private boolean fSortNames = true;
    private final String[] fColumnNames;
    public static final String SORT_BY_CHANGED = "sortByChanged";
    public static final String SORT_ASCENDING_CHANGED = "sortAscendingChanged";
    final QuickSortNames sSortNames = new QuickSortNames();
    final QuickSortDates sSortDates = new QuickSortDates();

    public AquaFileSystemModel(JFileChooser jFileChooser, JTable jTable, String[] stringArray) {
        this.fileCacheLock = new Object();
        this.filechooser = jFileChooser;
        this.fFileList = jTable;
        this.fColumnNames = stringArray;
        this.validateFileCache();
        this.updateSelectionMode();
    }

    void updateSelectionMode() {
        boolean bl = this.filechooser.isMultiSelectionEnabled() && this.filechooser.getDialogType() != 1;
        this.fFileList.setSelectionMode(bl ? 2 : 0);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string == "directoryChanged" || string == "fileViewChanged" || string == "fileFilterChanged" || string == "FileHidingChanged") {
            this.invalidateFileCache();
            this.validateFileCache();
        } else if (string.equals("MultiSelectionEnabledChangedProperty")) {
            this.updateSelectionMode();
        } else if (string == "fileSelectionChanged") {
            this.invalidateFileCache();
            this.validateFileCache();
        }
        if (string == SORT_BY_CHANGED) {
            this.fSortNames = (Integer)propertyChangeEvent.getNewValue() == 0;
            this.invalidateFileCache();
            this.validateFileCache();
            this.fFileList.repaint();
        }
        if (string == SORT_ASCENDING_CHANGED) {
            int n = this.fSortNames ? 0 : 1;
            this.fSortAscending[n] = (Boolean)propertyChangeEvent.getNewValue();
            this.invalidateFileCache();
            this.validateFileCache();
            this.fFileList.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateFileCache() {
        this.files = null;
        this.directories = null;
        Object object = this.fileCacheLock;
        synchronized (object) {
            if (this.fileCache != null) {
                int n = this.fileCache.size();
                this.fileCache = null;
                this.fireTableRowsDeleted(0, n);
            }
        }
    }

    public Vector<File> getDirectories() {
        if (this.directories != null) {
            return this.directories;
        }
        return this.directories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<File> getFiles() {
        if (this.files != null) {
            return this.files;
        }
        this.files = new Vector();
        this.directories = new Vector();
        this.directories.addElement(this.filechooser.getFileSystemView().createFileObject(this.filechooser.getCurrentDirectory(), ".."));
        Object object = this.fileCacheLock;
        synchronized (object) {
            for (int i = 0; i < this.fileCache.size(); ++i) {
                SortableFile sortableFile = this.fileCache.elementAt(i);
                File file = sortableFile.fFile;
                if (this.filechooser.isTraversable(file)) {
                    this.directories.addElement(file);
                    continue;
                }
                this.files.addElement(file);
            }
        }
        return this.files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWhenDone(Runnable runnable) {
        Object object = this.fileCacheLock;
        synchronized (object) {
            if (this.loadThread != null && this.loadThread.isAlive()) {
                this.loadThread.queuedTasks.add(runnable);
                return;
            }
            SwingUtilities.invokeLater(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateFileCache() {
        File file = this.filechooser.getCurrentDirectory();
        if (file == null) {
            this.invalidateFileCache();
            return;
        }
        if (this.loadThread != null) {
            this.loadThread.interrupt();
        }
        ++this.fetchID;
        this.invalidateFileCache();
        Object object = this.fileCacheLock;
        synchronized (object) {
            this.fileCache = new Vector(50);
        }
        this.loadThread = new LoadFilesThread(file, this.fetchID);
        this.loadThread.start();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int n) {
        return this.fColumnNames[n];
    }

    public Class<? extends Object> getColumnClass(int n) {
        if (n == 0) {
            return File.class;
        }
        return Date.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRowCount() {
        Object object = this.fileCacheLock;
        synchronized (object) {
            if (this.fileCache != null) {
                return this.fileCache.size();
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(File file) {
        Object object = this.fileCacheLock;
        synchronized (object) {
            if (this.fileCache != null) {
                return this.fileCache.contains(new SortableFile(file));
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(File file) {
        Object object = this.fileCacheLock;
        synchronized (object) {
            if (this.fileCache != null) {
                boolean bl = this.fSortNames ? this.fSortAscending[0] : this.fSortAscending[1];
                int n = this.fileCache.indexOf(new SortableFile(file));
                return bl ? n : this.fileCache.size() - n - 1;
            }
            return 0;
        }
    }

    public Object getElementAt(int n) {
        return this.getValueAt(n, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(int n, int n2) {
        if (n < 0 || n2 < 0) {
            return null;
        }
        boolean bl = this.fSortNames ? this.fSortAscending[0] : this.fSortAscending[1];
        Object object = this.fileCacheLock;
        synchronized (object) {
            if (this.fileCache != null) {
                if (!bl) {
                    n = this.fileCache.size() - n - 1;
                }
                return this.fileCache.elementAt(n).getValueAt(n2);
            }
            return null;
        }
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
    }

    protected void sort(Vector<Object> vector) {
        if (this.fSortNames) {
            this.sSortNames.quickSort(vector, 0, vector.size() - 1);
        } else {
            this.sSortDates.quickSort(vector, 0, vector.size() - 1);
        }
    }

    class DoChangeContents
    implements Runnable {
        private Vector<SortableFile> contentFiles;
        private boolean doFire = true;
        private final Object lock = new Object();
        private final int fid;

        public DoChangeContents(Vector<SortableFile> vector, int n) {
            this.contentFiles = vector;
            this.fid = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void cancel() {
            Object object = this.lock;
            synchronized (object) {
                this.doFire = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (AquaFileSystemModel.this.fetchID == this.fid) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.doFire) {
                        Object object2 = AquaFileSystemModel.this.fileCacheLock;
                        synchronized (object2) {
                            if (AquaFileSystemModel.this.fileCache != null) {
                                for (int i = 0; i < this.contentFiles.size(); ++i) {
                                    AquaFileSystemModel.this.fileCache.addElement(this.contentFiles.elementAt(i));
                                    AquaFileSystemModel.this.fireTableRowsInserted(i, i);
                                }
                            }
                        }
                    }
                    this.contentFiles = null;
                    AquaFileSystemModel.this.directories = null;
                }
            }
        }
    }

    class LoadFilesThread
    extends Thread {
        Vector<Runnable> queuedTasks;
        File currentDirectory;
        int fid;

        public LoadFilesThread(File file, int n) {
            super("Aqua L&F File Loading Thread");
            this.queuedTasks = new Vector();
            this.currentDirectory = null;
            this.currentDirectory = file;
            this.fid = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void run() {
            Vector<DoChangeContents> vector = new Vector<DoChangeContents>(10);
            FileSystemView fileSystemView = AquaFileSystemModel.this.filechooser.getFileSystemView();
            File[] fileArray = fileSystemView.getFiles(this.currentDirectory, AquaFileSystemModel.this.filechooser.isFileHidingEnabled());
            Vector<Object> vector2 = new Vector<Object>();
            for (File object2 : fileArray) {
                vector2.addElement(new SortableFile(object2));
            }
            AquaFileSystemModel.this.sort(vector2);
            Object object = new Vector(10);
            int n = vector2.size();
            int n2 = 0;
            while (n2 < n) {
                void var9_15;
                boolean bl = false;
                while (var9_15 < 10 && n2 < n) {
                    SortableFile sortableFile = (SortableFile)vector2.elementAt(n2);
                    ((Vector)object).addElement(sortableFile);
                    ++var9_15;
                    ++n2;
                }
                DoChangeContents doChangeContents = new DoChangeContents((Vector<SortableFile>)object, this.fid);
                vector.addElement(doChangeContents);
                SwingUtilities.invokeLater(doChangeContents);
                object = new Vector(10);
                if (!this.isInterrupted()) continue;
                this.cancelRunnables(vector);
                return;
            }
            Object object3 = AquaFileSystemModel.this.fileCacheLock;
            synchronized (object3) {
                for (Runnable runnable : this.queuedTasks) {
                    SwingUtilities.invokeLater(runnable);
                }
            }
        }

        public void cancelRunnables(Vector<DoChangeContents> vector) {
            for (int i = 0; i < vector.size(); ++i) {
                vector.elementAt(i).cancel();
            }
        }
    }

    class SortableFile {
        File fFile;
        String fName;
        long fDateValue;
        Date fDate;

        SortableFile(File file) {
            this.fFile = file;
            this.fName = this.fFile.getName();
            this.fDateValue = this.fFile.lastModified();
            this.fDate = new Date(this.fDateValue);
        }

        public Object getValueAt(int n) {
            if (n == 0) {
                return this.fFile;
            }
            return this.fDate;
        }

        public boolean equals(Object object) {
            SortableFile sortableFile = (SortableFile)object;
            return sortableFile.fFile.equals(this.fFile);
        }
    }

    class QuickSortDates
    extends QuickSort {
        QuickSortDates() {
        }

        @Override
        protected boolean lt(SortableFile sortableFile, SortableFile sortableFile2) {
            return sortableFile.fDateValue < sortableFile2.fDateValue;
        }
    }

    class QuickSortNames
    extends QuickSort {
        QuickSortNames() {
        }

        @Override
        protected boolean lt(SortableFile sortableFile, SortableFile sortableFile2) {
            String string;
            String string2 = sortableFile.fName.toLowerCase();
            return string2.compareTo(string = sortableFile2.fName.toLowerCase()) < 0;
        }
    }

    abstract class QuickSort {
        QuickSort() {
        }

        final void quickSort(Vector<Object> vector, int n, int n2) {
            int n3 = n;
            int n4 = n2;
            if (n2 > n) {
                SortableFile sortableFile = (SortableFile)vector.elementAt((n + n2) / 2);
                while (n3 <= n4) {
                    while (n3 < n2 && this.lt((SortableFile)vector.elementAt(n3), sortableFile)) {
                        ++n3;
                    }
                    while (n4 > n && this.lt(sortableFile, (SortableFile)vector.elementAt(n4))) {
                        --n4;
                    }
                    if (n3 > n4) continue;
                    this.swap(vector, n3, n4);
                    ++n3;
                    --n4;
                }
                if (n < n4) {
                    this.quickSort(vector, n, n4);
                }
                if (n3 < n2) {
                    this.quickSort(vector, n3, n2);
                }
            }
        }

        private final void swap(Vector<Object> vector, int n, int n2) {
            Object object = vector.elementAt(n);
            vector.setElementAt(vector.elementAt(n2), n);
            vector.setElementAt(object, n2);
        }

        protected abstract boolean lt(SortableFile var1, SortableFile var2);
    }
}

