package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSuspEventTypes invokes the aegis.DescribeSuspEventTypes API synchronously
// api document: https://help.aliyun.com/api/aegis/describesuspeventtypes.html
func (client *Client) DescribeSuspEventTypes(request *DescribeSuspEventTypesRequest) (response *DescribeSuspEventTypesResponse, err error) {
	response = CreateDescribeSuspEventTypesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSuspEventTypesWithChan invokes the aegis.DescribeSuspEventTypes API asynchronously
// api document: https://help.aliyun.com/api/aegis/describesuspeventtypes.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeSuspEventTypesWithChan(request *DescribeSuspEventTypesRequest) (<-chan *DescribeSuspEventTypesResponse, <-chan error) {
	responseChan := make(chan *DescribeSuspEventTypesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSuspEventTypes(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSuspEventTypesWithCallback invokes the aegis.DescribeSuspEventTypes API asynchronously
// api document: https://help.aliyun.com/api/aegis/describesuspeventtypes.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeSuspEventTypesWithCallback(request *DescribeSuspEventTypesRequest, callback func(response *DescribeSuspEventTypesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSuspEventTypesResponse
		var err error
		defer close(result)
		response, err = client.DescribeSuspEventTypes(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSuspEventTypesRequest is the request struct for api DescribeSuspEventTypes
type DescribeSuspEventTypesRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
}

// DescribeSuspEventTypesResponse is the response struct for api DescribeSuspEventTypes
type DescribeSuspEventTypesResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	TotalCount int    `json:"TotalCount" xml:"TotalCount"`
	EventTypes []Data `json:"EventTypes" xml:"EventTypes"`
}

// CreateDescribeSuspEventTypesRequest creates a request to invoke DescribeSuspEventTypes API
func CreateDescribeSuspEventTypesRequest() (request *DescribeSuspEventTypesRequest) {
	request = &DescribeSuspEventTypesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "DescribeSuspEventTypes", "vipaegis", "openAPI")
	return
}

// CreateDescribeSuspEventTypesResponse creates a response to parse from DescribeSuspEventTypes response
func CreateDescribeSuspEventTypesResponse() (response *DescribeSuspEventTypesResponse) {
	response = &DescribeSuspEventTypesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
