package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeTraceInfoNode invokes the aegis.DescribeTraceInfoNode API synchronously
// api document: https://help.aliyun.com/api/aegis/describetraceinfonode.html
func (client *Client) DescribeTraceInfoNode(request *DescribeTraceInfoNodeRequest) (response *DescribeTraceInfoNodeResponse, err error) {
	response = CreateDescribeTraceInfoNodeResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeTraceInfoNodeWithChan invokes the aegis.DescribeTraceInfoNode API asynchronously
// api document: https://help.aliyun.com/api/aegis/describetraceinfonode.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeTraceInfoNodeWithChan(request *DescribeTraceInfoNodeRequest) (<-chan *DescribeTraceInfoNodeResponse, <-chan error) {
	responseChan := make(chan *DescribeTraceInfoNodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeTraceInfoNode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeTraceInfoNodeWithCallback invokes the aegis.DescribeTraceInfoNode API asynchronously
// api document: https://help.aliyun.com/api/aegis/describetraceinfonode.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeTraceInfoNodeWithCallback(request *DescribeTraceInfoNodeRequest, callback func(response *DescribeTraceInfoNodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeTraceInfoNodeResponse
		var err error
		defer close(result)
		response, err = client.DescribeTraceInfoNode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeTraceInfoNodeRequest is the request struct for api DescribeTraceInfoNode
type DescribeTraceInfoNodeRequest struct {
	*requests.RpcRequest
	SourceIp  string `position:"Query" name:"SourceIp"`
	VertexId  string `position:"Query" name:"VertexId"`
	From      string `position:"Query" name:"From"`
	Lang      string `position:"Query" name:"Lang"`
	Type      string `position:"Query" name:"Type"`
	Uuid      string `position:"Query" name:"Uuid"`
	EventName string `position:"Query" name:"EventName"`
}

// DescribeTraceInfoNodeResponse is the response struct for api DescribeTraceInfoNode
type DescribeTraceInfoNodeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Node      Node   `json:"Node" xml:"Node"`
}

// CreateDescribeTraceInfoNodeRequest creates a request to invoke DescribeTraceInfoNode API
func CreateDescribeTraceInfoNodeRequest() (request *DescribeTraceInfoNodeRequest) {
	request = &DescribeTraceInfoNodeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "DescribeTraceInfoNode", "vipaegis", "openAPI")
	return
}

// CreateDescribeTraceInfoNodeResponse creates a response to parse from DescribeTraceInfoNode response
func CreateDescribeTraceInfoNodeResponse() (response *DescribeTraceInfoNodeResponse) {
	response = &DescribeTraceInfoNodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
