package airec

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDashboardDetailsFlows invokes the airec.ListDashboardDetailsFlows API synchronously
func (client *Client) ListDashboardDetailsFlows(request *ListDashboardDetailsFlowsRequest) (response *ListDashboardDetailsFlowsResponse, err error) {
	response = CreateListDashboardDetailsFlowsResponse()
	err = client.DoAction(request, response)
	return
}

// ListDashboardDetailsFlowsWithChan invokes the airec.ListDashboardDetailsFlows API asynchronously
func (client *Client) ListDashboardDetailsFlowsWithChan(request *ListDashboardDetailsFlowsRequest) (<-chan *ListDashboardDetailsFlowsResponse, <-chan error) {
	responseChan := make(chan *ListDashboardDetailsFlowsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDashboardDetailsFlows(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDashboardDetailsFlowsWithCallback invokes the airec.ListDashboardDetailsFlows API asynchronously
func (client *Client) ListDashboardDetailsFlowsWithCallback(request *ListDashboardDetailsFlowsRequest, callback func(response *ListDashboardDetailsFlowsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDashboardDetailsFlowsResponse
		var err error
		defer close(result)
		response, err = client.ListDashboardDetailsFlows(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDashboardDetailsFlowsRequest is the request struct for api ListDashboardDetailsFlows
type ListDashboardDetailsFlowsRequest struct {
	*requests.RoaRequest
	MetricType    string           `position:"Query" name:"metricType"`
	InstanceId    string           `position:"Path" name:"instanceId"`
	ExperimentIds string           `position:"Query" name:"experimentIds"`
	TraceIds      string           `position:"Query" name:"traceIds"`
	EndTime       requests.Integer `position:"Query" name:"endTime"`
	StartTime     requests.Integer `position:"Query" name:"startTime"`
	SceneIds      string           `position:"Query" name:"sceneIds"`
}

// ListDashboardDetailsFlowsResponse is the response struct for api ListDashboardDetailsFlows
type ListDashboardDetailsFlowsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
	Code      string `json:"code" xml:"code"`
	Message   string `json:"message" xml:"message"`
	Result    Result `json:"result" xml:"result"`
}

// CreateListDashboardDetailsFlowsRequest creates a request to invoke ListDashboardDetailsFlows API
func CreateListDashboardDetailsFlowsRequest() (request *ListDashboardDetailsFlowsRequest) {
	request = &ListDashboardDetailsFlowsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Airec", "2020-11-26", "ListDashboardDetailsFlows", "/v2/openapi/instances/[instanceId]/dashboard/details/flows", "airec", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListDashboardDetailsFlowsResponse creates a response to parse from ListDashboardDetailsFlows response
func CreateListDashboardDetailsFlowsResponse() (response *ListDashboardDetailsFlowsResponse) {
	response = &ListDashboardDetailsFlowsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
