package appmallsservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// TaobaoFilmGetSoonShows invokes the appmallsservice.TaobaoFilmGetSoonShows API synchronously
// api document: https://help.aliyun.com/api/appmallsservice/taobaofilmgetsoonshows.html
func (client *Client) TaobaoFilmGetSoonShows(request *TaobaoFilmGetSoonShowsRequest) (response *TaobaoFilmGetSoonShowsResponse, err error) {
	response = CreateTaobaoFilmGetSoonShowsResponse()
	err = client.DoAction(request, response)
	return
}

// TaobaoFilmGetSoonShowsWithChan invokes the appmallsservice.TaobaoFilmGetSoonShows API asynchronously
// api document: https://help.aliyun.com/api/appmallsservice/taobaofilmgetsoonshows.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) TaobaoFilmGetSoonShowsWithChan(request *TaobaoFilmGetSoonShowsRequest) (<-chan *TaobaoFilmGetSoonShowsResponse, <-chan error) {
	responseChan := make(chan *TaobaoFilmGetSoonShowsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.TaobaoFilmGetSoonShows(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// TaobaoFilmGetSoonShowsWithCallback invokes the appmallsservice.TaobaoFilmGetSoonShows API asynchronously
// api document: https://help.aliyun.com/api/appmallsservice/taobaofilmgetsoonshows.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) TaobaoFilmGetSoonShowsWithCallback(request *TaobaoFilmGetSoonShowsRequest, callback func(response *TaobaoFilmGetSoonShowsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *TaobaoFilmGetSoonShowsResponse
		var err error
		defer close(result)
		response, err = client.TaobaoFilmGetSoonShows(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// TaobaoFilmGetSoonShowsRequest is the request struct for api TaobaoFilmGetSoonShows
type TaobaoFilmGetSoonShowsRequest struct {
	*requests.RpcRequest
	CityCode   requests.Integer `position:"Query" name:"CityCode"`
	ParamsJson string           `position:"Query" name:"ParamsJson"`
}

// TaobaoFilmGetSoonShowsResponse is the response struct for api TaobaoFilmGetSoonShows
type TaobaoFilmGetSoonShowsResponse struct {
	*responses.BaseResponse
	ErrorCode string      `json:"ErrorCode" xml:"ErrorCode"`
	Msg       string      `json:"Msg" xml:"Msg"`
	SubCode   string      `json:"SubCode" xml:"SubCode"`
	SubMsg    string      `json:"SubMsg" xml:"SubMsg"`
	LogsId    string      `json:"LogsId" xml:"LogsId"`
	RequestId string      `json:"RequestId" xml:"RequestId"`
	Shows     []ShowsItem `json:"Shows" xml:"Shows"`
}

// CreateTaobaoFilmGetSoonShowsRequest creates a request to invoke TaobaoFilmGetSoonShows API
func CreateTaobaoFilmGetSoonShowsRequest() (request *TaobaoFilmGetSoonShowsRequest) {
	request = &TaobaoFilmGetSoonShowsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("AppMallsService", "2018-02-24", "TaobaoFilmGetSoonShows", "", "")
	return
}

// CreateTaobaoFilmGetSoonShowsResponse creates a response to parse from TaobaoFilmGetSoonShows response
func CreateTaobaoFilmGetSoonShowsResponse() (response *TaobaoFilmGetSoonShowsResponse) {
	response = &TaobaoFilmGetSoonShowsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
