package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryNumber400List invokes the cloudcallcenter.QueryNumber400List API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/querynumber400list.html
func (client *Client) QueryNumber400List(request *QueryNumber400ListRequest) (response *QueryNumber400ListResponse, err error) {
	response = CreateQueryNumber400ListResponse()
	err = client.DoAction(request, response)
	return
}

// QueryNumber400ListWithChan invokes the cloudcallcenter.QueryNumber400List API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/querynumber400list.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryNumber400ListWithChan(request *QueryNumber400ListRequest) (<-chan *QueryNumber400ListResponse, <-chan error) {
	responseChan := make(chan *QueryNumber400ListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryNumber400List(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryNumber400ListWithCallback invokes the cloudcallcenter.QueryNumber400List API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/querynumber400list.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryNumber400ListWithCallback(request *QueryNumber400ListRequest, callback func(response *QueryNumber400ListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryNumber400ListResponse
		var err error
		defer close(result)
		response, err = client.QueryNumber400List(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryNumber400ListRequest is the request struct for api QueryNumber400List
type QueryNumber400ListRequest struct {
	*requests.RpcRequest
	SpecId        requests.Integer `position:"Query" name:"SpecId"`
	MonthPrice    string           `position:"Query" name:"MonthPrice"`
	OrderId       string           `position:"Query" name:"OrderId"`
	NumberCount   requests.Integer `position:"Query" name:"NumberCount"`
	LevelId       requests.Integer `position:"Query" name:"LevelId"`
	RealNameInsId requests.Integer `position:"Query" name:"RealNameInsId"`
}

// QueryNumber400ListResponse is the response struct for api QueryNumber400List
type QueryNumber400ListResponse struct {
	*responses.BaseResponse
	RequestId      string                   `json:"RequestId" xml:"RequestId"`
	Success        bool                     `json:"Success" xml:"Success"`
	Code           string                   `json:"Code" xml:"Code"`
	Message        string                   `json:"Message" xml:"Message"`
	HttpStatusCode int                      `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Data           DataInQueryNumber400List `json:"Data" xml:"Data"`
}

// CreateQueryNumber400ListRequest creates a request to invoke QueryNumber400List API
func CreateQueryNumber400ListRequest() (request *QueryNumber400ListRequest) {
	request = &QueryNumber400ListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "QueryNumber400List", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryNumber400ListResponse creates a response to parse from QueryNumber400List response
func CreateQueryNumber400ListResponse() (response *QueryNumber400ListResponse) {
	response = &QueryNumber400ListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
