package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateTaobaoAccessTokenByAliyunPk invokes the cloudcallcenter.UpdateTaobaoAccessTokenByAliyunPk API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/updatetaobaoaccesstokenbyaliyunpk.html
func (client *Client) UpdateTaobaoAccessTokenByAliyunPk(request *UpdateTaobaoAccessTokenByAliyunPkRequest) (response *UpdateTaobaoAccessTokenByAliyunPkResponse, err error) {
	response = CreateUpdateTaobaoAccessTokenByAliyunPkResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateTaobaoAccessTokenByAliyunPkWithChan invokes the cloudcallcenter.UpdateTaobaoAccessTokenByAliyunPk API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/updatetaobaoaccesstokenbyaliyunpk.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateTaobaoAccessTokenByAliyunPkWithChan(request *UpdateTaobaoAccessTokenByAliyunPkRequest) (<-chan *UpdateTaobaoAccessTokenByAliyunPkResponse, <-chan error) {
	responseChan := make(chan *UpdateTaobaoAccessTokenByAliyunPkResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateTaobaoAccessTokenByAliyunPk(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateTaobaoAccessTokenByAliyunPkWithCallback invokes the cloudcallcenter.UpdateTaobaoAccessTokenByAliyunPk API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/updatetaobaoaccesstokenbyaliyunpk.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateTaobaoAccessTokenByAliyunPkWithCallback(request *UpdateTaobaoAccessTokenByAliyunPkRequest, callback func(response *UpdateTaobaoAccessTokenByAliyunPkResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateTaobaoAccessTokenByAliyunPkResponse
		var err error
		defer close(result)
		response, err = client.UpdateTaobaoAccessTokenByAliyunPk(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateTaobaoAccessTokenByAliyunPkRequest is the request struct for api UpdateTaobaoAccessTokenByAliyunPk
type UpdateTaobaoAccessTokenByAliyunPkRequest struct {
	*requests.RpcRequest
	AliyunPk                   requests.Integer `position:"Query" name:"AliyunPk"`
	TaobaoAccessToken          string           `position:"Query" name:"TaobaoAccessToken"`
	TaobaoAccessTokenExpiresIn requests.Integer `position:"Query" name:"TaobaoAccessTokenExpiresIn"`
}

// UpdateTaobaoAccessTokenByAliyunPkResponse is the response struct for api UpdateTaobaoAccessTokenByAliyunPk
type UpdateTaobaoAccessTokenByAliyunPkResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreateUpdateTaobaoAccessTokenByAliyunPkRequest creates a request to invoke UpdateTaobaoAccessTokenByAliyunPk API
func CreateUpdateTaobaoAccessTokenByAliyunPkRequest() (request *UpdateTaobaoAccessTokenByAliyunPkRequest) {
	request = &UpdateTaobaoAccessTokenByAliyunPkRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "UpdateTaobaoAccessTokenByAliyunPk", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateTaobaoAccessTokenByAliyunPkResponse creates a response to parse from UpdateTaobaoAccessTokenByAliyunPk response
func CreateUpdateTaobaoAccessTokenByAliyunPkResponse() (response *UpdateTaobaoAccessTokenByAliyunPkResponse) {
	response = &UpdateTaobaoAccessTokenByAliyunPkResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
