package cdn

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/cdn/mgmt/2021-06-01/cdn"

// ActivatedResourceReference reference to another resource along with its state.
type ActivatedResourceReference struct {
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// IsActive - READ-ONLY; Whether the resource is active or inactive
	IsActive *bool `json:"isActive,omitempty"`
}

// MarshalJSON is the custom marshaler for ActivatedResourceReference.
func (arr ActivatedResourceReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if arr.ID != nil {
		objectMap["id"] = arr.ID
	}
	return json.Marshal(objectMap)
}

// AFDCustomDomainsCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AFDCustomDomainsCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AFDCustomDomainsClient) (AFDDomain, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AFDCustomDomainsCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AFDCustomDomainsCreateFuture.Result.
func (future *AFDCustomDomainsCreateFuture) result(client AFDCustomDomainsClient) (ad AFDDomain, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.AFDCustomDomainsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ad.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("cdn.AFDCustomDomainsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ad.Response.Response, err = future.GetResult(sender); err == nil && ad.Response.Response.StatusCode != http.StatusNoContent {
		ad, err = client.CreateResponder(ad.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.AFDCustomDomainsCreateFuture", "Result", ad.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AFDCustomDomainsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AFDCustomDomainsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AFDCustomDomainsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AFDCustomDomainsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AFDCustomDomainsDeleteFuture.Result.
func (future *AFDCustomDomainsDeleteFuture) result(client AFDCustomDomainsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.AFDCustomDomainsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("cdn.AFDCustomDomainsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// AFDCustomDomainsRefreshValidationTokenFuture an abstraction for monitoring and retrieving the results of
// a long-running operation.
type AFDCustomDomainsRefreshValidationTokenFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AFDCustomDomainsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AFDCustomDomainsRefreshValidationTokenFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AFDCustomDomainsRefreshValidationTokenFuture.Result.
func (future *AFDCustomDomainsRefreshValidationTokenFuture) result(client AFDCustomDomainsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.AFDCustomDomainsRefreshValidationTokenFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("cdn.AFDCustomDomainsRefreshValidationTokenFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// AFDCustomDomainsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AFDCustomDomainsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AFDCustomDomainsClient) (AFDDomain, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AFDCustomDomainsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AFDCustomDomainsUpdateFuture.Result.
func (future *AFDCustomDomainsUpdateFuture) result(client AFDCustomDomainsClient) (ad AFDDomain, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.AFDCustomDomainsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ad.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("cdn.AFDCustomDomainsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ad.Response.Response, err = future.GetResult(sender); err == nil && ad.Response.Response.StatusCode != http.StatusNoContent {
		ad, err = client.UpdateResponder(ad.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.AFDCustomDomainsUpdateFuture", "Result", ad.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AFDDomain friendly domain name mapping to the endpoint hostname that the customer provides for branding
// purposes, e.g. www.contoso.com.
type AFDDomain struct {
	autorest.Response    `json:"-"`
	*AFDDomainProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for AFDDomain.
func (ad AFDDomain) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ad.AFDDomainProperties != nil {
		objectMap["properties"] = ad.AFDDomainProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AFDDomain struct.
func (ad *AFDDomain) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var aFDDomainProperties AFDDomainProperties
				err = json.Unmarshal(*v, &aFDDomainProperties)
				if err != nil {
					return err
				}
				ad.AFDDomainProperties = &aFDDomainProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ad.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ad.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ad.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				ad.SystemData = &systemData
			}
		}
	}

	return nil
}

// AFDDomainHTTPSParameters the JSON object that contains the properties to secure a domain.
type AFDDomainHTTPSParameters struct {
	// CertificateType - Defines the source of the SSL certificate. Possible values include: 'AfdCertificateTypeCustomerCertificate', 'AfdCertificateTypeManagedCertificate', 'AfdCertificateTypeAzureFirstPartyManagedCertificate'
	CertificateType AfdCertificateType `json:"certificateType,omitempty"`
	// MinimumTLSVersion - TLS protocol version that will be used for Https. Possible values include: 'AfdMinimumTLSVersionTLS10', 'AfdMinimumTLSVersionTLS12'
	MinimumTLSVersion AfdMinimumTLSVersion `json:"minimumTlsVersion,omitempty"`
	// Secret - Resource reference to the secret. ie. subs/rg/profile/secret
	Secret *ResourceReference `json:"secret,omitempty"`
}

// AFDDomainListResult result of the request to list domains. It contains a list of domain objects and a
// URL link to get the next set of results.
type AFDDomainListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of AzureFrontDoor domains within a profile.
	Value *[]AFDDomain `json:"value,omitempty"`
	// NextLink - URL to get the next set of domain objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for AFDDomainListResult.
func (adlr AFDDomainListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if adlr.NextLink != nil {
		objectMap["nextLink"] = adlr.NextLink
	}
	return json.Marshal(objectMap)
}

// AFDDomainListResultIterator provides access to a complete listing of AFDDomain values.
type AFDDomainListResultIterator struct {
	i    int
	page AFDDomainListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AFDDomainListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AFDDomainListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AFDDomainListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AFDDomainListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AFDDomainListResultIterator) Response() AFDDomainListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AFDDomainListResultIterator) Value() AFDDomain {
	if !iter.page.NotDone() {
		return AFDDomain{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AFDDomainListResultIterator type.
func NewAFDDomainListResultIterator(page AFDDomainListResultPage) AFDDomainListResultIterator {
	return AFDDomainListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (adlr AFDDomainListResult) IsEmpty() bool {
	return adlr.Value == nil || len(*adlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (adlr AFDDomainListResult) hasNextLink() bool {
	return adlr.NextLink != nil && len(*adlr.NextLink) != 0
}

// aFDDomainListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (adlr AFDDomainListResult) aFDDomainListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !adlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(adlr.NextLink)))
}

// AFDDomainListResultPage contains a page of AFDDomain values.
type AFDDomainListResultPage struct {
	fn   func(context.Context, AFDDomainListResult) (AFDDomainListResult, error)
	adlr AFDDomainListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AFDDomainListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AFDDomainListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.adlr)
		if err != nil {
			return err
		}
		page.adlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AFDDomainListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AFDDomainListResultPage) NotDone() bool {
	return !page.adlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AFDDomainListResultPage) Response() AFDDomainListResult {
	return page.adlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AFDDomainListResultPage) Values() []AFDDomain {
	if page.adlr.IsEmpty() {
		return nil
	}
	return *page.adlr.Value
}

// Creates a new instance of the AFDDomainListResultPage type.
func NewAFDDomainListResultPage(cur AFDDomainListResult, getNextPage func(context.Context, AFDDomainListResult) (AFDDomainListResult, error)) AFDDomainListResultPage {
	return AFDDomainListResultPage{
		fn:   getNextPage,
		adlr: cur,
	}
}

// AFDDomainProperties the JSON object that contains the properties of the domain to create.
type AFDDomainProperties struct {
	// ProfileName - READ-ONLY; The name of the profile which holds the domain.
	ProfileName *string `json:"profileName,omitempty"`
	// TLSSettings - The configuration specifying how to enable HTTPS for the domain - using AzureFrontDoor managed certificate or user's own certificate. If not specified, enabling ssl uses AzureFrontDoor managed certificate by default.
	TLSSettings *AFDDomainHTTPSParameters `json:"tlsSettings,omitempty"`
	// AzureDNSZone - Resource reference to the Azure DNS zone
	AzureDNSZone *ResourceReference `json:"azureDnsZone,omitempty"`
	// PreValidatedCustomDomainResourceID - Resource reference to the Azure resource where custom domain ownership was prevalidated
	PreValidatedCustomDomainResourceID *ResourceReference `json:"preValidatedCustomDomainResourceId,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning status. Possible values include: 'AfdProvisioningStateSucceeded', 'AfdProvisioningStateFailed', 'AfdProvisioningStateUpdating', 'AfdProvisioningStateDeleting', 'AfdProvisioningStateCreating'
	ProvisioningState AfdProvisioningState `json:"provisioningState,omitempty"`
	// DeploymentStatus - READ-ONLY; Possible values include: 'DeploymentStatusNotStarted', 'DeploymentStatusInProgress', 'DeploymentStatusSucceeded', 'DeploymentStatusFailed'
	DeploymentStatus DeploymentStatus `json:"deploymentStatus,omitempty"`
	// DomainValidationState - READ-ONLY; Provisioning substate shows the progress of custom HTTPS enabling/disabling process step by step. DCV stands for DomainControlValidation. Possible values include: 'DomainValidationStateUnknown', 'DomainValidationStateSubmitting', 'DomainValidationStatePending', 'DomainValidationStateRejected', 'DomainValidationStateTimedOut', 'DomainValidationStatePendingRevalidation', 'DomainValidationStateApproved', 'DomainValidationStateRefreshingValidationToken', 'DomainValidationStateInternalError'
	DomainValidationState DomainValidationState `json:"domainValidationState,omitempty"`
	// HostName - The host name of the domain. Must be a domain name.
	HostName *string `json:"hostName,omitempty"`
	// ValidationProperties - READ-ONLY; Values the customer needs to validate domain ownership
	ValidationProperties *DomainValidationProperties `json:"validationProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for AFDDomainProperties.
func (adp AFDDomainProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if adp.TLSSettings != nil {
		objectMap["tlsSettings"] = adp.TLSSettings
	}
	if adp.AzureDNSZone != nil {
		objectMap["azureDnsZone"] = adp.AzureDNSZone
	}
	if adp.PreValidatedCustomDomainResourceID != nil {
		objectMap["preValidatedCustomDomainResourceId"] = adp.PreValidatedCustomDomainResourceID
	}
	if adp.HostName != nil {
		objectMap["hostName"] = adp.HostName
	}
	return json.Marshal(objectMap)
}

// AFDDomainUpdateParameters the domain JSON object required for domain creation or update.
type AFDDomainUpdateParameters struct {
	*AFDDomainUpdatePropertiesParameters `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for AFDDomainUpdateParameters.
func (adup AFDDomainUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if adup.AFDDomainUpdatePropertiesParameters != nil {
		objectMap["properties"] = adup.AFDDomainUpdatePropertiesParameters
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AFDDomainUpdateParameters struct.
func (adup *AFDDomainUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var aFDDomainUpdatePropertiesParameters AFDDomainUpdatePropertiesParameters
				err = json.Unmarshal(*v, &aFDDomainUpdatePropertiesParameters)
				if err != nil {
					return err
				}
				adup.AFDDomainUpdatePropertiesParameters = &aFDDomainUpdatePropertiesParameters
			}
		}
	}

	return nil
}

// AFDDomainUpdatePropertiesParameters the JSON object that contains the properties of the domain to
// create.
type AFDDomainUpdatePropertiesParameters struct {
	// ProfileName - READ-ONLY; The name of the profile which holds the domain.
	ProfileName *string `json:"profileName,omitempty"`
	// TLSSettings - The configuration specifying how to enable HTTPS for the domain - using AzureFrontDoor managed certificate or user's own certificate. If not specified, enabling ssl uses AzureFrontDoor managed certificate by default.
	TLSSettings *AFDDomainHTTPSParameters `json:"tlsSettings,omitempty"`
	// AzureDNSZone - Resource reference to the Azure DNS zone
	AzureDNSZone *ResourceReference `json:"azureDnsZone,omitempty"`
	// PreValidatedCustomDomainResourceID - Resource reference to the Azure resource where custom domain ownership was prevalidated
	PreValidatedCustomDomainResourceID *ResourceReference `json:"preValidatedCustomDomainResourceId,omitempty"`
}

// MarshalJSON is the custom marshaler for AFDDomainUpdatePropertiesParameters.
func (adupp AFDDomainUpdatePropertiesParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if adupp.TLSSettings != nil {
		objectMap["tlsSettings"] = adupp.TLSSettings
	}
	if adupp.AzureDNSZone != nil {
		objectMap["azureDnsZone"] = adupp.AzureDNSZone
	}
	if adupp.PreValidatedCustomDomainResourceID != nil {
		objectMap["preValidatedCustomDomainResourceId"] = adupp.PreValidatedCustomDomainResourceID
	}
	return json.Marshal(objectMap)
}

// AFDEndpoint CDN endpoint is the entity within a CDN profile containing configuration information such as
// origin, protocol, content caching and delivery behavior. The AzureFrontDoor endpoint uses the URL format
// <endpointname>.azureedge.net.
type AFDEndpoint struct {
	autorest.Response      `json:"-"`
	*AFDEndpointProperties `json:"properties,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for AFDEndpoint.
func (ae AFDEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ae.AFDEndpointProperties != nil {
		objectMap["properties"] = ae.AFDEndpointProperties
	}
	if ae.Location != nil {
		objectMap["location"] = ae.Location
	}
	if ae.Tags != nil {
		objectMap["tags"] = ae.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AFDEndpoint struct.
func (ae *AFDEndpoint) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var aFDEndpointProperties AFDEndpointProperties
				err = json.Unmarshal(*v, &aFDEndpointProperties)
				if err != nil {
					return err
				}
				ae.AFDEndpointProperties = &aFDEndpointProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ae.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ae.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ae.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ae.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ae.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				ae.SystemData = &systemData
			}
		}
	}

	return nil
}

// AFDEndpointListResult result of the request to list endpoints. It contains a list of endpoint objects
// and a URL link to get the next set of results.
type AFDEndpointListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of AzureFrontDoor endpoints within a profile
	Value *[]AFDEndpoint `json:"value,omitempty"`
	// NextLink - URL to get the next set of endpoint objects if there is any.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for AFDEndpointListResult.
func (aelr AFDEndpointListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aelr.NextLink != nil {
		objectMap["nextLink"] = aelr.NextLink
	}
	return json.Marshal(objectMap)
}

// AFDEndpointListResultIterator provides access to a complete listing of AFDEndpoint values.
type AFDEndpointListResultIterator struct {
	i    int
	page AFDEndpointListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AFDEndpointListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AFDEndpointListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AFDEndpointListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AFDEndpointListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AFDEndpointListResultIterator) Response() AFDEndpointListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AFDEndpointListResultIterator) Value() AFDEndpoint {
	if !iter.page.NotDone() {
		return AFDEndpoint{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AFDEndpointListResultIterator type.
func NewAFDEndpointListResultIterator(page AFDEndpointListResultPage) AFDEndpointListResultIterator {
	return AFDEndpointListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (aelr AFDEndpointListResult) IsEmpty() bool {
	return aelr.Value == nil || len(*aelr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (aelr AFDEndpointListResult) hasNextLink() bool {
	return aelr.NextLink != nil && len(*aelr.NextLink) != 0
}

// aFDEndpointListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (aelr AFDEndpointListResult) aFDEndpointListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !aelr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(aelr.NextLink)))
}

// AFDEndpointListResultPage contains a page of AFDEndpoint values.
type AFDEndpointListResultPage struct {
	fn   func(context.Context, AFDEndpointListResult) (AFDEndpointListResult, error)
	aelr AFDEndpointListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AFDEndpointListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AFDEndpointListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.aelr)
		if err != nil {
			return err
		}
		page.aelr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AFDEndpointListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AFDEndpointListResultPage) NotDone() bool {
	return !page.aelr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AFDEndpointListResultPage) Response() AFDEndpointListResult {
	return page.aelr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AFDEndpointListResultPage) Values() []AFDEndpoint {
	if page.aelr.IsEmpty() {
		return nil
	}
	return *page.aelr.Value
}

// Creates a new instance of the AFDEndpointListResultPage type.
func NewAFDEndpointListResultPage(cur AFDEndpointListResult, getNextPage func(context.Context, AFDEndpointListResult) (AFDEndpointListResult, error)) AFDEndpointListResultPage {
	return AFDEndpointListResultPage{
		fn:   getNextPage,
		aelr: cur,
	}
}

// AFDEndpointProperties the JSON object that contains the properties required to create an endpoint.
type AFDEndpointProperties struct {
	// ProfileName - READ-ONLY; The name of the profile which holds the endpoint.
	ProfileName *string `json:"profileName,omitempty"`
	// EnabledState - Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'. Possible values include: 'EnabledStateEnabled', 'EnabledStateDisabled'
	EnabledState EnabledState `json:"enabledState,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning status. Possible values include: 'AfdProvisioningStateSucceeded', 'AfdProvisioningStateFailed', 'AfdProvisioningStateUpdating', 'AfdProvisioningStateDeleting', 'AfdProvisioningStateCreating'
	ProvisioningState AfdProvisioningState `json:"provisioningState,omitempty"`
	// DeploymentStatus - READ-ONLY; Possible values include: 'DeploymentStatusNotStarted', 'DeploymentStatusInProgress', 'DeploymentStatusSucceeded', 'DeploymentStatusFailed'
	DeploymentStatus DeploymentStatus `json:"deploymentStatus,omitempty"`
	// HostName - READ-ONLY; The host name of the endpoint structured as {endpointName}.{DNSZone}, e.g. contoso.azureedge.net
	HostName *string `json:"hostName,omitempty"`
	// AutoGeneratedDomainNameLabelScope - Indicates the endpoint name reuse scope. The default value is TenantReuse. Possible values include: 'AutoGeneratedDomainNameLabelScopeTenantReuse', 'AutoGeneratedDomainNameLabelScopeSubscriptionReuse', 'AutoGeneratedDomainNameLabelScopeResourceGroupReuse', 'AutoGeneratedDomainNameLabelScopeNoReuse'
	AutoGeneratedDomainNameLabelScope AutoGeneratedDomainNameLabelScope `json:"autoGeneratedDomainNameLabelScope,omitempty"`
}

// MarshalJSON is the custom marshaler for AFDEndpointProperties.
func (aep AFDEndpointProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aep.EnabledState != "" {
		objectMap["enabledState"] = aep.EnabledState
	}
	if aep.AutoGeneratedDomainNameLabelScope != "" {
		objectMap["autoGeneratedDomainNameLabelScope"] = aep.AutoGeneratedDomainNameLabelScope
	}
	return json.Marshal(objectMap)
}

// AFDEndpointPropertiesUpdateParameters the JSON object containing endpoint update parameters.
type AFDEndpointPropertiesUpdateParameters struct {
	// ProfileName - READ-ONLY; The name of the profile which holds the endpoint.
	ProfileName *string `json:"profileName,omitempty"`
	// EnabledState - Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'. Possible values include: 'EnabledStateEnabled', 'EnabledStateDisabled'
	EnabledState EnabledState `json:"enabledState,omitempty"`
}

// MarshalJSON is the custom marshaler for AFDEndpointPropertiesUpdateParameters.
func (aepup AFDEndpointPropertiesUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aepup.EnabledState != "" {
		objectMap["enabledState"] = aepup.EnabledState
	}
	return json.Marshal(objectMap)
}

// AFDEndpointsCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AFDEndpointsCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AFDEndpointsClient) (AFDEndpoint, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AFDEndpointsCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AFDEndpointsCreateFuture.Result.
func (future *AFDEndpointsCreateFuture) result(client AFDEndpointsClient) (ae AFDEndpoint, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.AFDEndpointsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ae.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("cdn.AFDEndpointsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ae.Response.Response, err = future.GetResult(sender); err == nil && ae.Response.Response.StatusCode != http.StatusNoContent {
		ae, err = client.CreateResponder(ae.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.AFDEndpointsCreateFuture", "Result", ae.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AFDEndpointsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AFDEndpointsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AFDEndpointsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AFDEndpointsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AFDEndpointsDeleteFuture.Result.
func (future *AFDEndpointsDeleteFuture) result(client AFDEndpointsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.AFDEndpointsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("cdn.AFDEndpointsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// AFDEndpointsPurgeContentFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AFDEndpointsPurgeContentFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AFDEndpointsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AFDEndpointsPurgeContentFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AFDEndpointsPurgeContentFuture.Result.
func (future *AFDEndpointsPurgeContentFuture) result(client AFDEndpointsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.AFDEndpointsPurgeContentFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("cdn.AFDEndpointsPurgeContentFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// AFDEndpointsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AFDEndpointsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AFDEndpointsClient) (AFDEndpoint, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AFDEndpointsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AFDEndpointsUpdateFuture.Result.
func (future *AFDEndpointsUpdateFuture) result(client AFDEndpointsClient) (ae AFDEndpoint, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.AFDEndpointsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ae.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("cdn.AFDEndpointsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ae.Response.Response, err = future.GetResult(sender); err == nil && ae.Response.Response.StatusCode != http.StatusNoContent {
		ae, err = client.UpdateResponder(ae.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.AFDEndpointsUpdateFuture", "Result", ae.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AFDEndpointUpdateParameters properties required to create or update an endpoint.
type AFDEndpointUpdateParameters struct {
	// Tags - Endpoint tags.
	Tags                                   map[string]*string `json:"tags"`
	*AFDEndpointPropertiesUpdateParameters `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for AFDEndpointUpdateParameters.
func (aeup AFDEndpointUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aeup.Tags != nil {
		objectMap["tags"] = aeup.Tags
	}
	if aeup.AFDEndpointPropertiesUpdateParameters != nil {
		objectMap["properties"] = aeup.AFDEndpointPropertiesUpdateParameters
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AFDEndpointUpdateParameters struct.
func (aeup *AFDEndpointUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				aeup.Tags = tags
			}
		case "properties":
			if v != nil {
				var aFDEndpointPropertiesUpdateParameters AFDEndpointPropertiesUpdateParameters
				err = json.Unmarshal(*v, &aFDEndpointPropertiesUpdateParameters)
				if err != nil {
					return err
				}
				aeup.AFDEndpointPropertiesUpdateParameters = &aFDEndpointPropertiesUpdateParameters
			}
		}
	}

	return nil
}

// AfdErrorResponse common error response for all Azure Resource Manager APIs to return error details for
// failed operations. (This also follows the OData error response format.).
type AfdErrorResponse struct {
	// Error - The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// AFDOrigin CDN origin is the source of the content being delivered via CDN. When the edge nodes
// represented by an endpoint do not have the requested content cached, they attempt to fetch it from one
// or more of the configured origins.
type AFDOrigin struct {
	autorest.Response    `json:"-"`
	*AFDOriginProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for AFDOrigin.
func (ao AFDOrigin) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ao.AFDOriginProperties != nil {
		objectMap["properties"] = ao.AFDOriginProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AFDOrigin struct.
func (ao *AFDOrigin) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var aFDOriginProperties AFDOriginProperties
				err = json.Unmarshal(*v, &aFDOriginProperties)
				if err != nil {
					return err
				}
				ao.AFDOriginProperties = &aFDOriginProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ao.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ao.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ao.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				ao.SystemData = &systemData
			}
		}
	}

	return nil
}

// AFDOriginGroup aFDOrigin group comprising of origins is used for load balancing to origins when the
// content cannot be served from CDN.
type AFDOriginGroup struct {
	autorest.Response         `json:"-"`
	*AFDOriginGroupProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for AFDOriginGroup.
func (aog AFDOriginGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aog.AFDOriginGroupProperties != nil {
		objectMap["properties"] = aog.AFDOriginGroupProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AFDOriginGroup struct.
func (aog *AFDOriginGroup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var aFDOriginGroupProperties AFDOriginGroupProperties
				err = json.Unmarshal(*v, &aFDOriginGroupProperties)
				if err != nil {
					return err
				}
				aog.AFDOriginGroupProperties = &aFDOriginGroupProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				aog.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				aog.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				aog.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				aog.SystemData = &systemData
			}
		}
	}

	return nil
}

// AFDOriginGroupListResult result of the request to list origin groups. It contains a list of origin
// groups objects and a URL link to get the next set of results.
type AFDOriginGroupListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of CDN origin groups within an endpoint
	Value *[]AFDOriginGroup `json:"value,omitempty"`
	// NextLink - URL to get the next set of origin objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for AFDOriginGroupListResult.
func (aoglr AFDOriginGroupListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aoglr.NextLink != nil {
		objectMap["nextLink"] = aoglr.NextLink
	}
	return json.Marshal(objectMap)
}

// AFDOriginGroupListResultIterator provides access to a complete listing of AFDOriginGroup values.
type AFDOriginGroupListResultIterator struct {
	i    int
	page AFDOriginGroupListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AFDOriginGroupListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AFDOriginGroupListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AFDOriginGroupListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AFDOriginGroupListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AFDOriginGroupListResultIterator) Response() AFDOriginGroupListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AFDOriginGroupListResultIterator) Value() AFDOriginGroup {
	if !iter.page.NotDone() {
		return AFDOriginGroup{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AFDOriginGroupListResultIterator type.
func NewAFDOriginGroupListResultIterator(page AFDOriginGroupListResultPage) AFDOriginGroupListResultIterator {
	return AFDOriginGroupListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (aoglr AFDOriginGroupListResult) IsEmpty() bool {
	return aoglr.Value == nil || len(*aoglr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (aoglr AFDOriginGroupListResult) hasNextLink() bool {
	return aoglr.NextLink != nil && len(*aoglr.NextLink) != 0
}

// aFDOriginGroupListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (aoglr AFDOriginGroupListResult) aFDOriginGroupListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !aoglr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(aoglr.NextLink)))
}

// AFDOriginGroupListResultPage contains a page of AFDOriginGroup values.
type AFDOriginGroupListResultPage struct {
	fn    func(context.Context, AFDOriginGroupListResult) (AFDOriginGroupListResult, error)
	aoglr AFDOriginGroupListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AFDOriginGroupListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AFDOriginGroupListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.aoglr)
		if err != nil {
			return err
		}
		page.aoglr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AFDOriginGroupListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AFDOriginGroupListResultPage) NotDone() bool {
	return !page.aoglr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AFDOriginGroupListResultPage) Response() AFDOriginGroupListResult {
	return page.aoglr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AFDOriginGroupListResultPage) Values() []AFDOriginGroup {
	if page.aoglr.IsEmpty() {
		return nil
	}
	return *page.aoglr.Value
}

// Creates a new instance of the AFDOriginGroupListResultPage type.
func NewAFDOriginGroupListResultPage(cur AFDOriginGroupListResult, getNextPage func(context.Context, AFDOriginGroupListResult) (AFDOriginGroupListResult, error)) AFDOriginGroupListResultPage {
	return AFDOriginGroupListResultPage{
		fn:    getNextPage,
		aoglr: cur,
	}
}

// AFDOriginGroupProperties the JSON object that contains the properties of the origin group.
type AFDOriginGroupProperties struct {
	// ProfileName - READ-ONLY; The name of the profile which holds the origin group.
	ProfileName *string `json:"profileName,omitempty"`
	// LoadBalancingSettings - Load balancing settings for a backend pool
	LoadBalancingSettings *LoadBalancingSettingsParameters `json:"loadBalancingSettings,omitempty"`
	// HealthProbeSettings - Health probe settings to the origin that is used to determine the health of the origin.
	HealthProbeSettings *HealthProbeParameters `json:"healthProbeSettings,omitempty"`
	// TrafficRestorationTimeToHealedOrNewEndpointsInMinutes - Time in minutes to shift the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new endpoint is added. Default is 10 mins. This property is currently not supported.
	TrafficRestorationTimeToHealedOrNewEndpointsInMinutes *int32 `json:"trafficRestorationTimeToHealedOrNewEndpointsInMinutes,omitempty"`
	// SessionAffinityState - Whether to allow session affinity on this host. Valid options are 'Enabled' or 'Disabled'. Possible values include: 'EnabledStateEnabled', 'EnabledStateDisabled'
	SessionAffinityState EnabledState `json:"sessionAffinityState,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning status. Possible values include: 'AfdProvisioningStateSucceeded', 'AfdProvisioningStateFailed', 'AfdProvisioningStateUpdating', 'AfdProvisioningStateDeleting', 'AfdProvisioningStateCreating'
	ProvisioningState AfdProvisioningState `json:"provisioningState,omitempty"`
	// DeploymentStatus - READ-ONLY; Possible values include: 'DeploymentStatusNotStarted', 'DeploymentStatusInProgress', 'DeploymentStatusSucceeded', 'DeploymentStatusFailed'
	DeploymentStatus DeploymentStatus `json:"deploymentStatus,omitempty"`
}

// MarshalJSON is the custom marshaler for AFDOriginGroupProperties.
func (aogp AFDOriginGroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aogp.LoadBalancingSettings != nil {
		objectMap["loadBalancingSettings"] = aogp.LoadBalancingSettings
	}
	if aogp.HealthProbeSettings != nil {
		objectMap["healthProbeSettings"] = aogp.HealthProbeSettings
	}
	if aogp.TrafficRestorationTimeToHealedOrNewEndpointsInMinutes != nil {
		objectMap["trafficRestorationTimeToHealedOrNewEndpointsInMinutes"] = aogp.TrafficRestorationTimeToHealedOrNewEndpointsInMinutes
	}
	if aogp.SessionAffinityState != "" {
		objectMap["sessionAffinityState"] = aogp.SessionAffinityState
	}
	return json.Marshal(objectMap)
}

// AFDOriginGroupsCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AFDOriginGroupsCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AFDOriginGroupsClient) (AFDOriginGroup, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AFDOriginGroupsCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AFDOriginGroupsCreateFuture.Result.
func (future *AFDOriginGroupsCreateFuture) result(client AFDOriginGroupsClient) (aog AFDOriginGroup, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.AFDOriginGroupsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		aog.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("cdn.AFDOriginGroupsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if aog.Response.Response, err = future.GetResult(sender); err == nil && aog.Response.Response.StatusCode != http.StatusNoContent {
		aog, err = client.CreateResponder(aog.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.AFDOriginGroupsCreateFuture", "Result", aog.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AFDOriginGroupsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AFDOriginGroupsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AFDOriginGroupsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AFDOriginGroupsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AFDOriginGroupsDeleteFuture.Result.
func (future *AFDOriginGroupsDeleteFuture) result(client AFDOriginGroupsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.AFDOriginGroupsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("cdn.AFDOriginGroupsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// AFDOriginGroupsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AFDOriginGroupsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AFDOriginGroupsClient) (AFDOriginGroup, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AFDOriginGroupsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AFDOriginGroupsUpdateFuture.Result.
func (future *AFDOriginGroupsUpdateFuture) result(client AFDOriginGroupsClient) (aog AFDOriginGroup, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.AFDOriginGroupsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		aog.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("cdn.AFDOriginGroupsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if aog.Response.Response, err = future.GetResult(sender); err == nil && aog.Response.Response.StatusCode != http.StatusNoContent {
		aog, err = client.UpdateResponder(aog.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.AFDOriginGroupsUpdateFuture", "Result", aog.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AFDOriginGroupUpdateParameters aFDOrigin group properties needed for origin group creation or update.
type AFDOriginGroupUpdateParameters struct {
	*AFDOriginGroupUpdatePropertiesParameters `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for AFDOriginGroupUpdateParameters.
func (aogup AFDOriginGroupUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aogup.AFDOriginGroupUpdatePropertiesParameters != nil {
		objectMap["properties"] = aogup.AFDOriginGroupUpdatePropertiesParameters
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AFDOriginGroupUpdateParameters struct.
func (aogup *AFDOriginGroupUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var aFDOriginGroupUpdatePropertiesParameters AFDOriginGroupUpdatePropertiesParameters
				err = json.Unmarshal(*v, &aFDOriginGroupUpdatePropertiesParameters)
				if err != nil {
					return err
				}
				aogup.AFDOriginGroupUpdatePropertiesParameters = &aFDOriginGroupUpdatePropertiesParameters
			}
		}
	}

	return nil
}

// AFDOriginGroupUpdatePropertiesParameters the JSON object that contains the properties of the origin
// group.
type AFDOriginGroupUpdatePropertiesParameters struct {
	// ProfileName - READ-ONLY; The name of the profile which holds the origin group.
	ProfileName *string `json:"profileName,omitempty"`
	// LoadBalancingSettings - Load balancing settings for a backend pool
	LoadBalancingSettings *LoadBalancingSettingsParameters `json:"loadBalancingSettings,omitempty"`
	// HealthProbeSettings - Health probe settings to the origin that is used to determine the health of the origin.
	HealthProbeSettings *HealthProbeParameters `json:"healthProbeSettings,omitempty"`
	// TrafficRestorationTimeToHealedOrNewEndpointsInMinutes - Time in minutes to shift the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new endpoint is added. Default is 10 mins. This property is currently not supported.
	TrafficRestorationTimeToHealedOrNewEndpointsInMinutes *int32 `json:"trafficRestorationTimeToHealedOrNewEndpointsInMinutes,omitempty"`
	// SessionAffinityState - Whether to allow session affinity on this host. Valid options are 'Enabled' or 'Disabled'. Possible values include: 'EnabledStateEnabled', 'EnabledStateDisabled'
	SessionAffinityState EnabledState `json:"sessionAffinityState,omitempty"`
}

// MarshalJSON is the custom marshaler for AFDOriginGroupUpdatePropertiesParameters.
func (aogupp AFDOriginGroupUpdatePropertiesParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aogupp.LoadBalancingSettings != nil {
		objectMap["loadBalancingSettings"] = aogupp.LoadBalancingSettings
	}
	if aogupp.HealthProbeSettings != nil {
		objectMap["healthProbeSettings"] = aogupp.HealthProbeSettings
	}
	if aogupp.TrafficRestorationTimeToHealedOrNewEndpointsInMinutes != nil {
		objectMap["trafficRestorationTimeToHealedOrNewEndpointsInMinutes"] = aogupp.TrafficRestorationTimeToHealedOrNewEndpointsInMinutes
	}
	if aogupp.SessionAffinityState != "" {
		objectMap["sessionAffinityState"] = aogupp.SessionAffinityState
	}
	return json.Marshal(objectMap)
}

// AFDOriginListResult result of the request to list origins. It contains a list of origin objects and a
// URL link to get the next set of results.
type AFDOriginListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of CDN origins within an endpoint
	Value *[]AFDOrigin `json:"value,omitempty"`
	// NextLink - URL to get the next set of origin objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for AFDOriginListResult.
func (aolr AFDOriginListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aolr.NextLink != nil {
		objectMap["nextLink"] = aolr.NextLink
	}
	return json.Marshal(objectMap)
}

// AFDOriginListResultIterator provides access to a complete listing of AFDOrigin values.
type AFDOriginListResultIterator struct {
	i    int
	page AFDOriginListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AFDOriginListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AFDOriginListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AFDOriginListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AFDOriginListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AFDOriginListResultIterator) Response() AFDOriginListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AFDOriginListResultIterator) Value() AFDOrigin {
	if !iter.page.NotDone() {
		return AFDOrigin{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AFDOriginListResultIterator type.
func NewAFDOriginListResultIterator(page AFDOriginListResultPage) AFDOriginListResultIterator {
	return AFDOriginListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (aolr AFDOriginListResult) IsEmpty() bool {
	return aolr.Value == nil || len(*aolr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (aolr AFDOriginListResult) hasNextLink() bool {
	return aolr.NextLink != nil && len(*aolr.NextLink) != 0
}

// aFDOriginListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (aolr AFDOriginListResult) aFDOriginListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !aolr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(aolr.NextLink)))
}

// AFDOriginListResultPage contains a page of AFDOrigin values.
type AFDOriginListResultPage struct {
	fn   func(context.Context, AFDOriginListResult) (AFDOriginListResult, error)
	aolr AFDOriginListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AFDOriginListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AFDOriginListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.aolr)
		if err != nil {
			return err
		}
		page.aolr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AFDOriginListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AFDOriginListResultPage) NotDone() bool {
	return !page.aolr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AFDOriginListResultPage) Response() AFDOriginListResult {
	return page.aolr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AFDOriginListResultPage) Values() []AFDOrigin {
	if page.aolr.IsEmpty() {
		return nil
	}
	return *page.aolr.Value
}

// Creates a new instance of the AFDOriginListResultPage type.
func NewAFDOriginListResultPage(cur AFDOriginListResult, getNextPage func(context.Context, AFDOriginListResult) (AFDOriginListResult, error)) AFDOriginListResultPage {
	return AFDOriginListResultPage{
		fn:   getNextPage,
		aolr: cur,
	}
}

// AFDOriginProperties the JSON object that contains the properties of the origin.
type AFDOriginProperties struct {
	// OriginGroupName - READ-ONLY; The name of the origin group which contains this origin.
	OriginGroupName *string `json:"originGroupName,omitempty"`
	// AzureOrigin - Resource reference to the Azure origin resource.
	AzureOrigin *ResourceReference `json:"azureOrigin,omitempty"`
	// HostName - The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses are supported.This should be unique across all origins in an endpoint.
	HostName *string `json:"hostName,omitempty"`
	// HTTPPort - The value of the HTTP port. Must be between 1 and 65535.
	HTTPPort *int32 `json:"httpPort,omitempty"`
	// HTTPSPort - The value of the HTTPS port. Must be between 1 and 65535.
	HTTPSPort *int32 `json:"httpsPort,omitempty"`
	// OriginHostHeader - The host header value sent to the origin with each request. If you leave this blank, the request hostname determines this value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services require this host header value to match the origin hostname by default. This overrides the host header defined at Endpoint
	OriginHostHeader *string `json:"originHostHeader,omitempty"`
	// Priority - Priority of origin in given origin group for load balancing. Higher priorities will not be used for load balancing if any lower priority origin is healthy.Must be between 1 and 5
	Priority *int32 `json:"priority,omitempty"`
	// Weight - Weight of the origin in given origin group for load balancing. Must be between 1 and 1000
	Weight *int32 `json:"weight,omitempty"`
	// SharedPrivateLinkResource - The properties of the private link resource for private origin.
	SharedPrivateLinkResource *SharedPrivateLinkResourceProperties `json:"sharedPrivateLinkResource,omitempty"`
	// EnabledState - Whether to enable health probes to be made against backends defined under backendPools. Health probes can only be disabled if there is a single enabled backend in single enabled backend pool. Possible values include: 'EnabledStateEnabled', 'EnabledStateDisabled'
	EnabledState EnabledState `json:"enabledState,omitempty"`
	// EnforceCertificateNameCheck - Whether to enable certificate name check at origin level
	EnforceCertificateNameCheck *bool `json:"enforceCertificateNameCheck,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning status. Possible values include: 'AfdProvisioningStateSucceeded', 'AfdProvisioningStateFailed', 'AfdProvisioningStateUpdating', 'AfdProvisioningStateDeleting', 'AfdProvisioningStateCreating'
	ProvisioningState AfdProvisioningState `json:"provisioningState,omitempty"`
	// DeploymentStatus - READ-ONLY; Possible values include: 'DeploymentStatusNotStarted', 'DeploymentStatusInProgress', 'DeploymentStatusSucceeded', 'DeploymentStatusFailed'
	DeploymentStatus DeploymentStatus `json:"deploymentStatus,omitempty"`
}

// MarshalJSON is the custom marshaler for AFDOriginProperties.
func (aop AFDOriginProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aop.AzureOrigin != nil {
		objectMap["azureOrigin"] = aop.AzureOrigin
	}
	if aop.HostName != nil {
		objectMap["hostName"] = aop.HostName
	}
	if aop.HTTPPort != nil {
		objectMap["httpPort"] = aop.HTTPPort
	}
	if aop.HTTPSPort != nil {
		objectMap["httpsPort"] = aop.HTTPSPort
	}
	if aop.OriginHostHeader != nil {
		objectMap["originHostHeader"] = aop.OriginHostHeader
	}
	if aop.Priority != nil {
		objectMap["priority"] = aop.Priority
	}
	if aop.Weight != nil {
		objectMap["weight"] = aop.Weight
	}
	if aop.SharedPrivateLinkResource != nil {
		objectMap["sharedPrivateLinkResource"] = aop.SharedPrivateLinkResource
	}
	if aop.EnabledState != "" {
		objectMap["enabledState"] = aop.EnabledState
	}
	if aop.EnforceCertificateNameCheck != nil {
		objectMap["enforceCertificateNameCheck"] = aop.EnforceCertificateNameCheck
	}
	return json.Marshal(objectMap)
}

// AFDOriginsCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AFDOriginsCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AFDOriginsClient) (AFDOrigin, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AFDOriginsCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AFDOriginsCreateFuture.Result.
func (future *AFDOriginsCreateFuture) result(client AFDOriginsClient) (ao AFDOrigin, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.AFDOriginsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ao.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("cdn.AFDOriginsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ao.Response.Response, err = future.GetResult(sender); err == nil && ao.Response.Response.StatusCode != http.StatusNoContent {
		ao, err = client.CreateResponder(ao.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.AFDOriginsCreateFuture", "Result", ao.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AFDOriginsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AFDOriginsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AFDOriginsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AFDOriginsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AFDOriginsDeleteFuture.Result.
func (future *AFDOriginsDeleteFuture) result(client AFDOriginsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.AFDOriginsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("cdn.AFDOriginsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// AFDOriginsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AFDOriginsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AFDOriginsClient) (AFDOrigin, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AFDOriginsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AFDOriginsUpdateFuture.Result.
func (future *AFDOriginsUpdateFuture) result(client AFDOriginsClient) (ao AFDOrigin, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.AFDOriginsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ao.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("cdn.AFDOriginsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ao.Response.Response, err = future.GetResult(sender); err == nil && ao.Response.Response.StatusCode != http.StatusNoContent {
		ao, err = client.UpdateResponder(ao.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.AFDOriginsUpdateFuture", "Result", ao.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AFDOriginUpdateParameters aFDOrigin properties needed for origin update.
type AFDOriginUpdateParameters struct {
	*AFDOriginUpdatePropertiesParameters `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for AFDOriginUpdateParameters.
func (aoup AFDOriginUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aoup.AFDOriginUpdatePropertiesParameters != nil {
		objectMap["properties"] = aoup.AFDOriginUpdatePropertiesParameters
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AFDOriginUpdateParameters struct.
func (aoup *AFDOriginUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var aFDOriginUpdatePropertiesParameters AFDOriginUpdatePropertiesParameters
				err = json.Unmarshal(*v, &aFDOriginUpdatePropertiesParameters)
				if err != nil {
					return err
				}
				aoup.AFDOriginUpdatePropertiesParameters = &aFDOriginUpdatePropertiesParameters
			}
		}
	}

	return nil
}

// AFDOriginUpdatePropertiesParameters the JSON object that contains the properties of the origin.
type AFDOriginUpdatePropertiesParameters struct {
	// OriginGroupName - READ-ONLY; The name of the origin group which contains this origin.
	OriginGroupName *string `json:"originGroupName,omitempty"`
	// AzureOrigin - Resource reference to the Azure origin resource.
	AzureOrigin *ResourceReference `json:"azureOrigin,omitempty"`
	// HostName - The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses are supported.This should be unique across all origins in an endpoint.
	HostName *string `json:"hostName,omitempty"`
	// HTTPPort - The value of the HTTP port. Must be between 1 and 65535.
	HTTPPort *int32 `json:"httpPort,omitempty"`
	// HTTPSPort - The value of the HTTPS port. Must be between 1 and 65535.
	HTTPSPort *int32 `json:"httpsPort,omitempty"`
	// OriginHostHeader - The host header value sent to the origin with each request. If you leave this blank, the request hostname determines this value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services require this host header value to match the origin hostname by default. This overrides the host header defined at Endpoint
	OriginHostHeader *string `json:"originHostHeader,omitempty"`
	// Priority - Priority of origin in given origin group for load balancing. Higher priorities will not be used for load balancing if any lower priority origin is healthy.Must be between 1 and 5
	Priority *int32 `json:"priority,omitempty"`
	// Weight - Weight of the origin in given origin group for load balancing. Must be between 1 and 1000
	Weight *int32 `json:"weight,omitempty"`
	// SharedPrivateLinkResource - The properties of the private link resource for private origin.
	SharedPrivateLinkResource *SharedPrivateLinkResourceProperties `json:"sharedPrivateLinkResource,omitempty"`
	// EnabledState - Whether to enable health probes to be made against backends defined under backendPools. Health probes can only be disabled if there is a single enabled backend in single enabled backend pool. Possible values include: 'EnabledStateEnabled', 'EnabledStateDisabled'
	EnabledState EnabledState `json:"enabledState,omitempty"`
	// EnforceCertificateNameCheck - Whether to enable certificate name check at origin level
	EnforceCertificateNameCheck *bool `json:"enforceCertificateNameCheck,omitempty"`
}

// MarshalJSON is the custom marshaler for AFDOriginUpdatePropertiesParameters.
func (aoupp AFDOriginUpdatePropertiesParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aoupp.AzureOrigin != nil {
		objectMap["azureOrigin"] = aoupp.AzureOrigin
	}
	if aoupp.HostName != nil {
		objectMap["hostName"] = aoupp.HostName
	}
	if aoupp.HTTPPort != nil {
		objectMap["httpPort"] = aoupp.HTTPPort
	}
	if aoupp.HTTPSPort != nil {
		objectMap["httpsPort"] = aoupp.HTTPSPort
	}
	if aoupp.OriginHostHeader != nil {
		objectMap["originHostHeader"] = aoupp.OriginHostHeader
	}
	if aoupp.Priority != nil {
		objectMap["priority"] = aoupp.Priority
	}
	if aoupp.Weight != nil {
		objectMap["weight"] = aoupp.Weight
	}
	if aoupp.SharedPrivateLinkResource != nil {
		objectMap["sharedPrivateLinkResource"] = aoupp.SharedPrivateLinkResource
	}
	if aoupp.EnabledState != "" {
		objectMap["enabledState"] = aoupp.EnabledState
	}
	if aoupp.EnforceCertificateNameCheck != nil {
		objectMap["enforceCertificateNameCheck"] = aoupp.EnforceCertificateNameCheck
	}
	return json.Marshal(objectMap)
}

// AfdPurgeParameters parameters required for content purge.
type AfdPurgeParameters struct {
	// ContentPaths - The path to the content to be purged. Can describe a file path or a wild card directory.
	ContentPaths *[]string `json:"contentPaths,omitempty"`
	// Domains - List of domains.
	Domains *[]string `json:"domains,omitempty"`
}

// AfdRouteCacheConfiguration caching settings for a caching-type route. To disable caching, do not provide
// a cacheConfiguration object.
type AfdRouteCacheConfiguration struct {
	// QueryStringCachingBehavior - Defines how Frontdoor caches requests that include query strings. You can ignore any query strings when caching, ignore specific query strings, cache every request with a unique URL, or cache specific query strings. Possible values include: 'AfdQueryStringCachingBehaviorIgnoreQueryString', 'AfdQueryStringCachingBehaviorUseQueryString', 'AfdQueryStringCachingBehaviorIgnoreSpecifiedQueryStrings', 'AfdQueryStringCachingBehaviorIncludeSpecifiedQueryStrings'
	QueryStringCachingBehavior AfdQueryStringCachingBehavior `json:"queryStringCachingBehavior,omitempty"`
	// QueryParameters - query parameters to include or exclude (comma separated).
	QueryParameters *string `json:"queryParameters,omitempty"`
	// CompressionSettings - compression settings.
	CompressionSettings *CompressionSettings `json:"compressionSettings,omitempty"`
}

// AFDStateProperties the tracking states for afd resources.
type AFDStateProperties struct {
	// ProvisioningState - READ-ONLY; Provisioning status. Possible values include: 'AfdProvisioningStateSucceeded', 'AfdProvisioningStateFailed', 'AfdProvisioningStateUpdating', 'AfdProvisioningStateDeleting', 'AfdProvisioningStateCreating'
	ProvisioningState AfdProvisioningState `json:"provisioningState,omitempty"`
	// DeploymentStatus - READ-ONLY; Possible values include: 'DeploymentStatusNotStarted', 'DeploymentStatusInProgress', 'DeploymentStatusSucceeded', 'DeploymentStatusFailed'
	DeploymentStatus DeploymentStatus `json:"deploymentStatus,omitempty"`
}

// MarshalJSON is the custom marshaler for AFDStateProperties.
func (asp AFDStateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// AzureFirstPartyManagedCertificate azure FirstParty Managed Certificate provided by other first party
// resource providers to enable HTTPS.
type AzureFirstPartyManagedCertificate struct {
	// Type - Possible values include: 'SecretTypeURLSigningKey', 'SecretTypeCustomerCertificate', 'SecretTypeManagedCertificate', 'SecretTypeAzureFirstPartyManagedCertificate'
	Type SecretType `json:"type,omitempty"`
	// Subject - READ-ONLY; Subject name in the certificate.
	Subject *string `json:"subject,omitempty"`
	// ExpirationDate - READ-ONLY; Certificate expiration date.
	ExpirationDate *string `json:"expirationDate,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureFirstPartyManagedCertificate.
func (afpmc AzureFirstPartyManagedCertificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if afpmc.Type != "" {
		objectMap["type"] = afpmc.Type
	}
	return json.Marshal(objectMap)
}

// AzureFirstPartyManagedCertificateParameters azure FirstParty Managed Certificate provided by other first
// party resource providers to enable HTTPS.
type AzureFirstPartyManagedCertificateParameters struct {
	// Type - Possible values include: 'TypeBasicSecretParametersTypeSecretParameters', 'TypeBasicSecretParametersTypeURLSigningKey', 'TypeBasicSecretParametersTypeManagedCertificate', 'TypeBasicSecretParametersTypeCustomerCertificate', 'TypeBasicSecretParametersTypeAzureFirstPartyManagedCertificate'
	Type TypeBasicSecretParameters `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureFirstPartyManagedCertificateParameters.
func (afpmcp AzureFirstPartyManagedCertificateParameters) MarshalJSON() ([]byte, error) {
	afpmcp.Type = TypeBasicSecretParametersTypeAzureFirstPartyManagedCertificate
	objectMap := make(map[string]interface{})
	if afpmcp.Type != "" {
		objectMap["type"] = afpmcp.Type
	}
	return json.Marshal(objectMap)
}

// AsURLSigningKeyParameters is the BasicSecretParameters implementation for AzureFirstPartyManagedCertificateParameters.
func (afpmcp AzureFirstPartyManagedCertificateParameters) AsURLSigningKeyParameters() (*URLSigningKeyParameters, bool) {
	return nil, false
}

// AsManagedCertificateParameters is the BasicSecretParameters implementation for AzureFirstPartyManagedCertificateParameters.
func (afpmcp AzureFirstPartyManagedCertificateParameters) AsManagedCertificateParameters() (*ManagedCertificateParameters, bool) {
	return nil, false
}

// AsCustomerCertificateParameters is the BasicSecretParameters implementation for AzureFirstPartyManagedCertificateParameters.
func (afpmcp AzureFirstPartyManagedCertificateParameters) AsCustomerCertificateParameters() (*CustomerCertificateParameters, bool) {
	return nil, false
}

// AsAzureFirstPartyManagedCertificateParameters is the BasicSecretParameters implementation for AzureFirstPartyManagedCertificateParameters.
func (afpmcp AzureFirstPartyManagedCertificateParameters) AsAzureFirstPartyManagedCertificateParameters() (*AzureFirstPartyManagedCertificateParameters, bool) {
	return &afpmcp, true
}

// AsSecretParameters is the BasicSecretParameters implementation for AzureFirstPartyManagedCertificateParameters.
func (afpmcp AzureFirstPartyManagedCertificateParameters) AsSecretParameters() (*SecretParameters, bool) {
	return nil, false
}

// AsBasicSecretParameters is the BasicSecretParameters implementation for AzureFirstPartyManagedCertificateParameters.
func (afpmcp AzureFirstPartyManagedCertificateParameters) AsBasicSecretParameters() (BasicSecretParameters, bool) {
	return &afpmcp, true
}

// CacheConfiguration caching settings for a caching-type route. To disable caching, do not provide a
// cacheConfiguration object.
type CacheConfiguration struct {
	// QueryStringCachingBehavior - Defines how Frontdoor caches requests that include query strings. You can ignore any query strings when caching, ignore specific query strings, cache every request with a unique URL, or cache specific query strings. Possible values include: 'RuleQueryStringCachingBehaviorIgnoreQueryString', 'RuleQueryStringCachingBehaviorUseQueryString', 'RuleQueryStringCachingBehaviorIgnoreSpecifiedQueryStrings', 'RuleQueryStringCachingBehaviorIncludeSpecifiedQueryStrings'
	QueryStringCachingBehavior RuleQueryStringCachingBehavior `json:"queryStringCachingBehavior,omitempty"`
	// QueryParameters - query parameters to include or exclude (comma separated).
	QueryParameters *string `json:"queryParameters,omitempty"`
	// IsCompressionEnabled - Indicates whether content compression is enabled. If compression is enabled, content will be served as compressed if user requests for a compressed version. Content won't be compressed on AzureFrontDoor when requested content is smaller than 1 byte or larger than 1 MB. Possible values include: 'RuleIsCompressionEnabledEnabled', 'RuleIsCompressionEnabledDisabled'
	IsCompressionEnabled RuleIsCompressionEnabled `json:"isCompressionEnabled,omitempty"`
	// CacheBehavior - Caching behavior for the requests. Possible values include: 'RuleCacheBehaviorHonorOrigin', 'RuleCacheBehaviorOverrideAlways', 'RuleCacheBehaviorOverrideIfOriginMissing'
	CacheBehavior RuleCacheBehavior `json:"cacheBehavior,omitempty"`
	// CacheDuration - The duration for which the content needs to be cached. Allowed format is [d.]hh:mm:ss
	CacheDuration *string `json:"cacheDuration,omitempty"`
}

// CacheExpirationActionParameters defines the parameters for the cache expiration action.
type CacheExpirationActionParameters struct {
	TypeName *string `json:"typeName,omitempty"`
	// CacheBehavior - Caching behavior for the requests. Possible values include: 'CacheBehaviorBypassCache', 'CacheBehaviorOverride', 'CacheBehaviorSetIfMissing'
	CacheBehavior CacheBehavior `json:"cacheBehavior,omitempty"`
	// CacheType - The level at which the content needs to be cached.
	CacheType *string `json:"cacheType,omitempty"`
	// CacheDuration - The duration for which the content needs to be cached. Allowed format is [d.]hh:mm:ss
	CacheDuration *string `json:"cacheDuration,omitempty"`
}

// CacheKeyQueryStringActionParameters defines the parameters for the cache-key query string action.
type CacheKeyQueryStringActionParameters struct {
	TypeName *string `json:"typeName,omitempty"`
	// QueryStringBehavior - Caching behavior for the requests. Possible values include: 'QueryStringBehaviorInclude', 'QueryStringBehaviorIncludeAll', 'QueryStringBehaviorExclude', 'QueryStringBehaviorExcludeAll'
	QueryStringBehavior QueryStringBehavior `json:"queryStringBehavior,omitempty"`
	// QueryParameters - query parameters to include or exclude (comma separated).
	QueryParameters *string `json:"queryParameters,omitempty"`
}

// Certificate certificate used for https
type Certificate struct {
	// Type - Possible values include: 'SecretTypeURLSigningKey', 'SecretTypeCustomerCertificate', 'SecretTypeManagedCertificate', 'SecretTypeAzureFirstPartyManagedCertificate'
	Type SecretType `json:"type,omitempty"`
	// Subject - READ-ONLY; Subject name in the certificate.
	Subject *string `json:"subject,omitempty"`
	// ExpirationDate - READ-ONLY; Certificate expiration date.
	ExpirationDate *string `json:"expirationDate,omitempty"`
}

// MarshalJSON is the custom marshaler for Certificate.
func (c Certificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.Type != "" {
		objectMap["type"] = c.Type
	}
	return json.Marshal(objectMap)
}

// CertificateSourceParameters defines the parameters for using CDN managed certificate for securing custom
// domain.
type CertificateSourceParameters struct {
	TypeName *string `json:"typeName,omitempty"`
	// CertificateType - Type of certificate used. Possible values include: 'CertificateTypeShared', 'CertificateTypeDedicated'
	CertificateType CertificateType `json:"certificateType,omitempty"`
}

// CheckEndpointNameAvailabilityInput input of CheckNameAvailability API.
type CheckEndpointNameAvailabilityInput struct {
	// Name - The resource name to validate.
	Name *string `json:"name,omitempty"`
	// Type - The type of the resource whose name is to be validated. Possible values include: 'ResourceTypeMicrosoftCdnProfilesEndpoints', 'ResourceTypeMicrosoftCdnProfilesAfdEndpoints'
	Type ResourceType `json:"type,omitempty"`
	// AutoGeneratedDomainNameLabelScope - Indicates the endpoint name reuse scope. The default value is TenantReuse. Possible values include: 'AutoGeneratedDomainNameLabelScopeTenantReuse', 'AutoGeneratedDomainNameLabelScopeSubscriptionReuse', 'AutoGeneratedDomainNameLabelScopeResourceGroupReuse', 'AutoGeneratedDomainNameLabelScopeNoReuse'
	AutoGeneratedDomainNameLabelScope AutoGeneratedDomainNameLabelScope `json:"autoGeneratedDomainNameLabelScope,omitempty"`
}

// CheckEndpointNameAvailabilityOutput output of check name availability API.
type CheckEndpointNameAvailabilityOutput struct {
	autorest.Response `json:"-"`
	// NameAvailable - READ-ONLY; Indicates whether the name is available.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// AvailableHostname - READ-ONLY; Returns the available hostname generated based on the AutoGeneratedDomainNameLabelScope when the name is available, otherwise it returns empty string
	AvailableHostname *string `json:"availableHostname,omitempty"`
	// Reason - READ-ONLY; The reason why the name is not available.
	Reason *string `json:"reason,omitempty"`
	// Message - READ-ONLY; The detailed error message describing why the name is not available.
	Message *string `json:"message,omitempty"`
}

// MarshalJSON is the custom marshaler for CheckEndpointNameAvailabilityOutput.
func (cenao CheckEndpointNameAvailabilityOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// CheckHostNameAvailabilityInput input of CheckHostNameAvailability API.
type CheckHostNameAvailabilityInput struct {
	// HostName - The host name to validate.
	HostName *string `json:"hostName,omitempty"`
}

// CheckNameAvailabilityInput input of CheckNameAvailability API.
type CheckNameAvailabilityInput struct {
	// Name - The resource name to validate.
	Name *string `json:"name,omitempty"`
	// Type - The type of the resource whose name is to be validated. Possible values include: 'ResourceTypeMicrosoftCdnProfilesEndpoints', 'ResourceTypeMicrosoftCdnProfilesAfdEndpoints'
	Type ResourceType `json:"type,omitempty"`
}

// CheckNameAvailabilityOutput output of check name availability API.
type CheckNameAvailabilityOutput struct {
	autorest.Response `json:"-"`
	// NameAvailable - READ-ONLY; Indicates whether the name is available.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Reason - READ-ONLY; The reason why the name is not available.
	Reason *string `json:"reason,omitempty"`
	// Message - READ-ONLY; The detailed error message describing why the name is not available.
	Message *string `json:"message,omitempty"`
}

// MarshalJSON is the custom marshaler for CheckNameAvailabilityOutput.
func (cnao CheckNameAvailabilityOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// CidrIPAddress CIDR Ip address
type CidrIPAddress struct {
	// BaseIPAddress - Ip address itself.
	BaseIPAddress *string `json:"baseIpAddress,omitempty"`
	// PrefixLength - The length of the prefix of the ip address.
	PrefixLength *int32 `json:"prefixLength,omitempty"`
}

// ClientPortMatchConditionParameters defines the parameters for ClientPort match conditions
type ClientPortMatchConditionParameters struct {
	TypeName *string `json:"typeName,omitempty"`
	// Operator - Describes operator to be matched. Possible values include: 'ClientPortOperatorAny', 'ClientPortOperatorEqual', 'ClientPortOperatorContains', 'ClientPortOperatorBeginsWith', 'ClientPortOperatorEndsWith', 'ClientPortOperatorLessThan', 'ClientPortOperatorLessThanOrEqual', 'ClientPortOperatorGreaterThan', 'ClientPortOperatorGreaterThanOrEqual', 'ClientPortOperatorRegEx'
	Operator ClientPortOperator `json:"operator,omitempty"`
	// NegateCondition - Describes if this is negate condition or not
	NegateCondition *bool `json:"negateCondition,omitempty"`
	// MatchValues - The match value for the condition of the delivery rule
	MatchValues *[]string `json:"matchValues,omitempty"`
	// Transforms - List of transforms
	Transforms *[]Transform `json:"transforms,omitempty"`
}

// CompressionSettings settings for compression.
type CompressionSettings struct {
	// ContentTypesToCompress - List of content types on which compression applies. The value should be a valid MIME type.
	ContentTypesToCompress *[]string `json:"contentTypesToCompress,omitempty"`
	// IsCompressionEnabled - Indicates whether content compression is enabled on AzureFrontDoor. Default value is false. If compression is enabled, content will be served as compressed if user requests for a compressed version. Content won't be compressed on AzureFrontDoor when requested content is smaller than 1 byte or larger than 1 MB.
	IsCompressionEnabled *bool `json:"isCompressionEnabled,omitempty"`
}

// ContinentsResponse continents Response
type ContinentsResponse struct {
	autorest.Response `json:"-"`
	Continents        *[]ContinentsResponseContinentsItem       `json:"continents,omitempty"`
	CountryOrRegions  *[]ContinentsResponseCountryOrRegionsItem `json:"countryOrRegions,omitempty"`
}

// ContinentsResponseContinentsItem ...
type ContinentsResponseContinentsItem struct {
	ID *string `json:"id,omitempty"`
}

// ContinentsResponseCountryOrRegionsItem ...
type ContinentsResponseCountryOrRegionsItem struct {
	ID          *string `json:"id,omitempty"`
	ContinentID *string `json:"continentId,omitempty"`
}

// CookiesMatchConditionParameters defines the parameters for Cookies match conditions
type CookiesMatchConditionParameters struct {
	TypeName *string `json:"typeName,omitempty"`
	// Selector - Name of Cookies to be matched
	Selector *string `json:"selector,omitempty"`
	// Operator - Describes operator to be matched. Possible values include: 'CookiesOperatorAny', 'CookiesOperatorEqual', 'CookiesOperatorContains', 'CookiesOperatorBeginsWith', 'CookiesOperatorEndsWith', 'CookiesOperatorLessThan', 'CookiesOperatorLessThanOrEqual', 'CookiesOperatorGreaterThan', 'CookiesOperatorGreaterThanOrEqual', 'CookiesOperatorRegEx'
	Operator CookiesOperator `json:"operator,omitempty"`
	// NegateCondition - Describes if this is negate condition or not
	NegateCondition *bool `json:"negateCondition,omitempty"`
	// MatchValues - The match value for the condition of the delivery rule
	MatchValues *[]string `json:"matchValues,omitempty"`
	// Transforms - List of transforms
	Transforms *[]Transform `json:"transforms,omitempty"`
}

// CustomDomain friendly domain name mapping to the endpoint hostname that the customer provides for
// branding purposes, e.g. www.contoso.com.
type CustomDomain struct {
	autorest.Response       `json:"-"`
	*CustomDomainProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for CustomDomain.
func (cd CustomDomain) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cd.CustomDomainProperties != nil {
		objectMap["properties"] = cd.CustomDomainProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CustomDomain struct.
func (cd *CustomDomain) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var customDomainProperties CustomDomainProperties
				err = json.Unmarshal(*v, &customDomainProperties)
				if err != nil {
					return err
				}
				cd.CustomDomainProperties = &customDomainProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cd.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cd.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				cd.SystemData = &systemData
			}
		}
	}

	return nil
}

// BasicCustomDomainHTTPSParameters the JSON object that contains the properties to secure a custom domain.
type BasicCustomDomainHTTPSParameters interface {
	AsUserManagedHTTPSParameters() (*UserManagedHTTPSParameters, bool)
	AsManagedHTTPSParameters() (*ManagedHTTPSParameters, bool)
	AsCustomDomainHTTPSParameters() (*CustomDomainHTTPSParameters, bool)
}

// CustomDomainHTTPSParameters the JSON object that contains the properties to secure a custom domain.
type CustomDomainHTTPSParameters struct {
	// ProtocolType - Defines the TLS extension protocol that is used for secure delivery. Possible values include: 'ProtocolTypeServerNameIndication', 'ProtocolTypeIPBased'
	ProtocolType ProtocolType `json:"protocolType,omitempty"`
	// MinimumTLSVersion - TLS protocol version that will be used for Https. Possible values include: 'MinimumTLSVersionNone', 'MinimumTLSVersionTLS10', 'MinimumTLSVersionTLS12'
	MinimumTLSVersion MinimumTLSVersion `json:"minimumTlsVersion,omitempty"`
	// CertificateSource - Possible values include: 'CertificateSourceCustomDomainHTTPSParameters', 'CertificateSourceAzureKeyVault', 'CertificateSourceCdn'
	CertificateSource CertificateSource `json:"certificateSource,omitempty"`
}

func unmarshalBasicCustomDomainHTTPSParameters(body []byte) (BasicCustomDomainHTTPSParameters, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["certificateSource"] {
	case string(CertificateSourceAzureKeyVault):
		var umhp UserManagedHTTPSParameters
		err := json.Unmarshal(body, &umhp)
		return umhp, err
	case string(CertificateSourceCdn):
		var mhp ManagedHTTPSParameters
		err := json.Unmarshal(body, &mhp)
		return mhp, err
	default:
		var cdhp CustomDomainHTTPSParameters
		err := json.Unmarshal(body, &cdhp)
		return cdhp, err
	}
}
func unmarshalBasicCustomDomainHTTPSParametersArray(body []byte) ([]BasicCustomDomainHTTPSParameters, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	cdhpArray := make([]BasicCustomDomainHTTPSParameters, len(rawMessages))

	for index, rawMessage := range rawMessages {
		cdhp, err := unmarshalBasicCustomDomainHTTPSParameters(*rawMessage)
		if err != nil {
			return nil, err
		}
		cdhpArray[index] = cdhp
	}
	return cdhpArray, nil
}

// MarshalJSON is the custom marshaler for CustomDomainHTTPSParameters.
func (cdhp CustomDomainHTTPSParameters) MarshalJSON() ([]byte, error) {
	cdhp.CertificateSource = CertificateSourceCustomDomainHTTPSParameters
	objectMap := make(map[string]interface{})
	if cdhp.ProtocolType != "" {
		objectMap["protocolType"] = cdhp.ProtocolType
	}
	if cdhp.MinimumTLSVersion != "" {
		objectMap["minimumTlsVersion"] = cdhp.MinimumTLSVersion
	}
	if cdhp.CertificateSource != "" {
		objectMap["certificateSource"] = cdhp.CertificateSource
	}
	return json.Marshal(objectMap)
}

// AsUserManagedHTTPSParameters is the BasicCustomDomainHTTPSParameters implementation for CustomDomainHTTPSParameters.
func (cdhp CustomDomainHTTPSParameters) AsUserManagedHTTPSParameters() (*UserManagedHTTPSParameters, bool) {
	return nil, false
}

// AsManagedHTTPSParameters is the BasicCustomDomainHTTPSParameters implementation for CustomDomainHTTPSParameters.
func (cdhp CustomDomainHTTPSParameters) AsManagedHTTPSParameters() (*ManagedHTTPSParameters, bool) {
	return nil, false
}

// AsCustomDomainHTTPSParameters is the BasicCustomDomainHTTPSParameters implementation for CustomDomainHTTPSParameters.
func (cdhp CustomDomainHTTPSParameters) AsCustomDomainHTTPSParameters() (*CustomDomainHTTPSParameters, bool) {
	return &cdhp, true
}

// AsBasicCustomDomainHTTPSParameters is the BasicCustomDomainHTTPSParameters implementation for CustomDomainHTTPSParameters.
func (cdhp CustomDomainHTTPSParameters) AsBasicCustomDomainHTTPSParameters() (BasicCustomDomainHTTPSParameters, bool) {
	return &cdhp, true
}

// CustomDomainListResult result of the request to list custom domains. It contains a list of custom domain
// objects and a URL link to get the next set of results.
type CustomDomainListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of CDN CustomDomains within an endpoint.
	Value *[]CustomDomain `json:"value,omitempty"`
	// NextLink - URL to get the next set of custom domain objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for CustomDomainListResult.
func (cdlr CustomDomainListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cdlr.NextLink != nil {
		objectMap["nextLink"] = cdlr.NextLink
	}
	return json.Marshal(objectMap)
}

// CustomDomainListResultIterator provides access to a complete listing of CustomDomain values.
type CustomDomainListResultIterator struct {
	i    int
	page CustomDomainListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CustomDomainListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CustomDomainListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CustomDomainListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CustomDomainListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CustomDomainListResultIterator) Response() CustomDomainListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CustomDomainListResultIterator) Value() CustomDomain {
	if !iter.page.NotDone() {
		return CustomDomain{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CustomDomainListResultIterator type.
func NewCustomDomainListResultIterator(page CustomDomainListResultPage) CustomDomainListResultIterator {
	return CustomDomainListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cdlr CustomDomainListResult) IsEmpty() bool {
	return cdlr.Value == nil || len(*cdlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (cdlr CustomDomainListResult) hasNextLink() bool {
	return cdlr.NextLink != nil && len(*cdlr.NextLink) != 0
}

// customDomainListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cdlr CustomDomainListResult) customDomainListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !cdlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cdlr.NextLink)))
}

// CustomDomainListResultPage contains a page of CustomDomain values.
type CustomDomainListResultPage struct {
	fn   func(context.Context, CustomDomainListResult) (CustomDomainListResult, error)
	cdlr CustomDomainListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CustomDomainListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CustomDomainListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.cdlr)
		if err != nil {
			return err
		}
		page.cdlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CustomDomainListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CustomDomainListResultPage) NotDone() bool {
	return !page.cdlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CustomDomainListResultPage) Response() CustomDomainListResult {
	return page.cdlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CustomDomainListResultPage) Values() []CustomDomain {
	if page.cdlr.IsEmpty() {
		return nil
	}
	return *page.cdlr.Value
}

// Creates a new instance of the CustomDomainListResultPage type.
func NewCustomDomainListResultPage(cur CustomDomainListResult, getNextPage func(context.Context, CustomDomainListResult) (CustomDomainListResult, error)) CustomDomainListResultPage {
	return CustomDomainListResultPage{
		fn:   getNextPage,
		cdlr: cur,
	}
}

// CustomDomainParameters the customDomain JSON object required for custom domain creation or update.
type CustomDomainParameters struct {
	*CustomDomainPropertiesParameters `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for CustomDomainParameters.
func (cdp CustomDomainParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cdp.CustomDomainPropertiesParameters != nil {
		objectMap["properties"] = cdp.CustomDomainPropertiesParameters
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CustomDomainParameters struct.
func (cdp *CustomDomainParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var customDomainPropertiesParameters CustomDomainPropertiesParameters
				err = json.Unmarshal(*v, &customDomainPropertiesParameters)
				if err != nil {
					return err
				}
				cdp.CustomDomainPropertiesParameters = &customDomainPropertiesParameters
			}
		}
	}

	return nil
}

// CustomDomainProperties the JSON object that contains the properties of the custom domain to create.
type CustomDomainProperties struct {
	// HostName - The host name of the custom domain. Must be a domain name.
	HostName *string `json:"hostName,omitempty"`
	// ResourceState - READ-ONLY; Resource status of the custom domain. Possible values include: 'CustomDomainResourceStateCreating', 'CustomDomainResourceStateActive', 'CustomDomainResourceStateDeleting'
	ResourceState CustomDomainResourceState `json:"resourceState,omitempty"`
	// CustomHTTPSProvisioningState - READ-ONLY; Provisioning status of Custom Https of the custom domain. Possible values include: 'CustomHTTPSProvisioningStateEnabling', 'CustomHTTPSProvisioningStateEnabled', 'CustomHTTPSProvisioningStateDisabling', 'CustomHTTPSProvisioningStateDisabled', 'CustomHTTPSProvisioningStateFailed'
	CustomHTTPSProvisioningState CustomHTTPSProvisioningState `json:"customHttpsProvisioningState,omitempty"`
	// CustomHTTPSProvisioningSubstate - READ-ONLY; Provisioning substate shows the progress of custom HTTPS enabling/disabling process step by step. Possible values include: 'CustomHTTPSProvisioningSubstateSubmittingDomainControlValidationRequest', 'CustomHTTPSProvisioningSubstatePendingDomainControlValidationREquestApproval', 'CustomHTTPSProvisioningSubstateDomainControlValidationRequestApproved', 'CustomHTTPSProvisioningSubstateDomainControlValidationRequestRejected', 'CustomHTTPSProvisioningSubstateDomainControlValidationRequestTimedOut', 'CustomHTTPSProvisioningSubstateIssuingCertificate', 'CustomHTTPSProvisioningSubstateDeployingCertificate', 'CustomHTTPSProvisioningSubstateCertificateDeployed', 'CustomHTTPSProvisioningSubstateDeletingCertificate', 'CustomHTTPSProvisioningSubstateCertificateDeleted'
	CustomHTTPSProvisioningSubstate CustomHTTPSProvisioningSubstate `json:"customHttpsProvisioningSubstate,omitempty"`
	// CustomHTTPSParameters - Certificate parameters for securing custom HTTPS
	CustomHTTPSParameters BasicCustomDomainHTTPSParameters `json:"customHttpsParameters,omitempty"`
	// ValidationData - Special validation or data may be required when delivering CDN to some regions due to local compliance reasons. E.g. ICP license number of a custom domain is required to deliver content in China.
	ValidationData *string `json:"validationData,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning status of the custom domain.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for CustomDomainProperties.
func (cdp CustomDomainProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cdp.HostName != nil {
		objectMap["hostName"] = cdp.HostName
	}
	objectMap["customHttpsParameters"] = cdp.CustomHTTPSParameters
	if cdp.ValidationData != nil {
		objectMap["validationData"] = cdp.ValidationData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CustomDomainProperties struct.
func (cdp *CustomDomainProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "hostName":
			if v != nil {
				var hostName string
				err = json.Unmarshal(*v, &hostName)
				if err != nil {
					return err
				}
				cdp.HostName = &hostName
			}
		case "resourceState":
			if v != nil {
				var resourceState CustomDomainResourceState
				err = json.Unmarshal(*v, &resourceState)
				if err != nil {
					return err
				}
				cdp.ResourceState = resourceState
			}
		case "customHttpsProvisioningState":
			if v != nil {
				var customHTTPSProvisioningState CustomHTTPSProvisioningState
				err = json.Unmarshal(*v, &customHTTPSProvisioningState)
				if err != nil {
					return err
				}
				cdp.CustomHTTPSProvisioningState = customHTTPSProvisioningState
			}
		case "customHttpsProvisioningSubstate":
			if v != nil {
				var customHTTPSProvisioningSubstate CustomHTTPSProvisioningSubstate
				err = json.Unmarshal(*v, &customHTTPSProvisioningSubstate)
				if err != nil {
					return err
				}
				cdp.CustomHTTPSProvisioningSubstate = customHTTPSProvisioningSubstate
			}
		case "customHttpsParameters":
			if v != nil {
				customHTTPSParameters, err := unmarshalBasicCustomDomainHTTPSParameters(*v)
				if err != nil {
					return err
				}
				cdp.CustomHTTPSParameters = customHTTPSParameters
			}
		case "validationData":
			if v != nil {
				var validationData string
				err = json.Unmarshal(*v, &validationData)
				if err != nil {
					return err
				}
				cdp.ValidationData = &validationData
			}
		case "provisioningState":
			if v != nil {
				var provisioningState string
				err = json.Unmarshal(*v, &provisioningState)
				if err != nil {
					return err
				}
				cdp.ProvisioningState = &provisioningState
			}
		}
	}

	return nil
}

// CustomDomainPropertiesParameters the JSON object that contains the properties of the custom domain to
// create.
type CustomDomainPropertiesParameters struct {
	// HostName - The host name of the custom domain. Must be a domain name.
	HostName *string `json:"hostName,omitempty"`
}

// CustomDomainsCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type CustomDomainsCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(CustomDomainsClient) (CustomDomain, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CustomDomainsCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CustomDomainsCreateFuture.Result.
func (future *CustomDomainsCreateFuture) result(client CustomDomainsClient) (cd CustomDomain, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.CustomDomainsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		cd.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("cdn.CustomDomainsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if cd.Response.Response, err = future.GetResult(sender); err == nil && cd.Response.Response.StatusCode != http.StatusNoContent {
		cd, err = client.CreateResponder(cd.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.CustomDomainsCreateFuture", "Result", cd.Response.Response, "Failure responding to request")
		}
	}
	return
}

// CustomDomainsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type CustomDomainsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(CustomDomainsClient) (CustomDomain, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CustomDomainsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CustomDomainsDeleteFuture.Result.
func (future *CustomDomainsDeleteFuture) result(client CustomDomainsClient) (cd CustomDomain, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.CustomDomainsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		cd.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("cdn.CustomDomainsDeleteFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if cd.Response.Response, err = future.GetResult(sender); err == nil && cd.Response.Response.StatusCode != http.StatusNoContent {
		cd, err = client.DeleteResponder(cd.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.CustomDomainsDeleteFuture", "Result", cd.Response.Response, "Failure responding to request")
		}
	}
	return
}

// CustomerCertificate customer Certificate used for https
type CustomerCertificate struct {
	// SecretSource - Resource reference to the Azure Key Vault certificate. Expected to be in format of /subscriptions/{​​​​​​​​​subscriptionId}​​​​​​​​​/resourceGroups/{​​​​​​​​​resourceGroupName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/providers/Microsoft.KeyVault/vaults/{vaultName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/secrets/{certificateName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​
	SecretSource *ResourceReference `json:"secretSource,omitempty"`
	// SecretVersion - Certificate version.
	SecretVersion *string `json:"secretVersion,omitempty"`
	// CertificateAuthority - READ-ONLY; Certificate issuing authority.
	CertificateAuthority *string `json:"certificateAuthority,omitempty"`
	// UseLatestVersion - Whether to use the latest version for the certificate
	UseLatestVersion *bool `json:"useLatestVersion,omitempty"`
	// SubjectAlternativeNames - The list of SANs.
	SubjectAlternativeNames *[]string `json:"subjectAlternativeNames,omitempty"`
	// Thumbprint - READ-ONLY; Certificate thumbprint.
	Thumbprint *string `json:"thumbprint,omitempty"`
	// Type - Possible values include: 'SecretTypeURLSigningKey', 'SecretTypeCustomerCertificate', 'SecretTypeManagedCertificate', 'SecretTypeAzureFirstPartyManagedCertificate'
	Type SecretType `json:"type,omitempty"`
	// Subject - READ-ONLY; Subject name in the certificate.
	Subject *string `json:"subject,omitempty"`
	// ExpirationDate - READ-ONLY; Certificate expiration date.
	ExpirationDate *string `json:"expirationDate,omitempty"`
}

// MarshalJSON is the custom marshaler for CustomerCertificate.
func (cc CustomerCertificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cc.SecretSource != nil {
		objectMap["secretSource"] = cc.SecretSource
	}
	if cc.SecretVersion != nil {
		objectMap["secretVersion"] = cc.SecretVersion
	}
	if cc.UseLatestVersion != nil {
		objectMap["useLatestVersion"] = cc.UseLatestVersion
	}
	if cc.SubjectAlternativeNames != nil {
		objectMap["subjectAlternativeNames"] = cc.SubjectAlternativeNames
	}
	if cc.Type != "" {
		objectMap["type"] = cc.Type
	}
	return json.Marshal(objectMap)
}

// CustomerCertificateParameters customer Certificate used for https
type CustomerCertificateParameters struct {
	// SecretSource - Resource reference to the Azure Key Vault certificate. Expected to be in format of /subscriptions/{​​​​​​​​​subscriptionId}​​​​​​​​​/resourceGroups/{​​​​​​​​​resourceGroupName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/providers/Microsoft.KeyVault/vaults/{vaultName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/secrets/{certificateName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​
	SecretSource *ResourceReference `json:"secretSource,omitempty"`
	// SecretVersion - Version of the secret to be used
	SecretVersion *string `json:"secretVersion,omitempty"`
	// UseLatestVersion - Whether to use the latest version for the certificate
	UseLatestVersion *bool `json:"useLatestVersion,omitempty"`
	// Subject - READ-ONLY; Subject name in the certificate.
	Subject *string `json:"subject,omitempty"`
	// ExpirationDate - READ-ONLY; Certificate expiration date.
	ExpirationDate *string `json:"expirationDate,omitempty"`
	// CertificateAuthority - READ-ONLY; Certificate issuing authority.
	CertificateAuthority *string `json:"certificateAuthority,omitempty"`
	// SubjectAlternativeNames - The list of SANs.
	SubjectAlternativeNames *[]string `json:"subjectAlternativeNames,omitempty"`
	// Thumbprint - READ-ONLY; Certificate thumbprint.
	Thumbprint *string `json:"thumbprint,omitempty"`
	// Type - Possible values include: 'TypeBasicSecretParametersTypeSecretParameters', 'TypeBasicSecretParametersTypeURLSigningKey', 'TypeBasicSecretParametersTypeManagedCertificate', 'TypeBasicSecretParametersTypeCustomerCertificate', 'TypeBasicSecretParametersTypeAzureFirstPartyManagedCertificate'
	Type TypeBasicSecretParameters `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for CustomerCertificateParameters.
func (ccp CustomerCertificateParameters) MarshalJSON() ([]byte, error) {
	ccp.Type = TypeBasicSecretParametersTypeCustomerCertificate
	objectMap := make(map[string]interface{})
	if ccp.SecretSource != nil {
		objectMap["secretSource"] = ccp.SecretSource
	}
	if ccp.SecretVersion != nil {
		objectMap["secretVersion"] = ccp.SecretVersion
	}
	if ccp.UseLatestVersion != nil {
		objectMap["useLatestVersion"] = ccp.UseLatestVersion
	}
	if ccp.SubjectAlternativeNames != nil {
		objectMap["subjectAlternativeNames"] = ccp.SubjectAlternativeNames
	}
	if ccp.Type != "" {
		objectMap["type"] = ccp.Type
	}
	return json.Marshal(objectMap)
}

// AsURLSigningKeyParameters is the BasicSecretParameters implementation for CustomerCertificateParameters.
func (ccp CustomerCertificateParameters) AsURLSigningKeyParameters() (*URLSigningKeyParameters, bool) {
	return nil, false
}

// AsManagedCertificateParameters is the BasicSecretParameters implementation for CustomerCertificateParameters.
func (ccp CustomerCertificateParameters) AsManagedCertificateParameters() (*ManagedCertificateParameters, bool) {
	return nil, false
}

// AsCustomerCertificateParameters is the BasicSecretParameters implementation for CustomerCertificateParameters.
func (ccp CustomerCertificateParameters) AsCustomerCertificateParameters() (*CustomerCertificateParameters, bool) {
	return &ccp, true
}

// AsAzureFirstPartyManagedCertificateParameters is the BasicSecretParameters implementation for CustomerCertificateParameters.
func (ccp CustomerCertificateParameters) AsAzureFirstPartyManagedCertificateParameters() (*AzureFirstPartyManagedCertificateParameters, bool) {
	return nil, false
}

// AsSecretParameters is the BasicSecretParameters implementation for CustomerCertificateParameters.
func (ccp CustomerCertificateParameters) AsSecretParameters() (*SecretParameters, bool) {
	return nil, false
}

// AsBasicSecretParameters is the BasicSecretParameters implementation for CustomerCertificateParameters.
func (ccp CustomerCertificateParameters) AsBasicSecretParameters() (BasicSecretParameters, bool) {
	return &ccp, true
}

// CustomRule defines the common attributes for a custom rule that can be included in a waf policy
type CustomRule struct {
	// Name - Defines the name of the custom rule
	Name *string `json:"name,omitempty"`
	// EnabledState - Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not specified. Possible values include: 'CustomRuleEnabledStateDisabled', 'CustomRuleEnabledStateEnabled'
	EnabledState CustomRuleEnabledState `json:"enabledState,omitempty"`
	// Priority - Defines in what order this rule be evaluated in the overall list of custom rules
	Priority *int32 `json:"priority,omitempty"`
	// MatchConditions - List of match conditions.
	MatchConditions *[]MatchCondition `json:"matchConditions,omitempty"`
	// Action - Describes what action to be applied when rule matches. Possible values include: 'ActionTypeAllow', 'ActionTypeBlock', 'ActionTypeLog', 'ActionTypeRedirect'
	Action ActionType `json:"action,omitempty"`
}

// CustomRuleList defines contents of custom rules
type CustomRuleList struct {
	// Rules - List of rules
	Rules *[]CustomRule `json:"rules,omitempty"`
}

// DeepCreatedOrigin the main origin of CDN content which is added when creating a CDN endpoint.
type DeepCreatedOrigin struct {
	// Name - Origin name which must be unique within the endpoint.
	Name                         *string `json:"name,omitempty"`
	*DeepCreatedOriginProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for DeepCreatedOrigin.
func (dco DeepCreatedOrigin) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dco.Name != nil {
		objectMap["name"] = dco.Name
	}
	if dco.DeepCreatedOriginProperties != nil {
		objectMap["properties"] = dco.DeepCreatedOriginProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DeepCreatedOrigin struct.
func (dco *DeepCreatedOrigin) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dco.Name = &name
			}
		case "properties":
			if v != nil {
				var deepCreatedOriginProperties DeepCreatedOriginProperties
				err = json.Unmarshal(*v, &deepCreatedOriginProperties)
				if err != nil {
					return err
				}
				dco.DeepCreatedOriginProperties = &deepCreatedOriginProperties
			}
		}
	}

	return nil
}

// DeepCreatedOriginGroup the origin group for CDN content which is added when creating a CDN endpoint.
// Traffic is sent to the origins within the origin group based on origin health.
type DeepCreatedOriginGroup struct {
	// Name - Origin group name which must be unique within the endpoint.
	Name                              *string `json:"name,omitempty"`
	*DeepCreatedOriginGroupProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for DeepCreatedOriginGroup.
func (dcog DeepCreatedOriginGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dcog.Name != nil {
		objectMap["name"] = dcog.Name
	}
	if dcog.DeepCreatedOriginGroupProperties != nil {
		objectMap["properties"] = dcog.DeepCreatedOriginGroupProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DeepCreatedOriginGroup struct.
func (dcog *DeepCreatedOriginGroup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dcog.Name = &name
			}
		case "properties":
			if v != nil {
				var deepCreatedOriginGroupProperties DeepCreatedOriginGroupProperties
				err = json.Unmarshal(*v, &deepCreatedOriginGroupProperties)
				if err != nil {
					return err
				}
				dcog.DeepCreatedOriginGroupProperties = &deepCreatedOriginGroupProperties
			}
		}
	}

	return nil
}

// DeepCreatedOriginGroupProperties properties of the origin group created on the CDN endpoint.
type DeepCreatedOriginGroupProperties struct {
	// HealthProbeSettings - Health probe settings to the origin that is used to determine the health of the origin.
	HealthProbeSettings *HealthProbeParameters `json:"healthProbeSettings,omitempty"`
	// Origins - The source of the content being delivered via CDN within given origin group.
	Origins *[]ResourceReference `json:"origins,omitempty"`
	// TrafficRestorationTimeToHealedOrNewEndpointsInMinutes - Time in minutes to shift the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new endpoint is added. Default is 10 mins. This property is currently not supported.
	TrafficRestorationTimeToHealedOrNewEndpointsInMinutes *int32 `json:"trafficRestorationTimeToHealedOrNewEndpointsInMinutes,omitempty"`
	// ResponseBasedOriginErrorDetectionSettings - The JSON object that contains the properties to determine origin health using real requests/responses.This property is currently not supported.
	ResponseBasedOriginErrorDetectionSettings *ResponseBasedOriginErrorDetectionParameters `json:"responseBasedOriginErrorDetectionSettings,omitempty"`
}

// DeepCreatedOriginProperties properties of the origin created on the CDN endpoint.
type DeepCreatedOriginProperties struct {
	// HostName - The address of the origin. It can be a domain name, IPv4 address, or IPv6 address. This should be unique across all origins in an endpoint.
	HostName *string `json:"hostName,omitempty"`
	// HTTPPort - The value of the HTTP port. Must be between 1 and 65535.
	HTTPPort *int32 `json:"httpPort,omitempty"`
	// HTTPSPort - The value of the HTTPS port. Must be between 1 and 65535.
	HTTPSPort *int32 `json:"httpsPort,omitempty"`
	// OriginHostHeader - The host header value sent to the origin with each request. If you leave this blank, the request hostname determines this value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services require this host header value to match the origin hostname by default.
	OriginHostHeader *string `json:"originHostHeader,omitempty"`
	// Priority - Priority of origin in given origin group for load balancing. Higher priorities will not be used for load balancing if any lower priority origin is healthy.Must be between 1 and 5.
	Priority *int32 `json:"priority,omitempty"`
	// Weight - Weight of the origin in given origin group for load balancing. Must be between 1 and 1000
	Weight *int32 `json:"weight,omitempty"`
	// Enabled - Origin is enabled for load balancing or not. By default, origin is always enabled.
	Enabled *bool `json:"enabled,omitempty"`
	// PrivateLinkAlias - The Alias of the Private Link resource. Populating this optional field indicates that this origin is 'Private'
	PrivateLinkAlias *string `json:"privateLinkAlias,omitempty"`
	// PrivateLinkResourceID - The Resource Id of the Private Link resource. Populating this optional field indicates that this backend is 'Private'
	PrivateLinkResourceID *string `json:"privateLinkResourceId,omitempty"`
	// PrivateLinkLocation - The location of the Private Link resource. Required only if 'privateLinkResourceId' is populated
	PrivateLinkLocation *string `json:"privateLinkLocation,omitempty"`
	// PrivateLinkApprovalMessage - A custom message to be included in the approval request to connect to the Private Link.
	PrivateLinkApprovalMessage *string `json:"privateLinkApprovalMessage,omitempty"`
	// PrivateEndpointStatus - READ-ONLY; The approval status for the connection to the Private Link. Possible values include: 'PrivateEndpointStatusPending', 'PrivateEndpointStatusApproved', 'PrivateEndpointStatusRejected', 'PrivateEndpointStatusDisconnected', 'PrivateEndpointStatusTimeout'
	PrivateEndpointStatus PrivateEndpointStatus `json:"privateEndpointStatus,omitempty"`
}

// MarshalJSON is the custom marshaler for DeepCreatedOriginProperties.
func (dcop DeepCreatedOriginProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dcop.HostName != nil {
		objectMap["hostName"] = dcop.HostName
	}
	if dcop.HTTPPort != nil {
		objectMap["httpPort"] = dcop.HTTPPort
	}
	if dcop.HTTPSPort != nil {
		objectMap["httpsPort"] = dcop.HTTPSPort
	}
	if dcop.OriginHostHeader != nil {
		objectMap["originHostHeader"] = dcop.OriginHostHeader
	}
	if dcop.Priority != nil {
		objectMap["priority"] = dcop.Priority
	}
	if dcop.Weight != nil {
		objectMap["weight"] = dcop.Weight
	}
	if dcop.Enabled != nil {
		objectMap["enabled"] = dcop.Enabled
	}
	if dcop.PrivateLinkAlias != nil {
		objectMap["privateLinkAlias"] = dcop.PrivateLinkAlias
	}
	if dcop.PrivateLinkResourceID != nil {
		objectMap["privateLinkResourceId"] = dcop.PrivateLinkResourceID
	}
	if dcop.PrivateLinkLocation != nil {
		objectMap["privateLinkLocation"] = dcop.PrivateLinkLocation
	}
	if dcop.PrivateLinkApprovalMessage != nil {
		objectMap["privateLinkApprovalMessage"] = dcop.PrivateLinkApprovalMessage
	}
	return json.Marshal(objectMap)
}

// DeliveryRule a rule that specifies a set of actions and conditions
type DeliveryRule struct {
	// Name - Name of the rule
	Name *string `json:"name,omitempty"`
	// Order - The order in which the rules are applied for the endpoint. Possible values {0,1,2,3,………}. A rule with a lesser order will be applied before a rule with a greater order. Rule with order 0 is a special rule. It does not require any condition and actions listed in it will always be applied.
	Order *int32 `json:"order,omitempty"`
	// Conditions - A list of conditions that must be matched for the actions to be executed
	Conditions *[]BasicDeliveryRuleCondition `json:"conditions,omitempty"`
	// Actions - A list of actions that are executed when all the conditions of a rule are satisfied.
	Actions *[]BasicDeliveryRuleAction `json:"actions,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for DeliveryRule struct.
func (dr *DeliveryRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dr.Name = &name
			}
		case "order":
			if v != nil {
				var order int32
				err = json.Unmarshal(*v, &order)
				if err != nil {
					return err
				}
				dr.Order = &order
			}
		case "conditions":
			if v != nil {
				conditions, err := unmarshalBasicDeliveryRuleConditionArray(*v)
				if err != nil {
					return err
				}
				dr.Conditions = &conditions
			}
		case "actions":
			if v != nil {
				actions, err := unmarshalBasicDeliveryRuleActionArray(*v)
				if err != nil {
					return err
				}
				dr.Actions = &actions
			}
		}
	}

	return nil
}

// BasicDeliveryRuleAction an action for the delivery rule.
type BasicDeliveryRuleAction interface {
	AsDeliveryRuleRouteConfigurationOverrideAction() (*DeliveryRuleRouteConfigurationOverrideAction, bool)
	AsDeliveryRuleCacheKeyQueryStringAction() (*DeliveryRuleCacheKeyQueryStringAction, bool)
	AsDeliveryRuleCacheExpirationAction() (*DeliveryRuleCacheExpirationAction, bool)
	AsDeliveryRuleResponseHeaderAction() (*DeliveryRuleResponseHeaderAction, bool)
	AsDeliveryRuleRequestHeaderAction() (*DeliveryRuleRequestHeaderAction, bool)
	AsURLRewriteAction() (*URLRewriteAction, bool)
	AsOriginGroupOverrideAction() (*OriginGroupOverrideAction, bool)
	AsURLSigningAction() (*URLSigningAction, bool)
	AsURLRedirectAction() (*URLRedirectAction, bool)
	AsDeliveryRuleAction() (*DeliveryRuleAction, bool)
}

// DeliveryRuleAction an action for the delivery rule.
type DeliveryRuleAction struct {
	// Name - Possible values include: 'NameBasicDeliveryRuleActionNameDeliveryRuleAction', 'NameBasicDeliveryRuleActionNameRouteConfigurationOverride', 'NameBasicDeliveryRuleActionNameCacheKeyQueryString', 'NameBasicDeliveryRuleActionNameCacheExpiration', 'NameBasicDeliveryRuleActionNameModifyResponseHeader', 'NameBasicDeliveryRuleActionNameModifyRequestHeader', 'NameBasicDeliveryRuleActionNameURLRewrite', 'NameBasicDeliveryRuleActionNameOriginGroupOverride', 'NameBasicDeliveryRuleActionNameURLSigning', 'NameBasicDeliveryRuleActionNameURLRedirect'
	Name NameBasicDeliveryRuleAction `json:"name,omitempty"`
}

func unmarshalBasicDeliveryRuleAction(body []byte) (BasicDeliveryRuleAction, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["name"] {
	case string(NameBasicDeliveryRuleActionNameRouteConfigurationOverride):
		var drrcoa DeliveryRuleRouteConfigurationOverrideAction
		err := json.Unmarshal(body, &drrcoa)
		return drrcoa, err
	case string(NameBasicDeliveryRuleActionNameCacheKeyQueryString):
		var drckqsa DeliveryRuleCacheKeyQueryStringAction
		err := json.Unmarshal(body, &drckqsa)
		return drckqsa, err
	case string(NameBasicDeliveryRuleActionNameCacheExpiration):
		var drcea DeliveryRuleCacheExpirationAction
		err := json.Unmarshal(body, &drcea)
		return drcea, err
	case string(NameBasicDeliveryRuleActionNameModifyResponseHeader):
		var drrha DeliveryRuleResponseHeaderAction
		err := json.Unmarshal(body, &drrha)
		return drrha, err
	case string(NameBasicDeliveryRuleActionNameModifyRequestHeader):
		var drrha DeliveryRuleRequestHeaderAction
		err := json.Unmarshal(body, &drrha)
		return drrha, err
	case string(NameBasicDeliveryRuleActionNameURLRewrite):
		var ura URLRewriteAction
		err := json.Unmarshal(body, &ura)
		return ura, err
	case string(NameBasicDeliveryRuleActionNameOriginGroupOverride):
		var ogoa OriginGroupOverrideAction
		err := json.Unmarshal(body, &ogoa)
		return ogoa, err
	case string(NameBasicDeliveryRuleActionNameURLSigning):
		var usa URLSigningAction
		err := json.Unmarshal(body, &usa)
		return usa, err
	case string(NameBasicDeliveryRuleActionNameURLRedirect):
		var ura URLRedirectAction
		err := json.Unmarshal(body, &ura)
		return ura, err
	default:
		var dra DeliveryRuleAction
		err := json.Unmarshal(body, &dra)
		return dra, err
	}
}
func unmarshalBasicDeliveryRuleActionArray(body []byte) ([]BasicDeliveryRuleAction, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	draArray := make([]BasicDeliveryRuleAction, len(rawMessages))

	for index, rawMessage := range rawMessages {
		dra, err := unmarshalBasicDeliveryRuleAction(*rawMessage)
		if err != nil {
			return nil, err
		}
		draArray[index] = dra
	}
	return draArray, nil
}

// MarshalJSON is the custom marshaler for DeliveryRuleAction.
func (dra DeliveryRuleAction) MarshalJSON() ([]byte, error) {
	dra.Name = NameBasicDeliveryRuleActionNameDeliveryRuleAction
	objectMap := make(map[string]interface{})
	if dra.Name != "" {
		objectMap["name"] = dra.Name
	}
	return json.Marshal(objectMap)
}

// AsDeliveryRuleRouteConfigurationOverrideAction is the BasicDeliveryRuleAction implementation for DeliveryRuleAction.
func (dra DeliveryRuleAction) AsDeliveryRuleRouteConfigurationOverrideAction() (*DeliveryRuleRouteConfigurationOverrideAction, bool) {
	return nil, false
}

// AsDeliveryRuleCacheKeyQueryStringAction is the BasicDeliveryRuleAction implementation for DeliveryRuleAction.
func (dra DeliveryRuleAction) AsDeliveryRuleCacheKeyQueryStringAction() (*DeliveryRuleCacheKeyQueryStringAction, bool) {
	return nil, false
}

// AsDeliveryRuleCacheExpirationAction is the BasicDeliveryRuleAction implementation for DeliveryRuleAction.
func (dra DeliveryRuleAction) AsDeliveryRuleCacheExpirationAction() (*DeliveryRuleCacheExpirationAction, bool) {
	return nil, false
}

// AsDeliveryRuleResponseHeaderAction is the BasicDeliveryRuleAction implementation for DeliveryRuleAction.
func (dra DeliveryRuleAction) AsDeliveryRuleResponseHeaderAction() (*DeliveryRuleResponseHeaderAction, bool) {
	return nil, false
}

// AsDeliveryRuleRequestHeaderAction is the BasicDeliveryRuleAction implementation for DeliveryRuleAction.
func (dra DeliveryRuleAction) AsDeliveryRuleRequestHeaderAction() (*DeliveryRuleRequestHeaderAction, bool) {
	return nil, false
}

// AsURLRewriteAction is the BasicDeliveryRuleAction implementation for DeliveryRuleAction.
func (dra DeliveryRuleAction) AsURLRewriteAction() (*URLRewriteAction, bool) {
	return nil, false
}

// AsOriginGroupOverrideAction is the BasicDeliveryRuleAction implementation for DeliveryRuleAction.
func (dra DeliveryRuleAction) AsOriginGroupOverrideAction() (*OriginGroupOverrideAction, bool) {
	return nil, false
}

// AsURLSigningAction is the BasicDeliveryRuleAction implementation for DeliveryRuleAction.
func (dra DeliveryRuleAction) AsURLSigningAction() (*URLSigningAction, bool) {
	return nil, false
}

// AsURLRedirectAction is the BasicDeliveryRuleAction implementation for DeliveryRuleAction.
func (dra DeliveryRuleAction) AsURLRedirectAction() (*URLRedirectAction, bool) {
	return nil, false
}

// AsDeliveryRuleAction is the BasicDeliveryRuleAction implementation for DeliveryRuleAction.
func (dra DeliveryRuleAction) AsDeliveryRuleAction() (*DeliveryRuleAction, bool) {
	return &dra, true
}

// AsBasicDeliveryRuleAction is the BasicDeliveryRuleAction implementation for DeliveryRuleAction.
func (dra DeliveryRuleAction) AsBasicDeliveryRuleAction() (BasicDeliveryRuleAction, bool) {
	return &dra, true
}

// DeliveryRuleCacheExpirationAction defines the cache expiration action for the delivery rule.
type DeliveryRuleCacheExpirationAction struct {
	// Parameters - Defines the parameters for the action.
	Parameters *CacheExpirationActionParameters `json:"parameters,omitempty"`
	// Name - Possible values include: 'NameBasicDeliveryRuleActionNameDeliveryRuleAction', 'NameBasicDeliveryRuleActionNameRouteConfigurationOverride', 'NameBasicDeliveryRuleActionNameCacheKeyQueryString', 'NameBasicDeliveryRuleActionNameCacheExpiration', 'NameBasicDeliveryRuleActionNameModifyResponseHeader', 'NameBasicDeliveryRuleActionNameModifyRequestHeader', 'NameBasicDeliveryRuleActionNameURLRewrite', 'NameBasicDeliveryRuleActionNameOriginGroupOverride', 'NameBasicDeliveryRuleActionNameURLSigning', 'NameBasicDeliveryRuleActionNameURLRedirect'
	Name NameBasicDeliveryRuleAction `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for DeliveryRuleCacheExpirationAction.
func (drcea DeliveryRuleCacheExpirationAction) MarshalJSON() ([]byte, error) {
	drcea.Name = NameBasicDeliveryRuleActionNameCacheExpiration
	objectMap := make(map[string]interface{})
	if drcea.Parameters != nil {
		objectMap["parameters"] = drcea.Parameters
	}
	if drcea.Name != "" {
		objectMap["name"] = drcea.Name
	}
	return json.Marshal(objectMap)
}

// AsDeliveryRuleRouteConfigurationOverrideAction is the BasicDeliveryRuleAction implementation for DeliveryRuleCacheExpirationAction.
func (drcea DeliveryRuleCacheExpirationAction) AsDeliveryRuleRouteConfigurationOverrideAction() (*DeliveryRuleRouteConfigurationOverrideAction, bool) {
	return nil, false
}

// AsDeliveryRuleCacheKeyQueryStringAction is the BasicDeliveryRuleAction implementation for DeliveryRuleCacheExpirationAction.
func (drcea DeliveryRuleCacheExpirationAction) AsDeliveryRuleCacheKeyQueryStringAction() (*DeliveryRuleCacheKeyQueryStringAction, bool) {
	return nil, false
}

// AsDeliveryRuleCacheExpirationAction is the BasicDeliveryRuleAction implementation for DeliveryRuleCacheExpirationAction.
func (drcea DeliveryRuleCacheExpirationAction) AsDeliveryRuleCacheExpirationAction() (*DeliveryRuleCacheExpirationAction, bool) {
	return &drcea, true
}

// AsDeliveryRuleResponseHeaderAction is the BasicDeliveryRuleAction implementation for DeliveryRuleCacheExpirationAction.
func (drcea DeliveryRuleCacheExpirationAction) AsDeliveryRuleResponseHeaderAction() (*DeliveryRuleResponseHeaderAction, bool) {
	return nil, false
}

// AsDeliveryRuleRequestHeaderAction is the BasicDeliveryRuleAction implementation for DeliveryRuleCacheExpirationAction.
func (drcea DeliveryRuleCacheExpirationAction) AsDeliveryRuleRequestHeaderAction() (*DeliveryRuleRequestHeaderAction, bool) {
	return nil, false
}

// AsURLRewriteAction is the BasicDeliveryRuleAction implementation for DeliveryRuleCacheExpirationAction.
func (drcea DeliveryRuleCacheExpirationAction) AsURLRewriteAction() (*URLRewriteAction, bool) {
	return nil, false
}

// AsOriginGroupOverrideAction is the BasicDeliveryRuleAction implementation for DeliveryRuleCacheExpirationAction.
func (drcea DeliveryRuleCacheExpirationAction) AsOriginGroupOverrideAction() (*OriginGroupOverrideAction, bool) {
	return nil, false
}

// AsURLSigningAction is the BasicDeliveryRuleAction implementation for DeliveryRuleCacheExpirationAction.
func (drcea DeliveryRuleCacheExpirationAction) AsURLSigningAction() (*URLSigningAction, bool) {
	return nil, false
}

// AsURLRedirectAction is the BasicDeliveryRuleAction implementation for DeliveryRuleCacheExpirationAction.
func (drcea DeliveryRuleCacheExpirationAction) AsURLRedirectAction() (*URLRedirectAction, bool) {
	return nil, false
}

// AsDeliveryRuleAction is the BasicDeliveryRuleAction implementation for DeliveryRuleCacheExpirationAction.
func (drcea DeliveryRuleCacheExpirationAction) AsDeliveryRuleAction() (*DeliveryRuleAction, bool) {
	return nil, false
}

// AsBasicDeliveryRuleAction is the BasicDeliveryRuleAction implementation for DeliveryRuleCacheExpirationAction.
func (drcea DeliveryRuleCacheExpirationAction) AsBasicDeliveryRuleAction() (BasicDeliveryRuleAction, bool) {
	return &drcea, true
}

// DeliveryRuleCacheKeyQueryStringAction defines the cache-key query string action for the delivery rule.
type DeliveryRuleCacheKeyQueryStringAction struct {
	// Parameters - Defines the parameters for the action.
	Parameters *CacheKeyQueryStringActionParameters `json:"parameters,omitempty"`
	// Name - Possible values include: 'NameBasicDeliveryRuleActionNameDeliveryRuleAction', 'NameBasicDeliveryRuleActionNameRouteConfigurationOverride', 'NameBasicDeliveryRuleActionNameCacheKeyQueryString', 'NameBasicDeliveryRuleActionNameCacheExpiration', 'NameBasicDeliveryRuleActionNameModifyResponseHeader', 'NameBasicDeliveryRuleActionNameModifyRequestHeader', 'NameBasicDeliveryRuleActionNameURLRewrite', 'NameBasicDeliveryRuleActionNameOriginGroupOverride', 'NameBasicDeliveryRuleActionNameURLSigning', 'NameBasicDeliveryRuleActionNameURLRedirect'
	Name NameBasicDeliveryRuleAction `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for DeliveryRuleCacheKeyQueryStringAction.
func (drckqsa DeliveryRuleCacheKeyQueryStringAction) MarshalJSON() ([]byte, error) {
	drckqsa.Name = NameBasicDeliveryRuleActionNameCacheKeyQueryString
	objectMap := make(map[string]interface{})
	if drckqsa.Parameters != nil {
		objectMap["parameters"] = drckqsa.Parameters
	}
	if drckqsa.Name != "" {
		objectMap["name"] = drckqsa.Name
	}
	return json.Marshal(objectMap)
}

// AsDeliveryRuleRouteConfigurationOverrideAction is the BasicDeliveryRuleAction implementation for DeliveryRuleCacheKeyQueryStringAction.
func (drckqsa DeliveryRuleCacheKeyQueryStringAction) AsDeliveryRuleRouteConfigurationOverrideAction() (*DeliveryRuleRouteConfigurationOverrideAction, bool) {
	return nil, false
}

// AsDeliveryRuleCacheKeyQueryStringAction is the BasicDeliveryRuleAction implementation for DeliveryRuleCacheKeyQueryStringAction.
func (drckqsa DeliveryRuleCacheKeyQueryStringAction) AsDeliveryRuleCacheKeyQueryStringAction() (*DeliveryRuleCacheKeyQueryStringAction, bool) {
	return &drckqsa, true
}

// AsDeliveryRuleCacheExpirationAction is the BasicDeliveryRuleAction implementation for DeliveryRuleCacheKeyQueryStringAction.
func (drckqsa DeliveryRuleCacheKeyQueryStringAction) AsDeliveryRuleCacheExpirationAction() (*DeliveryRuleCacheExpirationAction, bool) {
	return nil, false
}

// AsDeliveryRuleResponseHeaderAction is the BasicDeliveryRuleAction implementation for DeliveryRuleCacheKeyQueryStringAction.
func (drckqsa DeliveryRuleCacheKeyQueryStringAction) AsDeliveryRuleResponseHeaderAction() (*DeliveryRuleResponseHeaderAction, bool) {
	return nil, false
}

// AsDeliveryRuleRequestHeaderAction is the BasicDeliveryRuleAction implementation for DeliveryRuleCacheKeyQueryStringAction.
func (drckqsa DeliveryRuleCacheKeyQueryStringAction) AsDeliveryRuleRequestHeaderAction() (*DeliveryRuleRequestHeaderAction, bool) {
	return nil, false
}

// AsURLRewriteAction is the BasicDeliveryRuleAction implementation for DeliveryRuleCacheKeyQueryStringAction.
func (drckqsa DeliveryRuleCacheKeyQueryStringAction) AsURLRewriteAction() (*URLRewriteAction, bool) {
	return nil, false
}

// AsOriginGroupOverrideAction is the BasicDeliveryRuleAction implementation for DeliveryRuleCacheKeyQueryStringAction.
func (drckqsa DeliveryRuleCacheKeyQueryStringAction) AsOriginGroupOverrideAction() (*OriginGroupOverrideAction, bool) {
	return nil, false
}

// AsURLSigningAction is the BasicDeliveryRuleAction implementation for DeliveryRuleCacheKeyQueryStringAction.
func (drckqsa DeliveryRuleCacheKeyQueryStringAction) AsURLSigningAction() (*URLSigningAction, bool) {
	return nil, false
}

// AsURLRedirectAction is the BasicDeliveryRuleAction implementation for DeliveryRuleCacheKeyQueryStringAction.
func (drckqsa DeliveryRuleCacheKeyQueryStringAction) AsURLRedirectAction() (*URLRedirectAction, bool) {
	return nil, false
}

// AsDeliveryRuleAction is the BasicDeliveryRuleAction implementation for DeliveryRuleCacheKeyQueryStringAction.
func (drckqsa DeliveryRuleCacheKeyQueryStringAction) AsDeliveryRuleAction() (*DeliveryRuleAction, bool) {
	return nil, false
}

// AsBasicDeliveryRuleAction is the BasicDeliveryRuleAction implementation for DeliveryRuleCacheKeyQueryStringAction.
func (drckqsa DeliveryRuleCacheKeyQueryStringAction) AsBasicDeliveryRuleAction() (BasicDeliveryRuleAction, bool) {
	return &drckqsa, true
}

// DeliveryRuleClientPortCondition defines the ClientPort condition for the delivery rule.
type DeliveryRuleClientPortCondition struct {
	// Parameters - Defines the parameters for the condition.
	Parameters *ClientPortMatchConditionParameters `json:"parameters,omitempty"`
	// Name - Possible values include: 'NameDeliveryRuleCondition', 'NameSslProtocol', 'NameHostName', 'NameServerPort', 'NameClientPort', 'NameSocketAddr', 'NameIsDevice', 'NameCookies', 'NameHTTPVersion', 'NameURLFileName', 'NameURLFileExtension', 'NameURLPath', 'NameRequestScheme', 'NameRequestBody', 'NameRequestHeader', 'NameRequestURI', 'NamePostArgs', 'NameQueryString', 'NameRequestMethod', 'NameRemoteAddress'
	Name Name `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for DeliveryRuleClientPortCondition.
func (drcpc DeliveryRuleClientPortCondition) MarshalJSON() ([]byte, error) {
	drcpc.Name = NameClientPort
	objectMap := make(map[string]interface{})
	if drcpc.Parameters != nil {
		objectMap["parameters"] = drcpc.Parameters
	}
	if drcpc.Name != "" {
		objectMap["name"] = drcpc.Name
	}
	return json.Marshal(objectMap)
}

// AsDeliveryRuleSslProtocolCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleClientPortCondition.
func (drcpc DeliveryRuleClientPortCondition) AsDeliveryRuleSslProtocolCondition() (*DeliveryRuleSslProtocolCondition, bool) {
	return nil, false
}

// AsDeliveryRuleHostNameCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleClientPortCondition.
func (drcpc DeliveryRuleClientPortCondition) AsDeliveryRuleHostNameCondition() (*DeliveryRuleHostNameCondition, bool) {
	return nil, false
}

// AsDeliveryRuleServerPortCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleClientPortCondition.
func (drcpc DeliveryRuleClientPortCondition) AsDeliveryRuleServerPortCondition() (*DeliveryRuleServerPortCondition, bool) {
	return nil, false
}

// AsDeliveryRuleClientPortCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleClientPortCondition.
func (drcpc DeliveryRuleClientPortCondition) AsDeliveryRuleClientPortCondition() (*DeliveryRuleClientPortCondition, bool) {
	return &drcpc, true
}

// AsDeliveryRuleSocketAddrCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleClientPortCondition.
func (drcpc DeliveryRuleClientPortCondition) AsDeliveryRuleSocketAddrCondition() (*DeliveryRuleSocketAddrCondition, bool) {
	return nil, false
}

// AsDeliveryRuleIsDeviceCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleClientPortCondition.
func (drcpc DeliveryRuleClientPortCondition) AsDeliveryRuleIsDeviceCondition() (*DeliveryRuleIsDeviceCondition, bool) {
	return nil, false
}

// AsDeliveryRuleCookiesCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleClientPortCondition.
func (drcpc DeliveryRuleClientPortCondition) AsDeliveryRuleCookiesCondition() (*DeliveryRuleCookiesCondition, bool) {
	return nil, false
}

// AsDeliveryRuleHTTPVersionCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleClientPortCondition.
func (drcpc DeliveryRuleClientPortCondition) AsDeliveryRuleHTTPVersionCondition() (*DeliveryRuleHTTPVersionCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileNameCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleClientPortCondition.
func (drcpc DeliveryRuleClientPortCondition) AsDeliveryRuleURLFileNameCondition() (*DeliveryRuleURLFileNameCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileExtensionCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleClientPortCondition.
func (drcpc DeliveryRuleClientPortCondition) AsDeliveryRuleURLFileExtensionCondition() (*DeliveryRuleURLFileExtensionCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLPathCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleClientPortCondition.
func (drcpc DeliveryRuleClientPortCondition) AsDeliveryRuleURLPathCondition() (*DeliveryRuleURLPathCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestSchemeCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleClientPortCondition.
func (drcpc DeliveryRuleClientPortCondition) AsDeliveryRuleRequestSchemeCondition() (*DeliveryRuleRequestSchemeCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestBodyCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleClientPortCondition.
func (drcpc DeliveryRuleClientPortCondition) AsDeliveryRuleRequestBodyCondition() (*DeliveryRuleRequestBodyCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestHeaderCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleClientPortCondition.
func (drcpc DeliveryRuleClientPortCondition) AsDeliveryRuleRequestHeaderCondition() (*DeliveryRuleRequestHeaderCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestURICondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleClientPortCondition.
func (drcpc DeliveryRuleClientPortCondition) AsDeliveryRuleRequestURICondition() (*DeliveryRuleRequestURICondition, bool) {
	return nil, false
}

// AsDeliveryRulePostArgsCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleClientPortCondition.
func (drcpc DeliveryRuleClientPortCondition) AsDeliveryRulePostArgsCondition() (*DeliveryRulePostArgsCondition, bool) {
	return nil, false
}

// AsDeliveryRuleQueryStringCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleClientPortCondition.
func (drcpc DeliveryRuleClientPortCondition) AsDeliveryRuleQueryStringCondition() (*DeliveryRuleQueryStringCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestMethodCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleClientPortCondition.
func (drcpc DeliveryRuleClientPortCondition) AsDeliveryRuleRequestMethodCondition() (*DeliveryRuleRequestMethodCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRemoteAddressCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleClientPortCondition.
func (drcpc DeliveryRuleClientPortCondition) AsDeliveryRuleRemoteAddressCondition() (*DeliveryRuleRemoteAddressCondition, bool) {
	return nil, false
}

// AsDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleClientPortCondition.
func (drcpc DeliveryRuleClientPortCondition) AsDeliveryRuleCondition() (*DeliveryRuleCondition, bool) {
	return nil, false
}

// AsBasicDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleClientPortCondition.
func (drcpc DeliveryRuleClientPortCondition) AsBasicDeliveryRuleCondition() (BasicDeliveryRuleCondition, bool) {
	return &drcpc, true
}

// BasicDeliveryRuleCondition a condition for the delivery rule.
type BasicDeliveryRuleCondition interface {
	AsDeliveryRuleSslProtocolCondition() (*DeliveryRuleSslProtocolCondition, bool)
	AsDeliveryRuleHostNameCondition() (*DeliveryRuleHostNameCondition, bool)
	AsDeliveryRuleServerPortCondition() (*DeliveryRuleServerPortCondition, bool)
	AsDeliveryRuleClientPortCondition() (*DeliveryRuleClientPortCondition, bool)
	AsDeliveryRuleSocketAddrCondition() (*DeliveryRuleSocketAddrCondition, bool)
	AsDeliveryRuleIsDeviceCondition() (*DeliveryRuleIsDeviceCondition, bool)
	AsDeliveryRuleCookiesCondition() (*DeliveryRuleCookiesCondition, bool)
	AsDeliveryRuleHTTPVersionCondition() (*DeliveryRuleHTTPVersionCondition, bool)
	AsDeliveryRuleURLFileNameCondition() (*DeliveryRuleURLFileNameCondition, bool)
	AsDeliveryRuleURLFileExtensionCondition() (*DeliveryRuleURLFileExtensionCondition, bool)
	AsDeliveryRuleURLPathCondition() (*DeliveryRuleURLPathCondition, bool)
	AsDeliveryRuleRequestSchemeCondition() (*DeliveryRuleRequestSchemeCondition, bool)
	AsDeliveryRuleRequestBodyCondition() (*DeliveryRuleRequestBodyCondition, bool)
	AsDeliveryRuleRequestHeaderCondition() (*DeliveryRuleRequestHeaderCondition, bool)
	AsDeliveryRuleRequestURICondition() (*DeliveryRuleRequestURICondition, bool)
	AsDeliveryRulePostArgsCondition() (*DeliveryRulePostArgsCondition, bool)
	AsDeliveryRuleQueryStringCondition() (*DeliveryRuleQueryStringCondition, bool)
	AsDeliveryRuleRequestMethodCondition() (*DeliveryRuleRequestMethodCondition, bool)
	AsDeliveryRuleRemoteAddressCondition() (*DeliveryRuleRemoteAddressCondition, bool)
	AsDeliveryRuleCondition() (*DeliveryRuleCondition, bool)
}

// DeliveryRuleCondition a condition for the delivery rule.
type DeliveryRuleCondition struct {
	// Name - Possible values include: 'NameDeliveryRuleCondition', 'NameSslProtocol', 'NameHostName', 'NameServerPort', 'NameClientPort', 'NameSocketAddr', 'NameIsDevice', 'NameCookies', 'NameHTTPVersion', 'NameURLFileName', 'NameURLFileExtension', 'NameURLPath', 'NameRequestScheme', 'NameRequestBody', 'NameRequestHeader', 'NameRequestURI', 'NamePostArgs', 'NameQueryString', 'NameRequestMethod', 'NameRemoteAddress'
	Name Name `json:"name,omitempty"`
}

func unmarshalBasicDeliveryRuleCondition(body []byte) (BasicDeliveryRuleCondition, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["name"] {
	case string(NameSslProtocol):
		var drspc DeliveryRuleSslProtocolCondition
		err := json.Unmarshal(body, &drspc)
		return drspc, err
	case string(NameHostName):
		var drhnc DeliveryRuleHostNameCondition
		err := json.Unmarshal(body, &drhnc)
		return drhnc, err
	case string(NameServerPort):
		var drspc DeliveryRuleServerPortCondition
		err := json.Unmarshal(body, &drspc)
		return drspc, err
	case string(NameClientPort):
		var drcpc DeliveryRuleClientPortCondition
		err := json.Unmarshal(body, &drcpc)
		return drcpc, err
	case string(NameSocketAddr):
		var drsac DeliveryRuleSocketAddrCondition
		err := json.Unmarshal(body, &drsac)
		return drsac, err
	case string(NameIsDevice):
		var dridc DeliveryRuleIsDeviceCondition
		err := json.Unmarshal(body, &dridc)
		return dridc, err
	case string(NameCookies):
		var drcc DeliveryRuleCookiesCondition
		err := json.Unmarshal(body, &drcc)
		return drcc, err
	case string(NameHTTPVersion):
		var drhvc DeliveryRuleHTTPVersionCondition
		err := json.Unmarshal(body, &drhvc)
		return drhvc, err
	case string(NameURLFileName):
		var drufnc DeliveryRuleURLFileNameCondition
		err := json.Unmarshal(body, &drufnc)
		return drufnc, err
	case string(NameURLFileExtension):
		var drufec DeliveryRuleURLFileExtensionCondition
		err := json.Unmarshal(body, &drufec)
		return drufec, err
	case string(NameURLPath):
		var drupc DeliveryRuleURLPathCondition
		err := json.Unmarshal(body, &drupc)
		return drupc, err
	case string(NameRequestScheme):
		var drrsc DeliveryRuleRequestSchemeCondition
		err := json.Unmarshal(body, &drrsc)
		return drrsc, err
	case string(NameRequestBody):
		var drrbc DeliveryRuleRequestBodyCondition
		err := json.Unmarshal(body, &drrbc)
		return drrbc, err
	case string(NameRequestHeader):
		var drrhc DeliveryRuleRequestHeaderCondition
		err := json.Unmarshal(body, &drrhc)
		return drrhc, err
	case string(NameRequestURI):
		var drruc DeliveryRuleRequestURICondition
		err := json.Unmarshal(body, &drruc)
		return drruc, err
	case string(NamePostArgs):
		var drpac DeliveryRulePostArgsCondition
		err := json.Unmarshal(body, &drpac)
		return drpac, err
	case string(NameQueryString):
		var drqsc DeliveryRuleQueryStringCondition
		err := json.Unmarshal(body, &drqsc)
		return drqsc, err
	case string(NameRequestMethod):
		var drrmc DeliveryRuleRequestMethodCondition
		err := json.Unmarshal(body, &drrmc)
		return drrmc, err
	case string(NameRemoteAddress):
		var drrac DeliveryRuleRemoteAddressCondition
		err := json.Unmarshal(body, &drrac)
		return drrac, err
	default:
		var drc DeliveryRuleCondition
		err := json.Unmarshal(body, &drc)
		return drc, err
	}
}
func unmarshalBasicDeliveryRuleConditionArray(body []byte) ([]BasicDeliveryRuleCondition, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	drcArray := make([]BasicDeliveryRuleCondition, len(rawMessages))

	for index, rawMessage := range rawMessages {
		drc, err := unmarshalBasicDeliveryRuleCondition(*rawMessage)
		if err != nil {
			return nil, err
		}
		drcArray[index] = drc
	}
	return drcArray, nil
}

// MarshalJSON is the custom marshaler for DeliveryRuleCondition.
func (drc DeliveryRuleCondition) MarshalJSON() ([]byte, error) {
	drc.Name = NameDeliveryRuleCondition
	objectMap := make(map[string]interface{})
	if drc.Name != "" {
		objectMap["name"] = drc.Name
	}
	return json.Marshal(objectMap)
}

// AsDeliveryRuleSslProtocolCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleCondition.
func (drc DeliveryRuleCondition) AsDeliveryRuleSslProtocolCondition() (*DeliveryRuleSslProtocolCondition, bool) {
	return nil, false
}

// AsDeliveryRuleHostNameCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleCondition.
func (drc DeliveryRuleCondition) AsDeliveryRuleHostNameCondition() (*DeliveryRuleHostNameCondition, bool) {
	return nil, false
}

// AsDeliveryRuleServerPortCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleCondition.
func (drc DeliveryRuleCondition) AsDeliveryRuleServerPortCondition() (*DeliveryRuleServerPortCondition, bool) {
	return nil, false
}

// AsDeliveryRuleClientPortCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleCondition.
func (drc DeliveryRuleCondition) AsDeliveryRuleClientPortCondition() (*DeliveryRuleClientPortCondition, bool) {
	return nil, false
}

// AsDeliveryRuleSocketAddrCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleCondition.
func (drc DeliveryRuleCondition) AsDeliveryRuleSocketAddrCondition() (*DeliveryRuleSocketAddrCondition, bool) {
	return nil, false
}

// AsDeliveryRuleIsDeviceCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleCondition.
func (drc DeliveryRuleCondition) AsDeliveryRuleIsDeviceCondition() (*DeliveryRuleIsDeviceCondition, bool) {
	return nil, false
}

// AsDeliveryRuleCookiesCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleCondition.
func (drc DeliveryRuleCondition) AsDeliveryRuleCookiesCondition() (*DeliveryRuleCookiesCondition, bool) {
	return nil, false
}

// AsDeliveryRuleHTTPVersionCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleCondition.
func (drc DeliveryRuleCondition) AsDeliveryRuleHTTPVersionCondition() (*DeliveryRuleHTTPVersionCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileNameCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleCondition.
func (drc DeliveryRuleCondition) AsDeliveryRuleURLFileNameCondition() (*DeliveryRuleURLFileNameCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileExtensionCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleCondition.
func (drc DeliveryRuleCondition) AsDeliveryRuleURLFileExtensionCondition() (*DeliveryRuleURLFileExtensionCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLPathCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleCondition.
func (drc DeliveryRuleCondition) AsDeliveryRuleURLPathCondition() (*DeliveryRuleURLPathCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestSchemeCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleCondition.
func (drc DeliveryRuleCondition) AsDeliveryRuleRequestSchemeCondition() (*DeliveryRuleRequestSchemeCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestBodyCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleCondition.
func (drc DeliveryRuleCondition) AsDeliveryRuleRequestBodyCondition() (*DeliveryRuleRequestBodyCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestHeaderCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleCondition.
func (drc DeliveryRuleCondition) AsDeliveryRuleRequestHeaderCondition() (*DeliveryRuleRequestHeaderCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestURICondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleCondition.
func (drc DeliveryRuleCondition) AsDeliveryRuleRequestURICondition() (*DeliveryRuleRequestURICondition, bool) {
	return nil, false
}

// AsDeliveryRulePostArgsCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleCondition.
func (drc DeliveryRuleCondition) AsDeliveryRulePostArgsCondition() (*DeliveryRulePostArgsCondition, bool) {
	return nil, false
}

// AsDeliveryRuleQueryStringCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleCondition.
func (drc DeliveryRuleCondition) AsDeliveryRuleQueryStringCondition() (*DeliveryRuleQueryStringCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestMethodCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleCondition.
func (drc DeliveryRuleCondition) AsDeliveryRuleRequestMethodCondition() (*DeliveryRuleRequestMethodCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRemoteAddressCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleCondition.
func (drc DeliveryRuleCondition) AsDeliveryRuleRemoteAddressCondition() (*DeliveryRuleRemoteAddressCondition, bool) {
	return nil, false
}

// AsDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleCondition.
func (drc DeliveryRuleCondition) AsDeliveryRuleCondition() (*DeliveryRuleCondition, bool) {
	return &drc, true
}

// AsBasicDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleCondition.
func (drc DeliveryRuleCondition) AsBasicDeliveryRuleCondition() (BasicDeliveryRuleCondition, bool) {
	return &drc, true
}

// DeliveryRuleCookiesCondition defines the Cookies condition for the delivery rule.
type DeliveryRuleCookiesCondition struct {
	// Parameters - Defines the parameters for the condition.
	Parameters *CookiesMatchConditionParameters `json:"parameters,omitempty"`
	// Name - Possible values include: 'NameDeliveryRuleCondition', 'NameSslProtocol', 'NameHostName', 'NameServerPort', 'NameClientPort', 'NameSocketAddr', 'NameIsDevice', 'NameCookies', 'NameHTTPVersion', 'NameURLFileName', 'NameURLFileExtension', 'NameURLPath', 'NameRequestScheme', 'NameRequestBody', 'NameRequestHeader', 'NameRequestURI', 'NamePostArgs', 'NameQueryString', 'NameRequestMethod', 'NameRemoteAddress'
	Name Name `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for DeliveryRuleCookiesCondition.
func (drcc DeliveryRuleCookiesCondition) MarshalJSON() ([]byte, error) {
	drcc.Name = NameCookies
	objectMap := make(map[string]interface{})
	if drcc.Parameters != nil {
		objectMap["parameters"] = drcc.Parameters
	}
	if drcc.Name != "" {
		objectMap["name"] = drcc.Name
	}
	return json.Marshal(objectMap)
}

// AsDeliveryRuleSslProtocolCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleCookiesCondition.
func (drcc DeliveryRuleCookiesCondition) AsDeliveryRuleSslProtocolCondition() (*DeliveryRuleSslProtocolCondition, bool) {
	return nil, false
}

// AsDeliveryRuleHostNameCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleCookiesCondition.
func (drcc DeliveryRuleCookiesCondition) AsDeliveryRuleHostNameCondition() (*DeliveryRuleHostNameCondition, bool) {
	return nil, false
}

// AsDeliveryRuleServerPortCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleCookiesCondition.
func (drcc DeliveryRuleCookiesCondition) AsDeliveryRuleServerPortCondition() (*DeliveryRuleServerPortCondition, bool) {
	return nil, false
}

// AsDeliveryRuleClientPortCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleCookiesCondition.
func (drcc DeliveryRuleCookiesCondition) AsDeliveryRuleClientPortCondition() (*DeliveryRuleClientPortCondition, bool) {
	return nil, false
}

// AsDeliveryRuleSocketAddrCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleCookiesCondition.
func (drcc DeliveryRuleCookiesCondition) AsDeliveryRuleSocketAddrCondition() (*DeliveryRuleSocketAddrCondition, bool) {
	return nil, false
}

// AsDeliveryRuleIsDeviceCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleCookiesCondition.
func (drcc DeliveryRuleCookiesCondition) AsDeliveryRuleIsDeviceCondition() (*DeliveryRuleIsDeviceCondition, bool) {
	return nil, false
}

// AsDeliveryRuleCookiesCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleCookiesCondition.
func (drcc DeliveryRuleCookiesCondition) AsDeliveryRuleCookiesCondition() (*DeliveryRuleCookiesCondition, bool) {
	return &drcc, true
}

// AsDeliveryRuleHTTPVersionCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleCookiesCondition.
func (drcc DeliveryRuleCookiesCondition) AsDeliveryRuleHTTPVersionCondition() (*DeliveryRuleHTTPVersionCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileNameCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleCookiesCondition.
func (drcc DeliveryRuleCookiesCondition) AsDeliveryRuleURLFileNameCondition() (*DeliveryRuleURLFileNameCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileExtensionCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleCookiesCondition.
func (drcc DeliveryRuleCookiesCondition) AsDeliveryRuleURLFileExtensionCondition() (*DeliveryRuleURLFileExtensionCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLPathCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleCookiesCondition.
func (drcc DeliveryRuleCookiesCondition) AsDeliveryRuleURLPathCondition() (*DeliveryRuleURLPathCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestSchemeCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleCookiesCondition.
func (drcc DeliveryRuleCookiesCondition) AsDeliveryRuleRequestSchemeCondition() (*DeliveryRuleRequestSchemeCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestBodyCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleCookiesCondition.
func (drcc DeliveryRuleCookiesCondition) AsDeliveryRuleRequestBodyCondition() (*DeliveryRuleRequestBodyCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestHeaderCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleCookiesCondition.
func (drcc DeliveryRuleCookiesCondition) AsDeliveryRuleRequestHeaderCondition() (*DeliveryRuleRequestHeaderCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestURICondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleCookiesCondition.
func (drcc DeliveryRuleCookiesCondition) AsDeliveryRuleRequestURICondition() (*DeliveryRuleRequestURICondition, bool) {
	return nil, false
}

// AsDeliveryRulePostArgsCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleCookiesCondition.
func (drcc DeliveryRuleCookiesCondition) AsDeliveryRulePostArgsCondition() (*DeliveryRulePostArgsCondition, bool) {
	return nil, false
}

// AsDeliveryRuleQueryStringCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleCookiesCondition.
func (drcc DeliveryRuleCookiesCondition) AsDeliveryRuleQueryStringCondition() (*DeliveryRuleQueryStringCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestMethodCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleCookiesCondition.
func (drcc DeliveryRuleCookiesCondition) AsDeliveryRuleRequestMethodCondition() (*DeliveryRuleRequestMethodCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRemoteAddressCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleCookiesCondition.
func (drcc DeliveryRuleCookiesCondition) AsDeliveryRuleRemoteAddressCondition() (*DeliveryRuleRemoteAddressCondition, bool) {
	return nil, false
}

// AsDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleCookiesCondition.
func (drcc DeliveryRuleCookiesCondition) AsDeliveryRuleCondition() (*DeliveryRuleCondition, bool) {
	return nil, false
}

// AsBasicDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleCookiesCondition.
func (drcc DeliveryRuleCookiesCondition) AsBasicDeliveryRuleCondition() (BasicDeliveryRuleCondition, bool) {
	return &drcc, true
}

// DeliveryRuleHostNameCondition defines the HostName condition for the delivery rule.
type DeliveryRuleHostNameCondition struct {
	// Parameters - Defines the parameters for the condition.
	Parameters *HostNameMatchConditionParameters `json:"parameters,omitempty"`
	// Name - Possible values include: 'NameDeliveryRuleCondition', 'NameSslProtocol', 'NameHostName', 'NameServerPort', 'NameClientPort', 'NameSocketAddr', 'NameIsDevice', 'NameCookies', 'NameHTTPVersion', 'NameURLFileName', 'NameURLFileExtension', 'NameURLPath', 'NameRequestScheme', 'NameRequestBody', 'NameRequestHeader', 'NameRequestURI', 'NamePostArgs', 'NameQueryString', 'NameRequestMethod', 'NameRemoteAddress'
	Name Name `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for DeliveryRuleHostNameCondition.
func (drhnc DeliveryRuleHostNameCondition) MarshalJSON() ([]byte, error) {
	drhnc.Name = NameHostName
	objectMap := make(map[string]interface{})
	if drhnc.Parameters != nil {
		objectMap["parameters"] = drhnc.Parameters
	}
	if drhnc.Name != "" {
		objectMap["name"] = drhnc.Name
	}
	return json.Marshal(objectMap)
}

// AsDeliveryRuleSslProtocolCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleHostNameCondition.
func (drhnc DeliveryRuleHostNameCondition) AsDeliveryRuleSslProtocolCondition() (*DeliveryRuleSslProtocolCondition, bool) {
	return nil, false
}

// AsDeliveryRuleHostNameCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleHostNameCondition.
func (drhnc DeliveryRuleHostNameCondition) AsDeliveryRuleHostNameCondition() (*DeliveryRuleHostNameCondition, bool) {
	return &drhnc, true
}

// AsDeliveryRuleServerPortCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleHostNameCondition.
func (drhnc DeliveryRuleHostNameCondition) AsDeliveryRuleServerPortCondition() (*DeliveryRuleServerPortCondition, bool) {
	return nil, false
}

// AsDeliveryRuleClientPortCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleHostNameCondition.
func (drhnc DeliveryRuleHostNameCondition) AsDeliveryRuleClientPortCondition() (*DeliveryRuleClientPortCondition, bool) {
	return nil, false
}

// AsDeliveryRuleSocketAddrCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleHostNameCondition.
func (drhnc DeliveryRuleHostNameCondition) AsDeliveryRuleSocketAddrCondition() (*DeliveryRuleSocketAddrCondition, bool) {
	return nil, false
}

// AsDeliveryRuleIsDeviceCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleHostNameCondition.
func (drhnc DeliveryRuleHostNameCondition) AsDeliveryRuleIsDeviceCondition() (*DeliveryRuleIsDeviceCondition, bool) {
	return nil, false
}

// AsDeliveryRuleCookiesCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleHostNameCondition.
func (drhnc DeliveryRuleHostNameCondition) AsDeliveryRuleCookiesCondition() (*DeliveryRuleCookiesCondition, bool) {
	return nil, false
}

// AsDeliveryRuleHTTPVersionCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleHostNameCondition.
func (drhnc DeliveryRuleHostNameCondition) AsDeliveryRuleHTTPVersionCondition() (*DeliveryRuleHTTPVersionCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileNameCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleHostNameCondition.
func (drhnc DeliveryRuleHostNameCondition) AsDeliveryRuleURLFileNameCondition() (*DeliveryRuleURLFileNameCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileExtensionCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleHostNameCondition.
func (drhnc DeliveryRuleHostNameCondition) AsDeliveryRuleURLFileExtensionCondition() (*DeliveryRuleURLFileExtensionCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLPathCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleHostNameCondition.
func (drhnc DeliveryRuleHostNameCondition) AsDeliveryRuleURLPathCondition() (*DeliveryRuleURLPathCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestSchemeCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleHostNameCondition.
func (drhnc DeliveryRuleHostNameCondition) AsDeliveryRuleRequestSchemeCondition() (*DeliveryRuleRequestSchemeCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestBodyCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleHostNameCondition.
func (drhnc DeliveryRuleHostNameCondition) AsDeliveryRuleRequestBodyCondition() (*DeliveryRuleRequestBodyCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestHeaderCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleHostNameCondition.
func (drhnc DeliveryRuleHostNameCondition) AsDeliveryRuleRequestHeaderCondition() (*DeliveryRuleRequestHeaderCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestURICondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleHostNameCondition.
func (drhnc DeliveryRuleHostNameCondition) AsDeliveryRuleRequestURICondition() (*DeliveryRuleRequestURICondition, bool) {
	return nil, false
}

// AsDeliveryRulePostArgsCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleHostNameCondition.
func (drhnc DeliveryRuleHostNameCondition) AsDeliveryRulePostArgsCondition() (*DeliveryRulePostArgsCondition, bool) {
	return nil, false
}

// AsDeliveryRuleQueryStringCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleHostNameCondition.
func (drhnc DeliveryRuleHostNameCondition) AsDeliveryRuleQueryStringCondition() (*DeliveryRuleQueryStringCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestMethodCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleHostNameCondition.
func (drhnc DeliveryRuleHostNameCondition) AsDeliveryRuleRequestMethodCondition() (*DeliveryRuleRequestMethodCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRemoteAddressCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleHostNameCondition.
func (drhnc DeliveryRuleHostNameCondition) AsDeliveryRuleRemoteAddressCondition() (*DeliveryRuleRemoteAddressCondition, bool) {
	return nil, false
}

// AsDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleHostNameCondition.
func (drhnc DeliveryRuleHostNameCondition) AsDeliveryRuleCondition() (*DeliveryRuleCondition, bool) {
	return nil, false
}

// AsBasicDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleHostNameCondition.
func (drhnc DeliveryRuleHostNameCondition) AsBasicDeliveryRuleCondition() (BasicDeliveryRuleCondition, bool) {
	return &drhnc, true
}

// DeliveryRuleHTTPVersionCondition defines the HttpVersion condition for the delivery rule.
type DeliveryRuleHTTPVersionCondition struct {
	// Parameters - Defines the parameters for the condition.
	Parameters *HTTPVersionMatchConditionParameters `json:"parameters,omitempty"`
	// Name - Possible values include: 'NameDeliveryRuleCondition', 'NameSslProtocol', 'NameHostName', 'NameServerPort', 'NameClientPort', 'NameSocketAddr', 'NameIsDevice', 'NameCookies', 'NameHTTPVersion', 'NameURLFileName', 'NameURLFileExtension', 'NameURLPath', 'NameRequestScheme', 'NameRequestBody', 'NameRequestHeader', 'NameRequestURI', 'NamePostArgs', 'NameQueryString', 'NameRequestMethod', 'NameRemoteAddress'
	Name Name `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for DeliveryRuleHTTPVersionCondition.
func (drhvc DeliveryRuleHTTPVersionCondition) MarshalJSON() ([]byte, error) {
	drhvc.Name = NameHTTPVersion
	objectMap := make(map[string]interface{})
	if drhvc.Parameters != nil {
		objectMap["parameters"] = drhvc.Parameters
	}
	if drhvc.Name != "" {
		objectMap["name"] = drhvc.Name
	}
	return json.Marshal(objectMap)
}

// AsDeliveryRuleSslProtocolCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleHTTPVersionCondition.
func (drhvc DeliveryRuleHTTPVersionCondition) AsDeliveryRuleSslProtocolCondition() (*DeliveryRuleSslProtocolCondition, bool) {
	return nil, false
}

// AsDeliveryRuleHostNameCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleHTTPVersionCondition.
func (drhvc DeliveryRuleHTTPVersionCondition) AsDeliveryRuleHostNameCondition() (*DeliveryRuleHostNameCondition, bool) {
	return nil, false
}

// AsDeliveryRuleServerPortCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleHTTPVersionCondition.
func (drhvc DeliveryRuleHTTPVersionCondition) AsDeliveryRuleServerPortCondition() (*DeliveryRuleServerPortCondition, bool) {
	return nil, false
}

// AsDeliveryRuleClientPortCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleHTTPVersionCondition.
func (drhvc DeliveryRuleHTTPVersionCondition) AsDeliveryRuleClientPortCondition() (*DeliveryRuleClientPortCondition, bool) {
	return nil, false
}

// AsDeliveryRuleSocketAddrCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleHTTPVersionCondition.
func (drhvc DeliveryRuleHTTPVersionCondition) AsDeliveryRuleSocketAddrCondition() (*DeliveryRuleSocketAddrCondition, bool) {
	return nil, false
}

// AsDeliveryRuleIsDeviceCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleHTTPVersionCondition.
func (drhvc DeliveryRuleHTTPVersionCondition) AsDeliveryRuleIsDeviceCondition() (*DeliveryRuleIsDeviceCondition, bool) {
	return nil, false
}

// AsDeliveryRuleCookiesCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleHTTPVersionCondition.
func (drhvc DeliveryRuleHTTPVersionCondition) AsDeliveryRuleCookiesCondition() (*DeliveryRuleCookiesCondition, bool) {
	return nil, false
}

// AsDeliveryRuleHTTPVersionCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleHTTPVersionCondition.
func (drhvc DeliveryRuleHTTPVersionCondition) AsDeliveryRuleHTTPVersionCondition() (*DeliveryRuleHTTPVersionCondition, bool) {
	return &drhvc, true
}

// AsDeliveryRuleURLFileNameCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleHTTPVersionCondition.
func (drhvc DeliveryRuleHTTPVersionCondition) AsDeliveryRuleURLFileNameCondition() (*DeliveryRuleURLFileNameCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileExtensionCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleHTTPVersionCondition.
func (drhvc DeliveryRuleHTTPVersionCondition) AsDeliveryRuleURLFileExtensionCondition() (*DeliveryRuleURLFileExtensionCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLPathCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleHTTPVersionCondition.
func (drhvc DeliveryRuleHTTPVersionCondition) AsDeliveryRuleURLPathCondition() (*DeliveryRuleURLPathCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestSchemeCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleHTTPVersionCondition.
func (drhvc DeliveryRuleHTTPVersionCondition) AsDeliveryRuleRequestSchemeCondition() (*DeliveryRuleRequestSchemeCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestBodyCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleHTTPVersionCondition.
func (drhvc DeliveryRuleHTTPVersionCondition) AsDeliveryRuleRequestBodyCondition() (*DeliveryRuleRequestBodyCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestHeaderCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleHTTPVersionCondition.
func (drhvc DeliveryRuleHTTPVersionCondition) AsDeliveryRuleRequestHeaderCondition() (*DeliveryRuleRequestHeaderCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestURICondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleHTTPVersionCondition.
func (drhvc DeliveryRuleHTTPVersionCondition) AsDeliveryRuleRequestURICondition() (*DeliveryRuleRequestURICondition, bool) {
	return nil, false
}

// AsDeliveryRulePostArgsCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleHTTPVersionCondition.
func (drhvc DeliveryRuleHTTPVersionCondition) AsDeliveryRulePostArgsCondition() (*DeliveryRulePostArgsCondition, bool) {
	return nil, false
}

// AsDeliveryRuleQueryStringCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleHTTPVersionCondition.
func (drhvc DeliveryRuleHTTPVersionCondition) AsDeliveryRuleQueryStringCondition() (*DeliveryRuleQueryStringCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestMethodCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleHTTPVersionCondition.
func (drhvc DeliveryRuleHTTPVersionCondition) AsDeliveryRuleRequestMethodCondition() (*DeliveryRuleRequestMethodCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRemoteAddressCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleHTTPVersionCondition.
func (drhvc DeliveryRuleHTTPVersionCondition) AsDeliveryRuleRemoteAddressCondition() (*DeliveryRuleRemoteAddressCondition, bool) {
	return nil, false
}

// AsDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleHTTPVersionCondition.
func (drhvc DeliveryRuleHTTPVersionCondition) AsDeliveryRuleCondition() (*DeliveryRuleCondition, bool) {
	return nil, false
}

// AsBasicDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleHTTPVersionCondition.
func (drhvc DeliveryRuleHTTPVersionCondition) AsBasicDeliveryRuleCondition() (BasicDeliveryRuleCondition, bool) {
	return &drhvc, true
}

// DeliveryRuleIsDeviceCondition defines the IsDevice condition for the delivery rule.
type DeliveryRuleIsDeviceCondition struct {
	// Parameters - Defines the parameters for the condition.
	Parameters *IsDeviceMatchConditionParameters `json:"parameters,omitempty"`
	// Name - Possible values include: 'NameDeliveryRuleCondition', 'NameSslProtocol', 'NameHostName', 'NameServerPort', 'NameClientPort', 'NameSocketAddr', 'NameIsDevice', 'NameCookies', 'NameHTTPVersion', 'NameURLFileName', 'NameURLFileExtension', 'NameURLPath', 'NameRequestScheme', 'NameRequestBody', 'NameRequestHeader', 'NameRequestURI', 'NamePostArgs', 'NameQueryString', 'NameRequestMethod', 'NameRemoteAddress'
	Name Name `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for DeliveryRuleIsDeviceCondition.
func (dridc DeliveryRuleIsDeviceCondition) MarshalJSON() ([]byte, error) {
	dridc.Name = NameIsDevice
	objectMap := make(map[string]interface{})
	if dridc.Parameters != nil {
		objectMap["parameters"] = dridc.Parameters
	}
	if dridc.Name != "" {
		objectMap["name"] = dridc.Name
	}
	return json.Marshal(objectMap)
}

// AsDeliveryRuleSslProtocolCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleIsDeviceCondition.
func (dridc DeliveryRuleIsDeviceCondition) AsDeliveryRuleSslProtocolCondition() (*DeliveryRuleSslProtocolCondition, bool) {
	return nil, false
}

// AsDeliveryRuleHostNameCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleIsDeviceCondition.
func (dridc DeliveryRuleIsDeviceCondition) AsDeliveryRuleHostNameCondition() (*DeliveryRuleHostNameCondition, bool) {
	return nil, false
}

// AsDeliveryRuleServerPortCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleIsDeviceCondition.
func (dridc DeliveryRuleIsDeviceCondition) AsDeliveryRuleServerPortCondition() (*DeliveryRuleServerPortCondition, bool) {
	return nil, false
}

// AsDeliveryRuleClientPortCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleIsDeviceCondition.
func (dridc DeliveryRuleIsDeviceCondition) AsDeliveryRuleClientPortCondition() (*DeliveryRuleClientPortCondition, bool) {
	return nil, false
}

// AsDeliveryRuleSocketAddrCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleIsDeviceCondition.
func (dridc DeliveryRuleIsDeviceCondition) AsDeliveryRuleSocketAddrCondition() (*DeliveryRuleSocketAddrCondition, bool) {
	return nil, false
}

// AsDeliveryRuleIsDeviceCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleIsDeviceCondition.
func (dridc DeliveryRuleIsDeviceCondition) AsDeliveryRuleIsDeviceCondition() (*DeliveryRuleIsDeviceCondition, bool) {
	return &dridc, true
}

// AsDeliveryRuleCookiesCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleIsDeviceCondition.
func (dridc DeliveryRuleIsDeviceCondition) AsDeliveryRuleCookiesCondition() (*DeliveryRuleCookiesCondition, bool) {
	return nil, false
}

// AsDeliveryRuleHTTPVersionCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleIsDeviceCondition.
func (dridc DeliveryRuleIsDeviceCondition) AsDeliveryRuleHTTPVersionCondition() (*DeliveryRuleHTTPVersionCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileNameCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleIsDeviceCondition.
func (dridc DeliveryRuleIsDeviceCondition) AsDeliveryRuleURLFileNameCondition() (*DeliveryRuleURLFileNameCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileExtensionCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleIsDeviceCondition.
func (dridc DeliveryRuleIsDeviceCondition) AsDeliveryRuleURLFileExtensionCondition() (*DeliveryRuleURLFileExtensionCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLPathCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleIsDeviceCondition.
func (dridc DeliveryRuleIsDeviceCondition) AsDeliveryRuleURLPathCondition() (*DeliveryRuleURLPathCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestSchemeCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleIsDeviceCondition.
func (dridc DeliveryRuleIsDeviceCondition) AsDeliveryRuleRequestSchemeCondition() (*DeliveryRuleRequestSchemeCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestBodyCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleIsDeviceCondition.
func (dridc DeliveryRuleIsDeviceCondition) AsDeliveryRuleRequestBodyCondition() (*DeliveryRuleRequestBodyCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestHeaderCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleIsDeviceCondition.
func (dridc DeliveryRuleIsDeviceCondition) AsDeliveryRuleRequestHeaderCondition() (*DeliveryRuleRequestHeaderCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestURICondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleIsDeviceCondition.
func (dridc DeliveryRuleIsDeviceCondition) AsDeliveryRuleRequestURICondition() (*DeliveryRuleRequestURICondition, bool) {
	return nil, false
}

// AsDeliveryRulePostArgsCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleIsDeviceCondition.
func (dridc DeliveryRuleIsDeviceCondition) AsDeliveryRulePostArgsCondition() (*DeliveryRulePostArgsCondition, bool) {
	return nil, false
}

// AsDeliveryRuleQueryStringCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleIsDeviceCondition.
func (dridc DeliveryRuleIsDeviceCondition) AsDeliveryRuleQueryStringCondition() (*DeliveryRuleQueryStringCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestMethodCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleIsDeviceCondition.
func (dridc DeliveryRuleIsDeviceCondition) AsDeliveryRuleRequestMethodCondition() (*DeliveryRuleRequestMethodCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRemoteAddressCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleIsDeviceCondition.
func (dridc DeliveryRuleIsDeviceCondition) AsDeliveryRuleRemoteAddressCondition() (*DeliveryRuleRemoteAddressCondition, bool) {
	return nil, false
}

// AsDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleIsDeviceCondition.
func (dridc DeliveryRuleIsDeviceCondition) AsDeliveryRuleCondition() (*DeliveryRuleCondition, bool) {
	return nil, false
}

// AsBasicDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleIsDeviceCondition.
func (dridc DeliveryRuleIsDeviceCondition) AsBasicDeliveryRuleCondition() (BasicDeliveryRuleCondition, bool) {
	return &dridc, true
}

// DeliveryRulePostArgsCondition defines the PostArgs condition for the delivery rule.
type DeliveryRulePostArgsCondition struct {
	// Parameters - Defines the parameters for the condition.
	Parameters *PostArgsMatchConditionParameters `json:"parameters,omitempty"`
	// Name - Possible values include: 'NameDeliveryRuleCondition', 'NameSslProtocol', 'NameHostName', 'NameServerPort', 'NameClientPort', 'NameSocketAddr', 'NameIsDevice', 'NameCookies', 'NameHTTPVersion', 'NameURLFileName', 'NameURLFileExtension', 'NameURLPath', 'NameRequestScheme', 'NameRequestBody', 'NameRequestHeader', 'NameRequestURI', 'NamePostArgs', 'NameQueryString', 'NameRequestMethod', 'NameRemoteAddress'
	Name Name `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for DeliveryRulePostArgsCondition.
func (drpac DeliveryRulePostArgsCondition) MarshalJSON() ([]byte, error) {
	drpac.Name = NamePostArgs
	objectMap := make(map[string]interface{})
	if drpac.Parameters != nil {
		objectMap["parameters"] = drpac.Parameters
	}
	if drpac.Name != "" {
		objectMap["name"] = drpac.Name
	}
	return json.Marshal(objectMap)
}

// AsDeliveryRuleSslProtocolCondition is the BasicDeliveryRuleCondition implementation for DeliveryRulePostArgsCondition.
func (drpac DeliveryRulePostArgsCondition) AsDeliveryRuleSslProtocolCondition() (*DeliveryRuleSslProtocolCondition, bool) {
	return nil, false
}

// AsDeliveryRuleHostNameCondition is the BasicDeliveryRuleCondition implementation for DeliveryRulePostArgsCondition.
func (drpac DeliveryRulePostArgsCondition) AsDeliveryRuleHostNameCondition() (*DeliveryRuleHostNameCondition, bool) {
	return nil, false
}

// AsDeliveryRuleServerPortCondition is the BasicDeliveryRuleCondition implementation for DeliveryRulePostArgsCondition.
func (drpac DeliveryRulePostArgsCondition) AsDeliveryRuleServerPortCondition() (*DeliveryRuleServerPortCondition, bool) {
	return nil, false
}

// AsDeliveryRuleClientPortCondition is the BasicDeliveryRuleCondition implementation for DeliveryRulePostArgsCondition.
func (drpac DeliveryRulePostArgsCondition) AsDeliveryRuleClientPortCondition() (*DeliveryRuleClientPortCondition, bool) {
	return nil, false
}

// AsDeliveryRuleSocketAddrCondition is the BasicDeliveryRuleCondition implementation for DeliveryRulePostArgsCondition.
func (drpac DeliveryRulePostArgsCondition) AsDeliveryRuleSocketAddrCondition() (*DeliveryRuleSocketAddrCondition, bool) {
	return nil, false
}

// AsDeliveryRuleIsDeviceCondition is the BasicDeliveryRuleCondition implementation for DeliveryRulePostArgsCondition.
func (drpac DeliveryRulePostArgsCondition) AsDeliveryRuleIsDeviceCondition() (*DeliveryRuleIsDeviceCondition, bool) {
	return nil, false
}

// AsDeliveryRuleCookiesCondition is the BasicDeliveryRuleCondition implementation for DeliveryRulePostArgsCondition.
func (drpac DeliveryRulePostArgsCondition) AsDeliveryRuleCookiesCondition() (*DeliveryRuleCookiesCondition, bool) {
	return nil, false
}

// AsDeliveryRuleHTTPVersionCondition is the BasicDeliveryRuleCondition implementation for DeliveryRulePostArgsCondition.
func (drpac DeliveryRulePostArgsCondition) AsDeliveryRuleHTTPVersionCondition() (*DeliveryRuleHTTPVersionCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileNameCondition is the BasicDeliveryRuleCondition implementation for DeliveryRulePostArgsCondition.
func (drpac DeliveryRulePostArgsCondition) AsDeliveryRuleURLFileNameCondition() (*DeliveryRuleURLFileNameCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileExtensionCondition is the BasicDeliveryRuleCondition implementation for DeliveryRulePostArgsCondition.
func (drpac DeliveryRulePostArgsCondition) AsDeliveryRuleURLFileExtensionCondition() (*DeliveryRuleURLFileExtensionCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLPathCondition is the BasicDeliveryRuleCondition implementation for DeliveryRulePostArgsCondition.
func (drpac DeliveryRulePostArgsCondition) AsDeliveryRuleURLPathCondition() (*DeliveryRuleURLPathCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestSchemeCondition is the BasicDeliveryRuleCondition implementation for DeliveryRulePostArgsCondition.
func (drpac DeliveryRulePostArgsCondition) AsDeliveryRuleRequestSchemeCondition() (*DeliveryRuleRequestSchemeCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestBodyCondition is the BasicDeliveryRuleCondition implementation for DeliveryRulePostArgsCondition.
func (drpac DeliveryRulePostArgsCondition) AsDeliveryRuleRequestBodyCondition() (*DeliveryRuleRequestBodyCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestHeaderCondition is the BasicDeliveryRuleCondition implementation for DeliveryRulePostArgsCondition.
func (drpac DeliveryRulePostArgsCondition) AsDeliveryRuleRequestHeaderCondition() (*DeliveryRuleRequestHeaderCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestURICondition is the BasicDeliveryRuleCondition implementation for DeliveryRulePostArgsCondition.
func (drpac DeliveryRulePostArgsCondition) AsDeliveryRuleRequestURICondition() (*DeliveryRuleRequestURICondition, bool) {
	return nil, false
}

// AsDeliveryRulePostArgsCondition is the BasicDeliveryRuleCondition implementation for DeliveryRulePostArgsCondition.
func (drpac DeliveryRulePostArgsCondition) AsDeliveryRulePostArgsCondition() (*DeliveryRulePostArgsCondition, bool) {
	return &drpac, true
}

// AsDeliveryRuleQueryStringCondition is the BasicDeliveryRuleCondition implementation for DeliveryRulePostArgsCondition.
func (drpac DeliveryRulePostArgsCondition) AsDeliveryRuleQueryStringCondition() (*DeliveryRuleQueryStringCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestMethodCondition is the BasicDeliveryRuleCondition implementation for DeliveryRulePostArgsCondition.
func (drpac DeliveryRulePostArgsCondition) AsDeliveryRuleRequestMethodCondition() (*DeliveryRuleRequestMethodCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRemoteAddressCondition is the BasicDeliveryRuleCondition implementation for DeliveryRulePostArgsCondition.
func (drpac DeliveryRulePostArgsCondition) AsDeliveryRuleRemoteAddressCondition() (*DeliveryRuleRemoteAddressCondition, bool) {
	return nil, false
}

// AsDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRulePostArgsCondition.
func (drpac DeliveryRulePostArgsCondition) AsDeliveryRuleCondition() (*DeliveryRuleCondition, bool) {
	return nil, false
}

// AsBasicDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRulePostArgsCondition.
func (drpac DeliveryRulePostArgsCondition) AsBasicDeliveryRuleCondition() (BasicDeliveryRuleCondition, bool) {
	return &drpac, true
}

// DeliveryRuleQueryStringCondition defines the QueryString condition for the delivery rule.
type DeliveryRuleQueryStringCondition struct {
	// Parameters - Defines the parameters for the condition.
	Parameters *QueryStringMatchConditionParameters `json:"parameters,omitempty"`
	// Name - Possible values include: 'NameDeliveryRuleCondition', 'NameSslProtocol', 'NameHostName', 'NameServerPort', 'NameClientPort', 'NameSocketAddr', 'NameIsDevice', 'NameCookies', 'NameHTTPVersion', 'NameURLFileName', 'NameURLFileExtension', 'NameURLPath', 'NameRequestScheme', 'NameRequestBody', 'NameRequestHeader', 'NameRequestURI', 'NamePostArgs', 'NameQueryString', 'NameRequestMethod', 'NameRemoteAddress'
	Name Name `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for DeliveryRuleQueryStringCondition.
func (drqsc DeliveryRuleQueryStringCondition) MarshalJSON() ([]byte, error) {
	drqsc.Name = NameQueryString
	objectMap := make(map[string]interface{})
	if drqsc.Parameters != nil {
		objectMap["parameters"] = drqsc.Parameters
	}
	if drqsc.Name != "" {
		objectMap["name"] = drqsc.Name
	}
	return json.Marshal(objectMap)
}

// AsDeliveryRuleSslProtocolCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleQueryStringCondition.
func (drqsc DeliveryRuleQueryStringCondition) AsDeliveryRuleSslProtocolCondition() (*DeliveryRuleSslProtocolCondition, bool) {
	return nil, false
}

// AsDeliveryRuleHostNameCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleQueryStringCondition.
func (drqsc DeliveryRuleQueryStringCondition) AsDeliveryRuleHostNameCondition() (*DeliveryRuleHostNameCondition, bool) {
	return nil, false
}

// AsDeliveryRuleServerPortCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleQueryStringCondition.
func (drqsc DeliveryRuleQueryStringCondition) AsDeliveryRuleServerPortCondition() (*DeliveryRuleServerPortCondition, bool) {
	return nil, false
}

// AsDeliveryRuleClientPortCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleQueryStringCondition.
func (drqsc DeliveryRuleQueryStringCondition) AsDeliveryRuleClientPortCondition() (*DeliveryRuleClientPortCondition, bool) {
	return nil, false
}

// AsDeliveryRuleSocketAddrCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleQueryStringCondition.
func (drqsc DeliveryRuleQueryStringCondition) AsDeliveryRuleSocketAddrCondition() (*DeliveryRuleSocketAddrCondition, bool) {
	return nil, false
}

// AsDeliveryRuleIsDeviceCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleQueryStringCondition.
func (drqsc DeliveryRuleQueryStringCondition) AsDeliveryRuleIsDeviceCondition() (*DeliveryRuleIsDeviceCondition, bool) {
	return nil, false
}

// AsDeliveryRuleCookiesCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleQueryStringCondition.
func (drqsc DeliveryRuleQueryStringCondition) AsDeliveryRuleCookiesCondition() (*DeliveryRuleCookiesCondition, bool) {
	return nil, false
}

// AsDeliveryRuleHTTPVersionCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleQueryStringCondition.
func (drqsc DeliveryRuleQueryStringCondition) AsDeliveryRuleHTTPVersionCondition() (*DeliveryRuleHTTPVersionCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileNameCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleQueryStringCondition.
func (drqsc DeliveryRuleQueryStringCondition) AsDeliveryRuleURLFileNameCondition() (*DeliveryRuleURLFileNameCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileExtensionCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleQueryStringCondition.
func (drqsc DeliveryRuleQueryStringCondition) AsDeliveryRuleURLFileExtensionCondition() (*DeliveryRuleURLFileExtensionCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLPathCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleQueryStringCondition.
func (drqsc DeliveryRuleQueryStringCondition) AsDeliveryRuleURLPathCondition() (*DeliveryRuleURLPathCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestSchemeCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleQueryStringCondition.
func (drqsc DeliveryRuleQueryStringCondition) AsDeliveryRuleRequestSchemeCondition() (*DeliveryRuleRequestSchemeCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestBodyCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleQueryStringCondition.
func (drqsc DeliveryRuleQueryStringCondition) AsDeliveryRuleRequestBodyCondition() (*DeliveryRuleRequestBodyCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestHeaderCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleQueryStringCondition.
func (drqsc DeliveryRuleQueryStringCondition) AsDeliveryRuleRequestHeaderCondition() (*DeliveryRuleRequestHeaderCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestURICondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleQueryStringCondition.
func (drqsc DeliveryRuleQueryStringCondition) AsDeliveryRuleRequestURICondition() (*DeliveryRuleRequestURICondition, bool) {
	return nil, false
}

// AsDeliveryRulePostArgsCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleQueryStringCondition.
func (drqsc DeliveryRuleQueryStringCondition) AsDeliveryRulePostArgsCondition() (*DeliveryRulePostArgsCondition, bool) {
	return nil, false
}

// AsDeliveryRuleQueryStringCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleQueryStringCondition.
func (drqsc DeliveryRuleQueryStringCondition) AsDeliveryRuleQueryStringCondition() (*DeliveryRuleQueryStringCondition, bool) {
	return &drqsc, true
}

// AsDeliveryRuleRequestMethodCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleQueryStringCondition.
func (drqsc DeliveryRuleQueryStringCondition) AsDeliveryRuleRequestMethodCondition() (*DeliveryRuleRequestMethodCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRemoteAddressCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleQueryStringCondition.
func (drqsc DeliveryRuleQueryStringCondition) AsDeliveryRuleRemoteAddressCondition() (*DeliveryRuleRemoteAddressCondition, bool) {
	return nil, false
}

// AsDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleQueryStringCondition.
func (drqsc DeliveryRuleQueryStringCondition) AsDeliveryRuleCondition() (*DeliveryRuleCondition, bool) {
	return nil, false
}

// AsBasicDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleQueryStringCondition.
func (drqsc DeliveryRuleQueryStringCondition) AsBasicDeliveryRuleCondition() (BasicDeliveryRuleCondition, bool) {
	return &drqsc, true
}

// DeliveryRuleRemoteAddressCondition defines the RemoteAddress condition for the delivery rule.
type DeliveryRuleRemoteAddressCondition struct {
	// Parameters - Defines the parameters for the condition.
	Parameters *RemoteAddressMatchConditionParameters `json:"parameters,omitempty"`
	// Name - Possible values include: 'NameDeliveryRuleCondition', 'NameSslProtocol', 'NameHostName', 'NameServerPort', 'NameClientPort', 'NameSocketAddr', 'NameIsDevice', 'NameCookies', 'NameHTTPVersion', 'NameURLFileName', 'NameURLFileExtension', 'NameURLPath', 'NameRequestScheme', 'NameRequestBody', 'NameRequestHeader', 'NameRequestURI', 'NamePostArgs', 'NameQueryString', 'NameRequestMethod', 'NameRemoteAddress'
	Name Name `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for DeliveryRuleRemoteAddressCondition.
func (drrac DeliveryRuleRemoteAddressCondition) MarshalJSON() ([]byte, error) {
	drrac.Name = NameRemoteAddress
	objectMap := make(map[string]interface{})
	if drrac.Parameters != nil {
		objectMap["parameters"] = drrac.Parameters
	}
	if drrac.Name != "" {
		objectMap["name"] = drrac.Name
	}
	return json.Marshal(objectMap)
}

// AsDeliveryRuleSslProtocolCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRemoteAddressCondition.
func (drrac DeliveryRuleRemoteAddressCondition) AsDeliveryRuleSslProtocolCondition() (*DeliveryRuleSslProtocolCondition, bool) {
	return nil, false
}

// AsDeliveryRuleHostNameCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRemoteAddressCondition.
func (drrac DeliveryRuleRemoteAddressCondition) AsDeliveryRuleHostNameCondition() (*DeliveryRuleHostNameCondition, bool) {
	return nil, false
}

// AsDeliveryRuleServerPortCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRemoteAddressCondition.
func (drrac DeliveryRuleRemoteAddressCondition) AsDeliveryRuleServerPortCondition() (*DeliveryRuleServerPortCondition, bool) {
	return nil, false
}

// AsDeliveryRuleClientPortCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRemoteAddressCondition.
func (drrac DeliveryRuleRemoteAddressCondition) AsDeliveryRuleClientPortCondition() (*DeliveryRuleClientPortCondition, bool) {
	return nil, false
}

// AsDeliveryRuleSocketAddrCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRemoteAddressCondition.
func (drrac DeliveryRuleRemoteAddressCondition) AsDeliveryRuleSocketAddrCondition() (*DeliveryRuleSocketAddrCondition, bool) {
	return nil, false
}

// AsDeliveryRuleIsDeviceCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRemoteAddressCondition.
func (drrac DeliveryRuleRemoteAddressCondition) AsDeliveryRuleIsDeviceCondition() (*DeliveryRuleIsDeviceCondition, bool) {
	return nil, false
}

// AsDeliveryRuleCookiesCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRemoteAddressCondition.
func (drrac DeliveryRuleRemoteAddressCondition) AsDeliveryRuleCookiesCondition() (*DeliveryRuleCookiesCondition, bool) {
	return nil, false
}

// AsDeliveryRuleHTTPVersionCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRemoteAddressCondition.
func (drrac DeliveryRuleRemoteAddressCondition) AsDeliveryRuleHTTPVersionCondition() (*DeliveryRuleHTTPVersionCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileNameCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRemoteAddressCondition.
func (drrac DeliveryRuleRemoteAddressCondition) AsDeliveryRuleURLFileNameCondition() (*DeliveryRuleURLFileNameCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileExtensionCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRemoteAddressCondition.
func (drrac DeliveryRuleRemoteAddressCondition) AsDeliveryRuleURLFileExtensionCondition() (*DeliveryRuleURLFileExtensionCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLPathCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRemoteAddressCondition.
func (drrac DeliveryRuleRemoteAddressCondition) AsDeliveryRuleURLPathCondition() (*DeliveryRuleURLPathCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestSchemeCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRemoteAddressCondition.
func (drrac DeliveryRuleRemoteAddressCondition) AsDeliveryRuleRequestSchemeCondition() (*DeliveryRuleRequestSchemeCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestBodyCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRemoteAddressCondition.
func (drrac DeliveryRuleRemoteAddressCondition) AsDeliveryRuleRequestBodyCondition() (*DeliveryRuleRequestBodyCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestHeaderCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRemoteAddressCondition.
func (drrac DeliveryRuleRemoteAddressCondition) AsDeliveryRuleRequestHeaderCondition() (*DeliveryRuleRequestHeaderCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestURICondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRemoteAddressCondition.
func (drrac DeliveryRuleRemoteAddressCondition) AsDeliveryRuleRequestURICondition() (*DeliveryRuleRequestURICondition, bool) {
	return nil, false
}

// AsDeliveryRulePostArgsCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRemoteAddressCondition.
func (drrac DeliveryRuleRemoteAddressCondition) AsDeliveryRulePostArgsCondition() (*DeliveryRulePostArgsCondition, bool) {
	return nil, false
}

// AsDeliveryRuleQueryStringCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRemoteAddressCondition.
func (drrac DeliveryRuleRemoteAddressCondition) AsDeliveryRuleQueryStringCondition() (*DeliveryRuleQueryStringCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestMethodCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRemoteAddressCondition.
func (drrac DeliveryRuleRemoteAddressCondition) AsDeliveryRuleRequestMethodCondition() (*DeliveryRuleRequestMethodCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRemoteAddressCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRemoteAddressCondition.
func (drrac DeliveryRuleRemoteAddressCondition) AsDeliveryRuleRemoteAddressCondition() (*DeliveryRuleRemoteAddressCondition, bool) {
	return &drrac, true
}

// AsDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRemoteAddressCondition.
func (drrac DeliveryRuleRemoteAddressCondition) AsDeliveryRuleCondition() (*DeliveryRuleCondition, bool) {
	return nil, false
}

// AsBasicDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRemoteAddressCondition.
func (drrac DeliveryRuleRemoteAddressCondition) AsBasicDeliveryRuleCondition() (BasicDeliveryRuleCondition, bool) {
	return &drrac, true
}

// DeliveryRuleRequestBodyCondition defines the RequestBody condition for the delivery rule.
type DeliveryRuleRequestBodyCondition struct {
	// Parameters - Defines the parameters for the condition.
	Parameters *RequestBodyMatchConditionParameters `json:"parameters,omitempty"`
	// Name - Possible values include: 'NameDeliveryRuleCondition', 'NameSslProtocol', 'NameHostName', 'NameServerPort', 'NameClientPort', 'NameSocketAddr', 'NameIsDevice', 'NameCookies', 'NameHTTPVersion', 'NameURLFileName', 'NameURLFileExtension', 'NameURLPath', 'NameRequestScheme', 'NameRequestBody', 'NameRequestHeader', 'NameRequestURI', 'NamePostArgs', 'NameQueryString', 'NameRequestMethod', 'NameRemoteAddress'
	Name Name `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for DeliveryRuleRequestBodyCondition.
func (drrbc DeliveryRuleRequestBodyCondition) MarshalJSON() ([]byte, error) {
	drrbc.Name = NameRequestBody
	objectMap := make(map[string]interface{})
	if drrbc.Parameters != nil {
		objectMap["parameters"] = drrbc.Parameters
	}
	if drrbc.Name != "" {
		objectMap["name"] = drrbc.Name
	}
	return json.Marshal(objectMap)
}

// AsDeliveryRuleSslProtocolCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestBodyCondition.
func (drrbc DeliveryRuleRequestBodyCondition) AsDeliveryRuleSslProtocolCondition() (*DeliveryRuleSslProtocolCondition, bool) {
	return nil, false
}

// AsDeliveryRuleHostNameCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestBodyCondition.
func (drrbc DeliveryRuleRequestBodyCondition) AsDeliveryRuleHostNameCondition() (*DeliveryRuleHostNameCondition, bool) {
	return nil, false
}

// AsDeliveryRuleServerPortCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestBodyCondition.
func (drrbc DeliveryRuleRequestBodyCondition) AsDeliveryRuleServerPortCondition() (*DeliveryRuleServerPortCondition, bool) {
	return nil, false
}

// AsDeliveryRuleClientPortCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestBodyCondition.
func (drrbc DeliveryRuleRequestBodyCondition) AsDeliveryRuleClientPortCondition() (*DeliveryRuleClientPortCondition, bool) {
	return nil, false
}

// AsDeliveryRuleSocketAddrCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestBodyCondition.
func (drrbc DeliveryRuleRequestBodyCondition) AsDeliveryRuleSocketAddrCondition() (*DeliveryRuleSocketAddrCondition, bool) {
	return nil, false
}

// AsDeliveryRuleIsDeviceCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestBodyCondition.
func (drrbc DeliveryRuleRequestBodyCondition) AsDeliveryRuleIsDeviceCondition() (*DeliveryRuleIsDeviceCondition, bool) {
	return nil, false
}

// AsDeliveryRuleCookiesCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestBodyCondition.
func (drrbc DeliveryRuleRequestBodyCondition) AsDeliveryRuleCookiesCondition() (*DeliveryRuleCookiesCondition, bool) {
	return nil, false
}

// AsDeliveryRuleHTTPVersionCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestBodyCondition.
func (drrbc DeliveryRuleRequestBodyCondition) AsDeliveryRuleHTTPVersionCondition() (*DeliveryRuleHTTPVersionCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileNameCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestBodyCondition.
func (drrbc DeliveryRuleRequestBodyCondition) AsDeliveryRuleURLFileNameCondition() (*DeliveryRuleURLFileNameCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileExtensionCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestBodyCondition.
func (drrbc DeliveryRuleRequestBodyCondition) AsDeliveryRuleURLFileExtensionCondition() (*DeliveryRuleURLFileExtensionCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLPathCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestBodyCondition.
func (drrbc DeliveryRuleRequestBodyCondition) AsDeliveryRuleURLPathCondition() (*DeliveryRuleURLPathCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestSchemeCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestBodyCondition.
func (drrbc DeliveryRuleRequestBodyCondition) AsDeliveryRuleRequestSchemeCondition() (*DeliveryRuleRequestSchemeCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestBodyCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestBodyCondition.
func (drrbc DeliveryRuleRequestBodyCondition) AsDeliveryRuleRequestBodyCondition() (*DeliveryRuleRequestBodyCondition, bool) {
	return &drrbc, true
}

// AsDeliveryRuleRequestHeaderCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestBodyCondition.
func (drrbc DeliveryRuleRequestBodyCondition) AsDeliveryRuleRequestHeaderCondition() (*DeliveryRuleRequestHeaderCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestURICondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestBodyCondition.
func (drrbc DeliveryRuleRequestBodyCondition) AsDeliveryRuleRequestURICondition() (*DeliveryRuleRequestURICondition, bool) {
	return nil, false
}

// AsDeliveryRulePostArgsCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestBodyCondition.
func (drrbc DeliveryRuleRequestBodyCondition) AsDeliveryRulePostArgsCondition() (*DeliveryRulePostArgsCondition, bool) {
	return nil, false
}

// AsDeliveryRuleQueryStringCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestBodyCondition.
func (drrbc DeliveryRuleRequestBodyCondition) AsDeliveryRuleQueryStringCondition() (*DeliveryRuleQueryStringCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestMethodCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestBodyCondition.
func (drrbc DeliveryRuleRequestBodyCondition) AsDeliveryRuleRequestMethodCondition() (*DeliveryRuleRequestMethodCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRemoteAddressCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestBodyCondition.
func (drrbc DeliveryRuleRequestBodyCondition) AsDeliveryRuleRemoteAddressCondition() (*DeliveryRuleRemoteAddressCondition, bool) {
	return nil, false
}

// AsDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestBodyCondition.
func (drrbc DeliveryRuleRequestBodyCondition) AsDeliveryRuleCondition() (*DeliveryRuleCondition, bool) {
	return nil, false
}

// AsBasicDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestBodyCondition.
func (drrbc DeliveryRuleRequestBodyCondition) AsBasicDeliveryRuleCondition() (BasicDeliveryRuleCondition, bool) {
	return &drrbc, true
}

// DeliveryRuleRequestHeaderAction defines the request header action for the delivery rule.
type DeliveryRuleRequestHeaderAction struct {
	// Parameters - Defines the parameters for the action.
	Parameters *HeaderActionParameters `json:"parameters,omitempty"`
	// Name - Possible values include: 'NameBasicDeliveryRuleActionNameDeliveryRuleAction', 'NameBasicDeliveryRuleActionNameRouteConfigurationOverride', 'NameBasicDeliveryRuleActionNameCacheKeyQueryString', 'NameBasicDeliveryRuleActionNameCacheExpiration', 'NameBasicDeliveryRuleActionNameModifyResponseHeader', 'NameBasicDeliveryRuleActionNameModifyRequestHeader', 'NameBasicDeliveryRuleActionNameURLRewrite', 'NameBasicDeliveryRuleActionNameOriginGroupOverride', 'NameBasicDeliveryRuleActionNameURLSigning', 'NameBasicDeliveryRuleActionNameURLRedirect'
	Name NameBasicDeliveryRuleAction `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for DeliveryRuleRequestHeaderAction.
func (drrha DeliveryRuleRequestHeaderAction) MarshalJSON() ([]byte, error) {
	drrha.Name = NameBasicDeliveryRuleActionNameModifyRequestHeader
	objectMap := make(map[string]interface{})
	if drrha.Parameters != nil {
		objectMap["parameters"] = drrha.Parameters
	}
	if drrha.Name != "" {
		objectMap["name"] = drrha.Name
	}
	return json.Marshal(objectMap)
}

// AsDeliveryRuleRouteConfigurationOverrideAction is the BasicDeliveryRuleAction implementation for DeliveryRuleRequestHeaderAction.
func (drrha DeliveryRuleRequestHeaderAction) AsDeliveryRuleRouteConfigurationOverrideAction() (*DeliveryRuleRouteConfigurationOverrideAction, bool) {
	return nil, false
}

// AsDeliveryRuleCacheKeyQueryStringAction is the BasicDeliveryRuleAction implementation for DeliveryRuleRequestHeaderAction.
func (drrha DeliveryRuleRequestHeaderAction) AsDeliveryRuleCacheKeyQueryStringAction() (*DeliveryRuleCacheKeyQueryStringAction, bool) {
	return nil, false
}

// AsDeliveryRuleCacheExpirationAction is the BasicDeliveryRuleAction implementation for DeliveryRuleRequestHeaderAction.
func (drrha DeliveryRuleRequestHeaderAction) AsDeliveryRuleCacheExpirationAction() (*DeliveryRuleCacheExpirationAction, bool) {
	return nil, false
}

// AsDeliveryRuleResponseHeaderAction is the BasicDeliveryRuleAction implementation for DeliveryRuleRequestHeaderAction.
func (drrha DeliveryRuleRequestHeaderAction) AsDeliveryRuleResponseHeaderAction() (*DeliveryRuleResponseHeaderAction, bool) {
	return nil, false
}

// AsDeliveryRuleRequestHeaderAction is the BasicDeliveryRuleAction implementation for DeliveryRuleRequestHeaderAction.
func (drrha DeliveryRuleRequestHeaderAction) AsDeliveryRuleRequestHeaderAction() (*DeliveryRuleRequestHeaderAction, bool) {
	return &drrha, true
}

// AsURLRewriteAction is the BasicDeliveryRuleAction implementation for DeliveryRuleRequestHeaderAction.
func (drrha DeliveryRuleRequestHeaderAction) AsURLRewriteAction() (*URLRewriteAction, bool) {
	return nil, false
}

// AsOriginGroupOverrideAction is the BasicDeliveryRuleAction implementation for DeliveryRuleRequestHeaderAction.
func (drrha DeliveryRuleRequestHeaderAction) AsOriginGroupOverrideAction() (*OriginGroupOverrideAction, bool) {
	return nil, false
}

// AsURLSigningAction is the BasicDeliveryRuleAction implementation for DeliveryRuleRequestHeaderAction.
func (drrha DeliveryRuleRequestHeaderAction) AsURLSigningAction() (*URLSigningAction, bool) {
	return nil, false
}

// AsURLRedirectAction is the BasicDeliveryRuleAction implementation for DeliveryRuleRequestHeaderAction.
func (drrha DeliveryRuleRequestHeaderAction) AsURLRedirectAction() (*URLRedirectAction, bool) {
	return nil, false
}

// AsDeliveryRuleAction is the BasicDeliveryRuleAction implementation for DeliveryRuleRequestHeaderAction.
func (drrha DeliveryRuleRequestHeaderAction) AsDeliveryRuleAction() (*DeliveryRuleAction, bool) {
	return nil, false
}

// AsBasicDeliveryRuleAction is the BasicDeliveryRuleAction implementation for DeliveryRuleRequestHeaderAction.
func (drrha DeliveryRuleRequestHeaderAction) AsBasicDeliveryRuleAction() (BasicDeliveryRuleAction, bool) {
	return &drrha, true
}

// DeliveryRuleRequestHeaderCondition defines the RequestHeader condition for the delivery rule.
type DeliveryRuleRequestHeaderCondition struct {
	// Parameters - Defines the parameters for the condition.
	Parameters *RequestHeaderMatchConditionParameters `json:"parameters,omitempty"`
	// Name - Possible values include: 'NameDeliveryRuleCondition', 'NameSslProtocol', 'NameHostName', 'NameServerPort', 'NameClientPort', 'NameSocketAddr', 'NameIsDevice', 'NameCookies', 'NameHTTPVersion', 'NameURLFileName', 'NameURLFileExtension', 'NameURLPath', 'NameRequestScheme', 'NameRequestBody', 'NameRequestHeader', 'NameRequestURI', 'NamePostArgs', 'NameQueryString', 'NameRequestMethod', 'NameRemoteAddress'
	Name Name `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for DeliveryRuleRequestHeaderCondition.
func (drrhc DeliveryRuleRequestHeaderCondition) MarshalJSON() ([]byte, error) {
	drrhc.Name = NameRequestHeader
	objectMap := make(map[string]interface{})
	if drrhc.Parameters != nil {
		objectMap["parameters"] = drrhc.Parameters
	}
	if drrhc.Name != "" {
		objectMap["name"] = drrhc.Name
	}
	return json.Marshal(objectMap)
}

// AsDeliveryRuleSslProtocolCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestHeaderCondition.
func (drrhc DeliveryRuleRequestHeaderCondition) AsDeliveryRuleSslProtocolCondition() (*DeliveryRuleSslProtocolCondition, bool) {
	return nil, false
}

// AsDeliveryRuleHostNameCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestHeaderCondition.
func (drrhc DeliveryRuleRequestHeaderCondition) AsDeliveryRuleHostNameCondition() (*DeliveryRuleHostNameCondition, bool) {
	return nil, false
}

// AsDeliveryRuleServerPortCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestHeaderCondition.
func (drrhc DeliveryRuleRequestHeaderCondition) AsDeliveryRuleServerPortCondition() (*DeliveryRuleServerPortCondition, bool) {
	return nil, false
}

// AsDeliveryRuleClientPortCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestHeaderCondition.
func (drrhc DeliveryRuleRequestHeaderCondition) AsDeliveryRuleClientPortCondition() (*DeliveryRuleClientPortCondition, bool) {
	return nil, false
}

// AsDeliveryRuleSocketAddrCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestHeaderCondition.
func (drrhc DeliveryRuleRequestHeaderCondition) AsDeliveryRuleSocketAddrCondition() (*DeliveryRuleSocketAddrCondition, bool) {
	return nil, false
}

// AsDeliveryRuleIsDeviceCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestHeaderCondition.
func (drrhc DeliveryRuleRequestHeaderCondition) AsDeliveryRuleIsDeviceCondition() (*DeliveryRuleIsDeviceCondition, bool) {
	return nil, false
}

// AsDeliveryRuleCookiesCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestHeaderCondition.
func (drrhc DeliveryRuleRequestHeaderCondition) AsDeliveryRuleCookiesCondition() (*DeliveryRuleCookiesCondition, bool) {
	return nil, false
}

// AsDeliveryRuleHTTPVersionCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestHeaderCondition.
func (drrhc DeliveryRuleRequestHeaderCondition) AsDeliveryRuleHTTPVersionCondition() (*DeliveryRuleHTTPVersionCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileNameCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestHeaderCondition.
func (drrhc DeliveryRuleRequestHeaderCondition) AsDeliveryRuleURLFileNameCondition() (*DeliveryRuleURLFileNameCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileExtensionCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestHeaderCondition.
func (drrhc DeliveryRuleRequestHeaderCondition) AsDeliveryRuleURLFileExtensionCondition() (*DeliveryRuleURLFileExtensionCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLPathCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestHeaderCondition.
func (drrhc DeliveryRuleRequestHeaderCondition) AsDeliveryRuleURLPathCondition() (*DeliveryRuleURLPathCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestSchemeCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestHeaderCondition.
func (drrhc DeliveryRuleRequestHeaderCondition) AsDeliveryRuleRequestSchemeCondition() (*DeliveryRuleRequestSchemeCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestBodyCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestHeaderCondition.
func (drrhc DeliveryRuleRequestHeaderCondition) AsDeliveryRuleRequestBodyCondition() (*DeliveryRuleRequestBodyCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestHeaderCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestHeaderCondition.
func (drrhc DeliveryRuleRequestHeaderCondition) AsDeliveryRuleRequestHeaderCondition() (*DeliveryRuleRequestHeaderCondition, bool) {
	return &drrhc, true
}

// AsDeliveryRuleRequestURICondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestHeaderCondition.
func (drrhc DeliveryRuleRequestHeaderCondition) AsDeliveryRuleRequestURICondition() (*DeliveryRuleRequestURICondition, bool) {
	return nil, false
}

// AsDeliveryRulePostArgsCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestHeaderCondition.
func (drrhc DeliveryRuleRequestHeaderCondition) AsDeliveryRulePostArgsCondition() (*DeliveryRulePostArgsCondition, bool) {
	return nil, false
}

// AsDeliveryRuleQueryStringCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestHeaderCondition.
func (drrhc DeliveryRuleRequestHeaderCondition) AsDeliveryRuleQueryStringCondition() (*DeliveryRuleQueryStringCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestMethodCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestHeaderCondition.
func (drrhc DeliveryRuleRequestHeaderCondition) AsDeliveryRuleRequestMethodCondition() (*DeliveryRuleRequestMethodCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRemoteAddressCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestHeaderCondition.
func (drrhc DeliveryRuleRequestHeaderCondition) AsDeliveryRuleRemoteAddressCondition() (*DeliveryRuleRemoteAddressCondition, bool) {
	return nil, false
}

// AsDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestHeaderCondition.
func (drrhc DeliveryRuleRequestHeaderCondition) AsDeliveryRuleCondition() (*DeliveryRuleCondition, bool) {
	return nil, false
}

// AsBasicDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestHeaderCondition.
func (drrhc DeliveryRuleRequestHeaderCondition) AsBasicDeliveryRuleCondition() (BasicDeliveryRuleCondition, bool) {
	return &drrhc, true
}

// DeliveryRuleRequestMethodCondition defines the RequestMethod condition for the delivery rule.
type DeliveryRuleRequestMethodCondition struct {
	// Parameters - Defines the parameters for the condition.
	Parameters *RequestMethodMatchConditionParameters `json:"parameters,omitempty"`
	// Name - Possible values include: 'NameDeliveryRuleCondition', 'NameSslProtocol', 'NameHostName', 'NameServerPort', 'NameClientPort', 'NameSocketAddr', 'NameIsDevice', 'NameCookies', 'NameHTTPVersion', 'NameURLFileName', 'NameURLFileExtension', 'NameURLPath', 'NameRequestScheme', 'NameRequestBody', 'NameRequestHeader', 'NameRequestURI', 'NamePostArgs', 'NameQueryString', 'NameRequestMethod', 'NameRemoteAddress'
	Name Name `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for DeliveryRuleRequestMethodCondition.
func (drrmc DeliveryRuleRequestMethodCondition) MarshalJSON() ([]byte, error) {
	drrmc.Name = NameRequestMethod
	objectMap := make(map[string]interface{})
	if drrmc.Parameters != nil {
		objectMap["parameters"] = drrmc.Parameters
	}
	if drrmc.Name != "" {
		objectMap["name"] = drrmc.Name
	}
	return json.Marshal(objectMap)
}

// AsDeliveryRuleSslProtocolCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestMethodCondition.
func (drrmc DeliveryRuleRequestMethodCondition) AsDeliveryRuleSslProtocolCondition() (*DeliveryRuleSslProtocolCondition, bool) {
	return nil, false
}

// AsDeliveryRuleHostNameCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestMethodCondition.
func (drrmc DeliveryRuleRequestMethodCondition) AsDeliveryRuleHostNameCondition() (*DeliveryRuleHostNameCondition, bool) {
	return nil, false
}

// AsDeliveryRuleServerPortCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestMethodCondition.
func (drrmc DeliveryRuleRequestMethodCondition) AsDeliveryRuleServerPortCondition() (*DeliveryRuleServerPortCondition, bool) {
	return nil, false
}

// AsDeliveryRuleClientPortCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestMethodCondition.
func (drrmc DeliveryRuleRequestMethodCondition) AsDeliveryRuleClientPortCondition() (*DeliveryRuleClientPortCondition, bool) {
	return nil, false
}

// AsDeliveryRuleSocketAddrCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestMethodCondition.
func (drrmc DeliveryRuleRequestMethodCondition) AsDeliveryRuleSocketAddrCondition() (*DeliveryRuleSocketAddrCondition, bool) {
	return nil, false
}

// AsDeliveryRuleIsDeviceCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestMethodCondition.
func (drrmc DeliveryRuleRequestMethodCondition) AsDeliveryRuleIsDeviceCondition() (*DeliveryRuleIsDeviceCondition, bool) {
	return nil, false
}

// AsDeliveryRuleCookiesCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestMethodCondition.
func (drrmc DeliveryRuleRequestMethodCondition) AsDeliveryRuleCookiesCondition() (*DeliveryRuleCookiesCondition, bool) {
	return nil, false
}

// AsDeliveryRuleHTTPVersionCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestMethodCondition.
func (drrmc DeliveryRuleRequestMethodCondition) AsDeliveryRuleHTTPVersionCondition() (*DeliveryRuleHTTPVersionCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileNameCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestMethodCondition.
func (drrmc DeliveryRuleRequestMethodCondition) AsDeliveryRuleURLFileNameCondition() (*DeliveryRuleURLFileNameCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileExtensionCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestMethodCondition.
func (drrmc DeliveryRuleRequestMethodCondition) AsDeliveryRuleURLFileExtensionCondition() (*DeliveryRuleURLFileExtensionCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLPathCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestMethodCondition.
func (drrmc DeliveryRuleRequestMethodCondition) AsDeliveryRuleURLPathCondition() (*DeliveryRuleURLPathCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestSchemeCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestMethodCondition.
func (drrmc DeliveryRuleRequestMethodCondition) AsDeliveryRuleRequestSchemeCondition() (*DeliveryRuleRequestSchemeCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestBodyCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestMethodCondition.
func (drrmc DeliveryRuleRequestMethodCondition) AsDeliveryRuleRequestBodyCondition() (*DeliveryRuleRequestBodyCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestHeaderCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestMethodCondition.
func (drrmc DeliveryRuleRequestMethodCondition) AsDeliveryRuleRequestHeaderCondition() (*DeliveryRuleRequestHeaderCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestURICondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestMethodCondition.
func (drrmc DeliveryRuleRequestMethodCondition) AsDeliveryRuleRequestURICondition() (*DeliveryRuleRequestURICondition, bool) {
	return nil, false
}

// AsDeliveryRulePostArgsCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestMethodCondition.
func (drrmc DeliveryRuleRequestMethodCondition) AsDeliveryRulePostArgsCondition() (*DeliveryRulePostArgsCondition, bool) {
	return nil, false
}

// AsDeliveryRuleQueryStringCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestMethodCondition.
func (drrmc DeliveryRuleRequestMethodCondition) AsDeliveryRuleQueryStringCondition() (*DeliveryRuleQueryStringCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestMethodCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestMethodCondition.
func (drrmc DeliveryRuleRequestMethodCondition) AsDeliveryRuleRequestMethodCondition() (*DeliveryRuleRequestMethodCondition, bool) {
	return &drrmc, true
}

// AsDeliveryRuleRemoteAddressCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestMethodCondition.
func (drrmc DeliveryRuleRequestMethodCondition) AsDeliveryRuleRemoteAddressCondition() (*DeliveryRuleRemoteAddressCondition, bool) {
	return nil, false
}

// AsDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestMethodCondition.
func (drrmc DeliveryRuleRequestMethodCondition) AsDeliveryRuleCondition() (*DeliveryRuleCondition, bool) {
	return nil, false
}

// AsBasicDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestMethodCondition.
func (drrmc DeliveryRuleRequestMethodCondition) AsBasicDeliveryRuleCondition() (BasicDeliveryRuleCondition, bool) {
	return &drrmc, true
}

// DeliveryRuleRequestSchemeCondition defines the RequestScheme condition for the delivery rule.
type DeliveryRuleRequestSchemeCondition struct {
	// Parameters - Defines the parameters for the condition.
	Parameters *RequestSchemeMatchConditionParameters `json:"parameters,omitempty"`
	// Name - Possible values include: 'NameDeliveryRuleCondition', 'NameSslProtocol', 'NameHostName', 'NameServerPort', 'NameClientPort', 'NameSocketAddr', 'NameIsDevice', 'NameCookies', 'NameHTTPVersion', 'NameURLFileName', 'NameURLFileExtension', 'NameURLPath', 'NameRequestScheme', 'NameRequestBody', 'NameRequestHeader', 'NameRequestURI', 'NamePostArgs', 'NameQueryString', 'NameRequestMethod', 'NameRemoteAddress'
	Name Name `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for DeliveryRuleRequestSchemeCondition.
func (drrsc DeliveryRuleRequestSchemeCondition) MarshalJSON() ([]byte, error) {
	drrsc.Name = NameRequestScheme
	objectMap := make(map[string]interface{})
	if drrsc.Parameters != nil {
		objectMap["parameters"] = drrsc.Parameters
	}
	if drrsc.Name != "" {
		objectMap["name"] = drrsc.Name
	}
	return json.Marshal(objectMap)
}

// AsDeliveryRuleSslProtocolCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestSchemeCondition.
func (drrsc DeliveryRuleRequestSchemeCondition) AsDeliveryRuleSslProtocolCondition() (*DeliveryRuleSslProtocolCondition, bool) {
	return nil, false
}

// AsDeliveryRuleHostNameCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestSchemeCondition.
func (drrsc DeliveryRuleRequestSchemeCondition) AsDeliveryRuleHostNameCondition() (*DeliveryRuleHostNameCondition, bool) {
	return nil, false
}

// AsDeliveryRuleServerPortCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestSchemeCondition.
func (drrsc DeliveryRuleRequestSchemeCondition) AsDeliveryRuleServerPortCondition() (*DeliveryRuleServerPortCondition, bool) {
	return nil, false
}

// AsDeliveryRuleClientPortCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestSchemeCondition.
func (drrsc DeliveryRuleRequestSchemeCondition) AsDeliveryRuleClientPortCondition() (*DeliveryRuleClientPortCondition, bool) {
	return nil, false
}

// AsDeliveryRuleSocketAddrCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestSchemeCondition.
func (drrsc DeliveryRuleRequestSchemeCondition) AsDeliveryRuleSocketAddrCondition() (*DeliveryRuleSocketAddrCondition, bool) {
	return nil, false
}

// AsDeliveryRuleIsDeviceCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestSchemeCondition.
func (drrsc DeliveryRuleRequestSchemeCondition) AsDeliveryRuleIsDeviceCondition() (*DeliveryRuleIsDeviceCondition, bool) {
	return nil, false
}

// AsDeliveryRuleCookiesCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestSchemeCondition.
func (drrsc DeliveryRuleRequestSchemeCondition) AsDeliveryRuleCookiesCondition() (*DeliveryRuleCookiesCondition, bool) {
	return nil, false
}

// AsDeliveryRuleHTTPVersionCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestSchemeCondition.
func (drrsc DeliveryRuleRequestSchemeCondition) AsDeliveryRuleHTTPVersionCondition() (*DeliveryRuleHTTPVersionCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileNameCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestSchemeCondition.
func (drrsc DeliveryRuleRequestSchemeCondition) AsDeliveryRuleURLFileNameCondition() (*DeliveryRuleURLFileNameCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileExtensionCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestSchemeCondition.
func (drrsc DeliveryRuleRequestSchemeCondition) AsDeliveryRuleURLFileExtensionCondition() (*DeliveryRuleURLFileExtensionCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLPathCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestSchemeCondition.
func (drrsc DeliveryRuleRequestSchemeCondition) AsDeliveryRuleURLPathCondition() (*DeliveryRuleURLPathCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestSchemeCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestSchemeCondition.
func (drrsc DeliveryRuleRequestSchemeCondition) AsDeliveryRuleRequestSchemeCondition() (*DeliveryRuleRequestSchemeCondition, bool) {
	return &drrsc, true
}

// AsDeliveryRuleRequestBodyCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestSchemeCondition.
func (drrsc DeliveryRuleRequestSchemeCondition) AsDeliveryRuleRequestBodyCondition() (*DeliveryRuleRequestBodyCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestHeaderCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestSchemeCondition.
func (drrsc DeliveryRuleRequestSchemeCondition) AsDeliveryRuleRequestHeaderCondition() (*DeliveryRuleRequestHeaderCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestURICondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestSchemeCondition.
func (drrsc DeliveryRuleRequestSchemeCondition) AsDeliveryRuleRequestURICondition() (*DeliveryRuleRequestURICondition, bool) {
	return nil, false
}

// AsDeliveryRulePostArgsCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestSchemeCondition.
func (drrsc DeliveryRuleRequestSchemeCondition) AsDeliveryRulePostArgsCondition() (*DeliveryRulePostArgsCondition, bool) {
	return nil, false
}

// AsDeliveryRuleQueryStringCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestSchemeCondition.
func (drrsc DeliveryRuleRequestSchemeCondition) AsDeliveryRuleQueryStringCondition() (*DeliveryRuleQueryStringCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestMethodCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestSchemeCondition.
func (drrsc DeliveryRuleRequestSchemeCondition) AsDeliveryRuleRequestMethodCondition() (*DeliveryRuleRequestMethodCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRemoteAddressCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestSchemeCondition.
func (drrsc DeliveryRuleRequestSchemeCondition) AsDeliveryRuleRemoteAddressCondition() (*DeliveryRuleRemoteAddressCondition, bool) {
	return nil, false
}

// AsDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestSchemeCondition.
func (drrsc DeliveryRuleRequestSchemeCondition) AsDeliveryRuleCondition() (*DeliveryRuleCondition, bool) {
	return nil, false
}

// AsBasicDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestSchemeCondition.
func (drrsc DeliveryRuleRequestSchemeCondition) AsBasicDeliveryRuleCondition() (BasicDeliveryRuleCondition, bool) {
	return &drrsc, true
}

// DeliveryRuleRequestURICondition defines the RequestUri condition for the delivery rule.
type DeliveryRuleRequestURICondition struct {
	// Parameters - Defines the parameters for the condition.
	Parameters *RequestURIMatchConditionParameters `json:"parameters,omitempty"`
	// Name - Possible values include: 'NameDeliveryRuleCondition', 'NameSslProtocol', 'NameHostName', 'NameServerPort', 'NameClientPort', 'NameSocketAddr', 'NameIsDevice', 'NameCookies', 'NameHTTPVersion', 'NameURLFileName', 'NameURLFileExtension', 'NameURLPath', 'NameRequestScheme', 'NameRequestBody', 'NameRequestHeader', 'NameRequestURI', 'NamePostArgs', 'NameQueryString', 'NameRequestMethod', 'NameRemoteAddress'
	Name Name `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for DeliveryRuleRequestURICondition.
func (drruc DeliveryRuleRequestURICondition) MarshalJSON() ([]byte, error) {
	drruc.Name = NameRequestURI
	objectMap := make(map[string]interface{})
	if drruc.Parameters != nil {
		objectMap["parameters"] = drruc.Parameters
	}
	if drruc.Name != "" {
		objectMap["name"] = drruc.Name
	}
	return json.Marshal(objectMap)
}

// AsDeliveryRuleSslProtocolCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestURICondition.
func (drruc DeliveryRuleRequestURICondition) AsDeliveryRuleSslProtocolCondition() (*DeliveryRuleSslProtocolCondition, bool) {
	return nil, false
}

// AsDeliveryRuleHostNameCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestURICondition.
func (drruc DeliveryRuleRequestURICondition) AsDeliveryRuleHostNameCondition() (*DeliveryRuleHostNameCondition, bool) {
	return nil, false
}

// AsDeliveryRuleServerPortCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestURICondition.
func (drruc DeliveryRuleRequestURICondition) AsDeliveryRuleServerPortCondition() (*DeliveryRuleServerPortCondition, bool) {
	return nil, false
}

// AsDeliveryRuleClientPortCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestURICondition.
func (drruc DeliveryRuleRequestURICondition) AsDeliveryRuleClientPortCondition() (*DeliveryRuleClientPortCondition, bool) {
	return nil, false
}

// AsDeliveryRuleSocketAddrCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestURICondition.
func (drruc DeliveryRuleRequestURICondition) AsDeliveryRuleSocketAddrCondition() (*DeliveryRuleSocketAddrCondition, bool) {
	return nil, false
}

// AsDeliveryRuleIsDeviceCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestURICondition.
func (drruc DeliveryRuleRequestURICondition) AsDeliveryRuleIsDeviceCondition() (*DeliveryRuleIsDeviceCondition, bool) {
	return nil, false
}

// AsDeliveryRuleCookiesCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestURICondition.
func (drruc DeliveryRuleRequestURICondition) AsDeliveryRuleCookiesCondition() (*DeliveryRuleCookiesCondition, bool) {
	return nil, false
}

// AsDeliveryRuleHTTPVersionCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestURICondition.
func (drruc DeliveryRuleRequestURICondition) AsDeliveryRuleHTTPVersionCondition() (*DeliveryRuleHTTPVersionCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileNameCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestURICondition.
func (drruc DeliveryRuleRequestURICondition) AsDeliveryRuleURLFileNameCondition() (*DeliveryRuleURLFileNameCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileExtensionCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestURICondition.
func (drruc DeliveryRuleRequestURICondition) AsDeliveryRuleURLFileExtensionCondition() (*DeliveryRuleURLFileExtensionCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLPathCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestURICondition.
func (drruc DeliveryRuleRequestURICondition) AsDeliveryRuleURLPathCondition() (*DeliveryRuleURLPathCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestSchemeCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestURICondition.
func (drruc DeliveryRuleRequestURICondition) AsDeliveryRuleRequestSchemeCondition() (*DeliveryRuleRequestSchemeCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestBodyCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestURICondition.
func (drruc DeliveryRuleRequestURICondition) AsDeliveryRuleRequestBodyCondition() (*DeliveryRuleRequestBodyCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestHeaderCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestURICondition.
func (drruc DeliveryRuleRequestURICondition) AsDeliveryRuleRequestHeaderCondition() (*DeliveryRuleRequestHeaderCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestURICondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestURICondition.
func (drruc DeliveryRuleRequestURICondition) AsDeliveryRuleRequestURICondition() (*DeliveryRuleRequestURICondition, bool) {
	return &drruc, true
}

// AsDeliveryRulePostArgsCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestURICondition.
func (drruc DeliveryRuleRequestURICondition) AsDeliveryRulePostArgsCondition() (*DeliveryRulePostArgsCondition, bool) {
	return nil, false
}

// AsDeliveryRuleQueryStringCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestURICondition.
func (drruc DeliveryRuleRequestURICondition) AsDeliveryRuleQueryStringCondition() (*DeliveryRuleQueryStringCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestMethodCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestURICondition.
func (drruc DeliveryRuleRequestURICondition) AsDeliveryRuleRequestMethodCondition() (*DeliveryRuleRequestMethodCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRemoteAddressCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestURICondition.
func (drruc DeliveryRuleRequestURICondition) AsDeliveryRuleRemoteAddressCondition() (*DeliveryRuleRemoteAddressCondition, bool) {
	return nil, false
}

// AsDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestURICondition.
func (drruc DeliveryRuleRequestURICondition) AsDeliveryRuleCondition() (*DeliveryRuleCondition, bool) {
	return nil, false
}

// AsBasicDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleRequestURICondition.
func (drruc DeliveryRuleRequestURICondition) AsBasicDeliveryRuleCondition() (BasicDeliveryRuleCondition, bool) {
	return &drruc, true
}

// DeliveryRuleResponseHeaderAction defines the response header action for the delivery rule.
type DeliveryRuleResponseHeaderAction struct {
	// Parameters - Defines the parameters for the action.
	Parameters *HeaderActionParameters `json:"parameters,omitempty"`
	// Name - Possible values include: 'NameBasicDeliveryRuleActionNameDeliveryRuleAction', 'NameBasicDeliveryRuleActionNameRouteConfigurationOverride', 'NameBasicDeliveryRuleActionNameCacheKeyQueryString', 'NameBasicDeliveryRuleActionNameCacheExpiration', 'NameBasicDeliveryRuleActionNameModifyResponseHeader', 'NameBasicDeliveryRuleActionNameModifyRequestHeader', 'NameBasicDeliveryRuleActionNameURLRewrite', 'NameBasicDeliveryRuleActionNameOriginGroupOverride', 'NameBasicDeliveryRuleActionNameURLSigning', 'NameBasicDeliveryRuleActionNameURLRedirect'
	Name NameBasicDeliveryRuleAction `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for DeliveryRuleResponseHeaderAction.
func (drrha DeliveryRuleResponseHeaderAction) MarshalJSON() ([]byte, error) {
	drrha.Name = NameBasicDeliveryRuleActionNameModifyResponseHeader
	objectMap := make(map[string]interface{})
	if drrha.Parameters != nil {
		objectMap["parameters"] = drrha.Parameters
	}
	if drrha.Name != "" {
		objectMap["name"] = drrha.Name
	}
	return json.Marshal(objectMap)
}

// AsDeliveryRuleRouteConfigurationOverrideAction is the BasicDeliveryRuleAction implementation for DeliveryRuleResponseHeaderAction.
func (drrha DeliveryRuleResponseHeaderAction) AsDeliveryRuleRouteConfigurationOverrideAction() (*DeliveryRuleRouteConfigurationOverrideAction, bool) {
	return nil, false
}

// AsDeliveryRuleCacheKeyQueryStringAction is the BasicDeliveryRuleAction implementation for DeliveryRuleResponseHeaderAction.
func (drrha DeliveryRuleResponseHeaderAction) AsDeliveryRuleCacheKeyQueryStringAction() (*DeliveryRuleCacheKeyQueryStringAction, bool) {
	return nil, false
}

// AsDeliveryRuleCacheExpirationAction is the BasicDeliveryRuleAction implementation for DeliveryRuleResponseHeaderAction.
func (drrha DeliveryRuleResponseHeaderAction) AsDeliveryRuleCacheExpirationAction() (*DeliveryRuleCacheExpirationAction, bool) {
	return nil, false
}

// AsDeliveryRuleResponseHeaderAction is the BasicDeliveryRuleAction implementation for DeliveryRuleResponseHeaderAction.
func (drrha DeliveryRuleResponseHeaderAction) AsDeliveryRuleResponseHeaderAction() (*DeliveryRuleResponseHeaderAction, bool) {
	return &drrha, true
}

// AsDeliveryRuleRequestHeaderAction is the BasicDeliveryRuleAction implementation for DeliveryRuleResponseHeaderAction.
func (drrha DeliveryRuleResponseHeaderAction) AsDeliveryRuleRequestHeaderAction() (*DeliveryRuleRequestHeaderAction, bool) {
	return nil, false
}

// AsURLRewriteAction is the BasicDeliveryRuleAction implementation for DeliveryRuleResponseHeaderAction.
func (drrha DeliveryRuleResponseHeaderAction) AsURLRewriteAction() (*URLRewriteAction, bool) {
	return nil, false
}

// AsOriginGroupOverrideAction is the BasicDeliveryRuleAction implementation for DeliveryRuleResponseHeaderAction.
func (drrha DeliveryRuleResponseHeaderAction) AsOriginGroupOverrideAction() (*OriginGroupOverrideAction, bool) {
	return nil, false
}

// AsURLSigningAction is the BasicDeliveryRuleAction implementation for DeliveryRuleResponseHeaderAction.
func (drrha DeliveryRuleResponseHeaderAction) AsURLSigningAction() (*URLSigningAction, bool) {
	return nil, false
}

// AsURLRedirectAction is the BasicDeliveryRuleAction implementation for DeliveryRuleResponseHeaderAction.
func (drrha DeliveryRuleResponseHeaderAction) AsURLRedirectAction() (*URLRedirectAction, bool) {
	return nil, false
}

// AsDeliveryRuleAction is the BasicDeliveryRuleAction implementation for DeliveryRuleResponseHeaderAction.
func (drrha DeliveryRuleResponseHeaderAction) AsDeliveryRuleAction() (*DeliveryRuleAction, bool) {
	return nil, false
}

// AsBasicDeliveryRuleAction is the BasicDeliveryRuleAction implementation for DeliveryRuleResponseHeaderAction.
func (drrha DeliveryRuleResponseHeaderAction) AsBasicDeliveryRuleAction() (BasicDeliveryRuleAction, bool) {
	return &drrha, true
}

// DeliveryRuleRouteConfigurationOverrideAction defines the route configuration override action for the
// delivery rule. Only applicable to Frontdoor Standard/Premium Profiles.
type DeliveryRuleRouteConfigurationOverrideAction struct {
	// Parameters - Defines the parameters for the action.
	Parameters *RouteConfigurationOverrideActionParameters `json:"parameters,omitempty"`
	// Name - Possible values include: 'NameBasicDeliveryRuleActionNameDeliveryRuleAction', 'NameBasicDeliveryRuleActionNameRouteConfigurationOverride', 'NameBasicDeliveryRuleActionNameCacheKeyQueryString', 'NameBasicDeliveryRuleActionNameCacheExpiration', 'NameBasicDeliveryRuleActionNameModifyResponseHeader', 'NameBasicDeliveryRuleActionNameModifyRequestHeader', 'NameBasicDeliveryRuleActionNameURLRewrite', 'NameBasicDeliveryRuleActionNameOriginGroupOverride', 'NameBasicDeliveryRuleActionNameURLSigning', 'NameBasicDeliveryRuleActionNameURLRedirect'
	Name NameBasicDeliveryRuleAction `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for DeliveryRuleRouteConfigurationOverrideAction.
func (drrcoa DeliveryRuleRouteConfigurationOverrideAction) MarshalJSON() ([]byte, error) {
	drrcoa.Name = NameBasicDeliveryRuleActionNameRouteConfigurationOverride
	objectMap := make(map[string]interface{})
	if drrcoa.Parameters != nil {
		objectMap["parameters"] = drrcoa.Parameters
	}
	if drrcoa.Name != "" {
		objectMap["name"] = drrcoa.Name
	}
	return json.Marshal(objectMap)
}

// AsDeliveryRuleRouteConfigurationOverrideAction is the BasicDeliveryRuleAction implementation for DeliveryRuleRouteConfigurationOverrideAction.
func (drrcoa DeliveryRuleRouteConfigurationOverrideAction) AsDeliveryRuleRouteConfigurationOverrideAction() (*DeliveryRuleRouteConfigurationOverrideAction, bool) {
	return &drrcoa, true
}

// AsDeliveryRuleCacheKeyQueryStringAction is the BasicDeliveryRuleAction implementation for DeliveryRuleRouteConfigurationOverrideAction.
func (drrcoa DeliveryRuleRouteConfigurationOverrideAction) AsDeliveryRuleCacheKeyQueryStringAction() (*DeliveryRuleCacheKeyQueryStringAction, bool) {
	return nil, false
}

// AsDeliveryRuleCacheExpirationAction is the BasicDeliveryRuleAction implementation for DeliveryRuleRouteConfigurationOverrideAction.
func (drrcoa DeliveryRuleRouteConfigurationOverrideAction) AsDeliveryRuleCacheExpirationAction() (*DeliveryRuleCacheExpirationAction, bool) {
	return nil, false
}

// AsDeliveryRuleResponseHeaderAction is the BasicDeliveryRuleAction implementation for DeliveryRuleRouteConfigurationOverrideAction.
func (drrcoa DeliveryRuleRouteConfigurationOverrideAction) AsDeliveryRuleResponseHeaderAction() (*DeliveryRuleResponseHeaderAction, bool) {
	return nil, false
}

// AsDeliveryRuleRequestHeaderAction is the BasicDeliveryRuleAction implementation for DeliveryRuleRouteConfigurationOverrideAction.
func (drrcoa DeliveryRuleRouteConfigurationOverrideAction) AsDeliveryRuleRequestHeaderAction() (*DeliveryRuleRequestHeaderAction, bool) {
	return nil, false
}

// AsURLRewriteAction is the BasicDeliveryRuleAction implementation for DeliveryRuleRouteConfigurationOverrideAction.
func (drrcoa DeliveryRuleRouteConfigurationOverrideAction) AsURLRewriteAction() (*URLRewriteAction, bool) {
	return nil, false
}

// AsOriginGroupOverrideAction is the BasicDeliveryRuleAction implementation for DeliveryRuleRouteConfigurationOverrideAction.
func (drrcoa DeliveryRuleRouteConfigurationOverrideAction) AsOriginGroupOverrideAction() (*OriginGroupOverrideAction, bool) {
	return nil, false
}

// AsURLSigningAction is the BasicDeliveryRuleAction implementation for DeliveryRuleRouteConfigurationOverrideAction.
func (drrcoa DeliveryRuleRouteConfigurationOverrideAction) AsURLSigningAction() (*URLSigningAction, bool) {
	return nil, false
}

// AsURLRedirectAction is the BasicDeliveryRuleAction implementation for DeliveryRuleRouteConfigurationOverrideAction.
func (drrcoa DeliveryRuleRouteConfigurationOverrideAction) AsURLRedirectAction() (*URLRedirectAction, bool) {
	return nil, false
}

// AsDeliveryRuleAction is the BasicDeliveryRuleAction implementation for DeliveryRuleRouteConfigurationOverrideAction.
func (drrcoa DeliveryRuleRouteConfigurationOverrideAction) AsDeliveryRuleAction() (*DeliveryRuleAction, bool) {
	return nil, false
}

// AsBasicDeliveryRuleAction is the BasicDeliveryRuleAction implementation for DeliveryRuleRouteConfigurationOverrideAction.
func (drrcoa DeliveryRuleRouteConfigurationOverrideAction) AsBasicDeliveryRuleAction() (BasicDeliveryRuleAction, bool) {
	return &drrcoa, true
}

// DeliveryRuleServerPortCondition defines the ServerPort condition for the delivery rule.
type DeliveryRuleServerPortCondition struct {
	// Parameters - Defines the parameters for the condition.
	Parameters *ServerPortMatchConditionParameters `json:"parameters,omitempty"`
	// Name - Possible values include: 'NameDeliveryRuleCondition', 'NameSslProtocol', 'NameHostName', 'NameServerPort', 'NameClientPort', 'NameSocketAddr', 'NameIsDevice', 'NameCookies', 'NameHTTPVersion', 'NameURLFileName', 'NameURLFileExtension', 'NameURLPath', 'NameRequestScheme', 'NameRequestBody', 'NameRequestHeader', 'NameRequestURI', 'NamePostArgs', 'NameQueryString', 'NameRequestMethod', 'NameRemoteAddress'
	Name Name `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for DeliveryRuleServerPortCondition.
func (drspc DeliveryRuleServerPortCondition) MarshalJSON() ([]byte, error) {
	drspc.Name = NameServerPort
	objectMap := make(map[string]interface{})
	if drspc.Parameters != nil {
		objectMap["parameters"] = drspc.Parameters
	}
	if drspc.Name != "" {
		objectMap["name"] = drspc.Name
	}
	return json.Marshal(objectMap)
}

// AsDeliveryRuleSslProtocolCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleServerPortCondition.
func (drspc DeliveryRuleServerPortCondition) AsDeliveryRuleSslProtocolCondition() (*DeliveryRuleSslProtocolCondition, bool) {
	return nil, false
}

// AsDeliveryRuleHostNameCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleServerPortCondition.
func (drspc DeliveryRuleServerPortCondition) AsDeliveryRuleHostNameCondition() (*DeliveryRuleHostNameCondition, bool) {
	return nil, false
}

// AsDeliveryRuleServerPortCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleServerPortCondition.
func (drspc DeliveryRuleServerPortCondition) AsDeliveryRuleServerPortCondition() (*DeliveryRuleServerPortCondition, bool) {
	return &drspc, true
}

// AsDeliveryRuleClientPortCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleServerPortCondition.
func (drspc DeliveryRuleServerPortCondition) AsDeliveryRuleClientPortCondition() (*DeliveryRuleClientPortCondition, bool) {
	return nil, false
}

// AsDeliveryRuleSocketAddrCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleServerPortCondition.
func (drspc DeliveryRuleServerPortCondition) AsDeliveryRuleSocketAddrCondition() (*DeliveryRuleSocketAddrCondition, bool) {
	return nil, false
}

// AsDeliveryRuleIsDeviceCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleServerPortCondition.
func (drspc DeliveryRuleServerPortCondition) AsDeliveryRuleIsDeviceCondition() (*DeliveryRuleIsDeviceCondition, bool) {
	return nil, false
}

// AsDeliveryRuleCookiesCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleServerPortCondition.
func (drspc DeliveryRuleServerPortCondition) AsDeliveryRuleCookiesCondition() (*DeliveryRuleCookiesCondition, bool) {
	return nil, false
}

// AsDeliveryRuleHTTPVersionCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleServerPortCondition.
func (drspc DeliveryRuleServerPortCondition) AsDeliveryRuleHTTPVersionCondition() (*DeliveryRuleHTTPVersionCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileNameCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleServerPortCondition.
func (drspc DeliveryRuleServerPortCondition) AsDeliveryRuleURLFileNameCondition() (*DeliveryRuleURLFileNameCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileExtensionCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleServerPortCondition.
func (drspc DeliveryRuleServerPortCondition) AsDeliveryRuleURLFileExtensionCondition() (*DeliveryRuleURLFileExtensionCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLPathCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleServerPortCondition.
func (drspc DeliveryRuleServerPortCondition) AsDeliveryRuleURLPathCondition() (*DeliveryRuleURLPathCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestSchemeCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleServerPortCondition.
func (drspc DeliveryRuleServerPortCondition) AsDeliveryRuleRequestSchemeCondition() (*DeliveryRuleRequestSchemeCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestBodyCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleServerPortCondition.
func (drspc DeliveryRuleServerPortCondition) AsDeliveryRuleRequestBodyCondition() (*DeliveryRuleRequestBodyCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestHeaderCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleServerPortCondition.
func (drspc DeliveryRuleServerPortCondition) AsDeliveryRuleRequestHeaderCondition() (*DeliveryRuleRequestHeaderCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestURICondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleServerPortCondition.
func (drspc DeliveryRuleServerPortCondition) AsDeliveryRuleRequestURICondition() (*DeliveryRuleRequestURICondition, bool) {
	return nil, false
}

// AsDeliveryRulePostArgsCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleServerPortCondition.
func (drspc DeliveryRuleServerPortCondition) AsDeliveryRulePostArgsCondition() (*DeliveryRulePostArgsCondition, bool) {
	return nil, false
}

// AsDeliveryRuleQueryStringCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleServerPortCondition.
func (drspc DeliveryRuleServerPortCondition) AsDeliveryRuleQueryStringCondition() (*DeliveryRuleQueryStringCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestMethodCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleServerPortCondition.
func (drspc DeliveryRuleServerPortCondition) AsDeliveryRuleRequestMethodCondition() (*DeliveryRuleRequestMethodCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRemoteAddressCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleServerPortCondition.
func (drspc DeliveryRuleServerPortCondition) AsDeliveryRuleRemoteAddressCondition() (*DeliveryRuleRemoteAddressCondition, bool) {
	return nil, false
}

// AsDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleServerPortCondition.
func (drspc DeliveryRuleServerPortCondition) AsDeliveryRuleCondition() (*DeliveryRuleCondition, bool) {
	return nil, false
}

// AsBasicDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleServerPortCondition.
func (drspc DeliveryRuleServerPortCondition) AsBasicDeliveryRuleCondition() (BasicDeliveryRuleCondition, bool) {
	return &drspc, true
}

// DeliveryRuleSocketAddrCondition defines the SocketAddress condition for the delivery rule.
type DeliveryRuleSocketAddrCondition struct {
	// Parameters - Defines the parameters for the condition.
	Parameters *SocketAddrMatchConditionParameters `json:"parameters,omitempty"`
	// Name - Possible values include: 'NameDeliveryRuleCondition', 'NameSslProtocol', 'NameHostName', 'NameServerPort', 'NameClientPort', 'NameSocketAddr', 'NameIsDevice', 'NameCookies', 'NameHTTPVersion', 'NameURLFileName', 'NameURLFileExtension', 'NameURLPath', 'NameRequestScheme', 'NameRequestBody', 'NameRequestHeader', 'NameRequestURI', 'NamePostArgs', 'NameQueryString', 'NameRequestMethod', 'NameRemoteAddress'
	Name Name `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for DeliveryRuleSocketAddrCondition.
func (drsac DeliveryRuleSocketAddrCondition) MarshalJSON() ([]byte, error) {
	drsac.Name = NameSocketAddr
	objectMap := make(map[string]interface{})
	if drsac.Parameters != nil {
		objectMap["parameters"] = drsac.Parameters
	}
	if drsac.Name != "" {
		objectMap["name"] = drsac.Name
	}
	return json.Marshal(objectMap)
}

// AsDeliveryRuleSslProtocolCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleSocketAddrCondition.
func (drsac DeliveryRuleSocketAddrCondition) AsDeliveryRuleSslProtocolCondition() (*DeliveryRuleSslProtocolCondition, bool) {
	return nil, false
}

// AsDeliveryRuleHostNameCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleSocketAddrCondition.
func (drsac DeliveryRuleSocketAddrCondition) AsDeliveryRuleHostNameCondition() (*DeliveryRuleHostNameCondition, bool) {
	return nil, false
}

// AsDeliveryRuleServerPortCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleSocketAddrCondition.
func (drsac DeliveryRuleSocketAddrCondition) AsDeliveryRuleServerPortCondition() (*DeliveryRuleServerPortCondition, bool) {
	return nil, false
}

// AsDeliveryRuleClientPortCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleSocketAddrCondition.
func (drsac DeliveryRuleSocketAddrCondition) AsDeliveryRuleClientPortCondition() (*DeliveryRuleClientPortCondition, bool) {
	return nil, false
}

// AsDeliveryRuleSocketAddrCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleSocketAddrCondition.
func (drsac DeliveryRuleSocketAddrCondition) AsDeliveryRuleSocketAddrCondition() (*DeliveryRuleSocketAddrCondition, bool) {
	return &drsac, true
}

// AsDeliveryRuleIsDeviceCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleSocketAddrCondition.
func (drsac DeliveryRuleSocketAddrCondition) AsDeliveryRuleIsDeviceCondition() (*DeliveryRuleIsDeviceCondition, bool) {
	return nil, false
}

// AsDeliveryRuleCookiesCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleSocketAddrCondition.
func (drsac DeliveryRuleSocketAddrCondition) AsDeliveryRuleCookiesCondition() (*DeliveryRuleCookiesCondition, bool) {
	return nil, false
}

// AsDeliveryRuleHTTPVersionCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleSocketAddrCondition.
func (drsac DeliveryRuleSocketAddrCondition) AsDeliveryRuleHTTPVersionCondition() (*DeliveryRuleHTTPVersionCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileNameCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleSocketAddrCondition.
func (drsac DeliveryRuleSocketAddrCondition) AsDeliveryRuleURLFileNameCondition() (*DeliveryRuleURLFileNameCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileExtensionCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleSocketAddrCondition.
func (drsac DeliveryRuleSocketAddrCondition) AsDeliveryRuleURLFileExtensionCondition() (*DeliveryRuleURLFileExtensionCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLPathCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleSocketAddrCondition.
func (drsac DeliveryRuleSocketAddrCondition) AsDeliveryRuleURLPathCondition() (*DeliveryRuleURLPathCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestSchemeCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleSocketAddrCondition.
func (drsac DeliveryRuleSocketAddrCondition) AsDeliveryRuleRequestSchemeCondition() (*DeliveryRuleRequestSchemeCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestBodyCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleSocketAddrCondition.
func (drsac DeliveryRuleSocketAddrCondition) AsDeliveryRuleRequestBodyCondition() (*DeliveryRuleRequestBodyCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestHeaderCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleSocketAddrCondition.
func (drsac DeliveryRuleSocketAddrCondition) AsDeliveryRuleRequestHeaderCondition() (*DeliveryRuleRequestHeaderCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestURICondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleSocketAddrCondition.
func (drsac DeliveryRuleSocketAddrCondition) AsDeliveryRuleRequestURICondition() (*DeliveryRuleRequestURICondition, bool) {
	return nil, false
}

// AsDeliveryRulePostArgsCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleSocketAddrCondition.
func (drsac DeliveryRuleSocketAddrCondition) AsDeliveryRulePostArgsCondition() (*DeliveryRulePostArgsCondition, bool) {
	return nil, false
}

// AsDeliveryRuleQueryStringCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleSocketAddrCondition.
func (drsac DeliveryRuleSocketAddrCondition) AsDeliveryRuleQueryStringCondition() (*DeliveryRuleQueryStringCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestMethodCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleSocketAddrCondition.
func (drsac DeliveryRuleSocketAddrCondition) AsDeliveryRuleRequestMethodCondition() (*DeliveryRuleRequestMethodCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRemoteAddressCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleSocketAddrCondition.
func (drsac DeliveryRuleSocketAddrCondition) AsDeliveryRuleRemoteAddressCondition() (*DeliveryRuleRemoteAddressCondition, bool) {
	return nil, false
}

// AsDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleSocketAddrCondition.
func (drsac DeliveryRuleSocketAddrCondition) AsDeliveryRuleCondition() (*DeliveryRuleCondition, bool) {
	return nil, false
}

// AsBasicDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleSocketAddrCondition.
func (drsac DeliveryRuleSocketAddrCondition) AsBasicDeliveryRuleCondition() (BasicDeliveryRuleCondition, bool) {
	return &drsac, true
}

// DeliveryRuleSslProtocolCondition defines the SslProtocol condition for the delivery rule.
type DeliveryRuleSslProtocolCondition struct {
	// Parameters - Defines the parameters for the condition.
	Parameters *SslProtocolMatchConditionParameters `json:"parameters,omitempty"`
	// Name - Possible values include: 'NameDeliveryRuleCondition', 'NameSslProtocol', 'NameHostName', 'NameServerPort', 'NameClientPort', 'NameSocketAddr', 'NameIsDevice', 'NameCookies', 'NameHTTPVersion', 'NameURLFileName', 'NameURLFileExtension', 'NameURLPath', 'NameRequestScheme', 'NameRequestBody', 'NameRequestHeader', 'NameRequestURI', 'NamePostArgs', 'NameQueryString', 'NameRequestMethod', 'NameRemoteAddress'
	Name Name `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for DeliveryRuleSslProtocolCondition.
func (drspc DeliveryRuleSslProtocolCondition) MarshalJSON() ([]byte, error) {
	drspc.Name = NameSslProtocol
	objectMap := make(map[string]interface{})
	if drspc.Parameters != nil {
		objectMap["parameters"] = drspc.Parameters
	}
	if drspc.Name != "" {
		objectMap["name"] = drspc.Name
	}
	return json.Marshal(objectMap)
}

// AsDeliveryRuleSslProtocolCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleSslProtocolCondition.
func (drspc DeliveryRuleSslProtocolCondition) AsDeliveryRuleSslProtocolCondition() (*DeliveryRuleSslProtocolCondition, bool) {
	return &drspc, true
}

// AsDeliveryRuleHostNameCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleSslProtocolCondition.
func (drspc DeliveryRuleSslProtocolCondition) AsDeliveryRuleHostNameCondition() (*DeliveryRuleHostNameCondition, bool) {
	return nil, false
}

// AsDeliveryRuleServerPortCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleSslProtocolCondition.
func (drspc DeliveryRuleSslProtocolCondition) AsDeliveryRuleServerPortCondition() (*DeliveryRuleServerPortCondition, bool) {
	return nil, false
}

// AsDeliveryRuleClientPortCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleSslProtocolCondition.
func (drspc DeliveryRuleSslProtocolCondition) AsDeliveryRuleClientPortCondition() (*DeliveryRuleClientPortCondition, bool) {
	return nil, false
}

// AsDeliveryRuleSocketAddrCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleSslProtocolCondition.
func (drspc DeliveryRuleSslProtocolCondition) AsDeliveryRuleSocketAddrCondition() (*DeliveryRuleSocketAddrCondition, bool) {
	return nil, false
}

// AsDeliveryRuleIsDeviceCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleSslProtocolCondition.
func (drspc DeliveryRuleSslProtocolCondition) AsDeliveryRuleIsDeviceCondition() (*DeliveryRuleIsDeviceCondition, bool) {
	return nil, false
}

// AsDeliveryRuleCookiesCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleSslProtocolCondition.
func (drspc DeliveryRuleSslProtocolCondition) AsDeliveryRuleCookiesCondition() (*DeliveryRuleCookiesCondition, bool) {
	return nil, false
}

// AsDeliveryRuleHTTPVersionCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleSslProtocolCondition.
func (drspc DeliveryRuleSslProtocolCondition) AsDeliveryRuleHTTPVersionCondition() (*DeliveryRuleHTTPVersionCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileNameCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleSslProtocolCondition.
func (drspc DeliveryRuleSslProtocolCondition) AsDeliveryRuleURLFileNameCondition() (*DeliveryRuleURLFileNameCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileExtensionCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleSslProtocolCondition.
func (drspc DeliveryRuleSslProtocolCondition) AsDeliveryRuleURLFileExtensionCondition() (*DeliveryRuleURLFileExtensionCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLPathCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleSslProtocolCondition.
func (drspc DeliveryRuleSslProtocolCondition) AsDeliveryRuleURLPathCondition() (*DeliveryRuleURLPathCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestSchemeCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleSslProtocolCondition.
func (drspc DeliveryRuleSslProtocolCondition) AsDeliveryRuleRequestSchemeCondition() (*DeliveryRuleRequestSchemeCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestBodyCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleSslProtocolCondition.
func (drspc DeliveryRuleSslProtocolCondition) AsDeliveryRuleRequestBodyCondition() (*DeliveryRuleRequestBodyCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestHeaderCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleSslProtocolCondition.
func (drspc DeliveryRuleSslProtocolCondition) AsDeliveryRuleRequestHeaderCondition() (*DeliveryRuleRequestHeaderCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestURICondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleSslProtocolCondition.
func (drspc DeliveryRuleSslProtocolCondition) AsDeliveryRuleRequestURICondition() (*DeliveryRuleRequestURICondition, bool) {
	return nil, false
}

// AsDeliveryRulePostArgsCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleSslProtocolCondition.
func (drspc DeliveryRuleSslProtocolCondition) AsDeliveryRulePostArgsCondition() (*DeliveryRulePostArgsCondition, bool) {
	return nil, false
}

// AsDeliveryRuleQueryStringCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleSslProtocolCondition.
func (drspc DeliveryRuleSslProtocolCondition) AsDeliveryRuleQueryStringCondition() (*DeliveryRuleQueryStringCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestMethodCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleSslProtocolCondition.
func (drspc DeliveryRuleSslProtocolCondition) AsDeliveryRuleRequestMethodCondition() (*DeliveryRuleRequestMethodCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRemoteAddressCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleSslProtocolCondition.
func (drspc DeliveryRuleSslProtocolCondition) AsDeliveryRuleRemoteAddressCondition() (*DeliveryRuleRemoteAddressCondition, bool) {
	return nil, false
}

// AsDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleSslProtocolCondition.
func (drspc DeliveryRuleSslProtocolCondition) AsDeliveryRuleCondition() (*DeliveryRuleCondition, bool) {
	return nil, false
}

// AsBasicDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleSslProtocolCondition.
func (drspc DeliveryRuleSslProtocolCondition) AsBasicDeliveryRuleCondition() (BasicDeliveryRuleCondition, bool) {
	return &drspc, true
}

// DeliveryRuleURLFileExtensionCondition defines the UrlFileExtension condition for the delivery rule.
type DeliveryRuleURLFileExtensionCondition struct {
	// Parameters - Defines the parameters for the condition.
	Parameters *URLFileExtensionMatchConditionParameters `json:"parameters,omitempty"`
	// Name - Possible values include: 'NameDeliveryRuleCondition', 'NameSslProtocol', 'NameHostName', 'NameServerPort', 'NameClientPort', 'NameSocketAddr', 'NameIsDevice', 'NameCookies', 'NameHTTPVersion', 'NameURLFileName', 'NameURLFileExtension', 'NameURLPath', 'NameRequestScheme', 'NameRequestBody', 'NameRequestHeader', 'NameRequestURI', 'NamePostArgs', 'NameQueryString', 'NameRequestMethod', 'NameRemoteAddress'
	Name Name `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for DeliveryRuleURLFileExtensionCondition.
func (drufec DeliveryRuleURLFileExtensionCondition) MarshalJSON() ([]byte, error) {
	drufec.Name = NameURLFileExtension
	objectMap := make(map[string]interface{})
	if drufec.Parameters != nil {
		objectMap["parameters"] = drufec.Parameters
	}
	if drufec.Name != "" {
		objectMap["name"] = drufec.Name
	}
	return json.Marshal(objectMap)
}

// AsDeliveryRuleSslProtocolCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileExtensionCondition.
func (drufec DeliveryRuleURLFileExtensionCondition) AsDeliveryRuleSslProtocolCondition() (*DeliveryRuleSslProtocolCondition, bool) {
	return nil, false
}

// AsDeliveryRuleHostNameCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileExtensionCondition.
func (drufec DeliveryRuleURLFileExtensionCondition) AsDeliveryRuleHostNameCondition() (*DeliveryRuleHostNameCondition, bool) {
	return nil, false
}

// AsDeliveryRuleServerPortCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileExtensionCondition.
func (drufec DeliveryRuleURLFileExtensionCondition) AsDeliveryRuleServerPortCondition() (*DeliveryRuleServerPortCondition, bool) {
	return nil, false
}

// AsDeliveryRuleClientPortCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileExtensionCondition.
func (drufec DeliveryRuleURLFileExtensionCondition) AsDeliveryRuleClientPortCondition() (*DeliveryRuleClientPortCondition, bool) {
	return nil, false
}

// AsDeliveryRuleSocketAddrCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileExtensionCondition.
func (drufec DeliveryRuleURLFileExtensionCondition) AsDeliveryRuleSocketAddrCondition() (*DeliveryRuleSocketAddrCondition, bool) {
	return nil, false
}

// AsDeliveryRuleIsDeviceCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileExtensionCondition.
func (drufec DeliveryRuleURLFileExtensionCondition) AsDeliveryRuleIsDeviceCondition() (*DeliveryRuleIsDeviceCondition, bool) {
	return nil, false
}

// AsDeliveryRuleCookiesCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileExtensionCondition.
func (drufec DeliveryRuleURLFileExtensionCondition) AsDeliveryRuleCookiesCondition() (*DeliveryRuleCookiesCondition, bool) {
	return nil, false
}

// AsDeliveryRuleHTTPVersionCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileExtensionCondition.
func (drufec DeliveryRuleURLFileExtensionCondition) AsDeliveryRuleHTTPVersionCondition() (*DeliveryRuleHTTPVersionCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileNameCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileExtensionCondition.
func (drufec DeliveryRuleURLFileExtensionCondition) AsDeliveryRuleURLFileNameCondition() (*DeliveryRuleURLFileNameCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileExtensionCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileExtensionCondition.
func (drufec DeliveryRuleURLFileExtensionCondition) AsDeliveryRuleURLFileExtensionCondition() (*DeliveryRuleURLFileExtensionCondition, bool) {
	return &drufec, true
}

// AsDeliveryRuleURLPathCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileExtensionCondition.
func (drufec DeliveryRuleURLFileExtensionCondition) AsDeliveryRuleURLPathCondition() (*DeliveryRuleURLPathCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestSchemeCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileExtensionCondition.
func (drufec DeliveryRuleURLFileExtensionCondition) AsDeliveryRuleRequestSchemeCondition() (*DeliveryRuleRequestSchemeCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestBodyCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileExtensionCondition.
func (drufec DeliveryRuleURLFileExtensionCondition) AsDeliveryRuleRequestBodyCondition() (*DeliveryRuleRequestBodyCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestHeaderCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileExtensionCondition.
func (drufec DeliveryRuleURLFileExtensionCondition) AsDeliveryRuleRequestHeaderCondition() (*DeliveryRuleRequestHeaderCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestURICondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileExtensionCondition.
func (drufec DeliveryRuleURLFileExtensionCondition) AsDeliveryRuleRequestURICondition() (*DeliveryRuleRequestURICondition, bool) {
	return nil, false
}

// AsDeliveryRulePostArgsCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileExtensionCondition.
func (drufec DeliveryRuleURLFileExtensionCondition) AsDeliveryRulePostArgsCondition() (*DeliveryRulePostArgsCondition, bool) {
	return nil, false
}

// AsDeliveryRuleQueryStringCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileExtensionCondition.
func (drufec DeliveryRuleURLFileExtensionCondition) AsDeliveryRuleQueryStringCondition() (*DeliveryRuleQueryStringCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestMethodCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileExtensionCondition.
func (drufec DeliveryRuleURLFileExtensionCondition) AsDeliveryRuleRequestMethodCondition() (*DeliveryRuleRequestMethodCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRemoteAddressCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileExtensionCondition.
func (drufec DeliveryRuleURLFileExtensionCondition) AsDeliveryRuleRemoteAddressCondition() (*DeliveryRuleRemoteAddressCondition, bool) {
	return nil, false
}

// AsDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileExtensionCondition.
func (drufec DeliveryRuleURLFileExtensionCondition) AsDeliveryRuleCondition() (*DeliveryRuleCondition, bool) {
	return nil, false
}

// AsBasicDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileExtensionCondition.
func (drufec DeliveryRuleURLFileExtensionCondition) AsBasicDeliveryRuleCondition() (BasicDeliveryRuleCondition, bool) {
	return &drufec, true
}

// DeliveryRuleURLFileNameCondition defines the UrlFileName condition for the delivery rule.
type DeliveryRuleURLFileNameCondition struct {
	// Parameters - Defines the parameters for the condition.
	Parameters *URLFileNameMatchConditionParameters `json:"parameters,omitempty"`
	// Name - Possible values include: 'NameDeliveryRuleCondition', 'NameSslProtocol', 'NameHostName', 'NameServerPort', 'NameClientPort', 'NameSocketAddr', 'NameIsDevice', 'NameCookies', 'NameHTTPVersion', 'NameURLFileName', 'NameURLFileExtension', 'NameURLPath', 'NameRequestScheme', 'NameRequestBody', 'NameRequestHeader', 'NameRequestURI', 'NamePostArgs', 'NameQueryString', 'NameRequestMethod', 'NameRemoteAddress'
	Name Name `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for DeliveryRuleURLFileNameCondition.
func (drufnc DeliveryRuleURLFileNameCondition) MarshalJSON() ([]byte, error) {
	drufnc.Name = NameURLFileName
	objectMap := make(map[string]interface{})
	if drufnc.Parameters != nil {
		objectMap["parameters"] = drufnc.Parameters
	}
	if drufnc.Name != "" {
		objectMap["name"] = drufnc.Name
	}
	return json.Marshal(objectMap)
}

// AsDeliveryRuleSslProtocolCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileNameCondition.
func (drufnc DeliveryRuleURLFileNameCondition) AsDeliveryRuleSslProtocolCondition() (*DeliveryRuleSslProtocolCondition, bool) {
	return nil, false
}

// AsDeliveryRuleHostNameCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileNameCondition.
func (drufnc DeliveryRuleURLFileNameCondition) AsDeliveryRuleHostNameCondition() (*DeliveryRuleHostNameCondition, bool) {
	return nil, false
}

// AsDeliveryRuleServerPortCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileNameCondition.
func (drufnc DeliveryRuleURLFileNameCondition) AsDeliveryRuleServerPortCondition() (*DeliveryRuleServerPortCondition, bool) {
	return nil, false
}

// AsDeliveryRuleClientPortCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileNameCondition.
func (drufnc DeliveryRuleURLFileNameCondition) AsDeliveryRuleClientPortCondition() (*DeliveryRuleClientPortCondition, bool) {
	return nil, false
}

// AsDeliveryRuleSocketAddrCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileNameCondition.
func (drufnc DeliveryRuleURLFileNameCondition) AsDeliveryRuleSocketAddrCondition() (*DeliveryRuleSocketAddrCondition, bool) {
	return nil, false
}

// AsDeliveryRuleIsDeviceCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileNameCondition.
func (drufnc DeliveryRuleURLFileNameCondition) AsDeliveryRuleIsDeviceCondition() (*DeliveryRuleIsDeviceCondition, bool) {
	return nil, false
}

// AsDeliveryRuleCookiesCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileNameCondition.
func (drufnc DeliveryRuleURLFileNameCondition) AsDeliveryRuleCookiesCondition() (*DeliveryRuleCookiesCondition, bool) {
	return nil, false
}

// AsDeliveryRuleHTTPVersionCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileNameCondition.
func (drufnc DeliveryRuleURLFileNameCondition) AsDeliveryRuleHTTPVersionCondition() (*DeliveryRuleHTTPVersionCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileNameCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileNameCondition.
func (drufnc DeliveryRuleURLFileNameCondition) AsDeliveryRuleURLFileNameCondition() (*DeliveryRuleURLFileNameCondition, bool) {
	return &drufnc, true
}

// AsDeliveryRuleURLFileExtensionCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileNameCondition.
func (drufnc DeliveryRuleURLFileNameCondition) AsDeliveryRuleURLFileExtensionCondition() (*DeliveryRuleURLFileExtensionCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLPathCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileNameCondition.
func (drufnc DeliveryRuleURLFileNameCondition) AsDeliveryRuleURLPathCondition() (*DeliveryRuleURLPathCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestSchemeCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileNameCondition.
func (drufnc DeliveryRuleURLFileNameCondition) AsDeliveryRuleRequestSchemeCondition() (*DeliveryRuleRequestSchemeCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestBodyCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileNameCondition.
func (drufnc DeliveryRuleURLFileNameCondition) AsDeliveryRuleRequestBodyCondition() (*DeliveryRuleRequestBodyCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestHeaderCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileNameCondition.
func (drufnc DeliveryRuleURLFileNameCondition) AsDeliveryRuleRequestHeaderCondition() (*DeliveryRuleRequestHeaderCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestURICondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileNameCondition.
func (drufnc DeliveryRuleURLFileNameCondition) AsDeliveryRuleRequestURICondition() (*DeliveryRuleRequestURICondition, bool) {
	return nil, false
}

// AsDeliveryRulePostArgsCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileNameCondition.
func (drufnc DeliveryRuleURLFileNameCondition) AsDeliveryRulePostArgsCondition() (*DeliveryRulePostArgsCondition, bool) {
	return nil, false
}

// AsDeliveryRuleQueryStringCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileNameCondition.
func (drufnc DeliveryRuleURLFileNameCondition) AsDeliveryRuleQueryStringCondition() (*DeliveryRuleQueryStringCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestMethodCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileNameCondition.
func (drufnc DeliveryRuleURLFileNameCondition) AsDeliveryRuleRequestMethodCondition() (*DeliveryRuleRequestMethodCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRemoteAddressCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileNameCondition.
func (drufnc DeliveryRuleURLFileNameCondition) AsDeliveryRuleRemoteAddressCondition() (*DeliveryRuleRemoteAddressCondition, bool) {
	return nil, false
}

// AsDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileNameCondition.
func (drufnc DeliveryRuleURLFileNameCondition) AsDeliveryRuleCondition() (*DeliveryRuleCondition, bool) {
	return nil, false
}

// AsBasicDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileNameCondition.
func (drufnc DeliveryRuleURLFileNameCondition) AsBasicDeliveryRuleCondition() (BasicDeliveryRuleCondition, bool) {
	return &drufnc, true
}

// DeliveryRuleURLPathCondition defines the UrlPath condition for the delivery rule.
type DeliveryRuleURLPathCondition struct {
	// Parameters - Defines the parameters for the condition.
	Parameters *URLPathMatchConditionParameters `json:"parameters,omitempty"`
	// Name - Possible values include: 'NameDeliveryRuleCondition', 'NameSslProtocol', 'NameHostName', 'NameServerPort', 'NameClientPort', 'NameSocketAddr', 'NameIsDevice', 'NameCookies', 'NameHTTPVersion', 'NameURLFileName', 'NameURLFileExtension', 'NameURLPath', 'NameRequestScheme', 'NameRequestBody', 'NameRequestHeader', 'NameRequestURI', 'NamePostArgs', 'NameQueryString', 'NameRequestMethod', 'NameRemoteAddress'
	Name Name `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for DeliveryRuleURLPathCondition.
func (drupc DeliveryRuleURLPathCondition) MarshalJSON() ([]byte, error) {
	drupc.Name = NameURLPath
	objectMap := make(map[string]interface{})
	if drupc.Parameters != nil {
		objectMap["parameters"] = drupc.Parameters
	}
	if drupc.Name != "" {
		objectMap["name"] = drupc.Name
	}
	return json.Marshal(objectMap)
}

// AsDeliveryRuleSslProtocolCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLPathCondition.
func (drupc DeliveryRuleURLPathCondition) AsDeliveryRuleSslProtocolCondition() (*DeliveryRuleSslProtocolCondition, bool) {
	return nil, false
}

// AsDeliveryRuleHostNameCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLPathCondition.
func (drupc DeliveryRuleURLPathCondition) AsDeliveryRuleHostNameCondition() (*DeliveryRuleHostNameCondition, bool) {
	return nil, false
}

// AsDeliveryRuleServerPortCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLPathCondition.
func (drupc DeliveryRuleURLPathCondition) AsDeliveryRuleServerPortCondition() (*DeliveryRuleServerPortCondition, bool) {
	return nil, false
}

// AsDeliveryRuleClientPortCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLPathCondition.
func (drupc DeliveryRuleURLPathCondition) AsDeliveryRuleClientPortCondition() (*DeliveryRuleClientPortCondition, bool) {
	return nil, false
}

// AsDeliveryRuleSocketAddrCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLPathCondition.
func (drupc DeliveryRuleURLPathCondition) AsDeliveryRuleSocketAddrCondition() (*DeliveryRuleSocketAddrCondition, bool) {
	return nil, false
}

// AsDeliveryRuleIsDeviceCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLPathCondition.
func (drupc DeliveryRuleURLPathCondition) AsDeliveryRuleIsDeviceCondition() (*DeliveryRuleIsDeviceCondition, bool) {
	return nil, false
}

// AsDeliveryRuleCookiesCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLPathCondition.
func (drupc DeliveryRuleURLPathCondition) AsDeliveryRuleCookiesCondition() (*DeliveryRuleCookiesCondition, bool) {
	return nil, false
}

// AsDeliveryRuleHTTPVersionCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLPathCondition.
func (drupc DeliveryRuleURLPathCondition) AsDeliveryRuleHTTPVersionCondition() (*DeliveryRuleHTTPVersionCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileNameCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLPathCondition.
func (drupc DeliveryRuleURLPathCondition) AsDeliveryRuleURLFileNameCondition() (*DeliveryRuleURLFileNameCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileExtensionCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLPathCondition.
func (drupc DeliveryRuleURLPathCondition) AsDeliveryRuleURLFileExtensionCondition() (*DeliveryRuleURLFileExtensionCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLPathCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLPathCondition.
func (drupc DeliveryRuleURLPathCondition) AsDeliveryRuleURLPathCondition() (*DeliveryRuleURLPathCondition, bool) {
	return &drupc, true
}

// AsDeliveryRuleRequestSchemeCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLPathCondition.
func (drupc DeliveryRuleURLPathCondition) AsDeliveryRuleRequestSchemeCondition() (*DeliveryRuleRequestSchemeCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestBodyCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLPathCondition.
func (drupc DeliveryRuleURLPathCondition) AsDeliveryRuleRequestBodyCondition() (*DeliveryRuleRequestBodyCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestHeaderCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLPathCondition.
func (drupc DeliveryRuleURLPathCondition) AsDeliveryRuleRequestHeaderCondition() (*DeliveryRuleRequestHeaderCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestURICondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLPathCondition.
func (drupc DeliveryRuleURLPathCondition) AsDeliveryRuleRequestURICondition() (*DeliveryRuleRequestURICondition, bool) {
	return nil, false
}

// AsDeliveryRulePostArgsCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLPathCondition.
func (drupc DeliveryRuleURLPathCondition) AsDeliveryRulePostArgsCondition() (*DeliveryRulePostArgsCondition, bool) {
	return nil, false
}

// AsDeliveryRuleQueryStringCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLPathCondition.
func (drupc DeliveryRuleURLPathCondition) AsDeliveryRuleQueryStringCondition() (*DeliveryRuleQueryStringCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRequestMethodCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLPathCondition.
func (drupc DeliveryRuleURLPathCondition) AsDeliveryRuleRequestMethodCondition() (*DeliveryRuleRequestMethodCondition, bool) {
	return nil, false
}

// AsDeliveryRuleRemoteAddressCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLPathCondition.
func (drupc DeliveryRuleURLPathCondition) AsDeliveryRuleRemoteAddressCondition() (*DeliveryRuleRemoteAddressCondition, bool) {
	return nil, false
}

// AsDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLPathCondition.
func (drupc DeliveryRuleURLPathCondition) AsDeliveryRuleCondition() (*DeliveryRuleCondition, bool) {
	return nil, false
}

// AsBasicDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLPathCondition.
func (drupc DeliveryRuleURLPathCondition) AsBasicDeliveryRuleCondition() (BasicDeliveryRuleCondition, bool) {
	return &drupc, true
}

// DimensionProperties type of operation: get, read, delete, etc.
type DimensionProperties struct {
	// Name - Name of dimension.
	Name *string `json:"name,omitempty"`
	// DisplayName - Display name of dimension.
	DisplayName *string `json:"displayName,omitempty"`
	// InternalName - Internal name of dimension.
	InternalName *string `json:"internalName,omitempty"`
}

// DomainValidationProperties the JSON object that contains the properties to validate a domain.
type DomainValidationProperties struct {
	// ValidationToken - READ-ONLY; Challenge used for DNS TXT record or file based validation
	ValidationToken *string `json:"validationToken,omitempty"`
	// ExpirationDate - READ-ONLY; The date time that the token expires
	ExpirationDate *string `json:"expirationDate,omitempty"`
}

// MarshalJSON is the custom marshaler for DomainValidationProperties.
func (dvp DomainValidationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// EdgeNode edgenode is a global Point of Presence (POP) location used to deliver CDN content to end users.
type EdgeNode struct {
	*EdgeNodeProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for EdgeNode.
func (en EdgeNode) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if en.EdgeNodeProperties != nil {
		objectMap["properties"] = en.EdgeNodeProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EdgeNode struct.
func (en *EdgeNode) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var edgeNodeProperties EdgeNodeProperties
				err = json.Unmarshal(*v, &edgeNodeProperties)
				if err != nil {
					return err
				}
				en.EdgeNodeProperties = &edgeNodeProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				en.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				en.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				en.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				en.SystemData = &systemData
			}
		}
	}

	return nil
}

// EdgeNodeProperties the JSON object that contains the properties required to create an edgenode.
type EdgeNodeProperties struct {
	// IPAddressGroups - List of ip address groups.
	IPAddressGroups *[]IPAddressGroup `json:"ipAddressGroups,omitempty"`
}

// EdgenodeResult result of the request to list CDN edgenodes. It contains a list of ip address group and a
// URL link to get the next set of results.
type EdgenodeResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Edge node of CDN service.
	Value *[]EdgeNode `json:"value,omitempty"`
	// NextLink - URL to get the next set of edgenode list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for EdgenodeResult.
func (er EdgenodeResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if er.NextLink != nil {
		objectMap["nextLink"] = er.NextLink
	}
	return json.Marshal(objectMap)
}

// EdgenodeResultIterator provides access to a complete listing of EdgeNode values.
type EdgenodeResultIterator struct {
	i    int
	page EdgenodeResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EdgenodeResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EdgenodeResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *EdgenodeResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EdgenodeResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EdgenodeResultIterator) Response() EdgenodeResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EdgenodeResultIterator) Value() EdgeNode {
	if !iter.page.NotDone() {
		return EdgeNode{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the EdgenodeResultIterator type.
func NewEdgenodeResultIterator(page EdgenodeResultPage) EdgenodeResultIterator {
	return EdgenodeResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (er EdgenodeResult) IsEmpty() bool {
	return er.Value == nil || len(*er.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (er EdgenodeResult) hasNextLink() bool {
	return er.NextLink != nil && len(*er.NextLink) != 0
}

// edgenodeResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (er EdgenodeResult) edgenodeResultPreparer(ctx context.Context) (*http.Request, error) {
	if !er.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(er.NextLink)))
}

// EdgenodeResultPage contains a page of EdgeNode values.
type EdgenodeResultPage struct {
	fn func(context.Context, EdgenodeResult) (EdgenodeResult, error)
	er EdgenodeResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EdgenodeResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EdgenodeResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.er)
		if err != nil {
			return err
		}
		page.er = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *EdgenodeResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EdgenodeResultPage) NotDone() bool {
	return !page.er.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EdgenodeResultPage) Response() EdgenodeResult {
	return page.er
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EdgenodeResultPage) Values() []EdgeNode {
	if page.er.IsEmpty() {
		return nil
	}
	return *page.er.Value
}

// Creates a new instance of the EdgenodeResultPage type.
func NewEdgenodeResultPage(cur EdgenodeResult, getNextPage func(context.Context, EdgenodeResult) (EdgenodeResult, error)) EdgenodeResultPage {
	return EdgenodeResultPage{
		fn: getNextPage,
		er: cur,
	}
}

// Endpoint CDN endpoint is the entity within a CDN profile containing configuration information such as
// origin, protocol, content caching and delivery behavior. The CDN endpoint uses the URL format
// <endpointname>.azureedge.net.
type Endpoint struct {
	autorest.Response   `json:"-"`
	*EndpointProperties `json:"properties,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for Endpoint.
func (e Endpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if e.EndpointProperties != nil {
		objectMap["properties"] = e.EndpointProperties
	}
	if e.Location != nil {
		objectMap["location"] = e.Location
	}
	if e.Tags != nil {
		objectMap["tags"] = e.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Endpoint struct.
func (e *Endpoint) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var endpointProperties EndpointProperties
				err = json.Unmarshal(*v, &endpointProperties)
				if err != nil {
					return err
				}
				e.EndpointProperties = &endpointProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				e.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				e.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				e.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				e.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				e.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				e.SystemData = &systemData
			}
		}
	}

	return nil
}

// EndpointListResult result of the request to list endpoints. It contains a list of endpoint objects and a
// URL link to get the next set of results.
type EndpointListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of CDN endpoints within a profile
	Value *[]Endpoint `json:"value,omitempty"`
	// NextLink - URL to get the next set of endpoint objects if there is any.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for EndpointListResult.
func (elr EndpointListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if elr.NextLink != nil {
		objectMap["nextLink"] = elr.NextLink
	}
	return json.Marshal(objectMap)
}

// EndpointListResultIterator provides access to a complete listing of Endpoint values.
type EndpointListResultIterator struct {
	i    int
	page EndpointListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EndpointListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EndpointListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *EndpointListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EndpointListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EndpointListResultIterator) Response() EndpointListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EndpointListResultIterator) Value() Endpoint {
	if !iter.page.NotDone() {
		return Endpoint{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the EndpointListResultIterator type.
func NewEndpointListResultIterator(page EndpointListResultPage) EndpointListResultIterator {
	return EndpointListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (elr EndpointListResult) IsEmpty() bool {
	return elr.Value == nil || len(*elr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (elr EndpointListResult) hasNextLink() bool {
	return elr.NextLink != nil && len(*elr.NextLink) != 0
}

// endpointListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (elr EndpointListResult) endpointListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !elr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(elr.NextLink)))
}

// EndpointListResultPage contains a page of Endpoint values.
type EndpointListResultPage struct {
	fn  func(context.Context, EndpointListResult) (EndpointListResult, error)
	elr EndpointListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EndpointListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EndpointListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.elr)
		if err != nil {
			return err
		}
		page.elr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *EndpointListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EndpointListResultPage) NotDone() bool {
	return !page.elr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EndpointListResultPage) Response() EndpointListResult {
	return page.elr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EndpointListResultPage) Values() []Endpoint {
	if page.elr.IsEmpty() {
		return nil
	}
	return *page.elr.Value
}

// Creates a new instance of the EndpointListResultPage type.
func NewEndpointListResultPage(cur EndpointListResult, getNextPage func(context.Context, EndpointListResult) (EndpointListResult, error)) EndpointListResultPage {
	return EndpointListResultPage{
		fn:  getNextPage,
		elr: cur,
	}
}

// EndpointProperties the JSON object that contains the properties required to create an endpoint.
type EndpointProperties struct {
	// HostName - READ-ONLY; The host name of the endpoint structured as {endpointName}.{DNSZone}, e.g. contoso.azureedge.net
	HostName *string `json:"hostName,omitempty"`
	// Origins - The source of the content being delivered via CDN.
	Origins *[]DeepCreatedOrigin `json:"origins,omitempty"`
	// OriginGroups - The origin groups comprising of origins that are used for load balancing the traffic based on availability.
	OriginGroups *[]DeepCreatedOriginGroup `json:"originGroups,omitempty"`
	// CustomDomains - READ-ONLY; The custom domains under the endpoint.
	CustomDomains *[]CustomDomain `json:"customDomains,omitempty"`
	// ResourceState - READ-ONLY; Resource status of the endpoint. Possible values include: 'EndpointResourceStateCreating', 'EndpointResourceStateDeleting', 'EndpointResourceStateRunning', 'EndpointResourceStateStarting', 'EndpointResourceStateStopped', 'EndpointResourceStateStopping'
	ResourceState EndpointResourceState `json:"resourceState,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning status of the endpoint.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// OriginPath - A directory path on the origin that CDN can use to retrieve content from, e.g. contoso.cloudapp.net/originpath.
	OriginPath *string `json:"originPath,omitempty"`
	// ContentTypesToCompress - List of content types on which compression applies. The value should be a valid MIME type.
	ContentTypesToCompress *[]string `json:"contentTypesToCompress,omitempty"`
	// OriginHostHeader - The host header value sent to the origin with each request. This property at Endpoint is only allowed when endpoint uses single origin and can be overridden by the same property specified at origin.If you leave this blank, the request hostname determines this value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services require this host header value to match the origin hostname by default.
	OriginHostHeader *string `json:"originHostHeader,omitempty"`
	// IsCompressionEnabled - Indicates whether content compression is enabled on CDN. Default value is false. If compression is enabled, content will be served as compressed if user requests for a compressed version. Content won't be compressed on CDN when requested content is smaller than 1 byte or larger than 1 MB.
	IsCompressionEnabled *bool `json:"isCompressionEnabled,omitempty"`
	// IsHTTPAllowed - Indicates whether HTTP traffic is allowed on the endpoint. Default value is true. At least one protocol (HTTP or HTTPS) must be allowed.
	IsHTTPAllowed *bool `json:"isHttpAllowed,omitempty"`
	// IsHTTPSAllowed - Indicates whether HTTPS traffic is allowed on the endpoint. Default value is true. At least one protocol (HTTP or HTTPS) must be allowed.
	IsHTTPSAllowed *bool `json:"isHttpsAllowed,omitempty"`
	// QueryStringCachingBehavior - Defines how CDN caches requests that include query strings. You can ignore any query strings when caching, bypass caching to prevent requests that contain query strings from being cached, or cache every request with a unique URL. Possible values include: 'QueryStringCachingBehaviorIgnoreQueryString', 'QueryStringCachingBehaviorBypassCaching', 'QueryStringCachingBehaviorUseQueryString', 'QueryStringCachingBehaviorNotSet'
	QueryStringCachingBehavior QueryStringCachingBehavior `json:"queryStringCachingBehavior,omitempty"`
	// OptimizationType - Specifies what scenario the customer wants this CDN endpoint to optimize for, e.g. Download, Media services. With this information, CDN can apply scenario driven optimization. Possible values include: 'OptimizationTypeGeneralWebDelivery', 'OptimizationTypeGeneralMediaStreaming', 'OptimizationTypeVideoOnDemandMediaStreaming', 'OptimizationTypeLargeFileDownload', 'OptimizationTypeDynamicSiteAcceleration'
	OptimizationType OptimizationType `json:"optimizationType,omitempty"`
	// ProbePath - Path to a file hosted on the origin which helps accelerate delivery of the dynamic content and calculate the most optimal routes for the CDN. This is relative to the origin path. This property is only relevant when using a single origin.
	ProbePath *string `json:"probePath,omitempty"`
	// GeoFilters - List of rules defining the user's geo access within a CDN endpoint. Each geo filter defines an access rule to a specified path or content, e.g. block APAC for path /pictures/
	GeoFilters *[]GeoFilter `json:"geoFilters,omitempty"`
	// DefaultOriginGroup - A reference to the origin group.
	DefaultOriginGroup *ResourceReference `json:"defaultOriginGroup,omitempty"`
	// URLSigningKeys - List of keys used to validate the signed URL hashes.
	URLSigningKeys *[]URLSigningKey `json:"urlSigningKeys,omitempty"`
	// DeliveryPolicy - A policy that specifies the delivery rules to be used for an endpoint.
	DeliveryPolicy *EndpointPropertiesUpdateParametersDeliveryPolicy `json:"deliveryPolicy,omitempty"`
	// WebApplicationFirewallPolicyLink - Defines the Web Application Firewall policy for the endpoint (if applicable)
	WebApplicationFirewallPolicyLink *EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink `json:"webApplicationFirewallPolicyLink,omitempty"`
}

// MarshalJSON is the custom marshaler for EndpointProperties.
func (ep EndpointProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ep.Origins != nil {
		objectMap["origins"] = ep.Origins
	}
	if ep.OriginGroups != nil {
		objectMap["originGroups"] = ep.OriginGroups
	}
	if ep.OriginPath != nil {
		objectMap["originPath"] = ep.OriginPath
	}
	if ep.ContentTypesToCompress != nil {
		objectMap["contentTypesToCompress"] = ep.ContentTypesToCompress
	}
	if ep.OriginHostHeader != nil {
		objectMap["originHostHeader"] = ep.OriginHostHeader
	}
	if ep.IsCompressionEnabled != nil {
		objectMap["isCompressionEnabled"] = ep.IsCompressionEnabled
	}
	if ep.IsHTTPAllowed != nil {
		objectMap["isHttpAllowed"] = ep.IsHTTPAllowed
	}
	if ep.IsHTTPSAllowed != nil {
		objectMap["isHttpsAllowed"] = ep.IsHTTPSAllowed
	}
	if ep.QueryStringCachingBehavior != "" {
		objectMap["queryStringCachingBehavior"] = ep.QueryStringCachingBehavior
	}
	if ep.OptimizationType != "" {
		objectMap["optimizationType"] = ep.OptimizationType
	}
	if ep.ProbePath != nil {
		objectMap["probePath"] = ep.ProbePath
	}
	if ep.GeoFilters != nil {
		objectMap["geoFilters"] = ep.GeoFilters
	}
	if ep.DefaultOriginGroup != nil {
		objectMap["defaultOriginGroup"] = ep.DefaultOriginGroup
	}
	if ep.URLSigningKeys != nil {
		objectMap["urlSigningKeys"] = ep.URLSigningKeys
	}
	if ep.DeliveryPolicy != nil {
		objectMap["deliveryPolicy"] = ep.DeliveryPolicy
	}
	if ep.WebApplicationFirewallPolicyLink != nil {
		objectMap["webApplicationFirewallPolicyLink"] = ep.WebApplicationFirewallPolicyLink
	}
	return json.Marshal(objectMap)
}

// EndpointPropertiesUpdateParameters the JSON object containing endpoint update parameters.
type EndpointPropertiesUpdateParameters struct {
	// OriginPath - A directory path on the origin that CDN can use to retrieve content from, e.g. contoso.cloudapp.net/originpath.
	OriginPath *string `json:"originPath,omitempty"`
	// ContentTypesToCompress - List of content types on which compression applies. The value should be a valid MIME type.
	ContentTypesToCompress *[]string `json:"contentTypesToCompress,omitempty"`
	// OriginHostHeader - The host header value sent to the origin with each request. This property at Endpoint is only allowed when endpoint uses single origin and can be overridden by the same property specified at origin.If you leave this blank, the request hostname determines this value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services require this host header value to match the origin hostname by default.
	OriginHostHeader *string `json:"originHostHeader,omitempty"`
	// IsCompressionEnabled - Indicates whether content compression is enabled on CDN. Default value is false. If compression is enabled, content will be served as compressed if user requests for a compressed version. Content won't be compressed on CDN when requested content is smaller than 1 byte or larger than 1 MB.
	IsCompressionEnabled *bool `json:"isCompressionEnabled,omitempty"`
	// IsHTTPAllowed - Indicates whether HTTP traffic is allowed on the endpoint. Default value is true. At least one protocol (HTTP or HTTPS) must be allowed.
	IsHTTPAllowed *bool `json:"isHttpAllowed,omitempty"`
	// IsHTTPSAllowed - Indicates whether HTTPS traffic is allowed on the endpoint. Default value is true. At least one protocol (HTTP or HTTPS) must be allowed.
	IsHTTPSAllowed *bool `json:"isHttpsAllowed,omitempty"`
	// QueryStringCachingBehavior - Defines how CDN caches requests that include query strings. You can ignore any query strings when caching, bypass caching to prevent requests that contain query strings from being cached, or cache every request with a unique URL. Possible values include: 'QueryStringCachingBehaviorIgnoreQueryString', 'QueryStringCachingBehaviorBypassCaching', 'QueryStringCachingBehaviorUseQueryString', 'QueryStringCachingBehaviorNotSet'
	QueryStringCachingBehavior QueryStringCachingBehavior `json:"queryStringCachingBehavior,omitempty"`
	// OptimizationType - Specifies what scenario the customer wants this CDN endpoint to optimize for, e.g. Download, Media services. With this information, CDN can apply scenario driven optimization. Possible values include: 'OptimizationTypeGeneralWebDelivery', 'OptimizationTypeGeneralMediaStreaming', 'OptimizationTypeVideoOnDemandMediaStreaming', 'OptimizationTypeLargeFileDownload', 'OptimizationTypeDynamicSiteAcceleration'
	OptimizationType OptimizationType `json:"optimizationType,omitempty"`
	// ProbePath - Path to a file hosted on the origin which helps accelerate delivery of the dynamic content and calculate the most optimal routes for the CDN. This is relative to the origin path. This property is only relevant when using a single origin.
	ProbePath *string `json:"probePath,omitempty"`
	// GeoFilters - List of rules defining the user's geo access within a CDN endpoint. Each geo filter defines an access rule to a specified path or content, e.g. block APAC for path /pictures/
	GeoFilters *[]GeoFilter `json:"geoFilters,omitempty"`
	// DefaultOriginGroup - A reference to the origin group.
	DefaultOriginGroup *ResourceReference `json:"defaultOriginGroup,omitempty"`
	// URLSigningKeys - List of keys used to validate the signed URL hashes.
	URLSigningKeys *[]URLSigningKey `json:"urlSigningKeys,omitempty"`
	// DeliveryPolicy - A policy that specifies the delivery rules to be used for an endpoint.
	DeliveryPolicy *EndpointPropertiesUpdateParametersDeliveryPolicy `json:"deliveryPolicy,omitempty"`
	// WebApplicationFirewallPolicyLink - Defines the Web Application Firewall policy for the endpoint (if applicable)
	WebApplicationFirewallPolicyLink *EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink `json:"webApplicationFirewallPolicyLink,omitempty"`
}

// EndpointPropertiesUpdateParametersDeliveryPolicy a policy that specifies the delivery rules to be used
// for an endpoint.
type EndpointPropertiesUpdateParametersDeliveryPolicy struct {
	// Description - User-friendly description of the policy.
	Description *string `json:"description,omitempty"`
	// Rules - A list of the delivery rules.
	Rules *[]DeliveryRule `json:"rules,omitempty"`
}

// EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink defines the Web Application Firewall
// policy for the endpoint (if applicable)
type EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink struct {
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// EndpointsCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type EndpointsCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(EndpointsClient) (Endpoint, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *EndpointsCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for EndpointsCreateFuture.Result.
func (future *EndpointsCreateFuture) result(client EndpointsClient) (e Endpoint, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.EndpointsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		e.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("cdn.EndpointsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if e.Response.Response, err = future.GetResult(sender); err == nil && e.Response.Response.StatusCode != http.StatusNoContent {
		e, err = client.CreateResponder(e.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.EndpointsCreateFuture", "Result", e.Response.Response, "Failure responding to request")
		}
	}
	return
}

// EndpointsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type EndpointsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(EndpointsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *EndpointsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for EndpointsDeleteFuture.Result.
func (future *EndpointsDeleteFuture) result(client EndpointsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.EndpointsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("cdn.EndpointsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// EndpointsLoadContentFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type EndpointsLoadContentFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(EndpointsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *EndpointsLoadContentFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for EndpointsLoadContentFuture.Result.
func (future *EndpointsLoadContentFuture) result(client EndpointsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.EndpointsLoadContentFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("cdn.EndpointsLoadContentFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// EndpointsPurgeContentFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type EndpointsPurgeContentFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(EndpointsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *EndpointsPurgeContentFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for EndpointsPurgeContentFuture.Result.
func (future *EndpointsPurgeContentFuture) result(client EndpointsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.EndpointsPurgeContentFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("cdn.EndpointsPurgeContentFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// EndpointsStartFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type EndpointsStartFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(EndpointsClient) (Endpoint, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *EndpointsStartFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for EndpointsStartFuture.Result.
func (future *EndpointsStartFuture) result(client EndpointsClient) (e Endpoint, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.EndpointsStartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		e.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("cdn.EndpointsStartFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if e.Response.Response, err = future.GetResult(sender); err == nil && e.Response.Response.StatusCode != http.StatusNoContent {
		e, err = client.StartResponder(e.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.EndpointsStartFuture", "Result", e.Response.Response, "Failure responding to request")
		}
	}
	return
}

// EndpointsStopFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type EndpointsStopFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(EndpointsClient) (Endpoint, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *EndpointsStopFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for EndpointsStopFuture.Result.
func (future *EndpointsStopFuture) result(client EndpointsClient) (e Endpoint, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.EndpointsStopFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		e.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("cdn.EndpointsStopFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if e.Response.Response, err = future.GetResult(sender); err == nil && e.Response.Response.StatusCode != http.StatusNoContent {
		e, err = client.StopResponder(e.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.EndpointsStopFuture", "Result", e.Response.Response, "Failure responding to request")
		}
	}
	return
}

// EndpointsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type EndpointsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(EndpointsClient) (Endpoint, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *EndpointsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for EndpointsUpdateFuture.Result.
func (future *EndpointsUpdateFuture) result(client EndpointsClient) (e Endpoint, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.EndpointsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		e.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("cdn.EndpointsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if e.Response.Response, err = future.GetResult(sender); err == nil && e.Response.Response.StatusCode != http.StatusNoContent {
		e, err = client.UpdateResponder(e.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.EndpointsUpdateFuture", "Result", e.Response.Response, "Failure responding to request")
		}
	}
	return
}

// EndpointType defines the ARM Resource ID for the linked endpoints
type EndpointType struct {
	// ID - ARM Resource ID string.
	ID *string `json:"id,omitempty"`
}

// EndpointUpdateParameters properties required to create or update an endpoint.
type EndpointUpdateParameters struct {
	// Tags - Endpoint tags.
	Tags                                map[string]*string `json:"tags"`
	*EndpointPropertiesUpdateParameters `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for EndpointUpdateParameters.
func (eup EndpointUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if eup.Tags != nil {
		objectMap["tags"] = eup.Tags
	}
	if eup.EndpointPropertiesUpdateParameters != nil {
		objectMap["properties"] = eup.EndpointPropertiesUpdateParameters
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EndpointUpdateParameters struct.
func (eup *EndpointUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				eup.Tags = tags
			}
		case "properties":
			if v != nil {
				var endpointPropertiesUpdateParameters EndpointPropertiesUpdateParameters
				err = json.Unmarshal(*v, &endpointPropertiesUpdateParameters)
				if err != nil {
					return err
				}
				eup.EndpointPropertiesUpdateParameters = &endpointPropertiesUpdateParameters
			}
		}
	}

	return nil
}

// ErrorAdditionalInfo the resource management error additional info.
type ErrorAdditionalInfo struct {
	// Type - READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty"`
	// Info - READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorAdditionalInfo.
func (eai ErrorAdditionalInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorDetail the error detail.
type ErrorDetail struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
	// Target - READ-ONLY; The error target.
	Target *string `json:"target,omitempty"`
	// Details - READ-ONLY; The error details.
	Details *[]ErrorDetail `json:"details,omitempty"`
	// AdditionalInfo - READ-ONLY; The error additional info.
	AdditionalInfo *[]ErrorAdditionalInfo `json:"additionalInfo,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorDetail.
func (ed ErrorDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorResponse error response indicates Azure Front Door Standard or Azure Front Door Premium or CDN
// service is not able to process the incoming request. The reason is provided in the error message.
type ErrorResponse struct {
	// Error - The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// GeoFilter rules defining user's geo access within a CDN endpoint.
type GeoFilter struct {
	// RelativePath - Relative path applicable to geo filter. (e.g. '/mypictures', '/mypicture/kitty.jpg', and etc.)
	RelativePath *string `json:"relativePath,omitempty"`
	// Action - Action of the geo filter, i.e. allow or block access. Possible values include: 'GeoFilterActionsBlock', 'GeoFilterActionsAllow'
	Action GeoFilterActions `json:"action,omitempty"`
	// CountryCodes - Two letter country or region codes defining user country or region access in a geo filter, e.g. AU, MX, US.
	CountryCodes *[]string `json:"countryCodes,omitempty"`
}

// HeaderActionParameters defines the parameters for the request header action.
type HeaderActionParameters struct {
	TypeName *string `json:"typeName,omitempty"`
	// HeaderAction - Action to perform. Possible values include: 'HeaderActionAppend', 'HeaderActionOverwrite', 'HeaderActionDelete'
	HeaderAction HeaderAction `json:"headerAction,omitempty"`
	// HeaderName - Name of the header to modify
	HeaderName *string `json:"headerName,omitempty"`
	// Value - Value for the specified action
	Value *string `json:"value,omitempty"`
}

// HealthProbeParameters the JSON object that contains the properties to send health probes to origin.
type HealthProbeParameters struct {
	// ProbePath - The path relative to the origin that is used to determine the health of the origin.
	ProbePath *string `json:"probePath,omitempty"`
	// ProbeRequestType - The type of health probe request that is made. Possible values include: 'HealthProbeRequestTypeNotSet', 'HealthProbeRequestTypeGET', 'HealthProbeRequestTypeHEAD'
	ProbeRequestType HealthProbeRequestType `json:"probeRequestType,omitempty"`
	// ProbeProtocol - Protocol to use for health probe. Possible values include: 'ProbeProtocolNotSet', 'ProbeProtocolHTTP', 'ProbeProtocolHTTPS'
	ProbeProtocol ProbeProtocol `json:"probeProtocol,omitempty"`
	// ProbeIntervalInSeconds - The number of seconds between health probes.Default is 240sec.
	ProbeIntervalInSeconds *int32 `json:"probeIntervalInSeconds,omitempty"`
}

// HostNameMatchConditionParameters defines the parameters for HostName match conditions
type HostNameMatchConditionParameters struct {
	TypeName *string `json:"typeName,omitempty"`
	// Operator - Describes operator to be matched. Possible values include: 'HostNameOperatorAny', 'HostNameOperatorEqual', 'HostNameOperatorContains', 'HostNameOperatorBeginsWith', 'HostNameOperatorEndsWith', 'HostNameOperatorLessThan', 'HostNameOperatorLessThanOrEqual', 'HostNameOperatorGreaterThan', 'HostNameOperatorGreaterThanOrEqual', 'HostNameOperatorRegEx'
	Operator HostNameOperator `json:"operator,omitempty"`
	// NegateCondition - Describes if this is negate condition or not
	NegateCondition *bool `json:"negateCondition,omitempty"`
	// MatchValues - The match value for the condition of the delivery rule
	MatchValues *[]string `json:"matchValues,omitempty"`
	// Transforms - List of transforms
	Transforms *[]Transform `json:"transforms,omitempty"`
}

// HTTPErrorRangeParameters the JSON object that represents the range for http status codes
type HTTPErrorRangeParameters struct {
	// Begin - The inclusive start of the http status code range.
	Begin *int32 `json:"begin,omitempty"`
	// End - The inclusive end of the http status code range.
	End *int32 `json:"end,omitempty"`
}

// HTTPVersionMatchConditionParameters defines the parameters for HttpVersion match conditions
type HTTPVersionMatchConditionParameters struct {
	TypeName *string `json:"typeName,omitempty"`
	// Operator - Describes operator to be matched
	Operator *string `json:"operator,omitempty"`
	// NegateCondition - Describes if this is negate condition or not
	NegateCondition *bool `json:"negateCondition,omitempty"`
	// MatchValues - The match value for the condition of the delivery rule
	MatchValues *[]string `json:"matchValues,omitempty"`
	// Transforms - List of transforms
	Transforms *[]Transform `json:"transforms,omitempty"`
}

// IPAddressGroup CDN Ip address group
type IPAddressGroup struct {
	// DeliveryRegion - The delivery region of the ip address group
	DeliveryRegion *string `json:"deliveryRegion,omitempty"`
	// Ipv4Addresses - The list of ip v4 addresses.
	Ipv4Addresses *[]CidrIPAddress `json:"ipv4Addresses,omitempty"`
	// Ipv6Addresses - The list of ip v6 addresses.
	Ipv6Addresses *[]CidrIPAddress `json:"ipv6Addresses,omitempty"`
}

// IsDeviceMatchConditionParameters defines the parameters for IsDevice match conditions
type IsDeviceMatchConditionParameters struct {
	TypeName *string `json:"typeName,omitempty"`
	// Operator - Describes operator to be matched
	Operator *string `json:"operator,omitempty"`
	// NegateCondition - Describes if this is negate condition or not
	NegateCondition *bool `json:"negateCondition,omitempty"`
	// MatchValues - The match value for the condition of the delivery rule
	MatchValues *[]string `json:"matchValues,omitempty"`
	// Transforms - List of transforms
	Transforms *[]Transform `json:"transforms,omitempty"`
}

// KeyVaultCertificateSourceParameters describes the parameters for using a user's KeyVault certificate for
// securing custom domain.
type KeyVaultCertificateSourceParameters struct {
	TypeName *string `json:"typeName,omitempty"`
	// SubscriptionID - Subscription Id of the user's Key Vault containing the SSL certificate
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// ResourceGroupName - Resource group of the user's Key Vault containing the SSL certificate
	ResourceGroupName *string `json:"resourceGroupName,omitempty"`
	// VaultName - The name of the user's Key Vault containing the SSL certificate
	VaultName *string `json:"vaultName,omitempty"`
	// SecretName - The name of Key Vault Secret (representing the full certificate PFX) in Key Vault.
	SecretName *string `json:"secretName,omitempty"`
	// SecretVersion - The version(GUID) of Key Vault Secret in Key Vault.
	SecretVersion *string `json:"secretVersion,omitempty"`
	// UpdateRule - Describes the action that shall be taken when the certificate is updated in Key Vault.
	UpdateRule *string `json:"updateRule,omitempty"`
	// DeleteRule - Describes the action that shall be taken when the certificate is removed from Key Vault.
	DeleteRule *string `json:"deleteRule,omitempty"`
}

// KeyVaultSigningKeyParameters describes the parameters for using a user's KeyVault for URL Signing Key.
type KeyVaultSigningKeyParameters struct {
	TypeName *string `json:"typeName,omitempty"`
	// SubscriptionID - Subscription Id of the user's Key Vault containing the secret
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// ResourceGroupName - Resource group of the user's Key Vault containing the secret
	ResourceGroupName *string `json:"resourceGroupName,omitempty"`
	// VaultName - The name of the user's Key Vault containing the secret
	VaultName *string `json:"vaultName,omitempty"`
	// SecretName - The name of secret in Key Vault.
	SecretName *string `json:"secretName,omitempty"`
	// SecretVersion - The version(GUID) of secret in Key Vault.
	SecretVersion *string `json:"secretVersion,omitempty"`
}

// LoadBalancingSettingsParameters round-Robin load balancing settings for a backend pool
type LoadBalancingSettingsParameters struct {
	// SampleSize - The number of samples to consider for load balancing decisions
	SampleSize *int32 `json:"sampleSize,omitempty"`
	// SuccessfulSamplesRequired - The number of samples within the sample period that must succeed
	SuccessfulSamplesRequired *int32 `json:"successfulSamplesRequired,omitempty"`
	// AdditionalLatencyInMilliseconds - The additional latency in milliseconds for probes to fall into the lowest latency bucket
	AdditionalLatencyInMilliseconds *int32 `json:"additionalLatencyInMilliseconds,omitempty"`
}

// LoadParameters parameters required for content load.
type LoadParameters struct {
	// ContentPaths - The path to the content to be loaded. Path should be a relative file URL of the origin.
	ContentPaths *[]string `json:"contentPaths,omitempty"`
}

// LogSpecification log specification of operation.
type LogSpecification struct {
	// Name - Name of log specification.
	Name *string `json:"name,omitempty"`
	// DisplayName - Display name of log specification.
	DisplayName *string `json:"displayName,omitempty"`
	// BlobDuration - Blob duration of specification.
	BlobDuration *string `json:"blobDuration,omitempty"`
	// LogFilterPattern - Pattern to filter based on name
	LogFilterPattern *string `json:"logFilterPattern,omitempty"`
}

// ManagedCertificate managed Certificate used for https
type ManagedCertificate struct {
	// Type - Possible values include: 'SecretTypeURLSigningKey', 'SecretTypeCustomerCertificate', 'SecretTypeManagedCertificate', 'SecretTypeAzureFirstPartyManagedCertificate'
	Type SecretType `json:"type,omitempty"`
	// Subject - READ-ONLY; Subject name in the certificate.
	Subject *string `json:"subject,omitempty"`
	// ExpirationDate - READ-ONLY; Certificate expiration date.
	ExpirationDate *string `json:"expirationDate,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedCertificate.
func (mc ManagedCertificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mc.Type != "" {
		objectMap["type"] = mc.Type
	}
	return json.Marshal(objectMap)
}

// ManagedCertificateParameters managed Certificate used for https
type ManagedCertificateParameters struct {
	// Subject - READ-ONLY; Subject name in the certificate.
	Subject *string `json:"subject,omitempty"`
	// ExpirationDate - READ-ONLY; Certificate expiration date.
	ExpirationDate *string `json:"expirationDate,omitempty"`
	// Type - Possible values include: 'TypeBasicSecretParametersTypeSecretParameters', 'TypeBasicSecretParametersTypeURLSigningKey', 'TypeBasicSecretParametersTypeManagedCertificate', 'TypeBasicSecretParametersTypeCustomerCertificate', 'TypeBasicSecretParametersTypeAzureFirstPartyManagedCertificate'
	Type TypeBasicSecretParameters `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedCertificateParameters.
func (mcp ManagedCertificateParameters) MarshalJSON() ([]byte, error) {
	mcp.Type = TypeBasicSecretParametersTypeManagedCertificate
	objectMap := make(map[string]interface{})
	if mcp.Type != "" {
		objectMap["type"] = mcp.Type
	}
	return json.Marshal(objectMap)
}

// AsURLSigningKeyParameters is the BasicSecretParameters implementation for ManagedCertificateParameters.
func (mcp ManagedCertificateParameters) AsURLSigningKeyParameters() (*URLSigningKeyParameters, bool) {
	return nil, false
}

// AsManagedCertificateParameters is the BasicSecretParameters implementation for ManagedCertificateParameters.
func (mcp ManagedCertificateParameters) AsManagedCertificateParameters() (*ManagedCertificateParameters, bool) {
	return &mcp, true
}

// AsCustomerCertificateParameters is the BasicSecretParameters implementation for ManagedCertificateParameters.
func (mcp ManagedCertificateParameters) AsCustomerCertificateParameters() (*CustomerCertificateParameters, bool) {
	return nil, false
}

// AsAzureFirstPartyManagedCertificateParameters is the BasicSecretParameters implementation for ManagedCertificateParameters.
func (mcp ManagedCertificateParameters) AsAzureFirstPartyManagedCertificateParameters() (*AzureFirstPartyManagedCertificateParameters, bool) {
	return nil, false
}

// AsSecretParameters is the BasicSecretParameters implementation for ManagedCertificateParameters.
func (mcp ManagedCertificateParameters) AsSecretParameters() (*SecretParameters, bool) {
	return nil, false
}

// AsBasicSecretParameters is the BasicSecretParameters implementation for ManagedCertificateParameters.
func (mcp ManagedCertificateParameters) AsBasicSecretParameters() (BasicSecretParameters, bool) {
	return &mcp, true
}

// ManagedHTTPSParameters defines the certificate source parameters using CDN managed certificate for
// enabling SSL.
type ManagedHTTPSParameters struct {
	// CertificateSourceParameters - Defines the certificate source parameters using CDN managed certificate for enabling SSL.
	CertificateSourceParameters *CertificateSourceParameters `json:"certificateSourceParameters,omitempty"`
	// ProtocolType - Defines the TLS extension protocol that is used for secure delivery. Possible values include: 'ProtocolTypeServerNameIndication', 'ProtocolTypeIPBased'
	ProtocolType ProtocolType `json:"protocolType,omitempty"`
	// MinimumTLSVersion - TLS protocol version that will be used for Https. Possible values include: 'MinimumTLSVersionNone', 'MinimumTLSVersionTLS10', 'MinimumTLSVersionTLS12'
	MinimumTLSVersion MinimumTLSVersion `json:"minimumTlsVersion,omitempty"`
	// CertificateSource - Possible values include: 'CertificateSourceCustomDomainHTTPSParameters', 'CertificateSourceAzureKeyVault', 'CertificateSourceCdn'
	CertificateSource CertificateSource `json:"certificateSource,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedHTTPSParameters.
func (mhp ManagedHTTPSParameters) MarshalJSON() ([]byte, error) {
	mhp.CertificateSource = CertificateSourceCdn
	objectMap := make(map[string]interface{})
	if mhp.CertificateSourceParameters != nil {
		objectMap["certificateSourceParameters"] = mhp.CertificateSourceParameters
	}
	if mhp.ProtocolType != "" {
		objectMap["protocolType"] = mhp.ProtocolType
	}
	if mhp.MinimumTLSVersion != "" {
		objectMap["minimumTlsVersion"] = mhp.MinimumTLSVersion
	}
	if mhp.CertificateSource != "" {
		objectMap["certificateSource"] = mhp.CertificateSource
	}
	return json.Marshal(objectMap)
}

// AsUserManagedHTTPSParameters is the BasicCustomDomainHTTPSParameters implementation for ManagedHTTPSParameters.
func (mhp ManagedHTTPSParameters) AsUserManagedHTTPSParameters() (*UserManagedHTTPSParameters, bool) {
	return nil, false
}

// AsManagedHTTPSParameters is the BasicCustomDomainHTTPSParameters implementation for ManagedHTTPSParameters.
func (mhp ManagedHTTPSParameters) AsManagedHTTPSParameters() (*ManagedHTTPSParameters, bool) {
	return &mhp, true
}

// AsCustomDomainHTTPSParameters is the BasicCustomDomainHTTPSParameters implementation for ManagedHTTPSParameters.
func (mhp ManagedHTTPSParameters) AsCustomDomainHTTPSParameters() (*CustomDomainHTTPSParameters, bool) {
	return nil, false
}

// AsBasicCustomDomainHTTPSParameters is the BasicCustomDomainHTTPSParameters implementation for ManagedHTTPSParameters.
func (mhp ManagedHTTPSParameters) AsBasicCustomDomainHTTPSParameters() (BasicCustomDomainHTTPSParameters, bool) {
	return &mhp, true
}

// ManagedRuleDefinition describes a managed rule definition.
type ManagedRuleDefinition struct {
	// RuleID - READ-ONLY; Identifier for the managed rule.
	RuleID *string `json:"ruleId,omitempty"`
	// Description - READ-ONLY; Describes the functionality of the managed rule.
	Description *string `json:"description,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedRuleDefinition.
func (mrd ManagedRuleDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ManagedRuleGroupDefinition describes a managed rule group.
type ManagedRuleGroupDefinition struct {
	// RuleGroupName - READ-ONLY; Name of the managed rule group.
	RuleGroupName *string `json:"ruleGroupName,omitempty"`
	// Description - READ-ONLY; Description of the managed rule group.
	Description *string `json:"description,omitempty"`
	// Rules - READ-ONLY; List of rules within the managed rule group.
	Rules *[]ManagedRuleDefinition `json:"rules,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedRuleGroupDefinition.
func (mrgd ManagedRuleGroupDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ManagedRuleGroupOverride defines a managed rule group override setting.
type ManagedRuleGroupOverride struct {
	// RuleGroupName - Describes the managed rule group within the rule set to override
	RuleGroupName *string `json:"ruleGroupName,omitempty"`
	// Rules - List of rules that will be disabled. If none specified, all rules in the group will be disabled.
	Rules *[]ManagedRuleOverride `json:"rules,omitempty"`
}

// ManagedRuleOverride defines a managed rule group override setting.
type ManagedRuleOverride struct {
	// RuleID - Identifier for the managed rule.
	RuleID *string `json:"ruleId,omitempty"`
	// EnabledState - Describes if the managed rule is in enabled or disabled state. Defaults to Disabled if not specified. Possible values include: 'ManagedRuleEnabledStateDisabled', 'ManagedRuleEnabledStateEnabled'
	EnabledState ManagedRuleEnabledState `json:"enabledState,omitempty"`
	// Action - Describes the override action to be applied when rule matches. Possible values include: 'ActionTypeAllow', 'ActionTypeBlock', 'ActionTypeLog', 'ActionTypeRedirect'
	Action ActionType `json:"action,omitempty"`
}

// ManagedRuleSet defines a managed rule set.
type ManagedRuleSet struct {
	// RuleSetType - Defines the rule set type to use.
	RuleSetType *string `json:"ruleSetType,omitempty"`
	// RuleSetVersion - Defines the version of the rule set to use.
	RuleSetVersion *string `json:"ruleSetVersion,omitempty"`
	// AnomalyScore - Verizon only : If the rule set supports anomaly detection mode, this describes the threshold for blocking requests.
	AnomalyScore *int32 `json:"anomalyScore,omitempty"`
	// RuleGroupOverrides - Defines the rule overrides to apply to the rule set.
	RuleGroupOverrides *[]ManagedRuleGroupOverride `json:"ruleGroupOverrides,omitempty"`
}

// ManagedRuleSetDefinition describes a managed rule set definition.
type ManagedRuleSetDefinition struct {
	// ManagedRuleSetDefinitionProperties - Describes managed rule set definition properties.
	*ManagedRuleSetDefinitionProperties `json:"properties,omitempty"`
	// Sku - The pricing tier (defines a CDN provider, feature list and rate) of the CdnWebApplicationFirewallPolicy.
	Sku *Sku `json:"sku,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedRuleSetDefinition.
func (mrsd ManagedRuleSetDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mrsd.ManagedRuleSetDefinitionProperties != nil {
		objectMap["properties"] = mrsd.ManagedRuleSetDefinitionProperties
	}
	if mrsd.Sku != nil {
		objectMap["sku"] = mrsd.Sku
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedRuleSetDefinition struct.
func (mrsd *ManagedRuleSetDefinition) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var managedRuleSetDefinitionProperties ManagedRuleSetDefinitionProperties
				err = json.Unmarshal(*v, &managedRuleSetDefinitionProperties)
				if err != nil {
					return err
				}
				mrsd.ManagedRuleSetDefinitionProperties = &managedRuleSetDefinitionProperties
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				mrsd.Sku = &sku
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mrsd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mrsd.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mrsd.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				mrsd.SystemData = &systemData
			}
		}
	}

	return nil
}

// ManagedRuleSetDefinitionList list of managed rule set definitions available for use in a policy.
type ManagedRuleSetDefinitionList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of managed rule set definitions.
	Value *[]ManagedRuleSetDefinition `json:"value,omitempty"`
	// NextLink - URL to retrieve next set of managed rule set definitions.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedRuleSetDefinitionList.
func (mrsdl ManagedRuleSetDefinitionList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mrsdl.NextLink != nil {
		objectMap["nextLink"] = mrsdl.NextLink
	}
	return json.Marshal(objectMap)
}

// ManagedRuleSetDefinitionListIterator provides access to a complete listing of ManagedRuleSetDefinition
// values.
type ManagedRuleSetDefinitionListIterator struct {
	i    int
	page ManagedRuleSetDefinitionListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ManagedRuleSetDefinitionListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedRuleSetDefinitionListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ManagedRuleSetDefinitionListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ManagedRuleSetDefinitionListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ManagedRuleSetDefinitionListIterator) Response() ManagedRuleSetDefinitionList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ManagedRuleSetDefinitionListIterator) Value() ManagedRuleSetDefinition {
	if !iter.page.NotDone() {
		return ManagedRuleSetDefinition{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ManagedRuleSetDefinitionListIterator type.
func NewManagedRuleSetDefinitionListIterator(page ManagedRuleSetDefinitionListPage) ManagedRuleSetDefinitionListIterator {
	return ManagedRuleSetDefinitionListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mrsdl ManagedRuleSetDefinitionList) IsEmpty() bool {
	return mrsdl.Value == nil || len(*mrsdl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (mrsdl ManagedRuleSetDefinitionList) hasNextLink() bool {
	return mrsdl.NextLink != nil && len(*mrsdl.NextLink) != 0
}

// managedRuleSetDefinitionListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mrsdl ManagedRuleSetDefinitionList) managedRuleSetDefinitionListPreparer(ctx context.Context) (*http.Request, error) {
	if !mrsdl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mrsdl.NextLink)))
}

// ManagedRuleSetDefinitionListPage contains a page of ManagedRuleSetDefinition values.
type ManagedRuleSetDefinitionListPage struct {
	fn    func(context.Context, ManagedRuleSetDefinitionList) (ManagedRuleSetDefinitionList, error)
	mrsdl ManagedRuleSetDefinitionList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ManagedRuleSetDefinitionListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedRuleSetDefinitionListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.mrsdl)
		if err != nil {
			return err
		}
		page.mrsdl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ManagedRuleSetDefinitionListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ManagedRuleSetDefinitionListPage) NotDone() bool {
	return !page.mrsdl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ManagedRuleSetDefinitionListPage) Response() ManagedRuleSetDefinitionList {
	return page.mrsdl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ManagedRuleSetDefinitionListPage) Values() []ManagedRuleSetDefinition {
	if page.mrsdl.IsEmpty() {
		return nil
	}
	return *page.mrsdl.Value
}

// Creates a new instance of the ManagedRuleSetDefinitionListPage type.
func NewManagedRuleSetDefinitionListPage(cur ManagedRuleSetDefinitionList, getNextPage func(context.Context, ManagedRuleSetDefinitionList) (ManagedRuleSetDefinitionList, error)) ManagedRuleSetDefinitionListPage {
	return ManagedRuleSetDefinitionListPage{
		fn:    getNextPage,
		mrsdl: cur,
	}
}

// ManagedRuleSetDefinitionProperties properties for a managed rule set definition.
type ManagedRuleSetDefinitionProperties struct {
	// ProvisioningState - READ-ONLY; Provisioning state of the managed rule set.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// RuleSetType - READ-ONLY; Type of the managed rule set.
	RuleSetType *string `json:"ruleSetType,omitempty"`
	// RuleSetVersion - READ-ONLY; Version of the managed rule set type.
	RuleSetVersion *string `json:"ruleSetVersion,omitempty"`
	// RuleGroups - READ-ONLY; Rule groups of the managed rule set.
	RuleGroups *[]ManagedRuleGroupDefinition `json:"ruleGroups,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedRuleSetDefinitionProperties.
func (mrsdp ManagedRuleSetDefinitionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ManagedRuleSetList defines the list of managed rule sets for the policy.
type ManagedRuleSetList struct {
	// ManagedRuleSets - List of rule sets.
	ManagedRuleSets *[]ManagedRuleSet `json:"managedRuleSets,omitempty"`
}

// MatchCondition define match conditions
type MatchCondition struct {
	// MatchVariable - Match variable to compare against. Possible values include: 'WafMatchVariableRemoteAddr', 'WafMatchVariableSocketAddr', 'WafMatchVariableRequestMethod', 'WafMatchVariableRequestHeader', 'WafMatchVariableRequestURI', 'WafMatchVariableQueryString', 'WafMatchVariableRequestBody', 'WafMatchVariableCookies', 'WafMatchVariablePostArgs'
	MatchVariable WafMatchVariable `json:"matchVariable,omitempty"`
	// Selector - Selector can used to match a specific key for QueryString, Cookies, RequestHeader or PostArgs.
	Selector *string `json:"selector,omitempty"`
	// Operator - Describes operator to be matched. Possible values include: 'OperatorAny', 'OperatorIPMatch', 'OperatorGeoMatch', 'OperatorEqual', 'OperatorContains', 'OperatorLessThan', 'OperatorGreaterThan', 'OperatorLessThanOrEqual', 'OperatorGreaterThanOrEqual', 'OperatorBeginsWith', 'OperatorEndsWith', 'OperatorRegEx'
	Operator Operator `json:"operator,omitempty"`
	// NegateCondition - Describes if the result of this condition should be negated.
	NegateCondition *bool `json:"negateCondition,omitempty"`
	// MatchValue - List of possible match values.
	MatchValue *[]string `json:"matchValue,omitempty"`
	// Transforms - List of transforms.
	Transforms *[]TransformType `json:"transforms,omitempty"`
}

// MetricAvailability retention policy of a resource metric.
type MetricAvailability struct {
	TimeGrain    *string `json:"timeGrain,omitempty"`
	BlobDuration *string `json:"blobDuration,omitempty"`
}

// MetricSpecification metric specification of operation.
type MetricSpecification struct {
	// Name - Name of metric specification.
	Name *string `json:"name,omitempty"`
	// DisplayName - Display name of metric specification.
	DisplayName *string `json:"displayName,omitempty"`
	// DisplayDescription - Display description of metric specification.
	DisplayDescription *string `json:"displayDescription,omitempty"`
	// Unit - The metric unit. Possible values include: 'Bytes', 'Count', 'Milliseconds'.
	Unit *string `json:"unit,omitempty"`
	// AggregationType - The metric aggregation type. Possible values include: 'Average', 'Count', 'Total'.
	AggregationType *string `json:"aggregationType,omitempty"`
	// Availabilities - Retention policies of a resource metric.
	Availabilities *[]MetricAvailability `json:"availabilities,omitempty"`
	// SupportedTimeGrainTypes - The supported time grain types for the metrics.
	SupportedTimeGrainTypes *[]string `json:"supportedTimeGrainTypes,omitempty"`
	// Dimensions - The dimensions of metric
	Dimensions *[]DimensionProperties `json:"dimensions,omitempty"`
	// FillGapWithZero - Property to specify whether to fill gap with zero.
	FillGapWithZero *bool `json:"fillGapWithZero,omitempty"`
	// MetricFilterPattern - Pattern to filter based on name
	MetricFilterPattern *string `json:"metricFilterPattern,omitempty"`
	// IsInternal - Property to specify metric is internal or not.
	IsInternal *bool `json:"isInternal,omitempty"`
}

// MetricsResponse metrics Response
type MetricsResponse struct {
	autorest.Response `json:"-"`
	DateTimeBegin     *date.Time `json:"dateTimeBegin,omitempty"`
	DateTimeEnd       *date.Time `json:"dateTimeEnd,omitempty"`
	// Granularity - Possible values include: 'GranularityPT5M', 'GranularityPT1H', 'GranularityP1D'
	Granularity Granularity                  `json:"granularity,omitempty"`
	Series      *[]MetricsResponseSeriesItem `json:"series,omitempty"`
}

// MetricsResponseSeriesItem ...
type MetricsResponseSeriesItem struct {
	Metric *string `json:"metric,omitempty"`
	// Unit - Possible values include: 'UnitCount', 'UnitBytes', 'UnitBitsPerSecond', 'UnitMilliSeconds'
	Unit   Unit                                   `json:"unit,omitempty"`
	Groups *[]MetricsResponseSeriesItemGroupsItem `json:"groups,omitempty"`
	Data   *[]MetricsResponseSeriesItemDataItem   `json:"data,omitempty"`
}

// MetricsResponseSeriesItemDataItem ...
type MetricsResponseSeriesItemDataItem struct {
	DateTime *date.Time `json:"dateTime,omitempty"`
	Value    *float64   `json:"value,omitempty"`
}

// MetricsResponseSeriesItemGroupsItem ...
type MetricsResponseSeriesItemGroupsItem struct {
	Name  *string `json:"name,omitempty"`
	Value *string `json:"value,omitempty"`
}

// Operation CDN REST API operation
type Operation struct {
	// Name - READ-ONLY; Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// IsDataAction - Indicates whether the operation is a data action
	IsDataAction *bool `json:"isDataAction,omitempty"`
	// Display - The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`
	// Origin - READ-ONLY; The origin of operations.
	Origin *string `json:"origin,omitempty"`
	// OperationProperties - Properties of operation, include metric specifications.
	*OperationProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.IsDataAction != nil {
		objectMap["isDataAction"] = o.IsDataAction
	}
	if o.Display != nil {
		objectMap["display"] = o.Display
	}
	if o.OperationProperties != nil {
		objectMap["properties"] = o.OperationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Operation struct.
func (o *Operation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				o.Name = &name
			}
		case "isDataAction":
			if v != nil {
				var isDataAction bool
				err = json.Unmarshal(*v, &isDataAction)
				if err != nil {
					return err
				}
				o.IsDataAction = &isDataAction
			}
		case "display":
			if v != nil {
				var display OperationDisplay
				err = json.Unmarshal(*v, &display)
				if err != nil {
					return err
				}
				o.Display = &display
			}
		case "origin":
			if v != nil {
				var origin string
				err = json.Unmarshal(*v, &origin)
				if err != nil {
					return err
				}
				o.Origin = &origin
			}
		case "properties":
			if v != nil {
				var operationProperties OperationProperties
				err = json.Unmarshal(*v, &operationProperties)
				if err != nil {
					return err
				}
				o.OperationProperties = &operationProperties
			}
		}
	}

	return nil
}

// OperationDisplay the object that represents the operation.
type OperationDisplay struct {
	// Provider - READ-ONLY; Service provider: Microsoft.Cdn
	Provider *string `json:"provider,omitempty"`
	// Resource - READ-ONLY; Resource on which the operation is performed: Profile, endpoint, etc.
	Resource *string `json:"resource,omitempty"`
	// Operation - READ-ONLY; Operation type: Read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`
	// Description - READ-ONLY; Description of operation.
	Description *string `json:"description,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OperationProperties properties of operation, include metric specifications.
type OperationProperties struct {
	// ServiceSpecification - One property of operation, include metric specifications.
	ServiceSpecification *ServiceSpecification `json:"serviceSpecification,omitempty"`
}

// OperationsListResult result of the request to list CDN operations. It contains a list of operations and
// a URL link to get the next set of results.
type OperationsListResult struct {
	autorest.Response `json:"-"`
	// Value - List of CDN operations supported by the CDN resource provider.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationsListResultIterator provides access to a complete listing of Operation values.
type OperationsListResultIterator struct {
	i    int
	page OperationsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationsListResultIterator) Response() OperationsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationsListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationsListResultIterator type.
func NewOperationsListResultIterator(page OperationsListResultPage) OperationsListResultIterator {
	return OperationsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationsListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationsListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationsListResult) operationsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationsListResultPage contains a page of Operation values.
type OperationsListResultPage struct {
	fn  func(context.Context, OperationsListResult) (OperationsListResult, error)
	olr OperationsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationsListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationsListResultPage) Response() OperationsListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationsListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationsListResultPage type.
func NewOperationsListResultPage(cur OperationsListResult, getNextPage func(context.Context, OperationsListResult) (OperationsListResult, error)) OperationsListResultPage {
	return OperationsListResultPage{
		fn:  getNextPage,
		olr: cur,
	}
}

// Origin CDN origin is the source of the content being delivered via CDN. When the edge nodes represented
// by an endpoint do not have the requested content cached, they attempt to fetch it from one or more of
// the configured origins.
type Origin struct {
	autorest.Response `json:"-"`
	*OriginProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for Origin.
func (o Origin) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.OriginProperties != nil {
		objectMap["properties"] = o.OriginProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Origin struct.
func (o *Origin) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var originProperties OriginProperties
				err = json.Unmarshal(*v, &originProperties)
				if err != nil {
					return err
				}
				o.OriginProperties = &originProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				o.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				o.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				o.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				o.SystemData = &systemData
			}
		}
	}

	return nil
}

// OriginGroup origin group comprising of origins is used for load balancing to origins when the content
// cannot be served from CDN.
type OriginGroup struct {
	autorest.Response      `json:"-"`
	*OriginGroupProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for OriginGroup.
func (og OriginGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if og.OriginGroupProperties != nil {
		objectMap["properties"] = og.OriginGroupProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for OriginGroup struct.
func (og *OriginGroup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var originGroupProperties OriginGroupProperties
				err = json.Unmarshal(*v, &originGroupProperties)
				if err != nil {
					return err
				}
				og.OriginGroupProperties = &originGroupProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				og.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				og.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				og.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				og.SystemData = &systemData
			}
		}
	}

	return nil
}

// OriginGroupListResult result of the request to list origin groups. It contains a list of origin groups
// objects and a URL link to get the next set of results.
type OriginGroupListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of CDN origin groups within an endpoint
	Value *[]OriginGroup `json:"value,omitempty"`
	// NextLink - URL to get the next set of origin objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for OriginGroupListResult.
func (oglr OriginGroupListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if oglr.NextLink != nil {
		objectMap["nextLink"] = oglr.NextLink
	}
	return json.Marshal(objectMap)
}

// OriginGroupListResultIterator provides access to a complete listing of OriginGroup values.
type OriginGroupListResultIterator struct {
	i    int
	page OriginGroupListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OriginGroupListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OriginGroupListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OriginGroupListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OriginGroupListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OriginGroupListResultIterator) Response() OriginGroupListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OriginGroupListResultIterator) Value() OriginGroup {
	if !iter.page.NotDone() {
		return OriginGroup{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OriginGroupListResultIterator type.
func NewOriginGroupListResultIterator(page OriginGroupListResultPage) OriginGroupListResultIterator {
	return OriginGroupListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (oglr OriginGroupListResult) IsEmpty() bool {
	return oglr.Value == nil || len(*oglr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (oglr OriginGroupListResult) hasNextLink() bool {
	return oglr.NextLink != nil && len(*oglr.NextLink) != 0
}

// originGroupListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (oglr OriginGroupListResult) originGroupListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !oglr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(oglr.NextLink)))
}

// OriginGroupListResultPage contains a page of OriginGroup values.
type OriginGroupListResultPage struct {
	fn   func(context.Context, OriginGroupListResult) (OriginGroupListResult, error)
	oglr OriginGroupListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OriginGroupListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OriginGroupListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.oglr)
		if err != nil {
			return err
		}
		page.oglr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OriginGroupListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OriginGroupListResultPage) NotDone() bool {
	return !page.oglr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OriginGroupListResultPage) Response() OriginGroupListResult {
	return page.oglr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OriginGroupListResultPage) Values() []OriginGroup {
	if page.oglr.IsEmpty() {
		return nil
	}
	return *page.oglr.Value
}

// Creates a new instance of the OriginGroupListResultPage type.
func NewOriginGroupListResultPage(cur OriginGroupListResult, getNextPage func(context.Context, OriginGroupListResult) (OriginGroupListResult, error)) OriginGroupListResultPage {
	return OriginGroupListResultPage{
		fn:   getNextPage,
		oglr: cur,
	}
}

// OriginGroupOverride defines the parameters for the origin group override configuration.
type OriginGroupOverride struct {
	// OriginGroup - defines the OriginGroup that would override the DefaultOriginGroup on route.
	OriginGroup *ResourceReference `json:"originGroup,omitempty"`
	// ForwardingProtocol - Protocol this rule will use when forwarding traffic to backends. Possible values include: 'ForwardingProtocolHTTPOnly', 'ForwardingProtocolHTTPSOnly', 'ForwardingProtocolMatchRequest'
	ForwardingProtocol ForwardingProtocol `json:"forwardingProtocol,omitempty"`
}

// OriginGroupOverrideAction defines the origin group override action for the delivery rule.
type OriginGroupOverrideAction struct {
	// Parameters - Defines the parameters for the action.
	Parameters *OriginGroupOverrideActionParameters `json:"parameters,omitempty"`
	// Name - Possible values include: 'NameBasicDeliveryRuleActionNameDeliveryRuleAction', 'NameBasicDeliveryRuleActionNameRouteConfigurationOverride', 'NameBasicDeliveryRuleActionNameCacheKeyQueryString', 'NameBasicDeliveryRuleActionNameCacheExpiration', 'NameBasicDeliveryRuleActionNameModifyResponseHeader', 'NameBasicDeliveryRuleActionNameModifyRequestHeader', 'NameBasicDeliveryRuleActionNameURLRewrite', 'NameBasicDeliveryRuleActionNameOriginGroupOverride', 'NameBasicDeliveryRuleActionNameURLSigning', 'NameBasicDeliveryRuleActionNameURLRedirect'
	Name NameBasicDeliveryRuleAction `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for OriginGroupOverrideAction.
func (ogoa OriginGroupOverrideAction) MarshalJSON() ([]byte, error) {
	ogoa.Name = NameBasicDeliveryRuleActionNameOriginGroupOverride
	objectMap := make(map[string]interface{})
	if ogoa.Parameters != nil {
		objectMap["parameters"] = ogoa.Parameters
	}
	if ogoa.Name != "" {
		objectMap["name"] = ogoa.Name
	}
	return json.Marshal(objectMap)
}

// AsDeliveryRuleRouteConfigurationOverrideAction is the BasicDeliveryRuleAction implementation for OriginGroupOverrideAction.
func (ogoa OriginGroupOverrideAction) AsDeliveryRuleRouteConfigurationOverrideAction() (*DeliveryRuleRouteConfigurationOverrideAction, bool) {
	return nil, false
}

// AsDeliveryRuleCacheKeyQueryStringAction is the BasicDeliveryRuleAction implementation for OriginGroupOverrideAction.
func (ogoa OriginGroupOverrideAction) AsDeliveryRuleCacheKeyQueryStringAction() (*DeliveryRuleCacheKeyQueryStringAction, bool) {
	return nil, false
}

// AsDeliveryRuleCacheExpirationAction is the BasicDeliveryRuleAction implementation for OriginGroupOverrideAction.
func (ogoa OriginGroupOverrideAction) AsDeliveryRuleCacheExpirationAction() (*DeliveryRuleCacheExpirationAction, bool) {
	return nil, false
}

// AsDeliveryRuleResponseHeaderAction is the BasicDeliveryRuleAction implementation for OriginGroupOverrideAction.
func (ogoa OriginGroupOverrideAction) AsDeliveryRuleResponseHeaderAction() (*DeliveryRuleResponseHeaderAction, bool) {
	return nil, false
}

// AsDeliveryRuleRequestHeaderAction is the BasicDeliveryRuleAction implementation for OriginGroupOverrideAction.
func (ogoa OriginGroupOverrideAction) AsDeliveryRuleRequestHeaderAction() (*DeliveryRuleRequestHeaderAction, bool) {
	return nil, false
}

// AsURLRewriteAction is the BasicDeliveryRuleAction implementation for OriginGroupOverrideAction.
func (ogoa OriginGroupOverrideAction) AsURLRewriteAction() (*URLRewriteAction, bool) {
	return nil, false
}

// AsOriginGroupOverrideAction is the BasicDeliveryRuleAction implementation for OriginGroupOverrideAction.
func (ogoa OriginGroupOverrideAction) AsOriginGroupOverrideAction() (*OriginGroupOverrideAction, bool) {
	return &ogoa, true
}

// AsURLSigningAction is the BasicDeliveryRuleAction implementation for OriginGroupOverrideAction.
func (ogoa OriginGroupOverrideAction) AsURLSigningAction() (*URLSigningAction, bool) {
	return nil, false
}

// AsURLRedirectAction is the BasicDeliveryRuleAction implementation for OriginGroupOverrideAction.
func (ogoa OriginGroupOverrideAction) AsURLRedirectAction() (*URLRedirectAction, bool) {
	return nil, false
}

// AsDeliveryRuleAction is the BasicDeliveryRuleAction implementation for OriginGroupOverrideAction.
func (ogoa OriginGroupOverrideAction) AsDeliveryRuleAction() (*DeliveryRuleAction, bool) {
	return nil, false
}

// AsBasicDeliveryRuleAction is the BasicDeliveryRuleAction implementation for OriginGroupOverrideAction.
func (ogoa OriginGroupOverrideAction) AsBasicDeliveryRuleAction() (BasicDeliveryRuleAction, bool) {
	return &ogoa, true
}

// OriginGroupOverrideActionParameters defines the parameters for the origin group override action.
type OriginGroupOverrideActionParameters struct {
	TypeName *string `json:"typeName,omitempty"`
	// OriginGroup - defines the OriginGroup that would override the DefaultOriginGroup.
	OriginGroup *ResourceReference `json:"originGroup,omitempty"`
}

// OriginGroupProperties the JSON object that contains the properties of the origin group.
type OriginGroupProperties struct {
	// ResourceState - READ-ONLY; Resource status of the origin group. Possible values include: 'OriginGroupResourceStateCreating', 'OriginGroupResourceStateActive', 'OriginGroupResourceStateDeleting'
	ResourceState OriginGroupResourceState `json:"resourceState,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning status of the origin group.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// HealthProbeSettings - Health probe settings to the origin that is used to determine the health of the origin.
	HealthProbeSettings *HealthProbeParameters `json:"healthProbeSettings,omitempty"`
	// Origins - The source of the content being delivered via CDN within given origin group.
	Origins *[]ResourceReference `json:"origins,omitempty"`
	// TrafficRestorationTimeToHealedOrNewEndpointsInMinutes - Time in minutes to shift the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new endpoint is added. Default is 10 mins. This property is currently not supported.
	TrafficRestorationTimeToHealedOrNewEndpointsInMinutes *int32 `json:"trafficRestorationTimeToHealedOrNewEndpointsInMinutes,omitempty"`
	// ResponseBasedOriginErrorDetectionSettings - The JSON object that contains the properties to determine origin health using real requests/responses. This property is currently not supported.
	ResponseBasedOriginErrorDetectionSettings *ResponseBasedOriginErrorDetectionParameters `json:"responseBasedOriginErrorDetectionSettings,omitempty"`
}

// MarshalJSON is the custom marshaler for OriginGroupProperties.
func (ogp OriginGroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ogp.HealthProbeSettings != nil {
		objectMap["healthProbeSettings"] = ogp.HealthProbeSettings
	}
	if ogp.Origins != nil {
		objectMap["origins"] = ogp.Origins
	}
	if ogp.TrafficRestorationTimeToHealedOrNewEndpointsInMinutes != nil {
		objectMap["trafficRestorationTimeToHealedOrNewEndpointsInMinutes"] = ogp.TrafficRestorationTimeToHealedOrNewEndpointsInMinutes
	}
	if ogp.ResponseBasedOriginErrorDetectionSettings != nil {
		objectMap["responseBasedOriginErrorDetectionSettings"] = ogp.ResponseBasedOriginErrorDetectionSettings
	}
	return json.Marshal(objectMap)
}

// OriginGroupsCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type OriginGroupsCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(OriginGroupsClient) (OriginGroup, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *OriginGroupsCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for OriginGroupsCreateFuture.Result.
func (future *OriginGroupsCreateFuture) result(client OriginGroupsClient) (og OriginGroup, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.OriginGroupsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		og.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("cdn.OriginGroupsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if og.Response.Response, err = future.GetResult(sender); err == nil && og.Response.Response.StatusCode != http.StatusNoContent {
		og, err = client.CreateResponder(og.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.OriginGroupsCreateFuture", "Result", og.Response.Response, "Failure responding to request")
		}
	}
	return
}

// OriginGroupsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type OriginGroupsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(OriginGroupsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *OriginGroupsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for OriginGroupsDeleteFuture.Result.
func (future *OriginGroupsDeleteFuture) result(client OriginGroupsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.OriginGroupsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("cdn.OriginGroupsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// OriginGroupsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type OriginGroupsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(OriginGroupsClient) (OriginGroup, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *OriginGroupsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for OriginGroupsUpdateFuture.Result.
func (future *OriginGroupsUpdateFuture) result(client OriginGroupsClient) (og OriginGroup, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.OriginGroupsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		og.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("cdn.OriginGroupsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if og.Response.Response, err = future.GetResult(sender); err == nil && og.Response.Response.StatusCode != http.StatusNoContent {
		og, err = client.UpdateResponder(og.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.OriginGroupsUpdateFuture", "Result", og.Response.Response, "Failure responding to request")
		}
	}
	return
}

// OriginGroupUpdateParameters origin group properties needed for origin group creation or update.
type OriginGroupUpdateParameters struct {
	*OriginGroupUpdatePropertiesParameters `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for OriginGroupUpdateParameters.
func (ogup OriginGroupUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ogup.OriginGroupUpdatePropertiesParameters != nil {
		objectMap["properties"] = ogup.OriginGroupUpdatePropertiesParameters
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for OriginGroupUpdateParameters struct.
func (ogup *OriginGroupUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var originGroupUpdatePropertiesParameters OriginGroupUpdatePropertiesParameters
				err = json.Unmarshal(*v, &originGroupUpdatePropertiesParameters)
				if err != nil {
					return err
				}
				ogup.OriginGroupUpdatePropertiesParameters = &originGroupUpdatePropertiesParameters
			}
		}
	}

	return nil
}

// OriginGroupUpdatePropertiesParameters the JSON object that contains the properties of the origin group.
type OriginGroupUpdatePropertiesParameters struct {
	// HealthProbeSettings - Health probe settings to the origin that is used to determine the health of the origin.
	HealthProbeSettings *HealthProbeParameters `json:"healthProbeSettings,omitempty"`
	// Origins - The source of the content being delivered via CDN within given origin group.
	Origins *[]ResourceReference `json:"origins,omitempty"`
	// TrafficRestorationTimeToHealedOrNewEndpointsInMinutes - Time in minutes to shift the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new endpoint is added. Default is 10 mins. This property is currently not supported.
	TrafficRestorationTimeToHealedOrNewEndpointsInMinutes *int32 `json:"trafficRestorationTimeToHealedOrNewEndpointsInMinutes,omitempty"`
	// ResponseBasedOriginErrorDetectionSettings - The JSON object that contains the properties to determine origin health using real requests/responses. This property is currently not supported.
	ResponseBasedOriginErrorDetectionSettings *ResponseBasedOriginErrorDetectionParameters `json:"responseBasedOriginErrorDetectionSettings,omitempty"`
}

// OriginListResult result of the request to list origins. It contains a list of origin objects and a URL
// link to get the next set of results.
type OriginListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of CDN origins within an endpoint
	Value *[]Origin `json:"value,omitempty"`
	// NextLink - URL to get the next set of origin objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for OriginListResult.
func (olr OriginListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if olr.NextLink != nil {
		objectMap["nextLink"] = olr.NextLink
	}
	return json.Marshal(objectMap)
}

// OriginListResultIterator provides access to a complete listing of Origin values.
type OriginListResultIterator struct {
	i    int
	page OriginListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OriginListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OriginListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OriginListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OriginListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OriginListResultIterator) Response() OriginListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OriginListResultIterator) Value() Origin {
	if !iter.page.NotDone() {
		return Origin{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OriginListResultIterator type.
func NewOriginListResultIterator(page OriginListResultPage) OriginListResultIterator {
	return OriginListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OriginListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OriginListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// originListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OriginListResult) originListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OriginListResultPage contains a page of Origin values.
type OriginListResultPage struct {
	fn  func(context.Context, OriginListResult) (OriginListResult, error)
	olr OriginListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OriginListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OriginListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OriginListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OriginListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OriginListResultPage) Response() OriginListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OriginListResultPage) Values() []Origin {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OriginListResultPage type.
func NewOriginListResultPage(cur OriginListResult, getNextPage func(context.Context, OriginListResult) (OriginListResult, error)) OriginListResultPage {
	return OriginListResultPage{
		fn:  getNextPage,
		olr: cur,
	}
}

// OriginProperties the JSON object that contains the properties of the origin.
type OriginProperties struct {
	// ResourceState - READ-ONLY; Resource status of the origin. Possible values include: 'OriginResourceStateCreating', 'OriginResourceStateActive', 'OriginResourceStateDeleting'
	ResourceState OriginResourceState `json:"resourceState,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning status of the origin.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// PrivateEndpointStatus - READ-ONLY; The approval status for the connection to the Private Link. Possible values include: 'PrivateEndpointStatusPending', 'PrivateEndpointStatusApproved', 'PrivateEndpointStatusRejected', 'PrivateEndpointStatusDisconnected', 'PrivateEndpointStatusTimeout'
	PrivateEndpointStatus PrivateEndpointStatus `json:"privateEndpointStatus,omitempty"`
	// HostName - The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses are supported.This should be unique across all origins in an endpoint.
	HostName *string `json:"hostName,omitempty"`
	// HTTPPort - The value of the HTTP port. Must be between 1 and 65535.
	HTTPPort *int32 `json:"httpPort,omitempty"`
	// HTTPSPort - The value of the HTTPS port. Must be between 1 and 65535.
	HTTPSPort *int32 `json:"httpsPort,omitempty"`
	// OriginHostHeader - The host header value sent to the origin with each request. If you leave this blank, the request hostname determines this value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services require this host header value to match the origin hostname by default. This overrides the host header defined at Endpoint
	OriginHostHeader *string `json:"originHostHeader,omitempty"`
	// Priority - Priority of origin in given origin group for load balancing. Higher priorities will not be used for load balancing if any lower priority origin is healthy.Must be between 1 and 5
	Priority *int32 `json:"priority,omitempty"`
	// Weight - Weight of the origin in given origin group for load balancing. Must be between 1 and 1000
	Weight *int32 `json:"weight,omitempty"`
	// Enabled - Origin is enabled for load balancing or not
	Enabled *bool `json:"enabled,omitempty"`
	// PrivateLinkAlias - The Alias of the Private Link resource. Populating this optional field indicates that this origin is 'Private'
	PrivateLinkAlias *string `json:"privateLinkAlias,omitempty"`
	// PrivateLinkResourceID - The Resource Id of the Private Link resource. Populating this optional field indicates that this backend is 'Private'
	PrivateLinkResourceID *string `json:"privateLinkResourceId,omitempty"`
	// PrivateLinkLocation - The location of the Private Link resource. Required only if 'privateLinkResourceId' is populated
	PrivateLinkLocation *string `json:"privateLinkLocation,omitempty"`
	// PrivateLinkApprovalMessage - A custom message to be included in the approval request to connect to the Private Link.
	PrivateLinkApprovalMessage *string `json:"privateLinkApprovalMessage,omitempty"`
}

// MarshalJSON is the custom marshaler for OriginProperties.
func (op OriginProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if op.HostName != nil {
		objectMap["hostName"] = op.HostName
	}
	if op.HTTPPort != nil {
		objectMap["httpPort"] = op.HTTPPort
	}
	if op.HTTPSPort != nil {
		objectMap["httpsPort"] = op.HTTPSPort
	}
	if op.OriginHostHeader != nil {
		objectMap["originHostHeader"] = op.OriginHostHeader
	}
	if op.Priority != nil {
		objectMap["priority"] = op.Priority
	}
	if op.Weight != nil {
		objectMap["weight"] = op.Weight
	}
	if op.Enabled != nil {
		objectMap["enabled"] = op.Enabled
	}
	if op.PrivateLinkAlias != nil {
		objectMap["privateLinkAlias"] = op.PrivateLinkAlias
	}
	if op.PrivateLinkResourceID != nil {
		objectMap["privateLinkResourceId"] = op.PrivateLinkResourceID
	}
	if op.PrivateLinkLocation != nil {
		objectMap["privateLinkLocation"] = op.PrivateLinkLocation
	}
	if op.PrivateLinkApprovalMessage != nil {
		objectMap["privateLinkApprovalMessage"] = op.PrivateLinkApprovalMessage
	}
	return json.Marshal(objectMap)
}

// OriginsCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type OriginsCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(OriginsClient) (Origin, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *OriginsCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for OriginsCreateFuture.Result.
func (future *OriginsCreateFuture) result(client OriginsClient) (o Origin, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.OriginsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		o.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("cdn.OriginsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if o.Response.Response, err = future.GetResult(sender); err == nil && o.Response.Response.StatusCode != http.StatusNoContent {
		o, err = client.CreateResponder(o.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.OriginsCreateFuture", "Result", o.Response.Response, "Failure responding to request")
		}
	}
	return
}

// OriginsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type OriginsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(OriginsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *OriginsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for OriginsDeleteFuture.Result.
func (future *OriginsDeleteFuture) result(client OriginsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.OriginsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("cdn.OriginsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// OriginsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type OriginsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(OriginsClient) (Origin, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *OriginsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for OriginsUpdateFuture.Result.
func (future *OriginsUpdateFuture) result(client OriginsClient) (o Origin, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.OriginsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		o.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("cdn.OriginsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if o.Response.Response, err = future.GetResult(sender); err == nil && o.Response.Response.StatusCode != http.StatusNoContent {
		o, err = client.UpdateResponder(o.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.OriginsUpdateFuture", "Result", o.Response.Response, "Failure responding to request")
		}
	}
	return
}

// OriginUpdateParameters origin properties needed for origin update.
type OriginUpdateParameters struct {
	*OriginUpdatePropertiesParameters `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for OriginUpdateParameters.
func (oup OriginUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if oup.OriginUpdatePropertiesParameters != nil {
		objectMap["properties"] = oup.OriginUpdatePropertiesParameters
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for OriginUpdateParameters struct.
func (oup *OriginUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var originUpdatePropertiesParameters OriginUpdatePropertiesParameters
				err = json.Unmarshal(*v, &originUpdatePropertiesParameters)
				if err != nil {
					return err
				}
				oup.OriginUpdatePropertiesParameters = &originUpdatePropertiesParameters
			}
		}
	}

	return nil
}

// OriginUpdatePropertiesParameters the JSON object that contains the properties of the origin.
type OriginUpdatePropertiesParameters struct {
	// HostName - The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses are supported.This should be unique across all origins in an endpoint.
	HostName *string `json:"hostName,omitempty"`
	// HTTPPort - The value of the HTTP port. Must be between 1 and 65535.
	HTTPPort *int32 `json:"httpPort,omitempty"`
	// HTTPSPort - The value of the HTTPS port. Must be between 1 and 65535.
	HTTPSPort *int32 `json:"httpsPort,omitempty"`
	// OriginHostHeader - The host header value sent to the origin with each request. If you leave this blank, the request hostname determines this value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services require this host header value to match the origin hostname by default. This overrides the host header defined at Endpoint
	OriginHostHeader *string `json:"originHostHeader,omitempty"`
	// Priority - Priority of origin in given origin group for load balancing. Higher priorities will not be used for load balancing if any lower priority origin is healthy.Must be between 1 and 5
	Priority *int32 `json:"priority,omitempty"`
	// Weight - Weight of the origin in given origin group for load balancing. Must be between 1 and 1000
	Weight *int32 `json:"weight,omitempty"`
	// Enabled - Origin is enabled for load balancing or not
	Enabled *bool `json:"enabled,omitempty"`
	// PrivateLinkAlias - The Alias of the Private Link resource. Populating this optional field indicates that this origin is 'Private'
	PrivateLinkAlias *string `json:"privateLinkAlias,omitempty"`
	// PrivateLinkResourceID - The Resource Id of the Private Link resource. Populating this optional field indicates that this backend is 'Private'
	PrivateLinkResourceID *string `json:"privateLinkResourceId,omitempty"`
	// PrivateLinkLocation - The location of the Private Link resource. Required only if 'privateLinkResourceId' is populated
	PrivateLinkLocation *string `json:"privateLinkLocation,omitempty"`
	// PrivateLinkApprovalMessage - A custom message to be included in the approval request to connect to the Private Link.
	PrivateLinkApprovalMessage *string `json:"privateLinkApprovalMessage,omitempty"`
}

// PoliciesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type PoliciesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PoliciesClient) (WebApplicationFirewallPolicy, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PoliciesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PoliciesCreateOrUpdateFuture.Result.
func (future *PoliciesCreateOrUpdateFuture) result(client PoliciesClient) (wafp WebApplicationFirewallPolicy, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.PoliciesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		wafp.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("cdn.PoliciesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if wafp.Response.Response, err = future.GetResult(sender); err == nil && wafp.Response.Response.StatusCode != http.StatusNoContent {
		wafp, err = client.CreateOrUpdateResponder(wafp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.PoliciesCreateOrUpdateFuture", "Result", wafp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// PoliciesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type PoliciesUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PoliciesClient) (WebApplicationFirewallPolicy, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PoliciesUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PoliciesUpdateFuture.Result.
func (future *PoliciesUpdateFuture) result(client PoliciesClient) (wafp WebApplicationFirewallPolicy, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.PoliciesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		wafp.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("cdn.PoliciesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if wafp.Response.Response, err = future.GetResult(sender); err == nil && wafp.Response.Response.StatusCode != http.StatusNoContent {
		wafp, err = client.UpdateResponder(wafp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.PoliciesUpdateFuture", "Result", wafp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// PolicySettings defines contents of a web application firewall global configuration
type PolicySettings struct {
	// EnabledState - describes if the policy is in enabled state or disabled state. Possible values include: 'PolicyEnabledStateDisabled', 'PolicyEnabledStateEnabled'
	EnabledState PolicyEnabledState `json:"enabledState,omitempty"`
	// Mode - Describes if it is in detection mode or prevention mode at policy level. Possible values include: 'PolicyModePrevention', 'PolicyModeDetection'
	Mode PolicyMode `json:"mode,omitempty"`
	// DefaultRedirectURL - If action type is redirect, this field represents the default redirect URL for the client.
	DefaultRedirectURL *string `json:"defaultRedirectUrl,omitempty"`
	// DefaultCustomBlockResponseStatusCode - If the action type is block, this field defines the default customer overridable http response status code.
	DefaultCustomBlockResponseStatusCode *int32 `json:"defaultCustomBlockResponseStatusCode,omitempty"`
	// DefaultCustomBlockResponseBody - If the action type is block, customer can override the response body. The body must be specified in base64 encoding.
	DefaultCustomBlockResponseBody *string `json:"defaultCustomBlockResponseBody,omitempty"`
}

// PostArgsMatchConditionParameters defines the parameters for PostArgs match conditions
type PostArgsMatchConditionParameters struct {
	TypeName *string `json:"typeName,omitempty"`
	// Selector - Name of PostArg to be matched
	Selector *string `json:"selector,omitempty"`
	// Operator - Describes operator to be matched. Possible values include: 'PostArgsOperatorAny', 'PostArgsOperatorEqual', 'PostArgsOperatorContains', 'PostArgsOperatorBeginsWith', 'PostArgsOperatorEndsWith', 'PostArgsOperatorLessThan', 'PostArgsOperatorLessThanOrEqual', 'PostArgsOperatorGreaterThan', 'PostArgsOperatorGreaterThanOrEqual', 'PostArgsOperatorRegEx'
	Operator PostArgsOperator `json:"operator,omitempty"`
	// NegateCondition - Describes if this is negate condition or not
	NegateCondition *bool `json:"negateCondition,omitempty"`
	// MatchValues - The match value for the condition of the delivery rule
	MatchValues *[]string `json:"matchValues,omitempty"`
	// Transforms - List of transforms
	Transforms *[]Transform `json:"transforms,omitempty"`
}

// Profile a profile is a logical grouping of endpoints that share the same settings.
type Profile struct {
	autorest.Response `json:"-"`
	// Sku - The pricing tier (defines Azure Front Door Standard or Premium or a CDN provider, feature list and rate) of the profile.
	Sku *Sku `json:"sku,omitempty"`
	// Kind - READ-ONLY; Kind of the profile. Used by portal to differentiate traditional CDN profile and new AFD profile.
	Kind               *string `json:"kind,omitempty"`
	*ProfileProperties `json:"properties,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for Profile.
func (p Profile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if p.Sku != nil {
		objectMap["sku"] = p.Sku
	}
	if p.ProfileProperties != nil {
		objectMap["properties"] = p.ProfileProperties
	}
	if p.Location != nil {
		objectMap["location"] = p.Location
	}
	if p.Tags != nil {
		objectMap["tags"] = p.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Profile struct.
func (p *Profile) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				p.Sku = &sku
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				p.Kind = &kind
			}
		case "properties":
			if v != nil {
				var profileProperties ProfileProperties
				err = json.Unmarshal(*v, &profileProperties)
				if err != nil {
					return err
				}
				p.ProfileProperties = &profileProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				p.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				p.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				p.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				p.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				p.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				p.SystemData = &systemData
			}
		}
	}

	return nil
}

// ProfileListResult result of the request to list profiles. It contains a list of profile objects and a
// URL link to get the next set of results.
type ProfileListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of CDN profiles within a resource group.
	Value *[]Profile `json:"value,omitempty"`
	// NextLink - URL to get the next set of profile objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ProfileListResult.
func (plr ProfileListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plr.NextLink != nil {
		objectMap["nextLink"] = plr.NextLink
	}
	return json.Marshal(objectMap)
}

// ProfileListResultIterator provides access to a complete listing of Profile values.
type ProfileListResultIterator struct {
	i    int
	page ProfileListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ProfileListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProfileListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ProfileListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ProfileListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ProfileListResultIterator) Response() ProfileListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ProfileListResultIterator) Value() Profile {
	if !iter.page.NotDone() {
		return Profile{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ProfileListResultIterator type.
func NewProfileListResultIterator(page ProfileListResultPage) ProfileListResultIterator {
	return ProfileListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (plr ProfileListResult) IsEmpty() bool {
	return plr.Value == nil || len(*plr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (plr ProfileListResult) hasNextLink() bool {
	return plr.NextLink != nil && len(*plr.NextLink) != 0
}

// profileListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (plr ProfileListResult) profileListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !plr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(plr.NextLink)))
}

// ProfileListResultPage contains a page of Profile values.
type ProfileListResultPage struct {
	fn  func(context.Context, ProfileListResult) (ProfileListResult, error)
	plr ProfileListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ProfileListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProfileListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.plr)
		if err != nil {
			return err
		}
		page.plr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ProfileListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ProfileListResultPage) NotDone() bool {
	return !page.plr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ProfileListResultPage) Response() ProfileListResult {
	return page.plr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ProfileListResultPage) Values() []Profile {
	if page.plr.IsEmpty() {
		return nil
	}
	return *page.plr.Value
}

// Creates a new instance of the ProfileListResultPage type.
func NewProfileListResultPage(cur ProfileListResult, getNextPage func(context.Context, ProfileListResult) (ProfileListResult, error)) ProfileListResultPage {
	return ProfileListResultPage{
		fn:  getNextPage,
		plr: cur,
	}
}

// ProfileProperties the JSON object that contains the properties required to create a profile.
type ProfileProperties struct {
	// ResourceState - READ-ONLY; Resource status of the profile. Possible values include: 'ProfileResourceStateCreating', 'ProfileResourceStateActive', 'ProfileResourceStateDeleting', 'ProfileResourceStateDisabled'
	ResourceState ProfileResourceState `json:"resourceState,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning status of the profile.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// FrontDoorID - READ-ONLY; The Id of the frontdoor.
	FrontDoorID *string `json:"frontDoorId,omitempty"`
	// OriginResponseTimeoutSeconds - Send and receive timeout on forwarding request to the origin. When timeout is reached, the request fails and returns.
	OriginResponseTimeoutSeconds *int32 `json:"originResponseTimeoutSeconds,omitempty"`
}

// MarshalJSON is the custom marshaler for ProfileProperties.
func (pp ProfileProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pp.OriginResponseTimeoutSeconds != nil {
		objectMap["originResponseTimeoutSeconds"] = pp.OriginResponseTimeoutSeconds
	}
	return json.Marshal(objectMap)
}

// ProfilePropertiesUpdateParameters the JSON object containing profile update parameters.
type ProfilePropertiesUpdateParameters struct {
	// OriginResponseTimeoutSeconds - Send and receive timeout on forwarding request to the origin. When timeout is reached, the request fails and returns.
	OriginResponseTimeoutSeconds *int32 `json:"originResponseTimeoutSeconds,omitempty"`
}

// ProfilesCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ProfilesCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ProfilesClient) (Profile, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ProfilesCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ProfilesCreateFuture.Result.
func (future *ProfilesCreateFuture) result(client ProfilesClient) (p Profile, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.ProfilesCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		p.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("cdn.ProfilesCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if p.Response.Response, err = future.GetResult(sender); err == nil && p.Response.Response.StatusCode != http.StatusNoContent {
		p, err = client.CreateResponder(p.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.ProfilesCreateFuture", "Result", p.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ProfilesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ProfilesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ProfilesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ProfilesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ProfilesDeleteFuture.Result.
func (future *ProfilesDeleteFuture) result(client ProfilesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.ProfilesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("cdn.ProfilesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ProfilesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ProfilesUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ProfilesClient) (Profile, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ProfilesUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ProfilesUpdateFuture.Result.
func (future *ProfilesUpdateFuture) result(client ProfilesClient) (p Profile, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.ProfilesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		p.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("cdn.ProfilesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if p.Response.Response, err = future.GetResult(sender); err == nil && p.Response.Response.StatusCode != http.StatusNoContent {
		p, err = client.UpdateResponder(p.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.ProfilesUpdateFuture", "Result", p.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ProfileUpdateParameters properties required to update a profile.
type ProfileUpdateParameters struct {
	// Tags - Profile tags
	Tags                               map[string]*string `json:"tags"`
	*ProfilePropertiesUpdateParameters `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ProfileUpdateParameters.
func (pup ProfileUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pup.Tags != nil {
		objectMap["tags"] = pup.Tags
	}
	if pup.ProfilePropertiesUpdateParameters != nil {
		objectMap["properties"] = pup.ProfilePropertiesUpdateParameters
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ProfileUpdateParameters struct.
func (pup *ProfileUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				pup.Tags = tags
			}
		case "properties":
			if v != nil {
				var profilePropertiesUpdateParameters ProfilePropertiesUpdateParameters
				err = json.Unmarshal(*v, &profilePropertiesUpdateParameters)
				if err != nil {
					return err
				}
				pup.ProfilePropertiesUpdateParameters = &profilePropertiesUpdateParameters
			}
		}
	}

	return nil
}

// ProxyResource the resource model definition for a ARM proxy resource. It will have everything other than
// required location and tags
type ProxyResource struct {
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for ProxyResource.
func (pr ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PurgeParameters parameters required for content purge.
type PurgeParameters struct {
	// ContentPaths - The path to the content to be purged. Can describe a file path or a wild card directory.
	ContentPaths *[]string `json:"contentPaths,omitempty"`
}

// QueryStringMatchConditionParameters defines the parameters for QueryString match conditions
type QueryStringMatchConditionParameters struct {
	TypeName *string `json:"typeName,omitempty"`
	// Operator - Describes operator to be matched. Possible values include: 'QueryStringOperatorAny', 'QueryStringOperatorEqual', 'QueryStringOperatorContains', 'QueryStringOperatorBeginsWith', 'QueryStringOperatorEndsWith', 'QueryStringOperatorLessThan', 'QueryStringOperatorLessThanOrEqual', 'QueryStringOperatorGreaterThan', 'QueryStringOperatorGreaterThanOrEqual', 'QueryStringOperatorRegEx'
	Operator QueryStringOperator `json:"operator,omitempty"`
	// NegateCondition - Describes if this is negate condition or not
	NegateCondition *bool `json:"negateCondition,omitempty"`
	// MatchValues - The match value for the condition of the delivery rule
	MatchValues *[]string `json:"matchValues,omitempty"`
	// Transforms - List of transforms
	Transforms *[]Transform `json:"transforms,omitempty"`
}

// RankingsResponse rankings Response
type RankingsResponse struct {
	autorest.Response `json:"-"`
	DateTimeBegin     *date.Time                    `json:"dateTimeBegin,omitempty"`
	DateTimeEnd       *date.Time                    `json:"dateTimeEnd,omitempty"`
	Tables            *[]RankingsResponseTablesItem `json:"tables,omitempty"`
}

// RankingsResponseTablesItem ...
type RankingsResponseTablesItem struct {
	Ranking *string                               `json:"ranking,omitempty"`
	Data    *[]RankingsResponseTablesItemDataItem `json:"data,omitempty"`
}

// RankingsResponseTablesItemDataItem ...
type RankingsResponseTablesItemDataItem struct {
	Name    *string                                          `json:"name,omitempty"`
	Metrics *[]RankingsResponseTablesItemDataItemMetricsItem `json:"metrics,omitempty"`
}

// RankingsResponseTablesItemDataItemMetricsItem ...
type RankingsResponseTablesItemDataItemMetricsItem struct {
	Metric     *string  `json:"metric,omitempty"`
	Value      *int64   `json:"value,omitempty"`
	Percentage *float64 `json:"percentage,omitempty"`
}

// RateLimitRule defines a rate limiting rule that can be included in a waf policy
type RateLimitRule struct {
	// RateLimitThreshold - Defines rate limit threshold.
	RateLimitThreshold *int32 `json:"rateLimitThreshold,omitempty"`
	// RateLimitDurationInMinutes - Defines rate limit duration. Default is 1 minute.
	RateLimitDurationInMinutes *int32 `json:"rateLimitDurationInMinutes,omitempty"`
	// Name - Defines the name of the custom rule
	Name *string `json:"name,omitempty"`
	// EnabledState - Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not specified. Possible values include: 'CustomRuleEnabledStateDisabled', 'CustomRuleEnabledStateEnabled'
	EnabledState CustomRuleEnabledState `json:"enabledState,omitempty"`
	// Priority - Defines in what order this rule be evaluated in the overall list of custom rules
	Priority *int32 `json:"priority,omitempty"`
	// MatchConditions - List of match conditions.
	MatchConditions *[]MatchCondition `json:"matchConditions,omitempty"`
	// Action - Describes what action to be applied when rule matches. Possible values include: 'ActionTypeAllow', 'ActionTypeBlock', 'ActionTypeLog', 'ActionTypeRedirect'
	Action ActionType `json:"action,omitempty"`
}

// RateLimitRuleList defines contents of rate limit rules
type RateLimitRuleList struct {
	// Rules - List of rules
	Rules *[]RateLimitRule `json:"rules,omitempty"`
}

// RemoteAddressMatchConditionParameters defines the parameters for RemoteAddress match conditions
type RemoteAddressMatchConditionParameters struct {
	TypeName *string `json:"typeName,omitempty"`
	// Operator - Describes operator to be matched. Possible values include: 'RemoteAddressOperatorAny', 'RemoteAddressOperatorIPMatch', 'RemoteAddressOperatorGeoMatch'
	Operator RemoteAddressOperator `json:"operator,omitempty"`
	// NegateCondition - Describes if this is negate condition or not
	NegateCondition *bool `json:"negateCondition,omitempty"`
	// MatchValues - Match values to match against. The operator will apply to each value in here with OR semantics. If any of them match the variable with the given operator this match condition is considered a match.
	MatchValues *[]string `json:"matchValues,omitempty"`
	// Transforms - List of transforms
	Transforms *[]Transform `json:"transforms,omitempty"`
}

// RequestBodyMatchConditionParameters defines the parameters for RequestBody match conditions
type RequestBodyMatchConditionParameters struct {
	TypeName *string `json:"typeName,omitempty"`
	// Operator - Describes operator to be matched. Possible values include: 'RequestBodyOperatorAny', 'RequestBodyOperatorEqual', 'RequestBodyOperatorContains', 'RequestBodyOperatorBeginsWith', 'RequestBodyOperatorEndsWith', 'RequestBodyOperatorLessThan', 'RequestBodyOperatorLessThanOrEqual', 'RequestBodyOperatorGreaterThan', 'RequestBodyOperatorGreaterThanOrEqual', 'RequestBodyOperatorRegEx'
	Operator RequestBodyOperator `json:"operator,omitempty"`
	// NegateCondition - Describes if this is negate condition or not
	NegateCondition *bool `json:"negateCondition,omitempty"`
	// MatchValues - The match value for the condition of the delivery rule
	MatchValues *[]string `json:"matchValues,omitempty"`
	// Transforms - List of transforms
	Transforms *[]Transform `json:"transforms,omitempty"`
}

// RequestHeaderMatchConditionParameters defines the parameters for RequestHeader match conditions
type RequestHeaderMatchConditionParameters struct {
	TypeName *string `json:"typeName,omitempty"`
	// Selector - Name of Header to be matched
	Selector *string `json:"selector,omitempty"`
	// Operator - Describes operator to be matched. Possible values include: 'RequestHeaderOperatorAny', 'RequestHeaderOperatorEqual', 'RequestHeaderOperatorContains', 'RequestHeaderOperatorBeginsWith', 'RequestHeaderOperatorEndsWith', 'RequestHeaderOperatorLessThan', 'RequestHeaderOperatorLessThanOrEqual', 'RequestHeaderOperatorGreaterThan', 'RequestHeaderOperatorGreaterThanOrEqual', 'RequestHeaderOperatorRegEx'
	Operator RequestHeaderOperator `json:"operator,omitempty"`
	// NegateCondition - Describes if this is negate condition or not
	NegateCondition *bool `json:"negateCondition,omitempty"`
	// MatchValues - The match value for the condition of the delivery rule
	MatchValues *[]string `json:"matchValues,omitempty"`
	// Transforms - List of transforms
	Transforms *[]Transform `json:"transforms,omitempty"`
}

// RequestMethodMatchConditionParameters defines the parameters for RequestMethod match conditions
type RequestMethodMatchConditionParameters struct {
	TypeName *string `json:"typeName,omitempty"`
	// Operator - Describes operator to be matched
	Operator *string `json:"operator,omitempty"`
	// NegateCondition - Describes if this is negate condition or not
	NegateCondition *bool `json:"negateCondition,omitempty"`
	// Transforms - List of transforms
	Transforms *[]Transform `json:"transforms,omitempty"`
	// MatchValues - The match value for the condition of the delivery rule
	MatchValues *[]string `json:"matchValues,omitempty"`
}

// RequestSchemeMatchConditionParameters defines the parameters for RequestScheme match conditions
type RequestSchemeMatchConditionParameters struct {
	TypeName *string `json:"typeName,omitempty"`
	// Operator - Describes operator to be matched
	Operator *string `json:"operator,omitempty"`
	// NegateCondition - Describes if this is negate condition or not
	NegateCondition *bool `json:"negateCondition,omitempty"`
	// Transforms - List of transforms
	Transforms *[]Transform `json:"transforms,omitempty"`
	// MatchValues - The match value for the condition of the delivery rule
	MatchValues *[]string `json:"matchValues,omitempty"`
}

// RequestURIMatchConditionParameters defines the parameters for RequestUri match conditions
type RequestURIMatchConditionParameters struct {
	TypeName *string `json:"typeName,omitempty"`
	// Operator - Describes operator to be matched. Possible values include: 'RequestURIOperatorAny', 'RequestURIOperatorEqual', 'RequestURIOperatorContains', 'RequestURIOperatorBeginsWith', 'RequestURIOperatorEndsWith', 'RequestURIOperatorLessThan', 'RequestURIOperatorLessThanOrEqual', 'RequestURIOperatorGreaterThan', 'RequestURIOperatorGreaterThanOrEqual', 'RequestURIOperatorRegEx'
	Operator RequestURIOperator `json:"operator,omitempty"`
	// NegateCondition - Describes if this is negate condition or not
	NegateCondition *bool `json:"negateCondition,omitempty"`
	// MatchValues - The match value for the condition of the delivery rule
	MatchValues *[]string `json:"matchValues,omitempty"`
	// Transforms - List of transforms
	Transforms *[]Transform `json:"transforms,omitempty"`
}

// Resource the core properties of ARM resources
type Resource struct {
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ResourceReference reference to another resource.
type ResourceReference struct {
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
}

// ResourcesResponse resources Response
type ResourcesResponse struct {
	autorest.Response `json:"-"`
	Endpoints         *[]ResourcesResponseEndpointsItem     `json:"endpoints,omitempty"`
	CustomDomains     *[]ResourcesResponseCustomDomainsItem `json:"customDomains,omitempty"`
}

// ResourcesResponseCustomDomainsItem ...
type ResourcesResponseCustomDomainsItem struct {
	ID         *string `json:"id,omitempty"`
	Name       *string `json:"name,omitempty"`
	EndpointID *string `json:"endpointId,omitempty"`
	History    *bool   `json:"history,omitempty"`
}

// ResourcesResponseEndpointsItem ...
type ResourcesResponseEndpointsItem struct {
	ID            *string                                            `json:"id,omitempty"`
	Name          *string                                            `json:"name,omitempty"`
	History       *bool                                              `json:"history,omitempty"`
	CustomDomains *[]ResourcesResponseEndpointsItemCustomDomainsItem `json:"customDomains,omitempty"`
}

// ResourcesResponseEndpointsItemCustomDomainsItem ...
type ResourcesResponseEndpointsItemCustomDomainsItem struct {
	ID         *string `json:"id,omitempty"`
	Name       *string `json:"name,omitempty"`
	EndpointID *string `json:"endpointId,omitempty"`
	History    *bool   `json:"history,omitempty"`
}

// ResourceUsage output of check resource usage API.
type ResourceUsage struct {
	// ResourceType - READ-ONLY; Resource type for which the usage is provided.
	ResourceType *string `json:"resourceType,omitempty"`
	// Unit - READ-ONLY; Unit of the usage. e.g. Count.
	Unit *string `json:"unit,omitempty"`
	// CurrentValue - READ-ONLY; Actual value of usage on the specified resource type.
	CurrentValue *int32 `json:"currentValue,omitempty"`
	// Limit - READ-ONLY; Quota of the specified resource type.
	Limit *int32 `json:"limit,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceUsage.
func (ru ResourceUsage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ResourceUsageListResult output of check resource usage API.
type ResourceUsageListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of resource usages.
	Value *[]ResourceUsage `json:"value,omitempty"`
	// NextLink - URL to get the next set of custom domain objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceUsageListResult.
func (rulr ResourceUsageListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rulr.NextLink != nil {
		objectMap["nextLink"] = rulr.NextLink
	}
	return json.Marshal(objectMap)
}

// ResourceUsageListResultIterator provides access to a complete listing of ResourceUsage values.
type ResourceUsageListResultIterator struct {
	i    int
	page ResourceUsageListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResourceUsageListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceUsageListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ResourceUsageListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResourceUsageListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResourceUsageListResultIterator) Response() ResourceUsageListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResourceUsageListResultIterator) Value() ResourceUsage {
	if !iter.page.NotDone() {
		return ResourceUsage{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ResourceUsageListResultIterator type.
func NewResourceUsageListResultIterator(page ResourceUsageListResultPage) ResourceUsageListResultIterator {
	return ResourceUsageListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rulr ResourceUsageListResult) IsEmpty() bool {
	return rulr.Value == nil || len(*rulr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rulr ResourceUsageListResult) hasNextLink() bool {
	return rulr.NextLink != nil && len(*rulr.NextLink) != 0
}

// resourceUsageListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rulr ResourceUsageListResult) resourceUsageListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !rulr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rulr.NextLink)))
}

// ResourceUsageListResultPage contains a page of ResourceUsage values.
type ResourceUsageListResultPage struct {
	fn   func(context.Context, ResourceUsageListResult) (ResourceUsageListResult, error)
	rulr ResourceUsageListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResourceUsageListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceUsageListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rulr)
		if err != nil {
			return err
		}
		page.rulr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ResourceUsageListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResourceUsageListResultPage) NotDone() bool {
	return !page.rulr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResourceUsageListResultPage) Response() ResourceUsageListResult {
	return page.rulr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResourceUsageListResultPage) Values() []ResourceUsage {
	if page.rulr.IsEmpty() {
		return nil
	}
	return *page.rulr.Value
}

// Creates a new instance of the ResourceUsageListResultPage type.
func NewResourceUsageListResultPage(cur ResourceUsageListResult, getNextPage func(context.Context, ResourceUsageListResult) (ResourceUsageListResult, error)) ResourceUsageListResultPage {
	return ResourceUsageListResultPage{
		fn:   getNextPage,
		rulr: cur,
	}
}

// ResponseBasedOriginErrorDetectionParameters the JSON object that contains the properties to determine
// origin health using real requests/responses.
type ResponseBasedOriginErrorDetectionParameters struct {
	// ResponseBasedDetectedErrorTypes - Type of response errors for real user requests for which origin will be deemed unhealthy. Possible values include: 'ResponseBasedDetectedErrorTypesNone', 'ResponseBasedDetectedErrorTypesTCPErrorsOnly', 'ResponseBasedDetectedErrorTypesTCPAndHTTPErrors'
	ResponseBasedDetectedErrorTypes ResponseBasedDetectedErrorTypes `json:"responseBasedDetectedErrorTypes,omitempty"`
	// ResponseBasedFailoverThresholdPercentage - The percentage of failed requests in the sample where failover should trigger.
	ResponseBasedFailoverThresholdPercentage *int32 `json:"responseBasedFailoverThresholdPercentage,omitempty"`
	// HTTPErrorRanges - The list of Http status code ranges that are considered as server errors for origin and it is marked as unhealthy.
	HTTPErrorRanges *[]HTTPErrorRangeParameters `json:"httpErrorRanges,omitempty"`
}

// Route friendly Routes name mapping to the any Routes or secret related information.
type Route struct {
	autorest.Response `json:"-"`
	*RouteProperties  `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for Route.
func (r Route) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.RouteProperties != nil {
		objectMap["properties"] = r.RouteProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Route struct.
func (r *Route) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var routeProperties RouteProperties
				err = json.Unmarshal(*v, &routeProperties)
				if err != nil {
					return err
				}
				r.RouteProperties = &routeProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				r.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				r.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				r.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				r.SystemData = &systemData
			}
		}
	}

	return nil
}

// RouteConfigurationOverrideActionParameters defines the parameters for the route configuration override
// action.
type RouteConfigurationOverrideActionParameters struct {
	TypeName *string `json:"typeName,omitempty"`
	// OriginGroupOverride - A reference to the origin group override configuration. Leave empty to use the default origin group on route.
	OriginGroupOverride *OriginGroupOverride `json:"originGroupOverride,omitempty"`
	// CacheConfiguration - The caching configuration associated with this rule. To disable caching, do not provide a cacheConfiguration object.
	CacheConfiguration *CacheConfiguration `json:"cacheConfiguration,omitempty"`
}

// RouteListResult result of the request to list routes. It contains a list of route objects and a URL link
// to get the next set of results.
type RouteListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of AzureFrontDoor routes within a profile.
	Value *[]Route `json:"value,omitempty"`
	// NextLink - URL to get the next set of route objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for RouteListResult.
func (rlr RouteListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rlr.NextLink != nil {
		objectMap["nextLink"] = rlr.NextLink
	}
	return json.Marshal(objectMap)
}

// RouteListResultIterator provides access to a complete listing of Route values.
type RouteListResultIterator struct {
	i    int
	page RouteListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RouteListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RouteListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RouteListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RouteListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RouteListResultIterator) Response() RouteListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RouteListResultIterator) Value() Route {
	if !iter.page.NotDone() {
		return Route{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RouteListResultIterator type.
func NewRouteListResultIterator(page RouteListResultPage) RouteListResultIterator {
	return RouteListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rlr RouteListResult) IsEmpty() bool {
	return rlr.Value == nil || len(*rlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rlr RouteListResult) hasNextLink() bool {
	return rlr.NextLink != nil && len(*rlr.NextLink) != 0
}

// routeListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rlr RouteListResult) routeListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !rlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rlr.NextLink)))
}

// RouteListResultPage contains a page of Route values.
type RouteListResultPage struct {
	fn  func(context.Context, RouteListResult) (RouteListResult, error)
	rlr RouteListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RouteListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RouteListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rlr)
		if err != nil {
			return err
		}
		page.rlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RouteListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RouteListResultPage) NotDone() bool {
	return !page.rlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RouteListResultPage) Response() RouteListResult {
	return page.rlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RouteListResultPage) Values() []Route {
	if page.rlr.IsEmpty() {
		return nil
	}
	return *page.rlr.Value
}

// Creates a new instance of the RouteListResultPage type.
func NewRouteListResultPage(cur RouteListResult, getNextPage func(context.Context, RouteListResult) (RouteListResult, error)) RouteListResultPage {
	return RouteListResultPage{
		fn:  getNextPage,
		rlr: cur,
	}
}

// RouteProperties the JSON object that contains the properties of the Routes to create.
type RouteProperties struct {
	// EndpointName - READ-ONLY; The name of the endpoint which holds the route.
	EndpointName *string `json:"endpointName,omitempty"`
	// CustomDomains - Domains referenced by this endpoint.
	CustomDomains *[]ActivatedResourceReference `json:"customDomains,omitempty"`
	// OriginGroup - A reference to the origin group.
	OriginGroup *ResourceReference `json:"originGroup,omitempty"`
	// OriginPath - A directory path on the origin that AzureFrontDoor can use to retrieve content from, e.g. contoso.cloudapp.net/originpath.
	OriginPath *string `json:"originPath,omitempty"`
	// RuleSets - rule sets referenced by this endpoint.
	RuleSets *[]ResourceReference `json:"ruleSets,omitempty"`
	// SupportedProtocols - List of supported protocols for this route.
	SupportedProtocols *[]AFDEndpointProtocols `json:"supportedProtocols,omitempty"`
	// PatternsToMatch - The route patterns of the rule.
	PatternsToMatch *[]string `json:"patternsToMatch,omitempty"`
	// CacheConfiguration - The caching configuration for this route. To disable caching, do not provide a cacheConfiguration object.
	CacheConfiguration *AfdRouteCacheConfiguration `json:"cacheConfiguration,omitempty"`
	// ForwardingProtocol - Protocol this rule will use when forwarding traffic to backends. Possible values include: 'ForwardingProtocolHTTPOnly', 'ForwardingProtocolHTTPSOnly', 'ForwardingProtocolMatchRequest'
	ForwardingProtocol ForwardingProtocol `json:"forwardingProtocol,omitempty"`
	// LinkToDefaultDomain - whether this route will be linked to the default endpoint domain. Possible values include: 'LinkToDefaultDomainEnabled', 'LinkToDefaultDomainDisabled'
	LinkToDefaultDomain LinkToDefaultDomain `json:"linkToDefaultDomain,omitempty"`
	// HTTPSRedirect - Whether to automatically redirect HTTP traffic to HTTPS traffic. Note that this is a easy way to set up this rule and it will be the first rule that gets executed. Possible values include: 'HTTPSRedirectEnabled', 'HTTPSRedirectDisabled'
	HTTPSRedirect HTTPSRedirect `json:"httpsRedirect,omitempty"`
	// EnabledState - Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'. Possible values include: 'EnabledStateEnabled', 'EnabledStateDisabled'
	EnabledState EnabledState `json:"enabledState,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning status. Possible values include: 'AfdProvisioningStateSucceeded', 'AfdProvisioningStateFailed', 'AfdProvisioningStateUpdating', 'AfdProvisioningStateDeleting', 'AfdProvisioningStateCreating'
	ProvisioningState AfdProvisioningState `json:"provisioningState,omitempty"`
	// DeploymentStatus - READ-ONLY; Possible values include: 'DeploymentStatusNotStarted', 'DeploymentStatusInProgress', 'DeploymentStatusSucceeded', 'DeploymentStatusFailed'
	DeploymentStatus DeploymentStatus `json:"deploymentStatus,omitempty"`
}

// MarshalJSON is the custom marshaler for RouteProperties.
func (rp RouteProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rp.CustomDomains != nil {
		objectMap["customDomains"] = rp.CustomDomains
	}
	if rp.OriginGroup != nil {
		objectMap["originGroup"] = rp.OriginGroup
	}
	if rp.OriginPath != nil {
		objectMap["originPath"] = rp.OriginPath
	}
	if rp.RuleSets != nil {
		objectMap["ruleSets"] = rp.RuleSets
	}
	if rp.SupportedProtocols != nil {
		objectMap["supportedProtocols"] = rp.SupportedProtocols
	}
	if rp.PatternsToMatch != nil {
		objectMap["patternsToMatch"] = rp.PatternsToMatch
	}
	if rp.CacheConfiguration != nil {
		objectMap["cacheConfiguration"] = rp.CacheConfiguration
	}
	if rp.ForwardingProtocol != "" {
		objectMap["forwardingProtocol"] = rp.ForwardingProtocol
	}
	if rp.LinkToDefaultDomain != "" {
		objectMap["linkToDefaultDomain"] = rp.LinkToDefaultDomain
	}
	if rp.HTTPSRedirect != "" {
		objectMap["httpsRedirect"] = rp.HTTPSRedirect
	}
	if rp.EnabledState != "" {
		objectMap["enabledState"] = rp.EnabledState
	}
	return json.Marshal(objectMap)
}

// RoutesCreateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type RoutesCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(RoutesClient) (Route, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *RoutesCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for RoutesCreateFuture.Result.
func (future *RoutesCreateFuture) result(client RoutesClient) (r Route, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.RoutesCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		r.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("cdn.RoutesCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if r.Response.Response, err = future.GetResult(sender); err == nil && r.Response.Response.StatusCode != http.StatusNoContent {
		r, err = client.CreateResponder(r.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.RoutesCreateFuture", "Result", r.Response.Response, "Failure responding to request")
		}
	}
	return
}

// RoutesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type RoutesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(RoutesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *RoutesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for RoutesDeleteFuture.Result.
func (future *RoutesDeleteFuture) result(client RoutesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.RoutesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("cdn.RoutesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// RoutesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type RoutesUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(RoutesClient) (Route, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *RoutesUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for RoutesUpdateFuture.Result.
func (future *RoutesUpdateFuture) result(client RoutesClient) (r Route, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.RoutesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		r.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("cdn.RoutesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if r.Response.Response, err = future.GetResult(sender); err == nil && r.Response.Response.StatusCode != http.StatusNoContent {
		r, err = client.UpdateResponder(r.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.RoutesUpdateFuture", "Result", r.Response.Response, "Failure responding to request")
		}
	}
	return
}

// RouteUpdateParameters the domain JSON object required for domain creation or update.
type RouteUpdateParameters struct {
	*RouteUpdatePropertiesParameters `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for RouteUpdateParameters.
func (rup RouteUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rup.RouteUpdatePropertiesParameters != nil {
		objectMap["properties"] = rup.RouteUpdatePropertiesParameters
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RouteUpdateParameters struct.
func (rup *RouteUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var routeUpdatePropertiesParameters RouteUpdatePropertiesParameters
				err = json.Unmarshal(*v, &routeUpdatePropertiesParameters)
				if err != nil {
					return err
				}
				rup.RouteUpdatePropertiesParameters = &routeUpdatePropertiesParameters
			}
		}
	}

	return nil
}

// RouteUpdatePropertiesParameters the JSON object that contains the properties of the domain to create.
type RouteUpdatePropertiesParameters struct {
	// EndpointName - READ-ONLY; The name of the endpoint which holds the route.
	EndpointName *string `json:"endpointName,omitempty"`
	// CustomDomains - Domains referenced by this endpoint.
	CustomDomains *[]ActivatedResourceReference `json:"customDomains,omitempty"`
	// OriginGroup - A reference to the origin group.
	OriginGroup *ResourceReference `json:"originGroup,omitempty"`
	// OriginPath - A directory path on the origin that AzureFrontDoor can use to retrieve content from, e.g. contoso.cloudapp.net/originpath.
	OriginPath *string `json:"originPath,omitempty"`
	// RuleSets - rule sets referenced by this endpoint.
	RuleSets *[]ResourceReference `json:"ruleSets,omitempty"`
	// SupportedProtocols - List of supported protocols for this route.
	SupportedProtocols *[]AFDEndpointProtocols `json:"supportedProtocols,omitempty"`
	// PatternsToMatch - The route patterns of the rule.
	PatternsToMatch *[]string `json:"patternsToMatch,omitempty"`
	// CacheConfiguration - The caching configuration for this route. To disable caching, do not provide a cacheConfiguration object.
	CacheConfiguration *AfdRouteCacheConfiguration `json:"cacheConfiguration,omitempty"`
	// ForwardingProtocol - Protocol this rule will use when forwarding traffic to backends. Possible values include: 'ForwardingProtocolHTTPOnly', 'ForwardingProtocolHTTPSOnly', 'ForwardingProtocolMatchRequest'
	ForwardingProtocol ForwardingProtocol `json:"forwardingProtocol,omitempty"`
	// LinkToDefaultDomain - whether this route will be linked to the default endpoint domain. Possible values include: 'LinkToDefaultDomainEnabled', 'LinkToDefaultDomainDisabled'
	LinkToDefaultDomain LinkToDefaultDomain `json:"linkToDefaultDomain,omitempty"`
	// HTTPSRedirect - Whether to automatically redirect HTTP traffic to HTTPS traffic. Note that this is a easy way to set up this rule and it will be the first rule that gets executed. Possible values include: 'HTTPSRedirectEnabled', 'HTTPSRedirectDisabled'
	HTTPSRedirect HTTPSRedirect `json:"httpsRedirect,omitempty"`
	// EnabledState - Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'. Possible values include: 'EnabledStateEnabled', 'EnabledStateDisabled'
	EnabledState EnabledState `json:"enabledState,omitempty"`
}

// MarshalJSON is the custom marshaler for RouteUpdatePropertiesParameters.
func (rupp RouteUpdatePropertiesParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rupp.CustomDomains != nil {
		objectMap["customDomains"] = rupp.CustomDomains
	}
	if rupp.OriginGroup != nil {
		objectMap["originGroup"] = rupp.OriginGroup
	}
	if rupp.OriginPath != nil {
		objectMap["originPath"] = rupp.OriginPath
	}
	if rupp.RuleSets != nil {
		objectMap["ruleSets"] = rupp.RuleSets
	}
	if rupp.SupportedProtocols != nil {
		objectMap["supportedProtocols"] = rupp.SupportedProtocols
	}
	if rupp.PatternsToMatch != nil {
		objectMap["patternsToMatch"] = rupp.PatternsToMatch
	}
	if rupp.CacheConfiguration != nil {
		objectMap["cacheConfiguration"] = rupp.CacheConfiguration
	}
	if rupp.ForwardingProtocol != "" {
		objectMap["forwardingProtocol"] = rupp.ForwardingProtocol
	}
	if rupp.LinkToDefaultDomain != "" {
		objectMap["linkToDefaultDomain"] = rupp.LinkToDefaultDomain
	}
	if rupp.HTTPSRedirect != "" {
		objectMap["httpsRedirect"] = rupp.HTTPSRedirect
	}
	if rupp.EnabledState != "" {
		objectMap["enabledState"] = rupp.EnabledState
	}
	return json.Marshal(objectMap)
}

// Rule friendly Rules name mapping to the any Rules or secret related information.
type Rule struct {
	autorest.Response `json:"-"`
	*RuleProperties   `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for Rule.
func (r Rule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.RuleProperties != nil {
		objectMap["properties"] = r.RuleProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Rule struct.
func (r *Rule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var ruleProperties RuleProperties
				err = json.Unmarshal(*v, &ruleProperties)
				if err != nil {
					return err
				}
				r.RuleProperties = &ruleProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				r.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				r.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				r.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				r.SystemData = &systemData
			}
		}
	}

	return nil
}

// RuleListResult result of the request to list rules. It contains a list of rule objects and a URL link to
// get the next set of results.
type RuleListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of AzureFrontDoor rules within a rule set.
	Value *[]Rule `json:"value,omitempty"`
	// NextLink - URL to get the next set of rule objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for RuleListResult.
func (rlr RuleListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rlr.NextLink != nil {
		objectMap["nextLink"] = rlr.NextLink
	}
	return json.Marshal(objectMap)
}

// RuleListResultIterator provides access to a complete listing of Rule values.
type RuleListResultIterator struct {
	i    int
	page RuleListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RuleListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RuleListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RuleListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RuleListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RuleListResultIterator) Response() RuleListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RuleListResultIterator) Value() Rule {
	if !iter.page.NotDone() {
		return Rule{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RuleListResultIterator type.
func NewRuleListResultIterator(page RuleListResultPage) RuleListResultIterator {
	return RuleListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rlr RuleListResult) IsEmpty() bool {
	return rlr.Value == nil || len(*rlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rlr RuleListResult) hasNextLink() bool {
	return rlr.NextLink != nil && len(*rlr.NextLink) != 0
}

// ruleListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rlr RuleListResult) ruleListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !rlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rlr.NextLink)))
}

// RuleListResultPage contains a page of Rule values.
type RuleListResultPage struct {
	fn  func(context.Context, RuleListResult) (RuleListResult, error)
	rlr RuleListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RuleListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RuleListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rlr)
		if err != nil {
			return err
		}
		page.rlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RuleListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RuleListResultPage) NotDone() bool {
	return !page.rlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RuleListResultPage) Response() RuleListResult {
	return page.rlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RuleListResultPage) Values() []Rule {
	if page.rlr.IsEmpty() {
		return nil
	}
	return *page.rlr.Value
}

// Creates a new instance of the RuleListResultPage type.
func NewRuleListResultPage(cur RuleListResult, getNextPage func(context.Context, RuleListResult) (RuleListResult, error)) RuleListResultPage {
	return RuleListResultPage{
		fn:  getNextPage,
		rlr: cur,
	}
}

// RuleProperties the JSON object that contains the properties of the Rules to create.
type RuleProperties struct {
	// RuleSetName - READ-ONLY; The name of the rule set containing the rule.
	RuleSetName *string `json:"ruleSetName,omitempty"`
	// Order - The order in which the rules are applied for the endpoint. Possible values {0,1,2,3,………}. A rule with a lesser order will be applied before a rule with a greater order. Rule with order 0 is a special rule. It does not require any condition and actions listed in it will always be applied.
	Order *int32 `json:"order,omitempty"`
	// Conditions - A list of conditions that must be matched for the actions to be executed
	Conditions *[]BasicDeliveryRuleCondition `json:"conditions,omitempty"`
	// Actions - A list of actions that are executed when all the conditions of a rule are satisfied.
	Actions *[]BasicDeliveryRuleAction `json:"actions,omitempty"`
	// MatchProcessingBehavior - If this rule is a match should the rules engine continue running the remaining rules or stop. If not present, defaults to Continue. Possible values include: 'MatchProcessingBehaviorContinue', 'MatchProcessingBehaviorStop'
	MatchProcessingBehavior MatchProcessingBehavior `json:"matchProcessingBehavior,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning status. Possible values include: 'AfdProvisioningStateSucceeded', 'AfdProvisioningStateFailed', 'AfdProvisioningStateUpdating', 'AfdProvisioningStateDeleting', 'AfdProvisioningStateCreating'
	ProvisioningState AfdProvisioningState `json:"provisioningState,omitempty"`
	// DeploymentStatus - READ-ONLY; Possible values include: 'DeploymentStatusNotStarted', 'DeploymentStatusInProgress', 'DeploymentStatusSucceeded', 'DeploymentStatusFailed'
	DeploymentStatus DeploymentStatus `json:"deploymentStatus,omitempty"`
}

// MarshalJSON is the custom marshaler for RuleProperties.
func (rp RuleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rp.Order != nil {
		objectMap["order"] = rp.Order
	}
	if rp.Conditions != nil {
		objectMap["conditions"] = rp.Conditions
	}
	if rp.Actions != nil {
		objectMap["actions"] = rp.Actions
	}
	if rp.MatchProcessingBehavior != "" {
		objectMap["matchProcessingBehavior"] = rp.MatchProcessingBehavior
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RuleProperties struct.
func (rp *RuleProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "ruleSetName":
			if v != nil {
				var ruleSetName string
				err = json.Unmarshal(*v, &ruleSetName)
				if err != nil {
					return err
				}
				rp.RuleSetName = &ruleSetName
			}
		case "order":
			if v != nil {
				var order int32
				err = json.Unmarshal(*v, &order)
				if err != nil {
					return err
				}
				rp.Order = &order
			}
		case "conditions":
			if v != nil {
				conditions, err := unmarshalBasicDeliveryRuleConditionArray(*v)
				if err != nil {
					return err
				}
				rp.Conditions = &conditions
			}
		case "actions":
			if v != nil {
				actions, err := unmarshalBasicDeliveryRuleActionArray(*v)
				if err != nil {
					return err
				}
				rp.Actions = &actions
			}
		case "matchProcessingBehavior":
			if v != nil {
				var matchProcessingBehavior MatchProcessingBehavior
				err = json.Unmarshal(*v, &matchProcessingBehavior)
				if err != nil {
					return err
				}
				rp.MatchProcessingBehavior = matchProcessingBehavior
			}
		case "provisioningState":
			if v != nil {
				var provisioningState AfdProvisioningState
				err = json.Unmarshal(*v, &provisioningState)
				if err != nil {
					return err
				}
				rp.ProvisioningState = provisioningState
			}
		case "deploymentStatus":
			if v != nil {
				var deploymentStatus DeploymentStatus
				err = json.Unmarshal(*v, &deploymentStatus)
				if err != nil {
					return err
				}
				rp.DeploymentStatus = deploymentStatus
			}
		}
	}

	return nil
}

// RulesCreateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type RulesCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(RulesClient) (Rule, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *RulesCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for RulesCreateFuture.Result.
func (future *RulesCreateFuture) result(client RulesClient) (r Rule, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.RulesCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		r.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("cdn.RulesCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if r.Response.Response, err = future.GetResult(sender); err == nil && r.Response.Response.StatusCode != http.StatusNoContent {
		r, err = client.CreateResponder(r.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.RulesCreateFuture", "Result", r.Response.Response, "Failure responding to request")
		}
	}
	return
}

// RulesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type RulesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(RulesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *RulesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for RulesDeleteFuture.Result.
func (future *RulesDeleteFuture) result(client RulesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.RulesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("cdn.RulesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// RuleSet friendly RuleSet name mapping to the any RuleSet or secret related information.
type RuleSet struct {
	autorest.Response  `json:"-"`
	*RuleSetProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for RuleSet.
func (rs RuleSet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rs.RuleSetProperties != nil {
		objectMap["properties"] = rs.RuleSetProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RuleSet struct.
func (rs *RuleSet) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var ruleSetProperties RuleSetProperties
				err = json.Unmarshal(*v, &ruleSetProperties)
				if err != nil {
					return err
				}
				rs.RuleSetProperties = &ruleSetProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rs.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rs.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rs.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				rs.SystemData = &systemData
			}
		}
	}

	return nil
}

// RuleSetListResult result of the request to list rule sets. It contains a list of rule set objects and a
// URL link to get the next set of results.
type RuleSetListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of AzureFrontDoor rule sets within a profile.
	Value *[]RuleSet `json:"value,omitempty"`
	// NextLink - URL to get the next set of rule set objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for RuleSetListResult.
func (rslr RuleSetListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rslr.NextLink != nil {
		objectMap["nextLink"] = rslr.NextLink
	}
	return json.Marshal(objectMap)
}

// RuleSetListResultIterator provides access to a complete listing of RuleSet values.
type RuleSetListResultIterator struct {
	i    int
	page RuleSetListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RuleSetListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RuleSetListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RuleSetListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RuleSetListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RuleSetListResultIterator) Response() RuleSetListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RuleSetListResultIterator) Value() RuleSet {
	if !iter.page.NotDone() {
		return RuleSet{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RuleSetListResultIterator type.
func NewRuleSetListResultIterator(page RuleSetListResultPage) RuleSetListResultIterator {
	return RuleSetListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rslr RuleSetListResult) IsEmpty() bool {
	return rslr.Value == nil || len(*rslr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rslr RuleSetListResult) hasNextLink() bool {
	return rslr.NextLink != nil && len(*rslr.NextLink) != 0
}

// ruleSetListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rslr RuleSetListResult) ruleSetListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !rslr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rslr.NextLink)))
}

// RuleSetListResultPage contains a page of RuleSet values.
type RuleSetListResultPage struct {
	fn   func(context.Context, RuleSetListResult) (RuleSetListResult, error)
	rslr RuleSetListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RuleSetListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RuleSetListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rslr)
		if err != nil {
			return err
		}
		page.rslr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RuleSetListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RuleSetListResultPage) NotDone() bool {
	return !page.rslr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RuleSetListResultPage) Response() RuleSetListResult {
	return page.rslr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RuleSetListResultPage) Values() []RuleSet {
	if page.rslr.IsEmpty() {
		return nil
	}
	return *page.rslr.Value
}

// Creates a new instance of the RuleSetListResultPage type.
func NewRuleSetListResultPage(cur RuleSetListResult, getNextPage func(context.Context, RuleSetListResult) (RuleSetListResult, error)) RuleSetListResultPage {
	return RuleSetListResultPage{
		fn:   getNextPage,
		rslr: cur,
	}
}

// RuleSetProperties the JSON object that contains the properties of the Rule Set to create.
type RuleSetProperties struct {
	// ProfileName - READ-ONLY; The name of the profile which holds the rule set.
	ProfileName *string `json:"profileName,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning status. Possible values include: 'AfdProvisioningStateSucceeded', 'AfdProvisioningStateFailed', 'AfdProvisioningStateUpdating', 'AfdProvisioningStateDeleting', 'AfdProvisioningStateCreating'
	ProvisioningState AfdProvisioningState `json:"provisioningState,omitempty"`
	// DeploymentStatus - READ-ONLY; Possible values include: 'DeploymentStatusNotStarted', 'DeploymentStatusInProgress', 'DeploymentStatusSucceeded', 'DeploymentStatusFailed'
	DeploymentStatus DeploymentStatus `json:"deploymentStatus,omitempty"`
}

// MarshalJSON is the custom marshaler for RuleSetProperties.
func (rsp RuleSetProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// RuleSetsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type RuleSetsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(RuleSetsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *RuleSetsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for RuleSetsDeleteFuture.Result.
func (future *RuleSetsDeleteFuture) result(client RuleSetsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.RuleSetsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("cdn.RuleSetsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// RulesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type RulesUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(RulesClient) (Rule, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *RulesUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for RulesUpdateFuture.Result.
func (future *RulesUpdateFuture) result(client RulesClient) (r Rule, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.RulesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		r.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("cdn.RulesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if r.Response.Response, err = future.GetResult(sender); err == nil && r.Response.Response.StatusCode != http.StatusNoContent {
		r, err = client.UpdateResponder(r.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.RulesUpdateFuture", "Result", r.Response.Response, "Failure responding to request")
		}
	}
	return
}

// RuleUpdateParameters the domain JSON object required for domain creation or update.
type RuleUpdateParameters struct {
	*RuleUpdatePropertiesParameters `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for RuleUpdateParameters.
func (rup RuleUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rup.RuleUpdatePropertiesParameters != nil {
		objectMap["properties"] = rup.RuleUpdatePropertiesParameters
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RuleUpdateParameters struct.
func (rup *RuleUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var ruleUpdatePropertiesParameters RuleUpdatePropertiesParameters
				err = json.Unmarshal(*v, &ruleUpdatePropertiesParameters)
				if err != nil {
					return err
				}
				rup.RuleUpdatePropertiesParameters = &ruleUpdatePropertiesParameters
			}
		}
	}

	return nil
}

// RuleUpdatePropertiesParameters the JSON object that contains the properties of the rule to update.
type RuleUpdatePropertiesParameters struct {
	// RuleSetName - READ-ONLY; The name of the rule set containing the rule.
	RuleSetName *string `json:"ruleSetName,omitempty"`
	// Order - The order in which the rules are applied for the endpoint. Possible values {0,1,2,3,………}. A rule with a lesser order will be applied before a rule with a greater order. Rule with order 0 is a special rule. It does not require any condition and actions listed in it will always be applied.
	Order *int32 `json:"order,omitempty"`
	// Conditions - A list of conditions that must be matched for the actions to be executed
	Conditions *[]BasicDeliveryRuleCondition `json:"conditions,omitempty"`
	// Actions - A list of actions that are executed when all the conditions of a rule are satisfied.
	Actions *[]BasicDeliveryRuleAction `json:"actions,omitempty"`
	// MatchProcessingBehavior - If this rule is a match should the rules engine continue running the remaining rules or stop. If not present, defaults to Continue. Possible values include: 'MatchProcessingBehaviorContinue', 'MatchProcessingBehaviorStop'
	MatchProcessingBehavior MatchProcessingBehavior `json:"matchProcessingBehavior,omitempty"`
}

// MarshalJSON is the custom marshaler for RuleUpdatePropertiesParameters.
func (rupp RuleUpdatePropertiesParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rupp.Order != nil {
		objectMap["order"] = rupp.Order
	}
	if rupp.Conditions != nil {
		objectMap["conditions"] = rupp.Conditions
	}
	if rupp.Actions != nil {
		objectMap["actions"] = rupp.Actions
	}
	if rupp.MatchProcessingBehavior != "" {
		objectMap["matchProcessingBehavior"] = rupp.MatchProcessingBehavior
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RuleUpdatePropertiesParameters struct.
func (rupp *RuleUpdatePropertiesParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "ruleSetName":
			if v != nil {
				var ruleSetName string
				err = json.Unmarshal(*v, &ruleSetName)
				if err != nil {
					return err
				}
				rupp.RuleSetName = &ruleSetName
			}
		case "order":
			if v != nil {
				var order int32
				err = json.Unmarshal(*v, &order)
				if err != nil {
					return err
				}
				rupp.Order = &order
			}
		case "conditions":
			if v != nil {
				conditions, err := unmarshalBasicDeliveryRuleConditionArray(*v)
				if err != nil {
					return err
				}
				rupp.Conditions = &conditions
			}
		case "actions":
			if v != nil {
				actions, err := unmarshalBasicDeliveryRuleActionArray(*v)
				if err != nil {
					return err
				}
				rupp.Actions = &actions
			}
		case "matchProcessingBehavior":
			if v != nil {
				var matchProcessingBehavior MatchProcessingBehavior
				err = json.Unmarshal(*v, &matchProcessingBehavior)
				if err != nil {
					return err
				}
				rupp.MatchProcessingBehavior = matchProcessingBehavior
			}
		}
	}

	return nil
}

// Secret friendly Secret name mapping to the any Secret or secret related information.
type Secret struct {
	autorest.Response `json:"-"`
	*SecretProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for Secret.
func (s Secret) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if s.SecretProperties != nil {
		objectMap["properties"] = s.SecretProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Secret struct.
func (s *Secret) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var secretProperties SecretProperties
				err = json.Unmarshal(*v, &secretProperties)
				if err != nil {
					return err
				}
				s.SecretProperties = &secretProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				s.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				s.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				s.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				s.SystemData = &systemData
			}
		}
	}

	return nil
}

// SecretListResult result of the request to list secrets. It contains a list of Secret objects and a URL
// link to get the next set of results.
type SecretListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of AzureFrontDoor secrets within a profile.
	Value *[]Secret `json:"value,omitempty"`
	// NextLink - URL to get the next set of Secret objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for SecretListResult.
func (slr SecretListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if slr.NextLink != nil {
		objectMap["nextLink"] = slr.NextLink
	}
	return json.Marshal(objectMap)
}

// SecretListResultIterator provides access to a complete listing of Secret values.
type SecretListResultIterator struct {
	i    int
	page SecretListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SecretListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SecretListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SecretListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SecretListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SecretListResultIterator) Response() SecretListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SecretListResultIterator) Value() Secret {
	if !iter.page.NotDone() {
		return Secret{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SecretListResultIterator type.
func NewSecretListResultIterator(page SecretListResultPage) SecretListResultIterator {
	return SecretListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (slr SecretListResult) IsEmpty() bool {
	return slr.Value == nil || len(*slr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (slr SecretListResult) hasNextLink() bool {
	return slr.NextLink != nil && len(*slr.NextLink) != 0
}

// secretListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (slr SecretListResult) secretListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !slr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(slr.NextLink)))
}

// SecretListResultPage contains a page of Secret values.
type SecretListResultPage struct {
	fn  func(context.Context, SecretListResult) (SecretListResult, error)
	slr SecretListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SecretListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SecretListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.slr)
		if err != nil {
			return err
		}
		page.slr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SecretListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SecretListResultPage) NotDone() bool {
	return !page.slr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SecretListResultPage) Response() SecretListResult {
	return page.slr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SecretListResultPage) Values() []Secret {
	if page.slr.IsEmpty() {
		return nil
	}
	return *page.slr.Value
}

// Creates a new instance of the SecretListResultPage type.
func NewSecretListResultPage(cur SecretListResult, getNextPage func(context.Context, SecretListResult) (SecretListResult, error)) SecretListResultPage {
	return SecretListResultPage{
		fn:  getNextPage,
		slr: cur,
	}
}

// BasicSecretParameters the json object containing secret parameters
type BasicSecretParameters interface {
	AsURLSigningKeyParameters() (*URLSigningKeyParameters, bool)
	AsManagedCertificateParameters() (*ManagedCertificateParameters, bool)
	AsCustomerCertificateParameters() (*CustomerCertificateParameters, bool)
	AsAzureFirstPartyManagedCertificateParameters() (*AzureFirstPartyManagedCertificateParameters, bool)
	AsSecretParameters() (*SecretParameters, bool)
}

// SecretParameters the json object containing secret parameters
type SecretParameters struct {
	// Type - Possible values include: 'TypeBasicSecretParametersTypeSecretParameters', 'TypeBasicSecretParametersTypeURLSigningKey', 'TypeBasicSecretParametersTypeManagedCertificate', 'TypeBasicSecretParametersTypeCustomerCertificate', 'TypeBasicSecretParametersTypeAzureFirstPartyManagedCertificate'
	Type TypeBasicSecretParameters `json:"type,omitempty"`
}

func unmarshalBasicSecretParameters(body []byte) (BasicSecretParameters, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeBasicSecretParametersTypeURLSigningKey):
		var uskp URLSigningKeyParameters
		err := json.Unmarshal(body, &uskp)
		return uskp, err
	case string(TypeBasicSecretParametersTypeManagedCertificate):
		var mcp ManagedCertificateParameters
		err := json.Unmarshal(body, &mcp)
		return mcp, err
	case string(TypeBasicSecretParametersTypeCustomerCertificate):
		var ccp CustomerCertificateParameters
		err := json.Unmarshal(body, &ccp)
		return ccp, err
	case string(TypeBasicSecretParametersTypeAzureFirstPartyManagedCertificate):
		var afpmcp AzureFirstPartyManagedCertificateParameters
		err := json.Unmarshal(body, &afpmcp)
		return afpmcp, err
	default:
		var sp SecretParameters
		err := json.Unmarshal(body, &sp)
		return sp, err
	}
}
func unmarshalBasicSecretParametersArray(body []byte) ([]BasicSecretParameters, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	spArray := make([]BasicSecretParameters, len(rawMessages))

	for index, rawMessage := range rawMessages {
		sp, err := unmarshalBasicSecretParameters(*rawMessage)
		if err != nil {
			return nil, err
		}
		spArray[index] = sp
	}
	return spArray, nil
}

// MarshalJSON is the custom marshaler for SecretParameters.
func (sp SecretParameters) MarshalJSON() ([]byte, error) {
	sp.Type = TypeBasicSecretParametersTypeSecretParameters
	objectMap := make(map[string]interface{})
	if sp.Type != "" {
		objectMap["type"] = sp.Type
	}
	return json.Marshal(objectMap)
}

// AsURLSigningKeyParameters is the BasicSecretParameters implementation for SecretParameters.
func (sp SecretParameters) AsURLSigningKeyParameters() (*URLSigningKeyParameters, bool) {
	return nil, false
}

// AsManagedCertificateParameters is the BasicSecretParameters implementation for SecretParameters.
func (sp SecretParameters) AsManagedCertificateParameters() (*ManagedCertificateParameters, bool) {
	return nil, false
}

// AsCustomerCertificateParameters is the BasicSecretParameters implementation for SecretParameters.
func (sp SecretParameters) AsCustomerCertificateParameters() (*CustomerCertificateParameters, bool) {
	return nil, false
}

// AsAzureFirstPartyManagedCertificateParameters is the BasicSecretParameters implementation for SecretParameters.
func (sp SecretParameters) AsAzureFirstPartyManagedCertificateParameters() (*AzureFirstPartyManagedCertificateParameters, bool) {
	return nil, false
}

// AsSecretParameters is the BasicSecretParameters implementation for SecretParameters.
func (sp SecretParameters) AsSecretParameters() (*SecretParameters, bool) {
	return &sp, true
}

// AsBasicSecretParameters is the BasicSecretParameters implementation for SecretParameters.
func (sp SecretParameters) AsBasicSecretParameters() (BasicSecretParameters, bool) {
	return &sp, true
}

// SecretProperties the JSON object that contains the properties of the Secret to create.
type SecretProperties struct {
	// ProfileName - READ-ONLY; The name of the profile which holds the secret.
	ProfileName *string `json:"profileName,omitempty"`
	// Parameters - object which contains secret parameters
	Parameters BasicSecretParameters `json:"parameters,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning status. Possible values include: 'AfdProvisioningStateSucceeded', 'AfdProvisioningStateFailed', 'AfdProvisioningStateUpdating', 'AfdProvisioningStateDeleting', 'AfdProvisioningStateCreating'
	ProvisioningState AfdProvisioningState `json:"provisioningState,omitempty"`
	// DeploymentStatus - READ-ONLY; Possible values include: 'DeploymentStatusNotStarted', 'DeploymentStatusInProgress', 'DeploymentStatusSucceeded', 'DeploymentStatusFailed'
	DeploymentStatus DeploymentStatus `json:"deploymentStatus,omitempty"`
}

// MarshalJSON is the custom marshaler for SecretProperties.
func (sp SecretProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["parameters"] = sp.Parameters
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SecretProperties struct.
func (sp *SecretProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "profileName":
			if v != nil {
				var profileName string
				err = json.Unmarshal(*v, &profileName)
				if err != nil {
					return err
				}
				sp.ProfileName = &profileName
			}
		case "parameters":
			if v != nil {
				parameters, err := unmarshalBasicSecretParameters(*v)
				if err != nil {
					return err
				}
				sp.Parameters = parameters
			}
		case "provisioningState":
			if v != nil {
				var provisioningState AfdProvisioningState
				err = json.Unmarshal(*v, &provisioningState)
				if err != nil {
					return err
				}
				sp.ProvisioningState = provisioningState
			}
		case "deploymentStatus":
			if v != nil {
				var deploymentStatus DeploymentStatus
				err = json.Unmarshal(*v, &deploymentStatus)
				if err != nil {
					return err
				}
				sp.DeploymentStatus = deploymentStatus
			}
		}
	}

	return nil
}

// SecretsCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SecretsCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SecretsClient) (Secret, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SecretsCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SecretsCreateFuture.Result.
func (future *SecretsCreateFuture) result(client SecretsClient) (s Secret, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.SecretsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		s.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("cdn.SecretsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if s.Response.Response, err = future.GetResult(sender); err == nil && s.Response.Response.StatusCode != http.StatusNoContent {
		s, err = client.CreateResponder(s.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.SecretsCreateFuture", "Result", s.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SecretsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SecretsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SecretsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SecretsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SecretsDeleteFuture.Result.
func (future *SecretsDeleteFuture) result(client SecretsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.SecretsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("cdn.SecretsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// SecurityPoliciesCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SecurityPoliciesCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SecurityPoliciesClient) (SecurityPolicy, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SecurityPoliciesCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SecurityPoliciesCreateFuture.Result.
func (future *SecurityPoliciesCreateFuture) result(client SecurityPoliciesClient) (sp SecurityPolicy, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.SecurityPoliciesCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		sp.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("cdn.SecurityPoliciesCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sp.Response.Response, err = future.GetResult(sender); err == nil && sp.Response.Response.StatusCode != http.StatusNoContent {
		sp, err = client.CreateResponder(sp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.SecurityPoliciesCreateFuture", "Result", sp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SecurityPoliciesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SecurityPoliciesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SecurityPoliciesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SecurityPoliciesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SecurityPoliciesDeleteFuture.Result.
func (future *SecurityPoliciesDeleteFuture) result(client SecurityPoliciesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.SecurityPoliciesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("cdn.SecurityPoliciesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// SecurityPoliciesPatchFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SecurityPoliciesPatchFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SecurityPoliciesClient) (SecurityPolicy, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SecurityPoliciesPatchFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SecurityPoliciesPatchFuture.Result.
func (future *SecurityPoliciesPatchFuture) result(client SecurityPoliciesClient) (sp SecurityPolicy, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.SecurityPoliciesPatchFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		sp.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("cdn.SecurityPoliciesPatchFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sp.Response.Response, err = future.GetResult(sender); err == nil && sp.Response.Response.StatusCode != http.StatusNoContent {
		sp, err = client.PatchResponder(sp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.SecurityPoliciesPatchFuture", "Result", sp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SecurityPolicy securityPolicy association for AzureFrontDoor profile
type SecurityPolicy struct {
	autorest.Response         `json:"-"`
	*SecurityPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for SecurityPolicy.
func (sp SecurityPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sp.SecurityPolicyProperties != nil {
		objectMap["properties"] = sp.SecurityPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SecurityPolicy struct.
func (sp *SecurityPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var securityPolicyProperties SecurityPolicyProperties
				err = json.Unmarshal(*v, &securityPolicyProperties)
				if err != nil {
					return err
				}
				sp.SecurityPolicyProperties = &securityPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sp.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				sp.SystemData = &systemData
			}
		}
	}

	return nil
}

// SecurityPolicyListResult result of the request to list security policies. It contains a list of security
// policy objects and a URL link to get the next set of results.
type SecurityPolicyListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of Security policies within a profile
	Value *[]SecurityPolicy `json:"value,omitempty"`
	// NextLink - URL to get the next set of security policy objects if there is any.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for SecurityPolicyListResult.
func (splr SecurityPolicyListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if splr.NextLink != nil {
		objectMap["nextLink"] = splr.NextLink
	}
	return json.Marshal(objectMap)
}

// SecurityPolicyListResultIterator provides access to a complete listing of SecurityPolicy values.
type SecurityPolicyListResultIterator struct {
	i    int
	page SecurityPolicyListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SecurityPolicyListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SecurityPolicyListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SecurityPolicyListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SecurityPolicyListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SecurityPolicyListResultIterator) Response() SecurityPolicyListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SecurityPolicyListResultIterator) Value() SecurityPolicy {
	if !iter.page.NotDone() {
		return SecurityPolicy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SecurityPolicyListResultIterator type.
func NewSecurityPolicyListResultIterator(page SecurityPolicyListResultPage) SecurityPolicyListResultIterator {
	return SecurityPolicyListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (splr SecurityPolicyListResult) IsEmpty() bool {
	return splr.Value == nil || len(*splr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (splr SecurityPolicyListResult) hasNextLink() bool {
	return splr.NextLink != nil && len(*splr.NextLink) != 0
}

// securityPolicyListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (splr SecurityPolicyListResult) securityPolicyListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !splr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(splr.NextLink)))
}

// SecurityPolicyListResultPage contains a page of SecurityPolicy values.
type SecurityPolicyListResultPage struct {
	fn   func(context.Context, SecurityPolicyListResult) (SecurityPolicyListResult, error)
	splr SecurityPolicyListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SecurityPolicyListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SecurityPolicyListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.splr)
		if err != nil {
			return err
		}
		page.splr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SecurityPolicyListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SecurityPolicyListResultPage) NotDone() bool {
	return !page.splr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SecurityPolicyListResultPage) Response() SecurityPolicyListResult {
	return page.splr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SecurityPolicyListResultPage) Values() []SecurityPolicy {
	if page.splr.IsEmpty() {
		return nil
	}
	return *page.splr.Value
}

// Creates a new instance of the SecurityPolicyListResultPage type.
func NewSecurityPolicyListResultPage(cur SecurityPolicyListResult, getNextPage func(context.Context, SecurityPolicyListResult) (SecurityPolicyListResult, error)) SecurityPolicyListResultPage {
	return SecurityPolicyListResultPage{
		fn:   getNextPage,
		splr: cur,
	}
}

// SecurityPolicyProperties the json object that contains properties required to create a security policy
type SecurityPolicyProperties struct {
	// ProfileName - READ-ONLY; The name of the profile which holds the security policy.
	ProfileName *string `json:"profileName,omitempty"`
	// Parameters - object which contains security policy parameters
	Parameters BasicSecurityPolicyPropertiesParameters `json:"parameters,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning status. Possible values include: 'AfdProvisioningStateSucceeded', 'AfdProvisioningStateFailed', 'AfdProvisioningStateUpdating', 'AfdProvisioningStateDeleting', 'AfdProvisioningStateCreating'
	ProvisioningState AfdProvisioningState `json:"provisioningState,omitempty"`
	// DeploymentStatus - READ-ONLY; Possible values include: 'DeploymentStatusNotStarted', 'DeploymentStatusInProgress', 'DeploymentStatusSucceeded', 'DeploymentStatusFailed'
	DeploymentStatus DeploymentStatus `json:"deploymentStatus,omitempty"`
}

// MarshalJSON is the custom marshaler for SecurityPolicyProperties.
func (spp SecurityPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["parameters"] = spp.Parameters
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SecurityPolicyProperties struct.
func (spp *SecurityPolicyProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "profileName":
			if v != nil {
				var profileName string
				err = json.Unmarshal(*v, &profileName)
				if err != nil {
					return err
				}
				spp.ProfileName = &profileName
			}
		case "parameters":
			if v != nil {
				parameters, err := unmarshalBasicSecurityPolicyPropertiesParameters(*v)
				if err != nil {
					return err
				}
				spp.Parameters = parameters
			}
		case "provisioningState":
			if v != nil {
				var provisioningState AfdProvisioningState
				err = json.Unmarshal(*v, &provisioningState)
				if err != nil {
					return err
				}
				spp.ProvisioningState = provisioningState
			}
		case "deploymentStatus":
			if v != nil {
				var deploymentStatus DeploymentStatus
				err = json.Unmarshal(*v, &deploymentStatus)
				if err != nil {
					return err
				}
				spp.DeploymentStatus = deploymentStatus
			}
		}
	}

	return nil
}

// BasicSecurityPolicyPropertiesParameters the json object containing security policy parameters
type BasicSecurityPolicyPropertiesParameters interface {
	AsSecurityPolicyWebApplicationFirewallParameters() (*SecurityPolicyWebApplicationFirewallParameters, bool)
	AsSecurityPolicyPropertiesParameters() (*SecurityPolicyPropertiesParameters, bool)
}

// SecurityPolicyPropertiesParameters the json object containing security policy parameters
type SecurityPolicyPropertiesParameters struct {
	// Type - Possible values include: 'TypeSecurityPolicyPropertiesParameters', 'TypeWebApplicationFirewall'
	Type Type `json:"type,omitempty"`
}

func unmarshalBasicSecurityPolicyPropertiesParameters(body []byte) (BasicSecurityPolicyPropertiesParameters, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeWebApplicationFirewall):
		var spwafp SecurityPolicyWebApplicationFirewallParameters
		err := json.Unmarshal(body, &spwafp)
		return spwafp, err
	default:
		var sppp SecurityPolicyPropertiesParameters
		err := json.Unmarshal(body, &sppp)
		return sppp, err
	}
}
func unmarshalBasicSecurityPolicyPropertiesParametersArray(body []byte) ([]BasicSecurityPolicyPropertiesParameters, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	spppArray := make([]BasicSecurityPolicyPropertiesParameters, len(rawMessages))

	for index, rawMessage := range rawMessages {
		sppp, err := unmarshalBasicSecurityPolicyPropertiesParameters(*rawMessage)
		if err != nil {
			return nil, err
		}
		spppArray[index] = sppp
	}
	return spppArray, nil
}

// MarshalJSON is the custom marshaler for SecurityPolicyPropertiesParameters.
func (sppp SecurityPolicyPropertiesParameters) MarshalJSON() ([]byte, error) {
	sppp.Type = TypeSecurityPolicyPropertiesParameters
	objectMap := make(map[string]interface{})
	if sppp.Type != "" {
		objectMap["type"] = sppp.Type
	}
	return json.Marshal(objectMap)
}

// AsSecurityPolicyWebApplicationFirewallParameters is the BasicSecurityPolicyPropertiesParameters implementation for SecurityPolicyPropertiesParameters.
func (sppp SecurityPolicyPropertiesParameters) AsSecurityPolicyWebApplicationFirewallParameters() (*SecurityPolicyWebApplicationFirewallParameters, bool) {
	return nil, false
}

// AsSecurityPolicyPropertiesParameters is the BasicSecurityPolicyPropertiesParameters implementation for SecurityPolicyPropertiesParameters.
func (sppp SecurityPolicyPropertiesParameters) AsSecurityPolicyPropertiesParameters() (*SecurityPolicyPropertiesParameters, bool) {
	return &sppp, true
}

// AsBasicSecurityPolicyPropertiesParameters is the BasicSecurityPolicyPropertiesParameters implementation for SecurityPolicyPropertiesParameters.
func (sppp SecurityPolicyPropertiesParameters) AsBasicSecurityPolicyPropertiesParameters() (BasicSecurityPolicyPropertiesParameters, bool) {
	return &sppp, true
}

// SecurityPolicyUpdateParameters the JSON object containing security policy update parameters.
type SecurityPolicyUpdateParameters struct {
	*SecurityPolicyUpdateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for SecurityPolicyUpdateParameters.
func (spup SecurityPolicyUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if spup.SecurityPolicyUpdateProperties != nil {
		objectMap["properties"] = spup.SecurityPolicyUpdateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SecurityPolicyUpdateParameters struct.
func (spup *SecurityPolicyUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var securityPolicyUpdateProperties SecurityPolicyUpdateProperties
				err = json.Unmarshal(*v, &securityPolicyUpdateProperties)
				if err != nil {
					return err
				}
				spup.SecurityPolicyUpdateProperties = &securityPolicyUpdateProperties
			}
		}
	}

	return nil
}

// SecurityPolicyUpdateProperties the json object that contains properties required to update a security
// policy
type SecurityPolicyUpdateProperties struct {
	// Parameters - object which contains security policy parameters
	Parameters BasicSecurityPolicyPropertiesParameters `json:"parameters,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for SecurityPolicyUpdateProperties struct.
func (spup *SecurityPolicyUpdateProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "parameters":
			if v != nil {
				parameters, err := unmarshalBasicSecurityPolicyPropertiesParameters(*v)
				if err != nil {
					return err
				}
				spup.Parameters = parameters
			}
		}
	}

	return nil
}

// SecurityPolicyWebApplicationFirewallAssociation settings for security policy patterns to match
type SecurityPolicyWebApplicationFirewallAssociation struct {
	// Domains - List of domains.
	Domains *[]ActivatedResourceReference `json:"domains,omitempty"`
	// PatternsToMatch - List of paths
	PatternsToMatch *[]string `json:"patternsToMatch,omitempty"`
}

// SecurityPolicyWebApplicationFirewallParameters the json object containing security policy waf parameters
type SecurityPolicyWebApplicationFirewallParameters struct {
	// WafPolicy - Resource ID.
	WafPolicy *ResourceReference `json:"wafPolicy,omitempty"`
	// Associations - Waf associations
	Associations *[]SecurityPolicyWebApplicationFirewallAssociation `json:"associations,omitempty"`
	// Type - Possible values include: 'TypeSecurityPolicyPropertiesParameters', 'TypeWebApplicationFirewall'
	Type Type `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SecurityPolicyWebApplicationFirewallParameters.
func (spwafp SecurityPolicyWebApplicationFirewallParameters) MarshalJSON() ([]byte, error) {
	spwafp.Type = TypeWebApplicationFirewall
	objectMap := make(map[string]interface{})
	if spwafp.WafPolicy != nil {
		objectMap["wafPolicy"] = spwafp.WafPolicy
	}
	if spwafp.Associations != nil {
		objectMap["associations"] = spwafp.Associations
	}
	if spwafp.Type != "" {
		objectMap["type"] = spwafp.Type
	}
	return json.Marshal(objectMap)
}

// AsSecurityPolicyWebApplicationFirewallParameters is the BasicSecurityPolicyPropertiesParameters implementation for SecurityPolicyWebApplicationFirewallParameters.
func (spwafp SecurityPolicyWebApplicationFirewallParameters) AsSecurityPolicyWebApplicationFirewallParameters() (*SecurityPolicyWebApplicationFirewallParameters, bool) {
	return &spwafp, true
}

// AsSecurityPolicyPropertiesParameters is the BasicSecurityPolicyPropertiesParameters implementation for SecurityPolicyWebApplicationFirewallParameters.
func (spwafp SecurityPolicyWebApplicationFirewallParameters) AsSecurityPolicyPropertiesParameters() (*SecurityPolicyPropertiesParameters, bool) {
	return nil, false
}

// AsBasicSecurityPolicyPropertiesParameters is the BasicSecurityPolicyPropertiesParameters implementation for SecurityPolicyWebApplicationFirewallParameters.
func (spwafp SecurityPolicyWebApplicationFirewallParameters) AsBasicSecurityPolicyPropertiesParameters() (BasicSecurityPolicyPropertiesParameters, bool) {
	return &spwafp, true
}

// ServerPortMatchConditionParameters defines the parameters for ServerPort match conditions
type ServerPortMatchConditionParameters struct {
	TypeName *string `json:"typeName,omitempty"`
	// Operator - Describes operator to be matched. Possible values include: 'ServerPortOperatorAny', 'ServerPortOperatorEqual', 'ServerPortOperatorContains', 'ServerPortOperatorBeginsWith', 'ServerPortOperatorEndsWith', 'ServerPortOperatorLessThan', 'ServerPortOperatorLessThanOrEqual', 'ServerPortOperatorGreaterThan', 'ServerPortOperatorGreaterThanOrEqual', 'ServerPortOperatorRegEx'
	Operator ServerPortOperator `json:"operator,omitempty"`
	// NegateCondition - Describes if this is negate condition or not
	NegateCondition *bool `json:"negateCondition,omitempty"`
	// MatchValues - The match value for the condition of the delivery rule
	MatchValues *[]string `json:"matchValues,omitempty"`
	// Transforms - List of transforms
	Transforms *[]Transform `json:"transforms,omitempty"`
}

// ServiceSpecification one property of operation, include log specifications.
type ServiceSpecification struct {
	// LogSpecifications - Log specifications of operation.
	LogSpecifications *[]LogSpecification `json:"logSpecifications,omitempty"`
	// MetricSpecifications - Metric specifications of operation.
	MetricSpecifications *[]MetricSpecification `json:"metricSpecifications,omitempty"`
}

// SharedPrivateLinkResourceProperties describes the properties of an existing Shared Private Link Resource
// to use when connecting to a private origin.
type SharedPrivateLinkResourceProperties struct {
	// PrivateLink - The resource id of the resource the shared private link resource is for.
	PrivateLink *ResourceReference `json:"privateLink,omitempty"`
	// PrivateLinkLocation - The location of the shared private link resource
	PrivateLinkLocation *string `json:"privateLinkLocation,omitempty"`
	// GroupID - The group id from the provider of resource the shared private link resource is for.
	GroupID *string `json:"groupId,omitempty"`
	// RequestMessage - The request message for requesting approval of the shared private link resource.
	RequestMessage *string `json:"requestMessage,omitempty"`
	// Status - Status of the shared private link resource. Can be Pending, Approved, Rejected, Disconnected, or Timeout. Possible values include: 'SharedPrivateLinkResourceStatusPending', 'SharedPrivateLinkResourceStatusApproved', 'SharedPrivateLinkResourceStatusRejected', 'SharedPrivateLinkResourceStatusDisconnected', 'SharedPrivateLinkResourceStatusTimeout'
	Status SharedPrivateLinkResourceStatus `json:"status,omitempty"`
}

// Sku standard_Verizon = The SKU name for a Standard Verizon CDN profile.
// Premium_Verizon = The SKU name for a Premium Verizon CDN profile.
// Custom_Verizon = The SKU name for a Custom Verizon CDN profile.
// Standard_Akamai = The SKU name for an Akamai CDN profile.
// Standard_ChinaCdn = The SKU name for a China CDN profile for VOD, Web and download scenarios using GB
// based billing model.
// Standard_Microsoft = The SKU name for a Standard Microsoft CDN profile.
// Standard_AzureFrontDoor =  The SKU name for an Azure Front Door Standard profile.
// Premium_AzureFrontDoor = The SKU name for an Azure Front Door Premium profile.
// Standard_955BandWidth_ChinaCdn = The SKU name for a China CDN profile for VOD, Web and download
// scenarios using 95-5 peak bandwidth billing model.
// Standard_AvgBandWidth_ChinaCdn = The SKU name for a China CDN profile for VOD, Web and download
// scenarios using monthly average peak bandwidth billing model.
// StandardPlus_ChinaCdn = The SKU name for a China CDN profile for live-streaming using GB based billing
// model.
// StandardPlus_955BandWidth_ChinaCdn = The SKU name for a China CDN live-streaming profile using 95-5 peak
// bandwidth billing model.
// StandardPlus_AvgBandWidth_ChinaCdn = The SKU name for a China CDN live-streaming profile using monthly
// average peak bandwidth billing model.
type Sku struct {
	// Name - Name of the pricing tier. Possible values include: 'SkuNameStandardVerizon', 'SkuNamePremiumVerizon', 'SkuNameCustomVerizon', 'SkuNameStandardAkamai', 'SkuNameStandardChinaCdn', 'SkuNameStandardMicrosoft', 'SkuNameStandardAzureFrontDoor', 'SkuNamePremiumAzureFrontDoor', 'SkuNameStandard955BandWidthChinaCdn', 'SkuNameStandardAvgBandWidthChinaCdn', 'SkuNameStandardPlusChinaCdn', 'SkuNameStandardPlus955BandWidthChinaCdn', 'SkuNameStandardPlusAvgBandWidthChinaCdn'
	Name SkuName `json:"name,omitempty"`
}

// SocketAddrMatchConditionParameters defines the parameters for SocketAddress match conditions
type SocketAddrMatchConditionParameters struct {
	TypeName *string `json:"typeName,omitempty"`
	// Operator - Describes operator to be matched. Possible values include: 'SocketAddrOperatorAny', 'SocketAddrOperatorIPMatch'
	Operator SocketAddrOperator `json:"operator,omitempty"`
	// NegateCondition - Describes if this is negate condition or not
	NegateCondition *bool `json:"negateCondition,omitempty"`
	// MatchValues - The match value for the condition of the delivery rule
	MatchValues *[]string `json:"matchValues,omitempty"`
	// Transforms - List of transforms
	Transforms *[]Transform `json:"transforms,omitempty"`
}

// SslProtocolMatchConditionParameters defines the parameters for SslProtocol match conditions
type SslProtocolMatchConditionParameters struct {
	TypeName *string `json:"typeName,omitempty"`
	// Operator - Describes operator to be matched
	Operator *string `json:"operator,omitempty"`
	// NegateCondition - Describes if this is negate condition or not
	NegateCondition *bool `json:"negateCondition,omitempty"`
	// MatchValues - The match value for the condition of the delivery rule
	MatchValues *[]SslProtocol `json:"matchValues,omitempty"`
	// Transforms - List of transforms
	Transforms *[]Transform `json:"transforms,omitempty"`
}

// SsoURI the URI required to login to the supplemental portal from the Azure portal.
type SsoURI struct {
	autorest.Response `json:"-"`
	// SsoURIValue - READ-ONLY; The URI used to login to the supplemental portal.
	SsoURIValue *string `json:"ssoUriValue,omitempty"`
}

// MarshalJSON is the custom marshaler for SsoURI.
func (su SsoURI) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// SupportedOptimizationTypesListResult the result of the GetSupportedOptimizationTypes API
type SupportedOptimizationTypesListResult struct {
	autorest.Response `json:"-"`
	// SupportedOptimizationTypes - READ-ONLY; Supported optimization types for a profile.
	SupportedOptimizationTypes *[]OptimizationType `json:"supportedOptimizationTypes,omitempty"`
}

// MarshalJSON is the custom marshaler for SupportedOptimizationTypesListResult.
func (sotlr SupportedOptimizationTypesListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// SystemData read only system data
type SystemData struct {
	// CreatedBy - An identifier for the identity that created the resource
	CreatedBy *string `json:"createdBy,omitempty"`
	// CreatedByType - The type of identity that created the resource. Possible values include: 'IdentityTypeUser', 'IdentityTypeApplication', 'IdentityTypeManagedIdentity', 'IdentityTypeKey'
	CreatedByType IdentityType `json:"createdByType,omitempty"`
	// CreatedAt - The timestamp of resource creation (UTC)
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// LastModifiedBy - An identifier for the identity that last modified the resource
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// LastModifiedByType - The type of identity that last modified the resource. Possible values include: 'IdentityTypeUser', 'IdentityTypeApplication', 'IdentityTypeManagedIdentity', 'IdentityTypeKey'
	LastModifiedByType IdentityType `json:"lastModifiedByType,omitempty"`
	// LastModifiedAt - The timestamp of resource last modification (UTC)
	LastModifiedAt *date.Time `json:"lastModifiedAt,omitempty"`
}

// TrackedResource the resource model definition for a ARM tracked top level resource.
type TrackedResource struct {
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	return json.Marshal(objectMap)
}

// URLFileExtensionMatchConditionParameters defines the parameters for UrlFileExtension match conditions
type URLFileExtensionMatchConditionParameters struct {
	TypeName *string `json:"typeName,omitempty"`
	// Operator - Describes operator to be matched. Possible values include: 'URLFileExtensionOperatorAny', 'URLFileExtensionOperatorEqual', 'URLFileExtensionOperatorContains', 'URLFileExtensionOperatorBeginsWith', 'URLFileExtensionOperatorEndsWith', 'URLFileExtensionOperatorLessThan', 'URLFileExtensionOperatorLessThanOrEqual', 'URLFileExtensionOperatorGreaterThan', 'URLFileExtensionOperatorGreaterThanOrEqual', 'URLFileExtensionOperatorRegEx'
	Operator URLFileExtensionOperator `json:"operator,omitempty"`
	// NegateCondition - Describes if this is negate condition or not
	NegateCondition *bool `json:"negateCondition,omitempty"`
	// MatchValues - The match value for the condition of the delivery rule
	MatchValues *[]string `json:"matchValues,omitempty"`
	// Transforms - List of transforms
	Transforms *[]Transform `json:"transforms,omitempty"`
}

// URLFileNameMatchConditionParameters defines the parameters for UrlFilename match conditions
type URLFileNameMatchConditionParameters struct {
	TypeName *string `json:"typeName,omitempty"`
	// Operator - Describes operator to be matched. Possible values include: 'URLFileNameOperatorAny', 'URLFileNameOperatorEqual', 'URLFileNameOperatorContains', 'URLFileNameOperatorBeginsWith', 'URLFileNameOperatorEndsWith', 'URLFileNameOperatorLessThan', 'URLFileNameOperatorLessThanOrEqual', 'URLFileNameOperatorGreaterThan', 'URLFileNameOperatorGreaterThanOrEqual', 'URLFileNameOperatorRegEx'
	Operator URLFileNameOperator `json:"operator,omitempty"`
	// NegateCondition - Describes if this is negate condition or not
	NegateCondition *bool `json:"negateCondition,omitempty"`
	// MatchValues - The match value for the condition of the delivery rule
	MatchValues *[]string `json:"matchValues,omitempty"`
	// Transforms - List of transforms
	Transforms *[]Transform `json:"transforms,omitempty"`
}

// URLPathMatchConditionParameters defines the parameters for UrlPath match conditions
type URLPathMatchConditionParameters struct {
	TypeName *string `json:"typeName,omitempty"`
	// Operator - Describes operator to be matched. Possible values include: 'URLPathOperatorAny', 'URLPathOperatorEqual', 'URLPathOperatorContains', 'URLPathOperatorBeginsWith', 'URLPathOperatorEndsWith', 'URLPathOperatorLessThan', 'URLPathOperatorLessThanOrEqual', 'URLPathOperatorGreaterThan', 'URLPathOperatorGreaterThanOrEqual', 'URLPathOperatorWildcard', 'URLPathOperatorRegEx'
	Operator URLPathOperator `json:"operator,omitempty"`
	// NegateCondition - Describes if this is negate condition or not
	NegateCondition *bool `json:"negateCondition,omitempty"`
	// MatchValues - The match value for the condition of the delivery rule
	MatchValues *[]string `json:"matchValues,omitempty"`
	// Transforms - List of transforms
	Transforms *[]Transform `json:"transforms,omitempty"`
}

// URLRedirectAction defines the url redirect action for the delivery rule.
type URLRedirectAction struct {
	// Parameters - Defines the parameters for the action.
	Parameters *URLRedirectActionParameters `json:"parameters,omitempty"`
	// Name - Possible values include: 'NameBasicDeliveryRuleActionNameDeliveryRuleAction', 'NameBasicDeliveryRuleActionNameRouteConfigurationOverride', 'NameBasicDeliveryRuleActionNameCacheKeyQueryString', 'NameBasicDeliveryRuleActionNameCacheExpiration', 'NameBasicDeliveryRuleActionNameModifyResponseHeader', 'NameBasicDeliveryRuleActionNameModifyRequestHeader', 'NameBasicDeliveryRuleActionNameURLRewrite', 'NameBasicDeliveryRuleActionNameOriginGroupOverride', 'NameBasicDeliveryRuleActionNameURLSigning', 'NameBasicDeliveryRuleActionNameURLRedirect'
	Name NameBasicDeliveryRuleAction `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for URLRedirectAction.
func (ura URLRedirectAction) MarshalJSON() ([]byte, error) {
	ura.Name = NameBasicDeliveryRuleActionNameURLRedirect
	objectMap := make(map[string]interface{})
	if ura.Parameters != nil {
		objectMap["parameters"] = ura.Parameters
	}
	if ura.Name != "" {
		objectMap["name"] = ura.Name
	}
	return json.Marshal(objectMap)
}

// AsDeliveryRuleRouteConfigurationOverrideAction is the BasicDeliveryRuleAction implementation for URLRedirectAction.
func (ura URLRedirectAction) AsDeliveryRuleRouteConfigurationOverrideAction() (*DeliveryRuleRouteConfigurationOverrideAction, bool) {
	return nil, false
}

// AsDeliveryRuleCacheKeyQueryStringAction is the BasicDeliveryRuleAction implementation for URLRedirectAction.
func (ura URLRedirectAction) AsDeliveryRuleCacheKeyQueryStringAction() (*DeliveryRuleCacheKeyQueryStringAction, bool) {
	return nil, false
}

// AsDeliveryRuleCacheExpirationAction is the BasicDeliveryRuleAction implementation for URLRedirectAction.
func (ura URLRedirectAction) AsDeliveryRuleCacheExpirationAction() (*DeliveryRuleCacheExpirationAction, bool) {
	return nil, false
}

// AsDeliveryRuleResponseHeaderAction is the BasicDeliveryRuleAction implementation for URLRedirectAction.
func (ura URLRedirectAction) AsDeliveryRuleResponseHeaderAction() (*DeliveryRuleResponseHeaderAction, bool) {
	return nil, false
}

// AsDeliveryRuleRequestHeaderAction is the BasicDeliveryRuleAction implementation for URLRedirectAction.
func (ura URLRedirectAction) AsDeliveryRuleRequestHeaderAction() (*DeliveryRuleRequestHeaderAction, bool) {
	return nil, false
}

// AsURLRewriteAction is the BasicDeliveryRuleAction implementation for URLRedirectAction.
func (ura URLRedirectAction) AsURLRewriteAction() (*URLRewriteAction, bool) {
	return nil, false
}

// AsOriginGroupOverrideAction is the BasicDeliveryRuleAction implementation for URLRedirectAction.
func (ura URLRedirectAction) AsOriginGroupOverrideAction() (*OriginGroupOverrideAction, bool) {
	return nil, false
}

// AsURLSigningAction is the BasicDeliveryRuleAction implementation for URLRedirectAction.
func (ura URLRedirectAction) AsURLSigningAction() (*URLSigningAction, bool) {
	return nil, false
}

// AsURLRedirectAction is the BasicDeliveryRuleAction implementation for URLRedirectAction.
func (ura URLRedirectAction) AsURLRedirectAction() (*URLRedirectAction, bool) {
	return &ura, true
}

// AsDeliveryRuleAction is the BasicDeliveryRuleAction implementation for URLRedirectAction.
func (ura URLRedirectAction) AsDeliveryRuleAction() (*DeliveryRuleAction, bool) {
	return nil, false
}

// AsBasicDeliveryRuleAction is the BasicDeliveryRuleAction implementation for URLRedirectAction.
func (ura URLRedirectAction) AsBasicDeliveryRuleAction() (BasicDeliveryRuleAction, bool) {
	return &ura, true
}

// URLRedirectActionParameters defines the parameters for the url redirect action.
type URLRedirectActionParameters struct {
	TypeName *string `json:"typeName,omitempty"`
	// RedirectType - The redirect type the rule will use when redirecting traffic. Possible values include: 'RedirectTypeMoved', 'RedirectTypeFound', 'RedirectTypeTemporaryRedirect', 'RedirectTypePermanentRedirect'
	RedirectType RedirectType `json:"redirectType,omitempty"`
	// DestinationProtocol - Protocol to use for the redirect. The default value is MatchRequest. Possible values include: 'DestinationProtocolMatchRequest', 'DestinationProtocolHTTP', 'DestinationProtocolHTTPS'
	DestinationProtocol DestinationProtocol `json:"destinationProtocol,omitempty"`
	// CustomPath - The full path to redirect. Path cannot be empty and must start with /. Leave empty to use the incoming path as destination path.
	CustomPath *string `json:"customPath,omitempty"`
	// CustomHostname - Host to redirect. Leave empty to use the incoming host as the destination host.
	CustomHostname *string `json:"customHostname,omitempty"`
	// CustomQueryString - The set of query strings to be placed in the redirect URL. Setting this value would replace any existing query string; leave empty to preserve the incoming query string. Query string must be in <key>=<value> format. ? and & will be added automatically so do not include them.
	CustomQueryString *string `json:"customQueryString,omitempty"`
	// CustomFragment - Fragment to add to the redirect URL. Fragment is the part of the URL that comes after #. Do not include the #.
	CustomFragment *string `json:"customFragment,omitempty"`
}

// URLRewriteAction defines the url rewrite action for the delivery rule.
type URLRewriteAction struct {
	// Parameters - Defines the parameters for the action.
	Parameters *URLRewriteActionParameters `json:"parameters,omitempty"`
	// Name - Possible values include: 'NameBasicDeliveryRuleActionNameDeliveryRuleAction', 'NameBasicDeliveryRuleActionNameRouteConfigurationOverride', 'NameBasicDeliveryRuleActionNameCacheKeyQueryString', 'NameBasicDeliveryRuleActionNameCacheExpiration', 'NameBasicDeliveryRuleActionNameModifyResponseHeader', 'NameBasicDeliveryRuleActionNameModifyRequestHeader', 'NameBasicDeliveryRuleActionNameURLRewrite', 'NameBasicDeliveryRuleActionNameOriginGroupOverride', 'NameBasicDeliveryRuleActionNameURLSigning', 'NameBasicDeliveryRuleActionNameURLRedirect'
	Name NameBasicDeliveryRuleAction `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for URLRewriteAction.
func (ura URLRewriteAction) MarshalJSON() ([]byte, error) {
	ura.Name = NameBasicDeliveryRuleActionNameURLRewrite
	objectMap := make(map[string]interface{})
	if ura.Parameters != nil {
		objectMap["parameters"] = ura.Parameters
	}
	if ura.Name != "" {
		objectMap["name"] = ura.Name
	}
	return json.Marshal(objectMap)
}

// AsDeliveryRuleRouteConfigurationOverrideAction is the BasicDeliveryRuleAction implementation for URLRewriteAction.
func (ura URLRewriteAction) AsDeliveryRuleRouteConfigurationOverrideAction() (*DeliveryRuleRouteConfigurationOverrideAction, bool) {
	return nil, false
}

// AsDeliveryRuleCacheKeyQueryStringAction is the BasicDeliveryRuleAction implementation for URLRewriteAction.
func (ura URLRewriteAction) AsDeliveryRuleCacheKeyQueryStringAction() (*DeliveryRuleCacheKeyQueryStringAction, bool) {
	return nil, false
}

// AsDeliveryRuleCacheExpirationAction is the BasicDeliveryRuleAction implementation for URLRewriteAction.
func (ura URLRewriteAction) AsDeliveryRuleCacheExpirationAction() (*DeliveryRuleCacheExpirationAction, bool) {
	return nil, false
}

// AsDeliveryRuleResponseHeaderAction is the BasicDeliveryRuleAction implementation for URLRewriteAction.
func (ura URLRewriteAction) AsDeliveryRuleResponseHeaderAction() (*DeliveryRuleResponseHeaderAction, bool) {
	return nil, false
}

// AsDeliveryRuleRequestHeaderAction is the BasicDeliveryRuleAction implementation for URLRewriteAction.
func (ura URLRewriteAction) AsDeliveryRuleRequestHeaderAction() (*DeliveryRuleRequestHeaderAction, bool) {
	return nil, false
}

// AsURLRewriteAction is the BasicDeliveryRuleAction implementation for URLRewriteAction.
func (ura URLRewriteAction) AsURLRewriteAction() (*URLRewriteAction, bool) {
	return &ura, true
}

// AsOriginGroupOverrideAction is the BasicDeliveryRuleAction implementation for URLRewriteAction.
func (ura URLRewriteAction) AsOriginGroupOverrideAction() (*OriginGroupOverrideAction, bool) {
	return nil, false
}

// AsURLSigningAction is the BasicDeliveryRuleAction implementation for URLRewriteAction.
func (ura URLRewriteAction) AsURLSigningAction() (*URLSigningAction, bool) {
	return nil, false
}

// AsURLRedirectAction is the BasicDeliveryRuleAction implementation for URLRewriteAction.
func (ura URLRewriteAction) AsURLRedirectAction() (*URLRedirectAction, bool) {
	return nil, false
}

// AsDeliveryRuleAction is the BasicDeliveryRuleAction implementation for URLRewriteAction.
func (ura URLRewriteAction) AsDeliveryRuleAction() (*DeliveryRuleAction, bool) {
	return nil, false
}

// AsBasicDeliveryRuleAction is the BasicDeliveryRuleAction implementation for URLRewriteAction.
func (ura URLRewriteAction) AsBasicDeliveryRuleAction() (BasicDeliveryRuleAction, bool) {
	return &ura, true
}

// URLRewriteActionParameters defines the parameters for the url rewrite action.
type URLRewriteActionParameters struct {
	TypeName *string `json:"typeName,omitempty"`
	// SourcePattern - define a request URI pattern that identifies the type of requests that may be rewritten. If value is blank, all strings are matched.
	SourcePattern *string `json:"sourcePattern,omitempty"`
	// Destination - Define the relative URL to which the above requests will be rewritten by.
	Destination *string `json:"destination,omitempty"`
	// PreserveUnmatchedPath - Whether to preserve unmatched path. Default value is true.
	PreserveUnmatchedPath *bool `json:"preserveUnmatchedPath,omitempty"`
}

// URLSigningAction defines the url signing action for the delivery rule.
type URLSigningAction struct {
	// Parameters - Defines the parameters for the action.
	Parameters *URLSigningActionParameters `json:"parameters,omitempty"`
	// Name - Possible values include: 'NameBasicDeliveryRuleActionNameDeliveryRuleAction', 'NameBasicDeliveryRuleActionNameRouteConfigurationOverride', 'NameBasicDeliveryRuleActionNameCacheKeyQueryString', 'NameBasicDeliveryRuleActionNameCacheExpiration', 'NameBasicDeliveryRuleActionNameModifyResponseHeader', 'NameBasicDeliveryRuleActionNameModifyRequestHeader', 'NameBasicDeliveryRuleActionNameURLRewrite', 'NameBasicDeliveryRuleActionNameOriginGroupOverride', 'NameBasicDeliveryRuleActionNameURLSigning', 'NameBasicDeliveryRuleActionNameURLRedirect'
	Name NameBasicDeliveryRuleAction `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for URLSigningAction.
func (usa URLSigningAction) MarshalJSON() ([]byte, error) {
	usa.Name = NameBasicDeliveryRuleActionNameURLSigning
	objectMap := make(map[string]interface{})
	if usa.Parameters != nil {
		objectMap["parameters"] = usa.Parameters
	}
	if usa.Name != "" {
		objectMap["name"] = usa.Name
	}
	return json.Marshal(objectMap)
}

// AsDeliveryRuleRouteConfigurationOverrideAction is the BasicDeliveryRuleAction implementation for URLSigningAction.
func (usa URLSigningAction) AsDeliveryRuleRouteConfigurationOverrideAction() (*DeliveryRuleRouteConfigurationOverrideAction, bool) {
	return nil, false
}

// AsDeliveryRuleCacheKeyQueryStringAction is the BasicDeliveryRuleAction implementation for URLSigningAction.
func (usa URLSigningAction) AsDeliveryRuleCacheKeyQueryStringAction() (*DeliveryRuleCacheKeyQueryStringAction, bool) {
	return nil, false
}

// AsDeliveryRuleCacheExpirationAction is the BasicDeliveryRuleAction implementation for URLSigningAction.
func (usa URLSigningAction) AsDeliveryRuleCacheExpirationAction() (*DeliveryRuleCacheExpirationAction, bool) {
	return nil, false
}

// AsDeliveryRuleResponseHeaderAction is the BasicDeliveryRuleAction implementation for URLSigningAction.
func (usa URLSigningAction) AsDeliveryRuleResponseHeaderAction() (*DeliveryRuleResponseHeaderAction, bool) {
	return nil, false
}

// AsDeliveryRuleRequestHeaderAction is the BasicDeliveryRuleAction implementation for URLSigningAction.
func (usa URLSigningAction) AsDeliveryRuleRequestHeaderAction() (*DeliveryRuleRequestHeaderAction, bool) {
	return nil, false
}

// AsURLRewriteAction is the BasicDeliveryRuleAction implementation for URLSigningAction.
func (usa URLSigningAction) AsURLRewriteAction() (*URLRewriteAction, bool) {
	return nil, false
}

// AsOriginGroupOverrideAction is the BasicDeliveryRuleAction implementation for URLSigningAction.
func (usa URLSigningAction) AsOriginGroupOverrideAction() (*OriginGroupOverrideAction, bool) {
	return nil, false
}

// AsURLSigningAction is the BasicDeliveryRuleAction implementation for URLSigningAction.
func (usa URLSigningAction) AsURLSigningAction() (*URLSigningAction, bool) {
	return &usa, true
}

// AsURLRedirectAction is the BasicDeliveryRuleAction implementation for URLSigningAction.
func (usa URLSigningAction) AsURLRedirectAction() (*URLRedirectAction, bool) {
	return nil, false
}

// AsDeliveryRuleAction is the BasicDeliveryRuleAction implementation for URLSigningAction.
func (usa URLSigningAction) AsDeliveryRuleAction() (*DeliveryRuleAction, bool) {
	return nil, false
}

// AsBasicDeliveryRuleAction is the BasicDeliveryRuleAction implementation for URLSigningAction.
func (usa URLSigningAction) AsBasicDeliveryRuleAction() (BasicDeliveryRuleAction, bool) {
	return &usa, true
}

// URLSigningActionParameters defines the parameters for the Url Signing action.
type URLSigningActionParameters struct {
	TypeName *string `json:"typeName,omitempty"`
	// Algorithm - Algorithm to use for URL signing. Possible values include: 'AlgorithmSHA256'
	Algorithm Algorithm `json:"algorithm,omitempty"`
	// ParameterNameOverride - Defines which query string parameters in the url to be considered for expires, key id etc.
	ParameterNameOverride *[]URLSigningParamIdentifier `json:"parameterNameOverride,omitempty"`
}

// URLSigningKey url signing key
type URLSigningKey struct {
	// KeyID - Defines the customer defined key Id. This id will exist in the incoming request to indicate the key used to form the hash.
	KeyID *string `json:"keyId,omitempty"`
	// KeySourceParameters - Defines the parameters for using customer key vault for Url Signing Key.
	KeySourceParameters *KeyVaultSigningKeyParameters `json:"keySourceParameters,omitempty"`
}

// URLSigningKeyParameters url signing key parameters
type URLSigningKeyParameters struct {
	// KeyID - Defines the customer defined key Id. This id will exist in the incoming request to indicate the key used to form the hash.
	KeyID *string `json:"keyId,omitempty"`
	// SecretSource - Resource reference to the Azure Key Vault secret. Expected to be in format of /subscriptions/{​​​​​​​​​subscriptionId}​​​​​​​​​/resourceGroups/{​​​​​​​​​resourceGroupName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/providers/Microsoft.KeyVault/vaults/{vaultName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/secrets/{secretName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​
	SecretSource *ResourceReference `json:"secretSource,omitempty"`
	// SecretVersion - Version of the secret to be used
	SecretVersion *string `json:"secretVersion,omitempty"`
	// Type - Possible values include: 'TypeBasicSecretParametersTypeSecretParameters', 'TypeBasicSecretParametersTypeURLSigningKey', 'TypeBasicSecretParametersTypeManagedCertificate', 'TypeBasicSecretParametersTypeCustomerCertificate', 'TypeBasicSecretParametersTypeAzureFirstPartyManagedCertificate'
	Type TypeBasicSecretParameters `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for URLSigningKeyParameters.
func (uskp URLSigningKeyParameters) MarshalJSON() ([]byte, error) {
	uskp.Type = TypeBasicSecretParametersTypeURLSigningKey
	objectMap := make(map[string]interface{})
	if uskp.KeyID != nil {
		objectMap["keyId"] = uskp.KeyID
	}
	if uskp.SecretSource != nil {
		objectMap["secretSource"] = uskp.SecretSource
	}
	if uskp.SecretVersion != nil {
		objectMap["secretVersion"] = uskp.SecretVersion
	}
	if uskp.Type != "" {
		objectMap["type"] = uskp.Type
	}
	return json.Marshal(objectMap)
}

// AsURLSigningKeyParameters is the BasicSecretParameters implementation for URLSigningKeyParameters.
func (uskp URLSigningKeyParameters) AsURLSigningKeyParameters() (*URLSigningKeyParameters, bool) {
	return &uskp, true
}

// AsManagedCertificateParameters is the BasicSecretParameters implementation for URLSigningKeyParameters.
func (uskp URLSigningKeyParameters) AsManagedCertificateParameters() (*ManagedCertificateParameters, bool) {
	return nil, false
}

// AsCustomerCertificateParameters is the BasicSecretParameters implementation for URLSigningKeyParameters.
func (uskp URLSigningKeyParameters) AsCustomerCertificateParameters() (*CustomerCertificateParameters, bool) {
	return nil, false
}

// AsAzureFirstPartyManagedCertificateParameters is the BasicSecretParameters implementation for URLSigningKeyParameters.
func (uskp URLSigningKeyParameters) AsAzureFirstPartyManagedCertificateParameters() (*AzureFirstPartyManagedCertificateParameters, bool) {
	return nil, false
}

// AsSecretParameters is the BasicSecretParameters implementation for URLSigningKeyParameters.
func (uskp URLSigningKeyParameters) AsSecretParameters() (*SecretParameters, bool) {
	return nil, false
}

// AsBasicSecretParameters is the BasicSecretParameters implementation for URLSigningKeyParameters.
func (uskp URLSigningKeyParameters) AsBasicSecretParameters() (BasicSecretParameters, bool) {
	return &uskp, true
}

// URLSigningParamIdentifier defines how to identify a parameter for a specific purpose e.g. expires
type URLSigningParamIdentifier struct {
	// ParamIndicator - Indicates the purpose of the parameter. Possible values include: 'ParamIndicatorExpires', 'ParamIndicatorKeyID', 'ParamIndicatorSignature'
	ParamIndicator ParamIndicator `json:"paramIndicator,omitempty"`
	// ParamName - Parameter name
	ParamName *string `json:"paramName,omitempty"`
}

// Usage describes resource usage.
type Usage struct {
	// ID - READ-ONLY; Resource identifier.
	ID *string `json:"id,omitempty"`
	// Unit - An enum describing the unit of measurement.
	Unit *string `json:"unit,omitempty"`
	// CurrentValue - The current value of the usage.
	CurrentValue *int64 `json:"currentValue,omitempty"`
	// Limit - The limit of usage.
	Limit *int64 `json:"limit,omitempty"`
	// Name - The name of the type of usage.
	Name *UsageName `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for Usage.
func (u Usage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if u.Unit != nil {
		objectMap["unit"] = u.Unit
	}
	if u.CurrentValue != nil {
		objectMap["currentValue"] = u.CurrentValue
	}
	if u.Limit != nil {
		objectMap["limit"] = u.Limit
	}
	if u.Name != nil {
		objectMap["name"] = u.Name
	}
	return json.Marshal(objectMap)
}

// UsageName the usage names.
type UsageName struct {
	// Value - A string describing the resource name.
	Value *string `json:"value,omitempty"`
	// LocalizedValue - A localized string describing the resource name.
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// UsagesListResult the list usages operation response.
type UsagesListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of resource usages.
	Value *[]Usage `json:"value,omitempty"`
	// NextLink - URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// UsagesListResultIterator provides access to a complete listing of Usage values.
type UsagesListResultIterator struct {
	i    int
	page UsagesListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *UsagesListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/UsagesListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *UsagesListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter UsagesListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter UsagesListResultIterator) Response() UsagesListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter UsagesListResultIterator) Value() Usage {
	if !iter.page.NotDone() {
		return Usage{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the UsagesListResultIterator type.
func NewUsagesListResultIterator(page UsagesListResultPage) UsagesListResultIterator {
	return UsagesListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ulr UsagesListResult) IsEmpty() bool {
	return ulr.Value == nil || len(*ulr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ulr UsagesListResult) hasNextLink() bool {
	return ulr.NextLink != nil && len(*ulr.NextLink) != 0
}

// usagesListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ulr UsagesListResult) usagesListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !ulr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ulr.NextLink)))
}

// UsagesListResultPage contains a page of Usage values.
type UsagesListResultPage struct {
	fn  func(context.Context, UsagesListResult) (UsagesListResult, error)
	ulr UsagesListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *UsagesListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/UsagesListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ulr)
		if err != nil {
			return err
		}
		page.ulr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *UsagesListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page UsagesListResultPage) NotDone() bool {
	return !page.ulr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page UsagesListResultPage) Response() UsagesListResult {
	return page.ulr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page UsagesListResultPage) Values() []Usage {
	if page.ulr.IsEmpty() {
		return nil
	}
	return *page.ulr.Value
}

// Creates a new instance of the UsagesListResultPage type.
func NewUsagesListResultPage(cur UsagesListResult, getNextPage func(context.Context, UsagesListResult) (UsagesListResult, error)) UsagesListResultPage {
	return UsagesListResultPage{
		fn:  getNextPage,
		ulr: cur,
	}
}

// UserManagedHTTPSParameters defines the certificate source parameters using user's keyvault certificate
// for enabling SSL.
type UserManagedHTTPSParameters struct {
	// CertificateSourceParameters - Defines the certificate source parameters using user's keyvault certificate for enabling SSL.
	CertificateSourceParameters *KeyVaultCertificateSourceParameters `json:"certificateSourceParameters,omitempty"`
	// ProtocolType - Defines the TLS extension protocol that is used for secure delivery. Possible values include: 'ProtocolTypeServerNameIndication', 'ProtocolTypeIPBased'
	ProtocolType ProtocolType `json:"protocolType,omitempty"`
	// MinimumTLSVersion - TLS protocol version that will be used for Https. Possible values include: 'MinimumTLSVersionNone', 'MinimumTLSVersionTLS10', 'MinimumTLSVersionTLS12'
	MinimumTLSVersion MinimumTLSVersion `json:"minimumTlsVersion,omitempty"`
	// CertificateSource - Possible values include: 'CertificateSourceCustomDomainHTTPSParameters', 'CertificateSourceAzureKeyVault', 'CertificateSourceCdn'
	CertificateSource CertificateSource `json:"certificateSource,omitempty"`
}

// MarshalJSON is the custom marshaler for UserManagedHTTPSParameters.
func (umhp UserManagedHTTPSParameters) MarshalJSON() ([]byte, error) {
	umhp.CertificateSource = CertificateSourceAzureKeyVault
	objectMap := make(map[string]interface{})
	if umhp.CertificateSourceParameters != nil {
		objectMap["certificateSourceParameters"] = umhp.CertificateSourceParameters
	}
	if umhp.ProtocolType != "" {
		objectMap["protocolType"] = umhp.ProtocolType
	}
	if umhp.MinimumTLSVersion != "" {
		objectMap["minimumTlsVersion"] = umhp.MinimumTLSVersion
	}
	if umhp.CertificateSource != "" {
		objectMap["certificateSource"] = umhp.CertificateSource
	}
	return json.Marshal(objectMap)
}

// AsUserManagedHTTPSParameters is the BasicCustomDomainHTTPSParameters implementation for UserManagedHTTPSParameters.
func (umhp UserManagedHTTPSParameters) AsUserManagedHTTPSParameters() (*UserManagedHTTPSParameters, bool) {
	return &umhp, true
}

// AsManagedHTTPSParameters is the BasicCustomDomainHTTPSParameters implementation for UserManagedHTTPSParameters.
func (umhp UserManagedHTTPSParameters) AsManagedHTTPSParameters() (*ManagedHTTPSParameters, bool) {
	return nil, false
}

// AsCustomDomainHTTPSParameters is the BasicCustomDomainHTTPSParameters implementation for UserManagedHTTPSParameters.
func (umhp UserManagedHTTPSParameters) AsCustomDomainHTTPSParameters() (*CustomDomainHTTPSParameters, bool) {
	return nil, false
}

// AsBasicCustomDomainHTTPSParameters is the BasicCustomDomainHTTPSParameters implementation for UserManagedHTTPSParameters.
func (umhp UserManagedHTTPSParameters) AsBasicCustomDomainHTTPSParameters() (BasicCustomDomainHTTPSParameters, bool) {
	return &umhp, true
}

// ValidateCustomDomainInput input of the custom domain to be validated for DNS mapping.
type ValidateCustomDomainInput struct {
	// HostName - The host name of the custom domain. Must be a domain name.
	HostName *string `json:"hostName,omitempty"`
}

// ValidateCustomDomainOutput output of custom domain validation.
type ValidateCustomDomainOutput struct {
	autorest.Response `json:"-"`
	// CustomDomainValidated - READ-ONLY; Indicates whether the custom domain is valid or not.
	CustomDomainValidated *bool `json:"customDomainValidated,omitempty"`
	// Reason - READ-ONLY; The reason why the custom domain is not valid.
	Reason *string `json:"reason,omitempty"`
	// Message - READ-ONLY; Error message describing why the custom domain is not valid.
	Message *string `json:"message,omitempty"`
}

// MarshalJSON is the custom marshaler for ValidateCustomDomainOutput.
func (vcdo ValidateCustomDomainOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ValidateProbeInput input of the validate probe API.
type ValidateProbeInput struct {
	// ProbeURL - The probe URL to validate.
	ProbeURL *string `json:"probeURL,omitempty"`
}

// ValidateProbeOutput output of the validate probe API.
type ValidateProbeOutput struct {
	autorest.Response `json:"-"`
	// IsValid - READ-ONLY; Indicates whether the probe URL is accepted or not.
	IsValid *bool `json:"isValid,omitempty"`
	// ErrorCode - READ-ONLY; Specifies the error code when the probe url is not accepted.
	ErrorCode *string `json:"errorCode,omitempty"`
	// Message - READ-ONLY; The detailed error message describing why the probe URL is not accepted.
	Message *string `json:"message,omitempty"`
}

// MarshalJSON is the custom marshaler for ValidateProbeOutput.
func (vpo ValidateProbeOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ValidateSecretInput input of the secret to be validated.
type ValidateSecretInput struct {
	// SecretType - The secret type. Possible values include: 'SecretTypeURLSigningKey', 'SecretTypeCustomerCertificate', 'SecretTypeManagedCertificate', 'SecretTypeAzureFirstPartyManagedCertificate'
	SecretType SecretType `json:"secretType,omitempty"`
	// SecretSource - Resource reference to the Azure Key Vault secret. Expected to be in format of /subscriptions/{​​​​​​​​​subscriptionId}​​​​​​​​​/resourceGroups/{​​​​​​​​​resourceGroupName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/providers/Microsoft.KeyVault/vaults/{vaultName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/secrets/{secretName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​
	SecretSource *ResourceReference `json:"secretSource,omitempty"`
	// SecretVersion - Secret version, if customer is using a specific version.
	SecretVersion *string `json:"secretVersion,omitempty"`
}

// ValidateSecretOutput output of the validated secret.
type ValidateSecretOutput struct {
	autorest.Response `json:"-"`
	// Status - The validation status. Possible values include: 'StatusValid', 'StatusInvalid', 'StatusAccessDenied', 'StatusCertificateExpired'
	Status Status `json:"status,omitempty"`
	// Message - Detailed error message
	Message *string `json:"message,omitempty"`
}

// ValidationToken the validation token.
type ValidationToken struct {
	// Token - READ-ONLY
	Token *string `json:"token,omitempty"`
}

// MarshalJSON is the custom marshaler for ValidationToken.
func (vt ValidationToken) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// WafMetricsResponse waf Metrics Response
type WafMetricsResponse struct {
	autorest.Response `json:"-"`
	DateTimeBegin     *date.Time `json:"dateTimeBegin,omitempty"`
	DateTimeEnd       *date.Time `json:"dateTimeEnd,omitempty"`
	// Granularity - Possible values include: 'Granularity1PT5M', 'Granularity1PT1H', 'Granularity1P1D'
	Granularity Granularity1                    `json:"granularity,omitempty"`
	Series      *[]WafMetricsResponseSeriesItem `json:"series,omitempty"`
}

// WafMetricsResponseSeriesItem ...
type WafMetricsResponseSeriesItem struct {
	Metric *string `json:"metric,omitempty"`
	// Unit - Possible values include: 'Unit1Count'
	Unit   Unit1                                     `json:"unit,omitempty"`
	Groups *[]WafMetricsResponseSeriesItemGroupsItem `json:"groups,omitempty"`
	Data   *[]WafMetricsResponseSeriesItemDataItem   `json:"data,omitempty"`
}

// WafMetricsResponseSeriesItemDataItem ...
type WafMetricsResponseSeriesItemDataItem struct {
	DateTime *date.Time `json:"dateTime,omitempty"`
	Value    *float64   `json:"value,omitempty"`
}

// WafMetricsResponseSeriesItemGroupsItem ...
type WafMetricsResponseSeriesItemGroupsItem struct {
	Name  *string `json:"name,omitempty"`
	Value *string `json:"value,omitempty"`
}

// WafRankingsResponse waf Rankings Response
type WafRankingsResponse struct {
	autorest.Response `json:"-"`
	DateTimeBegin     *date.Time                     `json:"dateTimeBegin,omitempty"`
	DateTimeEnd       *date.Time                     `json:"dateTimeEnd,omitempty"`
	Groups            *[]string                      `json:"groups,omitempty"`
	Data              *[]WafRankingsResponseDataItem `json:"data,omitempty"`
}

// WafRankingsResponseDataItem ...
type WafRankingsResponseDataItem struct {
	GroupValues *[]string                                 `json:"groupValues,omitempty"`
	Metrics     *[]WafRankingsResponseDataItemMetricsItem `json:"metrics,omitempty"`
}

// WafRankingsResponseDataItemMetricsItem ...
type WafRankingsResponseDataItemMetricsItem struct {
	Metric     *string  `json:"metric,omitempty"`
	Value      *int64   `json:"value,omitempty"`
	Percentage *float64 `json:"percentage,omitempty"`
}

// WebApplicationFirewallPolicy defines web application firewall policy for Azure CDN.
type WebApplicationFirewallPolicy struct {
	autorest.Response `json:"-"`
	// WebApplicationFirewallPolicyProperties - Properties of the web application firewall policy.
	*WebApplicationFirewallPolicyProperties `json:"properties,omitempty"`
	// Etag - Gets a unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// Sku - The pricing tier (defines a CDN provider, feature list and rate) of the CdnWebApplicationFirewallPolicy.
	Sku *Sku `json:"sku,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for WebApplicationFirewallPolicy.
func (wafp WebApplicationFirewallPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wafp.WebApplicationFirewallPolicyProperties != nil {
		objectMap["properties"] = wafp.WebApplicationFirewallPolicyProperties
	}
	if wafp.Etag != nil {
		objectMap["etag"] = wafp.Etag
	}
	if wafp.Sku != nil {
		objectMap["sku"] = wafp.Sku
	}
	if wafp.Location != nil {
		objectMap["location"] = wafp.Location
	}
	if wafp.Tags != nil {
		objectMap["tags"] = wafp.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WebApplicationFirewallPolicy struct.
func (wafp *WebApplicationFirewallPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var webApplicationFirewallPolicyProperties WebApplicationFirewallPolicyProperties
				err = json.Unmarshal(*v, &webApplicationFirewallPolicyProperties)
				if err != nil {
					return err
				}
				wafp.WebApplicationFirewallPolicyProperties = &webApplicationFirewallPolicyProperties
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				wafp.Etag = &etag
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				wafp.Sku = &sku
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				wafp.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				wafp.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				wafp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				wafp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				wafp.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				wafp.SystemData = &systemData
			}
		}
	}

	return nil
}

// WebApplicationFirewallPolicyList defines a list of WebApplicationFirewallPolicies for Azure CDN. It
// contains a list of WebApplicationFirewallPolicy objects and a URL link to get the next set of results.
type WebApplicationFirewallPolicyList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of Azure CDN WebApplicationFirewallPolicies within a resource group.
	Value *[]WebApplicationFirewallPolicy `json:"value,omitempty"`
	// NextLink - URL to get the next set of WebApplicationFirewallPolicy objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for WebApplicationFirewallPolicyList.
func (wafpl WebApplicationFirewallPolicyList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wafpl.NextLink != nil {
		objectMap["nextLink"] = wafpl.NextLink
	}
	return json.Marshal(objectMap)
}

// WebApplicationFirewallPolicyListIterator provides access to a complete listing of
// WebApplicationFirewallPolicy values.
type WebApplicationFirewallPolicyListIterator struct {
	i    int
	page WebApplicationFirewallPolicyListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WebApplicationFirewallPolicyListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WebApplicationFirewallPolicyListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WebApplicationFirewallPolicyListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WebApplicationFirewallPolicyListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WebApplicationFirewallPolicyListIterator) Response() WebApplicationFirewallPolicyList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WebApplicationFirewallPolicyListIterator) Value() WebApplicationFirewallPolicy {
	if !iter.page.NotDone() {
		return WebApplicationFirewallPolicy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WebApplicationFirewallPolicyListIterator type.
func NewWebApplicationFirewallPolicyListIterator(page WebApplicationFirewallPolicyListPage) WebApplicationFirewallPolicyListIterator {
	return WebApplicationFirewallPolicyListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wafpl WebApplicationFirewallPolicyList) IsEmpty() bool {
	return wafpl.Value == nil || len(*wafpl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (wafpl WebApplicationFirewallPolicyList) hasNextLink() bool {
	return wafpl.NextLink != nil && len(*wafpl.NextLink) != 0
}

// webApplicationFirewallPolicyListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wafpl WebApplicationFirewallPolicyList) webApplicationFirewallPolicyListPreparer(ctx context.Context) (*http.Request, error) {
	if !wafpl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wafpl.NextLink)))
}

// WebApplicationFirewallPolicyListPage contains a page of WebApplicationFirewallPolicy values.
type WebApplicationFirewallPolicyListPage struct {
	fn    func(context.Context, WebApplicationFirewallPolicyList) (WebApplicationFirewallPolicyList, error)
	wafpl WebApplicationFirewallPolicyList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WebApplicationFirewallPolicyListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WebApplicationFirewallPolicyListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.wafpl)
		if err != nil {
			return err
		}
		page.wafpl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WebApplicationFirewallPolicyListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WebApplicationFirewallPolicyListPage) NotDone() bool {
	return !page.wafpl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WebApplicationFirewallPolicyListPage) Response() WebApplicationFirewallPolicyList {
	return page.wafpl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WebApplicationFirewallPolicyListPage) Values() []WebApplicationFirewallPolicy {
	if page.wafpl.IsEmpty() {
		return nil
	}
	return *page.wafpl.Value
}

// Creates a new instance of the WebApplicationFirewallPolicyListPage type.
func NewWebApplicationFirewallPolicyListPage(cur WebApplicationFirewallPolicyList, getNextPage func(context.Context, WebApplicationFirewallPolicyList) (WebApplicationFirewallPolicyList, error)) WebApplicationFirewallPolicyListPage {
	return WebApplicationFirewallPolicyListPage{
		fn:    getNextPage,
		wafpl: cur,
	}
}

// WebApplicationFirewallPolicyPatchParameters properties required to update a
// CdnWebApplicationFirewallPolicy.
type WebApplicationFirewallPolicyPatchParameters struct {
	// Tags - CdnWebApplicationFirewallPolicy tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for WebApplicationFirewallPolicyPatchParameters.
func (wafppp WebApplicationFirewallPolicyPatchParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wafppp.Tags != nil {
		objectMap["tags"] = wafppp.Tags
	}
	return json.Marshal(objectMap)
}

// WebApplicationFirewallPolicyProperties defines CDN web application firewall policy properties.
type WebApplicationFirewallPolicyProperties struct {
	// PolicySettings - Describes  policySettings for policy
	PolicySettings *PolicySettings `json:"policySettings,omitempty"`
	// RateLimitRules - Describes rate limit rules inside the policy.
	RateLimitRules *RateLimitRuleList `json:"rateLimitRules,omitempty"`
	// CustomRules - Describes custom rules inside the policy.
	CustomRules *CustomRuleList `json:"customRules,omitempty"`
	// ManagedRules - Describes managed rules inside the policy.
	ManagedRules *ManagedRuleSetList `json:"managedRules,omitempty"`
	// EndpointLinks - READ-ONLY; Describes Azure CDN endpoints associated with this Web Application Firewall policy.
	EndpointLinks *[]EndpointType `json:"endpointLinks,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state of the WebApplicationFirewallPolicy. Possible values include: 'ProvisioningStateCreating', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// ResourceState - READ-ONLY; Possible values include: 'PolicyResourceStateCreating', 'PolicyResourceStateEnabling', 'PolicyResourceStateEnabled', 'PolicyResourceStateDisabling', 'PolicyResourceStateDisabled', 'PolicyResourceStateDeleting'
	ResourceState PolicyResourceState `json:"resourceState,omitempty"`
}

// MarshalJSON is the custom marshaler for WebApplicationFirewallPolicyProperties.
func (wafpp WebApplicationFirewallPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wafpp.PolicySettings != nil {
		objectMap["policySettings"] = wafpp.PolicySettings
	}
	if wafpp.RateLimitRules != nil {
		objectMap["rateLimitRules"] = wafpp.RateLimitRules
	}
	if wafpp.CustomRules != nil {
		objectMap["customRules"] = wafpp.CustomRules
	}
	if wafpp.ManagedRules != nil {
		objectMap["managedRules"] = wafpp.ManagedRules
	}
	return json.Marshal(objectMap)
}
