package web

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AppServicePlanRestrictions enumerates the values for app service plan restrictions.
type AppServicePlanRestrictions string

const (
	// Basic ...
	Basic AppServicePlanRestrictions = "Basic"
	// Free ...
	Free AppServicePlanRestrictions = "Free"
	// None ...
	None AppServicePlanRestrictions = "None"
	// Premium ...
	Premium AppServicePlanRestrictions = "Premium"
	// Shared ...
	Shared AppServicePlanRestrictions = "Shared"
	// Standard ...
	Standard AppServicePlanRestrictions = "Standard"
)

// PossibleAppServicePlanRestrictionsValues returns an array of possible values for the AppServicePlanRestrictions const type.
func PossibleAppServicePlanRestrictionsValues() []AppServicePlanRestrictions {
	return []AppServicePlanRestrictions{Basic, Free, None, Premium, Shared, Standard}
}

// AutoHealActionType enumerates the values for auto heal action type.
type AutoHealActionType string

const (
	// CustomAction ...
	CustomAction AutoHealActionType = "CustomAction"
	// LogEvent ...
	LogEvent AutoHealActionType = "LogEvent"
	// Recycle ...
	Recycle AutoHealActionType = "Recycle"
)

// PossibleAutoHealActionTypeValues returns an array of possible values for the AutoHealActionType const type.
func PossibleAutoHealActionTypeValues() []AutoHealActionType {
	return []AutoHealActionType{CustomAction, LogEvent, Recycle}
}

// AzureResourceType enumerates the values for azure resource type.
type AzureResourceType string

const (
	// TrafficManager ...
	TrafficManager AzureResourceType = "TrafficManager"
	// Website ...
	Website AzureResourceType = "Website"
)

// PossibleAzureResourceTypeValues returns an array of possible values for the AzureResourceType const type.
func PossibleAzureResourceTypeValues() []AzureResourceType {
	return []AzureResourceType{TrafficManager, Website}
}

// AzureStorageState enumerates the values for azure storage state.
type AzureStorageState string

const (
	// InvalidCredentials ...
	InvalidCredentials AzureStorageState = "InvalidCredentials"
	// InvalidShare ...
	InvalidShare AzureStorageState = "InvalidShare"
	// NotValidated ...
	NotValidated AzureStorageState = "NotValidated"
	// Ok ...
	Ok AzureStorageState = "Ok"
)

// PossibleAzureStorageStateValues returns an array of possible values for the AzureStorageState const type.
func PossibleAzureStorageStateValues() []AzureStorageState {
	return []AzureStorageState{InvalidCredentials, InvalidShare, NotValidated, Ok}
}

// AzureStorageType enumerates the values for azure storage type.
type AzureStorageType string

const (
	// AzureBlob ...
	AzureBlob AzureStorageType = "AzureBlob"
	// AzureFiles ...
	AzureFiles AzureStorageType = "AzureFiles"
)

// PossibleAzureStorageTypeValues returns an array of possible values for the AzureStorageType const type.
func PossibleAzureStorageTypeValues() []AzureStorageType {
	return []AzureStorageType{AzureBlob, AzureFiles}
}

// BackupItemStatus enumerates the values for backup item status.
type BackupItemStatus string

const (
	// Created ...
	Created BackupItemStatus = "Created"
	// Deleted ...
	Deleted BackupItemStatus = "Deleted"
	// DeleteFailed ...
	DeleteFailed BackupItemStatus = "DeleteFailed"
	// DeleteInProgress ...
	DeleteInProgress BackupItemStatus = "DeleteInProgress"
	// Failed ...
	Failed BackupItemStatus = "Failed"
	// InProgress ...
	InProgress BackupItemStatus = "InProgress"
	// PartiallySucceeded ...
	PartiallySucceeded BackupItemStatus = "PartiallySucceeded"
	// Skipped ...
	Skipped BackupItemStatus = "Skipped"
	// Succeeded ...
	Succeeded BackupItemStatus = "Succeeded"
	// TimedOut ...
	TimedOut BackupItemStatus = "TimedOut"
)

// PossibleBackupItemStatusValues returns an array of possible values for the BackupItemStatus const type.
func PossibleBackupItemStatusValues() []BackupItemStatus {
	return []BackupItemStatus{Created, Deleted, DeleteFailed, DeleteInProgress, Failed, InProgress, PartiallySucceeded, Skipped, Succeeded, TimedOut}
}

// BackupRestoreOperationType enumerates the values for backup restore operation type.
type BackupRestoreOperationType string

const (
	// BackupRestoreOperationTypeClone ...
	BackupRestoreOperationTypeClone BackupRestoreOperationType = "Clone"
	// BackupRestoreOperationTypeCloudFS ...
	BackupRestoreOperationTypeCloudFS BackupRestoreOperationType = "CloudFS"
	// BackupRestoreOperationTypeDefault ...
	BackupRestoreOperationTypeDefault BackupRestoreOperationType = "Default"
	// BackupRestoreOperationTypeRelocation ...
	BackupRestoreOperationTypeRelocation BackupRestoreOperationType = "Relocation"
	// BackupRestoreOperationTypeSnapshot ...
	BackupRestoreOperationTypeSnapshot BackupRestoreOperationType = "Snapshot"
)

// PossibleBackupRestoreOperationTypeValues returns an array of possible values for the BackupRestoreOperationType const type.
func PossibleBackupRestoreOperationTypeValues() []BackupRestoreOperationType {
	return []BackupRestoreOperationType{BackupRestoreOperationTypeClone, BackupRestoreOperationTypeCloudFS, BackupRestoreOperationTypeDefault, BackupRestoreOperationTypeRelocation, BackupRestoreOperationTypeSnapshot}
}

// BuildStatus enumerates the values for build status.
type BuildStatus string

const (
	// BuildStatusDeleting ...
	BuildStatusDeleting BuildStatus = "Deleting"
	// BuildStatusDeploying ...
	BuildStatusDeploying BuildStatus = "Deploying"
	// BuildStatusDetached ...
	BuildStatusDetached BuildStatus = "Detached"
	// BuildStatusFailed ...
	BuildStatusFailed BuildStatus = "Failed"
	// BuildStatusReady ...
	BuildStatusReady BuildStatus = "Ready"
	// BuildStatusUploading ...
	BuildStatusUploading BuildStatus = "Uploading"
	// BuildStatusWaitingForDeployment ...
	BuildStatusWaitingForDeployment BuildStatus = "WaitingForDeployment"
)

// PossibleBuildStatusValues returns an array of possible values for the BuildStatus const type.
func PossibleBuildStatusValues() []BuildStatus {
	return []BuildStatus{BuildStatusDeleting, BuildStatusDeploying, BuildStatusDetached, BuildStatusFailed, BuildStatusReady, BuildStatusUploading, BuildStatusWaitingForDeployment}
}

// BuiltInAuthenticationProvider enumerates the values for built in authentication provider.
type BuiltInAuthenticationProvider string

const (
	// BuiltInAuthenticationProviderAzureActiveDirectory ...
	BuiltInAuthenticationProviderAzureActiveDirectory BuiltInAuthenticationProvider = "AzureActiveDirectory"
	// BuiltInAuthenticationProviderFacebook ...
	BuiltInAuthenticationProviderFacebook BuiltInAuthenticationProvider = "Facebook"
	// BuiltInAuthenticationProviderGithub ...
	BuiltInAuthenticationProviderGithub BuiltInAuthenticationProvider = "Github"
	// BuiltInAuthenticationProviderGoogle ...
	BuiltInAuthenticationProviderGoogle BuiltInAuthenticationProvider = "Google"
	// BuiltInAuthenticationProviderMicrosoftAccount ...
	BuiltInAuthenticationProviderMicrosoftAccount BuiltInAuthenticationProvider = "MicrosoftAccount"
	// BuiltInAuthenticationProviderTwitter ...
	BuiltInAuthenticationProviderTwitter BuiltInAuthenticationProvider = "Twitter"
)

// PossibleBuiltInAuthenticationProviderValues returns an array of possible values for the BuiltInAuthenticationProvider const type.
func PossibleBuiltInAuthenticationProviderValues() []BuiltInAuthenticationProvider {
	return []BuiltInAuthenticationProvider{BuiltInAuthenticationProviderAzureActiveDirectory, BuiltInAuthenticationProviderFacebook, BuiltInAuthenticationProviderGithub, BuiltInAuthenticationProviderGoogle, BuiltInAuthenticationProviderMicrosoftAccount, BuiltInAuthenticationProviderTwitter}
}

// CertificateOrderActionType enumerates the values for certificate order action type.
type CertificateOrderActionType string

const (
	// CertificateExpirationWarning ...
	CertificateExpirationWarning CertificateOrderActionType = "CertificateExpirationWarning"
	// CertificateExpired ...
	CertificateExpired CertificateOrderActionType = "CertificateExpired"
	// CertificateIssued ...
	CertificateIssued CertificateOrderActionType = "CertificateIssued"
	// CertificateOrderCanceled ...
	CertificateOrderCanceled CertificateOrderActionType = "CertificateOrderCanceled"
	// CertificateOrderCreated ...
	CertificateOrderCreated CertificateOrderActionType = "CertificateOrderCreated"
	// CertificateRevoked ...
	CertificateRevoked CertificateOrderActionType = "CertificateRevoked"
	// DomainValidationComplete ...
	DomainValidationComplete CertificateOrderActionType = "DomainValidationComplete"
	// FraudCleared ...
	FraudCleared CertificateOrderActionType = "FraudCleared"
	// FraudDetected ...
	FraudDetected CertificateOrderActionType = "FraudDetected"
	// FraudDocumentationRequired ...
	FraudDocumentationRequired CertificateOrderActionType = "FraudDocumentationRequired"
	// OrgNameChange ...
	OrgNameChange CertificateOrderActionType = "OrgNameChange"
	// OrgValidationComplete ...
	OrgValidationComplete CertificateOrderActionType = "OrgValidationComplete"
	// SanDrop ...
	SanDrop CertificateOrderActionType = "SanDrop"
	// Unknown ...
	Unknown CertificateOrderActionType = "Unknown"
)

// PossibleCertificateOrderActionTypeValues returns an array of possible values for the CertificateOrderActionType const type.
func PossibleCertificateOrderActionTypeValues() []CertificateOrderActionType {
	return []CertificateOrderActionType{CertificateExpirationWarning, CertificateExpired, CertificateIssued, CertificateOrderCanceled, CertificateOrderCreated, CertificateRevoked, DomainValidationComplete, FraudCleared, FraudDetected, FraudDocumentationRequired, OrgNameChange, OrgValidationComplete, SanDrop, Unknown}
}

// CertificateOrderStatus enumerates the values for certificate order status.
type CertificateOrderStatus string

const (
	// Canceled ...
	Canceled CertificateOrderStatus = "Canceled"
	// Denied ...
	Denied CertificateOrderStatus = "Denied"
	// Expired ...
	Expired CertificateOrderStatus = "Expired"
	// Issued ...
	Issued CertificateOrderStatus = "Issued"
	// NotSubmitted ...
	NotSubmitted CertificateOrderStatus = "NotSubmitted"
	// Pendingissuance ...
	Pendingissuance CertificateOrderStatus = "Pendingissuance"
	// PendingRekey ...
	PendingRekey CertificateOrderStatus = "PendingRekey"
	// Pendingrevocation ...
	Pendingrevocation CertificateOrderStatus = "Pendingrevocation"
	// Revoked ...
	Revoked CertificateOrderStatus = "Revoked"
	// Unused ...
	Unused CertificateOrderStatus = "Unused"
)

// PossibleCertificateOrderStatusValues returns an array of possible values for the CertificateOrderStatus const type.
func PossibleCertificateOrderStatusValues() []CertificateOrderStatus {
	return []CertificateOrderStatus{Canceled, Denied, Expired, Issued, NotSubmitted, Pendingissuance, PendingRekey, Pendingrevocation, Revoked, Unused}
}

// CertificateProductType enumerates the values for certificate product type.
type CertificateProductType string

const (
	// StandardDomainValidatedSsl ...
	StandardDomainValidatedSsl CertificateProductType = "StandardDomainValidatedSsl"
	// StandardDomainValidatedWildCardSsl ...
	StandardDomainValidatedWildCardSsl CertificateProductType = "StandardDomainValidatedWildCardSsl"
)

// PossibleCertificateProductTypeValues returns an array of possible values for the CertificateProductType const type.
func PossibleCertificateProductTypeValues() []CertificateProductType {
	return []CertificateProductType{StandardDomainValidatedSsl, StandardDomainValidatedWildCardSsl}
}

// Channels enumerates the values for channels.
type Channels string

const (
	// All ...
	All Channels = "All"
	// API ...
	API Channels = "Api"
	// Email ...
	Email Channels = "Email"
	// Notification ...
	Notification Channels = "Notification"
	// Webhook ...
	Webhook Channels = "Webhook"
)

// PossibleChannelsValues returns an array of possible values for the Channels const type.
func PossibleChannelsValues() []Channels {
	return []Channels{All, API, Email, Notification, Webhook}
}

// CheckNameResourceTypes enumerates the values for check name resource types.
type CheckNameResourceTypes string

const (
	// CheckNameResourceTypesHostingEnvironment ...
	CheckNameResourceTypesHostingEnvironment CheckNameResourceTypes = "HostingEnvironment"
	// CheckNameResourceTypesMicrosoftWebhostingEnvironments ...
	CheckNameResourceTypesMicrosoftWebhostingEnvironments CheckNameResourceTypes = "Microsoft.Web/hostingEnvironments"
	// CheckNameResourceTypesMicrosoftWebpublishingUsers ...
	CheckNameResourceTypesMicrosoftWebpublishingUsers CheckNameResourceTypes = "Microsoft.Web/publishingUsers"
	// CheckNameResourceTypesMicrosoftWebsites ...
	CheckNameResourceTypesMicrosoftWebsites CheckNameResourceTypes = "Microsoft.Web/sites"
	// CheckNameResourceTypesMicrosoftWebsitesslots ...
	CheckNameResourceTypesMicrosoftWebsitesslots CheckNameResourceTypes = "Microsoft.Web/sites/slots"
	// CheckNameResourceTypesPublishingUser ...
	CheckNameResourceTypesPublishingUser CheckNameResourceTypes = "PublishingUser"
	// CheckNameResourceTypesSite ...
	CheckNameResourceTypesSite CheckNameResourceTypes = "Site"
	// CheckNameResourceTypesSlot ...
	CheckNameResourceTypesSlot CheckNameResourceTypes = "Slot"
)

// PossibleCheckNameResourceTypesValues returns an array of possible values for the CheckNameResourceTypes const type.
func PossibleCheckNameResourceTypesValues() []CheckNameResourceTypes {
	return []CheckNameResourceTypes{CheckNameResourceTypesHostingEnvironment, CheckNameResourceTypesMicrosoftWebhostingEnvironments, CheckNameResourceTypesMicrosoftWebpublishingUsers, CheckNameResourceTypesMicrosoftWebsites, CheckNameResourceTypesMicrosoftWebsitesslots, CheckNameResourceTypesPublishingUser, CheckNameResourceTypesSite, CheckNameResourceTypesSlot}
}

// ClientCertMode enumerates the values for client cert mode.
type ClientCertMode string

const (
	// Optional ...
	Optional ClientCertMode = "Optional"
	// OptionalInteractiveUser ...
	OptionalInteractiveUser ClientCertMode = "OptionalInteractiveUser"
	// Required ...
	Required ClientCertMode = "Required"
)

// PossibleClientCertModeValues returns an array of possible values for the ClientCertMode const type.
func PossibleClientCertModeValues() []ClientCertMode {
	return []ClientCertMode{Optional, OptionalInteractiveUser, Required}
}

// ClientCredentialMethod enumerates the values for client credential method.
type ClientCredentialMethod string

const (
	// ClientSecretPost ...
	ClientSecretPost ClientCredentialMethod = "ClientSecretPost"
)

// PossibleClientCredentialMethodValues returns an array of possible values for the ClientCredentialMethod const type.
func PossibleClientCredentialMethodValues() []ClientCredentialMethod {
	return []ClientCredentialMethod{ClientSecretPost}
}

// CloneAbilityResult enumerates the values for clone ability result.
type CloneAbilityResult string

const (
	// Cloneable ...
	Cloneable CloneAbilityResult = "Cloneable"
	// NotCloneable ...
	NotCloneable CloneAbilityResult = "NotCloneable"
	// PartiallyCloneable ...
	PartiallyCloneable CloneAbilityResult = "PartiallyCloneable"
)

// PossibleCloneAbilityResultValues returns an array of possible values for the CloneAbilityResult const type.
func PossibleCloneAbilityResultValues() []CloneAbilityResult {
	return []CloneAbilityResult{Cloneable, NotCloneable, PartiallyCloneable}
}

// ComputeModeOptions enumerates the values for compute mode options.
type ComputeModeOptions string

const (
	// ComputeModeOptionsDedicated ...
	ComputeModeOptionsDedicated ComputeModeOptions = "Dedicated"
	// ComputeModeOptionsDynamic ...
	ComputeModeOptionsDynamic ComputeModeOptions = "Dynamic"
	// ComputeModeOptionsShared ...
	ComputeModeOptionsShared ComputeModeOptions = "Shared"
)

// PossibleComputeModeOptionsValues returns an array of possible values for the ComputeModeOptions const type.
func PossibleComputeModeOptionsValues() []ComputeModeOptions {
	return []ComputeModeOptions{ComputeModeOptionsDedicated, ComputeModeOptionsDynamic, ComputeModeOptionsShared}
}

// ConfigReferenceSource enumerates the values for config reference source.
type ConfigReferenceSource string

const (
	// KeyVault ...
	KeyVault ConfigReferenceSource = "KeyVault"
)

// PossibleConfigReferenceSourceValues returns an array of possible values for the ConfigReferenceSource const type.
func PossibleConfigReferenceSourceValues() []ConfigReferenceSource {
	return []ConfigReferenceSource{KeyVault}
}

// ConnectionStringType enumerates the values for connection string type.
type ConnectionStringType string

const (
	// APIHub ...
	APIHub ConnectionStringType = "ApiHub"
	// Custom ...
	Custom ConnectionStringType = "Custom"
	// DocDb ...
	DocDb ConnectionStringType = "DocDb"
	// EventHub ...
	EventHub ConnectionStringType = "EventHub"
	// MySQL ...
	MySQL ConnectionStringType = "MySql"
	// NotificationHub ...
	NotificationHub ConnectionStringType = "NotificationHub"
	// PostgreSQL ...
	PostgreSQL ConnectionStringType = "PostgreSQL"
	// RedisCache ...
	RedisCache ConnectionStringType = "RedisCache"
	// ServiceBus ...
	ServiceBus ConnectionStringType = "ServiceBus"
	// SQLAzure ...
	SQLAzure ConnectionStringType = "SQLAzure"
	// SQLServer ...
	SQLServer ConnectionStringType = "SQLServer"
)

// PossibleConnectionStringTypeValues returns an array of possible values for the ConnectionStringType const type.
func PossibleConnectionStringTypeValues() []ConnectionStringType {
	return []ConnectionStringType{APIHub, Custom, DocDb, EventHub, MySQL, NotificationHub, PostgreSQL, RedisCache, ServiceBus, SQLAzure, SQLServer}
}

// ContinuousWebJobStatus enumerates the values for continuous web job status.
type ContinuousWebJobStatus string

const (
	// Initializing ...
	Initializing ContinuousWebJobStatus = "Initializing"
	// PendingRestart ...
	PendingRestart ContinuousWebJobStatus = "PendingRestart"
	// Running ...
	Running ContinuousWebJobStatus = "Running"
	// Starting ...
	Starting ContinuousWebJobStatus = "Starting"
	// Stopped ...
	Stopped ContinuousWebJobStatus = "Stopped"
)

// PossibleContinuousWebJobStatusValues returns an array of possible values for the ContinuousWebJobStatus const type.
func PossibleContinuousWebJobStatusValues() []ContinuousWebJobStatus {
	return []ContinuousWebJobStatus{Initializing, PendingRestart, Running, Starting, Stopped}
}

// CookieExpirationConvention enumerates the values for cookie expiration convention.
type CookieExpirationConvention string

const (
	// FixedTime ...
	FixedTime CookieExpirationConvention = "FixedTime"
	// IdentityProviderDerived ...
	IdentityProviderDerived CookieExpirationConvention = "IdentityProviderDerived"
)

// PossibleCookieExpirationConventionValues returns an array of possible values for the CookieExpirationConvention const type.
func PossibleCookieExpirationConventionValues() []CookieExpirationConvention {
	return []CookieExpirationConvention{FixedTime, IdentityProviderDerived}
}

// CustomDomainStatus enumerates the values for custom domain status.
type CustomDomainStatus string

const (
	// CustomDomainStatusAdding ...
	CustomDomainStatusAdding CustomDomainStatus = "Adding"
	// CustomDomainStatusDeleting ...
	CustomDomainStatusDeleting CustomDomainStatus = "Deleting"
	// CustomDomainStatusFailed ...
	CustomDomainStatusFailed CustomDomainStatus = "Failed"
	// CustomDomainStatusReady ...
	CustomDomainStatusReady CustomDomainStatus = "Ready"
	// CustomDomainStatusRetrievingValidationToken ...
	CustomDomainStatusRetrievingValidationToken CustomDomainStatus = "RetrievingValidationToken"
	// CustomDomainStatusValidating ...
	CustomDomainStatusValidating CustomDomainStatus = "Validating"
)

// PossibleCustomDomainStatusValues returns an array of possible values for the CustomDomainStatus const type.
func PossibleCustomDomainStatusValues() []CustomDomainStatus {
	return []CustomDomainStatus{CustomDomainStatusAdding, CustomDomainStatusDeleting, CustomDomainStatusFailed, CustomDomainStatusReady, CustomDomainStatusRetrievingValidationToken, CustomDomainStatusValidating}
}

// CustomHostNameDNSRecordType enumerates the values for custom host name dns record type.
type CustomHostNameDNSRecordType string

const (
	// A ...
	A CustomHostNameDNSRecordType = "A"
	// CName ...
	CName CustomHostNameDNSRecordType = "CName"
)

// PossibleCustomHostNameDNSRecordTypeValues returns an array of possible values for the CustomHostNameDNSRecordType const type.
func PossibleCustomHostNameDNSRecordTypeValues() []CustomHostNameDNSRecordType {
	return []CustomHostNameDNSRecordType{A, CName}
}

// DatabaseType enumerates the values for database type.
type DatabaseType string

const (
	// DatabaseTypeLocalMySQL ...
	DatabaseTypeLocalMySQL DatabaseType = "LocalMySql"
	// DatabaseTypeMySQL ...
	DatabaseTypeMySQL DatabaseType = "MySql"
	// DatabaseTypePostgreSQL ...
	DatabaseTypePostgreSQL DatabaseType = "PostgreSql"
	// DatabaseTypeSQLAzure ...
	DatabaseTypeSQLAzure DatabaseType = "SqlAzure"
)

// PossibleDatabaseTypeValues returns an array of possible values for the DatabaseType const type.
func PossibleDatabaseTypeValues() []DatabaseType {
	return []DatabaseType{DatabaseTypeLocalMySQL, DatabaseTypeMySQL, DatabaseTypePostgreSQL, DatabaseTypeSQLAzure}
}

// DetectorType enumerates the values for detector type.
type DetectorType string

const (
	// Analysis ...
	Analysis DetectorType = "Analysis"
	// CategoryOverview ...
	CategoryOverview DetectorType = "CategoryOverview"
	// Detector ...
	Detector DetectorType = "Detector"
)

// PossibleDetectorTypeValues returns an array of possible values for the DetectorType const type.
func PossibleDetectorTypeValues() []DetectorType {
	return []DetectorType{Analysis, CategoryOverview, Detector}
}

// DNSType enumerates the values for dns type.
type DNSType string

const (
	// AzureDNS ...
	AzureDNS DNSType = "AzureDns"
	// DefaultDomainRegistrarDNS ...
	DefaultDomainRegistrarDNS DNSType = "DefaultDomainRegistrarDns"
)

// PossibleDNSTypeValues returns an array of possible values for the DNSType const type.
func PossibleDNSTypeValues() []DNSType {
	return []DNSType{AzureDNS, DefaultDomainRegistrarDNS}
}

// DNSVerificationTestResult enumerates the values for dns verification test result.
type DNSVerificationTestResult string

const (
	// DNSVerificationTestResultFailed ...
	DNSVerificationTestResultFailed DNSVerificationTestResult = "Failed"
	// DNSVerificationTestResultPassed ...
	DNSVerificationTestResultPassed DNSVerificationTestResult = "Passed"
	// DNSVerificationTestResultSkipped ...
	DNSVerificationTestResultSkipped DNSVerificationTestResult = "Skipped"
)

// PossibleDNSVerificationTestResultValues returns an array of possible values for the DNSVerificationTestResult const type.
func PossibleDNSVerificationTestResultValues() []DNSVerificationTestResult {
	return []DNSVerificationTestResult{DNSVerificationTestResultFailed, DNSVerificationTestResultPassed, DNSVerificationTestResultSkipped}
}

// DomainStatus enumerates the values for domain status.
type DomainStatus string

const (
	// DomainStatusActive ...
	DomainStatusActive DomainStatus = "Active"
	// DomainStatusAwaiting ...
	DomainStatusAwaiting DomainStatus = "Awaiting"
	// DomainStatusCancelled ...
	DomainStatusCancelled DomainStatus = "Cancelled"
	// DomainStatusConfiscated ...
	DomainStatusConfiscated DomainStatus = "Confiscated"
	// DomainStatusDisabled ...
	DomainStatusDisabled DomainStatus = "Disabled"
	// DomainStatusExcluded ...
	DomainStatusExcluded DomainStatus = "Excluded"
	// DomainStatusExpired ...
	DomainStatusExpired DomainStatus = "Expired"
	// DomainStatusFailed ...
	DomainStatusFailed DomainStatus = "Failed"
	// DomainStatusHeld ...
	DomainStatusHeld DomainStatus = "Held"
	// DomainStatusJSONConverterFailed ...
	DomainStatusJSONConverterFailed DomainStatus = "JsonConverterFailed"
	// DomainStatusLocked ...
	DomainStatusLocked DomainStatus = "Locked"
	// DomainStatusParked ...
	DomainStatusParked DomainStatus = "Parked"
	// DomainStatusPending ...
	DomainStatusPending DomainStatus = "Pending"
	// DomainStatusReserved ...
	DomainStatusReserved DomainStatus = "Reserved"
	// DomainStatusReverted ...
	DomainStatusReverted DomainStatus = "Reverted"
	// DomainStatusSuspended ...
	DomainStatusSuspended DomainStatus = "Suspended"
	// DomainStatusTransferred ...
	DomainStatusTransferred DomainStatus = "Transferred"
	// DomainStatusUnknown ...
	DomainStatusUnknown DomainStatus = "Unknown"
	// DomainStatusUnlocked ...
	DomainStatusUnlocked DomainStatus = "Unlocked"
	// DomainStatusUnparked ...
	DomainStatusUnparked DomainStatus = "Unparked"
	// DomainStatusUpdated ...
	DomainStatusUpdated DomainStatus = "Updated"
)

// PossibleDomainStatusValues returns an array of possible values for the DomainStatus const type.
func PossibleDomainStatusValues() []DomainStatus {
	return []DomainStatus{DomainStatusActive, DomainStatusAwaiting, DomainStatusCancelled, DomainStatusConfiscated, DomainStatusDisabled, DomainStatusExcluded, DomainStatusExpired, DomainStatusFailed, DomainStatusHeld, DomainStatusJSONConverterFailed, DomainStatusLocked, DomainStatusParked, DomainStatusPending, DomainStatusReserved, DomainStatusReverted, DomainStatusSuspended, DomainStatusTransferred, DomainStatusUnknown, DomainStatusUnlocked, DomainStatusUnparked, DomainStatusUpdated}
}

// DomainType enumerates the values for domain type.
type DomainType string

const (
	// Regular ...
	Regular DomainType = "Regular"
	// SoftDeleted ...
	SoftDeleted DomainType = "SoftDeleted"
)

// PossibleDomainTypeValues returns an array of possible values for the DomainType const type.
func PossibleDomainTypeValues() []DomainType {
	return []DomainType{Regular, SoftDeleted}
}

// ForwardProxyConvention enumerates the values for forward proxy convention.
type ForwardProxyConvention string

const (
	// ForwardProxyConventionCustom ...
	ForwardProxyConventionCustom ForwardProxyConvention = "Custom"
	// ForwardProxyConventionNoProxy ...
	ForwardProxyConventionNoProxy ForwardProxyConvention = "NoProxy"
	// ForwardProxyConventionStandard ...
	ForwardProxyConventionStandard ForwardProxyConvention = "Standard"
)

// PossibleForwardProxyConventionValues returns an array of possible values for the ForwardProxyConvention const type.
func PossibleForwardProxyConventionValues() []ForwardProxyConvention {
	return []ForwardProxyConvention{ForwardProxyConventionCustom, ForwardProxyConventionNoProxy, ForwardProxyConventionStandard}
}

// FrequencyUnit enumerates the values for frequency unit.
type FrequencyUnit string

const (
	// Day ...
	Day FrequencyUnit = "Day"
	// Hour ...
	Hour FrequencyUnit = "Hour"
)

// PossibleFrequencyUnitValues returns an array of possible values for the FrequencyUnit const type.
func PossibleFrequencyUnitValues() []FrequencyUnit {
	return []FrequencyUnit{Day, Hour}
}

// FtpsState enumerates the values for ftps state.
type FtpsState string

const (
	// AllAllowed ...
	AllAllowed FtpsState = "AllAllowed"
	// Disabled ...
	Disabled FtpsState = "Disabled"
	// FtpsOnly ...
	FtpsOnly FtpsState = "FtpsOnly"
)

// PossibleFtpsStateValues returns an array of possible values for the FtpsState const type.
func PossibleFtpsStateValues() []FtpsState {
	return []FtpsState{AllAllowed, Disabled, FtpsOnly}
}

// HostingEnvironmentStatus enumerates the values for hosting environment status.
type HostingEnvironmentStatus string

const (
	// Deleting ...
	Deleting HostingEnvironmentStatus = "Deleting"
	// Preparing ...
	Preparing HostingEnvironmentStatus = "Preparing"
	// Ready ...
	Ready HostingEnvironmentStatus = "Ready"
	// Scaling ...
	Scaling HostingEnvironmentStatus = "Scaling"
)

// PossibleHostingEnvironmentStatusValues returns an array of possible values for the HostingEnvironmentStatus const type.
func PossibleHostingEnvironmentStatusValues() []HostingEnvironmentStatus {
	return []HostingEnvironmentStatus{Deleting, Preparing, Ready, Scaling}
}

// HostNameType enumerates the values for host name type.
type HostNameType string

const (
	// Managed ...
	Managed HostNameType = "Managed"
	// Verified ...
	Verified HostNameType = "Verified"
)

// PossibleHostNameTypeValues returns an array of possible values for the HostNameType const type.
func PossibleHostNameTypeValues() []HostNameType {
	return []HostNameType{Managed, Verified}
}

// HostType enumerates the values for host type.
type HostType string

const (
	// HostTypeRepository ...
	HostTypeRepository HostType = "Repository"
	// HostTypeStandard ...
	HostTypeStandard HostType = "Standard"
)

// PossibleHostTypeValues returns an array of possible values for the HostType const type.
func PossibleHostTypeValues() []HostType {
	return []HostType{HostTypeRepository, HostTypeStandard}
}

// InAvailabilityReasonType enumerates the values for in availability reason type.
type InAvailabilityReasonType string

const (
	// AlreadyExists ...
	AlreadyExists InAvailabilityReasonType = "AlreadyExists"
	// Invalid ...
	Invalid InAvailabilityReasonType = "Invalid"
)

// PossibleInAvailabilityReasonTypeValues returns an array of possible values for the InAvailabilityReasonType const type.
func PossibleInAvailabilityReasonTypeValues() []InAvailabilityReasonType {
	return []InAvailabilityReasonType{AlreadyExists, Invalid}
}

// InsightStatus enumerates the values for insight status.
type InsightStatus string

const (
	// InsightStatusCritical ...
	InsightStatusCritical InsightStatus = "Critical"
	// InsightStatusInfo ...
	InsightStatusInfo InsightStatus = "Info"
	// InsightStatusNone ...
	InsightStatusNone InsightStatus = "None"
	// InsightStatusSuccess ...
	InsightStatusSuccess InsightStatus = "Success"
	// InsightStatusWarning ...
	InsightStatusWarning InsightStatus = "Warning"
)

// PossibleInsightStatusValues returns an array of possible values for the InsightStatus const type.
func PossibleInsightStatusValues() []InsightStatus {
	return []InsightStatus{InsightStatusCritical, InsightStatusInfo, InsightStatusNone, InsightStatusSuccess, InsightStatusWarning}
}

// IPFilterTag enumerates the values for ip filter tag.
type IPFilterTag string

const (
	// Default ...
	Default IPFilterTag = "Default"
	// ServiceTag ...
	ServiceTag IPFilterTag = "ServiceTag"
	// XffProxy ...
	XffProxy IPFilterTag = "XffProxy"
)

// PossibleIPFilterTagValues returns an array of possible values for the IPFilterTag const type.
func PossibleIPFilterTagValues() []IPFilterTag {
	return []IPFilterTag{Default, ServiceTag, XffProxy}
}

// IssueType enumerates the values for issue type.
type IssueType string

const (
	// AppCrash ...
	AppCrash IssueType = "AppCrash"
	// AppDeployment ...
	AppDeployment IssueType = "AppDeployment"
	// AseDeployment ...
	AseDeployment IssueType = "AseDeployment"
	// Other ...
	Other IssueType = "Other"
	// PlatformIssue ...
	PlatformIssue IssueType = "PlatformIssue"
	// RuntimeIssueDetected ...
	RuntimeIssueDetected IssueType = "RuntimeIssueDetected"
	// ServiceIncident ...
	ServiceIncident IssueType = "ServiceIncident"
	// UserIssue ...
	UserIssue IssueType = "UserIssue"
)

// PossibleIssueTypeValues returns an array of possible values for the IssueType const type.
func PossibleIssueTypeValues() []IssueType {
	return []IssueType{AppCrash, AppDeployment, AseDeployment, Other, PlatformIssue, RuntimeIssueDetected, ServiceIncident, UserIssue}
}

// JobType enumerates the values for job type.
type JobType string

const (
	// Continuous ...
	Continuous JobType = "Continuous"
	// Triggered ...
	Triggered JobType = "Triggered"
)

// PossibleJobTypeValues returns an array of possible values for the JobType const type.
func PossibleJobTypeValues() []JobType {
	return []JobType{Continuous, Triggered}
}

// KeyVaultSecretStatus enumerates the values for key vault secret status.
type KeyVaultSecretStatus string

const (
	// KeyVaultSecretStatusAzureServiceUnauthorizedToAccessKeyVault ...
	KeyVaultSecretStatusAzureServiceUnauthorizedToAccessKeyVault KeyVaultSecretStatus = "AzureServiceUnauthorizedToAccessKeyVault"
	// KeyVaultSecretStatusCertificateOrderFailed ...
	KeyVaultSecretStatusCertificateOrderFailed KeyVaultSecretStatus = "CertificateOrderFailed"
	// KeyVaultSecretStatusExternalPrivateKey ...
	KeyVaultSecretStatusExternalPrivateKey KeyVaultSecretStatus = "ExternalPrivateKey"
	// KeyVaultSecretStatusInitialized ...
	KeyVaultSecretStatusInitialized KeyVaultSecretStatus = "Initialized"
	// KeyVaultSecretStatusKeyVaultDoesNotExist ...
	KeyVaultSecretStatusKeyVaultDoesNotExist KeyVaultSecretStatus = "KeyVaultDoesNotExist"
	// KeyVaultSecretStatusKeyVaultSecretDoesNotExist ...
	KeyVaultSecretStatusKeyVaultSecretDoesNotExist KeyVaultSecretStatus = "KeyVaultSecretDoesNotExist"
	// KeyVaultSecretStatusOperationNotPermittedOnKeyVault ...
	KeyVaultSecretStatusOperationNotPermittedOnKeyVault KeyVaultSecretStatus = "OperationNotPermittedOnKeyVault"
	// KeyVaultSecretStatusSucceeded ...
	KeyVaultSecretStatusSucceeded KeyVaultSecretStatus = "Succeeded"
	// KeyVaultSecretStatusUnknown ...
	KeyVaultSecretStatusUnknown KeyVaultSecretStatus = "Unknown"
	// KeyVaultSecretStatusUnknownError ...
	KeyVaultSecretStatusUnknownError KeyVaultSecretStatus = "UnknownError"
	// KeyVaultSecretStatusWaitingOnCertificateOrder ...
	KeyVaultSecretStatusWaitingOnCertificateOrder KeyVaultSecretStatus = "WaitingOnCertificateOrder"
)

// PossibleKeyVaultSecretStatusValues returns an array of possible values for the KeyVaultSecretStatus const type.
func PossibleKeyVaultSecretStatusValues() []KeyVaultSecretStatus {
	return []KeyVaultSecretStatus{KeyVaultSecretStatusAzureServiceUnauthorizedToAccessKeyVault, KeyVaultSecretStatusCertificateOrderFailed, KeyVaultSecretStatusExternalPrivateKey, KeyVaultSecretStatusInitialized, KeyVaultSecretStatusKeyVaultDoesNotExist, KeyVaultSecretStatusKeyVaultSecretDoesNotExist, KeyVaultSecretStatusOperationNotPermittedOnKeyVault, KeyVaultSecretStatusSucceeded, KeyVaultSecretStatusUnknown, KeyVaultSecretStatusUnknownError, KeyVaultSecretStatusWaitingOnCertificateOrder}
}

// LoadBalancingMode enumerates the values for load balancing mode.
type LoadBalancingMode string

const (
	// LoadBalancingModeNone ...
	LoadBalancingModeNone LoadBalancingMode = "None"
	// LoadBalancingModePublishing ...
	LoadBalancingModePublishing LoadBalancingMode = "Publishing"
	// LoadBalancingModeWeb ...
	LoadBalancingModeWeb LoadBalancingMode = "Web"
	// LoadBalancingModeWebPublishing ...
	LoadBalancingModeWebPublishing LoadBalancingMode = "Web, Publishing"
)

// PossibleLoadBalancingModeValues returns an array of possible values for the LoadBalancingMode const type.
func PossibleLoadBalancingModeValues() []LoadBalancingMode {
	return []LoadBalancingMode{LoadBalancingModeNone, LoadBalancingModePublishing, LoadBalancingModeWeb, LoadBalancingModeWebPublishing}
}

// LogLevel enumerates the values for log level.
type LogLevel string

const (
	// Error ...
	Error LogLevel = "Error"
	// Information ...
	Information LogLevel = "Information"
	// Off ...
	Off LogLevel = "Off"
	// Verbose ...
	Verbose LogLevel = "Verbose"
	// Warning ...
	Warning LogLevel = "Warning"
)

// PossibleLogLevelValues returns an array of possible values for the LogLevel const type.
func PossibleLogLevelValues() []LogLevel {
	return []LogLevel{Error, Information, Off, Verbose, Warning}
}

// ManagedPipelineMode enumerates the values for managed pipeline mode.
type ManagedPipelineMode string

const (
	// Classic ...
	Classic ManagedPipelineMode = "Classic"
	// Integrated ...
	Integrated ManagedPipelineMode = "Integrated"
)

// PossibleManagedPipelineModeValues returns an array of possible values for the ManagedPipelineMode const type.
func PossibleManagedPipelineModeValues() []ManagedPipelineMode {
	return []ManagedPipelineMode{Classic, Integrated}
}

// ManagedServiceIdentityType enumerates the values for managed service identity type.
type ManagedServiceIdentityType string

const (
	// ManagedServiceIdentityTypeNone ...
	ManagedServiceIdentityTypeNone ManagedServiceIdentityType = "None"
	// ManagedServiceIdentityTypeSystemAssigned ...
	ManagedServiceIdentityTypeSystemAssigned ManagedServiceIdentityType = "SystemAssigned"
	// ManagedServiceIdentityTypeSystemAssignedUserAssigned ...
	ManagedServiceIdentityTypeSystemAssignedUserAssigned ManagedServiceIdentityType = "SystemAssigned, UserAssigned"
	// ManagedServiceIdentityTypeUserAssigned ...
	ManagedServiceIdentityTypeUserAssigned ManagedServiceIdentityType = "UserAssigned"
)

// PossibleManagedServiceIdentityTypeValues returns an array of possible values for the ManagedServiceIdentityType const type.
func PossibleManagedServiceIdentityTypeValues() []ManagedServiceIdentityType {
	return []ManagedServiceIdentityType{ManagedServiceIdentityTypeNone, ManagedServiceIdentityTypeSystemAssigned, ManagedServiceIdentityTypeSystemAssignedUserAssigned, ManagedServiceIdentityTypeUserAssigned}
}

// MSDeployLogEntryType enumerates the values for ms deploy log entry type.
type MSDeployLogEntryType string

const (
	// MSDeployLogEntryTypeError ...
	MSDeployLogEntryTypeError MSDeployLogEntryType = "Error"
	// MSDeployLogEntryTypeMessage ...
	MSDeployLogEntryTypeMessage MSDeployLogEntryType = "Message"
	// MSDeployLogEntryTypeWarning ...
	MSDeployLogEntryTypeWarning MSDeployLogEntryType = "Warning"
)

// PossibleMSDeployLogEntryTypeValues returns an array of possible values for the MSDeployLogEntryType const type.
func PossibleMSDeployLogEntryTypeValues() []MSDeployLogEntryType {
	return []MSDeployLogEntryType{MSDeployLogEntryTypeError, MSDeployLogEntryTypeMessage, MSDeployLogEntryTypeWarning}
}

// MSDeployProvisioningState enumerates the values for ms deploy provisioning state.
type MSDeployProvisioningState string

const (
	// MSDeployProvisioningStateAccepted ...
	MSDeployProvisioningStateAccepted MSDeployProvisioningState = "accepted"
	// MSDeployProvisioningStateCanceled ...
	MSDeployProvisioningStateCanceled MSDeployProvisioningState = "canceled"
	// MSDeployProvisioningStateFailed ...
	MSDeployProvisioningStateFailed MSDeployProvisioningState = "failed"
	// MSDeployProvisioningStateRunning ...
	MSDeployProvisioningStateRunning MSDeployProvisioningState = "running"
	// MSDeployProvisioningStateSucceeded ...
	MSDeployProvisioningStateSucceeded MSDeployProvisioningState = "succeeded"
)

// PossibleMSDeployProvisioningStateValues returns an array of possible values for the MSDeployProvisioningState const type.
func PossibleMSDeployProvisioningStateValues() []MSDeployProvisioningState {
	return []MSDeployProvisioningState{MSDeployProvisioningStateAccepted, MSDeployProvisioningStateCanceled, MSDeployProvisioningStateFailed, MSDeployProvisioningStateRunning, MSDeployProvisioningStateSucceeded}
}

// MySQLMigrationType enumerates the values for my sql migration type.
type MySQLMigrationType string

const (
	// LocalToRemote ...
	LocalToRemote MySQLMigrationType = "LocalToRemote"
	// RemoteToLocal ...
	RemoteToLocal MySQLMigrationType = "RemoteToLocal"
)

// PossibleMySQLMigrationTypeValues returns an array of possible values for the MySQLMigrationType const type.
func PossibleMySQLMigrationTypeValues() []MySQLMigrationType {
	return []MySQLMigrationType{LocalToRemote, RemoteToLocal}
}

// NotificationLevel enumerates the values for notification level.
type NotificationLevel string

const (
	// NotificationLevelCritical ...
	NotificationLevelCritical NotificationLevel = "Critical"
	// NotificationLevelInformation ...
	NotificationLevelInformation NotificationLevel = "Information"
	// NotificationLevelNonUrgentSuggestion ...
	NotificationLevelNonUrgentSuggestion NotificationLevel = "NonUrgentSuggestion"
	// NotificationLevelWarning ...
	NotificationLevelWarning NotificationLevel = "Warning"
)

// PossibleNotificationLevelValues returns an array of possible values for the NotificationLevel const type.
func PossibleNotificationLevelValues() []NotificationLevel {
	return []NotificationLevel{NotificationLevelCritical, NotificationLevelInformation, NotificationLevelNonUrgentSuggestion, NotificationLevelWarning}
}

// OperationStatus enumerates the values for operation status.
type OperationStatus string

const (
	// OperationStatusCreated ...
	OperationStatusCreated OperationStatus = "Created"
	// OperationStatusFailed ...
	OperationStatusFailed OperationStatus = "Failed"
	// OperationStatusInProgress ...
	OperationStatusInProgress OperationStatus = "InProgress"
	// OperationStatusSucceeded ...
	OperationStatusSucceeded OperationStatus = "Succeeded"
	// OperationStatusTimedOut ...
	OperationStatusTimedOut OperationStatus = "TimedOut"
)

// PossibleOperationStatusValues returns an array of possible values for the OperationStatus const type.
func PossibleOperationStatusValues() []OperationStatus {
	return []OperationStatus{OperationStatusCreated, OperationStatusFailed, OperationStatusInProgress, OperationStatusSucceeded, OperationStatusTimedOut}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateCanceled ...
	ProvisioningStateCanceled ProvisioningState = "Canceled"
	// ProvisioningStateDeleting ...
	ProvisioningStateDeleting ProvisioningState = "Deleting"
	// ProvisioningStateFailed ...
	ProvisioningStateFailed ProvisioningState = "Failed"
	// ProvisioningStateInProgress ...
	ProvisioningStateInProgress ProvisioningState = "InProgress"
	// ProvisioningStateSucceeded ...
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{ProvisioningStateCanceled, ProvisioningStateDeleting, ProvisioningStateFailed, ProvisioningStateInProgress, ProvisioningStateSucceeded}
}

// PublicCertificateLocation enumerates the values for public certificate location.
type PublicCertificateLocation string

const (
	// PublicCertificateLocationCurrentUserMy ...
	PublicCertificateLocationCurrentUserMy PublicCertificateLocation = "CurrentUserMy"
	// PublicCertificateLocationLocalMachineMy ...
	PublicCertificateLocationLocalMachineMy PublicCertificateLocation = "LocalMachineMy"
	// PublicCertificateLocationUnknown ...
	PublicCertificateLocationUnknown PublicCertificateLocation = "Unknown"
)

// PossiblePublicCertificateLocationValues returns an array of possible values for the PublicCertificateLocation const type.
func PossiblePublicCertificateLocationValues() []PublicCertificateLocation {
	return []PublicCertificateLocation{PublicCertificateLocationCurrentUserMy, PublicCertificateLocationLocalMachineMy, PublicCertificateLocationUnknown}
}

// PublishingProfileFormat enumerates the values for publishing profile format.
type PublishingProfileFormat string

const (
	// FileZilla3 ...
	FileZilla3 PublishingProfileFormat = "FileZilla3"
	// Ftp ...
	Ftp PublishingProfileFormat = "Ftp"
	// WebDeploy ...
	WebDeploy PublishingProfileFormat = "WebDeploy"
)

// PossiblePublishingProfileFormatValues returns an array of possible values for the PublishingProfileFormat const type.
func PossiblePublishingProfileFormatValues() []PublishingProfileFormat {
	return []PublishingProfileFormat{FileZilla3, Ftp, WebDeploy}
}

// RedundancyMode enumerates the values for redundancy mode.
type RedundancyMode string

const (
	// RedundancyModeActiveActive ...
	RedundancyModeActiveActive RedundancyMode = "ActiveActive"
	// RedundancyModeFailover ...
	RedundancyModeFailover RedundancyMode = "Failover"
	// RedundancyModeGeoRedundant ...
	RedundancyModeGeoRedundant RedundancyMode = "GeoRedundant"
	// RedundancyModeManual ...
	RedundancyModeManual RedundancyMode = "Manual"
	// RedundancyModeNone ...
	RedundancyModeNone RedundancyMode = "None"
)

// PossibleRedundancyModeValues returns an array of possible values for the RedundancyMode const type.
func PossibleRedundancyModeValues() []RedundancyMode {
	return []RedundancyMode{RedundancyModeActiveActive, RedundancyModeFailover, RedundancyModeGeoRedundant, RedundancyModeManual, RedundancyModeNone}
}

// RenderingType enumerates the values for rendering type.
type RenderingType string

const (
	// RenderingTypeAppInsight ...
	RenderingTypeAppInsight RenderingType = "AppInsight"
	// RenderingTypeAppInsightEnablement ...
	RenderingTypeAppInsightEnablement RenderingType = "AppInsightEnablement"
	// RenderingTypeCard ...
	RenderingTypeCard RenderingType = "Card"
	// RenderingTypeChangeAnalysisOnboarding ...
	RenderingTypeChangeAnalysisOnboarding RenderingType = "ChangeAnalysisOnboarding"
	// RenderingTypeChangeSets ...
	RenderingTypeChangeSets RenderingType = "ChangeSets"
	// RenderingTypeChangesView ...
	RenderingTypeChangesView RenderingType = "ChangesView"
	// RenderingTypeDataSummary ...
	RenderingTypeDataSummary RenderingType = "DataSummary"
	// RenderingTypeDependencyGraph ...
	RenderingTypeDependencyGraph RenderingType = "DependencyGraph"
	// RenderingTypeDetector ...
	RenderingTypeDetector RenderingType = "Detector"
	// RenderingTypeDownTime ...
	RenderingTypeDownTime RenderingType = "DownTime"
	// RenderingTypeDropDown ...
	RenderingTypeDropDown RenderingType = "DropDown"
	// RenderingTypeDynamicInsight ...
	RenderingTypeDynamicInsight RenderingType = "DynamicInsight"
	// RenderingTypeEmail ...
	RenderingTypeEmail RenderingType = "Email"
	// RenderingTypeForm ...
	RenderingTypeForm RenderingType = "Form"
	// RenderingTypeGuage ...
	RenderingTypeGuage RenderingType = "Guage"
	// RenderingTypeInsights ...
	RenderingTypeInsights RenderingType = "Insights"
	// RenderingTypeMarkdown ...
	RenderingTypeMarkdown RenderingType = "Markdown"
	// RenderingTypeNoGraph ...
	RenderingTypeNoGraph RenderingType = "NoGraph"
	// RenderingTypePieChart ...
	RenderingTypePieChart RenderingType = "PieChart"
	// RenderingTypeSearchComponent ...
	RenderingTypeSearchComponent RenderingType = "SearchComponent"
	// RenderingTypeSolution ...
	RenderingTypeSolution RenderingType = "Solution"
	// RenderingTypeSummaryCard ...
	RenderingTypeSummaryCard RenderingType = "SummaryCard"
	// RenderingTypeTable ...
	RenderingTypeTable RenderingType = "Table"
	// RenderingTypeTimeSeries ...
	RenderingTypeTimeSeries RenderingType = "TimeSeries"
	// RenderingTypeTimeSeriesPerInstance ...
	RenderingTypeTimeSeriesPerInstance RenderingType = "TimeSeriesPerInstance"
)

// PossibleRenderingTypeValues returns an array of possible values for the RenderingType const type.
func PossibleRenderingTypeValues() []RenderingType {
	return []RenderingType{RenderingTypeAppInsight, RenderingTypeAppInsightEnablement, RenderingTypeCard, RenderingTypeChangeAnalysisOnboarding, RenderingTypeChangeSets, RenderingTypeChangesView, RenderingTypeDataSummary, RenderingTypeDependencyGraph, RenderingTypeDetector, RenderingTypeDownTime, RenderingTypeDropDown, RenderingTypeDynamicInsight, RenderingTypeEmail, RenderingTypeForm, RenderingTypeGuage, RenderingTypeInsights, RenderingTypeMarkdown, RenderingTypeNoGraph, RenderingTypePieChart, RenderingTypeSearchComponent, RenderingTypeSolution, RenderingTypeSummaryCard, RenderingTypeTable, RenderingTypeTimeSeries, RenderingTypeTimeSeriesPerInstance}
}

// ResolveStatus enumerates the values for resolve status.
type ResolveStatus string

const (
	// AccessToKeyVaultDenied ...
	AccessToKeyVaultDenied ResolveStatus = "AccessToKeyVaultDenied"
	// FetchTimedOut ...
	FetchTimedOut ResolveStatus = "FetchTimedOut"
	// Initialized ...
	Initialized ResolveStatus = "Initialized"
	// InvalidSyntax ...
	InvalidSyntax ResolveStatus = "InvalidSyntax"
	// MSINotEnabled ...
	MSINotEnabled ResolveStatus = "MSINotEnabled"
	// OtherReasons ...
	OtherReasons ResolveStatus = "OtherReasons"
	// Resolved ...
	Resolved ResolveStatus = "Resolved"
	// SecretNotFound ...
	SecretNotFound ResolveStatus = "SecretNotFound"
	// SecretVersionNotFound ...
	SecretVersionNotFound ResolveStatus = "SecretVersionNotFound"
	// UnauthorizedClient ...
	UnauthorizedClient ResolveStatus = "UnauthorizedClient"
	// VaultNotFound ...
	VaultNotFound ResolveStatus = "VaultNotFound"
)

// PossibleResolveStatusValues returns an array of possible values for the ResolveStatus const type.
func PossibleResolveStatusValues() []ResolveStatus {
	return []ResolveStatus{AccessToKeyVaultDenied, FetchTimedOut, Initialized, InvalidSyntax, MSINotEnabled, OtherReasons, Resolved, SecretNotFound, SecretVersionNotFound, UnauthorizedClient, VaultNotFound}
}

// ResourceScopeType enumerates the values for resource scope type.
type ResourceScopeType string

const (
	// ServerFarm ...
	ServerFarm ResourceScopeType = "ServerFarm"
	// Subscription ...
	Subscription ResourceScopeType = "Subscription"
	// WebSite ...
	WebSite ResourceScopeType = "WebSite"
)

// PossibleResourceScopeTypeValues returns an array of possible values for the ResourceScopeType const type.
func PossibleResourceScopeTypeValues() []ResourceScopeType {
	return []ResourceScopeType{ServerFarm, Subscription, WebSite}
}

// RouteType enumerates the values for route type.
type RouteType string

const (
	// DEFAULT ...
	DEFAULT RouteType = "DEFAULT"
	// INHERITED ...
	INHERITED RouteType = "INHERITED"
	// STATIC ...
	STATIC RouteType = "STATIC"
)

// PossibleRouteTypeValues returns an array of possible values for the RouteType const type.
func PossibleRouteTypeValues() []RouteType {
	return []RouteType{DEFAULT, INHERITED, STATIC}
}

// ScmType enumerates the values for scm type.
type ScmType string

const (
	// ScmTypeBitbucketGit ...
	ScmTypeBitbucketGit ScmType = "BitbucketGit"
	// ScmTypeBitbucketHg ...
	ScmTypeBitbucketHg ScmType = "BitbucketHg"
	// ScmTypeCodePlexGit ...
	ScmTypeCodePlexGit ScmType = "CodePlexGit"
	// ScmTypeCodePlexHg ...
	ScmTypeCodePlexHg ScmType = "CodePlexHg"
	// ScmTypeDropbox ...
	ScmTypeDropbox ScmType = "Dropbox"
	// ScmTypeExternalGit ...
	ScmTypeExternalGit ScmType = "ExternalGit"
	// ScmTypeExternalHg ...
	ScmTypeExternalHg ScmType = "ExternalHg"
	// ScmTypeGitHub ...
	ScmTypeGitHub ScmType = "GitHub"
	// ScmTypeLocalGit ...
	ScmTypeLocalGit ScmType = "LocalGit"
	// ScmTypeNone ...
	ScmTypeNone ScmType = "None"
	// ScmTypeOneDrive ...
	ScmTypeOneDrive ScmType = "OneDrive"
	// ScmTypeTfs ...
	ScmTypeTfs ScmType = "Tfs"
	// ScmTypeVSO ...
	ScmTypeVSO ScmType = "VSO"
	// ScmTypeVSTSRM ...
	ScmTypeVSTSRM ScmType = "VSTSRM"
)

// PossibleScmTypeValues returns an array of possible values for the ScmType const type.
func PossibleScmTypeValues() []ScmType {
	return []ScmType{ScmTypeBitbucketGit, ScmTypeBitbucketHg, ScmTypeCodePlexGit, ScmTypeCodePlexHg, ScmTypeDropbox, ScmTypeExternalGit, ScmTypeExternalHg, ScmTypeGitHub, ScmTypeLocalGit, ScmTypeNone, ScmTypeOneDrive, ScmTypeTfs, ScmTypeVSO, ScmTypeVSTSRM}
}

// SiteAvailabilityState enumerates the values for site availability state.
type SiteAvailabilityState string

const (
	// DisasterRecoveryMode ...
	DisasterRecoveryMode SiteAvailabilityState = "DisasterRecoveryMode"
	// Limited ...
	Limited SiteAvailabilityState = "Limited"
	// Normal ...
	Normal SiteAvailabilityState = "Normal"
)

// PossibleSiteAvailabilityStateValues returns an array of possible values for the SiteAvailabilityState const type.
func PossibleSiteAvailabilityStateValues() []SiteAvailabilityState {
	return []SiteAvailabilityState{DisasterRecoveryMode, Limited, Normal}
}

// SiteExtensionType enumerates the values for site extension type.
type SiteExtensionType string

const (
	// Gallery ...
	Gallery SiteExtensionType = "Gallery"
	// WebRoot ...
	WebRoot SiteExtensionType = "WebRoot"
)

// PossibleSiteExtensionTypeValues returns an array of possible values for the SiteExtensionType const type.
func PossibleSiteExtensionTypeValues() []SiteExtensionType {
	return []SiteExtensionType{Gallery, WebRoot}
}

// SiteLoadBalancing enumerates the values for site load balancing.
type SiteLoadBalancing string

const (
	// LeastRequests ...
	LeastRequests SiteLoadBalancing = "LeastRequests"
	// LeastResponseTime ...
	LeastResponseTime SiteLoadBalancing = "LeastResponseTime"
	// PerSiteRoundRobin ...
	PerSiteRoundRobin SiteLoadBalancing = "PerSiteRoundRobin"
	// RequestHash ...
	RequestHash SiteLoadBalancing = "RequestHash"
	// WeightedRoundRobin ...
	WeightedRoundRobin SiteLoadBalancing = "WeightedRoundRobin"
	// WeightedTotalTraffic ...
	WeightedTotalTraffic SiteLoadBalancing = "WeightedTotalTraffic"
)

// PossibleSiteLoadBalancingValues returns an array of possible values for the SiteLoadBalancing const type.
func PossibleSiteLoadBalancingValues() []SiteLoadBalancing {
	return []SiteLoadBalancing{LeastRequests, LeastResponseTime, PerSiteRoundRobin, RequestHash, WeightedRoundRobin, WeightedTotalTraffic}
}

// SiteRuntimeState enumerates the values for site runtime state.
type SiteRuntimeState string

const (
	// READY ...
	READY SiteRuntimeState = "READY"
	// STOPPED ...
	STOPPED SiteRuntimeState = "STOPPED"
	// UNKNOWN ...
	UNKNOWN SiteRuntimeState = "UNKNOWN"
)

// PossibleSiteRuntimeStateValues returns an array of possible values for the SiteRuntimeState const type.
func PossibleSiteRuntimeStateValues() []SiteRuntimeState {
	return []SiteRuntimeState{READY, STOPPED, UNKNOWN}
}

// SkuName enumerates the values for sku name.
type SkuName string

const (
	// SkuNameBasic ...
	SkuNameBasic SkuName = "Basic"
	// SkuNameDynamic ...
	SkuNameDynamic SkuName = "Dynamic"
	// SkuNameElasticIsolated ...
	SkuNameElasticIsolated SkuName = "ElasticIsolated"
	// SkuNameElasticPremium ...
	SkuNameElasticPremium SkuName = "ElasticPremium"
	// SkuNameFree ...
	SkuNameFree SkuName = "Free"
	// SkuNameIsolated ...
	SkuNameIsolated SkuName = "Isolated"
	// SkuNameIsolatedV2 ...
	SkuNameIsolatedV2 SkuName = "IsolatedV2"
	// SkuNamePremium ...
	SkuNamePremium SkuName = "Premium"
	// SkuNamePremiumContainer ...
	SkuNamePremiumContainer SkuName = "PremiumContainer"
	// SkuNamePremiumV2 ...
	SkuNamePremiumV2 SkuName = "PremiumV2"
	// SkuNamePremiumV3 ...
	SkuNamePremiumV3 SkuName = "PremiumV3"
	// SkuNameShared ...
	SkuNameShared SkuName = "Shared"
	// SkuNameStandard ...
	SkuNameStandard SkuName = "Standard"
)

// PossibleSkuNameValues returns an array of possible values for the SkuName const type.
func PossibleSkuNameValues() []SkuName {
	return []SkuName{SkuNameBasic, SkuNameDynamic, SkuNameElasticIsolated, SkuNameElasticPremium, SkuNameFree, SkuNameIsolated, SkuNameIsolatedV2, SkuNamePremium, SkuNamePremiumContainer, SkuNamePremiumV2, SkuNamePremiumV3, SkuNameShared, SkuNameStandard}
}

// SolutionType enumerates the values for solution type.
type SolutionType string

const (
	// BestPractices ...
	BestPractices SolutionType = "BestPractices"
	// DeepInvestigation ...
	DeepInvestigation SolutionType = "DeepInvestigation"
	// QuickSolution ...
	QuickSolution SolutionType = "QuickSolution"
)

// PossibleSolutionTypeValues returns an array of possible values for the SolutionType const type.
func PossibleSolutionTypeValues() []SolutionType {
	return []SolutionType{BestPractices, DeepInvestigation, QuickSolution}
}

// SslState enumerates the values for ssl state.
type SslState string

const (
	// SslStateDisabled ...
	SslStateDisabled SslState = "Disabled"
	// SslStateIPBasedEnabled ...
	SslStateIPBasedEnabled SslState = "IpBasedEnabled"
	// SslStateSniEnabled ...
	SslStateSniEnabled SslState = "SniEnabled"
)

// PossibleSslStateValues returns an array of possible values for the SslState const type.
func PossibleSslStateValues() []SslState {
	return []SslState{SslStateDisabled, SslStateIPBasedEnabled, SslStateSniEnabled}
}

// StackPreferredOs enumerates the values for stack preferred os.
type StackPreferredOs string

const (
	// Linux ...
	Linux StackPreferredOs = "Linux"
	// Windows ...
	Windows StackPreferredOs = "Windows"
)

// PossibleStackPreferredOsValues returns an array of possible values for the StackPreferredOs const type.
func PossibleStackPreferredOsValues() []StackPreferredOs {
	return []StackPreferredOs{Linux, Windows}
}

// StagingEnvironmentPolicy enumerates the values for staging environment policy.
type StagingEnvironmentPolicy string

const (
	// StagingEnvironmentPolicyDisabled ...
	StagingEnvironmentPolicyDisabled StagingEnvironmentPolicy = "Disabled"
	// StagingEnvironmentPolicyEnabled ...
	StagingEnvironmentPolicyEnabled StagingEnvironmentPolicy = "Enabled"
)

// PossibleStagingEnvironmentPolicyValues returns an array of possible values for the StagingEnvironmentPolicy const type.
func PossibleStagingEnvironmentPolicyValues() []StagingEnvironmentPolicy {
	return []StagingEnvironmentPolicy{StagingEnvironmentPolicyDisabled, StagingEnvironmentPolicyEnabled}
}

// StatusOptions enumerates the values for status options.
type StatusOptions string

const (
	// StatusOptionsCreating ...
	StatusOptionsCreating StatusOptions = "Creating"
	// StatusOptionsPending ...
	StatusOptionsPending StatusOptions = "Pending"
	// StatusOptionsReady ...
	StatusOptionsReady StatusOptions = "Ready"
)

// PossibleStatusOptionsValues returns an array of possible values for the StatusOptions const type.
func PossibleStatusOptionsValues() []StatusOptions {
	return []StatusOptions{StatusOptionsCreating, StatusOptionsPending, StatusOptionsReady}
}

// SupportedTLSVersions enumerates the values for supported tls versions.
type SupportedTLSVersions string

const (
	// OneFullStopOne ...
	OneFullStopOne SupportedTLSVersions = "1.1"
	// OneFullStopTwo ...
	OneFullStopTwo SupportedTLSVersions = "1.2"
	// OneFullStopZero ...
	OneFullStopZero SupportedTLSVersions = "1.0"
)

// PossibleSupportedTLSVersionsValues returns an array of possible values for the SupportedTLSVersions const type.
func PossibleSupportedTLSVersionsValues() []SupportedTLSVersions {
	return []SupportedTLSVersions{OneFullStopOne, OneFullStopTwo, OneFullStopZero}
}

// TriggeredWebJobStatus enumerates the values for triggered web job status.
type TriggeredWebJobStatus string

const (
	// TriggeredWebJobStatusError ...
	TriggeredWebJobStatusError TriggeredWebJobStatus = "Error"
	// TriggeredWebJobStatusFailed ...
	TriggeredWebJobStatusFailed TriggeredWebJobStatus = "Failed"
	// TriggeredWebJobStatusSuccess ...
	TriggeredWebJobStatusSuccess TriggeredWebJobStatus = "Success"
)

// PossibleTriggeredWebJobStatusValues returns an array of possible values for the TriggeredWebJobStatus const type.
func PossibleTriggeredWebJobStatusValues() []TriggeredWebJobStatus {
	return []TriggeredWebJobStatus{TriggeredWebJobStatusError, TriggeredWebJobStatusFailed, TriggeredWebJobStatusSuccess}
}

// TriggerTypes enumerates the values for trigger types.
type TriggerTypes string

const (
	// TriggerTypesHTTPTrigger ...
	TriggerTypesHTTPTrigger TriggerTypes = "HttpTrigger"
	// TriggerTypesUnknown ...
	TriggerTypesUnknown TriggerTypes = "Unknown"
)

// PossibleTriggerTypesValues returns an array of possible values for the TriggerTypes const type.
func PossibleTriggerTypesValues() []TriggerTypes {
	return []TriggerTypes{TriggerTypesHTTPTrigger, TriggerTypesUnknown}
}

// UnauthenticatedClientAction enumerates the values for unauthenticated client action.
type UnauthenticatedClientAction string

const (
	// AllowAnonymous ...
	AllowAnonymous UnauthenticatedClientAction = "AllowAnonymous"
	// RedirectToLoginPage ...
	RedirectToLoginPage UnauthenticatedClientAction = "RedirectToLoginPage"
)

// PossibleUnauthenticatedClientActionValues returns an array of possible values for the UnauthenticatedClientAction const type.
func PossibleUnauthenticatedClientActionValues() []UnauthenticatedClientAction {
	return []UnauthenticatedClientAction{AllowAnonymous, RedirectToLoginPage}
}

// UnauthenticatedClientActionV2 enumerates the values for unauthenticated client action v2.
type UnauthenticatedClientActionV2 string

const (
	// UnauthenticatedClientActionV2AllowAnonymous ...
	UnauthenticatedClientActionV2AllowAnonymous UnauthenticatedClientActionV2 = "AllowAnonymous"
	// UnauthenticatedClientActionV2RedirectToLoginPage ...
	UnauthenticatedClientActionV2RedirectToLoginPage UnauthenticatedClientActionV2 = "RedirectToLoginPage"
	// UnauthenticatedClientActionV2Return401 ...
	UnauthenticatedClientActionV2Return401 UnauthenticatedClientActionV2 = "Return401"
	// UnauthenticatedClientActionV2Return403 ...
	UnauthenticatedClientActionV2Return403 UnauthenticatedClientActionV2 = "Return403"
)

// PossibleUnauthenticatedClientActionV2Values returns an array of possible values for the UnauthenticatedClientActionV2 const type.
func PossibleUnauthenticatedClientActionV2Values() []UnauthenticatedClientActionV2 {
	return []UnauthenticatedClientActionV2{UnauthenticatedClientActionV2AllowAnonymous, UnauthenticatedClientActionV2RedirectToLoginPage, UnauthenticatedClientActionV2Return401, UnauthenticatedClientActionV2Return403}
}

// UsageState enumerates the values for usage state.
type UsageState string

const (
	// UsageStateExceeded ...
	UsageStateExceeded UsageState = "Exceeded"
	// UsageStateNormal ...
	UsageStateNormal UsageState = "Normal"
)

// PossibleUsageStateValues returns an array of possible values for the UsageState const type.
func PossibleUsageStateValues() []UsageState {
	return []UsageState{UsageStateExceeded, UsageStateNormal}
}

// ValidateResourceTypes enumerates the values for validate resource types.
type ValidateResourceTypes string

const (
	// ValidateResourceTypesMicrosoftWebhostingEnvironments ...
	ValidateResourceTypesMicrosoftWebhostingEnvironments ValidateResourceTypes = "Microsoft.Web/hostingEnvironments"
	// ValidateResourceTypesServerFarm ...
	ValidateResourceTypesServerFarm ValidateResourceTypes = "ServerFarm"
	// ValidateResourceTypesSite ...
	ValidateResourceTypesSite ValidateResourceTypes = "Site"
)

// PossibleValidateResourceTypesValues returns an array of possible values for the ValidateResourceTypes const type.
func PossibleValidateResourceTypesValues() []ValidateResourceTypes {
	return []ValidateResourceTypes{ValidateResourceTypesMicrosoftWebhostingEnvironments, ValidateResourceTypesServerFarm, ValidateResourceTypesSite}
}

// WorkerSizeOptions enumerates the values for worker size options.
type WorkerSizeOptions string

const (
	// WorkerSizeOptionsD1 ...
	WorkerSizeOptionsD1 WorkerSizeOptions = "D1"
	// WorkerSizeOptionsD2 ...
	WorkerSizeOptionsD2 WorkerSizeOptions = "D2"
	// WorkerSizeOptionsD3 ...
	WorkerSizeOptionsD3 WorkerSizeOptions = "D3"
	// WorkerSizeOptionsDefault ...
	WorkerSizeOptionsDefault WorkerSizeOptions = "Default"
	// WorkerSizeOptionsLarge ...
	WorkerSizeOptionsLarge WorkerSizeOptions = "Large"
	// WorkerSizeOptionsLargeV3 ...
	WorkerSizeOptionsLargeV3 WorkerSizeOptions = "LargeV3"
	// WorkerSizeOptionsMedium ...
	WorkerSizeOptionsMedium WorkerSizeOptions = "Medium"
	// WorkerSizeOptionsMediumV3 ...
	WorkerSizeOptionsMediumV3 WorkerSizeOptions = "MediumV3"
	// WorkerSizeOptionsNestedSmall ...
	WorkerSizeOptionsNestedSmall WorkerSizeOptions = "NestedSmall"
	// WorkerSizeOptionsNestedSmallLinux ...
	WorkerSizeOptionsNestedSmallLinux WorkerSizeOptions = "NestedSmallLinux"
	// WorkerSizeOptionsSmall ...
	WorkerSizeOptionsSmall WorkerSizeOptions = "Small"
	// WorkerSizeOptionsSmallV3 ...
	WorkerSizeOptionsSmallV3 WorkerSizeOptions = "SmallV3"
)

// PossibleWorkerSizeOptionsValues returns an array of possible values for the WorkerSizeOptions const type.
func PossibleWorkerSizeOptionsValues() []WorkerSizeOptions {
	return []WorkerSizeOptions{WorkerSizeOptionsD1, WorkerSizeOptionsD2, WorkerSizeOptionsD3, WorkerSizeOptionsDefault, WorkerSizeOptionsLarge, WorkerSizeOptionsLargeV3, WorkerSizeOptionsMedium, WorkerSizeOptionsMediumV3, WorkerSizeOptionsNestedSmall, WorkerSizeOptionsNestedSmallLinux, WorkerSizeOptionsSmall, WorkerSizeOptionsSmallV3}
}
