// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package dataplaneapi

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
)

var (
	// SwaggerJSON embedded version of the swagger document used at generation time
	SwaggerJSON json.RawMessage
	// FlatSwaggerJSON embedded flattened version of the swagger document used at generation time
	FlatSwaggerJSON json.RawMessage
)

func init() {
	SwaggerJSON = json.RawMessage([]byte(`{
  "consumes": [
    "application/json"
  ],
  "produces": [
    "application/json"
  ],
  "schemes": [
    "http",
    "https"
  ],
  "swagger": "2.0",
  "info": {
    "description": "API for editing and managing haproxy instances. Provides process information, configuration management,\nhaproxy stats and logs.\n",
    "title": "HAProxy Data Plane API",
    "contact": {
      "name": "HAProxy Support",
      "url": "https://my.haproxy.com/portal/cust/login",
      "email": "support@haproxy.com"
    },
    "version": "3.0"
  },
  "basePath": "/v3",
  "paths": {
    "/": {
      "get": {
        "description": "Returns a list of root endpoints.",
        "produces": [
          "application/json"
        ],
        "tags": [
          "Discovery"
        ],
        "summary": "Return list of root endpoints",
        "operationId": "getAPIEndpoints",
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "$ref": "#/definitions/endpoints"
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/cluster": {
      "get": {
        "description": "Returns cluster data",
        "produces": [
          "application/json"
        ],
        "tags": [
          "Cluster"
        ],
        "summary": "Return cluster data",
        "operationId": "getCluster",
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "$ref": "#/definitions/cluster_settings"
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Edit cluster settings",
        "tags": [
          "Cluster"
        ],
        "summary": "Edit cluster settings",
        "operationId": "editCluster",
        "parameters": [
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/cluster_settings"
            }
          },
          {
            "$ref": "#/parameters/version"
          }
        ],
        "responses": {
          "200": {
            "description": "Cluster settings changed",
            "schema": {
              "$ref": "#/definitions/cluster_settings"
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Post cluster settings",
        "tags": [
          "Cluster"
        ],
        "summary": "Post cluster settings",
        "operationId": "postCluster",
        "parameters": [
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/cluster_settings"
            }
          },
          {
            "enum": [
              "keep"
            ],
            "type": "string",
            "description": "In case of moving to single mode do we keep or clean configuration",
            "name": "configuration",
            "in": "query"
          },
          {
            "type": "string",
            "description": "Force the advertised address when joining a cluster",
            "name": "advertised_address",
            "in": "query"
          },
          {
            "maximum": 65535,
            "minimum": 1,
            "type": "integer",
            "description": "Force the advertised port when joining a cluster",
            "name": "advertised_port",
            "in": "query"
          },
          {
            "$ref": "#/parameters/version"
          }
        ],
        "responses": {
          "200": {
            "description": "Cluster settings changed",
            "schema": {
              "$ref": "#/definitions/cluster_settings"
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Delete cluster settings and move the node back to single mode",
        "tags": [
          "Cluster"
        ],
        "summary": "Delete cluster settings",
        "operationId": "deleteCluster",
        "parameters": [
          {
            "enum": [
              "keep"
            ],
            "type": "string",
            "description": "In case of moving to single mode do we keep or clean configuration",
            "name": "configuration",
            "in": "query"
          },
          {
            "$ref": "#/parameters/version"
          }
        ],
        "responses": {
          "204": {
            "description": "Cluster settings deleted and node moved to single mode"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/cluster/certificate": {
      "post": {
        "description": "Initiates a certificate refresh",
        "tags": [
          "Cluster"
        ],
        "summary": "Initiates a certificate refresh",
        "operationId": "initiateCertificateRefresh",
        "responses": {
          "200": {
            "description": "refresh activated"
          },
          "403": {
            "description": "refresh not possible"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/health": {
      "get": {
        "description": "Return managed services health",
        "produces": [
          "application/json"
        ],
        "tags": [
          "Health"
        ],
        "summary": "Return managed services health",
        "operationId": "getHealth",
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "$ref": "#/definitions/health"
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/info": {
      "get": {
        "description": "Return API, hardware and OS information",
        "produces": [
          "application/json"
        ],
        "tags": [
          "Information"
        ],
        "summary": "Return API, hardware and OS information",
        "operationId": "getInfo",
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "$ref": "#/definitions/info"
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/service_discovery/aws": {
      "get": {
        "description": "Return all configured AWS regions.",
        "tags": [
          "ServiceDiscovery"
        ],
        "summary": "Return an array of all configured AWS regions",
        "operationId": "getAWSRegions",
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/awsRegions"
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Add a new AWS region.\nCredentials are not required in case Dataplane API is running in an EC2 instance with proper IAM role attached.",
        "tags": [
          "ServiceDiscovery"
        ],
        "summary": "Add a new AWS region",
        "operationId": "createAWSRegion",
        "parameters": [
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/awsRegion"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Resource created",
            "schema": {
              "$ref": "#/definitions/awsRegion"
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/service_discovery/aws/{id}": {
      "get": {
        "description": "Return one AWS Region configuration by it's id.",
        "tags": [
          "ServiceDiscovery"
        ],
        "summary": "Return an AWS region",
        "operationId": "getAWSRegion",
        "parameters": [
          {
            "type": "string",
            "description": "AWS region id",
            "name": "id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/awsRegion"
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replace an AWS region configuration by its id.",
        "tags": [
          "ServiceDiscovery"
        ],
        "summary": "Replace an AWS region",
        "operationId": "replaceAWSRegion",
        "parameters": [
          {
            "type": "string",
            "description": "AWS Region ID",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/awsRegion"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Resource updated",
            "schema": {
              "$ref": "#/definitions/awsRegion"
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Delete an AWS region configuration by it's id.",
        "tags": [
          "ServiceDiscovery"
        ],
        "summary": "Delete an AWS region",
        "operationId": "deleteAWSRegion",
        "parameters": [
          {
            "type": "string",
            "description": "AWS region ID",
            "name": "id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "Resource deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/service_discovery/consul": {
      "get": {
        "description": "Returns all configured Consul servers.",
        "tags": [
          "ServiceDiscovery"
        ],
        "summary": "Return an array of all configured Consul servers",
        "operationId": "getConsuls",
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/consuls"
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new Consul server.",
        "tags": [
          "ServiceDiscovery"
        ],
        "summary": "Add a new Consul server",
        "operationId": "createConsul",
        "parameters": [
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/consul"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Consul created",
            "schema": {
              "$ref": "#/definitions/consul"
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/service_discovery/consul/{id}": {
      "get": {
        "description": "Returns one Consul server configuration by it's id.",
        "tags": [
          "ServiceDiscovery"
        ],
        "summary": "Return one Consul server",
        "operationId": "getConsul",
        "parameters": [
          {
            "type": "string",
            "description": "Consul server id",
            "name": "id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/consul"
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a Consul server configuration by it's id.",
        "tags": [
          "ServiceDiscovery"
        ],
        "summary": "Replace a Consul server",
        "operationId": "replaceConsul",
        "parameters": [
          {
            "type": "string",
            "description": "Consul Index",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/consul"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Consul server replaced",
            "schema": {
              "$ref": "#/definitions/consul"
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a Consul server configuration by it's id.",
        "tags": [
          "ServiceDiscovery"
        ],
        "summary": "Delete a Consul server",
        "operationId": "deleteConsul",
        "parameters": [
          {
            "type": "string",
            "description": "Consul server Index",
            "name": "id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "Consul server deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services": {
      "get": {
        "description": "Returns a list of API managed services endpoints.",
        "produces": [
          "application/json"
        ],
        "tags": [
          "Discovery"
        ],
        "summary": "Return list of service endpoints",
        "operationId": "getServicesEndpoints",
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "$ref": "#/definitions/endpoints"
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy": {
      "get": {
        "description": "Returns a list of HAProxy related endpoints.",
        "produces": [
          "application/json"
        ],
        "tags": [
          "Discovery"
        ],
        "summary": "Return list of HAProxy related endpoints",
        "operationId": "getHaproxyEndpoints",
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "$ref": "#/definitions/endpoints"
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration": {
      "get": {
        "description": "Returns a list of endpoints to be used for advanced configuration of HAProxy objects.",
        "produces": [
          "application/json"
        ],
        "tags": [
          "Discovery"
        ],
        "summary": "Return list of HAProxy advanced configuration endpoints",
        "operationId": "getConfigurationEndpoints",
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "$ref": "#/definitions/endpoints"
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/backends": {
      "get": {
        "description": "Returns an array of all configured backends.",
        "tags": [
          "Backend"
        ],
        "summary": "Return an array of backends",
        "operationId": "getBackends",
        "parameters": [
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/full_section"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/backends"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new backend to the configuration file.",
        "tags": [
          "Backend"
        ],
        "summary": "Add a backend",
        "operationId": "createBackend",
        "parameters": [
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/backend"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          },
          {
            "$ref": "#/parameters/full_section"
          }
        ],
        "responses": {
          "201": {
            "description": "Backend created",
            "schema": {
              "$ref": "#/definitions/backend"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/backend"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/backends/{name}": {
      "get": {
        "description": "Returns one backend configuration by it's name.",
        "tags": [
          "Backend"
        ],
        "summary": "Return a backend",
        "operationId": "getBackend",
        "parameters": [
          {
            "type": "string",
            "description": "Backend name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/full_section"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/backend"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a backend configuration by it's name.",
        "tags": [
          "Backend"
        ],
        "summary": "Replace a backend",
        "operationId": "replaceBackend",
        "parameters": [
          {
            "type": "string",
            "description": "Backend name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/backend"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          },
          {
            "$ref": "#/parameters/full_section"
          }
        ],
        "responses": {
          "200": {
            "description": "Backend replaced",
            "schema": {
              "$ref": "#/definitions/backend"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/backend"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a backend from the configuration by it's name.",
        "tags": [
          "Backend"
        ],
        "summary": "Delete a backend",
        "operationId": "deleteBackend",
        "parameters": [
          {
            "type": "string",
            "description": "Backend name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "Backend deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/backends/{parent_name}/acls": {
      "get": {
        "description": "Returns all ACL lines that are configured in specified parent.",
        "tags": [
          "ACL"
        ],
        "summary": "Return an array of all ACL lines",
        "operationId": "getAllAclBackend",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "type": "string",
            "description": "ACL name",
            "name": "acl_name",
            "in": "query"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/acls"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a whole list of ACLs with the list given in parameter",
        "tags": [
          "ACL"
        ],
        "summary": "Replace an ACL list",
        "operationId": "replaceAllAclBackend",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/acls"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "All ACL lines replaced",
            "schema": {
              "$ref": "#/definitions/acls"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/acls"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/backends/{parent_name}/acls/{index}": {
      "get": {
        "description": "Returns one ACL line configuration by it's index in the specified parent.",
        "tags": [
          "ACL"
        ],
        "summary": "Return one ACL line",
        "operationId": "getAclBackend",
        "parameters": [
          {
            "type": "integer",
            "description": "ACL line Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/acl"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a ACL line configuration by it's index in the specified parent.",
        "tags": [
          "ACL"
        ],
        "summary": "Replace a ACL line",
        "operationId": "replaceAclBackend",
        "parameters": [
          {
            "type": "integer",
            "description": "ACL line Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/acl"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "ACL line replaced",
            "schema": {
              "$ref": "#/definitions/acl"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/acl"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new ACL line of the specified type in the specified parent.",
        "tags": [
          "ACL"
        ],
        "summary": "Add a new ACL line",
        "operationId": "createAclBackend",
        "parameters": [
          {
            "type": "integer",
            "description": "ACL line Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/acl"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "201": {
            "description": "ACL line created",
            "schema": {
              "$ref": "#/definitions/acl"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/acl"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a ACL line configuration by it's index from the specified parent.",
        "tags": [
          "ACL"
        ],
        "summary": "Delete a ACL line",
        "operationId": "deleteAclBackend",
        "parameters": [
          {
            "type": "integer",
            "description": "ACL line Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "ACL line deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/backends/{parent_name}/filters": {
      "get": {
        "description": "Returns all Filters that are configured in specified parent.",
        "tags": [
          "Filter"
        ],
        "summary": "Return an array of all Filters",
        "operationId": "getAllFilterBackend",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/filters"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a whole list of Filters with the list given in parameter",
        "tags": [
          "Filter"
        ],
        "summary": "Replace a Filter list",
        "operationId": "replaceAllFilterBackend",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/filters"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "All Filter lines replaced",
            "schema": {
              "$ref": "#/definitions/filters"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/filters"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/backends/{parent_name}/filters/{index}": {
      "get": {
        "description": "Returns one Filter configuration by it's index in the specified parent.",
        "tags": [
          "Filter"
        ],
        "summary": "Return one Filter",
        "operationId": "getFilterBackend",
        "parameters": [
          {
            "type": "integer",
            "description": "Filter Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/filter"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a Filter configuration by it's index in the specified parent.",
        "tags": [
          "Filter"
        ],
        "summary": "Replace a Filter",
        "operationId": "replaceFilterBackend",
        "parameters": [
          {
            "type": "integer",
            "description": "Filter Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/filter"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "Filter replaced",
            "schema": {
              "$ref": "#/definitions/filter"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/filter"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new Filter of the specified type in the specified parent.",
        "tags": [
          "Filter"
        ],
        "summary": "Add a new Filter",
        "operationId": "createFilterBackend",
        "parameters": [
          {
            "type": "integer",
            "description": "Filter Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/filter"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "201": {
            "description": "Filter created",
            "schema": {
              "$ref": "#/definitions/filter"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/filter"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a Filter configuration by it's index from the specified parent.",
        "tags": [
          "Filter"
        ],
        "summary": "Delete a Filter",
        "operationId": "deleteFilterBackend",
        "parameters": [
          {
            "type": "integer",
            "description": "Filter Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "Filter deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/backends/{parent_name}/http_after_response_rules": {
      "get": {
        "description": "Returns all HTTP After Response Rules that are configured in specified parent.",
        "tags": [
          "HTTPAfterResponseRule"
        ],
        "summary": "Return an array of all HTTP After Response Rules",
        "operationId": "getAllHTTPAfterResponseRuleBackend",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/http_after_response_rules"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a whole list of HTTP After Response Rules with the list given in parameter",
        "tags": [
          "HTTPAfterResponseRule"
        ],
        "summary": "Replace an HTTP After Response Rules list",
        "operationId": "replaceAllHTTPAfterResponseRuleBackend",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/http_after_response_rules"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "All TTP After Response Rules lines replaced",
            "schema": {
              "$ref": "#/definitions/http_after_response_rules"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/http_after_response_rules"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/backends/{parent_name}/http_after_response_rules/{index}": {
      "get": {
        "description": "Returns one HTTP After Response Rule configuration by it's index in the specified parent.",
        "tags": [
          "HTTPAfterResponseRule"
        ],
        "summary": "Return one HTTP After Response Rule",
        "operationId": "getHTTPAfterResponseRuleBackend",
        "parameters": [
          {
            "type": "integer",
            "description": "HTTP After Response Rule Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/http_after_response_rule"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a HTTP After Response Rule configuration by it's index in the specified parent.",
        "tags": [
          "HTTPAfterResponseRule"
        ],
        "summary": "Replace a HTTP After Response Rule",
        "operationId": "replaceHTTPAfterResponseRuleBackend",
        "parameters": [
          {
            "type": "integer",
            "description": "HTTP After Response Rule Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/http_after_response_rule"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "HTTP After Response Rule replaced",
            "schema": {
              "$ref": "#/definitions/http_after_response_rule"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/http_after_response_rule"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new HTTP After Response Rule of the specified type in the specified parent.",
        "tags": [
          "HTTPAfterResponseRule"
        ],
        "summary": "Add a new HTTP After Response Rule",
        "operationId": "createHTTPAfterResponseRuleBackend",
        "parameters": [
          {
            "type": "integer",
            "description": "HTTP After Response Rule Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/http_after_response_rule"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "201": {
            "description": "HTTP Response Rule created",
            "schema": {
              "$ref": "#/definitions/http_after_response_rule"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/http_after_response_rule"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a HTTP After Response Rule configuration by it's index from the specified parent.",
        "tags": [
          "HTTPAfterResponseRule"
        ],
        "summary": "Delete a HTTP After Response Rule",
        "operationId": "deleteHTTPAfterResponseRuleBackend",
        "parameters": [
          {
            "type": "integer",
            "description": "HTTP After Response Rule Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "HTTP After Response Rule deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/backends/{parent_name}/http_checks": {
      "get": {
        "description": "Returns all HTTP checks that are configured in specified parent.",
        "tags": [
          "HTTPCheck"
        ],
        "summary": "Return an array of HTTP checks",
        "operationId": "getAllHTTPCheckBackend",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/http_checks"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a whole list of HTTP checks with the list given in parameter",
        "tags": [
          "HTTPCheck"
        ],
        "summary": "Replace an HTTP checks list",
        "operationId": "replaceAllHTTPCheckBackend",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/http_checks"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "All HTTP checks lines replaced",
            "schema": {
              "$ref": "#/definitions/http_checks"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/http_checks"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/backends/{parent_name}/http_checks/{index}": {
      "get": {
        "description": "Returns one HTTP check configuration by it's index in the specified parent.",
        "tags": [
          "HTTPCheck"
        ],
        "summary": "Return one HTTP check",
        "operationId": "getHTTPCheckBackend",
        "parameters": [
          {
            "type": "integer",
            "description": "HTTP Check Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/http_check"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a HTTP Check configuration by it's index in the specified parent.",
        "tags": [
          "HTTPCheck"
        ],
        "summary": "Replace a HTTP check",
        "operationId": "replaceHTTPCheckBackend",
        "parameters": [
          {
            "type": "integer",
            "description": "HTTP Check Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/http_check"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "HTTP check replaced",
            "schema": {
              "$ref": "#/definitions/http_check"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/http_check"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new HTTP check of the specified type in the specified parent.",
        "tags": [
          "HTTPCheck"
        ],
        "summary": "Add a new HTTP check",
        "operationId": "createHTTPCheckBackend",
        "parameters": [
          {
            "type": "integer",
            "description": "HTTP check Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/http_check"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "201": {
            "description": "HTTP check created",
            "schema": {
              "$ref": "#/definitions/http_check"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/http_check"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a HTTP check configuration by it's index from the specified parent.",
        "tags": [
          "HTTPCheck"
        ],
        "summary": "Delete a HTTP check",
        "operationId": "deleteHTTPCheckBackend",
        "parameters": [
          {
            "type": "integer",
            "description": "HTTP check Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "HTTP check deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/backends/{parent_name}/http_error_rules": {
      "get": {
        "description": "Returns all HTTP Error Rules that are configured in the specified parent.",
        "tags": [
          "HTTPErrorRule"
        ],
        "summary": "Return an array of all HTTP Error Rules",
        "operationId": "getAllHTTPErrorRuleBackend",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/http_error_rules"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a whole list of HTTP Error Rules with the list given in parameter",
        "tags": [
          "HTTPErrorRule"
        ],
        "summary": "Replace an HTTP Error Rules list",
        "operationId": "replaceAllHTTPErrorRuleBackend",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/http_error_rules"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "All HTTP Error Rules lines replaced",
            "schema": {
              "$ref": "#/definitions/http_error_rules"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/http_error_rules"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/backends/{parent_name}/http_error_rules/{index}": {
      "get": {
        "description": "Returns one HTTP Error Rule configuration by its index in the specified parent.",
        "tags": [
          "HTTPErrorRule"
        ],
        "summary": "Return one HTTP Error Rule",
        "operationId": "getHTTPErrorRuleBackend",
        "parameters": [
          {
            "type": "integer",
            "description": "HTTP Error Rule Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/http_error_rule"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a HTTP Error Rule configuration by its index in the specified parent.",
        "tags": [
          "HTTPErrorRule"
        ],
        "summary": "Replace a HTTP Error Rule",
        "operationId": "replaceHTTPErrorRuleBackend",
        "parameters": [
          {
            "type": "integer",
            "description": "HTTP Error Rule Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/http_error_rule"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "HTTP Error Rule replaced",
            "schema": {
              "$ref": "#/definitions/http_error_rule"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/http_error_rule"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new HTTP Error Rule of the specified type in the specified parent.",
        "tags": [
          "HTTPErrorRule"
        ],
        "summary": "Add a new HTTP Error Rule",
        "operationId": "createHTTPErrorRuleBackend",
        "parameters": [
          {
            "type": "integer",
            "description": "HTTP Error Rule Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/http_error_rule"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "201": {
            "description": "HTTP Error Rule created",
            "schema": {
              "$ref": "#/definitions/http_error_rule"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/http_error_rule"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a HTTP Error Rule configuration by its index from the specified parent.",
        "tags": [
          "HTTPErrorRule"
        ],
        "summary": "Delete a HTTP Error Rule",
        "operationId": "deleteHTTPErrorRuleBackend",
        "parameters": [
          {
            "type": "integer",
            "description": "HTTP Error Rule Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "HTTP Error Rule deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/backends/{parent_name}/http_request_rules": {
      "get": {
        "description": "Returns all HTTP Request Rules that are configured in specified parent.",
        "tags": [
          "HTTPRequestRule"
        ],
        "summary": "Return an array of all HTTP Request Rules",
        "operationId": "getAllHTTPRequestRuleBackend",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/http_request_rules"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a whole list of HTTP Request Rules with the list given in parameter",
        "tags": [
          "HTTPRequestRule"
        ],
        "summary": "Replace an HTTP Request Rule list",
        "operationId": "replaceAllHTTPRequestRuleBackend",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/http_request_rules"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "All HTTP Request Rule lines replaced",
            "schema": {
              "$ref": "#/definitions/http_request_rules"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/http_request_rules"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/backends/{parent_name}/http_request_rules/{index}": {
      "get": {
        "description": "Returns one HTTP Request Rule configuration by it's index in the specified parent.",
        "tags": [
          "HTTPRequestRule"
        ],
        "summary": "Return one HTTP Request Rule",
        "operationId": "getHTTPRequestRuleBackend",
        "parameters": [
          {
            "type": "integer",
            "description": "HTTP Request Rule Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/http_request_rule"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a HTTP Request Rule configuration by it's index in the specified parent.",
        "tags": [
          "HTTPRequestRule"
        ],
        "summary": "Replace a HTTP Request Rule",
        "operationId": "replaceHTTPRequestRuleBackend",
        "parameters": [
          {
            "type": "integer",
            "description": "HTTP Request Rule Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/http_request_rule"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "HTTP Request Rule replaced",
            "schema": {
              "$ref": "#/definitions/http_request_rule"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/http_request_rule"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new HTTP Request Rule of the specified type in the specified parent.",
        "tags": [
          "HTTPRequestRule"
        ],
        "summary": "Add a new HTTP Request Rule",
        "operationId": "createHTTPRequestRuleBackend",
        "parameters": [
          {
            "type": "integer",
            "description": "HTTP Request Rule Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/http_request_rule"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "201": {
            "description": "HTTP Request Rule created",
            "schema": {
              "$ref": "#/definitions/http_request_rule"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/http_request_rule"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a HTTP Request Rule configuration by it's index from the specified parent.",
        "tags": [
          "HTTPRequestRule"
        ],
        "summary": "Delete a HTTP Request Rule",
        "operationId": "deleteHTTPRequestRuleBackend",
        "parameters": [
          {
            "type": "integer",
            "description": "HTTP Request Rule Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "HTTP Request Rule deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/backends/{parent_name}/http_response_rules": {
      "get": {
        "description": "Returns all HTTP Response Rules that are configured in specified parent.",
        "tags": [
          "HTTPResponseRule"
        ],
        "summary": "Return an array of all HTTP Response Rules",
        "operationId": "getAllHTTPResponseRuleBackend",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/http_response_rules"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a whole list of HTTP Response Rules with the list given in parameter",
        "tags": [
          "HTTPResponseRule"
        ],
        "summary": "Replace an HTTP Response Rule list",
        "operationId": "replaceAllHTTPResponseRuleBackend",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/http_response_rules"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "All HTTP Response Rule lines replaced",
            "schema": {
              "$ref": "#/definitions/http_response_rules"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/http_response_rules"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/backends/{parent_name}/http_response_rules/{index}": {
      "get": {
        "description": "Returns one HTTP Response Rule configuration by it's index in the specified parent.",
        "tags": [
          "HTTPResponseRule"
        ],
        "summary": "Return one HTTP Response Rule",
        "operationId": "getHTTPResponseRuleBackend",
        "parameters": [
          {
            "type": "integer",
            "description": "HTTP Response Rule Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/http_response_rule"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a HTTP Response Rule configuration by it's index in the specified parent.",
        "tags": [
          "HTTPResponseRule"
        ],
        "summary": "Replace a HTTP Response Rule",
        "operationId": "replaceHTTPResponseRuleBackend",
        "parameters": [
          {
            "type": "integer",
            "description": "HTTP Response Rule Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/http_response_rule"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "HTTP Response Rule replaced",
            "schema": {
              "$ref": "#/definitions/http_response_rule"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/http_response_rule"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new HTTP Response Rule of the specified type in the specified parent.",
        "tags": [
          "HTTPResponseRule"
        ],
        "summary": "Add a new HTTP Response Rule",
        "operationId": "createHTTPResponseRuleBackend",
        "parameters": [
          {
            "type": "integer",
            "description": "HTTP Response Rule Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/http_response_rule"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "201": {
            "description": "HTTP Response Rule created",
            "schema": {
              "$ref": "#/definitions/http_response_rule"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/http_response_rule"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a HTTP Response Rule configuration by it's index from the specified parent.",
        "tags": [
          "HTTPResponseRule"
        ],
        "summary": "Delete a HTTP Response Rule",
        "operationId": "deleteHTTPResponseRuleBackend",
        "parameters": [
          {
            "type": "integer",
            "description": "HTTP Response Rule Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "HTTP Response Rule deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/backends/{parent_name}/log_targets": {
      "get": {
        "description": "Returns all Log Targets that are configured in specified parent.",
        "tags": [
          "LogTarget"
        ],
        "summary": "Return an array of all Log Targets",
        "operationId": "getAllLogTargetBackend",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/log_targets"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a whole list of Log Targets with the list given in parameter",
        "tags": [
          "LogTarget"
        ],
        "summary": "Replace a Log Target list",
        "operationId": "replaceAllLogTargetBackend",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/log_targets"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "All Log Target lines replaced",
            "schema": {
              "$ref": "#/definitions/log_targets"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/log_targets"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/backends/{parent_name}/log_targets/{index}": {
      "get": {
        "description": "Returns one Log Target configuration by it's index in the specified parent.",
        "tags": [
          "LogTarget"
        ],
        "summary": "Return one Log Target",
        "operationId": "getLogTargetBackend",
        "parameters": [
          {
            "type": "integer",
            "description": "Log Target Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/log_target"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a Log Target configuration by it's index in the specified parent.",
        "tags": [
          "LogTarget"
        ],
        "summary": "Replace a Log Target",
        "operationId": "replaceLogTargetBackend",
        "parameters": [
          {
            "type": "integer",
            "description": "Log Target Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/log_target"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "Log Target replaced",
            "schema": {
              "$ref": "#/definitions/log_target"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/log_target"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new Log Target of the specified type in the specified parent.",
        "tags": [
          "LogTarget"
        ],
        "summary": "Add a new Log Target",
        "operationId": "createLogTargetBackend",
        "parameters": [
          {
            "type": "integer",
            "description": "Log Target Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/log_target"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "201": {
            "description": "Log Target created",
            "schema": {
              "$ref": "#/definitions/log_target"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/log_target"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a Log Target configuration by it's index from the specified parent.",
        "tags": [
          "LogTarget"
        ],
        "summary": "Delete a Log Target",
        "operationId": "deleteLogTargetBackend",
        "parameters": [
          {
            "type": "integer",
            "description": "Log Target Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "Log Target deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/backends/{parent_name}/server_switching_rules": {
      "get": {
        "description": "Returns all Backend Switching Rules that are configured in specified backend.",
        "tags": [
          "ServerSwitchingRule"
        ],
        "summary": "Return an array of all Server Switching Rules",
        "operationId": "getServerSwitchingRules",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/server_switching_rules"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a whole list of Server Switching Rules with the list given in parameter",
        "tags": [
          "ServerSwitchingRule"
        ],
        "summary": "Replace an Server Switching Rule list",
        "operationId": "replaceServerSwitchingRules",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/server_switching_rules"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "All Server Switching Rule lines replaced",
            "schema": {
              "$ref": "#/definitions/server_switching_rules"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/server_switching_rules"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/backends/{parent_name}/server_switching_rules/{index}": {
      "get": {
        "description": "Returns one Server Switching Rule configuration by it's index in the specified backend.",
        "tags": [
          "ServerSwitchingRule"
        ],
        "summary": "Return one Server Switching Rule",
        "operationId": "getServerSwitchingRule",
        "parameters": [
          {
            "type": "integer",
            "description": "Switching Rule Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/server_switching_rule"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a Server Switching Rule configuration by it's index in the specified backend.",
        "tags": [
          "ServerSwitchingRule"
        ],
        "summary": "Replace a Server Switching Rule",
        "operationId": "replaceServerSwitchingRule",
        "parameters": [
          {
            "type": "integer",
            "description": "Switching Rule Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/server_switching_rule"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "Server Switching Rule replaced",
            "schema": {
              "$ref": "#/definitions/server_switching_rule"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/server_switching_rule"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new Server Switching Rule of the specified type in the specified backend.",
        "tags": [
          "ServerSwitchingRule"
        ],
        "summary": "Add a new Server Switching Rule",
        "operationId": "createServerSwitchingRule",
        "parameters": [
          {
            "type": "integer",
            "description": "Switching Rule Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/server_switching_rule"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "201": {
            "description": "Server Switching Rule created",
            "schema": {
              "$ref": "#/definitions/server_switching_rule"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/server_switching_rule"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a Server Switching Rule configuration by it's index from the specified backend.",
        "tags": [
          "ServerSwitchingRule"
        ],
        "summary": "Delete a Server Switching Rule",
        "operationId": "deleteServerSwitchingRule",
        "parameters": [
          {
            "type": "integer",
            "description": "Switching Rule Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "Server Switching Rule deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/backends/{parent_name}/server_templates": {
      "get": {
        "description": "Returns an array of all server templates that are configured in specified backend.",
        "tags": [
          "ServerTemplate"
        ],
        "summary": "Return an array of server templates",
        "operationId": "getServerTemplates",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/server_templates"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new server template in the specified backend in the configuration file.",
        "tags": [
          "ServerTemplate"
        ],
        "summary": "Add a new server template",
        "operationId": "createServerTemplate",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/server_template"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "201": {
            "description": "Server template created",
            "schema": {
              "$ref": "#/definitions/server_template"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/server_template"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/backends/{parent_name}/server_templates/{prefix}": {
      "get": {
        "description": "Returns one server template configuration by it's prefix in the specified backend.",
        "tags": [
          "ServerTemplate"
        ],
        "summary": "Return one server template",
        "operationId": "getServerTemplate",
        "parameters": [
          {
            "type": "string",
            "description": "Server template prefix",
            "name": "prefix",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/server_template"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a server template configuration by it's prefix in the specified backend.",
        "tags": [
          "ServerTemplate"
        ],
        "summary": "Replace a server template",
        "operationId": "replaceServerTemplate",
        "parameters": [
          {
            "type": "string",
            "description": "Server template prefix",
            "name": "prefix",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/server_template"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "Server template replaced",
            "schema": {
              "$ref": "#/definitions/server_template"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/server_template"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a server template configuration by it's prefix in the specified backend.",
        "tags": [
          "ServerTemplate"
        ],
        "summary": "Delete a server template",
        "operationId": "deleteServerTemplate",
        "parameters": [
          {
            "type": "string",
            "description": "Server template prefix",
            "name": "prefix",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "Server template deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/backends/{parent_name}/servers": {
      "get": {
        "description": "Returns an array of all servers that are configured in specified backend.",
        "tags": [
          "Server"
        ],
        "summary": "Return an array of servers",
        "operationId": "getAllServerBackend",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/servers"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new server in the specified backend in the configuration file.",
        "tags": [
          "Server"
        ],
        "summary": "Add a new server",
        "operationId": "createServerBackend",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/server"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "201": {
            "description": "Server created",
            "schema": {
              "$ref": "#/definitions/server"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/server"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/backends/{parent_name}/servers/{name}": {
      "get": {
        "description": "Returns one server configuration by it's name in the specified backend.",
        "tags": [
          "Server"
        ],
        "summary": "Return one server",
        "operationId": "getServerBackend",
        "parameters": [
          {
            "type": "string",
            "description": "Server name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/server"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a server configuration by it's name in the specified backend.",
        "tags": [
          "Server"
        ],
        "summary": "Replace a server",
        "operationId": "replaceServerBackend",
        "parameters": [
          {
            "type": "string",
            "description": "Server name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/server"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "Server replaced",
            "schema": {
              "$ref": "#/definitions/server"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/server"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a server configuration by it's name in the specified backend.",
        "tags": [
          "Server"
        ],
        "summary": "Delete a server",
        "operationId": "deleteServerBackend",
        "parameters": [
          {
            "type": "string",
            "description": "Server name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "Server deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/backends/{parent_name}/stick_rules": {
      "get": {
        "description": "Returns all Stick Rules that are configured in specified backend.",
        "tags": [
          "StickRule"
        ],
        "summary": "Return an array of all Stick Rules",
        "operationId": "getStickRules",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/stick_rules"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a whole list of Stick Rules with the list given in parameter",
        "tags": [
          "StickRule"
        ],
        "summary": "Replace a Stick Rule list",
        "operationId": "replaceStickRules",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/stick_rules"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "All Stick Rule lines replaced",
            "schema": {
              "$ref": "#/definitions/stick_rules"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/stick_rules"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/backends/{parent_name}/stick_rules/{index}": {
      "get": {
        "description": "Returns one Stick Rule configuration by it's index in the specified backend.",
        "tags": [
          "StickRule"
        ],
        "summary": "Return one Stick Rule",
        "operationId": "getStickRule",
        "parameters": [
          {
            "type": "integer",
            "description": "Stick Rule Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/stick_rule"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a Stick Rule configuration by it's index in the specified backend.",
        "tags": [
          "StickRule"
        ],
        "summary": "Replace a Stick Rule",
        "operationId": "replaceStickRule",
        "parameters": [
          {
            "type": "integer",
            "description": "Stick Rule Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/stick_rule"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "Stick Rule replaced",
            "schema": {
              "$ref": "#/definitions/stick_rule"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/stick_rule"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new Stick Rule of the specified type in the specified backend.",
        "tags": [
          "StickRule"
        ],
        "summary": "Add a new Stick Rule",
        "operationId": "createStickRule",
        "parameters": [
          {
            "type": "integer",
            "description": "Stick Rule Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/stick_rule"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "201": {
            "description": "Stick Rule created",
            "schema": {
              "$ref": "#/definitions/stick_rule"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/stick_rule"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a Stick Rule configuration by it's index from the specified backend.",
        "tags": [
          "StickRule"
        ],
        "summary": "Delete a Stick Rule",
        "operationId": "deleteStickRule",
        "parameters": [
          {
            "type": "integer",
            "description": "Stick Rule Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "Stick Rule deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/backends/{parent_name}/tcp_checks": {
      "get": {
        "description": "Returns all TCP checks that are configured in specified parent.",
        "tags": [
          "TCPCheck"
        ],
        "summary": "Return an array of TCP checks",
        "operationId": "getAllTCPCheckBackend",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/tcp_checks"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a whole list of TCP Checks with the list given in parameter",
        "tags": [
          "TCPCheck"
        ],
        "summary": "Replace an TCP Check list",
        "operationId": "replaceAllTCPCheckBackend",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/tcp_checks"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "All TCP Check lines replaced",
            "schema": {
              "$ref": "#/definitions/tcp_checks"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/tcp_checks"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/backends/{parent_name}/tcp_checks/{index}": {
      "get": {
        "description": "Returns one TCP check configuration by it's index in the specified parent.",
        "tags": [
          "TCPCheck"
        ],
        "summary": "Return one TCP check",
        "operationId": "getTCPCheckBackend",
        "parameters": [
          {
            "type": "integer",
            "description": "TCP Check Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/tcp_check"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a TCP Check configuration by it's index in the specified parent.",
        "tags": [
          "TCPCheck"
        ],
        "summary": "Replace a TCP check",
        "operationId": "replaceTCPCheckBackend",
        "parameters": [
          {
            "type": "integer",
            "description": "TCP Check Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/tcp_check"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "TCP check replaced",
            "schema": {
              "$ref": "#/definitions/tcp_check"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/tcp_check"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new TCP check of the specified type in the specified parent.",
        "tags": [
          "TCPCheck"
        ],
        "summary": "Add a new TCP check",
        "operationId": "createTCPCheckBackend",
        "parameters": [
          {
            "type": "integer",
            "description": "TCP check Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/tcp_check"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "201": {
            "description": "TCP check created",
            "schema": {
              "$ref": "#/definitions/tcp_check"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/tcp_check"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a TCP check configuration by it's index from the specified parent.",
        "tags": [
          "TCPCheck"
        ],
        "summary": "Delete a TCP check",
        "operationId": "deleteTCPCheckBackend",
        "parameters": [
          {
            "type": "integer",
            "description": "TCP check Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "TCP check deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/backends/{parent_name}/tcp_request_rules": {
      "get": {
        "description": "Returns all TCP Request Rules that are configured in specified parent and parent type.",
        "tags": [
          "TCPRequestRule"
        ],
        "summary": "Return an array of all TCP Request Rules",
        "operationId": "getAllTCPRequestRuleBackend",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/tcp_request_rules"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a whole list of TCP Request Rules with the list given in parameter",
        "tags": [
          "TCPRequestRule"
        ],
        "summary": "Replace an TCP Request Rule list",
        "operationId": "replaceAllTCPRequestRuleBackend",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/tcp_request_rules"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "All TCP Request Rule lines replaced",
            "schema": {
              "$ref": "#/definitions/tcp_request_rules"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/tcp_request_rules"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/backends/{parent_name}/tcp_request_rules/{index}": {
      "get": {
        "description": "Returns one TCP Request Rule configuration by it's index in the specified parent.",
        "tags": [
          "TCPRequestRule"
        ],
        "summary": "Return one TCP Request Rule",
        "operationId": "getTCPRequestRuleBackend",
        "parameters": [
          {
            "type": "integer",
            "description": "TCP Request Rule Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/tcp_request_rule"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a TCP Request Rule configuration by it's index in the specified parent.",
        "tags": [
          "TCPRequestRule"
        ],
        "summary": "Replace a TCP Request Rule",
        "operationId": "replaceTCPRequestRuleBackend",
        "parameters": [
          {
            "type": "integer",
            "description": "TCP Request Rule Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/tcp_request_rule"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "TCP Request Rule replaced",
            "schema": {
              "$ref": "#/definitions/tcp_request_rule"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/tcp_request_rule"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new TCP Request Rule of the specified type in the specified parent.",
        "tags": [
          "TCPRequestRule"
        ],
        "summary": "Add a new TCP Request Rule",
        "operationId": "createTCPRequestRuleBackend",
        "parameters": [
          {
            "type": "integer",
            "description": "TCP Request Rule Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/tcp_request_rule"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "201": {
            "description": "TCP Request Rule created",
            "schema": {
              "$ref": "#/definitions/tcp_request_rule"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/tcp_request_rule"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a TCP Request Rule configuration by it's index from the specified parent.",
        "tags": [
          "TCPRequestRule"
        ],
        "summary": "Delete a TCP Request Rule",
        "operationId": "deleteTCPRequestRuleBackend",
        "parameters": [
          {
            "type": "integer",
            "description": "TCP Request Rule Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "TCP Request Rule deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/backends/{parent_name}/tcp_response_rules": {
      "get": {
        "description": "Returns all TCP Response Rules that are configured in specified backend.",
        "tags": [
          "TCPResponseRule"
        ],
        "summary": "Return an array of all TCP Response Rules",
        "operationId": "getAllTCPResponseRuleBackend",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/tcp_response_rules"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a whole list of TCP Response Rules with the list given in parameter",
        "tags": [
          "TCPResponseRule"
        ],
        "summary": "Replace a TCP Response Rule list",
        "operationId": "replaceAllTCPResponseRuleBackend",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/tcp_response_rules"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "All TCP Response Rule lines replaced",
            "schema": {
              "$ref": "#/definitions/tcp_response_rules"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/tcp_response_rules"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/backends/{parent_name}/tcp_response_rules/{index}": {
      "get": {
        "description": "Returns one TCP Response Rule configuration by it's index in the specified backend.",
        "tags": [
          "TCPResponseRule"
        ],
        "summary": "Return one TCP Response Rule",
        "operationId": "getTCPResponseRuleBackend",
        "parameters": [
          {
            "type": "integer",
            "description": "TCP Response Rule Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/tcp_response_rule"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a TCP Response Rule configuration by it's Index in the specified backend.",
        "tags": [
          "TCPResponseRule"
        ],
        "summary": "Replace a TCP Response Rule",
        "operationId": "replaceTCPResponseRuleBackend",
        "parameters": [
          {
            "type": "integer",
            "description": "TCP Response Rule Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/tcp_response_rule"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "TCP Response Rule replaced",
            "schema": {
              "$ref": "#/definitions/tcp_response_rule"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/tcp_response_rule"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new TCP Response Rule of the specified type in the specified backend.",
        "tags": [
          "TCPResponseRule"
        ],
        "summary": "Add a new TCP Response Rule",
        "operationId": "createTCPResponseRuleBackend",
        "parameters": [
          {
            "type": "integer",
            "description": "TCP Response Rule Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/tcp_response_rule"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "201": {
            "description": "TCP Response Rule created",
            "schema": {
              "$ref": "#/definitions/tcp_response_rule"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/tcp_response_rule"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a TCP Response Rule configuration by it's index from the specified backend.",
        "tags": [
          "TCPResponseRule"
        ],
        "summary": "Delete a TCP Response Rule",
        "operationId": "deleteTCPResponseRuleBackend",
        "parameters": [
          {
            "type": "integer",
            "description": "TCP Response Rule Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "TCP Response Rule deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/caches": {
      "get": {
        "description": "Returns an array of all configured caches.",
        "tags": [
          "Cache"
        ],
        "summary": "Return an array of caches",
        "operationId": "getCaches",
        "parameters": [
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/caches"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new cache section to the configuration file.",
        "tags": [
          "Cache"
        ],
        "summary": "Add a cache",
        "operationId": "createCache",
        "parameters": [
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/cache"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "201": {
            "description": "Cache created",
            "schema": {
              "$ref": "#/definitions/cache"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/cache"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/caches/{name}": {
      "get": {
        "description": "Returns one cache section configuration by it's name.",
        "tags": [
          "Cache"
        ],
        "summary": "Return a cache",
        "operationId": "getCache",
        "parameters": [
          {
            "type": "string",
            "description": "Cache name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/cache"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a cache configuration by it's name.",
        "tags": [
          "Cache"
        ],
        "summary": "Replace a cache",
        "operationId": "replaceCache",
        "parameters": [
          {
            "type": "string",
            "description": "Cache name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/cache"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "Cache replaced",
            "schema": {
              "$ref": "#/definitions/cache"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/cache"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a cache from the configuration by it's name.",
        "tags": [
          "Cache"
        ],
        "summary": "Delete a cache",
        "operationId": "deleteCache",
        "parameters": [
          {
            "type": "string",
            "description": "Cache name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "Cache deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/crt_loads": {
      "get": {
        "description": "Returns the list of loaded certificates from the specified crt_store",
        "tags": [
          "CrtLoad"
        ],
        "summary": "Return an array of loaded certificates",
        "operationId": "getCrtLoads",
        "parameters": [
          {
            "type": "string",
            "description": "Parent crt_store name",
            "name": "crt_store",
            "in": "query",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/crt_loads"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new load entry to the specified crt_store section in the configuration",
        "tags": [
          "CrtLoad"
        ],
        "summary": "Add a new certificate to load",
        "operationId": "createCrtLoad",
        "parameters": [
          {
            "type": "string",
            "description": "Parent crt_store section name",
            "name": "crt_store",
            "in": "query",
            "required": true
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/crt_load"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "201": {
            "description": "Certificate load entry created",
            "schema": {
              "$ref": "#/definitions/crt_load"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/crt_load"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/crt_loads/{certificate}": {
      "get": {
        "description": "Returns one load entry by its certificate name in the specified crt_store",
        "tags": [
          "CrtLoad"
        ],
        "summary": "Return one certificate load entry",
        "operationId": "getCrtLoad",
        "parameters": [
          {
            "type": "string",
            "description": "Certificate filename",
            "name": "certificate",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Parent crt_store name",
            "name": "crt_store",
            "in": "query",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/crt_load"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a load entry by its certificate name in the specified crt_store section",
        "tags": [
          "CrtLoad"
        ],
        "summary": "Replace a certificate load entry",
        "operationId": "replaceCrtLoad",
        "parameters": [
          {
            "type": "string",
            "description": "Certificate filename",
            "name": "certificate",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Parent crt_store section name",
            "name": "crt_store",
            "in": "query",
            "required": true
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/crt_load"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "Certificate load entry replaced",
            "schema": {
              "$ref": "#/definitions/crt_load"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/crt_load"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a load entry by its certificate name in the specified crt_store section",
        "tags": [
          "CrtLoad"
        ],
        "summary": "Delete a certificate load entry",
        "operationId": "deleteCrtLoad",
        "parameters": [
          {
            "type": "string",
            "description": "Certificate filename",
            "name": "certificate",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Parent crt_store section name",
            "name": "crt_store",
            "in": "query",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "Certificate load entry deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/crt_stores": {
      "get": {
        "description": "Returns an array of all the configured crt_store sections in HAProxy",
        "tags": [
          "CrtStore"
        ],
        "summary": "Return all the Certificate Stores",
        "operationId": "getCrtStores",
        "parameters": [
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/crt_stores"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Creates a new crt_store section",
        "tags": [
          "CrtStore"
        ],
        "summary": "Add a new Certificate Store",
        "operationId": "createCrtStore",
        "parameters": [
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/crt_store"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "201": {
            "description": "Certificate Store created",
            "schema": {
              "$ref": "#/definitions/crt_store"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/crt_store"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/crt_stores/{name}": {
      "get": {
        "description": "Returns crt_store section by its name",
        "tags": [
          "CrtStore"
        ],
        "summary": "Return a Certificate Store",
        "operationId": "getCrtStore",
        "parameters": [
          {
            "type": "string",
            "description": "crt_store name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/crt_store"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Modifies a crt_store's configuration by its name",
        "tags": [
          "CrtStore"
        ],
        "summary": "Modify a Certificate Store",
        "operationId": "editCrtStore",
        "parameters": [
          {
            "type": "string",
            "description": "crt_store name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/crt_store"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "crt_store configuration updated",
            "schema": {
              "$ref": "#/definitions/crt_store"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/crt_store"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a crt_store section from the configuration",
        "tags": [
          "CrtStore"
        ],
        "summary": "Delete a Certificate Store",
        "operationId": "deleteCrtStore",
        "parameters": [
          {
            "type": "string",
            "description": "crt_store name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "crt_store deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/defaults": {
      "get": {
        "description": "Returns an array of all configured defaults.",
        "tags": [
          "Defaults"
        ],
        "summary": "Return an array of defaults",
        "operationId": "getDefaultsSections",
        "parameters": [
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/full_section"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/defaults_sections"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Adds a new defaults section to the configuration file.",
        "tags": [
          "Defaults"
        ],
        "summary": "Add a defaults section",
        "operationId": "createDefaultsSection",
        "parameters": [
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/defaults"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          },
          {
            "$ref": "#/parameters/full_section"
          }
        ],
        "responses": {
          "201": {
            "description": "Defaults created",
            "schema": {
              "$ref": "#/definitions/defaults"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/defaults"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/defaults/{name}": {
      "get": {
        "description": "Returns one defaults section configuration by it's name.",
        "tags": [
          "Defaults"
        ],
        "summary": "Return a defaults section",
        "operationId": "getDefaultsSection",
        "parameters": [
          {
            "type": "string",
            "description": "Defaults name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/full_section"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/defaults"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a defatults section configuration by it's name.",
        "tags": [
          "Defaults"
        ],
        "summary": "Replace a defatults section",
        "operationId": "replaceDefaultsSection",
        "parameters": [
          {
            "type": "string",
            "description": "Defaults name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/defaults"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          },
          {
            "$ref": "#/parameters/full_section"
          }
        ],
        "responses": {
          "200": {
            "description": "Defaults section replaced",
            "schema": {
              "$ref": "#/definitions/defaults"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/defaults"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a defaults section from the configuration by it's name.",
        "tags": [
          "Defaults"
        ],
        "summary": "Delete a defaults section",
        "operationId": "deleteDefaultsSection",
        "parameters": [
          {
            "type": "string",
            "description": "Defaults name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          },
          {
            "$ref": "#/parameters/full_section"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "Defaults section deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/defaults/{parent_name}/http_checks": {
      "get": {
        "description": "Returns all HTTP checks that are configured in specified parent.",
        "tags": [
          "HTTPCheck"
        ],
        "summary": "Return an array of HTTP checks",
        "operationId": "getAllHTTPCheckDefaults",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/http_checks"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a whole list of HTTP checks with the list given in parameter",
        "tags": [
          "HTTPCheck"
        ],
        "summary": "Replace an HTTP checks list",
        "operationId": "replaceAllHTTPCheckDefaults",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/http_checks"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "All HTTP checks lines replaced",
            "schema": {
              "$ref": "#/definitions/http_checks"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/http_checks"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/defaults/{parent_name}/http_checks/{index}": {
      "get": {
        "description": "Returns one HTTP check configuration by it's index in the specified parent.",
        "tags": [
          "HTTPCheck"
        ],
        "summary": "Return one HTTP check",
        "operationId": "getHTTPCheckDefaults",
        "parameters": [
          {
            "type": "integer",
            "description": "HTTP Check Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/http_check"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a HTTP Check configuration by it's index in the specified parent.",
        "tags": [
          "HTTPCheck"
        ],
        "summary": "Replace a HTTP check",
        "operationId": "replaceHTTPCheckDefaults",
        "parameters": [
          {
            "type": "integer",
            "description": "HTTP Check Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/http_check"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "HTTP check replaced",
            "schema": {
              "$ref": "#/definitions/http_check"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/http_check"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new HTTP check of the specified type in the specified parent.",
        "tags": [
          "HTTPCheck"
        ],
        "summary": "Add a new HTTP check",
        "operationId": "createHTTPCheckDefaults",
        "parameters": [
          {
            "type": "integer",
            "description": "HTTP check Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/http_check"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "201": {
            "description": "HTTP check created",
            "schema": {
              "$ref": "#/definitions/http_check"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/http_check"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a HTTP check configuration by it's index from the specified parent.",
        "tags": [
          "HTTPCheck"
        ],
        "summary": "Delete a HTTP check",
        "operationId": "deleteHTTPCheckDefaults",
        "parameters": [
          {
            "type": "integer",
            "description": "HTTP check Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "HTTP check deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/defaults/{parent_name}/http_error_rules": {
      "get": {
        "description": "Returns all HTTP Error Rules that are configured in the specified parent.",
        "tags": [
          "HTTPErrorRule"
        ],
        "summary": "Return an array of all HTTP Error Rules",
        "operationId": "getAllHTTPErrorRuleDefaults",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/http_error_rules"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a whole list of HTTP Error Rules with the list given in parameter",
        "tags": [
          "HTTPErrorRule"
        ],
        "summary": "Replace an HTTP Error Rules list",
        "operationId": "replaceAllHTTPErrorRuleDefaults",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/http_error_rules"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "All HTTP Error Rules lines replaced",
            "schema": {
              "$ref": "#/definitions/http_error_rules"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/http_error_rules"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/defaults/{parent_name}/http_error_rules/{index}": {
      "get": {
        "description": "Returns one HTTP Error Rule configuration by its index in the specified parent.",
        "tags": [
          "HTTPErrorRule"
        ],
        "summary": "Return one HTTP Error Rule",
        "operationId": "getHTTPErrorRuleDefaults",
        "parameters": [
          {
            "type": "integer",
            "description": "HTTP Error Rule Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/http_error_rule"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a HTTP Error Rule configuration by its index in the specified parent.",
        "tags": [
          "HTTPErrorRule"
        ],
        "summary": "Replace a HTTP Error Rule",
        "operationId": "replaceHTTPErrorRuleDefaults",
        "parameters": [
          {
            "type": "integer",
            "description": "HTTP Error Rule Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/http_error_rule"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "HTTP Error Rule replaced",
            "schema": {
              "$ref": "#/definitions/http_error_rule"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/http_error_rule"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new HTTP Error Rule of the specified type in the specified parent.",
        "tags": [
          "HTTPErrorRule"
        ],
        "summary": "Add a new HTTP Error Rule",
        "operationId": "createHTTPErrorRuleDefaults",
        "parameters": [
          {
            "type": "integer",
            "description": "HTTP Error Rule Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/http_error_rule"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "201": {
            "description": "HTTP Error Rule created",
            "schema": {
              "$ref": "#/definitions/http_error_rule"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/http_error_rule"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a HTTP Error Rule configuration by its index from the specified parent.",
        "tags": [
          "HTTPErrorRule"
        ],
        "summary": "Delete a HTTP Error Rule",
        "operationId": "deleteHTTPErrorRuleDefaults",
        "parameters": [
          {
            "type": "integer",
            "description": "HTTP Error Rule Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "HTTP Error Rule deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/defaults/{parent_name}/log_targets": {
      "get": {
        "description": "Returns all Log Targets that are configured in specified parent.",
        "tags": [
          "LogTarget"
        ],
        "summary": "Return an array of all Log Targets",
        "operationId": "getAllLogTargetDefaults",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/log_targets"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a whole list of Log Targets with the list given in parameter",
        "tags": [
          "LogTarget"
        ],
        "summary": "Replace a Log Target list",
        "operationId": "replaceAllLogTargetDefaults",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/log_targets"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "All Log Target lines replaced",
            "schema": {
              "$ref": "#/definitions/log_targets"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/log_targets"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/defaults/{parent_name}/log_targets/{index}": {
      "get": {
        "description": "Returns one Log Target configuration by it's index in the specified parent.",
        "tags": [
          "LogTarget"
        ],
        "summary": "Return one Log Target",
        "operationId": "getLogTargetDefaults",
        "parameters": [
          {
            "type": "integer",
            "description": "Log Target Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/log_target"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a Log Target configuration by it's index in the specified parent.",
        "tags": [
          "LogTarget"
        ],
        "summary": "Replace a Log Target",
        "operationId": "replaceLogTargetDefaults",
        "parameters": [
          {
            "type": "integer",
            "description": "Log Target Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/log_target"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "Log Target replaced",
            "schema": {
              "$ref": "#/definitions/log_target"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/log_target"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new Log Target of the specified type in the specified parent.",
        "tags": [
          "LogTarget"
        ],
        "summary": "Add a new Log Target",
        "operationId": "createLogTargetDefaults",
        "parameters": [
          {
            "type": "integer",
            "description": "Log Target Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/log_target"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "201": {
            "description": "Log Target created",
            "schema": {
              "$ref": "#/definitions/log_target"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/log_target"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a Log Target configuration by it's index from the specified parent.",
        "tags": [
          "LogTarget"
        ],
        "summary": "Delete a Log Target",
        "operationId": "deleteLogTargetDefaults",
        "parameters": [
          {
            "type": "integer",
            "description": "Log Target Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "Log Target deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/defaults/{parent_name}/tcp_checks": {
      "get": {
        "description": "Returns all TCP checks that are configured in specified parent.",
        "tags": [
          "TCPCheck"
        ],
        "summary": "Return an array of TCP checks",
        "operationId": "getAllTCPCheckDefaults",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/tcp_checks"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a whole list of TCP Checks with the list given in parameter",
        "tags": [
          "TCPCheck"
        ],
        "summary": "Replace an TCP Check list",
        "operationId": "replaceAllTCPCheckDefaults",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/tcp_checks"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "All TCP Check lines replaced",
            "schema": {
              "$ref": "#/definitions/tcp_checks"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/tcp_checks"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/defaults/{parent_name}/tcp_checks/{index}": {
      "get": {
        "description": "Returns one TCP check configuration by it's index in the specified parent.",
        "tags": [
          "TCPCheck"
        ],
        "summary": "Return one TCP check",
        "operationId": "getTCPCheckDefaults",
        "parameters": [
          {
            "type": "integer",
            "description": "TCP Check Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/tcp_check"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a TCP Check configuration by it's index in the specified parent.",
        "tags": [
          "TCPCheck"
        ],
        "summary": "Replace a TCP check",
        "operationId": "replaceTCPCheckDefaults",
        "parameters": [
          {
            "type": "integer",
            "description": "TCP Check Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/tcp_check"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "TCP check replaced",
            "schema": {
              "$ref": "#/definitions/tcp_check"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/tcp_check"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new TCP check of the specified type in the specified parent.",
        "tags": [
          "TCPCheck"
        ],
        "summary": "Add a new TCP check",
        "operationId": "createTCPCheckDefaults",
        "parameters": [
          {
            "type": "integer",
            "description": "TCP check Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/tcp_check"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "201": {
            "description": "TCP check created",
            "schema": {
              "$ref": "#/definitions/tcp_check"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/tcp_check"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a TCP check configuration by it's index from the specified parent.",
        "tags": [
          "TCPCheck"
        ],
        "summary": "Delete a TCP check",
        "operationId": "deleteTCPCheckDefaults",
        "parameters": [
          {
            "type": "integer",
            "description": "TCP check Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "TCP check deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/fcgi_apps": {
      "get": {
        "description": "Returns an array of all configured FCGI applications.",
        "tags": [
          "FCGIApp"
        ],
        "summary": "Return an array of FCGI apps",
        "operationId": "getFCGIApps",
        "parameters": [
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/full_section"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/fcgiApps"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new FCGI application to the configuration file.",
        "tags": [
          "FCGIApp"
        ],
        "summary": "Add an FCGI app",
        "operationId": "createFCGIApp",
        "parameters": [
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/fcgiApp"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          },
          {
            "$ref": "#/parameters/full_section"
          }
        ],
        "responses": {
          "201": {
            "description": "Application created",
            "schema": {
              "$ref": "#/definitions/fcgiApp"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/fcgiApp"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/fcgi_apps/{name}": {
      "get": {
        "description": "Returns one FCGI application configuration by its name.",
        "tags": [
          "FCGIApp"
        ],
        "summary": "Return a FCGI app",
        "operationId": "getFCGIApp",
        "parameters": [
          {
            "type": "string",
            "description": "Application name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/full_section"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/fcgiApp"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a FCGI application configuration by its name.",
        "tags": [
          "FCGIApp"
        ],
        "summary": "Replace a FCGI app",
        "operationId": "replaceFCGIApp",
        "parameters": [
          {
            "type": "string",
            "description": "Application name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/fcgiApp"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          },
          {
            "$ref": "#/parameters/full_section"
          }
        ],
        "responses": {
          "200": {
            "description": "Application replaced",
            "schema": {
              "$ref": "#/definitions/fcgiApp"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/fcgiApp"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes an FCGI application from the configuration by its name.",
        "tags": [
          "FCGIApp"
        ],
        "summary": "Delete an FCGI app",
        "operationId": "deleteFCGIApp",
        "parameters": [
          {
            "type": "string",
            "description": "Application name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "Application deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/fcgi_apps/{parent_name}/acls": {
      "get": {
        "description": "Returns all ACL lines that are configured in specified parent.",
        "tags": [
          "ACL"
        ],
        "summary": "Return an array of all ACL lines",
        "operationId": "getAllAclFCGIApp",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "type": "string",
            "description": "ACL name",
            "name": "acl_name",
            "in": "query"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/acls"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a whole list of ACLs with the list given in parameter",
        "tags": [
          "ACL"
        ],
        "summary": "Replace an ACL list",
        "operationId": "replaceAllAclFCGIApp",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/acls"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "All ACL lines replaced",
            "schema": {
              "$ref": "#/definitions/acls"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/acls"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/fcgi_apps/{parent_name}/acls/{index}": {
      "get": {
        "description": "Returns one ACL line configuration by it's index in the specified parent.",
        "tags": [
          "ACL"
        ],
        "summary": "Return one ACL line",
        "operationId": "getAclFCGIApp",
        "parameters": [
          {
            "type": "integer",
            "description": "ACL line Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/acl"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a ACL line configuration by it's index in the specified parent.",
        "tags": [
          "ACL"
        ],
        "summary": "Replace a ACL line",
        "operationId": "replaceAclFCGIApp",
        "parameters": [
          {
            "type": "integer",
            "description": "ACL line Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/acl"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "ACL line replaced",
            "schema": {
              "$ref": "#/definitions/acl"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/acl"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new ACL line of the specified type in the specified parent.",
        "tags": [
          "ACL"
        ],
        "summary": "Add a new ACL line",
        "operationId": "createAclFCGIApp",
        "parameters": [
          {
            "type": "integer",
            "description": "ACL line Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/acl"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "201": {
            "description": "ACL line created",
            "schema": {
              "$ref": "#/definitions/acl"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/acl"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a ACL line configuration by it's index from the specified parent.",
        "tags": [
          "ACL"
        ],
        "summary": "Delete a ACL line",
        "operationId": "deleteAclFCGIApp",
        "parameters": [
          {
            "type": "integer",
            "description": "ACL line Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "ACL line deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/frontends": {
      "get": {
        "description": "Returns an array of all configured frontends.",
        "tags": [
          "Frontend"
        ],
        "summary": "Return an array of frontends",
        "operationId": "getFrontends",
        "parameters": [
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/full_section"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/frontends"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new frontend to the configuration file.",
        "tags": [
          "Frontend"
        ],
        "summary": "Add a frontend",
        "operationId": "createFrontend",
        "parameters": [
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/frontend"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          },
          {
            "$ref": "#/parameters/full_section"
          }
        ],
        "responses": {
          "201": {
            "description": "Frontend created",
            "schema": {
              "$ref": "#/definitions/frontend"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/frontend"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/frontends/{name}": {
      "get": {
        "description": "Returns one frontend configuration by it's name.",
        "tags": [
          "Frontend"
        ],
        "summary": "Return a frontend",
        "operationId": "getFrontend",
        "parameters": [
          {
            "type": "string",
            "description": "Frontend name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/full_section"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/frontend"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a frontend configuration by it's name.",
        "tags": [
          "Frontend"
        ],
        "summary": "Replace a frontend",
        "operationId": "replaceFrontend",
        "parameters": [
          {
            "type": "string",
            "description": "Frontend name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/frontend"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          },
          {
            "$ref": "#/parameters/full_section"
          }
        ],
        "responses": {
          "200": {
            "description": "Frontend replaced",
            "schema": {
              "$ref": "#/definitions/frontend"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/frontend"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a frontend from the configuration by it's name.",
        "tags": [
          "Frontend"
        ],
        "summary": "Delete a frontend",
        "operationId": "deleteFrontend",
        "parameters": [
          {
            "type": "string",
            "description": "Frontend name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "Frontend deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/frontends/{parent_name}/acls": {
      "get": {
        "description": "Returns all ACL lines that are configured in specified parent.",
        "tags": [
          "ACL"
        ],
        "summary": "Return an array of all ACL lines",
        "operationId": "getAllAclFrontend",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "type": "string",
            "description": "ACL name",
            "name": "acl_name",
            "in": "query"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/acls"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a whole list of ACLs with the list given in parameter",
        "tags": [
          "ACL"
        ],
        "summary": "Replace an ACL list",
        "operationId": "replaceAllAclFrontend",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/acls"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "All ACL lines replaced",
            "schema": {
              "$ref": "#/definitions/acls"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/acls"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/frontends/{parent_name}/acls/{index}": {
      "get": {
        "description": "Returns one ACL line configuration by it's index in the specified parent.",
        "tags": [
          "ACL"
        ],
        "summary": "Return one ACL line",
        "operationId": "getAclFrontend",
        "parameters": [
          {
            "type": "integer",
            "description": "ACL line Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/acl"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a ACL line configuration by it's index in the specified parent.",
        "tags": [
          "ACL"
        ],
        "summary": "Replace a ACL line",
        "operationId": "replaceAclFrontend",
        "parameters": [
          {
            "type": "integer",
            "description": "ACL line Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/acl"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "ACL line replaced",
            "schema": {
              "$ref": "#/definitions/acl"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/acl"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new ACL line of the specified type in the specified parent.",
        "tags": [
          "ACL"
        ],
        "summary": "Add a new ACL line",
        "operationId": "createAclFrontend",
        "parameters": [
          {
            "type": "integer",
            "description": "ACL line Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/acl"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "201": {
            "description": "ACL line created",
            "schema": {
              "$ref": "#/definitions/acl"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/acl"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a ACL line configuration by it's index from the specified parent.",
        "tags": [
          "ACL"
        ],
        "summary": "Delete a ACL line",
        "operationId": "deleteAclFrontend",
        "parameters": [
          {
            "type": "integer",
            "description": "ACL line Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "ACL line deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/frontends/{parent_name}/backend_switching_rules": {
      "get": {
        "description": "Returns all Backend Switching Rules that are configured in specified frontend.",
        "tags": [
          "BackendSwitchingRule"
        ],
        "summary": "Return an array of all Backend Switching Rules",
        "operationId": "getBackendSwitchingRules",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/backend_switching_rules"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a whole list of Backend Switching Rules with the list given in parameter",
        "tags": [
          "BackendSwitchingRule"
        ],
        "summary": "Replace an Backend Switching Rule list",
        "operationId": "replaceBackendSwitchingRules",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/backend_switching_rules"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "All Backend Switching Rule lines replaced",
            "schema": {
              "$ref": "#/definitions/backend_switching_rules"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/backend_switching_rules"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/frontends/{parent_name}/backend_switching_rules/{index}": {
      "get": {
        "description": "Returns one Backend Switching Rule configuration by it's index in the specified frontend.",
        "tags": [
          "BackendSwitchingRule"
        ],
        "summary": "Return one Backend Switching Rule",
        "operationId": "getBackendSwitchingRule",
        "parameters": [
          {
            "type": "integer",
            "description": "Switching Rule Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/backend_switching_rule"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a Backend Switching Rule configuration by it's index in the specified frontend.",
        "tags": [
          "BackendSwitchingRule"
        ],
        "summary": "Replace a Backend Switching Rule",
        "operationId": "replaceBackendSwitchingRule",
        "parameters": [
          {
            "type": "integer",
            "description": "Switching Rule Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/backend_switching_rule"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "Backend Switching Rule replaced",
            "schema": {
              "$ref": "#/definitions/backend_switching_rule"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/backend_switching_rule"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new Backend Switching Rule of the specified type in the specified frontend.",
        "tags": [
          "BackendSwitchingRule"
        ],
        "summary": "Add a new Backend Switching Rule",
        "operationId": "createBackendSwitchingRule",
        "parameters": [
          {
            "type": "integer",
            "description": "Switching Rule Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/backend_switching_rule"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "201": {
            "description": "Backend Switching Rule created",
            "schema": {
              "$ref": "#/definitions/backend_switching_rule"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/backend_switching_rule"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a Backend Switching Rule configuration by it's index from the specified frontend.",
        "tags": [
          "BackendSwitchingRule"
        ],
        "summary": "Delete a Backend Switching Rule",
        "operationId": "deleteBackendSwitchingRule",
        "parameters": [
          {
            "type": "integer",
            "description": "Switching Rule Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "Backend Switching Rule deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/frontends/{parent_name}/binds": {
      "get": {
        "description": "Returns an array of all binds that are configured in specified frontend.",
        "tags": [
          "Bind"
        ],
        "summary": "Return an array of binds",
        "operationId": "getAllBindFrontend",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/binds"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new bind in the specified frontend in the configuration file.",
        "tags": [
          "Bind"
        ],
        "summary": "Add a new bind",
        "operationId": "createBindFrontend",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/bind"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "201": {
            "description": "Bind created",
            "schema": {
              "$ref": "#/definitions/bind"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/bind"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/frontends/{parent_name}/binds/{name}": {
      "get": {
        "description": "Returns one bind configuration by it's name in the specified frontend.",
        "tags": [
          "Bind"
        ],
        "summary": "Return one bind",
        "operationId": "getBindFrontend",
        "parameters": [
          {
            "type": "string",
            "description": "Bind name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/bind"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a bind configuration by it's name in the specified frontend.",
        "tags": [
          "Bind"
        ],
        "summary": "Replace a bind",
        "operationId": "replaceBindFrontend",
        "parameters": [
          {
            "type": "string",
            "description": "Bind name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/bind"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "Bind replaced",
            "schema": {
              "$ref": "#/definitions/bind"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/bind"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a bind configuration by it's name in the specified frontend.",
        "tags": [
          "Bind"
        ],
        "summary": "Delete a bind",
        "operationId": "deleteBindFrontend",
        "parameters": [
          {
            "type": "string",
            "description": "Bind name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "Bind deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/frontends/{parent_name}/captures": {
      "get": {
        "description": "Returns an array of all declare capture records that are configured in specified frontend.",
        "tags": [
          "DeclareCapture"
        ],
        "summary": "Return an array of declare captures",
        "operationId": "getDeclareCaptures",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/captures"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a whole list of declare capture with the list given in parameter",
        "tags": [
          "DeclareCapture"
        ],
        "summary": "Replace a declare capture list",
        "operationId": "replaceDeclareCaptures",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/captures"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "All Declare capture lines replaced",
            "schema": {
              "$ref": "#/definitions/captures"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/captures"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/frontends/{parent_name}/captures/{index}": {
      "get": {
        "description": "Returns one declare capture configuration by it's index in the specified frontend.",
        "tags": [
          "DeclareCapture"
        ],
        "summary": "Return one declare capture",
        "operationId": "getDeclareCapture",
        "parameters": [
          {
            "type": "integer",
            "description": "Declare Capture Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/capture"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a declare capture configuration by it's index in the specified frontend.",
        "tags": [
          "DeclareCapture"
        ],
        "summary": "Replace a declare capture",
        "operationId": "replaceDeclareCapture",
        "parameters": [
          {
            "type": "integer",
            "description": "Declare Capture Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/capture"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "Declare Capture replaced",
            "schema": {
              "$ref": "#/definitions/capture"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/capture"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new declare capture in the specified frontend in the configuration file.",
        "tags": [
          "DeclareCapture"
        ],
        "summary": "Add a new declare capture",
        "operationId": "createDeclareCapture",
        "parameters": [
          {
            "type": "integer",
            "description": "Declare Capture Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/capture"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "201": {
            "description": "Declare capture created",
            "schema": {
              "$ref": "#/definitions/capture"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/capture"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a declare capture configuration by it's index in the specified frontend.",
        "tags": [
          "DeclareCapture"
        ],
        "summary": "Delete a declare capture",
        "operationId": "deleteDeclareCapture",
        "parameters": [
          {
            "type": "integer",
            "description": "Declare Capture Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "Declare Capture deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/frontends/{parent_name}/filters": {
      "get": {
        "description": "Returns all Filters that are configured in specified parent.",
        "tags": [
          "Filter"
        ],
        "summary": "Return an array of all Filters",
        "operationId": "getAllFilterFrontend",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/filters"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a whole list of Filters with the list given in parameter",
        "tags": [
          "Filter"
        ],
        "summary": "Replace a Filter list",
        "operationId": "replaceAllFilterFrontend",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/filters"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "All Filter lines replaced",
            "schema": {
              "$ref": "#/definitions/filters"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/filters"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/frontends/{parent_name}/filters/{index}": {
      "get": {
        "description": "Returns one Filter configuration by it's index in the specified parent.",
        "tags": [
          "Filter"
        ],
        "summary": "Return one Filter",
        "operationId": "getFilterFrontend",
        "parameters": [
          {
            "type": "integer",
            "description": "Filter Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/filter"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a Filter configuration by it's index in the specified parent.",
        "tags": [
          "Filter"
        ],
        "summary": "Replace a Filter",
        "operationId": "replaceFilterFrontend",
        "parameters": [
          {
            "type": "integer",
            "description": "Filter Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/filter"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "Filter replaced",
            "schema": {
              "$ref": "#/definitions/filter"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/filter"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new Filter of the specified type in the specified parent.",
        "tags": [
          "Filter"
        ],
        "summary": "Add a new Filter",
        "operationId": "createFilterFrontend",
        "parameters": [
          {
            "type": "integer",
            "description": "Filter Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/filter"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "201": {
            "description": "Filter created",
            "schema": {
              "$ref": "#/definitions/filter"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/filter"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a Filter configuration by it's index from the specified parent.",
        "tags": [
          "Filter"
        ],
        "summary": "Delete a Filter",
        "operationId": "deleteFilterFrontend",
        "parameters": [
          {
            "type": "integer",
            "description": "Filter Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "Filter deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/frontends/{parent_name}/http_after_response_rules": {
      "get": {
        "description": "Returns all HTTP After Response Rules that are configured in specified parent.",
        "tags": [
          "HTTPAfterResponseRule"
        ],
        "summary": "Return an array of all HTTP After Response Rules",
        "operationId": "getAllHTTPAfterResponseRuleFrontend",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/http_after_response_rules"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a whole list of HTTP After Response Rules with the list given in parameter",
        "tags": [
          "HTTPAfterResponseRule"
        ],
        "summary": "Replace an HTTP After Response Rules list",
        "operationId": "replaceAllHTTPAfterResponseRuleFrontend",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/http_after_response_rules"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "All TTP After Response Rules lines replaced",
            "schema": {
              "$ref": "#/definitions/http_after_response_rules"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/http_after_response_rules"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/frontends/{parent_name}/http_after_response_rules/{index}": {
      "get": {
        "description": "Returns one HTTP After Response Rule configuration by it's index in the specified parent.",
        "tags": [
          "HTTPAfterResponseRule"
        ],
        "summary": "Return one HTTP After Response Rule",
        "operationId": "getHTTPAfterResponseRuleFrontend",
        "parameters": [
          {
            "type": "integer",
            "description": "HTTP After Response Rule Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/http_after_response_rule"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a HTTP After Response Rule configuration by it's index in the specified parent.",
        "tags": [
          "HTTPAfterResponseRule"
        ],
        "summary": "Replace a HTTP After Response Rule",
        "operationId": "replaceHTTPAfterResponseRuleFrontend",
        "parameters": [
          {
            "type": "integer",
            "description": "HTTP After Response Rule Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/http_after_response_rule"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "HTTP After Response Rule replaced",
            "schema": {
              "$ref": "#/definitions/http_after_response_rule"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/http_after_response_rule"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new HTTP After Response Rule of the specified type in the specified parent.",
        "tags": [
          "HTTPAfterResponseRule"
        ],
        "summary": "Add a new HTTP After Response Rule",
        "operationId": "createHTTPAfterResponseRuleFrontend",
        "parameters": [
          {
            "type": "integer",
            "description": "HTTP After Response Rule Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/http_after_response_rule"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "201": {
            "description": "HTTP Response Rule created",
            "schema": {
              "$ref": "#/definitions/http_after_response_rule"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/http_after_response_rule"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a HTTP After Response Rule configuration by it's index from the specified parent.",
        "tags": [
          "HTTPAfterResponseRule"
        ],
        "summary": "Delete a HTTP After Response Rule",
        "operationId": "deleteHTTPAfterResponseRuleFrontend",
        "parameters": [
          {
            "type": "integer",
            "description": "HTTP After Response Rule Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "HTTP After Response Rule deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/frontends/{parent_name}/http_error_rules": {
      "get": {
        "description": "Returns all HTTP Error Rules that are configured in the specified parent.",
        "tags": [
          "HTTPErrorRule"
        ],
        "summary": "Return an array of all HTTP Error Rules",
        "operationId": "getAllHTTPErrorRuleFrontend",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/http_error_rules"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a whole list of HTTP Error Rules with the list given in parameter",
        "tags": [
          "HTTPErrorRule"
        ],
        "summary": "Replace an HTTP Error Rules list",
        "operationId": "replaceAllHTTPErrorRuleFrontend",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/http_error_rules"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "All HTTP Error Rules lines replaced",
            "schema": {
              "$ref": "#/definitions/http_error_rules"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/http_error_rules"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/frontends/{parent_name}/http_error_rules/{index}": {
      "get": {
        "description": "Returns one HTTP Error Rule configuration by its index in the specified parent.",
        "tags": [
          "HTTPErrorRule"
        ],
        "summary": "Return one HTTP Error Rule",
        "operationId": "getHTTPErrorRuleFrontend",
        "parameters": [
          {
            "type": "integer",
            "description": "HTTP Error Rule Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/http_error_rule"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a HTTP Error Rule configuration by its index in the specified parent.",
        "tags": [
          "HTTPErrorRule"
        ],
        "summary": "Replace a HTTP Error Rule",
        "operationId": "replaceHTTPErrorRuleFrontend",
        "parameters": [
          {
            "type": "integer",
            "description": "HTTP Error Rule Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/http_error_rule"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "HTTP Error Rule replaced",
            "schema": {
              "$ref": "#/definitions/http_error_rule"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/http_error_rule"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new HTTP Error Rule of the specified type in the specified parent.",
        "tags": [
          "HTTPErrorRule"
        ],
        "summary": "Add a new HTTP Error Rule",
        "operationId": "createHTTPErrorRuleFrontend",
        "parameters": [
          {
            "type": "integer",
            "description": "HTTP Error Rule Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/http_error_rule"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "201": {
            "description": "HTTP Error Rule created",
            "schema": {
              "$ref": "#/definitions/http_error_rule"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/http_error_rule"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a HTTP Error Rule configuration by its index from the specified parent.",
        "tags": [
          "HTTPErrorRule"
        ],
        "summary": "Delete a HTTP Error Rule",
        "operationId": "deleteHTTPErrorRuleFrontend",
        "parameters": [
          {
            "type": "integer",
            "description": "HTTP Error Rule Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "HTTP Error Rule deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/frontends/{parent_name}/http_request_rules": {
      "get": {
        "description": "Returns all HTTP Request Rules that are configured in specified parent.",
        "tags": [
          "HTTPRequestRule"
        ],
        "summary": "Return an array of all HTTP Request Rules",
        "operationId": "getAllHTTPRequestRuleFrontend",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/http_request_rules"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a whole list of HTTP Request Rules with the list given in parameter",
        "tags": [
          "HTTPRequestRule"
        ],
        "summary": "Replace an HTTP Request Rule list",
        "operationId": "replaceAllHTTPRequestRuleFrontend",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/http_request_rules"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "All HTTP Request Rule lines replaced",
            "schema": {
              "$ref": "#/definitions/http_request_rules"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/http_request_rules"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/frontends/{parent_name}/http_request_rules/{index}": {
      "get": {
        "description": "Returns one HTTP Request Rule configuration by it's index in the specified parent.",
        "tags": [
          "HTTPRequestRule"
        ],
        "summary": "Return one HTTP Request Rule",
        "operationId": "getHTTPRequestRuleFrontend",
        "parameters": [
          {
            "type": "integer",
            "description": "HTTP Request Rule Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/http_request_rule"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a HTTP Request Rule configuration by it's index in the specified parent.",
        "tags": [
          "HTTPRequestRule"
        ],
        "summary": "Replace a HTTP Request Rule",
        "operationId": "replaceHTTPRequestRuleFrontend",
        "parameters": [
          {
            "type": "integer",
            "description": "HTTP Request Rule Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/http_request_rule"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "HTTP Request Rule replaced",
            "schema": {
              "$ref": "#/definitions/http_request_rule"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/http_request_rule"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new HTTP Request Rule of the specified type in the specified parent.",
        "tags": [
          "HTTPRequestRule"
        ],
        "summary": "Add a new HTTP Request Rule",
        "operationId": "createHTTPRequestRuleFrontend",
        "parameters": [
          {
            "type": "integer",
            "description": "HTTP Request Rule Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/http_request_rule"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "201": {
            "description": "HTTP Request Rule created",
            "schema": {
              "$ref": "#/definitions/http_request_rule"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/http_request_rule"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a HTTP Request Rule configuration by it's index from the specified parent.",
        "tags": [
          "HTTPRequestRule"
        ],
        "summary": "Delete a HTTP Request Rule",
        "operationId": "deleteHTTPRequestRuleFrontend",
        "parameters": [
          {
            "type": "integer",
            "description": "HTTP Request Rule Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "HTTP Request Rule deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/frontends/{parent_name}/http_response_rules": {
      "get": {
        "description": "Returns all HTTP Response Rules that are configured in specified parent.",
        "tags": [
          "HTTPResponseRule"
        ],
        "summary": "Return an array of all HTTP Response Rules",
        "operationId": "getAllHTTPResponseRuleFrontend",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/http_response_rules"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a whole list of HTTP Response Rules with the list given in parameter",
        "tags": [
          "HTTPResponseRule"
        ],
        "summary": "Replace an HTTP Response Rule list",
        "operationId": "replaceAllHTTPResponseRuleFrontend",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/http_response_rules"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "All HTTP Response Rule lines replaced",
            "schema": {
              "$ref": "#/definitions/http_response_rules"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/http_response_rules"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/frontends/{parent_name}/http_response_rules/{index}": {
      "get": {
        "description": "Returns one HTTP Response Rule configuration by it's index in the specified parent.",
        "tags": [
          "HTTPResponseRule"
        ],
        "summary": "Return one HTTP Response Rule",
        "operationId": "getHTTPResponseRuleFrontend",
        "parameters": [
          {
            "type": "integer",
            "description": "HTTP Response Rule Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/http_response_rule"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a HTTP Response Rule configuration by it's index in the specified parent.",
        "tags": [
          "HTTPResponseRule"
        ],
        "summary": "Replace a HTTP Response Rule",
        "operationId": "replaceHTTPResponseRuleFrontend",
        "parameters": [
          {
            "type": "integer",
            "description": "HTTP Response Rule Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/http_response_rule"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "HTTP Response Rule replaced",
            "schema": {
              "$ref": "#/definitions/http_response_rule"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/http_response_rule"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new HTTP Response Rule of the specified type in the specified parent.",
        "tags": [
          "HTTPResponseRule"
        ],
        "summary": "Add a new HTTP Response Rule",
        "operationId": "createHTTPResponseRuleFrontend",
        "parameters": [
          {
            "type": "integer",
            "description": "HTTP Response Rule Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/http_response_rule"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "201": {
            "description": "HTTP Response Rule created",
            "schema": {
              "$ref": "#/definitions/http_response_rule"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/http_response_rule"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a HTTP Response Rule configuration by it's index from the specified parent.",
        "tags": [
          "HTTPResponseRule"
        ],
        "summary": "Delete a HTTP Response Rule",
        "operationId": "deleteHTTPResponseRuleFrontend",
        "parameters": [
          {
            "type": "integer",
            "description": "HTTP Response Rule Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "HTTP Response Rule deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/frontends/{parent_name}/log_targets": {
      "get": {
        "description": "Returns all Log Targets that are configured in specified parent.",
        "tags": [
          "LogTarget"
        ],
        "summary": "Return an array of all Log Targets",
        "operationId": "getAllLogTargetFrontend",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/log_targets"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a whole list of Log Targets with the list given in parameter",
        "tags": [
          "LogTarget"
        ],
        "summary": "Replace a Log Target list",
        "operationId": "replaceAllLogTargetFrontend",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/log_targets"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "All Log Target lines replaced",
            "schema": {
              "$ref": "#/definitions/log_targets"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/log_targets"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/frontends/{parent_name}/log_targets/{index}": {
      "get": {
        "description": "Returns one Log Target configuration by it's index in the specified parent.",
        "tags": [
          "LogTarget"
        ],
        "summary": "Return one Log Target",
        "operationId": "getLogTargetFrontend",
        "parameters": [
          {
            "type": "integer",
            "description": "Log Target Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/log_target"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a Log Target configuration by it's index in the specified parent.",
        "tags": [
          "LogTarget"
        ],
        "summary": "Replace a Log Target",
        "operationId": "replaceLogTargetFrontend",
        "parameters": [
          {
            "type": "integer",
            "description": "Log Target Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/log_target"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "Log Target replaced",
            "schema": {
              "$ref": "#/definitions/log_target"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/log_target"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new Log Target of the specified type in the specified parent.",
        "tags": [
          "LogTarget"
        ],
        "summary": "Add a new Log Target",
        "operationId": "createLogTargetFrontend",
        "parameters": [
          {
            "type": "integer",
            "description": "Log Target Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/log_target"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "201": {
            "description": "Log Target created",
            "schema": {
              "$ref": "#/definitions/log_target"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/log_target"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a Log Target configuration by it's index from the specified parent.",
        "tags": [
          "LogTarget"
        ],
        "summary": "Delete a Log Target",
        "operationId": "deleteLogTargetFrontend",
        "parameters": [
          {
            "type": "integer",
            "description": "Log Target Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "Log Target deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/frontends/{parent_name}/tcp_request_rules": {
      "get": {
        "description": "Returns all TCP Request Rules that are configured in specified parent and parent type.",
        "tags": [
          "TCPRequestRule"
        ],
        "summary": "Return an array of all TCP Request Rules",
        "operationId": "getAllTCPRequestRuleFrontend",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/tcp_request_rules"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a whole list of TCP Request Rules with the list given in parameter",
        "tags": [
          "TCPRequestRule"
        ],
        "summary": "Replace an TCP Request Rule list",
        "operationId": "replaceAllTCPRequestRuleFrontend",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/tcp_request_rules"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "All TCP Request Rule lines replaced",
            "schema": {
              "$ref": "#/definitions/tcp_request_rules"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/tcp_request_rules"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/frontends/{parent_name}/tcp_request_rules/{index}": {
      "get": {
        "description": "Returns one TCP Request Rule configuration by it's index in the specified parent.",
        "tags": [
          "TCPRequestRule"
        ],
        "summary": "Return one TCP Request Rule",
        "operationId": "getTCPRequestRuleFrontend",
        "parameters": [
          {
            "type": "integer",
            "description": "TCP Request Rule Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/tcp_request_rule"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a TCP Request Rule configuration by it's index in the specified parent.",
        "tags": [
          "TCPRequestRule"
        ],
        "summary": "Replace a TCP Request Rule",
        "operationId": "replaceTCPRequestRuleFrontend",
        "parameters": [
          {
            "type": "integer",
            "description": "TCP Request Rule Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/tcp_request_rule"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "TCP Request Rule replaced",
            "schema": {
              "$ref": "#/definitions/tcp_request_rule"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/tcp_request_rule"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new TCP Request Rule of the specified type in the specified parent.",
        "tags": [
          "TCPRequestRule"
        ],
        "summary": "Add a new TCP Request Rule",
        "operationId": "createTCPRequestRuleFrontend",
        "parameters": [
          {
            "type": "integer",
            "description": "TCP Request Rule Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/tcp_request_rule"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "201": {
            "description": "TCP Request Rule created",
            "schema": {
              "$ref": "#/definitions/tcp_request_rule"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/tcp_request_rule"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a TCP Request Rule configuration by it's index from the specified parent.",
        "tags": [
          "TCPRequestRule"
        ],
        "summary": "Delete a TCP Request Rule",
        "operationId": "deleteTCPRequestRuleFrontend",
        "parameters": [
          {
            "type": "integer",
            "description": "TCP Request Rule Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "TCP Request Rule deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/global": {
      "get": {
        "description": "Returns global part of configuration.",
        "tags": [
          "Global"
        ],
        "summary": "Return a global part of configuration",
        "operationId": "getGlobal",
        "parameters": [
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/full_section"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/global"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replace global part of config",
        "tags": [
          "Global"
        ],
        "summary": "Replace global",
        "operationId": "replaceGlobal",
        "parameters": [
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/global"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          },
          {
            "$ref": "#/parameters/full_section"
          }
        ],
        "responses": {
          "200": {
            "description": "Global replaced",
            "schema": {
              "$ref": "#/definitions/global"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/global"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/global/log_targets": {
      "get": {
        "description": "Returns all Log Targets that are configured in specified parent.",
        "tags": [
          "LogTarget"
        ],
        "summary": "Return an array of all Log Targets",
        "operationId": "getAllLogTargetGlobal",
        "parameters": [
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/log_targets"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a whole list of Log Targets with the list given in parameter",
        "tags": [
          "LogTarget"
        ],
        "summary": "Replace a Log Target list",
        "operationId": "replaceAllLogTargetGlobal",
        "parameters": [
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/log_targets"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "All Log Target lines replaced",
            "schema": {
              "$ref": "#/definitions/log_targets"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/log_targets"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/global/log_targets/{index}": {
      "get": {
        "description": "Returns one Log Target configuration by it's index in the specified parent.",
        "tags": [
          "LogTarget"
        ],
        "summary": "Return one Log Target",
        "operationId": "getLogTargetGlobal",
        "parameters": [
          {
            "type": "integer",
            "description": "Log Target Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/log_target"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a Log Target configuration by it's index in the specified parent.",
        "tags": [
          "LogTarget"
        ],
        "summary": "Replace a Log Target",
        "operationId": "replaceLogTargetGlobal",
        "parameters": [
          {
            "type": "integer",
            "description": "Log Target Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/log_target"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "Log Target replaced",
            "schema": {
              "$ref": "#/definitions/log_target"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/log_target"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new Log Target of the specified type in the specified parent.",
        "tags": [
          "LogTarget"
        ],
        "summary": "Add a new Log Target",
        "operationId": "createLogTargetGlobal",
        "parameters": [
          {
            "type": "integer",
            "description": "Log Target Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/log_target"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "201": {
            "description": "Log Target created",
            "schema": {
              "$ref": "#/definitions/log_target"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/log_target"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a Log Target configuration by it's index from the specified parent.",
        "tags": [
          "LogTarget"
        ],
        "summary": "Delete a Log Target",
        "operationId": "deleteLogTargetGlobal",
        "parameters": [
          {
            "type": "integer",
            "description": "Log Target Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "Log Target deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/groups": {
      "get": {
        "tags": [
          "Group"
        ],
        "summary": "Return an array of userlist groups",
        "operationId": "getGroups",
        "parameters": [
          {
            "type": "string",
            "description": "Parent userlist name",
            "name": "userlist",
            "in": "query",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/groups"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "tags": [
          "Group"
        ],
        "summary": "Add a new userlist group",
        "operationId": "createGroup",
        "parameters": [
          {
            "type": "string",
            "description": "Parent userlist name",
            "name": "userlist",
            "in": "query",
            "required": true
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/group"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "201": {
            "description": "Group created",
            "schema": {
              "$ref": "#/definitions/group"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/group"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/groups/{name}": {
      "get": {
        "tags": [
          "Group"
        ],
        "summary": "Return one userlist group",
        "operationId": "getGroup",
        "parameters": [
          {
            "type": "string",
            "description": "Group name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Parent userlist name",
            "name": "userlist",
            "in": "query",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/group"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "tags": [
          "Group"
        ],
        "summary": "Replace a group",
        "operationId": "replaceGroup",
        "parameters": [
          {
            "type": "string",
            "description": "group name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Parent userlist name",
            "name": "userlist",
            "in": "query",
            "required": true
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/group"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "Group replaced",
            "schema": {
              "$ref": "#/definitions/group"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/group"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "tags": [
          "Group"
        ],
        "summary": "Delete a group",
        "operationId": "deleteGroup",
        "parameters": [
          {
            "type": "string",
            "description": "group name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Parent userlist name",
            "name": "userlist",
            "in": "query",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "Group deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/http_errors_sections": {
      "get": {
        "description": "Returns an array of all configured http-error sections.",
        "tags": [
          "HTTPErrors"
        ],
        "summary": "Return an array of http-error sections",
        "operationId": "getHTTPErrorsSections",
        "parameters": [
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/http_errors_sections"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new http-error section to the configuration.",
        "tags": [
          "HTTPErrors"
        ],
        "summary": "Add a new http-error section",
        "operationId": "createHTTPErrorsSection",
        "parameters": [
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/http_errors_section"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "201": {
            "description": "http-error section created",
            "schema": {
              "$ref": "#/definitions/http_errors_section"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/http_errors_section"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/http_errors_sections/{name}": {
      "get": {
        "description": "Returns one http-error section with a given name from the configuration.",
        "tags": [
          "HTTPErrors"
        ],
        "summary": "Return a http-error section",
        "operationId": "getHTTPErrorsSection",
        "parameters": [
          {
            "type": "string",
            "description": "http-error section name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/http_errors_section"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a http-error section with a given name in the configuration.",
        "tags": [
          "HTTPErrors"
        ],
        "summary": "Replace a http-error section",
        "operationId": "replaceHTTPErrorsSection",
        "parameters": [
          {
            "type": "string",
            "description": "http-error section name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/http_errors_section"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "http-error section updated",
            "schema": {
              "$ref": "#/definitions/http_errors_section"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/http_errors_section"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a http-error section with a given name from the configuration.",
        "tags": [
          "HTTPErrors"
        ],
        "summary": "Delete a http-error section",
        "operationId": "deleteHTTPErrorsSection",
        "parameters": [
          {
            "type": "string",
            "description": "http-error section name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "http-error section deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/log_forwards": {
      "get": {
        "description": "Returns an array of all configured log forwards.",
        "tags": [
          "LogForward"
        ],
        "summary": "Return an array of log forwards",
        "operationId": "getLogForwards",
        "parameters": [
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/full_section"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/log_forwards"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new log_forward to the configuration file.",
        "tags": [
          "LogForward"
        ],
        "summary": "Add a log forward",
        "operationId": "createLogForward",
        "parameters": [
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/log_forward"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          },
          {
            "$ref": "#/parameters/full_section"
          }
        ],
        "responses": {
          "201": {
            "description": "Log Forward created",
            "schema": {
              "$ref": "#/definitions/log_forward"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/log_forward"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/log_forwards/{name}": {
      "get": {
        "description": "Returns one log forward configuration by it's name.",
        "tags": [
          "LogForward"
        ],
        "summary": "Return a log forward",
        "operationId": "getLogForward",
        "parameters": [
          {
            "type": "string",
            "description": "Log Forward name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/full_section"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/log_forward"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a log forward configuration by it's name.",
        "tags": [
          "LogForward"
        ],
        "summary": "Replace a log forward",
        "operationId": "replaceLogForward",
        "parameters": [
          {
            "type": "string",
            "description": "Log Forward name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/log_forward"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          },
          {
            "$ref": "#/parameters/full_section"
          }
        ],
        "responses": {
          "200": {
            "description": "Log Forward replaced",
            "schema": {
              "$ref": "#/definitions/log_forward"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/log_forward"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a log forward from the configuration by it's name.",
        "tags": [
          "LogForward"
        ],
        "summary": "Delete a log forward",
        "operationId": "deleteLogForward",
        "parameters": [
          {
            "type": "string",
            "description": "Log Forward name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "Log Forward deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/log_forwards/{parent_name}/binds": {
      "get": {
        "description": "Returns an array of all binds that are configured in specified frontend.",
        "tags": [
          "Bind"
        ],
        "summary": "Return an array of binds",
        "operationId": "getAllBindLogForward",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/binds"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new bind in the specified frontend in the configuration file.",
        "tags": [
          "Bind"
        ],
        "summary": "Add a new bind",
        "operationId": "createBindLogForward",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/bind"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "201": {
            "description": "Bind created",
            "schema": {
              "$ref": "#/definitions/bind"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/bind"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/log_forwards/{parent_name}/binds/{name}": {
      "get": {
        "description": "Returns one bind configuration by it's name in the specified frontend.",
        "tags": [
          "Bind"
        ],
        "summary": "Return one bind",
        "operationId": "getBindLogForward",
        "parameters": [
          {
            "type": "string",
            "description": "Bind name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/bind"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a bind configuration by it's name in the specified frontend.",
        "tags": [
          "Bind"
        ],
        "summary": "Replace a bind",
        "operationId": "replaceBindLogForward",
        "parameters": [
          {
            "type": "string",
            "description": "Bind name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/bind"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "Bind replaced",
            "schema": {
              "$ref": "#/definitions/bind"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/bind"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a bind configuration by it's name in the specified frontend.",
        "tags": [
          "Bind"
        ],
        "summary": "Delete a bind",
        "operationId": "deleteBindLogForward",
        "parameters": [
          {
            "type": "string",
            "description": "Bind name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "Bind deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/log_forwards/{parent_name}/dgram_binds": {
      "get": {
        "description": "Returns an array of all dgram binds that are configured in specified log forward.",
        "tags": [
          "DgramBind"
        ],
        "summary": "Return an array of dgram binds",
        "operationId": "getDgramBinds",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/dgram_binds"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new dgram bind in the specified log forward in the configuration file.",
        "tags": [
          "DgramBind"
        ],
        "summary": "Add a new dgram bind",
        "operationId": "createDgramBind",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/dgram_bind"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "201": {
            "description": "Bind created",
            "schema": {
              "$ref": "#/definitions/dgram_bind"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/dgram_bind"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/log_forwards/{parent_name}/dgram_binds/{name}": {
      "get": {
        "description": "Returns one dgram bind configuration by it's name in the specified log forward.",
        "tags": [
          "DgramBind"
        ],
        "summary": "Return one dgram bind",
        "operationId": "getDgramBind",
        "parameters": [
          {
            "type": "string",
            "description": "Bind name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/dgram_bind"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a dgram bind configuration by it's name in the specified log forward.",
        "tags": [
          "DgramBind"
        ],
        "summary": "Replace a dgram bind",
        "operationId": "replaceDgramBind",
        "parameters": [
          {
            "type": "string",
            "description": "Bind name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/dgram_bind"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "Bind replaced",
            "schema": {
              "$ref": "#/definitions/dgram_bind"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/dgram_bind"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a dgram bind configuration by it's name in the specified log forward.",
        "tags": [
          "DgramBind"
        ],
        "summary": "Delete a dgram bind",
        "operationId": "deleteDgramBind",
        "parameters": [
          {
            "type": "string",
            "description": "Bind name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "Bind deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/log_forwards/{parent_name}/log_targets": {
      "get": {
        "description": "Returns all Log Targets that are configured in specified parent.",
        "tags": [
          "LogTarget"
        ],
        "summary": "Return an array of all Log Targets",
        "operationId": "getAllLogTargetLogForward",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/log_targets"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a whole list of Log Targets with the list given in parameter",
        "tags": [
          "LogTarget"
        ],
        "summary": "Replace a Log Target list",
        "operationId": "replaceAllLogTargetLogForward",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/log_targets"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "All Log Target lines replaced",
            "schema": {
              "$ref": "#/definitions/log_targets"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/log_targets"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/log_forwards/{parent_name}/log_targets/{index}": {
      "get": {
        "description": "Returns one Log Target configuration by it's index in the specified parent.",
        "tags": [
          "LogTarget"
        ],
        "summary": "Return one Log Target",
        "operationId": "getLogTargetLogForward",
        "parameters": [
          {
            "type": "integer",
            "description": "Log Target Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/log_target"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a Log Target configuration by it's index in the specified parent.",
        "tags": [
          "LogTarget"
        ],
        "summary": "Replace a Log Target",
        "operationId": "replaceLogTargetLogForward",
        "parameters": [
          {
            "type": "integer",
            "description": "Log Target Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/log_target"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "Log Target replaced",
            "schema": {
              "$ref": "#/definitions/log_target"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/log_target"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new Log Target of the specified type in the specified parent.",
        "tags": [
          "LogTarget"
        ],
        "summary": "Add a new Log Target",
        "operationId": "createLogTargetLogForward",
        "parameters": [
          {
            "type": "integer",
            "description": "Log Target Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/log_target"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "201": {
            "description": "Log Target created",
            "schema": {
              "$ref": "#/definitions/log_target"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/log_target"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a Log Target configuration by it's index from the specified parent.",
        "tags": [
          "LogTarget"
        ],
        "summary": "Delete a Log Target",
        "operationId": "deleteLogTargetLogForward",
        "parameters": [
          {
            "type": "integer",
            "description": "Log Target Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "Log Target deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/mailer_entries": {
      "get": {
        "description": "Returns an array of all the mailer_entries configured in the specified mailers section.",
        "tags": [
          "MailerEntry"
        ],
        "summary": "Return an array of mailer_entries",
        "operationId": "getMailerEntries",
        "parameters": [
          {
            "type": "string",
            "description": "Parent mailers section name",
            "name": "mailers_section",
            "in": "query",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/mailer_entries"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new mailer entry to the specified mailers section in the configuration file.",
        "tags": [
          "MailerEntry"
        ],
        "summary": "Add a new mailer_entry",
        "operationId": "createMailerEntry",
        "parameters": [
          {
            "type": "string",
            "description": "Parent mailers section name",
            "name": "mailers_section",
            "in": "query",
            "required": true
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/mailer_entry"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "201": {
            "description": "MailerEntry created",
            "schema": {
              "$ref": "#/definitions/mailer_entry"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/mailer_entry"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/mailer_entries/{name}": {
      "get": {
        "description": "Returns one mailer_entry configuration by it's name in the specified mailers section.",
        "tags": [
          "MailerEntry"
        ],
        "summary": "Return one mailer_entry",
        "operationId": "getMailerEntry",
        "parameters": [
          {
            "type": "string",
            "description": "MailerEntry name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Parent mailers name",
            "name": "mailers_section",
            "in": "query",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/mailer_entry"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a mailer entry configuration by it's name in the specified mailers section.",
        "tags": [
          "MailerEntry"
        ],
        "summary": "Replace a mailer_entry",
        "operationId": "replaceMailerEntry",
        "parameters": [
          {
            "type": "string",
            "description": "MailerEntry name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Parent mailers section name",
            "name": "mailers_section",
            "in": "query",
            "required": true
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/mailer_entry"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "MailerEntry replaced",
            "schema": {
              "$ref": "#/definitions/mailer_entry"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/mailer_entry"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a mailer entry configuration by it's name in the specified mailers section.",
        "tags": [
          "MailerEntry"
        ],
        "summary": "Delete a mailer_entry",
        "operationId": "deleteMailerEntry",
        "parameters": [
          {
            "type": "string",
            "description": "MailerEntry name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Parent mailers section name",
            "name": "mailers_section",
            "in": "query",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "MailerEntry deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/mailers_section": {
      "get": {
        "description": "Returns an array of all the configured mailers in HAProxy",
        "tags": [
          "Mailers"
        ],
        "summary": "Return an array of mailers sections",
        "operationId": "getMailersSections",
        "parameters": [
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/full_section"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/mailers_sections"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Creates a new empty Mailers section",
        "tags": [
          "Mailers"
        ],
        "summary": "Add a new Mailers section",
        "operationId": "createMailersSection",
        "parameters": [
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/mailers_section"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          },
          {
            "$ref": "#/parameters/full_section"
          }
        ],
        "responses": {
          "201": {
            "description": "Mailers created",
            "schema": {
              "$ref": "#/definitions/mailers_section"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/mailers_section"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/mailers_section/{name}": {
      "get": {
        "description": "Returns one mailers configuration by it's name.",
        "tags": [
          "Mailers"
        ],
        "summary": "Return a Mailers section",
        "operationId": "getMailersSection",
        "parameters": [
          {
            "type": "string",
            "description": "Mailers name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/full_section"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/mailers_section"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Modifies a mailers configuration by it's name.",
        "tags": [
          "Mailers"
        ],
        "summary": "Modify a Mailers section",
        "operationId": "editMailersSection",
        "parameters": [
          {
            "type": "string",
            "description": "Mailers name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/mailers_section"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          },
          {
            "$ref": "#/parameters/full_section"
          }
        ],
        "responses": {
          "200": {
            "description": "Mailers configuration updated",
            "schema": {
              "$ref": "#/definitions/mailers_section"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/mailers_section"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a mailers from the configuration by it's name.",
        "tags": [
          "Mailers"
        ],
        "summary": "Delete a Mailers section",
        "operationId": "deleteMailersSection",
        "parameters": [
          {
            "type": "string",
            "description": "Mailers name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "Mailers deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/nameservers": {
      "get": {
        "description": "Returns an array of all configured nameservers.",
        "tags": [
          "Nameserver"
        ],
        "summary": "Return an array of nameservers",
        "operationId": "getNameservers",
        "parameters": [
          {
            "type": "string",
            "description": "Parent resolver name",
            "name": "resolver",
            "in": "query",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/nameservers"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new nameserver to the resolvers section.",
        "tags": [
          "Nameserver"
        ],
        "summary": "Add a nameserver",
        "operationId": "createNameserver",
        "parameters": [
          {
            "type": "string",
            "description": "Parent resolver name",
            "name": "resolver",
            "in": "query",
            "required": true
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/nameserver"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "201": {
            "description": "Nameserver created",
            "schema": {
              "$ref": "#/definitions/nameserver"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/nameserver"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/nameservers/{name}": {
      "get": {
        "description": "Returns one nameserver configuration by it's name.",
        "tags": [
          "Nameserver"
        ],
        "summary": "Return a nameserver",
        "operationId": "getNameserver",
        "parameters": [
          {
            "type": "string",
            "description": "Nameserver name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Parent resolver name",
            "name": "resolver",
            "in": "query",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/nameserver"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a nameserver configuration by it's name.",
        "tags": [
          "Nameserver"
        ],
        "summary": "Replace a nameserver",
        "operationId": "replaceNameserver",
        "parameters": [
          {
            "type": "string",
            "description": "Nameserver name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Parent resolver name",
            "name": "resolver",
            "in": "query",
            "required": true
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/nameserver"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "Nameserver replaced",
            "schema": {
              "$ref": "#/definitions/nameserver"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/nameserver"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a nameserver from the resolvers section by it's name.",
        "tags": [
          "Nameserver"
        ],
        "summary": "Delete a nameserver",
        "operationId": "deleteNameserver",
        "parameters": [
          {
            "type": "string",
            "description": "Nameserver name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Parent resolver name",
            "name": "resolver",
            "in": "query",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "Nameserver deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/peer_entries": {
      "get": {
        "description": "Returns an array of all peer_entries that are configured in specified peer section.",
        "tags": [
          "PeerEntry"
        ],
        "summary": "Return an array of peer_entries",
        "operationId": "getPeerEntries",
        "parameters": [
          {
            "type": "string",
            "description": "Parent peer section name",
            "name": "peer_section",
            "in": "query",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/peer_entries"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new peer entry in the specified peer section in the configuration file.",
        "tags": [
          "PeerEntry"
        ],
        "summary": "Add a new peer_entry",
        "operationId": "createPeerEntry",
        "parameters": [
          {
            "type": "string",
            "description": "Parent peer section name",
            "name": "peer_section",
            "in": "query",
            "required": true
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/peer_entry"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "201": {
            "description": "PeerEntry created",
            "schema": {
              "$ref": "#/definitions/peer_entry"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/peer_entry"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/peer_entries/{name}": {
      "get": {
        "description": "Returns one peer_entry configuration by it's name in the specified peer section.",
        "tags": [
          "PeerEntry"
        ],
        "summary": "Return one peer_entry",
        "operationId": "getPeerEntry",
        "parameters": [
          {
            "type": "string",
            "description": "PeerEntry name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Parent peers name",
            "name": "peer_section",
            "in": "query",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/peer_entry"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a peer entry configuration by it's name in the specified peer section.",
        "tags": [
          "PeerEntry"
        ],
        "summary": "Replace a peer_entry",
        "operationId": "replacePeerEntry",
        "parameters": [
          {
            "type": "string",
            "description": "PeerEntry name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Parent peers name",
            "name": "peer_section",
            "in": "query",
            "required": true
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/peer_entry"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "PeerEntry replaced",
            "schema": {
              "$ref": "#/definitions/peer_entry"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/peer_entry"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a peer entry configuration by it's name in the specified peer section.",
        "tags": [
          "PeerEntry"
        ],
        "summary": "Delete a peer_entry",
        "operationId": "deletePeerEntry",
        "parameters": [
          {
            "type": "string",
            "description": "PeerEntry name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Parent peers name",
            "name": "peer_section",
            "in": "query",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "PeerEntry deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/peer_section": {
      "get": {
        "description": "Returns an array of all configured peer_section.",
        "tags": [
          "Peer"
        ],
        "summary": "Return an array of peer_section",
        "operationId": "getPeerSections",
        "parameters": [
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/full_section"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/peer_sections"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new peer to the configuration file.",
        "tags": [
          "Peer"
        ],
        "summary": "Add a peer",
        "operationId": "createPeer",
        "parameters": [
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/peer_section"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          },
          {
            "$ref": "#/parameters/full_section"
          }
        ],
        "responses": {
          "201": {
            "description": "Peer created",
            "schema": {
              "$ref": "#/definitions/peer_section"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/peer_section"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/peer_section/{name}": {
      "get": {
        "description": "Returns one peer configuration by it's name.",
        "tags": [
          "Peer"
        ],
        "summary": "Return a peer",
        "operationId": "getPeerSection",
        "parameters": [
          {
            "type": "string",
            "description": "Peer name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/full_section"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/peer_section"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a peer from the configuration by it's name.",
        "tags": [
          "Peer"
        ],
        "summary": "Delete a peer",
        "operationId": "deletePeer",
        "parameters": [
          {
            "type": "string",
            "description": "Peer name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "Peer deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/peers/{parent_name}/binds": {
      "get": {
        "description": "Returns an array of all binds that are configured in specified frontend.",
        "tags": [
          "Bind"
        ],
        "summary": "Return an array of binds",
        "operationId": "getAllBindPeer",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/binds"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new bind in the specified frontend in the configuration file.",
        "tags": [
          "Bind"
        ],
        "summary": "Add a new bind",
        "operationId": "createBindPeer",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/bind"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "201": {
            "description": "Bind created",
            "schema": {
              "$ref": "#/definitions/bind"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/bind"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/peers/{parent_name}/binds/{name}": {
      "get": {
        "description": "Returns one bind configuration by it's name in the specified frontend.",
        "tags": [
          "Bind"
        ],
        "summary": "Return one bind",
        "operationId": "getBindPeer",
        "parameters": [
          {
            "type": "string",
            "description": "Bind name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/bind"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a bind configuration by it's name in the specified frontend.",
        "tags": [
          "Bind"
        ],
        "summary": "Replace a bind",
        "operationId": "replaceBindPeer",
        "parameters": [
          {
            "type": "string",
            "description": "Bind name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/bind"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "Bind replaced",
            "schema": {
              "$ref": "#/definitions/bind"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/bind"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a bind configuration by it's name in the specified frontend.",
        "tags": [
          "Bind"
        ],
        "summary": "Delete a bind",
        "operationId": "deleteBindPeer",
        "parameters": [
          {
            "type": "string",
            "description": "Bind name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "Bind deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/peers/{parent_name}/log_targets": {
      "get": {
        "description": "Returns all Log Targets that are configured in specified parent.",
        "tags": [
          "LogTarget"
        ],
        "summary": "Return an array of all Log Targets",
        "operationId": "getAllLogTargetPeer",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/log_targets"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a whole list of Log Targets with the list given in parameter",
        "tags": [
          "LogTarget"
        ],
        "summary": "Replace a Log Target list",
        "operationId": "replaceAllLogTargetPeer",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/log_targets"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "All Log Target lines replaced",
            "schema": {
              "$ref": "#/definitions/log_targets"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/log_targets"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/peers/{parent_name}/log_targets/{index}": {
      "get": {
        "description": "Returns one Log Target configuration by it's index in the specified parent.",
        "tags": [
          "LogTarget"
        ],
        "summary": "Return one Log Target",
        "operationId": "getLogTargetPeer",
        "parameters": [
          {
            "type": "integer",
            "description": "Log Target Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/log_target"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a Log Target configuration by it's index in the specified parent.",
        "tags": [
          "LogTarget"
        ],
        "summary": "Replace a Log Target",
        "operationId": "replaceLogTargetPeer",
        "parameters": [
          {
            "type": "integer",
            "description": "Log Target Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/log_target"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "Log Target replaced",
            "schema": {
              "$ref": "#/definitions/log_target"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/log_target"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new Log Target of the specified type in the specified parent.",
        "tags": [
          "LogTarget"
        ],
        "summary": "Add a new Log Target",
        "operationId": "createLogTargetPeer",
        "parameters": [
          {
            "type": "integer",
            "description": "Log Target Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/log_target"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "201": {
            "description": "Log Target created",
            "schema": {
              "$ref": "#/definitions/log_target"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/log_target"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a Log Target configuration by it's index from the specified parent.",
        "tags": [
          "LogTarget"
        ],
        "summary": "Delete a Log Target",
        "operationId": "deleteLogTargetPeer",
        "parameters": [
          {
            "type": "integer",
            "description": "Log Target Index",
            "name": "index",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "Log Target deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/peers/{parent_name}/servers": {
      "get": {
        "description": "Returns an array of all servers that are configured in specified backend.",
        "tags": [
          "Server"
        ],
        "summary": "Return an array of servers",
        "operationId": "getAllServerPeer",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/servers"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new server in the specified backend in the configuration file.",
        "tags": [
          "Server"
        ],
        "summary": "Add a new server",
        "operationId": "createServerPeer",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/server"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "201": {
            "description": "Server created",
            "schema": {
              "$ref": "#/definitions/server"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/server"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/peers/{parent_name}/servers/{name}": {
      "get": {
        "description": "Returns one server configuration by it's name in the specified backend.",
        "tags": [
          "Server"
        ],
        "summary": "Return one server",
        "operationId": "getServerPeer",
        "parameters": [
          {
            "type": "string",
            "description": "Server name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/server"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a server configuration by it's name in the specified backend.",
        "tags": [
          "Server"
        ],
        "summary": "Replace a server",
        "operationId": "replaceServerPeer",
        "parameters": [
          {
            "type": "string",
            "description": "Server name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/server"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "Server replaced",
            "schema": {
              "$ref": "#/definitions/server"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/server"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a server configuration by it's name in the specified backend.",
        "tags": [
          "Server"
        ],
        "summary": "Delete a server",
        "operationId": "deleteServerPeer",
        "parameters": [
          {
            "type": "string",
            "description": "Server name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "Server deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/peers/{parent_name}/tables": {
      "get": {
        "description": "Returns an array of all tables that are configured in specified peer section.",
        "tags": [
          "Table"
        ],
        "summary": "Return an array of tables",
        "operationId": "getTables",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/tables"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new table in the specified peer section in the configuration file.",
        "tags": [
          "Table"
        ],
        "summary": "Add a new table",
        "operationId": "createTable",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/table"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "201": {
            "description": "Table created",
            "schema": {
              "$ref": "#/definitions/table"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/table"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/peers/{parent_name}/tables/{name}": {
      "get": {
        "description": "Returns one table configuration by it's name in the specified peer section.",
        "tags": [
          "Table"
        ],
        "summary": "Return one table",
        "operationId": "getTable",
        "parameters": [
          {
            "type": "string",
            "description": "Table name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/table"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a table configuration by it's name in the specified peer section.",
        "tags": [
          "Table"
        ],
        "summary": "Replace a table",
        "operationId": "replaceTable",
        "parameters": [
          {
            "type": "string",
            "description": "Table name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/table"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "Table replaced",
            "schema": {
              "$ref": "#/definitions/table"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/table"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a table configuration by it's name in the specified peer section.",
        "tags": [
          "Table"
        ],
        "summary": "Delete a table",
        "operationId": "deleteTable",
        "parameters": [
          {
            "type": "string",
            "description": "Table name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "Table deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/programs": {
      "get": {
        "description": "Returns an array of all configured programs in the process-manager configuration file.",
        "tags": [
          "ProcessManager"
        ],
        "summary": "Return an array of programs",
        "operationId": "getPrograms",
        "parameters": [
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/programs"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new program to the process-manager configuration file.",
        "tags": [
          "ProcessManager"
        ],
        "summary": "Add a program",
        "operationId": "createProgram",
        "parameters": [
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/program"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "201": {
            "description": "Program created",
            "schema": {
              "$ref": "#/definitions/program"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/program"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/programs/{name}": {
      "get": {
        "description": "Returns one program by its name from the process-manager configuration file.",
        "tags": [
          "ProcessManager"
        ],
        "summary": "Return a program",
        "operationId": "getProgram",
        "parameters": [
          {
            "type": "string",
            "description": "Program name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/program"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a program from the process-manager configuration by its name.",
        "tags": [
          "ProcessManager"
        ],
        "summary": "Replace a program",
        "operationId": "replaceProgram",
        "parameters": [
          {
            "type": "string",
            "description": "Program name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/program"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "Program replaced",
            "schema": {
              "$ref": "#/definitions/program"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/program"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a program from the process-manager configuration file by its name.",
        "tags": [
          "ProcessManager"
        ],
        "summary": "Delete a program",
        "operationId": "deleteProgram",
        "parameters": [
          {
            "type": "string",
            "description": "Program name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "Program deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/raw": {
      "get": {
        "description": "Returns HAProxy configuration file in plain text",
        "produces": [
          "text/plain"
        ],
        "tags": [
          "Configuration"
        ],
        "summary": "Return HAProxy configuration",
        "operationId": "getHAProxyConfiguration",
        "parameters": [
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          }
        ],
        "responses": {
          "200": {
            "description": "Operation successful",
            "schema": {
              "type": "string"
            },
            "headers": {
              "Cluster-Version": {
                "type": "string",
                "description": "Cluster configuration version"
              },
              "Configuration-Checksum": {
                "type": "string",
                "description": "Configuration file md5 checksum"
              },
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Push a new haproxy configuration file in plain text",
        "consumes": [
          "text/plain"
        ],
        "produces": [
          "text/plain"
        ],
        "tags": [
          "Configuration"
        ],
        "summary": "Push new haproxy configuration",
        "operationId": "postHAProxyConfiguration",
        "parameters": [
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "type": "string"
            }
          },
          {
            "type": "boolean",
            "default": false,
            "description": "If set, no version check will be done and the pushed config will be enforced",
            "name": "skip_version",
            "in": "query"
          },
          {
            "type": "boolean",
            "default": false,
            "description": "If set, no reload will be initiated and runtime actions from X-Runtime-Actions will be applied",
            "name": "skip_reload",
            "in": "query"
          },
          {
            "type": "boolean",
            "default": false,
            "description": "If set, only validates configuration, without applying it",
            "name": "only_validate",
            "in": "query"
          },
          {
            "type": "string",
            "description": "List of Runtime API commands with parameters separated by ';'",
            "name": "X-Runtime-Actions",
            "in": "header"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "201": {
            "description": "New HAProxy configuration pushed",
            "schema": {
              "type": "string"
            },
            "headers": {
              "Cluster-Version": {
                "type": "string",
                "description": "Cluster configuration version"
              },
              "Configuration-Checksum": {
                "type": "string",
                "description": "Configuration file md5 checksum"
              },
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "type": "string"
            },
            "headers": {
              "Cluster-Version": {
                "type": "string",
                "description": "Cluster configuration version"
              },
              "Configuration-Checksum": {
                "type": "string",
                "description": "Configuration file md5 checksum"
              },
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              },
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/resolvers": {
      "get": {
        "description": "Returns an array of all configured resolvers.",
        "tags": [
          "Resolver"
        ],
        "summary": "Return an array of resolvers",
        "operationId": "getResolvers",
        "parameters": [
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/full_section"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/resolvers"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new resolver section to the configuration file.",
        "tags": [
          "Resolver"
        ],
        "summary": "Add a resolver",
        "operationId": "createResolver",
        "parameters": [
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/resolver"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          },
          {
            "$ref": "#/parameters/full_section"
          }
        ],
        "responses": {
          "201": {
            "description": "Resolver created",
            "schema": {
              "$ref": "#/definitions/resolver"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/resolver"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/resolvers/{name}": {
      "get": {
        "description": "Returns one resolver section configuration by it's name.",
        "tags": [
          "Resolver"
        ],
        "summary": "Return a resolver",
        "operationId": "getResolver",
        "parameters": [
          {
            "type": "string",
            "description": "Resolver name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/full_section"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/resolver"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a resolver configuration by it's name.",
        "tags": [
          "Resolver"
        ],
        "summary": "Replace a resolver",
        "operationId": "replaceResolver",
        "parameters": [
          {
            "type": "string",
            "description": "Resolver name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/resolver"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          },
          {
            "$ref": "#/parameters/full_section"
          }
        ],
        "responses": {
          "200": {
            "description": "Resolver replaced",
            "schema": {
              "$ref": "#/definitions/resolver"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/resolver"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a resolver from the configuration by it's name.",
        "tags": [
          "Resolver"
        ],
        "summary": "Delete a resolver",
        "operationId": "deleteResolver",
        "parameters": [
          {
            "type": "string",
            "description": "Resolver name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "Resolver deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/rings": {
      "get": {
        "description": "Returns an array of all configured rings.",
        "tags": [
          "Ring"
        ],
        "summary": "Return an array of rings",
        "operationId": "getRings",
        "parameters": [
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/full_section"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/rings"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new ring to the configuration file.",
        "tags": [
          "Ring"
        ],
        "summary": "Add a ring",
        "operationId": "createRing",
        "parameters": [
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/ring"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          },
          {
            "$ref": "#/parameters/full_section"
          }
        ],
        "responses": {
          "201": {
            "description": "Ring created",
            "schema": {
              "$ref": "#/definitions/ring"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/ring"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/rings/{name}": {
      "get": {
        "description": "Returns one ring configuration by it's name.",
        "tags": [
          "Ring"
        ],
        "summary": "Return a ring",
        "operationId": "getRing",
        "parameters": [
          {
            "type": "string",
            "description": "Ring name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/full_section"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/ring"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a ring configuration by it's name.",
        "tags": [
          "Ring"
        ],
        "summary": "Replace a ring",
        "operationId": "replaceRing",
        "parameters": [
          {
            "type": "string",
            "description": "Ring name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/ring"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          },
          {
            "$ref": "#/parameters/full_section"
          }
        ],
        "responses": {
          "200": {
            "description": "Ring replaced",
            "schema": {
              "$ref": "#/definitions/ring"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/ring"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a ring from the configuration by it's name.",
        "tags": [
          "Ring"
        ],
        "summary": "Delete a ring",
        "operationId": "deleteRing",
        "parameters": [
          {
            "type": "string",
            "description": "Ring name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "Ring deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/rings/{parent_name}/servers": {
      "get": {
        "description": "Returns an array of all servers that are configured in specified backend.",
        "tags": [
          "Server"
        ],
        "summary": "Return an array of servers",
        "operationId": "getAllServerRing",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/servers"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new server in the specified backend in the configuration file.",
        "tags": [
          "Server"
        ],
        "summary": "Add a new server",
        "operationId": "createServerRing",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/server"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "201": {
            "description": "Server created",
            "schema": {
              "$ref": "#/definitions/server"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/server"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/rings/{parent_name}/servers/{name}": {
      "get": {
        "description": "Returns one server configuration by it's name in the specified backend.",
        "tags": [
          "Server"
        ],
        "summary": "Return one server",
        "operationId": "getServerRing",
        "parameters": [
          {
            "type": "string",
            "description": "Server name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/server"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a server configuration by it's name in the specified backend.",
        "tags": [
          "Server"
        ],
        "summary": "Replace a server",
        "operationId": "replaceServerRing",
        "parameters": [
          {
            "type": "string",
            "description": "Server name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/server"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "Server replaced",
            "schema": {
              "$ref": "#/definitions/server"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/server"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a server configuration by it's name in the specified backend.",
        "tags": [
          "Server"
        ],
        "summary": "Delete a server",
        "operationId": "deleteServerRing",
        "parameters": [
          {
            "type": "string",
            "description": "Server name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "Server deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/userlists": {
      "get": {
        "description": "Returns an array of all configured userlists.",
        "tags": [
          "Userlist"
        ],
        "summary": "Return an array of userlists",
        "operationId": "getUserlists",
        "parameters": [
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/full_section"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/userlists"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new userlist to the configuration file.",
        "tags": [
          "Userlist"
        ],
        "summary": "Add a new userlist",
        "operationId": "createUserlist",
        "parameters": [
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/userlist"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          },
          {
            "$ref": "#/parameters/full_section"
          }
        ],
        "responses": {
          "201": {
            "description": "Userlist created",
            "schema": {
              "$ref": "#/definitions/userlist"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/userlist"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/userlists/{name}": {
      "get": {
        "description": "Returns one userlist configuration by it's name.",
        "tags": [
          "Userlist"
        ],
        "summary": "Return one userlist",
        "operationId": "getUserlist",
        "parameters": [
          {
            "type": "string",
            "description": "Userlist name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/full_section"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/userlist"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a userlist configuration by it's name.",
        "tags": [
          "Userlist"
        ],
        "summary": "Delete a userlist",
        "operationId": "deleteUserlist",
        "parameters": [
          {
            "type": "string",
            "description": "Userlist name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "Userlist deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/users": {
      "get": {
        "tags": [
          "User"
        ],
        "summary": "Return an array of userlist users",
        "operationId": "getUsers",
        "parameters": [
          {
            "type": "string",
            "description": "Parent userlist name",
            "name": "userlist",
            "in": "query",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/users"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "tags": [
          "User"
        ],
        "summary": "Add a new userlist user",
        "operationId": "createUser",
        "parameters": [
          {
            "type": "string",
            "description": "Parent userlist name",
            "name": "userlist",
            "in": "query",
            "required": true
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/user"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "201": {
            "description": "User created",
            "schema": {
              "$ref": "#/definitions/user"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/user"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/users/{username}": {
      "get": {
        "tags": [
          "User"
        ],
        "summary": "Return one userlist user",
        "operationId": "getUser",
        "parameters": [
          {
            "type": "string",
            "description": "User username",
            "name": "username",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Parent userlist name",
            "name": "userlist",
            "in": "query",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/user"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "tags": [
          "User"
        ],
        "summary": "Replace a user",
        "operationId": "replaceUser",
        "parameters": [
          {
            "type": "string",
            "description": "User username",
            "name": "username",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Parent userlist name",
            "name": "userlist",
            "in": "query",
            "required": true
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/user"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "User replaced",
            "schema": {
              "$ref": "#/definitions/user"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/user"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "tags": [
          "User"
        ],
        "summary": "Delete a user",
        "operationId": "deleteUser",
        "parameters": [
          {
            "type": "string",
            "description": "User username",
            "name": "username",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Parent userlist name",
            "name": "userlist",
            "in": "query",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "User deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/configuration/version": {
      "get": {
        "description": "Returns configuration version.",
        "tags": [
          "Configuration"
        ],
        "summary": "Return a configuration version",
        "operationId": "getConfigurationVersion",
        "parameters": [
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Configuration version",
            "schema": {
              "type": "integer"
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/reloads": {
      "get": {
        "description": "Returns a list of HAProxy reloads.",
        "produces": [
          "application/json"
        ],
        "tags": [
          "Reloads"
        ],
        "summary": "Return list of HAProxy Reloads.",
        "operationId": "getReloads",
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "$ref": "#/definitions/reloads"
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/reloads/{id}": {
      "get": {
        "description": "Returns one HAProxy reload status.",
        "tags": [
          "Reloads"
        ],
        "summary": "Return one HAProxy reload status",
        "operationId": "getReload",
        "parameters": [
          {
            "pattern": "^\\d{4}-\\d{2}-\\d{2}-\\d+$",
            "type": "string",
            "description": "Reload id",
            "name": "id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/reload"
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/runtime": {
      "get": {
        "description": "Returns a list of endpoints to be used for advanced runtime settings of HAProxy objects.",
        "produces": [
          "application/json"
        ],
        "tags": [
          "Discovery"
        ],
        "summary": "Return list of HAProxy advanced runtime endpoints",
        "operationId": "getRuntimeEndpoints",
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "$ref": "#/definitions/endpoints"
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/runtime/acls": {
      "get": {
        "description": "Returns all ACL files using the runtime socket.",
        "produces": [
          "application/json"
        ],
        "tags": [
          "ACL Runtime"
        ],
        "summary": "Return an array of all ACL files",
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/acl_files"
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/runtime/acls/{id}": {
      "get": {
        "description": "Returns an ACL file by id using the runtime socket.",
        "produces": [
          "application/json"
        ],
        "tags": [
          "ACL Runtime"
        ],
        "summary": "Return an ACL file",
        "parameters": [
          {
            "type": "string",
            "description": "ACL file entry ID",
            "name": "id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/acl_file"
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/runtime/acls/{parent_name}/entries": {
      "get": {
        "description": "Returns an ACL runtime setting using the runtime socket.",
        "produces": [
          "application/json"
        ],
        "tags": [
          "ACL Runtime"
        ],
        "summary": "Return an ACL entries",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/acl_files_entries"
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Adds a new ACL payload.",
        "tags": [
          "ACL Runtime"
        ],
        "summary": "Add a new ACL payload",
        "operationId": "addPayloadRuntimeACL",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/acl_files_entries"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "ACL payload added",
            "schema": {
              "$ref": "#/definitions/acl_files_entries"
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds an entry into the ACL file using the runtime socket.",
        "produces": [
          "application/json"
        ],
        "tags": [
          "ACL Runtime"
        ],
        "summary": "Add entry to an ACL file",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/acl_file_entry"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "ACL entry created",
            "schema": {
              "$ref": "#/definitions/acl_file_entry"
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/runtime/acls/{parent_name}/entries/{id}": {
      "get": {
        "description": "Returns the ACL entry by its ID using the runtime socket.",
        "produces": [
          "application/json"
        ],
        "tags": [
          "ACL Runtime"
        ],
        "summary": "Return an ACL entry",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "type": "string",
            "description": "File entry ID",
            "name": "id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/acl_file_entry"
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes the entry from the ACL by its value using the runtime socket.",
        "produces": [
          "application/json"
        ],
        "tags": [
          "ACL Runtime"
        ],
        "summary": "Delete an ACL entry",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "type": "string",
            "description": "File entry ID",
            "name": "id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "Successful operation"
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/runtime/backends/{parent_name}/servers": {
      "get": {
        "description": "Returns an array of all servers' runtime settings.",
        "tags": [
          "Server"
        ],
        "summary": "Return an array of runtime servers' settings",
        "operationId": "getAllRuntimeServer",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/runtime_servers"
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new server to the specified backend",
        "tags": [
          "Server"
        ],
        "summary": "Adds a new server to a backend",
        "operationId": "addRuntimeServer",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/runtime_add_server"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Server added",
            "schema": {
              "$ref": "#/definitions/runtime_add_server"
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/runtime/backends/{parent_name}/servers/{name}": {
      "get": {
        "description": "Returns one server runtime settings by it's name in the specified backend.",
        "tags": [
          "Server"
        ],
        "summary": "Return one server runtime settings",
        "operationId": "getRuntimeServer",
        "parameters": [
          {
            "type": "string",
            "description": "Server name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/runtime_server"
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a server transient settings by it's name in the specified backend.",
        "tags": [
          "Server"
        ],
        "summary": "Replace server transient settings",
        "operationId": "replaceRuntimeServer",
        "parameters": [
          {
            "type": "string",
            "description": "Server name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/runtime_server"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Server transient settings replaced",
            "schema": {
              "$ref": "#/definitions/runtime_server"
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a server from the specified backend",
        "tags": [
          "Server"
        ],
        "summary": "Deletes a server from a backend",
        "operationId": "deleteRuntimeServer",
        "parameters": [
          {
            "type": "string",
            "description": "Server name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          }
        ],
        "responses": {
          "204": {
            "description": "Server deleted"
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/runtime/info": {
      "get": {
        "description": "Return HAProxy process information",
        "produces": [
          "application/json"
        ],
        "tags": [
          "Information"
        ],
        "summary": "Return HAProxy process information",
        "operationId": "getHaproxyProcessInfo",
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "$ref": "#/definitions/process_info"
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/runtime/maps": {
      "get": {
        "description": "Returns runtime map files.",
        "tags": [
          "Maps"
        ],
        "summary": "Return runtime map files",
        "operationId": "getAllRuntimeMapFiles",
        "parameters": [
          {
            "type": "boolean",
            "default": false,
            "description": "If true, also show unmanaged map files loaded in haproxy",
            "name": "include_unmanaged",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/maps"
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/runtime/maps/{name}": {
      "get": {
        "description": "Returns one runtime map file.",
        "tags": [
          "Maps"
        ],
        "summary": "Return one runtime map file",
        "operationId": "getOneRuntimeMap",
        "parameters": [
          {
            "type": "string",
            "description": "Map file name",
            "name": "name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/map"
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Adds a new map payload.",
        "tags": [
          "Maps"
        ],
        "summary": "Add a new map payload",
        "operationId": "addPayloadRuntimeMap",
        "parameters": [
          {
            "type": "string",
            "description": "Map file name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "type": "boolean",
            "default": false,
            "description": "If true, immediately syncs changes to disk",
            "name": "force_sync",
            "in": "query"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/map_entries"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Map payload added",
            "schema": {
              "$ref": "#/definitions/map_entries"
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Remove all map entries from the map file.",
        "tags": [
          "Maps"
        ],
        "summary": "Remove all map entries from the map file",
        "operationId": "clearRuntimeMap",
        "parameters": [
          {
            "type": "string",
            "description": "Map file name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "type": "boolean",
            "description": "If true, deletes file from disk",
            "name": "forceDelete",
            "in": "query"
          },
          {
            "type": "boolean",
            "default": false,
            "description": "If true, immediately syncs changes to disk",
            "name": "force_sync",
            "in": "query"
          }
        ],
        "responses": {
          "204": {
            "description": "All map entries deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/runtime/maps/{parent_name}/entries": {
      "get": {
        "description": "Returns an array of all entries in a given runtime map file.",
        "tags": [
          "Maps"
        ],
        "summary": "Return one map runtime entries",
        "operationId": "showRuntimeMap",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/map_entries"
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds an entry into the map file.",
        "tags": [
          "Maps"
        ],
        "summary": "Adds an entry into the map file",
        "operationId": "addMapEntry",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "type": "boolean",
            "default": false,
            "description": "If true, immediately syncs changes to disk",
            "name": "force_sync",
            "in": "query"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/map_entry"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Map entry created",
            "schema": {
              "$ref": "#/definitions/map_entry"
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/runtime/maps/{parent_name}/entries/{id}": {
      "get": {
        "description": "Returns one map runtime setting by it's id.",
        "tags": [
          "Maps"
        ],
        "summary": "Return one map runtime setting",
        "operationId": "getRuntimeMapEntry",
        "parameters": [
          {
            "type": "string",
            "description": "Map id",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/map_entry"
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces the value corresponding to each id in a map.",
        "tags": [
          "Maps"
        ],
        "summary": "Replace the value corresponding to each id in a map",
        "operationId": "replaceRuntimeMapEntry",
        "parameters": [
          {
            "type": "string",
            "description": "Map id",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "type": "boolean",
            "default": false,
            "description": "If true, immediately syncs changes to disk",
            "name": "force_sync",
            "in": "query"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "type": "object",
              "required": [
                "value"
              ],
              "properties": {
                "value": {
                  "description": "Map value",
                  "type": "string"
                }
              }
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Map value replaced",
            "schema": {
              "$ref": "#/definitions/map_entry"
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Delete all the map entries from the map by its id.",
        "tags": [
          "Maps"
        ],
        "summary": "Deletes all the map entries from the map by its id",
        "operationId": "deleteRuntimeMapEntry",
        "parameters": [
          {
            "type": "string",
            "description": "Map id",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "type": "boolean",
            "default": false,
            "description": "If true, immediately syncs changes to disk",
            "name": "force_sync",
            "in": "query"
          }
        ],
        "responses": {
          "204": {
            "description": "Map key/value deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/runtime/stick_tables": {
      "get": {
        "description": "Returns an array of all stick tables.",
        "tags": [
          "StickTable"
        ],
        "summary": "Return Stick Tables",
        "operationId": "getStickTables",
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/stick_tables"
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/runtime/stick_tables/{name}": {
      "get": {
        "description": "Returns one stick table from runtime.",
        "tags": [
          "StickTable"
        ],
        "summary": "Return Stick Table",
        "operationId": "getStickTable",
        "parameters": [
          {
            "type": "string",
            "description": "Stick table name",
            "name": "name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/stick_table"
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/runtime/stick_tables/{parent_name}/entries": {
      "get": {
        "description": "Returns an array of all entries in a given stick tables.",
        "tags": [
          "StickTable"
        ],
        "summary": "Return Stick Table Entries",
        "operationId": "getStickTableEntries",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "type": "string",
            "description": "A list of filters in format data.\u003ctype\u003e \u003coperator\u003e \u003cvalue\u003e separated by comma",
            "name": "filter",
            "in": "query"
          },
          {
            "type": "string",
            "description": "Key which we want the entries for",
            "name": "key",
            "in": "query"
          },
          {
            "type": "integer",
            "description": "Max number of entries to be returned for pagination",
            "name": "count",
            "in": "query"
          },
          {
            "type": "integer",
            "description": "Offset which indicates how many items we skip in pagination",
            "name": "offset",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/stick_table_entries"
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Create or update a stick-table entry in the table.",
        "tags": [
          "StickTable"
        ],
        "summary": "Set Entry to Stick Table",
        "operationId": "setStickTableEntries",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "description": "Stick table entry",
            "name": "stick_table_entry",
            "in": "body",
            "schema": {
              "type": "object",
              "required": [
                "key",
                "data_type"
              ],
              "properties": {
                "data_type": {
                  "$ref": "#/definitions/stick_table_entry"
                },
                "key": {
                  "type": "string"
                }
              }
            }
          }
        ],
        "responses": {
          "204": {
            "description": "Successful operation"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/sites": {
      "get": {
        "description": "Returns an array of all configured sites.",
        "tags": [
          "Sites"
        ],
        "summary": "Return an array of sites",
        "operationId": "getSites",
        "parameters": [
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/sites"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new site to the configuration file.",
        "tags": [
          "Sites"
        ],
        "summary": "Add a site",
        "operationId": "createSite",
        "parameters": [
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/site"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "201": {
            "description": "Site created",
            "schema": {
              "$ref": "#/definitions/site"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/site"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/sites/{name}": {
      "get": {
        "description": "Returns one site configuration by it's name.",
        "tags": [
          "Sites"
        ],
        "summary": "Return a site",
        "operationId": "getSite",
        "parameters": [
          {
            "type": "string",
            "description": "Site frontend name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/site"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a site configuration by it's name.",
        "tags": [
          "Sites"
        ],
        "summary": "Replace a site",
        "operationId": "replaceSite",
        "parameters": [
          {
            "type": "string",
            "description": "Site frontend name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/site"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "Site replaced",
            "schema": {
              "$ref": "#/definitions/site"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/site"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a site from the configuration by it's name.",
        "tags": [
          "Sites"
        ],
        "summary": "Delete a site",
        "operationId": "deleteSite",
        "parameters": [
          {
            "type": "string",
            "description": "Site frontend name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "Site deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/spoe": {
      "get": {
        "description": "Returns a list of endpoints to be used for SPOE settings of HAProxy.",
        "produces": [
          "application/json"
        ],
        "tags": [
          "Discovery"
        ],
        "summary": "Return list of HAProxy SPOE endpoints",
        "operationId": "getSpoeEndpoints",
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "$ref": "#/definitions/endpoints"
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/spoe/spoe_files": {
      "get": {
        "description": "Returns all available SPOE files.",
        "tags": [
          "Spoe"
        ],
        "summary": "Return all available SPOE files",
        "operationId": "getAllSpoeFiles",
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/spoe_files"
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Creates SPOE file with its entries.",
        "consumes": [
          "multipart/form-data"
        ],
        "tags": [
          "Spoe"
        ],
        "summary": "Creates SPOE file with its entries",
        "operationId": "createSpoe",
        "parameters": [
          {
            "type": "file",
            "x-mimetype": "text/plain",
            "description": "The spoe file to upload",
            "name": "file_upload",
            "in": "formData"
          }
        ],
        "responses": {
          "201": {
            "description": "SPOE file created with its entries",
            "schema": {
              "type": "string"
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/spoe/spoe_files/{name}": {
      "get": {
        "description": "Returns one SPOE file.",
        "tags": [
          "Spoe"
        ],
        "summary": "Return one SPOE file",
        "operationId": "getOneSpoeFile",
        "parameters": [
          {
            "type": "string",
            "description": "SPOE file name",
            "name": "name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "type": "object",
              "properties": {
                "data": {
                  "type": "string"
                }
              }
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Spoe configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes SPOE file.",
        "tags": [
          "Spoe"
        ],
        "summary": "Delete SPOE file",
        "operationId": "deleteSpoeFile",
        "parameters": [
          {
            "type": "string",
            "description": "SPOE file name",
            "name": "name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "SPOE file deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/spoe/spoe_files/{parent_name}/scopes": {
      "get": {
        "description": "Returns an array of all configured spoe scopes.",
        "tags": [
          "Spoe"
        ],
        "summary": "Return an array of spoe scopes",
        "operationId": "getAllSpoeScope",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/spoe_scopes"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Spoe configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new spoe scope.",
        "tags": [
          "Spoe"
        ],
        "summary": "Add a new spoe scope",
        "operationId": "createSpoeScope",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/spoe_scope"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          }
        ],
        "responses": {
          "201": {
            "description": "Spoe scope created",
            "schema": {
              "$ref": "#/definitions/spoe_scope"
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/spoe/spoe_files/{parent_name}/scopes/{name}": {
      "get": {
        "description": "Returns one SPOE scope in one SPOE file.",
        "tags": [
          "Spoe"
        ],
        "summary": "Return one SPOE scope",
        "operationId": "getSpoeScope",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "type": "string",
            "description": "Spoe scope",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/spoe_scope"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Spoe configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a SPOE scope from the configuration file.",
        "tags": [
          "Spoe"
        ],
        "summary": "Delete a SPOE scope",
        "operationId": "deleteSpoeScope",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "type": "string",
            "description": "Spoe scope name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          }
        ],
        "responses": {
          "204": {
            "description": "Spoe scope deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/spoe/spoe_files/{parent_name}/scopes/{scope_name}/agents": {
      "get": {
        "description": "Returns an array of all configured spoe agents in one scope.",
        "tags": [
          "Spoe"
        ],
        "summary": "Return an array of spoe agents in one scope",
        "operationId": "getAllSpoeAgent",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "type": "string",
            "description": "Spoe scope name",
            "name": "scope_name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/spoe_agents"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Spoe configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new spoe agent to the spoe scope.",
        "tags": [
          "Spoe"
        ],
        "summary": "Add a new spoe agent to scope",
        "operationId": "createSpoeAgent",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "type": "string",
            "description": "Spoe scope name",
            "name": "scope_name",
            "in": "path",
            "required": true
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/spoe_agent"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          }
        ],
        "responses": {
          "201": {
            "description": "Spoe agent created",
            "schema": {
              "$ref": "#/definitions/spoe_agent"
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/spoe/spoe_files/{parent_name}/scopes/{scope_name}/agents/{name}": {
      "get": {
        "description": "Returns one spoe agent configuration in one SPOE scope.",
        "tags": [
          "Spoe"
        ],
        "summary": "Return a spoe agent",
        "operationId": "getSpoeAgent",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "type": "string",
            "description": "Spoe scope name",
            "name": "scope_name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Spoe agent name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/spoe_agent"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Spoe configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a SPOE agent configuration in one SPOE scope.",
        "tags": [
          "Spoe"
        ],
        "summary": "Replace a SPOE agent",
        "operationId": "replaceSpoeAgent",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "type": "string",
            "description": "Spoe scope name",
            "name": "scope_name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Spoe agent name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/spoe_agent"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          }
        ],
        "responses": {
          "200": {
            "description": "Spoe agent replaced",
            "schema": {
              "$ref": "#/definitions/spoe_agent"
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a SPOE agent from the configuration in one SPOE scope.",
        "tags": [
          "Spoe"
        ],
        "summary": "Delete a SPOE agent",
        "operationId": "deleteSpoeAgent",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "type": "string",
            "description": "Spoe scope name",
            "name": "scope_name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Spoe agent name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          }
        ],
        "responses": {
          "204": {
            "description": "Spoe agent deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/spoe/spoe_files/{parent_name}/scopes/{scope_name}/groups": {
      "get": {
        "description": "Returns an array of all configured SPOE groups in one SPOE scope.",
        "tags": [
          "Spoe"
        ],
        "summary": "Return an array of SPOE groups",
        "operationId": "getAllSpoeGroup",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "type": "string",
            "description": "Spoe scope name",
            "name": "scope_name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/spoe_groups"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Spoe configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new SPOE groups to the SPOE scope.",
        "tags": [
          "Spoe"
        ],
        "summary": "Add a new SPOE groups",
        "operationId": "createSpoeGroup",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "type": "string",
            "description": "Spoe scope name",
            "name": "scope_name",
            "in": "path",
            "required": true
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/spoe_group"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          }
        ],
        "responses": {
          "201": {
            "description": "Spoe groups created",
            "schema": {
              "$ref": "#/definitions/spoe_group"
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/spoe/spoe_files/{parent_name}/scopes/{scope_name}/groups/{name}": {
      "get": {
        "description": "Returns one SPOE groups configuration in one SPOE scope.",
        "tags": [
          "Spoe"
        ],
        "summary": "Return a SPOE groups",
        "operationId": "getSpoeGroup",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "type": "string",
            "description": "Spoe scope name",
            "name": "scope_name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Spoe group name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/spoe_group"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Spoe configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a SPOE groups configuration in one SPOE scope.",
        "tags": [
          "Spoe"
        ],
        "summary": "Replace a SPOE groups",
        "operationId": "replaceSpoeGroup",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "type": "string",
            "description": "Spoe scope name",
            "name": "scope_name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Spoe group name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/spoe_group"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          }
        ],
        "responses": {
          "200": {
            "description": "Spoe groups replaced",
            "schema": {
              "$ref": "#/definitions/spoe_group"
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a SPOE groups from the one SPOE scope.",
        "tags": [
          "Spoe"
        ],
        "summary": "Delete a SPOE groups",
        "operationId": "deleteSpoeGroup",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "type": "string",
            "description": "Spoe scope name",
            "name": "scope_name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Spoe group name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          }
        ],
        "responses": {
          "204": {
            "description": "Spoe group deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/spoe/spoe_files/{parent_name}/scopes/{scope_name}/messages": {
      "get": {
        "description": "Returns an array of all configured spoe messages in one scope.",
        "tags": [
          "Spoe"
        ],
        "summary": "Return an array of spoe messages in one scope",
        "operationId": "getAllSpoeMessage",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "type": "string",
            "description": "Spoe scope name",
            "name": "scope_name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/spoe_messages"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Spoe configuration file version"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Adds a new spoe message to the spoe scope.",
        "tags": [
          "Spoe"
        ],
        "summary": "Add a new spoe message to scope",
        "operationId": "createSpoeMessage",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "type": "string",
            "description": "Spoe scope name",
            "name": "scope_name",
            "in": "path",
            "required": true
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/spoe_message"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          }
        ],
        "responses": {
          "201": {
            "description": "Spoe message created",
            "schema": {
              "$ref": "#/definitions/spoe_message"
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/spoe/spoe_files/{parent_name}/scopes/{scope_name}/messages/{name}": {
      "get": {
        "description": "Returns one spoe message configuration in SPOE scope.",
        "tags": [
          "Spoe"
        ],
        "summary": "Return a spoe message",
        "operationId": "getSpoeMessage",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "type": "string",
            "description": "Spoe scope name",
            "name": "scope_name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Spoe message name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/spoe_message"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Spoe configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces a spoe message configuration in one SPOE scope.",
        "tags": [
          "Spoe"
        ],
        "summary": "Replace a spoe message",
        "operationId": "replaceSpoeMessage",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "type": "string",
            "description": "Spoe scope name",
            "name": "scope_name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Spoe message name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/spoe_message"
            }
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          }
        ],
        "responses": {
          "200": {
            "description": "Spoe message replaced",
            "schema": {
              "$ref": "#/definitions/spoe_message"
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a spoe message from the SPOE scope.",
        "tags": [
          "Spoe"
        ],
        "summary": "Delete a spoe message",
        "operationId": "deleteSpoeMessage",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "type": "string",
            "description": "Spoe scope name",
            "name": "scope_name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Spoe message name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/version"
          }
        ],
        "responses": {
          "204": {
            "description": "Spoe message deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/spoe/spoe_files/{parent_name}/transactions": {
      "get": {
        "description": "Returns a list of SPOE configuration transactions. Transactions can be filtered by their status.",
        "produces": [
          "application/json"
        ],
        "tags": [
          "SpoeTransactions"
        ],
        "summary": "Return list of SPOE configuration transactions.",
        "operationId": "getAllSpoeTransaction",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "enum": [
              "failed",
              "in_progress"
            ],
            "type": "string",
            "description": "Filter by transaction status",
            "name": "status",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "$ref": "#/definitions/spoe_transactions"
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Starts a new transaction and returns it's id",
        "produces": [
          "application/json"
        ],
        "tags": [
          "SpoeTransactions"
        ],
        "summary": "Start a new transaction",
        "operationId": "startSpoeTransaction",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "type": "integer",
            "description": "Configuration version on which to work on",
            "name": "version",
            "in": "query",
            "required": true
          }
        ],
        "responses": {
          "201": {
            "description": "Transaction started",
            "schema": {
              "$ref": "#/definitions/spoe_transaction"
            }
          },
          "429": {
            "description": "Too many open transactions",
            "schema": {
              "type": "object",
              "properties": {
                "code": {
                  "type": "integer"
                },
                "message": {
                  "type": "string"
                }
              },
              "example": {
                "code": 429,
                "message": "cannot start a new transaction, reached the maximum amount of 20 active transactions available"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/spoe/spoe_files/{parent_name}/transactions/{id}": {
      "get": {
        "description": "Returns one SPOE configuration transactions.",
        "tags": [
          "SpoeTransactions"
        ],
        "summary": "Return one SPOE configuration transactions",
        "operationId": "getSpoeTransaction",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "type": "string",
            "description": "Transaction id",
            "name": "id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/spoe_transaction"
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Commit transaction, execute all operations in transaction and return msg",
        "tags": [
          "SpoeTransactions"
        ],
        "summary": "Commit transaction",
        "operationId": "commitSpoeTransaction",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "type": "string",
            "description": "Transaction id",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "Transaction successfully committed",
            "schema": {
              "$ref": "#/definitions/spoe_transaction"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/spoe_transaction"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a transaction.",
        "tags": [
          "SpoeTransactions"
        ],
        "summary": "Delete a transaction",
        "operationId": "deleteSpoeTransaction",
        "parameters": [
          {
            "$ref": "#/parameters/parent_name"
          },
          {
            "type": "string",
            "description": "Transaction id",
            "name": "id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "Transaction deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/spoe/{parent_name}/version": {
      "get": {
        "description": "Returns SPOE configuration version.",
        "tags": [
          "Spoe"
        ],
        "summary": "Return a SPOE configuration version",
        "operationId": "getSpoeConfigurationVersion",
        "parameters": [
          {
            "$ref": "#/parameters/transaction_id"
          },
          {
            "$ref": "#/parameters/parent_name"
          }
        ],
        "responses": {
          "200": {
            "description": "SPOE configuration version",
            "schema": {
              "type": "integer"
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/stats": {
      "get": {
        "description": "Returns a list of HAProxy stats endpoints.",
        "produces": [
          "application/json"
        ],
        "tags": [
          "Discovery"
        ],
        "summary": "Return list of HAProxy stats endpoints",
        "operationId": "getStatsEndpoints",
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "$ref": "#/definitions/endpoints"
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/stats/native": {
      "get": {
        "description": "Getting stats from the HAProxy.",
        "produces": [
          "application/json"
        ],
        "tags": [
          "Stats"
        ],
        "summary": "Gets stats",
        "operationId": "getStats",
        "parameters": [
          {
            "enum": [
              "frontend",
              "backend",
              "server"
            ],
            "type": "string",
            "description": "Object type to get stats for (one of frontend, backend, server)",
            "name": "type",
            "in": "query"
          },
          {
            "type": "string",
            "description": "Object name to get stats for",
            "name": "name",
            "in": "query"
          },
          {
            "type": "string",
            "x-dependency": {
              "query.type": "server"
            },
            "description": "Object parent name to get stats for, in case the object is a server",
            "name": "parent",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "$ref": "#/definitions/native_stats"
            }
          },
          "500": {
            "description": "Internal Server Error",
            "schema": {
              "$ref": "#/definitions/native_stats"
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/storage": {
      "get": {
        "description": "Returns a list of endpoints that use HAProxy storage for persistency, e.g. maps, ssl certificates...",
        "produces": [
          "application/json"
        ],
        "tags": [
          "Discovery"
        ],
        "summary": "Return list of HAProxy storage endpoints",
        "operationId": "getStorageEndpoints",
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "$ref": "#/definitions/endpoints"
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/storage/general": {
      "get": {
        "description": "Returns a list of all managed general use files",
        "tags": [
          "Storage"
        ],
        "summary": "Return a list of all managed general use files",
        "operationId": "getAllStorageGeneralFiles",
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/general_files"
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Creates a managed storage general use file with contents.",
        "consumes": [
          "multipart/form-data"
        ],
        "tags": [
          "Storage"
        ],
        "summary": "Creates a managed storage general use file with contents",
        "operationId": "createStorageGeneralFile",
        "parameters": [
          {
            "type": "file",
            "x-mimetype": "application/octet-stream",
            "description": "General use file content",
            "name": "file_upload",
            "in": "formData"
          }
        ],
        "responses": {
          "201": {
            "description": "General use file created with its contents",
            "schema": {
              "$ref": "#/definitions/general_file"
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/storage/general/{name}": {
      "get": {
        "description": "Returns the contents of one managed general use file from disk",
        "produces": [
          "application/octet-stream"
        ],
        "tags": [
          "Storage"
        ],
        "summary": "Return the contents of one managed general use file from disk",
        "operationId": "getOneStorageGeneralFile",
        "parameters": [
          {
            "type": "string",
            "description": "General use file storage_name",
            "name": "name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "type": "file"
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces the contents of a managed general use file on disk",
        "consumes": [
          "multipart/form-data"
        ],
        "produces": [
          "application/json"
        ],
        "tags": [
          "Storage"
        ],
        "summary": "Replace contents of a managed general use file on disk",
        "operationId": "replaceStorageGeneralFile",
        "parameters": [
          {
            "type": "string",
            "description": "General use file storage_name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "type": "file",
            "x-mimetype": "application/octet-stream",
            "description": "General use file content",
            "name": "file_upload",
            "in": "formData"
          },
          {
            "$ref": "#/parameters/skip_reload"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "General use file replaced"
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a managed general use file from disk.",
        "tags": [
          "Storage"
        ],
        "summary": "Deletes a managed general use file from disk",
        "operationId": "deleteStorageGeneralFile",
        "parameters": [
          {
            "type": "string",
            "description": "General use file storage_name",
            "name": "name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "General use file deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/storage/maps": {
      "get": {
        "description": "Returns a list of all managed map files",
        "tags": [
          "Storage"
        ],
        "summary": "Return a list of all managed map files",
        "operationId": "getAllStorageMapFiles",
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/maps"
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Creates a managed storage map file with its entries.",
        "consumes": [
          "multipart/form-data"
        ],
        "tags": [
          "Storage"
        ],
        "summary": "Creates a managed storage map file with its entries",
        "operationId": "createStorageMapFile",
        "parameters": [
          {
            "type": "file",
            "x-mimetype": "text/plain",
            "description": "The map file contents",
            "name": "file_upload",
            "in": "formData"
          }
        ],
        "responses": {
          "201": {
            "description": "Map file created with its entries",
            "schema": {
              "$ref": "#/definitions/map"
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/storage/maps/{name}": {
      "get": {
        "description": "Returns the contents of one managed map file from disk",
        "produces": [
          "application/octet-stream"
        ],
        "tags": [
          "Storage"
        ],
        "summary": "Return the contents of one managed map file from disk",
        "operationId": "getOneStorageMap",
        "parameters": [
          {
            "type": "string",
            "description": "Map file storage_name",
            "name": "name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "type": "file"
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces the contents of a managed map file on disk",
        "consumes": [
          "text/plain"
        ],
        "produces": [
          "application/json"
        ],
        "tags": [
          "Storage"
        ],
        "summary": "Replace contents of a managed map file on disk",
        "operationId": "replaceStorageMapFile",
        "parameters": [
          {
            "type": "string",
            "description": "Map file storage_name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "type": "string"
            }
          },
          {
            "$ref": "#/parameters/skip_reload"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "Map file replaced"
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a managed map file from disk.",
        "tags": [
          "Storage"
        ],
        "summary": "Deletes a managed map file from disk",
        "operationId": "deleteStorageMap",
        "parameters": [
          {
            "type": "string",
            "description": "Map file storage_name",
            "name": "name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "Map file deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/storage/ssl_certificates": {
      "get": {
        "description": "Returns all available SSL certificates on disk.",
        "tags": [
          "Storage"
        ],
        "summary": "Return all available SSL certificates on disk",
        "operationId": "getAllStorageSSLCertificates",
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/ssl_certificates"
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Creates SSL certificate.",
        "consumes": [
          "multipart/form-data"
        ],
        "tags": [
          "Storage"
        ],
        "summary": "Create SSL certificate",
        "operationId": "createStorageSSLCertificate",
        "parameters": [
          {
            "type": "file",
            "x-mimetype": "text/plain",
            "description": "The SSL certificate to upload",
            "name": "file_upload",
            "in": "formData"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "201": {
            "description": "SSL certificate created",
            "schema": {
              "$ref": "#/definitions/ssl_certificate"
            }
          },
          "202": {
            "description": "SSL certificate created requested",
            "schema": {
              "$ref": "#/definitions/ssl_certificate"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "409": {
            "$ref": "#/responses/AlreadyExists"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/storage/ssl_certificates/{name}": {
      "get": {
        "description": "Returns one SSL certificate from disk.",
        "tags": [
          "Storage"
        ],
        "summary": "Return one SSL certificate from disk",
        "operationId": "getOneStorageSSLCertificate",
        "parameters": [
          {
            "type": "string",
            "description": "SSL certificate name",
            "name": "name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/ssl_certificate"
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Replaces SSL certificate on disk.",
        "consumes": [
          "text/plain"
        ],
        "produces": [
          "application/json"
        ],
        "tags": [
          "Storage"
        ],
        "summary": "Replace SSL certificates on disk",
        "operationId": "replaceStorageSSLCertificate",
        "parameters": [
          {
            "type": "string",
            "description": "SSL certificate name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "type": "string"
            }
          },
          {
            "$ref": "#/parameters/skip_reload"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "SSL certificate replaced",
            "schema": {
              "$ref": "#/definitions/ssl_certificate"
            }
          },
          "202": {
            "description": "SSL certificate replaced and reload requested",
            "schema": {
              "$ref": "#/definitions/ssl_certificate"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes SSL certificate from disk.",
        "tags": [
          "Storage"
        ],
        "summary": "Delete SSL certificate from disk",
        "operationId": "deleteStorageSSLCertificate",
        "parameters": [
          {
            "type": "string",
            "description": "SSL certificate name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/skip_reload"
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "202": {
            "description": "SSL certificate deleted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "SSL certificate deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/transactions": {
      "get": {
        "description": "Returns a list of HAProxy configuration transactions. Transactions can be filtered by their status.",
        "produces": [
          "application/json"
        ],
        "tags": [
          "Transactions"
        ],
        "summary": "Return list of HAProxy configuration transactions.",
        "operationId": "getTransactions",
        "parameters": [
          {
            "enum": [
              "failed",
              "in_progress"
            ],
            "type": "string",
            "description": "Filter by transaction status",
            "name": "status",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "$ref": "#/definitions/transactions"
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "post": {
        "description": "Starts a new transaction and returns it's id",
        "produces": [
          "application/json"
        ],
        "tags": [
          "Transactions"
        ],
        "summary": "Start a new transaction",
        "operationId": "startTransaction",
        "parameters": [
          {
            "type": "integer",
            "description": "Configuration version on which to work on",
            "name": "version",
            "in": "query",
            "required": true
          }
        ],
        "responses": {
          "201": {
            "description": "Transaction started",
            "schema": {
              "$ref": "#/definitions/transaction"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "429": {
            "description": "Too many open transactions",
            "schema": {
              "type": "object",
              "properties": {
                "code": {
                  "type": "integer"
                },
                "message": {
                  "type": "string"
                }
              },
              "example": {
                "code": 429,
                "message": "cannot start a new transaction, reached the maximum amount of 20 active transactions available"
              }
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/services/haproxy/transactions/{id}": {
      "get": {
        "description": "Returns one HAProxy configuration transactions.",
        "tags": [
          "Transactions"
        ],
        "summary": "Return one HAProxy configuration transactions",
        "operationId": "getTransaction",
        "parameters": [
          {
            "type": "string",
            "description": "Transaction id",
            "name": "id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/transaction"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "put": {
        "description": "Commit transaction, execute all operations in transaction and return msg",
        "tags": [
          "Transactions"
        ],
        "summary": "Commit transaction",
        "operationId": "commitTransaction",
        "parameters": [
          {
            "type": "string",
            "description": "Transaction id",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/force_reload"
          }
        ],
        "responses": {
          "200": {
            "description": "Transaction successfully committed",
            "schema": {
              "$ref": "#/definitions/transaction"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/transaction"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              },
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadRequest"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "406": {
            "$ref": "#/responses/NotAcceptable"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      },
      "delete": {
        "description": "Deletes a transaction.",
        "tags": [
          "Transactions"
        ],
        "summary": "Delete a transaction",
        "operationId": "deleteTransaction",
        "parameters": [
          {
            "type": "string",
            "description": "Transaction id",
            "name": "id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "Transaction deleted"
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/specification": {
      "get": {
        "description": "Return Data Plane API OpenAPI specification",
        "produces": [
          "application/json"
        ],
        "tags": [
          "Specification"
        ],
        "summary": "Data Plane API Specification",
        "operationId": "getSpecification",
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "type": "object"
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    },
    "/specification_openapiv3": {
      "get": {
        "description": "Return Data Plane API OpenAPI v3 specification",
        "produces": [
          "application/json"
        ],
        "tags": [
          "SpecificationOpenapiv3"
        ],
        "summary": "Data Plane API v3 Specification",
        "operationId": "getOpenapiv3Specification",
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "type": "object"
            }
          },
          "default": {
            "$ref": "#/responses/DefaultError"
          }
        }
      }
    }
  },
  "definitions": {
    "acl": {
      "description": "The use of Access Control Lists (ACL) provides a flexible solution to perform\ncontent switching and generally to take decisions based on content extracted\nfrom the request, the response or any environmental status.\n",
      "type": "object",
      "title": "ACL Lines",
      "required": [
        "acl_name",
        "criterion"
      ],
      "properties": {
        "acl_name": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-nullable": false
        },
        "criterion": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-nullable": false
        },
        "value": {
          "type": "string",
          "x-nullable": false
        }
      },
      "additionalProperties": false
    },
    "acl_file": {
      "description": "ACL File",
      "type": "object",
      "title": "ACL File",
      "properties": {
        "description": {
          "type": "string"
        },
        "id": {
          "type": "string"
        },
        "storage_name": {
          "type": "string"
        }
      }
    },
    "acl_file_entry": {
      "description": "One ACL File Entry",
      "type": "object",
      "title": "One ACL File Entry",
      "properties": {
        "id": {
          "type": "string",
          "readOnly": true
        },
        "value": {
          "type": "string"
        }
      }
    },
    "acl_files": {
      "description": "Array of runtime acl files",
      "type": "array",
      "title": "ACL Files Array",
      "items": {
        "$ref": "#/definitions/acl_file"
      }
    },
    "acl_files_entries": {
      "description": "Array of entries of one runtime acl file",
      "type": "array",
      "title": "ACL Files Entries",
      "items": {
        "$ref": "#/definitions/acl_file_entry"
      }
    },
    "acls": {
      "description": "HAProxy ACL lines array (corresponds to acl directives)",
      "type": "array",
      "title": "ACL Lines Array",
      "items": {
        "$ref": "#/definitions/acl"
      }
    },
    "awsFilters": {
      "type": "object",
      "required": [
        "key",
        "value"
      ],
      "properties": {
        "key": {
          "description": "Key to use as filter, using the format specified at https://docs.aws.amazon.com/cli/latest/reference/ec2/describe-instances.html#options",
          "type": "string"
        },
        "value": {
          "description": "Value of the filter to use",
          "type": "string"
        }
      }
    },
    "awsRegion": {
      "description": "AWS region configuration",
      "type": "object",
      "title": "AWS region",
      "required": [
        "name",
        "region",
        "enabled",
        "retry_timeout",
        "ipv4_address"
      ],
      "properties": {
        "access_key_id": {
          "description": "AWS Access Key ID.",
          "type": "string"
        },
        "allowlist": {
          "description": "Specify the AWS filters used to filter the EC2 instances to add",
          "type": "array",
          "items": {
            "$ref": "#/definitions/awsFilters"
          },
          "x-omitempty": true
        },
        "denylist": {
          "description": "Specify the AWS filters used to filter the EC2 instances to ignore",
          "type": "array",
          "items": {
            "$ref": "#/definitions/awsFilters"
          },
          "x-omitempty": true
        },
        "description": {
          "type": "string"
        },
        "enabled": {
          "type": "boolean"
        },
        "id": {
          "description": "Auto generated ID.",
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-nullable": true,
          "readOnly": true
        },
        "ipv4_address": {
          "description": "Select which IPv4 address the Service Discovery has to use for the backend server entry",
          "type": "string",
          "enum": [
            "private",
            "public"
          ]
        },
        "name": {
          "type": "string"
        },
        "region": {
          "type": "string"
        },
        "retry_timeout": {
          "description": "Duration in seconds in-between data pulling requests to the AWS region",
          "type": "integer",
          "minimum": 1
        },
        "secret_access_key": {
          "description": "AWS Secret Access Key.",
          "type": "string"
        },
        "server_slots_base": {
          "type": "integer",
          "default": 10
        },
        "server_slots_growth_increment": {
          "type": "integer"
        },
        "server_slots_growth_type": {
          "type": "string",
          "default": "exponential",
          "enum": [
            "linear",
            "exponential"
          ]
        }
      },
      "example": {
        "access_key_id": "****************L7GT",
        "allowlist": [
          {
            "key": "tag-key",
            "value": "Instance:Having:This:Tag"
          }
        ],
        "denylist": [
          {
            "key": "tag:Environment",
            "value": "development"
          }
        ],
        "enabled": true,
        "id": "0",
        "ipv4_address": "private",
        "name": "frontend-service",
        "region": "us-east-1",
        "retry_timeout": 1,
        "secret_access_key": "****************soLl"
      }
    },
    "awsRegions": {
      "description": "AWS regions array",
      "type": "array",
      "title": "AWS",
      "items": {
        "$ref": "#/definitions/awsRegion"
      }
    },
    "backend": {
      "description": "Backend with all it's children resources",
      "type": "object",
      "allOf": [
        {
          "$ref": "#/definitions/backend_base"
        },
        {
          "type": "object",
          "properties": {
            "acl_list": {
              "x-go-name": "AclList",
              "$ref": "#/definitions/acls"
            },
            "filter_list": {
              "x-go-name": "FilterList",
              "$ref": "#/definitions/filters"
            },
            "http_after_response_rule_list": {
              "x-go-name": "HTTPAfterResponseRuleList",
              "$ref": "#/definitions/http_after_response_rules"
            },
            "http_check_list": {
              "x-go-name": "HTTPCheckList",
              "$ref": "#/definitions/http_checks"
            },
            "http_error_rule_list": {
              "x-go-name": "HTTPErrorRuleList",
              "$ref": "#/definitions/http_error_rules"
            },
            "http_request_rule_list": {
              "x-go-name": "HTTPRequestRuleList",
              "$ref": "#/definitions/http_request_rules"
            },
            "http_response_rule_list": {
              "x-go-name": "HTTPResponseRuleList",
              "$ref": "#/definitions/http_response_rules"
            },
            "log_target_list": {
              "x-go-name": "LogTargetList",
              "$ref": "#/definitions/log_targets"
            },
            "server_switching_rule_list": {
              "x-go-name": "ServerSwitchingRuleList",
              "$ref": "#/definitions/server_switching_rules"
            },
            "server_templates": {
              "additionalProperties": {
                "$ref": "#/definitions/server_template"
              }
            },
            "servers": {
              "additionalProperties": {
                "$ref": "#/definitions/server"
              }
            },
            "stick_rule_list": {
              "x-go-name": "StickRuleList",
              "$ref": "#/definitions/stick_rules"
            },
            "tcp_check_rule_list": {
              "x-go-name": "TCPCheckRuleList",
              "$ref": "#/definitions/tcp_checks"
            },
            "tcp_request_rule_list": {
              "x-go-name": "TCPRequestRuleList",
              "$ref": "#/definitions/tcp_request_rules"
            },
            "tcp_response_rule_list": {
              "x-go-name": "TCPResponseRuleList",
              "$ref": "#/definitions/tcp_response_rules"
            }
          }
        }
      ],
      "x-go-name": "Backend"
    },
    "backend_base": {
      "description": "HAProxy backend configuration",
      "type": "object",
      "title": "Backend Base",
      "required": [
        "name"
      ],
      "properties": {
        "abortonclose": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "accept_invalid_http_response": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "Accept Invalid HTTP Response"
        },
        "adv_check": {
          "type": "string",
          "enum": [
            "httpchk",
            "ldap-check",
            "mysql-check",
            "pgsql-check",
            "redis-check",
            "smtpchk",
            "ssl-hello-chk",
            "tcp-check"
          ],
          "x-display-name": "Advanced Check"
        },
        "allbackups": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "All Backups"
        },
        "balance": {
          "$ref": "#/definitions/balance"
        },
        "check_timeout": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-duration": true,
          "x-nullable": true
        },
        "checkcache": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "Checkcache"
        },
        "compression": {
          "$ref": "#/definitions/compression"
        },
        "connect_timeout": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-duration": true,
          "x-nullable": true
        },
        "cookie": {
          "x-dependency": {
            "mode": {
              "value": "http"
            }
          },
          "$ref": "#/definitions/cookie"
        },
        "default_server": {
          "$ref": "#/definitions/default_server"
        },
        "description": {
          "type": "string",
          "x-display-name": "Description"
        },
        "disabled": {
          "type": "boolean"
        },
        "dynamic_cookie_key": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "cookie": {
              "dynamic": {
                "value": true
              }
            }
          }
        },
        "email_alert": {
          "$ref": "#/definitions/email_alert"
        },
        "enabled": {
          "type": "boolean"
        },
        "error_files": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/errorfile"
          },
          "x-go-name": "ErrorFiles",
          "x-omitempty": true
        },
        "errorfiles_from_http_errors": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/errorfiles"
          },
          "x-go-name": "ErrorFilesFromHTTPErrors",
          "x-omitempty": true
        },
        "errorloc302": {
          "$ref": "#/definitions/errorloc"
        },
        "errorloc303": {
          "$ref": "#/definitions/errorloc"
        },
        "external_check": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "External Check"
        },
        "external_check_command": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-display-name": "External Check Command"
        },
        "external_check_path": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-display-name": "External Check Path"
        },
        "force_persist": {
          "description": "This field is deprecated in favor of force_persist_list, and will be removed in a future release",
          "type": "object",
          "required": [
            "cond",
            "cond_test"
          ],
          "properties": {
            "cond": {
              "type": "string",
              "enum": [
                "if",
                "unless"
              ],
              "x-display-name": "Condition"
            },
            "cond_test": {
              "type": "string",
              "x-dependency": {
                "cond": {
                  "required": true
                }
              },
              "x-display-name": "Condition Test"
            }
          },
          "x-deprecated": true,
          "x-go-name": "BackendForcePersist"
        },
        "force_persist_list": {
          "type": "array",
          "items": {
            "type": "object",
            "required": [
              "cond",
              "cond_test"
            ],
            "properties": {
              "cond": {
                "type": "string",
                "enum": [
                  "if",
                  "unless"
                ],
                "x-display-name": "Condition"
              },
              "cond_test": {
                "type": "string",
                "x-dependency": {
                  "cond": {
                    "required": true
                  }
                },
                "x-display-name": "Condition Test"
              }
            },
            "x-go-name": "ForcePersist"
          },
          "x-go-name": "ForcePersistList",
          "x-omitempty": true
        },
        "forwardfor": {
          "x-dependency": {
            "mode": {
              "value": "http"
            }
          },
          "$ref": "#/definitions/forwardfor"
        },
        "from": {
          "type": "string",
          "pattern": "^[A-Za-z0-9-_.:]+$"
        },
        "fullconn": {
          "type": "integer",
          "x-nullable": true
        },
        "guid": {
          "type": "string",
          "pattern": "^[A-Za-z0-9-_.:]+$"
        },
        "h1_case_adjust_bogus_server": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-dependency": {
            "mode": {
              "value": "http"
            }
          },
          "x-display-name": "H1 Adjust Bogus Server"
        },
        "hash_balance_factor": {
          "type": "integer",
          "x-nullable": true
        },
        "hash_type": {
          "$ref": "#/definitions/hash_type"
        },
        "http-buffer-request": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-dependency": {
            "mode": {
              "value": "http"
            }
          },
          "x-display-name": "HTTP bufferrequest"
        },
        "http-no-delay": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-dependency": {
            "mode": {
              "value": "http"
            }
          },
          "x-display-name": "HTTP low interactive delays"
        },
        "http-use-htx": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-dependency": {
            "mode": {
              "value": "http"
            }
          }
        },
        "http_connection_mode": {
          "type": "string",
          "enum": [
            "httpclose",
            "http-server-close",
            "http-keep-alive"
          ],
          "x-dependency": {
            "mode": {
              "value": "http"
            }
          }
        },
        "http_keep_alive_timeout": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-dependency": {
            "mode": {
              "value": "http"
            }
          },
          "x-duration": true,
          "x-nullable": true
        },
        "http_pretend_keepalive": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-dependency": {
            "mode": {
              "value": "http"
            }
          }
        },
        "http_proxy": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-dependency": {
            "mode": {
              "value": "http"
            }
          },
          "x-display-name": "HTTP proxy mode"
        },
        "http_request_timeout": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-dependency": {
            "mode": {
              "value": "http"
            }
          },
          "x-duration": true,
          "x-nullable": true
        },
        "http_restrict_req_hdr_names": {
          "type": "string",
          "enum": [
            "preserve",
            "delete",
            "reject"
          ],
          "x-display-name": "Restrict HTTP Request Header Names"
        },
        "http_reuse": {
          "type": "string",
          "enum": [
            "aggressive",
            "always",
            "never",
            "safe"
          ],
          "x-dependency": {
            "mode": {
              "value": "http"
            }
          }
        },
        "http_send_name_header": {
          "type": "string",
          "x-display-name": "The header string to use to send the server name",
          "x-nullable": true
        },
        "httpchk_params": {
          "x-dependency": {
            "adv_check": {
              "value": "httpchk"
            },
            "mode": {
              "value": "http"
            }
          },
          "$ref": "#/definitions/httpchk_params"
        },
        "id": {
          "type": "integer",
          "x-nullable": true
        },
        "ignore_persist": {
          "description": "This field is deprecated in favor of ignore_persist_list, and will be removed in a future release",
          "type": "object",
          "required": [
            "cond",
            "cond_test"
          ],
          "properties": {
            "cond": {
              "type": "string",
              "enum": [
                "if",
                "unless"
              ],
              "x-display-name": "Condition"
            },
            "cond_test": {
              "type": "string",
              "x-dependency": {
                "cond": {
                  "required": true
                }
              },
              "x-display-name": "Condition Test"
            }
          },
          "x-deprecated": true,
          "x-go-name": "BackendIgnorePersist"
        },
        "ignore_persist_list": {
          "type": "array",
          "items": {
            "type": "object",
            "required": [
              "cond",
              "cond_test"
            ],
            "properties": {
              "cond": {
                "type": "string",
                "enum": [
                  "if",
                  "unless"
                ],
                "x-display-name": "Condition"
              },
              "cond_test": {
                "type": "string",
                "x-dependency": {
                  "cond": {
                    "required": true
                  }
                },
                "x-display-name": "Condition Test"
              }
            },
            "x-go-name": "IgnorePersist"
          },
          "x-go-name": "IgnorePersistList",
          "x-omitempty": true
        },
        "independent_streams": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "Independent Streams"
        },
        "load_server_state_from_file": {
          "type": "string",
          "enum": [
            "global",
            "local",
            "none"
          ]
        },
        "log_health_checks": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "Log Health Checks"
        },
        "log_tag": {
          "type": "string",
          "pattern": "^[^\\s]+$"
        },
        "max_keep_alive_queue": {
          "type": "integer",
          "x-display-name": "Maximum keep alive queue",
          "x-nullable": true
        },
        "mode": {
          "type": "string",
          "enum": [
            "http",
            "tcp",
            "log"
          ]
        },
        "mysql_check_params": {
          "x-dependency": {
            "adv_check": {
              "value": "mysql-check"
            }
          },
          "$ref": "#/definitions/mysql_check_params"
        },
        "name": {
          "type": "string",
          "pattern": "^[A-Za-z0-9-_.:]+$",
          "x-nullable": false
        },
        "nolinger": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "Nolinger"
        },
        "originalto": {
          "$ref": "#/definitions/originalto"
        },
        "persist": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "Persist"
        },
        "persist_rule": {
          "$ref": "#/definitions/persist_rule"
        },
        "pgsql_check_params": {
          "x-dependency": {
            "adv_check": {
              "value": "pgsql-check"
            }
          },
          "$ref": "#/definitions/pgsql_check_params"
        },
        "prefer_last_server": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "Prefer Last Server"
        },
        "queue_timeout": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-duration": true,
          "x-nullable": true
        },
        "redispatch": {
          "$ref": "#/definitions/redispatch"
        },
        "retries": {
          "type": "integer",
          "x-nullable": true
        },
        "retry_on": {
          "type": "string",
          "x-display-name": "Retry on"
        },
        "server_fin_timeout": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-duration": true,
          "x-nullable": true
        },
        "server_state_file_name": {
          "type": "string",
          "x-display-name": "Server state file"
        },
        "server_timeout": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-duration": true,
          "x-nullable": true
        },
        "smtpchk_params": {
          "x-dependency": {
            "adv_check": {
              "value": "smtpchk"
            }
          },
          "$ref": "#/definitions/smtpchk_params"
        },
        "source": {
          "$ref": "#/definitions/source"
        },
        "splice_auto": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "Splice Auto"
        },
        "splice_request": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "Splice Request"
        },
        "splice_response": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "Splice Response"
        },
        "spop_check": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "Spop Check"
        },
        "srvtcpka": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-dependency": {
            "mode": {
              "value": "tcp"
            }
          },
          "x-display-name": "Server TCP Keep Alive"
        },
        "srvtcpka_cnt": {
          "type": "integer",
          "x-display-name": "Srvtcpka Cnt",
          "x-nullable": true
        },
        "srvtcpka_idle": {
          "type": "integer",
          "x-default-unit": "s",
          "x-display-name": "Srvtcpka Idle",
          "x-duration": true,
          "x-nullable": true
        },
        "srvtcpka_intvl": {
          "type": "integer",
          "x-default-unit": "s",
          "x-display-name": "Srvtcpka Intvl",
          "x-duration": true,
          "x-nullable": true
        },
        "stats_options": {
          "$ref": "#/definitions/stats_options"
        },
        "stick_table": {
          "$ref": "#/definitions/config_stick_table"
        },
        "tarpit_timeout": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-duration": true,
          "x-nullable": true
        },
        "tcp_smart_connect": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "Tcp Smart Connect"
        },
        "tcpka": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-dependency": {
            "mode": {
              "value": "tcp"
            }
          },
          "x-display-name": "TCP Keep Alive"
        },
        "transparent": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "Transparent"
        },
        "tunnel_timeout": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-duration": true,
          "x-nullable": true
        },
        "use_fcgi_app": {
          "type": "string",
          "x-display-name": "FastCGI application"
        }
      },
      "additionalProperties": false,
      "example": {
        "adv_check": "httpchk",
        "balance": {
          "algorithm": "roundrobin"
        },
        "forwardfor": {
          "enabled": "enabled"
        },
        "httpchk_params": {
          "method": "GET",
          "uri": "/check",
          "version": "HTTP/1.1"
        },
        "mode": "http",
        "name": "test_backend"
      }
    },
    "backend_switching_rule": {
      "description": "HAProxy backend switching rule configuration (corresponds to use_backend directive)",
      "type": "object",
      "title": "Backend Switching Rule",
      "required": [
        "name"
      ],
      "properties": {
        "cond": {
          "type": "string",
          "enum": [
            "if",
            "unless"
          ],
          "x-display-name": "Condition"
        },
        "cond_test": {
          "type": "string",
          "x-dependency": {
            "cond": {
              "required": true
            }
          },
          "x-display-name": "Condition Test",
          "x-dynamic-enum": {
            "freeFormat": true,
            "operation": "getACLs",
            "property": "acl_name"
          }
        },
        "name": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-display-name": "Backend Name",
          "x-dynamic-enum": {
            "operation": "getBackends",
            "property": "name"
          },
          "x-nullable": false
        }
      },
      "additionalProperties": false,
      "example": {
        "cond": "if",
        "cond_test": "{ req_ssl_sni -i www.example.com }",
        "index": 0,
        "name": "test_backend"
      }
    },
    "backend_switching_rules": {
      "description": "HAProxy backend switching rules array (corresponds to use_backend directives)",
      "type": "array",
      "title": "Backend Switching Rules Array",
      "items": {
        "$ref": "#/definitions/backend_switching_rule"
      }
    },
    "backends": {
      "description": "HAProxy backends array",
      "type": "array",
      "title": "Backends",
      "items": {
        "$ref": "#/definitions/backend"
      }
    },
    "balance": {
      "type": "object",
      "required": [
        "algorithm"
      ],
      "properties": {
        "algorithm": {
          "type": "string",
          "enum": [
            "first",
            "hash",
            "hdr",
            "leastconn",
            "random",
            "rdp-cookie",
            "roundrobin",
            "source",
            "static-rr",
            "uri",
            "url_param"
          ]
        },
        "hash_expression": {
          "type": "string",
          "x-dependency": {
            "algorithm": {
              "value": "hash"
            }
          },
          "x-display-name": "Hash Expression"
        },
        "hdr_name": {
          "type": "string",
          "x-dependency": {
            "algorithm": {
              "required": true,
              "value": "hdr"
            }
          },
          "x-display-name": "Header Name"
        },
        "hdr_use_domain_only": {
          "type": "boolean",
          "x-dependency": {
            "algorithm": {
              "value": "hdr"
            }
          },
          "x-display-name": "Header Use Domain Only"
        },
        "random_draws": {
          "type": "integer",
          "x-dependency": {
            "algorithm": {
              "value": "random"
            }
          },
          "x-display-name": "Random Draws",
          "x-nullable": false
        },
        "rdp_cookie_name": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "algorithm": {
              "value": "rdp-cookie"
            }
          },
          "x-display-name": "Rdp Cookie Name"
        },
        "uri_depth": {
          "type": "integer",
          "x-dependency": {
            "algorithm": {
              "value": "uri"
            }
          },
          "x-display-name": "Uri Depth"
        },
        "uri_len": {
          "type": "integer",
          "x-dependency": {
            "algorithm": {
              "value": "uri"
            }
          },
          "x-display-name": "Uri Len"
        },
        "uri_path_only": {
          "type": "boolean",
          "x-dependency": {
            "algorithm": {
              "value": "uri"
            }
          },
          "x-display-name": "Uri Path Only"
        },
        "uri_whole": {
          "type": "boolean",
          "x-dependency": {
            "algorithm": {
              "value": "uri"
            }
          },
          "x-display-name": "Uri Whole"
        },
        "url_param": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "algorithm": {
              "required": true,
              "value": "url_param"
            }
          },
          "x-display-name": "Url Param"
        },
        "url_param_check_post": {
          "type": "integer",
          "x-dependency": {
            "algorithm": {
              "value": "url_param"
            }
          },
          "x-display-name": "Url Param Check Post"
        },
        "url_param_max_wait": {
          "type": "integer",
          "x-dependency": {
            "algorithm": {
              "value": "url_param"
            }
          },
          "x-display-name": "Url Param Max Weight"
        }
      }
    },
    "bind": {
      "description": "HAProxy frontend bind configuration",
      "title": "Bind",
      "allOf": [
        {
          "$ref": "#/definitions/bind_params"
        },
        {
          "type": "object",
          "properties": {
            "address": {
              "type": "string",
              "pattern": "^[^\\s]+$",
              "example": "127.0.0.1"
            },
            "port": {
              "type": "integer",
              "maximum": 65535,
              "minimum": 1,
              "x-nullable": true,
              "example": 80
            },
            "port-range-end": {
              "type": "integer",
              "maximum": 65535,
              "minimum": 1,
              "x-nullable": true,
              "example": 81
            }
          },
          "additionalProperties": false
        }
      ]
    },
    "bind_params": {
      "type": "object",
      "properties": {
        "accept_netscaler_cip": {
          "type": "integer"
        },
        "accept_proxy": {
          "type": "boolean"
        },
        "allow_0rtt": {
          "type": "boolean"
        },
        "alpn": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-display-name": "ALPN Protocols"
        },
        "backlog": {
          "type": "string"
        },
        "ca_ignore_err": {
          "type": "string",
          "x-dependency": {
            "ssl": {
              "value": true
            }
          }
        },
        "ca_sign_file": {
          "type": "string",
          "x-dependency": {
            "ssl": {
              "value": true
            }
          }
        },
        "ca_sign_pass": {
          "type": "string",
          "x-dependency": {
            "ssl": {
              "value": true
            }
          },
          "x-display-name": "Passphrase"
        },
        "ca_verify_file": {
          "type": "string",
          "x-dependency": {
            "ca_file": {
              "value": true
            }
          }
        },
        "ciphers": {
          "type": "string",
          "x-dependency": {
            "ssl": {
              "value": true
            }
          }
        },
        "ciphersuites": {
          "type": "string",
          "x-dependency": {
            "ssl": {
              "value": true
            }
          }
        },
        "client_sigalgs": {
          "type": "string",
          "x-dependency": {
            "ssl": {
              "value": true
            }
          }
        },
        "crl_file": {
          "type": "string",
          "x-dependency": {
            "ssl": {
              "value": true
            }
          }
        },
        "crt_ignore_err": {
          "type": "string",
          "x-dependency": {
            "ssl": {
              "value": true
            }
          }
        },
        "crt_list": {
          "type": "string",
          "x-dependency": {
            "ssl": {
              "value": true
            }
          }
        },
        "curves": {
          "type": "string",
          "x-dependency": {
            "ssl": {
              "value": true
            }
          }
        },
        "default_crt_list": {
          "type": "array",
          "items": {
            "type": "string",
            "pattern": "^[^\\s]+$"
          },
          "x-omitempty": true
        },
        "defer_accept": {
          "type": "boolean"
        },
        "ecdhe": {
          "type": "string",
          "x-dependency": {
            "ssl": {
              "value": true
            }
          }
        },
        "expose_fd_listeners": {
          "type": "boolean"
        },
        "force_sslv3": {
          "type": "boolean"
        },
        "force_tlsv10": {
          "type": "boolean"
        },
        "force_tlsv11": {
          "type": "boolean"
        },
        "force_tlsv12": {
          "type": "boolean"
        },
        "force_tlsv13": {
          "type": "boolean"
        },
        "generate_certificates": {
          "type": "boolean",
          "x-dependency": {
            "ssl": {
              "value": true
            }
          }
        },
        "gid": {
          "type": "integer",
          "x-display-name": "Group ID"
        },
        "group": {
          "type": "string",
          "x-display-name": "Group name"
        },
        "guid_prefix": {
          "type": "string",
          "pattern": "^[A-Za-z0-9-_.:]+$"
        },
        "id": {
          "type": "string",
          "x-display-name": "Socket ID"
        },
        "interface": {
          "type": "string"
        },
        "level": {
          "type": "string",
          "enum": [
            "user",
            "operator",
            "admin"
          ],
          "example": "user"
        },
        "maxconn": {
          "type": "integer",
          "example": 1234
        },
        "mode": {
          "type": "string"
        },
        "mss": {
          "type": "string"
        },
        "name": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-nullable": false
        },
        "namespace": {
          "type": "string",
          "example": "app"
        },
        "nbconn": {
          "type": "integer",
          "x-display-name": "Number of connection"
        },
        "nice": {
          "type": "integer",
          "example": 1
        },
        "no_alpn": {
          "type": "boolean",
          "x-dependency": {
            "ssl": {
              "value": true
            }
          }
        },
        "no_ca_names": {
          "type": "boolean",
          "x-dependency": {
            "ssl": {
              "value": true
            }
          }
        },
        "no_sslv3": {
          "type": "boolean",
          "x-dependency": {
            "ssl": {
              "value": true
            }
          }
        },
        "no_tls_tickets": {
          "type": "boolean",
          "x-dependency": {
            "ssl": {
              "value": true
            }
          }
        },
        "no_tlsv10": {
          "type": "boolean",
          "x-dependency": {
            "ssl": {
              "value": true
            }
          }
        },
        "no_tlsv11": {
          "type": "boolean",
          "x-dependency": {
            "ssl": {
              "value": true
            }
          }
        },
        "no_tlsv12": {
          "type": "boolean",
          "x-dependency": {
            "ssl": {
              "value": true
            }
          }
        },
        "no_tlsv13": {
          "type": "boolean",
          "x-dependency": {
            "ssl": {
              "value": true
            }
          }
        },
        "npn": {
          "type": "string"
        },
        "prefer_client_ciphers": {
          "type": "boolean"
        },
        "proto": {
          "type": "string",
          "x-display-name": "Protocol name"
        },
        "quic-cc-algo": {
          "type": "string",
          "enum": [
            "cubic",
            "newreno"
          ]
        },
        "quic-force-retry": {
          "type": "boolean"
        },
        "quic-socket": {
          "type": "string",
          "enum": [
            "connection",
            "listener"
          ]
        },
        "severity_output": {
          "type": "string",
          "enum": [
            "none",
            "number",
            "string"
          ],
          "x-display-name": "Format",
          "example": "none"
        },
        "sigalgs": {
          "type": "string",
          "x-dependency": {
            "ssl": {
              "value": true
            }
          }
        },
        "ssl": {
          "type": "boolean"
        },
        "ssl_cafile": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "ssl": {
              "value": true
            }
          },
          "x-display-name": "SSL CA File"
        },
        "ssl_certificate": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "ssl": {
              "value": true
            }
          }
        },
        "ssl_max_ver": {
          "type": "string",
          "enum": [
            "SSLv3",
            "TLSv1.0",
            "TLSv1.1",
            "TLSv1.2",
            "TLSv1.3"
          ]
        },
        "ssl_min_ver": {
          "type": "string",
          "enum": [
            "SSLv3",
            "TLSv1.0",
            "TLSv1.1",
            "TLSv1.2",
            "TLSv1.3"
          ]
        },
        "strict_sni": {
          "type": "boolean",
          "x-dependency": {
            "ssl": {
              "value": true
            }
          }
        },
        "tcp_user_timeout": {
          "type": "integer",
          "x-nullable": true
        },
        "tfo": {
          "type": "boolean"
        },
        "thread": {
          "type": "string"
        },
        "tls_ticket_keys": {
          "type": "string"
        },
        "transparent": {
          "type": "boolean"
        },
        "uid": {
          "type": "string"
        },
        "user": {
          "type": "string"
        },
        "v4v6": {
          "type": "boolean"
        },
        "v6only": {
          "type": "boolean"
        },
        "verify": {
          "type": "string",
          "enum": [
            "none",
            "optional",
            "required"
          ],
          "x-dependency": {
            "ssl": {
              "value": "enabled"
            }
          },
          "example": "none"
        }
      },
      "additionalProperties": false
    },
    "binds": {
      "description": "HAProxy frontend binds array (corresponds to bind directives)",
      "type": "array",
      "title": "Binds",
      "items": {
        "$ref": "#/definitions/bind"
      }
    },
    "cache": {
      "description": "HAPRoxy Cache section",
      "type": "object",
      "title": "Cache",
      "required": [
        "name"
      ],
      "properties": {
        "max_age": {
          "type": "integer",
          "x-default-unit": "s",
          "x-duration": false
        },
        "max_object_size": {
          "type": "integer",
          "x-size": false
        },
        "max_secondary_entries": {
          "type": "integer"
        },
        "name": {
          "type": "string",
          "pattern": "^[A-Za-z0-9-_.:]+$"
        },
        "process_vary": {
          "type": "boolean",
          "x-nullable": true
        },
        "total_max_size": {
          "type": "integer",
          "maximum": 4095,
          "minimum": 1
        }
      }
    },
    "caches": {
      "description": "HAProxy caches array",
      "type": "array",
      "title": "Cache Sections",
      "items": {
        "$ref": "#/definitions/cache"
      }
    },
    "capture": {
      "type": "object",
      "title": "Declare Capture",
      "required": [
        "type",
        "length"
      ],
      "properties": {
        "length": {
          "type": "integer",
          "x-nullable": false
        },
        "type": {
          "type": "string",
          "enum": [
            "request",
            "response"
          ],
          "x-nullable": false
        }
      }
    },
    "captures": {
      "type": "array",
      "title": "Declare capture array",
      "items": {
        "$ref": "#/definitions/capture"
      }
    },
    "cluster_settings": {
      "description": "Settings related to a cluster.",
      "type": "object",
      "title": "Cluster Settings",
      "properties": {
        "bootstrap_key": {
          "type": "string"
        },
        "cluster": {
          "type": "object",
          "title": "Cluster controller information",
          "properties": {
            "address": {
              "type": "string",
              "pattern": "^[^\\s]+$",
              "readOnly": true
            },
            "api_base_path": {
              "type": "string",
              "readOnly": true
            },
            "cluster_id": {
              "type": "string"
            },
            "description": {
              "type": "string",
              "readOnly": true
            },
            "log_targets": {
              "type": "array",
              "items": {
                "type": "object",
                "required": [
                  "address",
                  "port",
                  "protocol"
                ],
                "properties": {
                  "address": {
                    "type": "string"
                  },
                  "log_format": {
                    "type": "string"
                  },
                  "port": {
                    "type": "integer",
                    "maximum": 65535,
                    "minimum": 1
                  },
                  "protocol": {
                    "type": "string",
                    "enum": [
                      "tcp",
                      "udp"
                    ]
                  }
                },
                "x-go-name": "ClusterLogTarget"
              },
              "x-go-name": "ClusterLogTargets",
              "x-omitempty": true
            },
            "name": {
              "type": "string",
              "readOnly": true
            },
            "port": {
              "type": "integer",
              "maximum": 65535,
              "minimum": 1,
              "x-nullable": true,
              "readOnly": true
            }
          }
        },
        "mode": {
          "type": "string",
          "enum": [
            "single",
            "cluster"
          ]
        },
        "status": {
          "type": "string",
          "enum": [
            "active",
            "unreachable",
            "waiting_approval"
          ],
          "readOnly": true
        }
      }
    },
    "compression": {
      "type": "object",
      "properties": {
        "algo-req": {
          "type": "string",
          "enum": [
            "identity",
            "gzip",
            "deflate",
            "raw-deflate"
          ],
          "x-omitempty": true
        },
        "algorithms": {
          "type": "array",
          "items": {
            "type": "string",
            "enum": [
              "identity",
              "gzip",
              "deflate",
              "raw-deflate"
            ]
          },
          "x-omitempty": true
        },
        "algos-res": {
          "type": "array",
          "items": {
            "type": "string",
            "enum": [
              "identity",
              "gzip",
              "deflate",
              "raw-deflate"
            ]
          },
          "x-omitempty": true
        },
        "direction": {
          "type": "string",
          "enum": [
            "request",
            "response",
            "both"
          ],
          "x-omitempty": true
        },
        "offload": {
          "type": "boolean"
        },
        "types": {
          "type": "array",
          "items": {
            "type": "string"
          },
          "x-omitempty": true
        },
        "types-req": {
          "type": "array",
          "items": {
            "type": "string"
          },
          "x-omitempty": true
        },
        "types-res": {
          "type": "array",
          "items": {
            "type": "string"
          },
          "x-omitempty": true
        }
      }
    },
    "config_stick_table": {
      "type": "object",
      "properties": {
        "expire": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-duration": true,
          "x-nullable": true
        },
        "keylen": {
          "type": "integer",
          "x-display-name": "Key Length",
          "x-nullable": true
        },
        "nopurge": {
          "type": "boolean",
          "x-display-name": "No Purge"
        },
        "peers": {
          "type": "string",
          "pattern": "^[^\\s]+$"
        },
        "size": {
          "type": "integer",
          "x-nullable": true,
          "x-size": true
        },
        "srvkey": {
          "type": "string",
          "enum": [
            "addr",
            "name"
          ],
          "x-nullable": true
        },
        "store": {
          "type": "string",
          "pattern": "^[^\\s]+$"
        },
        "type": {
          "type": "string",
          "enum": [
            "ip",
            "ipv6",
            "integer",
            "string",
            "binary"
          ]
        },
        "write_to": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-nullable": true
        }
      }
    },
    "consul": {
      "description": "Consul server configuration",
      "type": "object",
      "title": "Consul server",
      "required": [
        "address",
        "port",
        "enabled",
        "retry_timeout"
      ],
      "properties": {
        "address": {
          "type": "string",
          "pattern": "^[^\\s]+$"
        },
        "defaults": {
          "description": "Name of the defaults section to be used in backends created by this service",
          "type": "string"
        },
        "description": {
          "type": "string"
        },
        "enabled": {
          "type": "boolean"
        },
        "health_check_policy": {
          "description": "Defines the health check conditions required for each node to be considered valid for the service.\n  none: all nodes are considered valid\n  any: a node is considered valid if any one health check is 'passing'\n  all: a node is considered valid if all health checks are 'passing'\n  min: a node is considered valid if the number of 'passing' checks is greater or equal to the 'health_check_policy_min' value.\n    If the node has less health checks configured then 'health_check_policy_min' it is considered invalid.",
          "type": "string",
          "default": "none",
          "enum": [
            "none",
            "any",
            "all",
            "min"
          ]
        },
        "health_check_policy_min": {
          "type": "integer",
          "x-dependency": {
            "health_check_policy": {
              "value": "min"
            }
          }
        },
        "id": {
          "description": "Auto generated ID.",
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-nullable": true
        },
        "mode": {
          "type": "string",
          "default": "http",
          "enum": [
            "http",
            "https"
          ]
        },
        "name": {
          "type": "string"
        },
        "namespace": {
          "type": "string"
        },
        "port": {
          "type": "integer",
          "maximum": 65535,
          "minimum": 1
        },
        "retry_timeout": {
          "description": "Duration in seconds in-between data pulling requests to the consul server",
          "type": "integer",
          "minimum": 1
        },
        "server_slots_base": {
          "type": "integer",
          "default": 10
        },
        "server_slots_growth_increment": {
          "type": "integer"
        },
        "server_slots_growth_type": {
          "type": "string",
          "default": "exponential",
          "enum": [
            "linear",
            "exponential"
          ]
        },
        "service_allowlist": {
          "type": "array",
          "items": {
            "type": "string",
            "pattern": "^[^\\s]+$"
          },
          "x-omitempty": true
        },
        "service_denylist": {
          "type": "array",
          "items": {
            "type": "string",
            "pattern": "^[^\\s]+$"
          },
          "x-omitempty": true
        },
        "service_name_regexp": {
          "description": "Regular expression used to filter services by name.",
          "type": "string"
        },
        "token": {
          "type": "string",
          "pattern": "^[^\\s]+$"
        }
      },
      "additionalProperties": false,
      "example": {
        "address": "127.0.0.1",
        "enabled": true,
        "id": "0",
        "port": 90,
        "retry_timeout": 10
      }
    },
    "consuls": {
      "description": "Consuls array",
      "type": "array",
      "title": "Consuls",
      "items": {
        "$ref": "#/definitions/consul"
      }
    },
    "cookie": {
      "type": "object",
      "required": [
        "name"
      ],
      "properties": {
        "attr": {
          "type": "array",
          "items": {
            "type": "object",
            "properties": {
              "value": {
                "type": "string",
                "pattern": "^[^\\s]+$"
              }
            },
            "x-go-name": "Attr"
          },
          "x-go-name": "Attrs",
          "x-omitempty": true
        },
        "domain": {
          "type": "array",
          "items": {
            "type": "object",
            "properties": {
              "value": {
                "type": "string",
                "pattern": "^[^\\s]+$"
              }
            },
            "x-go-name": "Domain"
          },
          "x-go-name": "Domains",
          "x-omitempty": true
        },
        "dynamic": {
          "type": "boolean"
        },
        "httponly": {
          "type": "boolean"
        },
        "indirect": {
          "type": "boolean"
        },
        "maxidle": {
          "type": "integer"
        },
        "maxlife": {
          "type": "integer"
        },
        "name": {
          "type": "string",
          "pattern": "^[^\\s]+$"
        },
        "nocache": {
          "type": "boolean"
        },
        "postonly": {
          "type": "boolean"
        },
        "preserve": {
          "type": "boolean"
        },
        "secure": {
          "type": "boolean"
        },
        "type": {
          "type": "string",
          "enum": [
            "rewrite",
            "insert",
            "prefix"
          ]
        }
      }
    },
    "crt_load": {
      "description": "Loads a certificate from a store with options",
      "type": "object",
      "title": "Certificate load action",
      "required": [
        "certificate"
      ],
      "properties": {
        "alias": {
          "description": "Certificate alias",
          "type": "string"
        },
        "certificate": {
          "description": "Certificate filename",
          "type": "string",
          "x-nullable": false
        },
        "issuer": {
          "description": "OCSP issuer filename",
          "type": "string"
        },
        "key": {
          "description": "Private key filename",
          "type": "string"
        },
        "ocsp": {
          "description": "OCSP response filename",
          "type": "string"
        },
        "ocsp_update": {
          "description": "Automatic OCSP response update",
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "sctl": {
          "description": "Signed Certificate Timestamp List filename",
          "type": "string"
        }
      }
    },
    "crt_loads": {
      "description": "List of certificates to load from a Certificate Store",
      "type": "array",
      "items": {
        "$ref": "#/definitions/crt_load"
      },
      "x-omitempty": true
    },
    "crt_store": {
      "description": "Storage mechanism to load and store certificates used in the configuration",
      "type": "object",
      "title": "Certificate Store",
      "required": [
        "name"
      ],
      "properties": {
        "crt_base": {
          "description": "Default directory to fetch SSL certificates from",
          "type": "string"
        },
        "key_base": {
          "description": "Default directory to fetch SSL private keys from",
          "type": "string"
        },
        "loads": {
          "$ref": "#/definitions/crt_loads"
        },
        "name": {
          "type": "string",
          "pattern": "^[A-Za-z0-9-_]+$",
          "x-nullable": false
        }
      },
      "additionalProperties": false
    },
    "crt_stores": {
      "description": "List of Certificate Stores",
      "type": "array",
      "items": {
        "$ref": "#/definitions/crt_store"
      }
    },
    "debug_options": {
      "type": "object",
      "properties": {
        "anonkey": {
          "type": "integer",
          "maximum": 4294967295,
          "x-nullable": true
        },
        "quiet": {
          "type": "boolean"
        },
        "zero_warning": {
          "type": "boolean"
        }
      }
    },
    "default_bind": {
      "description": "HAProxy default bind configuration",
      "title": "Default Bind",
      "allOf": [
        {
          "$ref": "#/definitions/bind_params"
        }
      ]
    },
    "default_server": {
      "title": "Default Server",
      "allOf": [
        {
          "$ref": "#/definitions/server_params"
        }
      ]
    },
    "defaults": {
      "description": "Defaults with all it's children resources",
      "type": "object",
      "allOf": [
        {
          "$ref": "#/definitions/defaults_base"
        },
        {
          "type": "object",
          "properties": {
            "http_check_list": {
              "x-go-name": "HTTPCheckList",
              "$ref": "#/definitions/http_checks"
            },
            "http_error_rule_list": {
              "x-go-name": "HTTPErrorRuleList",
              "$ref": "#/definitions/http_error_rules"
            },
            "log_target_list": {
              "x-go-name": "LogTargetList",
              "$ref": "#/definitions/log_targets"
            },
            "tcp_check_rule_list": {
              "x-go-name": "TCPCheckRuleList",
              "$ref": "#/definitions/tcp_checks"
            }
          }
        }
      ],
      "x-go-name": "Defaults"
    },
    "defaults_base": {
      "description": "HAProxy defaults configuration",
      "type": "object",
      "title": "Defaults Base",
      "properties": {
        "abortonclose": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "accept_invalid_http_request": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "Accept Invalid HTTP Request"
        },
        "accept_invalid_http_response": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "Accept Invalid HTTP Response"
        },
        "adv_check": {
          "type": "string",
          "enum": [
            "httpchk",
            "ldap-check",
            "mysql-check",
            "pgsql-check",
            "redis-check",
            "smtpchk",
            "ssl-hello-chk",
            "tcp-check"
          ],
          "x-display-name": "Advanced Check"
        },
        "allbackups": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "All Backups"
        },
        "backlog": {
          "type": "integer",
          "x-display-name": "Backlog",
          "x-nullable": true
        },
        "balance": {
          "$ref": "#/definitions/balance"
        },
        "check_timeout": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-duration": true,
          "x-nullable": true
        },
        "checkcache": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "Checkcache"
        },
        "clflog": {
          "type": "boolean",
          "x-display-name": "CLF Log"
        },
        "client_fin_timeout": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-duration": true,
          "x-nullable": true
        },
        "client_timeout": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-duration": true,
          "x-nullable": true
        },
        "clitcpka": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "Client TCP Keep Alive"
        },
        "clitcpka_cnt": {
          "type": "integer",
          "x-display-name": "Clitcpka Cnt",
          "x-nullable": true
        },
        "clitcpka_idle": {
          "type": "integer",
          "x-default-unit": "s",
          "x-display-name": "Clitcpka Idle",
          "x-duration": true,
          "x-nullable": true
        },
        "clitcpka_intvl": {
          "type": "integer",
          "x-default-unit": "s",
          "x-display-name": "Clitcpka Intvl",
          "x-duration": true,
          "x-nullable": true
        },
        "compression": {
          "$ref": "#/definitions/compression"
        },
        "connect_timeout": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-duration": true,
          "x-nullable": true
        },
        "contstats": {
          "type": "string",
          "enum": [
            "enabled"
          ],
          "x-display-name": "Continuous Statistics"
        },
        "cookie": {
          "$ref": "#/definitions/cookie"
        },
        "default_backend": {
          "type": "string",
          "pattern": "^[A-Za-z0-9-_.:]+$",
          "x-dynamic-enum": {
            "operation": "getBackends",
            "property": "name"
          }
        },
        "default_server": {
          "$ref": "#/definitions/default_server"
        },
        "disable_h2_upgrade": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "Disable HTTP/2 Upgrade"
        },
        "disabled": {
          "type": "boolean"
        },
        "dontlog_normal": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "Dontlog Normal"
        },
        "dontlognull": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "Don't Log Null"
        },
        "dynamic_cookie_key": {
          "type": "string",
          "pattern": "^[^\\s]+$"
        },
        "email_alert": {
          "$ref": "#/definitions/email_alert"
        },
        "enabled": {
          "type": "boolean"
        },
        "error_files": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/errorfile"
          },
          "x-go-name": "ErrorFiles",
          "x-omitempty": true
        },
        "error_log_format": {
          "type": "string"
        },
        "errorfiles_from_http_errors": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/errorfiles"
          },
          "x-go-name": "ErrorFilesFromHTTPErrors",
          "x-omitempty": true
        },
        "errorloc302": {
          "$ref": "#/definitions/errorloc"
        },
        "errorloc303": {
          "$ref": "#/definitions/errorloc"
        },
        "external_check": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "External Check"
        },
        "external_check_command": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-display-name": "External Check Command"
        },
        "external_check_path": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-display-name": "External Check Path"
        },
        "forwardfor": {
          "$ref": "#/definitions/forwardfor"
        },
        "from": {
          "type": "string",
          "pattern": "^[A-Za-z0-9-_.:]+$"
        },
        "fullconn": {
          "type": "integer",
          "x-nullable": true
        },
        "h1_case_adjust_bogus_client": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "H1 Adjust Bogus Client"
        },
        "h1_case_adjust_bogus_server": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "H1 Adjust Bogus Server"
        },
        "hash_balance_factor": {
          "type": "integer",
          "x-nullable": true
        },
        "hash_type": {
          "$ref": "#/definitions/hash_type"
        },
        "http-buffer-request": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "HTTP bufferrequest"
        },
        "http-use-htx": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "HTTP Use HTX"
        },
        "http_connection_mode": {
          "type": "string",
          "enum": [
            "httpclose",
            "http-server-close",
            "http-keep-alive"
          ]
        },
        "http_ignore_probes": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "HTTP Ignore Probes"
        },
        "http_keep_alive_timeout": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-duration": true,
          "x-nullable": true
        },
        "http_no_delay": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "HTTP No Delay"
        },
        "http_pretend_keepalive": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "http_request_timeout": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-duration": true,
          "x-nullable": true
        },
        "http_restrict_req_hdr_names": {
          "type": "string",
          "enum": [
            "preserve",
            "delete",
            "reject"
          ],
          "x-display-name": "Restrict HTTP Request Header Names"
        },
        "http_reuse": {
          "type": "string",
          "enum": [
            "aggressive",
            "always",
            "never",
            "safe"
          ]
        },
        "http_send_name_header": {
          "type": "string",
          "x-display-name": "Add the server name to a request",
          "x-nullable": true
        },
        "http_use_proxy_header": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "HTTP Use Proxy Header"
        },
        "httpchk_params": {
          "x-dependency": {
            "adv_check": {
              "value": "httpchk"
            }
          },
          "$ref": "#/definitions/httpchk_params"
        },
        "httplog": {
          "type": "boolean",
          "x-display-name": "HTTP Log"
        },
        "httpslog": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "Httpslog"
        },
        "idle_close_on_response": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "Idle Close On Response"
        },
        "independent_streams": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "Independent Streams"
        },
        "load_server_state_from_file": {
          "type": "string",
          "enum": [
            "global",
            "local",
            "none"
          ]
        },
        "log_format": {
          "type": "string"
        },
        "log_format_sd": {
          "type": "string",
          "x-display-name": "Log Format SD"
        },
        "log_health_checks": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "Log Health Checks"
        },
        "log_separate_errors": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "log_tag": {
          "type": "string",
          "pattern": "^[^\\s]+$"
        },
        "logasap": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "Log ASAP"
        },
        "max_keep_alive_queue": {
          "type": "integer",
          "x-display-name": "Maximum server queue size for maintaining keep-alive connections",
          "x-nullable": true
        },
        "maxconn": {
          "type": "integer",
          "x-display-name": "Max Connections",
          "x-nullable": true
        },
        "mode": {
          "type": "string",
          "enum": [
            "tcp",
            "http",
            "log"
          ]
        },
        "monitor_uri": {
          "$ref": "#/definitions/monitor_uri"
        },
        "mysql_check_params": {
          "x-dependency": {
            "adv_check": {
              "value": "mysql-check"
            }
          },
          "$ref": "#/definitions/mysql_check_params"
        },
        "name": {
          "type": "string",
          "pattern": "^[A-Za-z0-9-_.:]+$"
        },
        "nolinger": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "Nolinger"
        },
        "originalto": {
          "$ref": "#/definitions/originalto"
        },
        "persist": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "Persist"
        },
        "persist_rule": {
          "$ref": "#/definitions/persist_rule"
        },
        "pgsql_check_params": {
          "x-dependency": {
            "adv_check": {
              "value": "pgsql-check"
            }
          },
          "$ref": "#/definitions/pgsql_check_params"
        },
        "prefer_last_server": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "Prefer Last Server"
        },
        "queue_timeout": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-duration": true,
          "x-nullable": true
        },
        "redispatch": {
          "$ref": "#/definitions/redispatch"
        },
        "retries": {
          "type": "integer",
          "x-nullable": true
        },
        "retry_on": {
          "type": "string",
          "x-display-name": "Specify when to attempt to automatically retry a failed request"
        },
        "server_fin_timeout": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-duration": true,
          "x-nullable": true
        },
        "server_timeout": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-duration": true,
          "x-nullable": true
        },
        "smtpchk_params": {
          "x-dependency": {
            "adv_check": {
              "value": "smtpchk"
            }
          },
          "$ref": "#/definitions/smtpchk_params"
        },
        "socket_stats": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "Socket Stats"
        },
        "source": {
          "$ref": "#/definitions/source"
        },
        "splice_auto": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "Splice Auto"
        },
        "splice_request": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "Splice Request"
        },
        "splice_response": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "Splice Response"
        },
        "srvtcpka": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "Server TCP Keep Alive"
        },
        "srvtcpka_cnt": {
          "type": "integer",
          "x-display-name": "Srvtcpka Cnt",
          "x-nullable": true
        },
        "srvtcpka_idle": {
          "type": "integer",
          "x-default-unit": "s",
          "x-display-name": "Srvtcpka Idle",
          "x-duration": true,
          "x-nullable": true
        },
        "srvtcpka_intvl": {
          "type": "integer",
          "x-default-unit": "s",
          "x-display-name": "Srvtcpka Intvl",
          "x-duration": true,
          "x-nullable": true
        },
        "stats_options": {
          "$ref": "#/definitions/stats_options"
        },
        "tarpit_timeout": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-duration": true,
          "x-nullable": true
        },
        "tcp_smart_accept": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "Tcp Smart Accept"
        },
        "tcp_smart_connect": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "Tcp Smart Connect"
        },
        "tcpka": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "TCP Keep Alive"
        },
        "tcplog": {
          "type": "boolean",
          "x-display-name": "TCP Log"
        },
        "transparent": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "Transparent"
        },
        "tunnel_timeout": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-duration": true,
          "x-nullable": true
        },
        "unique_id_format": {
          "type": "string",
          "x-display-name": "Unique ID format"
        },
        "unique_id_header": {
          "type": "string",
          "x-display-name": "Unique ID header"
        }
      },
      "additionalProperties": false
    },
    "defaults_sections": {
      "description": "HAProxy defaults sections array",
      "type": "array",
      "title": "Defaults Sections",
      "items": {
        "$ref": "#/definitions/defaults"
      }
    },
    "device_atlas_options": {
      "type": "object",
      "properties": {
        "json_file": {
          "type": "string",
          "x-display-name": "JSON file"
        },
        "log_level": {
          "type": "string",
          "x-display-name": "Log Level"
        },
        "properties_cookie": {
          "type": "string",
          "x-display-name": "Properties Cookie"
        },
        "separator": {
          "type": "string",
          "x-display-name": "Separator"
        }
      }
    },
    "dgram_bind": {
      "description": "HAProxy log forward dgram bind configuration",
      "type": "object",
      "title": "Dgram Bind",
      "properties": {
        "address": {
          "type": "string",
          "pattern": "^[^\\s]+$"
        },
        "interface": {
          "type": "string"
        },
        "name": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-nullable": false
        },
        "namespace": {
          "type": "string"
        },
        "port": {
          "type": "integer",
          "maximum": 65535,
          "minimum": 1,
          "x-nullable": true
        },
        "port-range-end": {
          "type": "integer",
          "maximum": 65535,
          "minimum": 1,
          "x-nullable": true
        },
        "transparent": {
          "type": "boolean"
        }
      }
    },
    "dgram_binds": {
      "description": "HAProxy dgram bind array",
      "type": "array",
      "title": "Dgram Bind",
      "items": {
        "$ref": "#/definitions/dgram_bind"
      }
    },
    "email_alert": {
      "description": "Send emails for important log messages.",
      "type": "object",
      "title": "Email Alert",
      "required": [
        "from",
        "mailers",
        "to"
      ],
      "properties": {
        "from": {
          "type": "string",
          "pattern": "^\\S+@\\S+$"
        },
        "level": {
          "type": "string",
          "enum": [
            "emerg",
            "alert",
            "crit",
            "err",
            "warning",
            "notice",
            "info",
            "debug"
          ]
        },
        "mailers": {
          "type": "string",
          "x-dynamic-enum": {
            "operation": "getMailersSections",
            "property": "name"
          }
        },
        "myhostname": {
          "type": "string"
        },
        "to": {
          "type": "string",
          "pattern": "^\\S+@\\S+$"
        }
      }
    },
    "email_alerts": {
      "description": "Email Alerts array (corresponds to email-alert directives)",
      "type": "array",
      "title": "Email Alerts Array",
      "items": {
        "$ref": "#/definitions/email_alert"
      }
    },
    "endpoint": {
      "description": "Endpoint definition",
      "type": "object",
      "title": "Endpoint",
      "properties": {
        "description": {
          "description": "Endpoint description",
          "type": "string"
        },
        "title": {
          "description": "Endpoint title",
          "type": "string"
        },
        "url": {
          "description": "Path to the endpoint",
          "type": "string"
        }
      }
    },
    "endpoints": {
      "description": "Collection of endpoints",
      "type": "array",
      "title": "Endpoints Array",
      "items": {
        "$ref": "#/definitions/endpoint"
      }
    },
    "environment_options": {
      "type": "object",
      "properties": {
        "presetenv": {
          "type": "array",
          "items": {
            "type": "object",
            "required": [
              "name",
              "value"
            ],
            "properties": {
              "name": {
                "type": "string",
                "x-display-name": "Name"
              },
              "value": {
                "type": "string",
                "x-display-name": "Value"
              }
            },
            "x-go-name": "PresetEnv"
          },
          "x-display-name": "Preset environment variables",
          "x-go-name": "PresetEnvs",
          "x-omitempty": true
        },
        "resetenv": {
          "type": "string",
          "x-display-name": "Remove all environment variables except the ones specified"
        },
        "setenv": {
          "type": "array",
          "items": {
            "type": "object",
            "required": [
              "name",
              "value"
            ],
            "properties": {
              "name": {
                "type": "string",
                "x-display-name": "Name"
              },
              "value": {
                "type": "string",
                "x-display-name": "Value"
              }
            },
            "x-go-name": "SetEnv"
          },
          "x-display-name": "Set environment variables",
          "x-go-name": "SetEnvs",
          "x-omitempty": true
        },
        "unsetenv": {
          "type": "string",
          "x-display-name": "Removes environment variables specified in arguments"
        }
      }
    },
    "error": {
      "description": "API Error",
      "type": "object",
      "title": "Error",
      "required": [
        "code",
        "message"
      ],
      "properties": {
        "code": {
          "type": "integer",
          "x-nullable": true
        },
        "message": {
          "type": "string",
          "x-nullable": true
        }
      },
      "additionalProperties": {
        "type": "string"
      }
    },
    "errorfile": {
      "type": "object",
      "properties": {
        "code": {
          "type": "integer",
          "enum": [
            200,
            400,
            401,
            403,
            404,
            405,
            407,
            408,
            410,
            413,
            425,
            429,
            500,
            501,
            502,
            503,
            504
          ]
        },
        "file": {
          "type": "string"
        }
      },
      "x-display-name": "Error File"
    },
    "errorfiles": {
      "type": "object",
      "properties": {
        "codes": {
          "type": "array",
          "items": {
            "type": "integer",
            "enum": [
              200,
              400,
              401,
              403,
              404,
              405,
              407,
              408,
              410,
              413,
              425,
              429,
              500,
              501,
              502,
              503,
              504
            ]
          },
          "x-omitempty": true
        },
        "name": {
          "type": "string"
        }
      }
    },
    "errorloc": {
      "type": "object",
      "required": [
        "url",
        "code"
      ],
      "properties": {
        "code": {
          "type": "integer",
          "enum": [
            200,
            400,
            401,
            403,
            404,
            405,
            407,
            408,
            410,
            413,
            425,
            429,
            500,
            501,
            502,
            503,
            504
          ]
        },
        "url": {
          "type": "string"
        }
      }
    },
    "fcgiApp": {
      "description": "App with all it's children resources",
      "type": "object",
      "allOf": [
        {
          "$ref": "#/definitions/fcgiAppBase"
        },
        {
          "type": "object",
          "properties": {
            "acl_list": {
              "x-go-name": "AclList",
              "$ref": "#/definitions/acls"
            }
          }
        }
      ],
      "x-go-name": "FCGIApp"
    },
    "fcgiAppBase": {
      "description": "HAProxy FastCGI application configuration",
      "type": "object",
      "title": "FCGI application base",
      "required": [
        "name",
        "docroot"
      ],
      "properties": {
        "docroot": {
          "description": "Defines the document root on the remote host. The parameter serves to build the default value of FastCGI parameters SCRIPT_FILENAME and PATH_TRANSLATED. It is a mandatory setting.",
          "type": "string"
        },
        "get_values": {
          "description": "Enables or disables the retrieval of variables related to connection management.",
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "index": {
          "description": "Defines the script name to append after a URI that ends with a slash (\"/\") to set the default value for the FastCGI parameter SCRIPT_NAME. It is an optional setting.",
          "type": "string"
        },
        "keep_conn": {
          "description": "Tells the FastCGI application whether or not to keep the connection open after it sends a response. If disabled, the FastCGI application closes the connection after responding to this request.",
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "log_stderrs": {
          "type": "array",
          "items": {
            "x-go-name": "FCGIAppLogStderr",
            "$ref": "#/definitions/fcgiLogStderr"
          },
          "x-omitempty": true
        },
        "max_reqs": {
          "description": "Defines the maximum number of concurrent requests this application can accept. If the FastCGI application retrieves the variable FCGI_MAX_REQS during connection establishment, it can override this option. Furthermore, if the application does not do multiplexing, it will ignore this option.",
          "type": "integer",
          "default": 1,
          "minimum": 1
        },
        "mpxs_conns": {
          "description": "Enables or disables the support of connection multiplexing. If the FastCGI application retrieves the variable FCGI_MPXS_CONNS during connection establishment, it can override this option.",
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "name": {
          "description": "Declares a FastCGI application",
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-nullable": false
        },
        "pass_headers": {
          "type": "array",
          "items": {
            "x-go-name": "FCGIAppLogPassHeader",
            "$ref": "#/definitions/fcgiPassHeader"
          },
          "x-omitempty": true
        },
        "path_info": {
          "description": "Defines a regular expression to extract the script-name and the path-info from the URI.\nThus, \u003cregex\u003e must have two captures: the first to capture the script name, and the second to capture the path- info.\nIf not defined, it does not perform matching on the URI, and does not fill the FastCGI parameters PATH_INFO and PATH_TRANSLATED.",
          "type": "string"
        },
        "set_params": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/fcgiSetParam"
          },
          "x-omitempty": true
        }
      }
    },
    "fcgiApps": {
      "type": "array",
      "items": {
        "$ref": "#/definitions/fcgiApp"
      }
    },
    "fcgiLogStderr": {
      "description": "Enables logging of STDERR messages that the FastCGI application reports.\nIt is an optional setting. By default, HAProxy Enterprise ignores STDERR messages.",
      "type": "object",
      "properties": {
        "address": {
          "type": "string"
        },
        "facility": {
          "type": "string",
          "title": "Facility"
        },
        "format": {
          "type": "string",
          "title": "Format"
        },
        "global": {
          "type": "boolean",
          "title": "Global"
        },
        "len": {
          "type": "integer",
          "title": "Length"
        },
        "level": {
          "type": "string",
          "title": "Level",
          "x-dependency": {
            "facility": {
              "required": true
            }
          }
        },
        "minlevel": {
          "type": "string",
          "title": "Minimum level",
          "x-dependency": {
            "facility": {
              "required": true
            }
          }
        },
        "sample": {
          "type": "object",
          "title": "Sample",
          "required": [
            "ranges",
            "size"
          ],
          "properties": {
            "ranges": {
              "type": "string",
              "title": "Range"
            },
            "size": {
              "type": "integer",
              "title": "Size"
            }
          }
        }
      }
    },
    "fcgiPassHeader": {
      "description": "Specifies the name of a request header to pass to the FastCGI application.\nOptionally, you can follow it with an ACL-based condition, in which case the FastCGI application evaluates it only if the condition is true.\nMost request headers are already available to the FastCGI application with the prefix \"HTTP\".\nThus, you only need this directive to pass headers that are purposefully omitted.\nCurrently, the headers \"Authorization\", \"Proxy-Authorization\", and hop-by-hop headers are omitted.\nNote that the headers \"Content-type\" and \"Content-length\" never pass to the FastCGI application because they are already converted into parameters.",
      "type": "object",
      "properties": {
        "cond": {
          "type": "string",
          "enum": [
            "if",
            "unless"
          ],
          "x-display-name": "Condition"
        },
        "cond_test": {
          "type": "string",
          "x-dependency": {
            "cond": {
              "required": true
            }
          },
          "x-display-name": "Condition Test"
        },
        "name": {
          "type": "string"
        }
      }
    },
    "fcgiSetParam": {
      "description": "Sets a FastCGI parameter to pass to this application.\nIts value, defined by \u003cformat\u003e can take a formatted string, the same as the log directive.\nOptionally, you can follow it with an ACL-based condition, in which case the FastCGI application evaluates it only if the condition is true.",
      "type": "object",
      "properties": {
        "cond": {
          "type": "string",
          "enum": [
            "if",
            "unless"
          ],
          "x-display-name": "Condition"
        },
        "cond_test": {
          "type": "string",
          "x-dependency": {
            "cond": {
              "required": true
            }
          },
          "x-display-name": "Condition Test"
        },
        "format": {
          "type": "string"
        },
        "name": {
          "type": "string"
        }
      }
    },
    "fifty_one_degrees_options": {
      "type": "object",
      "properties": {
        "cache_size": {
          "type": "integer",
          "x-display-name": "Cache Size"
        },
        "data_file": {
          "type": "string",
          "x-display-name": "Data File"
        },
        "property_name_list": {
          "type": "string",
          "x-display-name": "Name List"
        },
        "property_separator": {
          "type": "string",
          "x-display-name": "Property Separator"
        }
      }
    },
    "filter": {
      "description": "HAProxy filters",
      "type": "object",
      "title": "Filter",
      "required": [
        "type"
      ],
      "properties": {
        "app_name": {
          "description": "Name of the fcgi-app section this filter will use.",
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "type": {
              "required": true,
              "value": "fcgi-app"
            }
          }
        },
        "bandwidth_limit_name": {
          "description": "Filter name that will be used by 'set-bandwidth-limit' actions to reference a specific bandwidth limitation filter",
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "type": {
              "required": true,
              "value": [
                "bwlim-in",
                "bwlim-out"
              ]
            }
          }
        },
        "cache_name": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "type": {
              "required": true,
              "value": "cache"
            }
          }
        },
        "default_limit": {
          "description": "The max number of bytes that can be forwarded over the period.\nThe value must be specified for per-stream and shared bandwidth limitation filters.\nIt follows the HAProxy size format and is expressed in bytes.",
          "type": "integer",
          "x-dependency": {
            "type": {
              "required": true,
              "value": [
                "bwlim-in",
                "bwlim-out"
              ]
            }
          },
          "x-size": true
        },
        "default_period": {
          "description": "The default time period used to evaluate the bandwidth limitation rate.\nIt can be specified for per-stream bandwidth limitation filters only.\nIt follows the HAProxy time format and is expressed in milliseconds.",
          "type": "integer",
          "x-default-unit": "ms",
          "x-dependency": {
            "default_limit": {
              "required": true
            },
            "type": {
              "required": true,
              "value": [
                "bwlim-in",
                "bwlim-out"
              ]
            }
          },
          "x-duration": true
        },
        "key": {
          "description": "A sample expression rule.\nIt describes what elements will be analyzed, extracted, combined, and used to select which table entry to update the counters.\nIt must be specified for shared bandwidth limitation filters only.",
          "type": "string",
          "x-dependency": {
            "limit": {
              "required": true
            },
            "type": {
              "required": true,
              "value": [
                "bwlim-in",
                "bwlim-out"
              ]
            }
          }
        },
        "limit": {
          "description": "The max number of bytes that can be forwarded over the period.\nThe value must be specified for per-stream and shared bandwidth limitation filters.\nIt follows the HAProxy size format and is expressed in bytes.",
          "type": "integer",
          "x-dependency": {
            "type": {
              "required": true,
              "value": [
                "bwlim-in",
                "bwlim-out"
              ]
            }
          },
          "x-size": true
        },
        "min_size": {
          "description": "The optional minimum number of bytes forwarded at a time by a stream excluding the last packet that may be smaller.\nThis value can be specified for per-stream and shared bandwidth limitation filters.\nIt follows the HAProxy size format and is expressed in bytes.",
          "type": "integer",
          "x-dependency": {
            "type": {
              "required": true,
              "value": [
                "bwlim-in",
                "bwlim-out"
              ]
            }
          },
          "x-size": true
        },
        "spoe_config": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "type": {
              "required": true,
              "value": "spoe"
            }
          }
        },
        "spoe_engine": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "type": {
              "value": "spoe"
            }
          }
        },
        "table": {
          "description": "An optional table to be used instead of the default one, which is the stick-table declared in the current proxy.\nIt can be specified for shared bandwidth limitation filters only.",
          "type": "string",
          "x-dependency": {
            "limit": {
              "required": true
            },
            "type": {
              "required": true,
              "value": [
                "bwlim-in",
                "bwlim-out"
              ]
            }
          }
        },
        "trace_hexdump": {
          "type": "boolean",
          "x-dependency": {
            "type": {
              "value": "trace"
            }
          }
        },
        "trace_name": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "type": {
              "value": "trace"
            }
          }
        },
        "trace_rnd_forwarding": {
          "type": "boolean",
          "x-dependency": {
            "type": {
              "value": "trace"
            }
          },
          "x-display-name": "Trace Random Forwarding"
        },
        "trace_rnd_parsing": {
          "type": "boolean",
          "x-dependency": {
            "type": {
              "value": "trace"
            }
          },
          "x-display-name": "Trace Random Parsing"
        },
        "type": {
          "type": "string",
          "enum": [
            "bwlim-in",
            "bwlim-out",
            "cache",
            "compression",
            "fcgi-app",
            "spoe",
            "trace"
          ],
          "x-nullable": false
        }
      },
      "additionalProperties": false,
      "example": {
        "trace_name": "name",
        "trace_rnd_parsing": true,
        "type": "trace"
      }
    },
    "filters": {
      "description": "HAProxy filters array (corresponds to filter directive)",
      "type": "array",
      "title": "Filters Array",
      "items": {
        "$ref": "#/definitions/filter"
      }
    },
    "forwardfor": {
      "type": "object",
      "required": [
        "enabled"
      ],
      "properties": {
        "enabled": {
          "type": "string",
          "enum": [
            "enabled"
          ]
        },
        "except": {
          "type": "string",
          "pattern": "^[^\\s]+$"
        },
        "header": {
          "type": "string",
          "pattern": "^[^\\s]+$"
        },
        "ifnone": {
          "type": "boolean"
        }
      },
      "x-display-name": "ForwardFor"
    },
    "frontend": {
      "description": "Frontend with all it's children resources",
      "type": "object",
      "allOf": [
        {
          "$ref": "#/definitions/frontend_base"
        },
        {
          "type": "object",
          "properties": {
            "acl_list": {
              "x-go-name": "AclList",
              "$ref": "#/definitions/acls"
            },
            "backend_switching_rule_list": {
              "x-go-name": "BackendSwitchingRuleList",
              "$ref": "#/definitions/backend_switching_rules"
            },
            "binds": {
              "additionalProperties": {
                "$ref": "#/definitions/bind"
              }
            },
            "capture_list": {
              "x-go-name": "CaptureList",
              "$ref": "#/definitions/captures"
            },
            "filter_list": {
              "x-go-name": "FilterList",
              "$ref": "#/definitions/filters"
            },
            "http_after_response_rule_list": {
              "x-go-name": "HTTPAfterResponseRuleList",
              "$ref": "#/definitions/http_after_response_rules"
            },
            "http_error_rule_list": {
              "x-go-name": "HTTPErrorRuleList",
              "$ref": "#/definitions/http_error_rules"
            },
            "http_request_rule_list": {
              "x-go-name": "HTTPRequestRuleList",
              "$ref": "#/definitions/http_request_rules"
            },
            "http_response_rule_list": {
              "x-go-name": "HTTPResponseRuleList",
              "$ref": "#/definitions/http_response_rules"
            },
            "log_target_list": {
              "x-go-name": "LogTargetList",
              "$ref": "#/definitions/log_targets"
            },
            "tcp_request_rule_list": {
              "x-go-name": "TCPRequestRuleList",
              "$ref": "#/definitions/tcp_request_rules"
            }
          }
        }
      ],
      "x-go-name": "Frontend"
    },
    "frontend_base": {
      "description": "HAProxy frontend configuration",
      "type": "object",
      "title": "Frontend Base",
      "required": [
        "name"
      ],
      "properties": {
        "accept_invalid_http_request": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "Accept Invalid HTTP Request"
        },
        "backlog": {
          "type": "integer",
          "x-display-name": "Backlog",
          "x-nullable": true
        },
        "clflog": {
          "type": "boolean",
          "x-dependency": {
            "mode": {
              "value": "http"
            }
          },
          "x-display-name": "CLF Log"
        },
        "client_fin_timeout": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-duration": true,
          "x-nullable": true
        },
        "client_timeout": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-duration": true,
          "x-nullable": true
        },
        "clitcpka": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-dependency": {
            "mode": {
              "value": "tcp"
            }
          },
          "x-display-name": "Client TCP Keep Alive"
        },
        "clitcpka_cnt": {
          "type": "integer",
          "x-display-name": "Clitcpka Cnt",
          "x-nullable": true
        },
        "clitcpka_idle": {
          "type": "integer",
          "x-default-unit": "s",
          "x-display-name": "Clitcpka Idle",
          "x-duration": true,
          "x-nullable": true
        },
        "clitcpka_intvl": {
          "type": "integer",
          "x-default-unit": "s",
          "x-display-name": "Clitcpka Intvl",
          "x-duration": true,
          "x-nullable": true
        },
        "compression": {
          "$ref": "#/definitions/compression"
        },
        "contstats": {
          "type": "string",
          "enum": [
            "enabled"
          ],
          "x-display-name": "Continuous Statistics"
        },
        "default_backend": {
          "type": "string",
          "pattern": "^[A-Za-z0-9-_.:]+$",
          "x-dynamic-enum": {
            "operation": "getBackends",
            "property": "name"
          }
        },
        "description": {
          "type": "string",
          "x-display-name": "Description"
        },
        "disable_h2_upgrade": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "Disable HTTP/2 Upgrade"
        },
        "disabled": {
          "type": "boolean"
        },
        "dontlog_normal": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "dontlognull": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "Don't Log Null"
        },
        "email_alert": {
          "$ref": "#/definitions/email_alert"
        },
        "enabled": {
          "type": "boolean"
        },
        "error_files": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/errorfile"
          },
          "x-go-name": "ErrorFiles",
          "x-omitempty": true
        },
        "error_log_format": {
          "type": "string"
        },
        "errorfiles_from_http_errors": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/errorfiles"
          },
          "x-go-name": "ErrorFilesFromHTTPErrors",
          "x-omitempty": true
        },
        "errorloc302": {
          "$ref": "#/definitions/errorloc"
        },
        "errorloc303": {
          "$ref": "#/definitions/errorloc"
        },
        "forwardfor": {
          "x-dependency": {
            "mode": {
              "value": "http"
            }
          },
          "$ref": "#/definitions/forwardfor"
        },
        "from": {
          "type": "string",
          "pattern": "^[A-Za-z0-9-_.:]+$"
        },
        "guid": {
          "type": "string",
          "pattern": "^[A-Za-z0-9-_.:]+$"
        },
        "h1_case_adjust_bogus_client": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "H1 Adjust Bogus Client"
        },
        "http-buffer-request": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "HTTP bufferrequest"
        },
        "http-use-htx": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-dependency": {
            "mode": {
              "value": "http"
            }
          },
          "x-display-name": "HTTP Use HTX"
        },
        "http_connection_mode": {
          "type": "string",
          "enum": [
            "httpclose",
            "http-server-close",
            "http-keep-alive"
          ],
          "x-dependency": {
            "mode": {
              "value": "http"
            }
          }
        },
        "http_ignore_probes": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "HTTP Ignore Probes"
        },
        "http_keep_alive_timeout": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-dependency": {
            "mode": {
              "value": "http"
            }
          },
          "x-duration": true,
          "x-nullable": true
        },
        "http_no_delay": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "HTTP No Delay"
        },
        "http_request_timeout": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-dependency": {
            "mode": {
              "value": "http"
            }
          },
          "x-duration": true,
          "x-nullable": true
        },
        "http_restrict_req_hdr_names": {
          "type": "string",
          "enum": [
            "preserve",
            "delete",
            "reject"
          ],
          "x-display-name": "Restrict HTTP Request Header Names"
        },
        "http_use_proxy_header": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "HTTP Use Proxy Header"
        },
        "httplog": {
          "type": "boolean",
          "x-dependency": {
            "mode": {
              "value": "http"
            }
          },
          "x-display-name": "HTTP Log"
        },
        "httpslog": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "Httpslog"
        },
        "id": {
          "type": "integer",
          "x-nullable": true
        },
        "idle_close_on_response": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "Idle Close On Response"
        },
        "independent_streams": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "Independent Streams"
        },
        "log_format": {
          "type": "string"
        },
        "log_format_sd": {
          "type": "string",
          "x-display-name": "Log Format SD"
        },
        "log_separate_errors": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "log_tag": {
          "type": "string",
          "pattern": "^[A-Za-z0-9-_.:]+$"
        },
        "logasap": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "Log ASAP"
        },
        "maxconn": {
          "type": "integer",
          "x-display-name": "Max Connections",
          "x-nullable": true
        },
        "mode": {
          "type": "string",
          "enum": [
            "http",
            "tcp"
          ]
        },
        "monitor_fail": {
          "$ref": "#/definitions/monitor_fail"
        },
        "monitor_uri": {
          "$ref": "#/definitions/monitor_uri"
        },
        "name": {
          "type": "string",
          "pattern": "^[A-Za-z0-9-_.:]+$",
          "x-nullable": false
        },
        "nolinger": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "Nolinger"
        },
        "originalto": {
          "$ref": "#/definitions/originalto"
        },
        "socket_stats": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "Socket Stats"
        },
        "splice_auto": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "Splice Auto"
        },
        "splice_request": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "Splice Request"
        },
        "splice_response": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "Splice Response"
        },
        "stats_options": {
          "$ref": "#/definitions/stats_options"
        },
        "stick_table": {
          "$ref": "#/definitions/config_stick_table"
        },
        "tarpit_timeout": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-duration": true,
          "x-nullable": true
        },
        "tcp_smart_accept": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "Tcp Smart Accept"
        },
        "tcpka": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-dependency": {
            "mode": {
              "value": "tcp"
            }
          },
          "x-display-name": "TCP Keep Alive"
        },
        "tcplog": {
          "type": "boolean",
          "x-dependency": {
            "mode": {
              "value": "tcp"
            }
          },
          "x-display-name": "TCP Log"
        },
        "unique_id_format": {
          "type": "string",
          "x-display-name": "Unique ID format"
        },
        "unique_id_header": {
          "type": "string",
          "x-display-name": "Unique ID header"
        }
      },
      "additionalProperties": false,
      "example": {
        "default_backend": "test_backend",
        "http_connection_mode": "http-keep-alive",
        "maxconn": 2000,
        "mode": "http",
        "name": "test_frontend"
      }
    },
    "frontends": {
      "description": "HAProxy frontends array",
      "type": "array",
      "title": "Frontends",
      "items": {
        "$ref": "#/definitions/frontend"
      }
    },
    "general_file": {
      "description": "General use file",
      "type": "object",
      "title": "General use file",
      "properties": {
        "description": {
          "type": "string"
        },
        "file": {
          "type": "string"
        },
        "id": {
          "type": "string"
        },
        "size": {
          "description": "File size in bytes.",
          "type": "integer",
          "x-nullable": true
        },
        "storage_name": {
          "type": "string"
        }
      }
    },
    "general_files": {
      "description": "Array of general use files",
      "type": "array",
      "title": "General Files Array",
      "items": {
        "$ref": "#/definitions/general_file"
      }
    },
    "global": {
      "description": "Frontend with all it's children resources",
      "type": "object",
      "allOf": [
        {
          "$ref": "#/definitions/global_base"
        },
        {
          "type": "object",
          "properties": {
            "log_target_list": {
              "x-go-name": "LogTargetList",
              "$ref": "#/definitions/log_targets"
            }
          }
        }
      ],
      "x-go-name": "Global"
    },
    "global_base": {
      "description": "HAProxy global configuration",
      "type": "object",
      "title": "Global Base",
      "properties": {
        "chroot": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-display-name": "Chroot"
        },
        "close_spread_time": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-duration": true,
          "x-nullable": true
        },
        "cluster_secret": {
          "type": "string",
          "x-display-name": "Cluster Secret"
        },
        "cpu_maps": {
          "type": "array",
          "items": {
            "type": "object",
            "required": [
              "process",
              "cpu_set"
            ],
            "properties": {
              "cpu_set": {
                "type": "string",
                "x-display-name": "CPU Set"
              },
              "process": {
                "type": "string",
                "x-display-name": "Process/Thread Set"
              }
            },
            "x-go-name": "CPUMap"
          },
          "x-display-name": "CPU Maps",
          "x-go-name": "CPUMaps",
          "x-omitempty": true
        },
        "daemon": {
          "type": "boolean"
        },
        "debug_options": {
          "$ref": "#/definitions/debug_options"
        },
        "default_path": {
          "type": "object",
          "required": [
            "type"
          ],
          "properties": {
            "path": {
              "type": "string",
              "pattern": "^[^\\s]+$",
              "x-dependency": {
                "type": {
                  "value": "origin"
                }
              }
            },
            "type": {
              "type": "string",
              "enum": [
                "current",
                "config",
                "parent",
                "origin"
              ],
              "x-nullable": false
            }
          },
          "x-go-name": "GlobalDefaultPath"
        },
        "description": {
          "type": "string",
          "x-display-name": "Text that describes the instance"
        },
        "device_atlas_options": {
          "$ref": "#/definitions/device_atlas_options"
        },
        "environment_options": {
          "$ref": "#/definitions/environment_options"
        },
        "expose_experimental_directives": {
          "type": "boolean"
        },
        "external_check": {
          "type": "boolean",
          "x-display-name": "External Check"
        },
        "fifty_one_degrees_options": {
          "$ref": "#/definitions/fifty_one_degrees_options"
        },
        "gid": {
          "type": "integer",
          "x-display-name": "GID"
        },
        "grace": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-display-name": "Defines a delay between SIGUSR1 and real soft-stop",
          "x-duration": true,
          "x-nullable": true
        },
        "group": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-display-name": "Group"
        },
        "h1_accept_payload_with_any_method": {
          "type": "boolean"
        },
        "h1_case_adjust": {
          "type": "array",
          "items": {
            "type": "object",
            "required": [
              "from",
              "to"
            ],
            "properties": {
              "from": {
                "type": "string"
              },
              "to": {
                "type": "string"
              }
            },
            "x-go-name": "H1CaseAdjust"
          },
          "x-go-name": "H1CaseAdjusts",
          "x-omitempty": true
        },
        "h1_case_adjust_file": {
          "type": "string"
        },
        "h1_do_not_close_on_insecure_transfer_encoding": {
          "type": "boolean"
        },
        "h2_workaround_bogus_websocket_clients": {
          "type": "boolean"
        },
        "hard_stop_after": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-display-name": "Hard Stop After",
          "x-duration": true,
          "x-nullable": true
        },
        "harden": {
          "type": "object",
          "properties": {
            "reject_privileged_ports": {
              "type": "object",
              "properties": {
                "quic": {
                  "type": "string",
                  "enum": [
                    "enabled",
                    "disabled"
                  ]
                },
                "tcp": {
                  "type": "string",
                  "enum": [
                    "enabled",
                    "disabled"
                  ]
                }
              },
              "x-go-name": "GlobalHardenRejectPrivilegedPorts"
            }
          },
          "x-go-name": "GlobalHarden"
        },
        "http_client_options": {
          "$ref": "#/definitions/http_client_options"
        },
        "http_err_codes": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/http_codes"
          },
          "x-display-name": "Replace, reduce or extend the list of status codes that define an error",
          "x-omitempty": true
        },
        "http_fail_codes": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/http_codes"
          },
          "x-display-name": "Replace, reduce or extend the list of status codes that define a failure",
          "x-omitempty": true
        },
        "insecure_fork_wanted": {
          "type": "boolean"
        },
        "insecure_setuid_wanted": {
          "type": "boolean"
        },
        "limited_quic": {
          "type": "boolean"
        },
        "localpeer": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-display-name": "Local instance's peer name."
        },
        "log_send_hostname": {
          "type": "object",
          "required": [
            "enabled"
          ],
          "properties": {
            "enabled": {
              "type": "string",
              "enum": [
                "enabled",
                "disabled"
              ]
            },
            "param": {
              "type": "string",
              "pattern": "^[^\\s]+$"
            }
          },
          "x-display-name": "Log Send Hostname",
          "x-go-name": "GlobalLogSendHostname"
        },
        "lua_options": {
          "$ref": "#/definitions/lua_options"
        },
        "master-worker": {
          "type": "boolean",
          "x-display-name": "Master Worker Mode"
        },
        "mworker_max_reloads": {
          "type": "integer",
          "x-display-name": "The number of times a worker can survive a reload",
          "x-nullable": true
        },
        "nbthread": {
          "type": "integer",
          "x-display-name": "Number of Threads"
        },
        "no_quic": {
          "type": "boolean",
          "x-display-name": "Disable the use of the QUIC protocol"
        },
        "node": {
          "type": "string"
        },
        "numa_cpu_mapping": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "ocsp_update_options": {
          "$ref": "#/definitions/ocsp_update_options"
        },
        "performance_options": {
          "$ref": "#/definitions/performance_options"
        },
        "pidfile": {
          "type": "string",
          "x-display-name": "PID File"
        },
        "pp2_never_send_local": {
          "type": "boolean"
        },
        "prealloc_fd": {
          "type": "boolean",
          "x-display-name": "Prealloc FD"
        },
        "runtime_apis": {
          "type": "array",
          "items": {
            "allOf": [
              {
                "$ref": "#/definitions/bind_params"
              },
              {
                "type": "object",
                "required": [
                  "address"
                ],
                "properties": {
                  "address": {
                    "type": "string",
                    "pattern": "^[^\\s]+$"
                  }
                }
              }
            ],
            "x-go-name": "RuntimeAPI"
          },
          "x-display-name": "Runtime APIs",
          "x-go-name": "RuntimeAPIs",
          "x-omitempty": true
        },
        "set_dumpable": {
          "type": "boolean"
        },
        "set_var": {
          "type": "array",
          "items": {
            "type": "object",
            "required": [
              "name",
              "expr"
            ],
            "properties": {
              "expr": {
                "type": "string",
                "x-display-name": "Expression"
              },
              "name": {
                "type": "string",
                "x-display-name": "Name"
              }
            },
            "x-go-name": "SetVar"
          },
          "x-display-name": "Set variables",
          "x-go-name": "SetVars",
          "x-omitempty": true
        },
        "set_var_fmt": {
          "type": "array",
          "items": {
            "type": "object",
            "required": [
              "name",
              "format"
            ],
            "properties": {
              "format": {
                "type": "string",
                "x-display-name": "Format"
              },
              "name": {
                "type": "string",
                "x-display-name": "Name"
              }
            },
            "x-go-name": "SetVarFmt"
          },
          "x-display-name": "Set variable formats",
          "x-go-name": "SetVarFmts",
          "x-omitempty": true
        },
        "setcap": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-display-name": "OS Capabilities",
          "x-omitempty": true
        },
        "ssl_options": {
          "$ref": "#/definitions/ssl_options"
        },
        "stats_file": {
          "type": "string"
        },
        "stats_maxconn": {
          "type": "integer",
          "x-display-name": "Stats maxconn",
          "x-nullable": true
        },
        "stats_timeout": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-duration": true,
          "x-nullable": true
        },
        "strict_limits": {
          "type": "boolean"
        },
        "thread_group_lines": {
          "type": "array",
          "items": {
            "type": "object",
            "required": [
              "group",
              "num_or_range"
            ],
            "properties": {
              "group": {
                "type": "string",
                "x-display-name": "Group"
              },
              "num_or_range": {
                "type": "string",
                "x-display-name": "Number or Range"
              }
            },
            "x-go-name": "ThreadGroup"
          },
          "x-display-name": "Thread Groups",
          "x-go-name": "ThreadGroupLines",
          "x-omitempty": true
        },
        "thread_groups": {
          "type": "integer",
          "x-display-name": "Number of Thread Groups"
        },
        "tune_buffer_options": {
          "$ref": "#/definitions/tune_buffer_options"
        },
        "tune_lua_options": {
          "$ref": "#/definitions/tune_lua_options"
        },
        "tune_options": {
          "$ref": "#/definitions/tune_options"
        },
        "tune_quic_options": {
          "$ref": "#/definitions/tune_quic_options"
        },
        "tune_ssl_options": {
          "$ref": "#/definitions/tune_ssl_options"
        },
        "tune_vars_options": {
          "$ref": "#/definitions/tune_vars_options"
        },
        "tune_zlib_options": {
          "$ref": "#/definitions/tune_zlib_options"
        },
        "uid": {
          "type": "integer",
          "x-display-name": "UID"
        },
        "ulimit_n": {
          "type": "integer"
        },
        "user": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-display-name": "User"
        },
        "wurfl_options": {
          "$ref": "#/definitions/wurfl_options"
        }
      },
      "additionalProperties": false
    },
    "group": {
      "description": "HAProxy userlist group",
      "type": "object",
      "title": "Group",
      "required": [
        "name"
      ],
      "properties": {
        "name": {
          "type": "string",
          "pattern": "^[A-Za-z0-9-_.:]+$",
          "x-nullable": false
        },
        "users": {
          "type": "string",
          "x-nullable": false
        }
      }
    },
    "groups": {
      "description": "HAProxy userlist groups array",
      "type": "array",
      "title": "Groups",
      "items": {
        "$ref": "#/definitions/group"
      }
    },
    "hash_type": {
      "type": "object",
      "properties": {
        "function": {
          "type": "string",
          "enum": [
            "sdbm",
            "djb2",
            "wt6",
            "crc32",
            "none"
          ]
        },
        "method": {
          "type": "string",
          "enum": [
            "map-based",
            "consistent"
          ]
        },
        "modifier": {
          "type": "string",
          "enum": [
            "avalanche"
          ]
        }
      }
    },
    "health": {
      "type": "object",
      "properties": {
        "haproxy": {
          "type": "string",
          "enum": [
            "up",
            "down",
            "unknown"
          ]
        }
      }
    },
    "http_after_response_rule": {
      "description": "HAProxy HTTP after response rule configuration (corresponds to http-after-response directives)",
      "type": "object",
      "title": "HTTP after Response Rule",
      "required": [
        "type"
      ],
      "properties": {
        "acl_file": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "type": {
              "required": true,
              "value": [
                "del-acl"
              ]
            }
          }
        },
        "acl_keyfmt": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "type": {
              "required": true,
              "value": [
                "del-acl"
              ]
            }
          },
          "x-display-name": "ACK Key Format"
        },
        "capture_id": {
          "type": "integer",
          "x-dependency": {
            "type": {
              "value": "capture"
            }
          },
          "x-display-name": "Capture SlotID",
          "x-nullable": true
        },
        "capture_len": {
          "type": "integer",
          "x-dependency": {
            "type": {
              "required": true,
              "value": "capture"
            }
          },
          "x-display-name": "Capture Len"
        },
        "capture_sample": {
          "type": "string",
          "pattern": "^(?:[A-Za-z]+\\(\"([A-Za-z\\s]+)\"\\)|[A-Za-z]+)",
          "x-dependency": {
            "type": {
              "value": "capture"
            }
          },
          "x-display-name": "Capture Sample"
        },
        "cond": {
          "type": "string",
          "enum": [
            "if",
            "unless"
          ],
          "x-display-name": "Condition"
        },
        "cond_test": {
          "type": "string",
          "x-dependency": {
            "cond": {
              "required": true
            }
          },
          "x-display-name": "Condition Test",
          "x-dynamic-enum": {
            "freeFormat": true,
            "operation": "getACLs",
            "property": "acl_name"
          }
        },
        "hdr_format": {
          "type": "string",
          "x-dependency": {
            "type": {
              "required": true,
              "value": [
                "replace-header",
                "replace-value",
                "set-header",
                "add-header"
              ]
            }
          },
          "x-display-name": "Header Format"
        },
        "hdr_match": {
          "type": "string",
          "x-dependency": {
            "type": {
              "required": true,
              "value": [
                "replace-header",
                "replace-value"
              ]
            }
          },
          "x-display-name": "Header Match"
        },
        "hdr_method": {
          "type": "string",
          "x-dependency": {
            "type": {
              "value": [
                "del-header"
              ]
            }
          },
          "x-display-name": "Header Match Method"
        },
        "hdr_name": {
          "type": "string",
          "x-dependency": {
            "type": {
              "required": true,
              "value": [
                "add-header",
                "replace-header",
                "del-header",
                "set-header",
                "replace-value"
              ]
            }
          },
          "x-display-name": "Header Name"
        },
        "log_level": {
          "type": "string",
          "enum": [
            "emerg",
            "alert",
            "crit",
            "err",
            "warning",
            "notice",
            "info",
            "debug",
            "silent"
          ],
          "x-dependency": {
            "type": {
              "required": true,
              "value": "set-log-level"
            }
          }
        },
        "map_file": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "type": {
              "required": true,
              "value": [
                "set-map",
                "del-map"
              ]
            }
          }
        },
        "map_keyfmt": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "type": {
              "required": true,
              "value": [
                "set-map",
                "del-map"
              ]
            }
          },
          "x-display-name": "Map Key Format"
        },
        "map_valuefmt": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "type": {
              "required": true,
              "value": "set-map"
            }
          },
          "x-display-name": "Map Value Format"
        },
        "sc_expr": {
          "type": "string",
          "x-dependency": {
            "type": {
              "required": true,
              "value": [
                "sc-add-gpc",
                "sc-set-gpt0"
              ]
            }
          },
          "x-display-name": "ScSet Expression Value"
        },
        "sc_id": {
          "type": "integer",
          "x-dependency": {
            "type": {
              "required": true,
              "value": [
                "sc-add-gpc",
                "sc-inc-gpc",
                "sc-inc-gpc0",
                "sc-inc-gpc1",
                "sc-set-gpt",
                "sc-set-gpt0"
              ]
            }
          }
        },
        "sc_idx": {
          "type": "integer",
          "x-dependency": {
            "type": {
              "required": true,
              "value": [
                "sc-add-gpc",
                "sc-inc-gpc",
                "sc-set-gpt"
              ]
            }
          }
        },
        "sc_int": {
          "type": "integer",
          "x-dependency": {
            "type": {
              "required": true,
              "value": [
                "sc-add-gpc",
                "sc-set-gpt0"
              ]
            }
          },
          "x-display-name": "ScSet Integer Value",
          "x-nullable": true
        },
        "status": {
          "type": "integer",
          "maximum": 999,
          "minimum": 100,
          "x-dependency": {
            "type": {
              "required": true,
              "value": "set-status"
            }
          },
          "x-nullable": false
        },
        "status_reason": {
          "type": "string",
          "x-dependency": {
            "type": {
              "value": "set-status"
            }
          }
        },
        "strict_mode": {
          "type": "string",
          "enum": [
            "on",
            "off"
          ],
          "x-dependency": {
            "type": {
              "required": true,
              "value": "strict-mode"
            }
          }
        },
        "type": {
          "type": "string",
          "enum": [
            "add-header",
            "allow",
            "capture",
            "del-acl",
            "del-header",
            "del-map",
            "replace-header",
            "replace-value",
            "sc-add-gpc",
            "sc-inc-gpc",
            "sc-inc-gpc0",
            "sc-inc-gpc1",
            "sc-set-gpt",
            "sc-set-gpt0",
            "set-header",
            "set-log-level",
            "set-map",
            "set-status",
            "set-var",
            "set-var-fmt",
            "strict-mode",
            "unset-var"
          ],
          "x-nullable": false
        },
        "var_expr": {
          "type": "string",
          "x-dependency": {
            "type": {
              "required": true,
              "value": "set-var"
            }
          },
          "x-display-name": "Var Expression"
        },
        "var_format": {
          "type": "string",
          "x-dependency": {
            "type": {
              "required": true,
              "value": "set-var-fmt"
            }
          },
          "x-display-name": "Var Format"
        },
        "var_name": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "type": {
              "required": true,
              "value": [
                "set-var",
                "set-var-fmt",
                "unset-var"
              ]
            }
          }
        },
        "var_scope": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "type": {
              "required": true,
              "value": [
                "set-var",
                "set-var-fmt",
                "unset-var"
              ]
            }
          }
        }
      },
      "additionalProperties": false,
      "example": {
        "cond": "unless",
        "cond_test": "{ src 192.168.0.0/16 }",
        "hdr_format": "max-age=31536000",
        "hdr_name": "Strict-Transport-Security",
        "type": "set-header"
      }
    },
    "http_after_response_rules": {
      "description": "HAProxy HTTP after response rules array (corresponds to http-after-response directives)",
      "type": "array",
      "title": "HTTP After Response Rules Array",
      "items": {
        "$ref": "#/definitions/http_after_response_rule"
      }
    },
    "http_check": {
      "type": "object",
      "title": "HTTP Check",
      "required": [
        "type"
      ],
      "properties": {
        "addr": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "type": {
              "value": "connect"
            }
          },
          "x-nullable": false
        },
        "alpn": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "type": {
              "value": "connect"
            }
          },
          "x-display-name": "ALPN Protocols"
        },
        "body": {
          "type": "string",
          "x-dependency": {
            "type": {
              "value": "send"
            }
          }
        },
        "body_log_format": {
          "type": "string",
          "x-dependency": {
            "type": {
              "value": "send"
            }
          }
        },
        "check_comment": {
          "type": "string",
          "x-dependency": {
            "type": {
              "value": [
                "comment",
                "connect",
                "expect",
                "send"
              ]
            }
          },
          "x-nullable": false
        },
        "default": {
          "type": "boolean",
          "x-dependency": {
            "type": {
              "value": "connect"
            }
          }
        },
        "error_status": {
          "type": "string",
          "enum": [
            "L7OKC",
            "L7RSP",
            "L7STS",
            "L6RSP",
            "L4CON"
          ],
          "x-dependency": {
            "type": {
              "value": "expect"
            }
          }
        },
        "exclamation_mark": {
          "type": "boolean",
          "x-dependency": {
            "type": {
              "value": "expect"
            }
          },
          "x-display-name": "Expect Exclamation Mark"
        },
        "headers": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/return_header"
          },
          "x-dependency": {
            "type": {
              "value": "send"
            }
          },
          "x-go-name": "CheckHeaders",
          "x-omitempty": true
        },
        "linger": {
          "type": "boolean",
          "x-dependency": {
            "type": {
              "value": "connect"
            }
          }
        },
        "match": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "enum": [
            "status",
            "rstatus",
            "hdr",
            "fhdr",
            "string",
            "rstring"
          ],
          "x-dependency": {
            "type": {
              "required": true,
              "value": "expect"
            }
          },
          "x-display-name": "Expect Match"
        },
        "method": {
          "type": "string",
          "enum": [
            "HEAD",
            "PUT",
            "POST",
            "GET",
            "TRACE",
            "PATCH",
            "DELETE",
            "CONNECT",
            "OPTIONS"
          ],
          "x-dependency": {
            "type": {
              "value": "send"
            }
          }
        },
        "min_recv": {
          "type": "integer",
          "x-dependency": {
            "type": {
              "value": "expect"
            }
          },
          "x-nullable": true
        },
        "ok_status": {
          "type": "string",
          "enum": [
            "L7OK",
            "L7OKC",
            "L6OK",
            "L4OK"
          ],
          "x-dependency": {
            "type": {
              "value": "expect"
            }
          }
        },
        "on_error": {
          "type": "string",
          "x-dependency": {
            "type": {
              "value": "expect"
            }
          }
        },
        "on_success": {
          "type": "string",
          "x-dependency": {
            "type": {
              "value": "expect"
            }
          }
        },
        "pattern": {
          "type": "string",
          "x-dependency": {
            "type": {
              "required": true,
              "value": "expect"
            }
          }
        },
        "port": {
          "type": "integer",
          "maximum": 65535,
          "minimum": 1,
          "x-dependency": {
            "type": {
              "value": "connect"
            }
          },
          "x-nullable": true
        },
        "port_string": {
          "type": "string",
          "x-dependency": {
            "type": {
              "value": "connect"
            }
          }
        },
        "proto": {
          "type": "string",
          "x-dependency": {
            "type": {
              "value": "connect"
            }
          },
          "x-nullable": false
        },
        "send_proxy": {
          "type": "boolean",
          "x-dependency": {
            "type": {
              "value": "connect"
            }
          }
        },
        "sni": {
          "type": "string",
          "x-dependency": {
            "type": {
              "value": "connect"
            }
          }
        },
        "ssl": {
          "type": "boolean",
          "x-dependency": {
            "type": {
              "value": "connect"
            }
          }
        },
        "status-code": {
          "type": "string",
          "x-dependency": {
            "type": {
              "value": "expect"
            }
          }
        },
        "tout_status": {
          "type": "string",
          "enum": [
            "L7TOUT",
            "L6TOUT",
            "L4TOUT"
          ],
          "x-dependency": {
            "type": {
              "value": "expect"
            }
          }
        },
        "type": {
          "type": "string",
          "enum": [
            "comment",
            "connect",
            "disable-on-404",
            "expect",
            "send",
            "send-state",
            "set-var",
            "set-var-fmt",
            "unset-var"
          ],
          "x-nullable": false
        },
        "uri": {
          "type": "string",
          "x-dependency": {
            "type": {
              "value": "send"
            }
          }
        },
        "uri_log_format": {
          "type": "string",
          "x-dependency": {
            "type": {
              "value": "send"
            }
          }
        },
        "var_expr": {
          "type": "string",
          "x-dependency": {
            "type": {
              "required": true,
              "value": [
                "set-var"
              ]
            }
          },
          "x-display-name": "Var Expression"
        },
        "var_format": {
          "type": "string",
          "x-dependency": {
            "type": {
              "required": true,
              "value": [
                "set-var-fmt"
              ]
            }
          },
          "x-display-name": "Var Format"
        },
        "var_name": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "type": {
              "required": true,
              "value": [
                "set-var",
                "set-var-fmt",
                "unset-var"
              ]
            }
          }
        },
        "var_scope": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "type": {
              "required": true,
              "value": [
                "set-var",
                "set-var-fmt",
                "unset-var"
              ]
            }
          }
        },
        "version": {
          "type": "string",
          "x-dependency": {
            "type": {
              "value": "send"
            }
          }
        },
        "via_socks4": {
          "type": "boolean",
          "x-dependency": {
            "type": {
              "value": "connect"
            }
          }
        }
      }
    },
    "http_checks": {
      "type": "array",
      "title": "HTTP Checks Array",
      "items": {
        "$ref": "#/definitions/http_check"
      }
    },
    "http_client_options": {
      "type": "object",
      "properties": {
        "resolvers_disabled": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "HTTP Client Resolvers Disabled"
        },
        "resolvers_id": {
          "type": "string",
          "x-display-name": "HTTP Client Resolvers ID"
        },
        "resolvers_prefer": {
          "type": "string",
          "enum": [
            "ipv4",
            "ipv6"
          ],
          "x-display-name": "HTTP Client Resolvers Prefer"
        },
        "retries": {
          "type": "integer",
          "x-display-name": "HTTP Client Retries"
        },
        "ssl_ca_file": {
          "type": "string",
          "x-display-name": "HTTP Client SSL CA File"
        },
        "ssl_verify": {
          "type": "string",
          "enum": [
            "",
            "none",
            "required"
          ],
          "x-display-name": "HTTP Client SSL Verify",
          "x-nullable": true
        },
        "timeout_connect": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-display-name": "HTTP Client Connect Timeout",
          "x-duration": true,
          "x-nullable": true
        }
      }
    },
    "http_codes": {
      "type": "object",
      "required": [
        "value"
      ],
      "properties": {
        "value": {
          "type": "string",
          "pattern": "^[a-zA-Z0-9 +\\-,]+$",
          "x-display-name": "Value"
        }
      },
      "x-go-name": "HTTPCodes"
    },
    "http_error_rule": {
      "description": "HAProxy HTTP error rule configuration (corresponds to http-error directives)",
      "type": "object",
      "title": "HTTP Error Rule",
      "required": [
        "type",
        "status"
      ],
      "properties": {
        "return_content": {
          "type": "string",
          "x-dependency": {
            "return_content_format": {
              "required": true,
              "value": [
                "errofile",
                "errorfiles",
                "file",
                "lf-file",
                "string",
                "lf-string"
              ]
            }
          }
        },
        "return_content_format": {
          "type": "string",
          "enum": [
            "default-errorfiles",
            "errorfile",
            "errorfiles",
            "file",
            "lf-file",
            "string",
            "lf-string"
          ],
          "x-dependency": {
            "type": {
              "value": "status"
            }
          }
        },
        "return_content_type": {
          "type": "string",
          "x-dependency": {
            "type": {
              "value": "status"
            }
          },
          "x-display-name": "Return content type",
          "x-nullable": true
        },
        "return_hdrs": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/return_header"
          },
          "x-dependency": {
            "return_content_format": {
              "value": [
                "file",
                "lf-file",
                "string",
                "lf-string"
              ]
            }
          },
          "x-go-name": "ReturnHeaders",
          "x-omitempty": true
        },
        "status": {
          "type": "integer",
          "enum": [
            200,
            400,
            401,
            403,
            404,
            405,
            407,
            408,
            410,
            413,
            425,
            429,
            500,
            501,
            502,
            503,
            504
          ],
          "x-dependency": {
            "type": {
              "required": true,
              "value": "status"
            }
          },
          "x-nullable": false
        },
        "type": {
          "type": "string",
          "enum": [
            "status"
          ],
          "x-nullable": false
        }
      },
      "additionalProperties": false,
      "example": {
        "index": 0,
        "status": 425,
        "type": "status"
      }
    },
    "http_error_rules": {
      "description": "HAProxy HTTP error rules array (corresponds to http-error directives)",
      "type": "array",
      "title": "HTTP Error Rules Array",
      "items": {
        "$ref": "#/definitions/http_error_rule"
      }
    },
    "http_errors_section": {
      "description": "A globally declared group of HTTP errors",
      "type": "object",
      "title": "http-errors section",
      "required": [
        "name",
        "error_files"
      ],
      "properties": {
        "error_files": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/errorfile"
          },
          "x-go-name": "ErrorFiles"
        },
        "name": {
          "type": "string",
          "pattern": "^[A-Za-z0-9-_]+$",
          "x-nullable": false
        }
      },
      "additionalProperties": false,
      "example": {
        "error_files": [
          {
            "code": 400,
            "name": "/etc/haproxy/errorfiles/site1/400.http"
          },
          {
            "code": 404,
            "name": "/etc/haproxy/errorfiles/site1/404.http"
          }
        ],
        "name": "website-1"
      }
    },
    "http_errors_sections": {
      "description": "An array of HAProxy http-error sections",
      "type": "array",
      "title": "http-errors sections",
      "items": {
        "$ref": "#/definitions/http_errors_section"
      }
    },
    "http_request_rule": {
      "description": "HAProxy HTTP request rule configuration (corresponds to http-request directives)",
      "type": "object",
      "title": "HTTP Request Rule",
      "required": [
        "type"
      ],
      "properties": {
        "acl_file": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "type": {
              "required": true,
              "value": [
                "add-acl",
                "del-acl"
              ]
            }
          },
          "x-display-name": "ACL File"
        },
        "acl_keyfmt": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "type": {
              "required": true,
              "value": [
                "add-acl",
                "del-acl"
              ]
            }
          },
          "x-display-name": "ACL Key Format"
        },
        "auth_realm": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "type": {
              "value": "auth"
            }
          },
          "x-display-name": "Authentication Realm"
        },
        "bandwidth_limit_limit": {
          "type": "string",
          "x-dependency": {
            "type": {
              "value": "set-bandwidth-limit"
            }
          },
          "x-display-name": "Standard HAProxy expression"
        },
        "bandwidth_limit_name": {
          "type": "string",
          "x-dependency": {
            "type": {
              "value": "set-bandwidth-limit"
            }
          },
          "x-display-name": "Bandwidth limit name"
        },
        "bandwidth_limit_period": {
          "type": "string",
          "x-dependency": {
            "type": {
              "value": "set-bandwidth-limit"
            }
          },
          "x-display-name": "Standard HAProxy expression"
        },
        "cache_name": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "type": {
              "required": true,
              "value": "cache-use"
            }
          },
          "x-display-name": "Cache Name"
        },
        "capture_id": {
          "type": "integer",
          "x-dependency": {
            "type": {
              "value": "capture"
            }
          },
          "x-display-name": "Capture SlotID",
          "x-nullable": true
        },
        "capture_len": {
          "type": "integer",
          "x-dependency": {
            "type": {
              "required": true,
              "value": "capture"
            }
          },
          "x-display-name": "Capture Len"
        },
        "capture_sample": {
          "type": "string",
          "pattern": "^(?:[A-Za-z]+\\(\"([A-Za-z\\s]+)\"\\)|[A-Za-z]+)",
          "x-dependency": {
            "type": {
              "value": "capture"
            }
          },
          "x-display-name": "Capture Sample"
        },
        "cond": {
          "type": "string",
          "enum": [
            "if",
            "unless"
          ],
          "x-display-name": "Condition"
        },
        "cond_test": {
          "type": "string",
          "x-dependency": {
            "cond": {
              "required": true
            }
          },
          "x-display-name": "Condition Test",
          "x-dynamic-enum": {
            "freeFormat": true,
            "operation": "getACLs",
            "property": "acl_name"
          }
        },
        "deny_status": {
          "type": "integer",
          "maximum": 599,
          "minimum": 200,
          "x-dependency": {
            "type": {
              "value": [
                "deny",
                "tarpit"
              ]
            }
          },
          "x-nullable": true
        },
        "expr": {
          "type": "string",
          "x-dependency": {
            "type": {
              "required": true,
              "value": [
                "do-resolve",
                "set-bc-mark",
                "set-bc-tos",
                "set-dst",
                "set-dst-port",
                "set-fc-mark",
                "set-fc-tos",
                "set-priority-class",
                "set-priority-offset",
                "set-src",
                "set-src-port"
              ]
            }
          },
          "x-display-name": "Standard HAProxy expression"
        },
        "hdr_format": {
          "type": "string",
          "x-dependency": {
            "type": {
              "required": true,
              "value": [
                "replace-header",
                "replace-value",
                "set-header",
                "add-header"
              ]
            }
          },
          "x-display-name": "Header Format"
        },
        "hdr_match": {
          "type": "string",
          "x-dependency": {
            "type": {
              "required": true,
              "value": [
                "replace-header",
                "replace-value"
              ]
            }
          },
          "x-display-name": "Header Match"
        },
        "hdr_method": {
          "type": "string",
          "x-dependency": {
            "type": {
              "value": [
                "del-header"
              ]
            }
          },
          "x-display-name": "Header Match Method"
        },
        "hdr_name": {
          "type": "string",
          "x-dependency": {
            "type": {
              "required": true,
              "value": [
                "add-header",
                "replace-header",
                "del-header",
                "set-header",
                "replace-value"
              ]
            }
          },
          "x-display-name": "Header Name"
        },
        "hint_format": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "type": {
              "required": true,
              "value": "early-hint"
            }
          },
          "x-display-name": "Hint Format"
        },
        "hint_name": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "type": {
              "required": true,
              "value": "early-hint"
            }
          },
          "x-display-name": "Hint Name"
        },
        "log_level": {
          "type": "string",
          "enum": [
            "emerg",
            "alert",
            "crit",
            "err",
            "warning",
            "notice",
            "info",
            "debug",
            "silent"
          ],
          "x-dependency": {
            "type": {
              "required": true,
              "value": "set-log-level"
            }
          }
        },
        "lua_action": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "type": {
              "required": true,
              "value": "lua"
            }
          }
        },
        "lua_params": {
          "type": "string",
          "x-dependency": {
            "type": {
              "value": "lua"
            }
          }
        },
        "map_file": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "type": {
              "required": true,
              "value": [
                "set-map",
                "del-map"
              ]
            }
          }
        },
        "map_keyfmt": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "type": {
              "required": true,
              "value": [
                "set-map",
                "del-map"
              ]
            }
          },
          "x-display-name": "Map Key Format"
        },
        "map_valuefmt": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "type": {
              "required": true,
              "value": "set-map"
            }
          },
          "x-display-name": "Map Value Format"
        },
        "mark_value": {
          "type": "string",
          "pattern": "^(0x[0-9A-Fa-f]+|[0-9]+)$",
          "x-dependency": {
            "type": {
              "required": true,
              "value": "set-mark"
            }
          },
          "x-display-name": "Mark Value"
        },
        "method_fmt": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "type": {
              "required": true,
              "value": "set-method"
            }
          }
        },
        "nice_value": {
          "type": "integer",
          "maximum": 1024,
          "minimum": -1024,
          "x-dependency": {
            "type": {
              "required": true,
              "value": "set-nice"
            }
          },
          "x-display-name": "Nice Value",
          "x-nullable": false
        },
        "normalizer": {
          "type": "string",
          "enum": [
            "fragment-encode",
            "fragment-strip",
            "path-merge-slashes",
            "path-strip-dot",
            "path-strip-dotdot",
            "percent-decode-unreserved",
            "percent-to-uppercase",
            "query-sort-by-name"
          ],
          "x-dependency": {
            "type": {
              "required": true,
              "value": "normalize-uri"
            }
          }
        },
        "normalizer_full": {
          "type": "boolean",
          "x-dependency": {
            "normalizer": {
              "value": "path-strip-dotdot"
            },
            "type": {
              "value": "normalize-uri"
            }
          }
        },
        "normalizer_strict": {
          "type": "boolean",
          "x-dependency": {
            "normalizer": {
              "value": [
                "percent-decode-unreserved",
                "percent-to-uppercase"
              ]
            },
            "type": {
              "value": "normalize-uri"
            }
          }
        },
        "path_fmt": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "type": {
              "required": true,
              "value": [
                "set-path",
                "set-pathq",
                "replace-path",
                "replace-pathq"
              ]
            }
          }
        },
        "path_match": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "type": {
              "required": true,
              "value": [
                "set-path",
                "set-pathq",
                "replace-path",
                "replace-pathq"
              ]
            }
          }
        },
        "protocol": {
          "type": "string",
          "enum": [
            "ipv4",
            "ipv6"
          ],
          "x-dependency": {
            "type": {
              "required": false,
              "value": "do-resolve"
            }
          },
          "x-display-name": "Protocol"
        },
        "query-fmt": {
          "type": "string",
          "x-dependency": {
            "type": {
              "required": true,
              "value": "set-query"
            }
          }
        },
        "redir_code": {
          "type": "integer",
          "enum": [
            301,
            302,
            303,
            307,
            308
          ],
          "x-dependency": {
            "type": {
              "value": "redirect"
            }
          },
          "x-display-name": "Redirect Code",
          "x-nullable": true
        },
        "redir_option": {
          "type": "string",
          "x-dependency": {
            "type": {
              "value": "redirect"
            }
          },
          "x-display-name": "Redirect Option"
        },
        "redir_type": {
          "type": "string",
          "enum": [
            "location",
            "prefix",
            "scheme"
          ],
          "x-dependency": {
            "type": {
              "required": true,
              "value": "redirect"
            }
          },
          "x-display-name": "Redirect Type"
        },
        "redir_value": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "type": {
              "required": true,
              "value": "redirect"
            }
          },
          "x-display-name": "Redirect Value"
        },
        "resolvers": {
          "type": "string",
          "x-dependency": {
            "type": {
              "required": true,
              "value": "do-resolve"
            }
          },
          "x-display-name": "Resolvers"
        },
        "return_content": {
          "type": "string",
          "x-dependency": {
            "return_content_format": {
              "required": true,
              "value": [
                "errofile",
                "errorfiles",
                "file",
                "lf-file",
                "string",
                "lf-string"
              ]
            }
          }
        },
        "return_content_format": {
          "type": "string",
          "enum": [
            "default-errorfiles",
            "errorfile",
            "errorfiles",
            "file",
            "lf-file",
            "string",
            "lf-string"
          ],
          "x-dependency": {
            "type": {
              "value": [
                "deny",
                "tarpit",
                "return"
              ]
            }
          }
        },
        "return_content_type": {
          "type": "string",
          "x-dependency": {
            "type": {
              "value": [
                "deny",
                "tarpit",
                "return"
              ]
            }
          },
          "x-display-name": "Return content type",
          "x-nullable": true
        },
        "return_hdrs": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/return_header"
          },
          "x-dependency": {
            "return_content_format": {
              "value": [
                "file",
                "lf-file",
                "string",
                "lf-string"
              ]
            }
          },
          "x-go-name": "ReturnHeaders",
          "x-omitempty": true
        },
        "return_status_code": {
          "type": "integer",
          "maximum": 599,
          "minimum": 200,
          "x-dependency": {
            "type": {
              "value": "return"
            }
          },
          "x-display-name": "Return Error Code",
          "x-nullable": true
        },
        "rst_ttl": {
          "type": "integer",
          "x-dependency": {
            "type": {
              "required": true,
              "value": [
                "silent-drop"
              ]
            }
          },
          "x-display-name": "RST TTL"
        },
        "sc_expr": {
          "type": "string",
          "x-dependency": {
            "type": {
              "required": true,
              "value": [
                "sc-add-gpc",
                "sc-set-gpt0"
              ]
            }
          },
          "x-display-name": "ScSet Expression Value"
        },
        "sc_id": {
          "type": "integer",
          "x-dependency": {
            "type": {
              "required": true,
              "value": [
                "sc-add-gpc",
                "sc-inc-gpc",
                "sc-inc-gpc0",
                "sc-inc-gpc1",
                "sc-set-gpt",
                "sc-set-gpt0"
              ]
            }
          }
        },
        "sc_idx": {
          "type": "integer",
          "x-dependency": {
            "type": {
              "required": true,
              "value": [
                "sc-add-gpc",
                "sc-inc-gpc",
                "sc-set-gpt"
              ]
            }
          }
        },
        "sc_int": {
          "type": "integer",
          "x-dependency": {
            "type": {
              "required": true,
              "value": [
                "sc-add-gpc",
                "sc-set-gpt0"
              ]
            }
          },
          "x-display-name": "ScSet Integer Value",
          "x-nullable": true
        },
        "service_name": {
          "type": "string",
          "x-dependency": {
            "type": {
              "required": true,
              "value": "use-service"
            }
          }
        },
        "spoe_engine": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "type": {
              "required": true,
              "value": "send-spoe-group"
            }
          },
          "x-display-name": "SPOE Engine"
        },
        "spoe_group": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "type": {
              "required": true,
              "value": "send-spoe-group"
            }
          },
          "x-display-name": "SPOE Group"
        },
        "strict_mode": {
          "type": "string",
          "enum": [
            "on",
            "off"
          ],
          "x-dependency": {
            "type": {
              "required": true,
              "value": "strict-mode"
            }
          }
        },
        "timeout": {
          "type": "string",
          "x-dependency": {
            "type": {
              "required": true,
              "value": "set-timeout"
            }
          }
        },
        "timeout_type": {
          "type": "string",
          "enum": [
            "server",
            "tunnel",
            "client"
          ],
          "x-dependency": {
            "type": {
              "required": true,
              "value": "set-timeout"
            }
          }
        },
        "tos_value": {
          "type": "string",
          "pattern": "^(0x[0-9A-Fa-f]+|[0-9]+)$",
          "x-dependency": {
            "type": {
              "required": true,
              "value": "set-tos"
            }
          },
          "x-display-name": "Tos Value"
        },
        "track_sc_key": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "type": {
              "required": true,
              "value": "track-sc"
            }
          },
          "x-display-name": "track-sc Key"
        },
        "track_sc_stick_counter": {
          "type": "integer",
          "x-dependency": {
            "type": {
              "value": "track-sc"
            }
          },
          "x-display-name": "track-sc StickCounter",
          "x-nullable": true
        },
        "track_sc_table": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "type": {
              "value": "track-sc"
            }
          },
          "x-display-name": "track-sc Table"
        },
        "type": {
          "type": "string",
          "enum": [
            "add-acl",
            "add-header",
            "allow",
            "auth",
            "cache-use",
            "capture",
            "del-acl",
            "del-header",
            "del-map",
            "deny",
            "disable-l7-retry",
            "do-resolve",
            "early-hint",
            "lua",
            "normalize-uri",
            "redirect",
            "reject",
            "replace-header",
            "replace-path",
            "replace-pathq",
            "replace-uri",
            "replace-value",
            "return",
            "sc-add-gpc",
            "sc-inc-gpc",
            "sc-inc-gpc0",
            "sc-inc-gpc1",
            "sc-set-gpt",
            "sc-set-gpt0",
            "send-spoe-group",
            "set-bc-mark",
            "set-bc-tos",
            "set-dst",
            "set-dst-port",
            "set-fc-mark",
            "set-fc-tos",
            "set-header",
            "set-log-level",
            "set-map",
            "set-mark",
            "set-method",
            "set-nice",
            "set-path",
            "set-pathq",
            "set-priority-class",
            "set-priority-offset",
            "set-query",
            "set-src",
            "set-src-port",
            "set-timeout",
            "set-tos",
            "set-uri",
            "set-var",
            "silent-drop",
            "strict-mode",
            "tarpit",
            "track-sc",
            "unset-var",
            "use-service",
            "wait-for-body",
            "wait-for-handshake",
            "set-bandwidth-limit"
          ],
          "x-nullable": false
        },
        "uri-fmt": {
          "type": "string",
          "x-dependency": {
            "type": {
              "required": true,
              "value": [
                "set-uri",
                "replace-uri"
              ]
            }
          }
        },
        "uri-match": {
          "type": "string",
          "x-dependency": {
            "type": {
              "required": true,
              "value": "replace-uri"
            }
          }
        },
        "var_expr": {
          "type": "string",
          "x-dependency": {
            "type": {
              "required": true,
              "value": "set-var"
            }
          },
          "x-display-name": "Var Expression"
        },
        "var_format": {
          "type": "string",
          "x-dependency": {
            "type": {
              "required": true,
              "value": "set-var-fmt"
            }
          },
          "x-display-name": "Var Format"
        },
        "var_name": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "type": {
              "required": true,
              "value": [
                "set-var",
                "set-var-fmt",
                "do-resolve",
                "unset-var"
              ]
            }
          }
        },
        "var_scope": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "type": {
              "required": true,
              "value": [
                "set-var",
                "set-var-fmt",
                "unset-var"
              ]
            }
          }
        },
        "wait_at_least": {
          "type": "integer",
          "x-dependency": {
            "type": {
              "value": "wait-for-body"
            }
          },
          "x-nullable": true,
          "x-size": true
        },
        "wait_time": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-dependency": {
            "type": {
              "required": true,
              "value": "wait-for-body"
            }
          },
          "x-duration": true,
          "x-nullable": true
        }
      },
      "additionalProperties": false,
      "example": {
        "cond": "unless",
        "cond_test": "{ src 192.168.0.0/16 }",
        "hdr_format": "%T",
        "hdr_name": "X-Haproxy-Current-Date",
        "index": 0,
        "type": "add-header"
      }
    },
    "http_request_rules": {
      "description": "HAProxy HTTP request rules array (corresponds to http-request directives)",
      "type": "array",
      "title": "HTTP Request Rules Array",
      "items": {
        "$ref": "#/definitions/http_request_rule"
      }
    },
    "http_response_rule": {
      "description": "HAProxy HTTP response rule configuration (corresponds to http-response directives)",
      "type": "object",
      "title": "HTTP Response Rule",
      "required": [
        "type"
      ],
      "properties": {
        "acl_file": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "type": {
              "required": true,
              "value": [
                "add-acl",
                "del-acl"
              ]
            }
          }
        },
        "acl_keyfmt": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "type": {
              "required": true,
              "value": [
                "add-acl",
                "del-acl"
              ]
            }
          },
          "x-display-name": "ACK Key Format"
        },
        "bandwidth_limit_limit": {
          "type": "string",
          "x-dependency": {
            "type": {
              "value": "set-bandwidth-limit"
            }
          },
          "x-display-name": "Standard HAProxy expression"
        },
        "bandwidth_limit_name": {
          "type": "string",
          "x-dependency": {
            "type": {
              "value": "set-bandwidth-limit"
            }
          },
          "x-display-name": "Bandwidth limit name"
        },
        "bandwidth_limit_period": {
          "type": "string",
          "x-dependency": {
            "type": {
              "value": "set-bandwidth-limit"
            }
          },
          "x-display-name": "Standard HAProxy expression"
        },
        "cache_name": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "type": {
              "required": true,
              "value": "cache-store"
            }
          },
          "x-display-name": "Cache Name"
        },
        "capture_id": {
          "type": "integer",
          "x-dependency": {
            "type": {
              "required": true,
              "value": "capture"
            }
          },
          "x-display-name": "Capture SlotID",
          "x-nullable": true
        },
        "capture_sample": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "type": {
              "required": true,
              "value": "capture"
            }
          },
          "x-display-name": "Capture Sample"
        },
        "cond": {
          "type": "string",
          "enum": [
            "if",
            "unless"
          ],
          "x-display-name": "Condition"
        },
        "cond_test": {
          "type": "string",
          "x-dependency": {
            "cond": {
              "required": true
            }
          },
          "x-display-name": "Condition Test",
          "x-dynamic-enum": {
            "freeFormat": true,
            "operation": "getACLs",
            "property": "acl_name"
          }
        },
        "deny_status": {
          "type": "integer",
          "maximum": 599,
          "minimum": 200,
          "x-dependency": {
            "type": {
              "value": "deny"
            }
          },
          "x-nullable": true
        },
        "expr": {
          "type": "string",
          "x-dependency": {
            "type": {
              "required": true,
              "value": [
                "set-fc-mark",
                "set-fc-tos"
              ]
            }
          },
          "x-display-name": "Standard HAProxy expression"
        },
        "hdr_format": {
          "type": "string",
          "x-dependency": {
            "type": {
              "required": true,
              "value": [
                "replace-header",
                "replace-value",
                "set-header",
                "add-header"
              ]
            }
          },
          "x-display-name": "Header Format"
        },
        "hdr_match": {
          "type": "string",
          "x-dependency": {
            "type": {
              "required": true,
              "value": [
                "replace-header",
                "replace-value"
              ]
            }
          },
          "x-display-name": "Header Match"
        },
        "hdr_method": {
          "type": "string",
          "x-dependency": {
            "type": {
              "value": [
                "del-header"
              ]
            }
          },
          "x-display-name": "Header Match Method"
        },
        "hdr_name": {
          "type": "string",
          "x-dependency": {
            "type": {
              "required": true,
              "value": [
                "add-header",
                "replace-header",
                "del-header",
                "set-header",
                "replace-value"
              ]
            }
          },
          "x-display-name": "Header Name"
        },
        "log_level": {
          "type": "string",
          "enum": [
            "emerg",
            "alert",
            "crit",
            "err",
            "warning",
            "notice",
            "info",
            "debug",
            "silent"
          ],
          "x-dependency": {
            "type": {
              "required": true,
              "value": "set-log-level"
            }
          }
        },
        "lua_action": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "type": {
              "required": true,
              "value": "lua"
            }
          }
        },
        "lua_params": {
          "type": "string",
          "x-dependency": {
            "type": {
              "value": "lua"
            }
          }
        },
        "map_file": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "type": {
              "required": true,
              "value": [
                "set-map",
                "del-map"
              ]
            }
          }
        },
        "map_keyfmt": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "type": {
              "required": true,
              "value": [
                "set-map",
                "del-map"
              ]
            }
          },
          "x-display-name": "Map Key Format"
        },
        "map_valuefmt": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "type": {
              "required": true,
              "value": "set-map"
            }
          },
          "x-display-name": "Map Value Format"
        },
        "mark_value": {
          "type": "string",
          "pattern": "^(0x[0-9A-Fa-f]+|[0-9]+)$",
          "x-dependency": {
            "type": {
              "required": true,
              "value": "set-mark"
            }
          },
          "x-display-name": "Mark Value"
        },
        "nice_value": {
          "type": "integer",
          "maximum": 1024,
          "minimum": -1024,
          "x-dependency": {
            "type": {
              "required": true,
              "value": "set-nice"
            }
          },
          "x-display-name": "Nice Value",
          "x-nullable": false
        },
        "redir_code": {
          "type": "integer",
          "enum": [
            301,
            302,
            303,
            307,
            308
          ],
          "x-dependency": {
            "type": {
              "value": "redirect"
            }
          },
          "x-display-name": "Redirect Code",
          "x-nullable": true
        },
        "redir_option": {
          "type": "string",
          "x-dependency": {
            "type": {
              "required": true,
              "value": "redirect"
            }
          },
          "x-display-name": "Redirect Option"
        },
        "redir_type": {
          "type": "string",
          "enum": [
            "location",
            "prefix",
            "scheme"
          ],
          "x-dependency": {
            "type": {
              "required": true,
              "value": "redirect"
            }
          },
          "x-display-name": "Redirect Type"
        },
        "redir_value": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "type": {
              "required": true,
              "value": "redirect"
            }
          },
          "x-display-name": "Redirect Value"
        },
        "return_content": {
          "type": "string",
          "x-dependency": {
            "return_content_format": {
              "required": true,
              "value": [
                "errofile",
                "errorfiles",
                "file",
                "lf-file",
                "string",
                "lf-string"
              ]
            }
          }
        },
        "return_content_format": {
          "type": "string",
          "enum": [
            "default-errorfiles",
            "errorfile",
            "errorfiles",
            "file",
            "lf-file",
            "string",
            "lf-string"
          ],
          "x-dependency": {
            "type": {
              "value": [
                "deny",
                "return"
              ]
            }
          }
        },
        "return_content_type": {
          "type": "string",
          "x-dependency": {
            "type": {
              "value": [
                "deny",
                "return"
              ]
            }
          },
          "x-display-name": "Return content type",
          "x-nullable": true
        },
        "return_hdrs": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/return_header"
          },
          "x-dependency": {
            "return_content_format": {
              "value": [
                "file",
                "lf-file",
                "string",
                "lf-string"
              ]
            }
          },
          "x-go-name": "ReturnHeaders",
          "x-omitempty": true
        },
        "return_status_code": {
          "type": "integer",
          "maximum": 599,
          "minimum": 200,
          "x-dependency": {
            "type": {
              "value": "return"
            }
          },
          "x-display-name": "Return Error Code",
          "x-nullable": true
        },
        "rst_ttl": {
          "type": "integer",
          "x-dependency": {
            "type": {
              "required": true,
              "value": [
                "silent-drop"
              ]
            }
          },
          "x-display-name": "RST TTL"
        },
        "sc_expr": {
          "type": "string",
          "x-dependency": {
            "type": {
              "required": true,
              "value": [
                "sc-add-gpc",
                "sc-set-gpt0"
              ]
            }
          },
          "x-display-name": "ScSet Expression Value"
        },
        "sc_id": {
          "type": "integer",
          "x-dependency": {
            "type": {
              "required": true,
              "value": [
                "sc-add-gpc",
                "sc-inc-gpc",
                "sc-inc-gpc0",
                "sc-inc-gpc1",
                "sc-set-gpt",
                "sc-set-gpt0"
              ]
            }
          }
        },
        "sc_idx": {
          "type": "integer",
          "x-dependency": {
            "type": {
              "required": true,
              "value": [
                "sc-add-gpc",
                "sc-inc-gpc",
                "sc-set-gpt"
              ]
            }
          }
        },
        "sc_int": {
          "type": "integer",
          "x-dependency": {
            "type": {
              "required": true,
              "value": [
                "sc-add-gpc",
                "sc-set-gpt0"
              ]
            }
          },
          "x-display-name": "ScSet Integer Value",
          "x-nullable": true
        },
        "spoe_engine": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "type": {
              "required": true,
              "value": "send-spoe-group"
            }
          }
        },
        "spoe_group": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "type": {
              "required": true,
              "value": "send-spoe-group"
            }
          }
        },
        "status": {
          "type": "integer",
          "maximum": 999,
          "minimum": 100,
          "x-dependency": {
            "type": {
              "required": true,
              "value": "set-status"
            }
          },
          "x-nullable": false
        },
        "status_reason": {
          "type": "string",
          "x-dependency": {
            "type": {
              "value": "set-status"
            }
          }
        },
        "strict_mode": {
          "type": "string",
          "enum": [
            "on",
            "off"
          ],
          "x-dependency": {
            "type": {
              "required": true,
              "value": "strict-mode"
            }
          }
        },
        "timeout": {
          "type": "string",
          "x-dependency": {
            "type": {
              "required": true,
              "value": "set-timeout"
            }
          }
        },
        "timeout_type": {
          "type": "string",
          "enum": [
            "server",
            "tunnel",
            "client"
          ],
          "x-dependency": {
            "type": {
              "required": true,
              "value": "set-timeout"
            }
          }
        },
        "tos_value": {
          "type": "string",
          "pattern": "^(0x[0-9A-Fa-f]+|[0-9]+)$",
          "x-dependency": {
            "type": {
              "required": true,
              "value": "set-tos"
            }
          },
          "x-display-name": "Tos Value"
        },
        "track_sc_key": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "type": {
              "required": true,
              "value": "track-sc"
            }
          },
          "x-display-name": "track-sc Key"
        },
        "track_sc_stick_counter": {
          "type": "integer",
          "x-dependency": {
            "type": {
              "value": "track-sc"
            }
          },
          "x-display-name": "track-sc StickCounter",
          "x-nullable": true
        },
        "track_sc_table": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "type": {
              "value": "track-sc"
            }
          },
          "x-display-name": "track-sc Table"
        },
        "type": {
          "type": "string",
          "enum": [
            "add-acl",
            "add-header",
            "allow",
            "cache-store",
            "capture",
            "del-acl",
            "del-header",
            "del-map",
            "deny",
            "lua",
            "redirect",
            "replace-header",
            "replace-value",
            "return",
            "sc-add-gpc",
            "sc-inc-gpc",
            "sc-inc-gpc0",
            "sc-inc-gpc1",
            "sc-set-gpt",
            "sc-set-gpt0",
            "send-spoe-group",
            "set-fc-mark",
            "set-fc-tos",
            "set-header",
            "set-log-level",
            "set-map",
            "set-mark",
            "set-nice",
            "set-status",
            "set-timeout",
            "set-tos",
            "set-var",
            "set-var-fmt",
            "silent-drop",
            "strict-mode",
            "track-sc",
            "unset-var",
            "wait-for-body",
            "set-bandwidth-limit"
          ],
          "x-nullable": false
        },
        "var_expr": {
          "type": "string",
          "x-dependency": {
            "type": {
              "required": true,
              "value": "set-var"
            }
          },
          "x-display-name": "Var Expression"
        },
        "var_format": {
          "type": "string",
          "x-dependency": {
            "type": {
              "required": true,
              "value": "set-var-fmt"
            }
          },
          "x-display-name": "Var Format"
        },
        "var_name": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "type": {
              "required": true,
              "value": [
                "set-var",
                "set-var-fmt",
                "unset-var"
              ]
            }
          }
        },
        "var_scope": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "type": {
              "required": true,
              "value": [
                "set-var",
                "set-var-fmt",
                "unset-var"
              ]
            }
          }
        },
        "wait_at_least": {
          "type": "integer",
          "x-dependency": {
            "type": {
              "value": "wait-for-body"
            }
          },
          "x-nullable": true,
          "x-size": true
        },
        "wait_time": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-dependency": {
            "type": {
              "required": true,
              "value": "wait-for-body"
            }
          },
          "x-duration": true,
          "x-nullable": true
        }
      },
      "additionalProperties": false,
      "example": {
        "cond": "unless",
        "cond_test": "{ src 192.168.0.0/16 }",
        "hdr_format": "%T",
        "hdr_name": "X-Haproxy-Current-Date",
        "index": 0,
        "type": "add-header"
      }
    },
    "http_response_rules": {
      "description": "HAProxy HTTP response rules array (corresponds to http-response directives)",
      "type": "array",
      "title": "HTTP Response Rules Array",
      "items": {
        "$ref": "#/definitions/http_response_rule"
      }
    },
    "httpchk_params": {
      "type": "object",
      "properties": {
        "method": {
          "type": "string",
          "enum": [
            "HEAD",
            "PUT",
            "POST",
            "GET",
            "TRACE",
            "PATCH",
            "DELETE",
            "CONNECT",
            "OPTIONS"
          ]
        },
        "uri": {
          "type": "string",
          "pattern": "^[^ ]*$"
        },
        "version": {
          "type": "string"
        }
      },
      "x-display-name": "HTTP Check"
    },
    "info": {
      "description": "General API, OS and hardware information",
      "type": "object",
      "title": "Information",
      "properties": {
        "api": {
          "type": "object",
          "properties": {
            "build_date": {
              "description": "HAProxy Dataplane API build date",
              "type": "string",
              "format": "date-time"
            },
            "version": {
              "description": "HAProxy Dataplane API version string",
              "type": "string"
            }
          }
        },
        "system": {
          "type": "object",
          "properties": {
            "cpu_info": {
              "type": "object",
              "properties": {
                "model": {
                  "type": "string"
                },
                "num_cpus": {
                  "description": "Number of logical CPUs",
                  "type": "integer"
                }
              }
            },
            "hostname": {
              "description": "Hostname where the HAProxy is running",
              "type": "string"
            },
            "mem_info": {
              "type": "object",
              "properties": {
                "dataplaneapi_memory": {
                  "type": "integer"
                },
                "free_memory": {
                  "type": "integer"
                },
                "total_memory": {
                  "type": "integer"
                }
              }
            },
            "os_string": {
              "description": "OS string",
              "type": "string"
            },
            "time": {
              "description": "Current time in milliseconds since Epoch.",
              "type": "integer"
            },
            "uptime": {
              "description": "System uptime",
              "type": "integer",
              "x-nullable": true
            }
          }
        }
      },
      "example": {
        "api": {
          "build_date": "2019-08-21T17:31:56.000Z",
          "version": "v1.2.1 45a3288.dev"
        },
        "system": {
          "cpu_info": {
            "model": "Intel(R) Core(TM) i7-7500U CPU @ 2.70GHz",
            "num_cpus": 4
          },
          "hostname": "test",
          "mem_info": {
            "dataplaneapi_memory": 44755536,
            "free_memory": 5790642176,
            "total_memory": 16681517056
          },
          "os_string": "Linux 4.15.0-58-generic #64-Ubuntu SMP Tue Aug 6 11:12:41 UTC 2019",
          "time": 1566401525,
          "uptime": 87340
        }
      }
    },
    "log_forward": {
      "description": "LogForward with all it's children resources",
      "type": "object",
      "allOf": [
        {
          "$ref": "#/definitions/log_forward_base"
        },
        {
          "type": "object",
          "properties": {
            "binds": {
              "additionalProperties": {
                "$ref": "#/definitions/bind"
              }
            },
            "dgram_binds": {
              "additionalProperties": {
                "$ref": "#/definitions/dgram_bind"
              }
            },
            "log_target_list": {
              "x-go-name": "LogTargetList",
              "$ref": "#/definitions/log_targets"
            }
          }
        }
      ],
      "x-go-name": "LogForward"
    },
    "log_forward_base": {
      "description": "HAProxy log forward configuration",
      "type": "object",
      "title": "Log Forward",
      "required": [
        "name"
      ],
      "properties": {
        "backlog": {
          "type": "integer",
          "x-nullable": true
        },
        "maxconn": {
          "type": "integer",
          "x-nullable": true
        },
        "name": {
          "type": "string",
          "pattern": "^[A-Za-z0-9-_.:]+$",
          "x-nullable": false
        },
        "timeout_client": {
          "type": "integer",
          "maximum": 2147483647,
          "x-default-unit": "ms",
          "x-duration": true,
          "x-nullable": true
        }
      },
      "additionalProperties": false
    },
    "log_forwards": {
      "description": "HAProxy log forwards array",
      "type": "array",
      "title": "Log Forwards",
      "items": {
        "$ref": "#/definitions/log_forward"
      }
    },
    "log_target": {
      "description": "Per-instance logging of events and traffic.",
      "type": "object",
      "title": "Log Target",
      "properties": {
        "address": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "global": {
              "required": true,
              "value": false
            },
            "nolog": {
              "required": true,
              "value": false
            }
          }
        },
        "facility": {
          "type": "string",
          "enum": [
            "kern",
            "user",
            "mail",
            "daemon",
            "auth",
            "syslog",
            "lpr",
            "news",
            "uucp",
            "cron",
            "auth2",
            "ftp",
            "ntp",
            "audit",
            "alert",
            "cron2",
            "local0",
            "local1",
            "local2",
            "local3",
            "local4",
            "local5",
            "local6",
            "local7"
          ],
          "x-dependency": {
            "global": {
              "required": true,
              "value": false
            },
            "nolog": {
              "required": true,
              "value": false
            }
          }
        },
        "format": {
          "type": "string",
          "enum": [
            "local",
            "rfc3164",
            "rfc5424",
            "priority",
            "short",
            "timed",
            "iso",
            "raw"
          ],
          "x-dependency": {
            "global": {
              "value": false
            },
            "nolog": {
              "value": false
            }
          }
        },
        "global": {
          "type": "boolean"
        },
        "length": {
          "type": "integer",
          "x-dependency": {
            "global": {
              "value": false
            },
            "nolog": {
              "value": false
            }
          }
        },
        "level": {
          "type": "string",
          "enum": [
            "emerg",
            "alert",
            "crit",
            "err",
            "warning",
            "notice",
            "info",
            "debug"
          ],
          "x-dependency": {
            "global": {
              "value": false
            },
            "nolog": {
              "value": false
            }
          }
        },
        "minlevel": {
          "type": "string",
          "enum": [
            "emerg",
            "alert",
            "crit",
            "err",
            "warning",
            "notice",
            "info",
            "debug"
          ],
          "x-dependency": {
            "global": {
              "value": false
            },
            "level": {
              "required": false
            },
            "nolog": {
              "value": false
            }
          }
        },
        "nolog": {
          "type": "boolean"
        },
        "sample_range": {
          "type": "string",
          "x-dependency": {
            "global": {
              "value": false
            },
            "nolog": {
              "value": false
            }
          }
        },
        "sample_size": {
          "type": "integer",
          "x-dependency": {
            "global": {
              "value": false
            },
            "nolog": {
              "value": false
            },
            "sample_range": {
              "required": true
            }
          }
        }
      },
      "additionalProperties": false
    },
    "log_targets": {
      "description": "HAProxy log target array (corresponds to log directives)",
      "type": "array",
      "title": "Log Target Array",
      "items": {
        "$ref": "#/definitions/log_target"
      }
    },
    "lua_options": {
      "type": "object",
      "properties": {
        "load_per_thread": {
          "type": "string"
        },
        "loads": {
          "type": "array",
          "items": {
            "type": "object",
            "required": [
              "file"
            ],
            "properties": {
              "file": {
                "type": "string",
                "pattern": "^[^\\s]+$"
              }
            },
            "x-go-name": "LuaLoad"
          },
          "x-omitempty": true
        },
        "prepend_path": {
          "type": "array",
          "items": {
            "type": "object",
            "required": [
              "path"
            ],
            "properties": {
              "path": {
                "type": "string",
                "pattern": "^[^\\s]+$"
              },
              "type": {
                "type": "string",
                "enum": [
                  "path",
                  "cpath"
                ]
              }
            },
            "x-go-name": "LuaPrependPath"
          },
          "x-omitempty": true
        }
      }
    },
    "mailer_entries": {
      "description": "HAProxy mailer entries",
      "type": "array",
      "title": "Mailer Entries",
      "items": {
        "$ref": "#/definitions/mailer_entry"
      }
    },
    "mailer_entry": {
      "description": "Mailer entry of a Mailers section",
      "type": "object",
      "title": "Mailer Entry",
      "required": [
        "name",
        "address",
        "port"
      ],
      "properties": {
        "address": {
          "type": "string",
          "pattern": "^\\S+$",
          "x-nullable": false
        },
        "name": {
          "type": "string",
          "pattern": "^[A-Za-z0-9-_]+$",
          "x-nullable": false
        },
        "port": {
          "type": "integer",
          "maximum": 65535,
          "minimum": 1,
          "x-nullable": false
        }
      }
    },
    "mailers_section": {
      "description": "MailersSection with all it's children resources",
      "type": "object",
      "allOf": [
        {
          "$ref": "#/definitions/mailers_section_base"
        },
        {
          "type": "object",
          "properties": {
            "mailer_entries": {
              "additionalProperties": {
                "$ref": "#/definitions/mailer_entry"
              }
            }
          }
        }
      ],
      "x-go-name": "MailersSection"
    },
    "mailers_section_base": {
      "description": "A list of SMTP servers used by HAProxy to send emails.",
      "type": "object",
      "title": "Mailers Section Base",
      "required": [
        "name"
      ],
      "properties": {
        "name": {
          "type": "string",
          "pattern": "^[A-Za-z0-9-_]+$",
          "x-nullable": false
        },
        "timeout": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-display-name": "Timeout to send an email in milliseconds",
          "x-duration": true,
          "x-nullable": true
        }
      },
      "additionalProperties": false
    },
    "mailers_sections": {
      "description": "HAProxy mailers_section array",
      "type": "array",
      "title": "Mailers Sections",
      "items": {
        "$ref": "#/definitions/mailers_section"
      }
    },
    "map": {
      "description": "Map File",
      "type": "object",
      "title": "Map File",
      "properties": {
        "description": {
          "type": "string"
        },
        "file": {
          "type": "string"
        },
        "id": {
          "type": "string"
        },
        "size": {
          "description": "File size in bytes.",
          "type": "integer",
          "x-nullable": true
        },
        "storage_name": {
          "type": "string"
        }
      }
    },
    "map_entries": {
      "description": "Entries of one runtime map",
      "type": "array",
      "title": "Maps Entries",
      "items": {
        "$ref": "#/definitions/map_entry"
      }
    },
    "map_entry": {
      "description": "One Map Entry",
      "type": "object",
      "title": "One Map Entry",
      "properties": {
        "id": {
          "type": "string",
          "readOnly": true
        },
        "key": {
          "type": "string"
        },
        "value": {
          "type": "string"
        }
      }
    },
    "maps": {
      "description": "Array of runtime map files",
      "type": "array",
      "title": "Map Files Array",
      "items": {
        "$ref": "#/definitions/map"
      }
    },
    "monitor_fail": {
      "type": "object",
      "required": [
        "cond",
        "cond_test"
      ],
      "properties": {
        "cond": {
          "type": "string",
          "enum": [
            "if",
            "unless"
          ],
          "x-display-name": "Condition"
        },
        "cond_test": {
          "type": "string",
          "x-dependency": {
            "cond": {
              "required": true
            }
          },
          "x-display-name": "Condition Test"
        }
      }
    },
    "monitor_uri": {
      "type": "string"
    },
    "mysql_check_params": {
      "type": "object",
      "properties": {
        "client_version": {
          "type": "string",
          "enum": [
            "pre-41",
            "post-41"
          ]
        },
        "username": {
          "type": "string"
        }
      }
    },
    "nameserver": {
      "description": "Nameserver used in Runtime DNS configuration",
      "type": "object",
      "title": "Nameserver",
      "required": [
        "name",
        "address"
      ],
      "properties": {
        "address": {
          "type": "string",
          "pattern": "^[^\\s]+$"
        },
        "name": {
          "type": "string",
          "pattern": "^[A-Za-z0-9-_.:]+$",
          "x-nullable": false
        },
        "port": {
          "type": "integer",
          "maximum": 65535,
          "minimum": 1,
          "x-nullable": true
        }
      },
      "example": {
        "address": "10.0.0.1",
        "name": "ns1",
        "port": 53
      }
    },
    "nameservers": {
      "description": "Nameservers array",
      "type": "array",
      "title": "Nameservers",
      "items": {
        "$ref": "#/definitions/nameserver"
      }
    },
    "native_stat": {
      "description": "Current stats for one object.",
      "type": "object",
      "title": "Stats",
      "properties": {
        "backend_name": {
          "type": "string",
          "x-dependency": {
            "type": "server"
          }
        },
        "name": {
          "type": "string"
        },
        "stats": {
          "$ref": "#/definitions/native_stat_stats"
        },
        "type": {
          "type": "string",
          "enum": [
            "backend",
            "server",
            "frontend"
          ]
        }
      }
    },
    "native_stat_stats": {
      "type": "object",
      "properties": {
        "act": {
          "type": "integer",
          "x-dependency": {
            "type": [
              "server",
              "backend"
            ]
          },
          "x-nullable": true
        },
        "addr": {
          "type": "string",
          "x-dependency": {
            "type": "server"
          }
        },
        "agent_code": {
          "type": "integer",
          "x-dependency": {
            "type": "server"
          },
          "x-nullable": true
        },
        "agent_desc": {
          "type": "string",
          "x-dependency": {
            "type": "server"
          }
        },
        "agent_duration": {
          "type": "integer",
          "x-dependency": {
            "type": "server"
          },
          "x-nullable": true
        },
        "agent_fall": {
          "type": "integer",
          "x-dependency": {
            "type": "server"
          },
          "x-nullable": true
        },
        "agent_health": {
          "type": "integer",
          "x-dependency": {
            "type": "server"
          },
          "x-nullable": true
        },
        "agent_rise": {
          "type": "integer",
          "x-dependency": {
            "type": "server"
          },
          "x-nullable": true
        },
        "agent_status": {
          "type": "string",
          "enum": [
            "UNK",
            "INI",
            "SOCKERR",
            "L4OK",
            "L4TOUT",
            "L4CON",
            "L7OK",
            "L7STS"
          ],
          "x-dependency": {
            "type": "server"
          }
        },
        "algo": {
          "type": "string",
          "x-dependency": {
            "type": "backend"
          }
        },
        "bck": {
          "type": "integer",
          "x-dependency": {
            "type": [
              "server",
              "backend"
            ]
          },
          "x-nullable": true
        },
        "bin": {
          "type": "integer",
          "x-nullable": true
        },
        "bout": {
          "type": "integer",
          "x-nullable": true
        },
        "check_code": {
          "type": "integer",
          "x-dependency": {
            "type": "server"
          },
          "x-nullable": true
        },
        "check_desc": {
          "type": "string",
          "x-dependency": {
            "type": "server"
          }
        },
        "check_duration": {
          "type": "integer",
          "x-dependency": {
            "type": "server"
          },
          "x-nullable": true
        },
        "check_fall": {
          "type": "integer",
          "x-dependency": {
            "type": "server"
          },
          "x-nullable": true
        },
        "check_health": {
          "type": "integer",
          "x-dependency": {
            "type": "server"
          },
          "x-nullable": true
        },
        "check_rise": {
          "type": "integer",
          "x-dependency": {
            "type": "server"
          },
          "x-nullable": true
        },
        "check_status": {
          "type": "string",
          "enum": [
            "UNK",
            "INI",
            "SOCKERR",
            "L4OK",
            "L4TOUT",
            "L4CON",
            "L6OK",
            "L6TOUT",
            "L6RSP",
            "L7OK",
            "L7OKC",
            "L7TOUT",
            "L7RSP",
            "L7STS"
          ],
          "x-dependency": {
            "type": "server"
          }
        },
        "chkdown": {
          "type": "integer",
          "x-dependency": {
            "type": [
              "server",
              "backend"
            ]
          },
          "x-nullable": true
        },
        "chkfail": {
          "type": "integer",
          "x-dependency": {
            "type": "server"
          },
          "x-nullable": true
        },
        "cli_abrt": {
          "type": "integer",
          "x-dependency": {
            "type": [
              "server",
              "backend"
            ]
          },
          "x-nullable": true
        },
        "comp_byp": {
          "type": "integer",
          "x-dependency": {
            "type": [
              "frontend",
              "backend"
            ]
          },
          "x-nullable": true
        },
        "comp_in": {
          "type": "integer",
          "x-dependency": {
            "type": [
              "frontend",
              "backend"
            ]
          },
          "x-nullable": true
        },
        "comp_out": {
          "type": "integer",
          "x-dependency": {
            "type": [
              "frontend",
              "backend"
            ]
          },
          "x-nullable": true
        },
        "comp_rsp": {
          "type": "integer",
          "x-dependency": {
            "type": [
              "frontend",
              "backend"
            ]
          },
          "x-nullable": true
        },
        "conn_rate": {
          "type": "integer",
          "x-dependency": {
            "type": "frontend"
          },
          "x-nullable": true
        },
        "conn_rate_max": {
          "type": "integer",
          "x-dependency": {
            "type": "frontend"
          },
          "x-nullable": true
        },
        "conn_tot": {
          "type": "integer",
          "x-dependency": {
            "type": "frontend"
          },
          "x-nullable": true
        },
        "cookie": {
          "type": "string",
          "x-dependency": {
            "type": [
              "server",
              "backend"
            ]
          }
        },
        "ctime": {
          "type": "integer",
          "x-dependency": {
            "type": [
              "server",
              "backend"
            ]
          },
          "x-nullable": true
        },
        "dcon": {
          "type": "integer",
          "x-dependency": {
            "type": "frontend"
          },
          "x-nullable": true
        },
        "downtime": {
          "type": "integer",
          "x-dependency": {
            "type": "server"
          },
          "x-nullable": true
        },
        "dreq": {
          "type": "integer",
          "x-dependency": {
            "type": [
              "frontend",
              "backend"
            ]
          },
          "x-nullable": true
        },
        "dresp": {
          "type": "integer",
          "x-nullable": true
        },
        "dses": {
          "type": "integer",
          "x-dependency": {
            "type": "frontend"
          },
          "x-nullable": true
        },
        "econ": {
          "type": "integer",
          "x-dependency": {
            "type": [
              "server",
              "backend"
            ]
          },
          "x-nullable": true
        },
        "ereq": {
          "type": "integer",
          "x-dependency": {
            "type": "frontend"
          },
          "x-nullable": true
        },
        "eresp": {
          "type": "integer",
          "x-dependency": {
            "type": [
              "server",
              "backend"
            ]
          },
          "x-nullable": true
        },
        "hanafail": {
          "type": "string",
          "x-dependency": {
            "type": "server"
          }
        },
        "hrsp_1xx": {
          "type": "integer",
          "x-nullable": true
        },
        "hrsp_2xx": {
          "type": "integer",
          "x-nullable": true
        },
        "hrsp_3xx": {
          "type": "integer",
          "x-nullable": true
        },
        "hrsp_4xx": {
          "type": "integer",
          "x-nullable": true
        },
        "hrsp_5xx": {
          "type": "integer",
          "x-nullable": true
        },
        "hrsp_other": {
          "type": "integer",
          "x-nullable": true
        },
        "iid": {
          "type": "integer",
          "x-nullable": true
        },
        "intercepted": {
          "type": "integer",
          "x-dependency": {
            "type": [
              "frontend",
              "backend"
            ]
          },
          "x-nullable": true
        },
        "last_agt": {
          "type": "string",
          "x-dependency": {
            "type": "server"
          },
          "x-nullable": true
        },
        "last_chk": {
          "type": "string",
          "x-dependency": {
            "type": "server"
          },
          "x-nullable": true
        },
        "lastchg": {
          "type": "integer",
          "x-dependency": {
            "type": [
              "server",
              "backend"
            ]
          },
          "x-nullable": true
        },
        "lastsess": {
          "type": "integer",
          "x-dependency": {
            "type": [
              "server",
              "backend"
            ]
          },
          "x-nullable": true
        },
        "lbtot": {
          "type": "integer",
          "x-dependency": {
            "type": [
              "server",
              "backend"
            ]
          },
          "x-nullable": true
        },
        "mode": {
          "type": "string",
          "enum": [
            "tcp",
            "http",
            "health",
            "unknown"
          ]
        },
        "pid": {
          "type": "integer",
          "x-nullable": true
        },
        "qcur": {
          "type": "integer",
          "x-dependency": {
            "type": [
              "server",
              "backend"
            ]
          },
          "x-nullable": true
        },
        "qlimit": {
          "type": "integer",
          "x-dependency": {
            "type": [
              "server",
              "backend"
            ]
          },
          "x-nullable": true
        },
        "qmax": {
          "type": "integer",
          "x-dependency": {
            "type": [
              "server",
              "backend"
            ]
          },
          "x-nullable": true
        },
        "qtime": {
          "type": "integer",
          "x-dependency": {
            "type": [
              "server",
              "backend"
            ]
          },
          "x-nullable": true
        },
        "rate": {
          "type": "integer",
          "x-nullable": true
        },
        "rate_lim": {
          "type": "integer",
          "x-dependency": {
            "type": "frontend"
          },
          "x-nullable": true
        },
        "rate_max": {
          "type": "integer",
          "x-nullable": true
        },
        "req_rate": {
          "type": "integer",
          "x-dependency": {
            "type": "frontend"
          },
          "x-nullable": true
        },
        "req_rate_max": {
          "type": "integer",
          "x-dependency": {
            "type": "frontend"
          },
          "x-nullable": true
        },
        "req_tot": {
          "type": "integer",
          "x-dependency": {
            "type": [
              "frontend",
              "backend"
            ]
          },
          "x-nullable": true
        },
        "rtime": {
          "type": "integer",
          "x-dependency": {
            "type": [
              "server",
              "backend"
            ]
          },
          "x-nullable": true
        },
        "scur": {
          "type": "integer",
          "x-nullable": true
        },
        "sid": {
          "type": "integer",
          "x-dependency": {
            "type": "server"
          },
          "x-nullable": true
        },
        "slim": {
          "type": "integer",
          "x-nullable": true
        },
        "smax": {
          "type": "integer",
          "x-nullable": true
        },
        "srv_abrt": {
          "type": "integer",
          "x-dependency": {
            "type": [
              "server",
              "backend"
            ]
          },
          "x-nullable": true
        },
        "status": {
          "type": "string",
          "enum": [
            "UP",
            "DOWN",
            "NOLB",
            "MAINT",
            "no check"
          ]
        },
        "stot": {
          "type": "integer",
          "x-nullable": true
        },
        "throttle": {
          "type": "integer",
          "x-dependency": {
            "type": "server"
          },
          "x-nullable": true
        },
        "tracked": {
          "type": "string",
          "x-dependency": {
            "type": "server"
          }
        },
        "ttime": {
          "type": "integer",
          "x-dependency": {
            "type": [
              "server",
              "backend"
            ]
          },
          "x-nullable": true
        },
        "weight": {
          "type": "integer",
          "x-dependency": {
            "type": [
              "server",
              "backend"
            ]
          },
          "x-nullable": true
        },
        "wredis": {
          "type": "integer",
          "x-dependency": {
            "type": [
              "server",
              "backend"
            ]
          },
          "x-nullable": true
        },
        "wretr": {
          "type": "integer",
          "x-dependency": {
            "type": [
              "server",
              "backend"
            ]
          },
          "x-nullable": true
        }
      },
      "example": {
        "bin": 4326578,
        "bout": 889901290,
        "comp_byp": 0,
        "comp_in": 0,
        "comp_out": 0,
        "comp_rsp": 0,
        "conn_rate": 12,
        "conn_rate_max": 456,
        "conn_tot": 45682,
        "dcon": 0,
        "dreq": 4,
        "dresp": 1,
        "dses": 0,
        "ereq": 54,
        "hrsp_1xx": 0,
        "hrsp_2xx": 165,
        "hrsp_3xx": 12,
        "hrsp_4xx": 50,
        "hrsp_5xx": 4,
        "hrsp_other": 0,
        "iid": 0,
        "intercepted": 346,
        "last_chk": "L4OK in 0ms",
        "mode": "http",
        "pid": 3204,
        "rate": 64,
        "rate_lim": 20000,
        "rate_max": 4000,
        "req_rate": 49,
        "req_rate_max": 3965,
        "req_total": 1254786,
        "scur": 129,
        "slim": 2000,
        "smax": 2000,
        "status": "UP",
        "stot": 12902
      }
    },
    "native_stats": {
      "description": "HAProxy stats array",
      "type": "object",
      "title": "Stats Array",
      "properties": {
        "error": {
          "type": "string"
        },
        "runtimeAPI": {
          "type": "string"
        },
        "stats": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/native_stat"
          },
          "x-omitempty": true
        }
      },
      "x-omitempty": true
    },
    "ocsp_update_options": {
      "type": "object",
      "properties": {
        "disable": {
          "type": "boolean",
          "default": false,
          "x-display-name": "Disable OCSP Update",
          "x-nullable": true
        },
        "httpproxy": {
          "type": "object",
          "properties": {
            "address": {
              "type": "string",
              "pattern": "^[^\\s]+$",
              "example": "127.0.0.1"
            },
            "port": {
              "type": "integer",
              "maximum": 65535,
              "minimum": 1,
              "x-nullable": true,
              "example": 80
            }
          },
          "x-display-name": "OCSP Update HTTP Proxy",
          "x-omitempty": true
        },
        "maxdelay": {
          "description": "Sets the maximum interval between two automatic updates of the same OCSP response.This time is expressed in seconds",
          "type": "integer",
          "x-default-unit": "s",
          "x-display-name": "OCSP Update Maximum Delay",
          "x-duration": false,
          "x-nullable": true
        },
        "mindelay": {
          "description": "Sets the minimum interval between two automatic updates of the same OCSP response. This time is expressed in seconds",
          "type": "integer",
          "x-default-unit": "s",
          "x-display-name": "OCSP Update Minimum Delay",
          "x-duration": false,
          "x-nullable": true
        },
        "mode": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "OCSP Update Mode"
        }
      }
    },
    "originalto": {
      "type": "object",
      "required": [
        "enabled"
      ],
      "properties": {
        "enabled": {
          "type": "string",
          "enum": [
            "enabled"
          ]
        },
        "except": {
          "type": "string",
          "pattern": "^[^\\s]+$"
        },
        "header": {
          "type": "string",
          "pattern": "^[^\\s]+$"
        }
      },
      "x-display-name": "OriginalTo"
    },
    "peer_entries": {
      "description": "HAProxy peer entries array",
      "type": "array",
      "title": "Peer entries",
      "items": {
        "$ref": "#/definitions/peer_entry"
      }
    },
    "peer_entry": {
      "description": "Peer Entry from peers table",
      "type": "object",
      "title": "Peer Entry",
      "required": [
        "name",
        "address",
        "port"
      ],
      "properties": {
        "address": {
          "type": "string",
          "pattern": "^[^\\s]+$"
        },
        "name": {
          "type": "string",
          "pattern": "^[A-Za-z0-9-_.:]+$",
          "x-nullable": false
        },
        "port": {
          "type": "integer",
          "maximum": 65535,
          "minimum": 1,
          "x-nullable": true
        },
        "shard": {
          "type": "integer"
        }
      }
    },
    "peer_section": {
      "description": "Peer Section with all it's children resources",
      "type": "object",
      "allOf": [
        {
          "$ref": "#/definitions/peer_section_base"
        },
        {
          "type": "object",
          "properties": {
            "binds": {
              "additionalProperties": {
                "$ref": "#/definitions/bind"
              }
            },
            "log_target_list": {
              "x-go-name": "LogTargetList",
              "$ref": "#/definitions/log_targets"
            },
            "peer_entries": {
              "additionalProperties": {
                "$ref": "#/definitions/peer_entry"
              }
            },
            "servers": {
              "additionalProperties": {
                "$ref": "#/definitions/server"
              }
            }
          }
        }
      ],
      "x-go-name": "PeerSection"
    },
    "peer_section_base": {
      "description": "HAProxy peer_section configuration",
      "type": "object",
      "title": "Peer Section Base",
      "required": [
        "name"
      ],
      "properties": {
        "default_bind": {
          "$ref": "#/definitions/default_bind"
        },
        "default_server": {
          "$ref": "#/definitions/default_server"
        },
        "disabled": {
          "type": "boolean"
        },
        "enabled": {
          "type": "boolean"
        },
        "name": {
          "type": "string",
          "pattern": "^[A-Za-z0-9-_.:]+$",
          "x-nullable": false
        },
        "shards": {
          "description": "In some configurations, one would like to distribute the stick-table contents\nto some peers in place of sending all the stick-table contents to each peer\ndeclared in the \"peers\" section. In such cases, \"shards\" specifies the\nnumber of peer involved in this stick-table contents distribution.",
          "type": "integer"
        }
      },
      "additionalProperties": false
    },
    "peer_sections": {
      "description": "HAProxy peer_section array",
      "type": "array",
      "title": "Peer_Section",
      "items": {
        "$ref": "#/definitions/peer_section"
      }
    },
    "performance_options": {
      "type": "object",
      "properties": {
        "busy_polling": {
          "type": "boolean"
        },
        "max_spread_checks": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-duration": true,
          "x-nullable": true
        },
        "maxcompcpuusage": {
          "type": "integer",
          "x-display-name": "Maximum HAProxy CPU usage"
        },
        "maxcomprate": {
          "type": "integer",
          "x-display-name": "Maximum per-process input compression rate"
        },
        "maxconn": {
          "type": "integer",
          "x-display-name": "Max Connections"
        },
        "maxconnrate": {
          "type": "integer",
          "x-display-name": "Maximum per-process number of concurrent connections"
        },
        "maxpipes": {
          "type": "integer",
          "x-display-name": "Maximum per-process number of pipes"
        },
        "maxsessrate": {
          "type": "integer",
          "x-display-name": "Maximum per-process number of sessions per second"
        },
        "maxzlibmem": {
          "type": "integer",
          "x-display-name": "Maximum amount of RAM in megabytes per process usable by the zlib"
        },
        "noepoll": {
          "type": "boolean",
          "x-display-name": "Disable the use of the \"epoll\" event polling system on Linux"
        },
        "noevports": {
          "type": "boolean",
          "x-display-name": "Disable the use of the event ports event polling system on SunOS system derived from Solaris 10 and later"
        },
        "nogetaddrinfo": {
          "type": "boolean",
          "x-display-name": "Disable the use of getaddrinfo for name resolving"
        },
        "nokqueue": {
          "type": "boolean",
          "x-display-name": "Disable the use of the \"kqueue\" event polling system on BSD"
        },
        "nopoll": {
          "type": "boolean",
          "x-display-name": "Disable the use of the \"poll\" event polling system"
        },
        "noreuseport": {
          "type": "boolean",
          "x-display-name": "Disable the use of SO_REUSEPORT"
        },
        "nosplice": {
          "type": "boolean",
          "x-display-name": "Disable the use of kernel tcp splicing between sockets on Linux"
        },
        "profiling_memory": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "Enable or disables per-function memory profiling"
        },
        "profiling_tasks": {
          "type": "string",
          "enum": [
            "auto",
            "enabled",
            "disabled"
          ],
          "x-display-name": "Enable or disables per-task CPU profiling"
        },
        "server_state_base": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-display-name": "Server State Base"
        },
        "server_state_file": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-display-name": "Server State File"
        },
        "spread_checks": {
          "type": "integer",
          "x-display-name": "Add some randomness in the check interval"
        },
        "thread_hard_limit": {
          "type": "integer",
          "x-nullable": true
        }
      }
    },
    "persist_rule": {
      "type": "object",
      "required": [
        "type"
      ],
      "properties": {
        "rdp_cookie_name": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "type": {
              "value": "rdp-cookie"
            }
          },
          "x-display-name": "Rdp Cookie Name"
        },
        "type": {
          "type": "string",
          "enum": [
            "rdp-cookie"
          ]
        }
      }
    },
    "pgsql_check_params": {
      "type": "object",
      "properties": {
        "username": {
          "type": "string"
        }
      }
    },
    "process_info": {
      "description": "General HAProxy process information",
      "type": "object",
      "title": "HAProxy Information",
      "properties": {
        "error": {
          "type": "string"
        },
        "info": {
          "$ref": "#/definitions/process_info_item"
        },
        "runtimeAPI": {
          "type": "string"
        }
      },
      "x-omitempty": true
    },
    "process_info_item": {
      "type": "object",
      "properties": {
        "active_peers": {
          "type": "integer",
          "x-nullable": true
        },
        "busy_polling": {
          "type": "integer",
          "x-nullable": true
        },
        "bytes_out_rate": {
          "type": "integer",
          "x-nullable": true
        },
        "compress_bps_in": {
          "type": "integer",
          "x-nullable": true
        },
        "compress_bps_out": {
          "type": "integer",
          "x-nullable": true
        },
        "compress_bps_rate_lim": {
          "type": "integer",
          "x-nullable": true
        },
        "conn_rate": {
          "type": "integer",
          "x-nullable": true
        },
        "conn_rate_limit": {
          "type": "integer",
          "x-nullable": true
        },
        "connected_peers": {
          "type": "integer",
          "x-nullable": true
        },
        "cum_conns": {
          "type": "integer",
          "x-nullable": true
        },
        "cum_req": {
          "type": "integer",
          "x-nullable": true
        },
        "cum_ssl_conns": {
          "type": "integer",
          "x-nullable": true
        },
        "curr_conns": {
          "type": "integer",
          "x-nullable": true
        },
        "curr_ssl_conns": {
          "type": "integer",
          "x-nullable": true
        },
        "dropped_logs": {
          "type": "integer",
          "x-nullable": true
        },
        "failed_resolutions": {
          "type": "integer",
          "x-nullable": true
        },
        "hard_max_conn": {
          "type": "integer",
          "x-nullable": true
        },
        "idle_pct": {
          "type": "integer",
          "x-nullable": true
        },
        "jobs": {
          "type": "integer",
          "x-nullable": true
        },
        "listeners": {
          "type": "integer",
          "x-nullable": true
        },
        "max_conn": {
          "type": "integer",
          "x-nullable": true
        },
        "max_conn_rate": {
          "type": "integer",
          "x-nullable": true
        },
        "max_pipes": {
          "type": "integer",
          "x-nullable": true
        },
        "max_sess_rate": {
          "type": "integer",
          "x-nullable": true
        },
        "max_sock": {
          "type": "integer",
          "x-nullable": true
        },
        "max_ssl_conns": {
          "type": "integer",
          "x-nullable": true
        },
        "max_ssl_rate": {
          "type": "integer",
          "x-nullable": true
        },
        "max_zlib_mem_usage": {
          "type": "integer",
          "x-nullable": true
        },
        "mem_max_mb": {
          "type": "integer",
          "x-nullable": true
        },
        "nbthread": {
          "description": "Number of threads",
          "type": "integer",
          "x-display-name": "Number of Threads",
          "x-nullable": true
        },
        "node": {
          "type": "string"
        },
        "pid": {
          "description": "Process id of the replying worker process",
          "type": "integer",
          "x-display-name": "PID",
          "x-nullable": true
        },
        "pipes_free": {
          "type": "integer",
          "x-nullable": true
        },
        "pipes_used": {
          "type": "integer",
          "x-nullable": true
        },
        "pool_alloc_mb": {
          "type": "integer",
          "x-nullable": true
        },
        "pool_failed": {
          "type": "integer",
          "x-nullable": true
        },
        "pool_used_mb": {
          "type": "integer",
          "x-nullable": true
        },
        "process_num": {
          "description": "Process number",
          "type": "integer",
          "x-display-name": "Process Number",
          "x-nullable": true
        },
        "processes": {
          "description": "Number of spawned processes",
          "type": "integer",
          "x-display-name": "Number of processes",
          "x-nullable": true
        },
        "release_date": {
          "description": "HAProxy version release date",
          "type": "string",
          "format": "date"
        },
        "run_queue": {
          "type": "integer",
          "x-nullable": true
        },
        "sess_rate": {
          "type": "integer",
          "x-nullable": true
        },
        "sess_rate_limit": {
          "type": "integer",
          "x-nullable": true
        },
        "ssl_backend_key_rate": {
          "type": "integer",
          "x-nullable": true
        },
        "ssl_backend_max_key_rate": {
          "type": "integer",
          "x-nullable": true
        },
        "ssl_cache_lookups": {
          "type": "integer",
          "x-nullable": true
        },
        "ssl_cache_misses": {
          "type": "integer",
          "x-nullable": true
        },
        "ssl_frontend_key_rate": {
          "type": "integer",
          "x-nullable": true
        },
        "ssl_frontend_max_key_rate": {
          "type": "integer",
          "x-nullable": true
        },
        "ssl_frontend_session_reuse": {
          "type": "integer",
          "x-nullable": true
        },
        "ssl_rate": {
          "type": "integer",
          "x-nullable": true
        },
        "ssl_rate_limit": {
          "type": "integer",
          "x-nullable": true
        },
        "stopping": {
          "type": "integer",
          "x-nullable": true
        },
        "tasks": {
          "type": "integer",
          "x-nullable": true
        },
        "total_bytes_out": {
          "type": "integer",
          "x-nullable": true
        },
        "ulimit_n": {
          "type": "integer",
          "x-nullable": true
        },
        "unstoppable": {
          "type": "integer",
          "x-nullable": true
        },
        "uptime": {
          "description": "HAProxy uptime in s",
          "type": "integer",
          "x-nullable": true
        },
        "version": {
          "description": "HAProxy version string",
          "type": "string"
        },
        "zlib_mem_usage": {
          "type": "integer",
          "x-nullable": true
        }
      }
    },
    "program": {
      "description": "HAProxy program configuration",
      "type": "object",
      "title": "Program",
      "required": [
        "name",
        "command"
      ],
      "properties": {
        "command": {
          "description": "The command to be run, with flags and options.",
          "type": "string"
        },
        "group": {
          "description": "The group to run the command as, if different than the HAProxy group.",
          "type": "string"
        },
        "name": {
          "type": "string",
          "pattern": "^[A-Za-z0-9-_.:]+$",
          "x-nullable": false
        },
        "start-on-reload": {
          "description": "HAProxy stops and recreates child programs at reload.",
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "user": {
          "description": "The user to run the command as, if different than the HAProxy user.",
          "type": "string"
        }
      },
      "example": {
        "command": "spoa-mirror --runtime 0 --mirror-url http://test.local",
        "group": "mygroupname",
        "name": "mirror",
        "start-on-reload": "enabled",
        "user": "myusername"
      }
    },
    "programs": {
      "type": "array",
      "items": {
        "$ref": "#/definitions/program"
      }
    },
    "redispatch": {
      "type": "object",
      "required": [
        "enabled"
      ],
      "properties": {
        "enabled": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "interval": {
          "type": "integer",
          "x-nullable": false
        }
      }
    },
    "reload": {
      "description": "HAProxy reload",
      "type": "object",
      "title": "HAProxy reload",
      "properties": {
        "id": {
          "type": "string",
          "pattern": "^\\d{4}-\\d{2}-\\d{2}-\\d+$"
        },
        "reload_timestamp": {
          "type": "integer"
        },
        "response": {
          "type": "string"
        },
        "status": {
          "type": "string",
          "enum": [
            "failed",
            "in_progress",
            "succeeded"
          ]
        }
      },
      "example": {
        "id": "2019-01-03-44",
        "status": "in_progress"
      }
    },
    "reloads": {
      "description": "HAProxy reloads array",
      "type": "array",
      "title": "HAProxy Reloads Array",
      "items": {
        "$ref": "#/definitions/reload"
      }
    },
    "resolver": {
      "description": "Resolver with all it's children resources",
      "type": "object",
      "allOf": [
        {
          "$ref": "#/definitions/resolver_base"
        },
        {
          "type": "object",
          "properties": {
            "nameservers": {
              "additionalProperties": {
                "$ref": "#/definitions/nameserver"
              }
            }
          }
        }
      ],
      "x-go-name": "Resolver"
    },
    "resolver_base": {
      "description": "Runtime DNS configuration",
      "type": "object",
      "title": "Resolver Base",
      "required": [
        "name"
      ],
      "properties": {
        "accepted_payload_size": {
          "type": "integer",
          "maximum": 8192,
          "minimum": 512
        },
        "hold_nx": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-duration": true,
          "x-nullable": true
        },
        "hold_obsolete": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-duration": true,
          "x-nullable": true
        },
        "hold_other": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-duration": true,
          "x-nullable": true
        },
        "hold_refused": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-duration": true,
          "x-nullable": true
        },
        "hold_timeout": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-duration": true,
          "x-nullable": true
        },
        "hold_valid": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-duration": true,
          "x-nullable": true
        },
        "name": {
          "type": "string",
          "pattern": "^[A-Za-z0-9-_.:]+$",
          "x-nullable": false
        },
        "parse-resolv-conf": {
          "type": "boolean"
        },
        "resolve_retries": {
          "type": "integer",
          "minimum": 1
        },
        "timeout_resolve": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-duration": true,
          "x-nullable": false
        },
        "timeout_retry": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-duration": true,
          "x-nullable": false
        }
      }
    },
    "resolvers": {
      "description": "HAProxy resolvers array",
      "type": "array",
      "title": "Resolvers",
      "items": {
        "$ref": "#/definitions/resolver"
      }
    },
    "return_header": {
      "type": "object",
      "required": [
        "name",
        "fmt"
      ],
      "properties": {
        "fmt": {
          "type": "string"
        },
        "name": {
          "type": "string"
        }
      },
      "x-go-name": "ReturnHeader"
    },
    "ring": {
      "description": "Ring with all it's children resources",
      "type": "object",
      "allOf": [
        {
          "$ref": "#/definitions/ring_base"
        },
        {
          "type": "object",
          "properties": {
            "servers": {
              "additionalProperties": {
                "$ref": "#/definitions/server"
              }
            }
          }
        }
      ],
      "x-go-name": "Ring"
    },
    "ring_base": {
      "description": "HAProxy ring configuration",
      "type": "object",
      "title": "Ring Base",
      "required": [
        "name"
      ],
      "properties": {
        "description": {
          "type": "string",
          "x-display-name": "The description is an optional description string of the ring"
        },
        "format": {
          "type": "string",
          "enum": [
            "iso",
            "local",
            "raw",
            "rfc3164",
            "rfc5424",
            "short",
            "priority",
            "timed"
          ],
          "x-display-name": "Format used to store events into the ring buffer"
        },
        "maxlen": {
          "type": "integer",
          "x-display-name": "The maximum length of an event message stored into the ring",
          "x-nullable": true
        },
        "name": {
          "type": "string",
          "pattern": "^[A-Za-z0-9-_.:]+$",
          "x-nullable": false
        },
        "size": {
          "type": "integer",
          "x-display-name": "Optional size in bytes for the ring-buffer",
          "x-nullable": true,
          "x-size": true
        },
        "timeout_connect": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-duration": true,
          "x-nullable": true
        },
        "timeout_server": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-duration": true,
          "x-nullable": true
        }
      },
      "additionalProperties": false
    },
    "rings": {
      "description": "HAProxy rings array",
      "type": "array",
      "title": "Rings",
      "items": {
        "$ref": "#/definitions/ring"
      }
    },
    "runtime_add_server": {
      "description": "Settable properties when adding a new server using HAProxy's runtime.",
      "type": "object",
      "title": "Runtime Add Server",
      "properties": {
        "address": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-nullable": false,
          "readOnly": true
        },
        "agent-addr": {
          "type": "string",
          "pattern": "^[^\\s]+$"
        },
        "agent-check": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-dependency": {
            "agent-port": {
              "required": true
            }
          }
        },
        "agent-inter": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-duration": true,
          "x-nullable": true
        },
        "agent-port": {
          "type": "integer",
          "maximum": 65535,
          "minimum": 1,
          "x-nullable": true
        },
        "agent-send": {
          "type": "string"
        },
        "allow_0rtt": {
          "type": "boolean"
        },
        "alpn": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-display-name": "ALPN Protocols"
        },
        "backup": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "check": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "check-send-proxy": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "check-sni": {
          "type": "string",
          "pattern": "^[^\\s]+$"
        },
        "check-ssl": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "check_alpn": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-display-name": "Protocols"
        },
        "check_proto": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-display-name": "Name"
        },
        "check_via_socks4": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "ciphers": {
          "type": "string",
          "x-dependency": {
            "ssl": {
              "value": "enabled"
            }
          }
        },
        "ciphersuites": {
          "type": "string",
          "x-dependency": {
            "ssl": {
              "value": "enabled"
            }
          }
        },
        "crl_file": {
          "type": "string",
          "x-dependency": {
            "ssl": {
              "value": "enabled"
            }
          }
        },
        "downinter": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-duration": true,
          "x-nullable": true
        },
        "error_limit": {
          "type": "integer",
          "x-display-name": "Healthcheck error limit",
          "x-nullable": true
        },
        "fall": {
          "type": "integer",
          "x-display-name": "Nr. of consecutive failed checks",
          "x-nullable": true
        },
        "fastinter": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-duration": true,
          "x-nullable": true
        },
        "force_sslv3": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "force_tlsv10": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "force_tlsv11": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "force_tlsv12": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "force_tlsv13": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "health_check_address": {
          "type": "string",
          "pattern": "^[^\\s]+$"
        },
        "health_check_port": {
          "type": "integer",
          "maximum": 65535,
          "minimum": 1,
          "x-nullable": true
        },
        "id": {
          "type": "string",
          "readOnly": true
        },
        "inter": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-duration": true,
          "x-nullable": true
        },
        "maintenance": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "maxconn": {
          "type": "integer",
          "x-display-name": "Max Concurrent Connections",
          "x-nullable": true
        },
        "maxqueue": {
          "type": "integer",
          "x-display-name": "Max Number of Connections",
          "x-nullable": true
        },
        "minconn": {
          "type": "integer",
          "x-nullable": true
        },
        "name": {
          "type": "string",
          "readOnly": true
        },
        "no_sslv3": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "no_tlsv10": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "no_tlsv11": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "no_tlsv12": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "no_tlsv13": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "npn": {
          "type": "string",
          "x-dependency": {
            "ssl": {
              "value": "enabled"
            }
          }
        },
        "observe": {
          "type": "string",
          "enum": [
            "layer4",
            "layer7"
          ],
          "x-dependency": {
            "ssl": {
              "value": "enabled"
            }
          }
        },
        "on-error": {
          "type": "string",
          "enum": [
            "fastinter",
            "fail-check",
            "sudden-death",
            "mark-down"
          ]
        },
        "on-marked-down": {
          "type": "string",
          "enum": [
            "shutdown-sessions"
          ]
        },
        "on-marked-up": {
          "type": "string",
          "enum": [
            "shutdown-backup-sessions"
          ]
        },
        "pool_low_conn": {
          "type": "integer",
          "x-nullable": true
        },
        "pool_max_conn": {
          "type": "integer",
          "x-nullable": true
        },
        "pool_purge_delay": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-duration": true,
          "x-nullable": true
        },
        "port": {
          "type": "integer",
          "maximum": 65535,
          "minimum": 1,
          "x-nullable": true,
          "readOnly": true
        },
        "proto": {
          "type": "string",
          "pattern": "^[^\\s]+$"
        },
        "proxy-v2-options": {
          "type": "array",
          "items": {
            "type": "string",
            "enum": [
              "authority",
              "cert-cn",
              "cert-key",
              "cert-sig",
              "crc32c",
              "ssl",
              "ssl-cipher",
              "unique-id"
            ]
          },
          "x-omitempty": true
        },
        "rise": {
          "type": "integer",
          "x-nullable": true
        },
        "send-proxy": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "send-proxy-v2": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "send_proxy_v2_ssl": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "send_proxy_v2_ssl_cn": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "slowstart": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-duration": true,
          "x-nullable": true
        },
        "sni": {
          "type": "string",
          "pattern": "^[^\\s]+$"
        },
        "source": {
          "type": "string"
        },
        "ssl": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "ssl_cafile": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "ssl": {
              "value": "enabled"
            }
          },
          "x-display-name": "SSL CA File"
        },
        "ssl_certificate": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "ssl": {
              "value": "enabled"
            }
          }
        },
        "ssl_max_ver": {
          "type": "string",
          "enum": [
            "SSLv3",
            "TLSv1.0",
            "TLSv1.1",
            "TLSv1.2",
            "TLSv1.3"
          ]
        },
        "ssl_min_ver": {
          "type": "string",
          "enum": [
            "SSLv3",
            "TLSv1.0",
            "TLSv1.1",
            "TLSv1.2",
            "TLSv1.3"
          ]
        },
        "ssl_reuse": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "tfo": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "tls_tickets": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-dependency": {
            "ssl": {
              "value": "enabled"
            }
          }
        },
        "track": {
          "type": "string"
        },
        "verify": {
          "type": "string",
          "enum": [
            "none",
            "required"
          ],
          "x-dependency": {
            "ssl": {
              "value": "enabled"
            }
          }
        },
        "verifyhost": {
          "type": "string",
          "x-dependency": {
            "ssl": {
              "value": "enabled"
            },
            "verify": {
              "value": "required"
            }
          }
        },
        "weight": {
          "type": "integer",
          "x-nullable": true
        },
        "ws": {
          "type": "string",
          "enum": [
            "auto",
            "h1",
            "h2"
          ],
          "x-display-name": "Relaying websocket stream protocol"
        }
      }
    },
    "runtime_server": {
      "description": "Runtime transient server properties",
      "type": "object",
      "title": "Runtime Server",
      "properties": {
        "address": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-nullable": false,
          "readOnly": true
        },
        "admin_state": {
          "type": "string",
          "enum": [
            "ready",
            "maint",
            "drain"
          ]
        },
        "id": {
          "type": "string",
          "readOnly": true
        },
        "name": {
          "type": "string",
          "readOnly": true
        },
        "operational_state": {
          "type": "string",
          "enum": [
            "up",
            "down",
            "stopping"
          ]
        },
        "port": {
          "type": "integer",
          "maximum": 65535,
          "minimum": 1,
          "x-nullable": true,
          "readOnly": true
        }
      },
      "example": {
        "address": "127.0.0.5",
        "admin_state": "ready",
        "operational_state": "up",
        "port": 80,
        "server_id": 1,
        "server_name": "web_server"
      }
    },
    "runtime_servers": {
      "description": "HAProxy runtime servers array",
      "type": "array",
      "title": "HAProxy Runtime Servers Array",
      "items": {
        "$ref": "#/definitions/runtime_server"
      }
    },
    "server": {
      "description": "HAProxy backend server configuration",
      "title": "Server",
      "allOf": [
        {
          "$ref": "#/definitions/server_params"
        },
        {
          "type": "object",
          "required": [
            "name",
            "address"
          ],
          "properties": {
            "address": {
              "type": "string",
              "pattern": "^[^\\s]+$",
              "x-nullable": false
            },
            "id": {
              "type": "integer",
              "x-nullable": true
            },
            "metadata": {
              "additionalProperties": {
                "type": "object"
              }
            },
            "name": {
              "type": "string",
              "pattern": "^[^\\s]+$",
              "x-nullable": false
            },
            "port": {
              "type": "integer",
              "maximum": 65535,
              "minimum": 1,
              "x-nullable": true
            }
          }
        }
      ],
      "additionalProperties": false,
      "example": {
        "address": "10.1.1.1",
        "name": "www",
        "port": 8080
      }
    },
    "server_params": {
      "type": "object",
      "properties": {
        "agent-addr": {
          "type": "string",
          "pattern": "^[^\\s]+$"
        },
        "agent-check": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-dependency": {
            "agent-port": {
              "required": true
            }
          }
        },
        "agent-inter": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-duration": true,
          "x-nullable": true
        },
        "agent-port": {
          "type": "integer",
          "maximum": 65535,
          "minimum": 1,
          "x-nullable": true
        },
        "agent-send": {
          "type": "string"
        },
        "allow_0rtt": {
          "type": "boolean"
        },
        "alpn": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-display-name": "ALPN Protocols"
        },
        "backup": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "check": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "check-send-proxy": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "check-sni": {
          "type": "string",
          "pattern": "^[^\\s]+$"
        },
        "check-ssl": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "check_alpn": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-display-name": "Protocols"
        },
        "check_proto": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-display-name": "Name"
        },
        "check_via_socks4": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "ciphers": {
          "type": "string",
          "x-dependency": {
            "ssl": {
              "value": "enabled"
            }
          }
        },
        "ciphersuites": {
          "type": "string",
          "x-dependency": {
            "ssl": {
              "value": "enabled"
            }
          }
        },
        "client_sigalgs": {
          "type": "string",
          "x-dependency": {
            "ssl": {
              "value": true
            }
          }
        },
        "cookie": {
          "type": "string",
          "pattern": "^[^\\s]+$"
        },
        "crl_file": {
          "type": "string",
          "x-dependency": {
            "ssl": {
              "value": "enabled"
            }
          }
        },
        "curves": {
          "type": "string",
          "x-dependency": {
            "ssl": {
              "value": true
            }
          }
        },
        "downinter": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-duration": true,
          "x-nullable": true
        },
        "error_limit": {
          "type": "integer",
          "x-display-name": "Error count"
        },
        "fall": {
          "type": "integer",
          "x-display-name": "Nr. of consecutive failed checks",
          "x-nullable": true
        },
        "fastinter": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-duration": true,
          "x-nullable": true
        },
        "force_sslv3": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "force_tlsv10": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "force_tlsv11": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "force_tlsv12": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "force_tlsv13": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "guid": {
          "type": "string",
          "pattern": "^[A-Za-z0-9-_.:]+$"
        },
        "hash_key": {
          "type": "string",
          "pattern": "^[^\\s]+$"
        },
        "health_check_address": {
          "type": "string",
          "pattern": "^[^\\s]+$"
        },
        "health_check_port": {
          "type": "integer",
          "maximum": 65535,
          "minimum": 1,
          "x-nullable": true
        },
        "init-addr": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-nullable": true
        },
        "inter": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-duration": true,
          "x-nullable": true
        },
        "log-bufsize": {
          "type": "integer",
          "x-nullable": true
        },
        "log_proto": {
          "type": "string",
          "enum": [
            "legacy",
            "octet-count"
          ]
        },
        "maintenance": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "max_reuse": {
          "type": "integer",
          "x-nullable": true
        },
        "maxconn": {
          "type": "integer",
          "x-display-name": "Max Concurrent Connections",
          "x-nullable": true
        },
        "maxqueue": {
          "type": "integer",
          "x-display-name": "Max Number of Connections",
          "x-nullable": true
        },
        "minconn": {
          "type": "integer",
          "x-nullable": true
        },
        "namespace": {
          "type": "string"
        },
        "no_sslv3": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "no_tlsv10": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "no_tlsv11": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "no_tlsv12": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "no_tlsv13": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "no_verifyhost": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "npn": {
          "type": "string",
          "x-dependency": {
            "ssl": {
              "value": "enabled"
            }
          }
        },
        "observe": {
          "type": "string",
          "enum": [
            "layer4",
            "layer7"
          ],
          "x-dependency": {
            "ssl": {
              "value": "enabled"
            }
          }
        },
        "on-error": {
          "type": "string",
          "enum": [
            "fastinter",
            "fail-check",
            "sudden-death",
            "mark-down"
          ]
        },
        "on-marked-down": {
          "type": "string",
          "enum": [
            "shutdown-sessions"
          ]
        },
        "on-marked-up": {
          "type": "string",
          "enum": [
            "shutdown-backup-sessions"
          ]
        },
        "pool_conn_name": {
          "type": "string",
          "pattern": "^[^\\s]+$"
        },
        "pool_low_conn": {
          "type": "integer",
          "x-nullable": true
        },
        "pool_max_conn": {
          "type": "integer",
          "x-nullable": true
        },
        "pool_purge_delay": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-duration": true,
          "x-nullable": true
        },
        "proto": {
          "type": "string",
          "pattern": "^[^\\s]+$"
        },
        "proxy-v2-options": {
          "type": "array",
          "items": {
            "type": "string",
            "enum": [
              "authority",
              "cert-cn",
              "cert-key",
              "cert-sig",
              "crc32c",
              "ssl",
              "ssl-cipher",
              "unique-id"
            ]
          },
          "x-omitempty": true
        },
        "redir": {
          "type": "string",
          "x-display-name": "Prefix"
        },
        "resolve-net": {
          "type": "string",
          "pattern": "^([A-Za-z0-9.:/]+)(,[A-Za-z0-9.:/]+)*$"
        },
        "resolve-prefer": {
          "type": "string",
          "enum": [
            "ipv4",
            "ipv6"
          ]
        },
        "resolve_opts": {
          "type": "string",
          "pattern": "^(allow-dup-ip|ignore-weight|prevent-dup-ip)(,(allow-dup-ip|ignore-weight|prevent-dup-ip))*$"
        },
        "resolvers": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dynamic-enum": {
            "operation": "getResolvers",
            "property": "name"
          }
        },
        "rise": {
          "type": "integer",
          "x-nullable": true
        },
        "send-proxy": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "send-proxy-v2": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "send_proxy_v2_ssl": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "send_proxy_v2_ssl_cn": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "set-proxy-v2-tlv-fmt": {
          "type": "object",
          "required": [
            "id",
            "value"
          ],
          "properties": {
            "id": {
              "type": "string"
            },
            "value": {
              "type": "string"
            }
          }
        },
        "shard": {
          "type": "integer"
        },
        "sigalgs": {
          "type": "string",
          "x-dependency": {
            "ssl": {
              "value": true
            }
          }
        },
        "slowstart": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-duration": true,
          "x-nullable": true
        },
        "sni": {
          "type": "string",
          "pattern": "^[^\\s]+$"
        },
        "socks4": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "check-via-socks4": {
              "required": true
            }
          }
        },
        "source": {
          "type": "string"
        },
        "ssl": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "ssl_cafile": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "ssl": {
              "value": "enabled"
            }
          },
          "x-display-name": "SSL CA File"
        },
        "ssl_certificate": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "ssl": {
              "value": "enabled"
            }
          }
        },
        "ssl_max_ver": {
          "type": "string",
          "enum": [
            "SSLv3",
            "TLSv1.0",
            "TLSv1.1",
            "TLSv1.2",
            "TLSv1.3"
          ]
        },
        "ssl_min_ver": {
          "type": "string",
          "enum": [
            "SSLv3",
            "TLSv1.0",
            "TLSv1.1",
            "TLSv1.2",
            "TLSv1.3"
          ]
        },
        "ssl_reuse": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "stick": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "tcp_ut": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-duration": true,
          "x-nullable": true
        },
        "tfo": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "tls_tickets": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-dependency": {
            "ssl": {
              "value": "enabled"
            }
          }
        },
        "track": {
          "type": "string"
        },
        "verify": {
          "type": "string",
          "enum": [
            "none",
            "required"
          ],
          "x-dependency": {
            "ssl": {
              "value": "enabled"
            }
          }
        },
        "verifyhost": {
          "type": "string",
          "x-dependency": {
            "ssl": {
              "value": "enabled"
            },
            "verify": {
              "value": "required"
            }
          }
        },
        "weight": {
          "type": "integer",
          "x-nullable": true
        },
        "ws": {
          "type": "string",
          "enum": [
            "auto",
            "h1",
            "h2"
          ],
          "x-display-name": "Relaying websocket stream protocol"
        }
      }
    },
    "server_switching_rule": {
      "description": "HAProxy server switching rule configuration (corresponds to use-server directive)",
      "type": "object",
      "title": "Server Switching Rule",
      "required": [
        "target_server"
      ],
      "properties": {
        "cond": {
          "type": "string",
          "enum": [
            "if",
            "unless"
          ],
          "x-display-name": "Condition"
        },
        "cond_test": {
          "type": "string",
          "x-dependency": {
            "cond": {
              "required": true
            }
          },
          "x-display-name": "Condition Test",
          "x-dynamic-enum": {
            "freeFormat": true,
            "operation": "getACLs",
            "property": "acl_name"
          }
        },
        "target_server": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dynamic-enum": {
            "operation": "getServers",
            "property": "name"
          },
          "x-nullable": false
        }
      },
      "additionalProperties": false,
      "example": {
        "cond": "if",
        "cond_test": "{ req_ssl_sni -i www.example.com }",
        "target_server": "www"
      }
    },
    "server_switching_rules": {
      "description": "HAProxy backend server switching rules array (corresponds to use-server directives)",
      "type": "array",
      "title": "Server Switching Rules Array",
      "items": {
        "$ref": "#/definitions/server_switching_rule"
      }
    },
    "server_template": {
      "description": "Set a template to initialize servers with shared parameters.",
      "title": "Server template",
      "allOf": [
        {
          "$ref": "#/definitions/server_params"
        },
        {
          "type": "object",
          "required": [
            "prefix",
            "num_or_range",
            "fqdn"
          ],
          "properties": {
            "fqdn": {
              "type": "string",
              "x-nullable": false
            },
            "id": {
              "type": "integer",
              "x-nullable": true
            },
            "num_or_range": {
              "type": "string",
              "x-nullable": false
            },
            "port": {
              "type": "integer",
              "maximum": 65535,
              "minimum": 1,
              "x-nullable": true
            },
            "prefix": {
              "type": "string",
              "pattern": "^[^\\s]+$",
              "x-nullable": false
            }
          }
        }
      ],
      "additionalProperties": false,
      "example": {
        "fqdn": "google.com",
        "num_or_range": "1-3",
        "port": 80,
        "prefix": "srv"
      }
    },
    "server_templates": {
      "description": "HAProxy backend server templates array",
      "type": "array",
      "title": "Server templates",
      "items": {
        "$ref": "#/definitions/server_template"
      }
    },
    "servers": {
      "description": "HAProxy backend servers array",
      "type": "array",
      "title": "Servers",
      "items": {
        "$ref": "#/definitions/server"
      }
    },
    "site": {
      "description": "Site configuration. Sites are considered as one service and all farms connected to that service.\nFarms are connected to service using use-backend and default_backend directives. Sites let you\nconfigure simple HAProxy configurations, for more advanced options use /haproxy/configuration\nendpoints.\n",
      "type": "object",
      "title": "Site",
      "required": [
        "name"
      ],
      "properties": {
        "farms": {
          "type": "array",
          "items": {
            "type": "object",
            "required": [
              "name",
              "use_as"
            ],
            "properties": {
              "balance": {
                "$ref": "#/definitions/balance"
              },
              "cond": {
                "type": "string",
                "enum": [
                  "if",
                  "unless"
                ],
                "x-dependency": {
                  "use_as": {
                    "required": true,
                    "value": "conditional"
                  }
                },
                "x-display-name": "Condition"
              },
              "cond_test": {
                "type": "string",
                "x-dependency": {
                  "use_as": {
                    "required": true,
                    "value": "conditional"
                  }
                },
                "x-display-name": "Condition Test"
              },
              "forwardfor": {
                "$ref": "#/definitions/forwardfor"
              },
              "mode": {
                "type": "string",
                "enum": [
                  "http",
                  "tcp"
                ]
              },
              "name": {
                "type": "string",
                "pattern": "^[A-Za-z0-9-_.:]+$",
                "x-nullable": false
              },
              "servers": {
                "type": "array",
                "items": {
                  "$ref": "#/definitions/server"
                },
                "x-omitempty": true
              },
              "use_as": {
                "type": "string",
                "enum": [
                  "default",
                  "conditional"
                ],
                "x-nullable": false
              }
            },
            "x-go-name": "SiteFarm"
          },
          "x-omitempty": true
        },
        "name": {
          "type": "string",
          "pattern": "^[A-Za-z0-9-_.:]+$",
          "x-nullable": false
        },
        "service": {
          "type": "object",
          "properties": {
            "http_connection_mode": {
              "type": "string",
              "enum": [
                "http-tunnel",
                "httpclose",
                "forced-close",
                "http-server-close",
                "http-keep-alive"
              ],
              "x-dependency": {
                "mode": {
                  "value": "http"
                }
              },
              "x-display-name": "HTTP Connection Mode"
            },
            "listeners": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/bind"
              },
              "x-omitempty": true
            },
            "maxconn": {
              "type": "integer",
              "x-display-name": "Max Connections",
              "x-nullable": true
            },
            "mode": {
              "type": "string",
              "enum": [
                "http",
                "tcp"
              ]
            }
          }
        }
      },
      "additionalProperties": false,
      "example": {
        "farms": [
          {
            "balance": {
              "algorithm": "roundrobin"
            },
            "mode": "http",
            "name": "www_backend",
            "servers": [
              {
                "address": "127.0.1.1",
                "name": "www_server",
                "port": 4567
              },
              {
                "address": "127.0.1.2",
                "name": "www_server_new",
                "port": 4567
              }
            ],
            "use_as": "default"
          }
        ],
        "name": "test_site",
        "service": {
          "http_connection_mode": "httpclose",
          "maxconn": 2000,
          "mode": "http"
        }
      }
    },
    "sites": {
      "description": "Sites array. Sites are considered as one service and all farms connected to that service.\nFarms are connected to service using use-backend and default_backend directives. Sites let you\nconfigure simple HAProxy configurations, for more advanced options use /haproxy/configuration\nendpoints.\n",
      "type": "array",
      "title": "Sites",
      "items": {
        "$ref": "#/definitions/site"
      }
    },
    "smtpchk_params": {
      "type": "object",
      "properties": {
        "domain": {
          "type": "string"
        },
        "hello": {
          "type": "string"
        }
      }
    },
    "source": {
      "type": "object",
      "required": [
        "address"
      ],
      "properties": {
        "address": {
          "type": "string"
        },
        "address_second": {
          "type": "string"
        },
        "hdr": {
          "type": "string",
          "x-dependency": {
            "usesrc": {
              "value": "hdr_ip"
            }
          }
        },
        "interface": {
          "type": "string"
        },
        "occ": {
          "type": "string",
          "x-dependency": {
            "usesrc": {
              "value": "hdr_ip"
            }
          }
        },
        "port": {
          "type": "integer",
          "maximum": 65535,
          "minimum": 1
        },
        "port_second": {
          "type": "integer",
          "maximum": 65535,
          "minimum": 1
        },
        "usesrc": {
          "type": "string",
          "enum": [
            "address",
            "client",
            "clientip",
            "hdr_ip"
          ]
        }
      }
    },
    "spoe_agent": {
      "description": "SPOE agent configuration",
      "type": "object",
      "title": "SPOE agent",
      "required": [
        "name"
      ],
      "properties": {
        "async": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "continue-on-error": {
          "type": "string",
          "enum": [
            "enabled"
          ]
        },
        "dontlog-normal": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "engine-name": {
          "type": "string"
        },
        "force-set-var": {
          "type": "string",
          "enum": [
            "enabled"
          ]
        },
        "groups": {
          "type": "string"
        },
        "hello_timeout": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-duration": true
        },
        "idle_timeout": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-duration": true
        },
        "log": {
          "$ref": "#/definitions/log_targets"
        },
        "max-frame-size": {
          "type": "integer"
        },
        "max-waiting-frames": {
          "type": "integer"
        },
        "maxconnrate": {
          "type": "integer"
        },
        "maxerrrate": {
          "type": "integer"
        },
        "messages": {
          "type": "string"
        },
        "name": {
          "type": "string"
        },
        "option_set-on-error": {
          "type": "string",
          "pattern": "^[A-Za-z0-9-_.]+$"
        },
        "option_set-process-time": {
          "type": "string",
          "pattern": "^[A-Za-z0-9-_.]+$"
        },
        "option_set-total-time": {
          "type": "string",
          "pattern": "^[A-Za-z0-9-_.]+$"
        },
        "option_var-prefix": {
          "type": "string",
          "pattern": "^[A-Za-z0-9-_.]+$"
        },
        "pipelining": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "processing_timeout": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-duration": true
        },
        "register-var-names": {
          "type": "string"
        },
        "send-frag-payload": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ]
        },
        "use-backend": {
          "type": "string"
        }
      }
    },
    "spoe_agents": {
      "description": "SPOE Agents of one scope in SPOE file",
      "type": "array",
      "title": "SPOE Agents",
      "items": {
        "$ref": "#/definitions/spoe_agent"
      }
    },
    "spoe_files": {
      "description": "SPOE files",
      "type": "array",
      "title": "SPOE files",
      "items": {
        "type": "string"
      },
      "x-omitempty": true
    },
    "spoe_group": {
      "description": "SPOE group section configuration",
      "type": "object",
      "title": "SPOE group",
      "required": [
        "name"
      ],
      "properties": {
        "messages": {
          "type": "string"
        },
        "name": {
          "type": "string"
        }
      }
    },
    "spoe_groups": {
      "description": "SPOE Groups of one scope in SPOE file",
      "type": "array",
      "title": "SPOE Groups",
      "items": {
        "$ref": "#/definitions/spoe_group"
      }
    },
    "spoe_message": {
      "description": "SPOE message section configuration",
      "type": "object",
      "title": "SPOE message",
      "required": [
        "name"
      ],
      "properties": {
        "acl": {
          "$ref": "#/definitions/acls"
        },
        "args": {
          "type": "string"
        },
        "event": {
          "type": "object",
          "required": [
            "name"
          ],
          "properties": {
            "cond": {
              "type": "string",
              "enum": [
                "if",
                "unless"
              ],
              "x-display-name": "Condition"
            },
            "cond_test": {
              "type": "string",
              "x-dependency": {
                "cond": {
                  "required": true
                }
              },
              "x-display-name": "Condition Test"
            },
            "name": {
              "type": "string",
              "enum": [
                "on-backend-http-request",
                "on-backend-tcp-request",
                "on-client-session",
                "on-frontend-http-request",
                "on-frontend-tcp-request",
                "on-http-response",
                "on-server-session",
                "on-tcp-response"
              ]
            }
          }
        },
        "name": {
          "type": "string"
        }
      }
    },
    "spoe_messages": {
      "description": "SPOE Messages of one scope in SPOE file",
      "type": "array",
      "title": "SPOE Messages",
      "items": {
        "$ref": "#/definitions/spoe_message"
      }
    },
    "spoe_scope": {
      "description": "SPOE scope name",
      "type": "string",
      "title": "SPOE scope"
    },
    "spoe_scopes": {
      "description": "All SPOE Scopes",
      "type": "array",
      "title": "SPOE Scopes",
      "items": {
        "$ref": "#/definitions/spoe_scope"
      }
    },
    "spoe_transaction": {
      "description": "SPOE configuration transaction",
      "type": "object",
      "title": "SPOE configuration transaction",
      "properties": {
        "_version": {
          "type": "integer"
        },
        "id": {
          "type": "string",
          "pattern": "^[^\\s]+$"
        },
        "status": {
          "type": "string",
          "enum": [
            "failed",
            "in_progress",
            "success"
          ]
        }
      },
      "example": {
        "_version": 2,
        "id": "273e3385-2d0c-4fb1-aa27-93cbb31ff203",
        "status": "in_progress"
      }
    },
    "spoe_transactions": {
      "description": "SPOE Configuration transactions array",
      "type": "array",
      "title": "SPOE Transactions array",
      "items": {
        "$ref": "#/definitions/spoe_transaction"
      }
    },
    "ssl_cert_entry": {
      "description": "One SSL/TLS certificate",
      "type": "object",
      "title": "One SSL Certificate Entry",
      "properties": {
        "algorithm": {
          "type": "string"
        },
        "chain_issuer": {
          "type": "string"
        },
        "chain_subject": {
          "type": "string"
        },
        "issuer": {
          "type": "string"
        },
        "not_after": {
          "type": "string",
          "format": "date"
        },
        "not_before": {
          "type": "string",
          "format": "date"
        },
        "serial": {
          "type": "string"
        },
        "sha1_finger_print": {
          "type": "string"
        },
        "status": {
          "type": "string"
        },
        "storage_name": {
          "type": "string"
        },
        "subject": {
          "type": "string"
        },
        "subject_alternative_names": {
          "type": "array",
          "items": {
            "type": "string"
          },
          "x-omitempty": true
        }
      }
    },
    "ssl_certificate": {
      "description": "A file containing one or more SSL/TLS certificates and keys",
      "type": "object",
      "title": "SSL File",
      "properties": {
        "algorithm": {
          "type": "string"
        },
        "authority_key_id": {
          "type": "string"
        },
        "description": {
          "type": "string"
        },
        "domains": {
          "type": "string",
          "x-omitempty": true,
          "readOnly": true
        },
        "file": {
          "type": "string"
        },
        "ip_addresses": {
          "type": "string",
          "x-omitempty": true,
          "readOnly": true
        },
        "issuers": {
          "type": "string",
          "x-omitempty": true,
          "readOnly": true
        },
        "not_after": {
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\"",
          "x-nullable": true,
          "readOnly": true
        },
        "not_before": {
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\"",
          "x-nullable": true,
          "readOnly": true
        },
        "serial": {
          "type": "string"
        },
        "sha1_finger_print": {
          "type": "string"
        },
        "sha256_finger_print": {
          "type": "string"
        },
        "size": {
          "description": "File size in bytes.",
          "type": "integer",
          "x-nullable": true,
          "readOnly": true
        },
        "storage_name": {
          "type": "string"
        },
        "subject": {
          "type": "string"
        },
        "subject_alternative_names": {
          "type": "string"
        },
        "subject_key_id": {
          "type": "string"
        }
      }
    },
    "ssl_certificates": {
      "description": "Array of ssl certificate files",
      "type": "array",
      "title": "SSL Files Array",
      "items": {
        "$ref": "#/definitions/ssl_certificate"
      }
    },
    "ssl_options": {
      "type": "object",
      "properties": {
        "ca_base": {
          "type": "string",
          "x-display-name": "SSL CA Certificates Base Directory"
        },
        "crt_base": {
          "type": "string",
          "x-display-name": "SSL Certificates Base Directory"
        },
        "default_bind_ciphers": {
          "type": "string",
          "x-display-name": "SSL Default Bind Ciphers"
        },
        "default_bind_ciphersuites": {
          "type": "string",
          "x-display-name": "SSL Default Bind Ciphersuites"
        },
        "default_bind_client_sigalgs": {
          "type": "string",
          "x-display-name": "SSL Default Bind Client Sigalgs"
        },
        "default_bind_curves": {
          "type": "string",
          "x-display-name": "SSL Default Bind Curves"
        },
        "default_bind_options": {
          "type": "string",
          "x-display-name": "SSL Default Bind Options"
        },
        "default_bind_sigalgs": {
          "type": "string",
          "x-display-name": "SSL Default Bind Sigalgs"
        },
        "default_server_ciphers": {
          "type": "string",
          "x-display-name": "SSL Default Server Ciphers"
        },
        "default_server_ciphersuites": {
          "type": "string",
          "x-display-name": "SSL Default Server Ciphersuites"
        },
        "default_server_client_sigalgs": {
          "type": "string",
          "x-display-name": "SSL Default Server Client Sigalgs"
        },
        "default_server_curves": {
          "type": "string",
          "x-display-name": "SSL Default Server Curves"
        },
        "default_server_options": {
          "type": "string",
          "x-display-name": "SSL Default Server Options"
        },
        "default_server_sigalgs": {
          "type": "string",
          "x-display-name": "SSL Default Server Sigalgs"
        },
        "dh_param_file": {
          "type": "string"
        },
        "engines": {
          "type": "array",
          "items": {
            "type": "object",
            "required": [
              "name"
            ],
            "properties": {
              "algorithms": {
                "type": "string",
                "x-display-name": "Algorithms",
                "x-nullable": true
              },
              "name": {
                "type": "string",
                "x-display-name": "Name"
              }
            },
            "x-go-name": "SslEngine"
          },
          "x-display-name": "SSL Engines",
          "x-go-name": "SslEngines",
          "x-omitempty": true
        },
        "issuers_chain_path": {
          "type": "string"
        },
        "load_extra_files": {
          "type": "string",
          "x-display-name": "SSL Load Extra Files"
        },
        "maxsslconn": {
          "type": "integer",
          "x-display-name": "Maximum per-process number of concurrent SSL connections"
        },
        "maxsslrate": {
          "type": "integer",
          "x-display-name": "Maximum per-process number of SSL sessions per second"
        },
        "mode_async": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "Asynchronous TLS I/O operations"
        },
        "propquery": {
          "type": "string",
          "x-display-name": "SSL Query String Property"
        },
        "provider": {
          "type": "string",
          "x-display-name": "SSL Provider"
        },
        "provider_path": {
          "type": "string",
          "x-display-name": "SSL Provider Path"
        },
        "security_level": {
          "type": "integer",
          "maximum": 5,
          "x-nullable": true
        },
        "server_verify": {
          "type": "string",
          "enum": [
            "none",
            "required"
          ],
          "x-display-name": "Verify server certificates"
        },
        "skip_self_issued_ca": {
          "type": "boolean",
          "x-display-name": "Self issued CA, aka x509 root CA"
        }
      }
    },
    "stats_auth": {
      "type": "object",
      "required": [
        "user",
        "passwd"
      ],
      "properties": {
        "passwd": {
          "type": "string"
        },
        "user": {
          "type": "string"
        }
      }
    },
    "stats_http_request": {
      "type": "object",
      "required": [
        "type"
      ],
      "properties": {
        "cond": {
          "type": "string"
        },
        "cond_test": {
          "type": "string",
          "x-dependency": {
            "cond": {
              "required": true
            }
          }
        },
        "realm": {
          "type": "string",
          "x-dependency": {
            "type": {
              "value": "auth"
            }
          }
        },
        "type": {
          "type": "string",
          "enum": [
            "allow",
            "deny",
            "auth"
          ]
        }
      }
    },
    "stats_options": {
      "type": "object",
      "properties": {
        "stats_admin": {
          "type": "boolean",
          "x-display-name": "Stats Admin"
        },
        "stats_admin_cond": {
          "type": "string",
          "enum": [
            "if",
            "unless"
          ],
          "x-dependency": {
            "stats_admin": {
              "required": true,
              "value": true
            }
          },
          "x-display-name": "Stats Admin Condition"
        },
        "stats_admin_cond_test": {
          "type": "string",
          "x-dependency": {
            "stats_admin_cond": {
              "required": true
            }
          },
          "x-display-name": "Stats Admin Condition Test",
          "x-dynamic-enum": {
            "freeFormat": true,
            "operation": "getACLs",
            "property": "acl_name"
          }
        },
        "stats_auths": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/stats_auth"
          },
          "x-display-name": "Stats Auths",
          "x-omitempty": true
        },
        "stats_enable": {
          "type": "boolean",
          "x-display-name": "Stats Enable"
        },
        "stats_hide_version": {
          "type": "boolean",
          "x-display-name": "Stats Hide Version"
        },
        "stats_http_requests": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/stats_http_request"
          },
          "x-display-name": "Stats HTTP Requests",
          "x-omitempty": true
        },
        "stats_maxconn": {
          "type": "integer",
          "minimum": 1
        },
        "stats_realm": {
          "type": "boolean",
          "x-display-name": "Stats Realm"
        },
        "stats_realm_realm": {
          "type": "string",
          "x-dependency": {
            "stats_realm": {
              "required": true,
              "value": true
            }
          },
          "x-nullable": true
        },
        "stats_refresh_delay": {
          "type": "integer",
          "x-default-unit": "s",
          "x-duration": true,
          "x-nullable": true
        },
        "stats_show_desc": {
          "type": "string",
          "x-nullable": true
        },
        "stats_show_legends": {
          "type": "boolean",
          "x-display-name": "Stats Show Legends"
        },
        "stats_show_modules": {
          "type": "boolean",
          "x-display-name": "Stats Show Modules"
        },
        "stats_show_node_name": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-nullable": true,
          "x-omitempty": false
        },
        "stats_uri_prefix": {
          "type": "string",
          "pattern": "^[^\\s]+$"
        }
      }
    },
    "stick_rule": {
      "description": "Define a pattern used to create an entry in a stickiness table or matching condition or associate a user to a server.",
      "type": "object",
      "title": "Stick Rule",
      "required": [
        "type",
        "pattern"
      ],
      "properties": {
        "cond": {
          "type": "string",
          "enum": [
            "if",
            "unless"
          ],
          "x-display-name": "Condition"
        },
        "cond_test": {
          "type": "string",
          "x-dependency": {
            "cond": {
              "required": true
            }
          },
          "x-display-name": "Condition Test",
          "x-dynamic-enum": {
            "freeFormat": true,
            "operation": "getACLs",
            "property": "acl_name"
          }
        },
        "pattern": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-nullable": false
        },
        "table": {
          "type": "string",
          "pattern": "^[^\\s]+$"
        },
        "type": {
          "type": "string",
          "enum": [
            "match",
            "on",
            "store-request",
            "store-response"
          ],
          "x-nullable": false
        }
      },
      "additionalProperties": false,
      "example": {
        "pattern": "src",
        "type": "match"
      }
    },
    "stick_rules": {
      "description": "HAProxy backend stick rules array (corresponds to stick store-request, stick match, stick on, stick store-response)",
      "type": "array",
      "title": "Stick Rules Array",
      "items": {
        "$ref": "#/definitions/stick_rule"
      }
    },
    "stick_table": {
      "description": "Stick Table Information",
      "type": "object",
      "title": "Stick Table",
      "properties": {
        "fields": {
          "type": "array",
          "items": {
            "type": "object",
            "properties": {
              "field": {
                "type": "string",
                "enum": [
                  "bytes_in_cnt",
                  "bytes_in_rate",
                  "bytes_out_cnt",
                  "bytes_out_rate",
                  "conn_cnt",
                  "conn_cur",
                  "conn_rate",
                  "gpc0",
                  "gpc0_rate",
                  "gpc1",
                  "gpc1_rate",
                  "gpt0",
                  "http_req_cnt",
                  "http_req_rate",
                  "http_err_cnt",
                  "http_err_rate",
                  "server_id",
                  "sess_cnt",
                  "sess_rate"
                ]
              },
              "period": {
                "type": "integer",
                "x-dependency": {
                  "type": {
                    "value": "rate"
                  }
                }
              },
              "type": {
                "type": "string",
                "enum": [
                  "rate",
                  "counter"
                ]
              }
            },
            "x-go-name": "StickTableField"
          },
          "x-omitempty": true
        },
        "name": {
          "type": "string"
        },
        "size": {
          "type": "integer",
          "x-nullable": true
        },
        "type": {
          "type": "string",
          "enum": [
            "ip",
            "ipv6",
            "integer",
            "string",
            "binary"
          ]
        },
        "used": {
          "type": "integer",
          "x-nullable": true
        }
      }
    },
    "stick_table_entries": {
      "description": "Entries of one runtime stick table",
      "type": "array",
      "title": "Stick Tables Entries",
      "items": {
        "$ref": "#/definitions/stick_table_entry"
      }
    },
    "stick_table_entry": {
      "description": "One entry in stick table",
      "type": "object",
      "title": "Stick Table Entry",
      "properties": {
        "bytes_in_cnt": {
          "type": "integer",
          "x-nullable": true
        },
        "bytes_in_rate": {
          "type": "integer",
          "x-nullable": true
        },
        "bytes_out_cnt": {
          "type": "integer",
          "x-nullable": true
        },
        "bytes_out_rate": {
          "type": "integer",
          "x-nullable": true
        },
        "conn_cnt": {
          "type": "integer",
          "x-nullable": true
        },
        "conn_cur": {
          "type": "integer",
          "x-nullable": true
        },
        "conn_rate": {
          "type": "integer",
          "x-nullable": true
        },
        "exp": {
          "type": "integer",
          "x-nullable": true
        },
        "gpc0": {
          "type": "integer",
          "x-nullable": true
        },
        "gpc0_rate": {
          "type": "integer",
          "x-nullable": true
        },
        "gpc1": {
          "type": "integer",
          "x-nullable": true
        },
        "gpc1_rate": {
          "type": "integer",
          "x-nullable": true
        },
        "gpt0": {
          "type": "integer",
          "x-nullable": true
        },
        "http_err_cnt": {
          "type": "integer",
          "x-nullable": true
        },
        "http_err_rate": {
          "type": "integer",
          "x-nullable": true
        },
        "http_req_cnt": {
          "type": "integer",
          "x-nullable": true
        },
        "http_req_rate": {
          "type": "integer",
          "x-nullable": true
        },
        "id": {
          "type": "string"
        },
        "key": {
          "type": "string"
        },
        "server_id": {
          "type": "integer",
          "x-nullable": true
        },
        "sess_cnt": {
          "type": "integer",
          "x-nullable": true
        },
        "sess_rate": {
          "type": "integer",
          "x-nullable": true
        },
        "use": {
          "type": "boolean"
        }
      }
    },
    "stick_tables": {
      "description": "Array of runtime stick tables",
      "type": "array",
      "title": "Stick Tables Array",
      "items": {
        "$ref": "#/definitions/stick_table"
      }
    },
    "table": {
      "type": "object",
      "properties": {
        "expire": {
          "type": "string",
          "pattern": "^\\d+(ms|s|m|h|d)?$",
          "x-default-unit": "ms",
          "x-duration": true,
          "x-nullable": true
        },
        "name": {
          "type": "string",
          "x-nullable": false
        },
        "no_purge": {
          "type": "boolean",
          "x-display-name": "No Purge"
        },
        "size": {
          "type": "string",
          "pattern": "^\\d+(k|K|m|M|g|G)?$",
          "x-size": true
        },
        "store": {
          "type": "string"
        },
        "type": {
          "type": "string",
          "enum": [
            "ip",
            "integer",
            "string",
            "binary"
          ]
        },
        "type_len": {
          "type": "integer",
          "x-display-name": "Type",
          "x-nullable": true
        },
        "write_to": {
          "type": "string",
          "x-nullable": true
        }
      }
    },
    "tables": {
      "description": "HAProxy table array",
      "type": "array",
      "title": "Tables",
      "items": {
        "$ref": "#/definitions/table"
      }
    },
    "tcp_check": {
      "type": "object",
      "title": "TCP Check",
      "required": [
        "action"
      ],
      "properties": {
        "action": {
          "type": "string",
          "enum": [
            "comment",
            "connect",
            "expect",
            "send",
            "send-lf",
            "send-binary",
            "send-binary-lf",
            "set-var",
            "set-var-fmt",
            "unset-var"
          ],
          "x-nullable": false
        },
        "addr": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "action": {
              "value": "connect"
            }
          },
          "x-nullable": false
        },
        "alpn": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "action": {
              "value": "connect"
            }
          },
          "x-display-name": "ALPN Protocols",
          "x-nullable": false
        },
        "check_comment": {
          "type": "string",
          "x-dependency": {
            "action": {
              "value": [
                "connect",
                "expect",
                "send",
                "send-lf",
                "send-binary",
                "send-binary-lf"
              ]
            }
          },
          "x-nullable": false
        },
        "data": {
          "type": "string",
          "x-dependency": {
            "action": {
              "required": true,
              "value": "send"
            }
          }
        },
        "default": {
          "type": "boolean",
          "x-dependency": {
            "action": {
              "value": "connect"
            }
          }
        },
        "error_status": {
          "type": "string",
          "enum": [
            "L7OKC",
            "L7RSP",
            "L7STS",
            "L6RSP",
            "L4CON"
          ],
          "x-dependency": {
            "action": {
              "value": "expect"
            }
          }
        },
        "exclamation_mark": {
          "type": "boolean",
          "x-dependency": {
            "action": {
              "value": "expect"
            }
          },
          "x-display-name": "Expect Exclamation Mark"
        },
        "fmt": {
          "type": "string",
          "x-dependency": {
            "action": {
              "required": true,
              "value": "send-lf"
            }
          }
        },
        "hex_fmt": {
          "type": "string",
          "x-dependency": {
            "action": {
              "required": true,
              "value": "send-binary-lf"
            }
          }
        },
        "hex_string": {
          "type": "string",
          "x-dependency": {
            "action": {
              "required": true,
              "value": "send-binary"
            }
          }
        },
        "linger": {
          "type": "boolean",
          "x-dependency": {
            "action": {
              "value": "connect"
            }
          }
        },
        "match": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "enum": [
            "string",
            "rstring",
            "string-lf",
            "binary",
            "rbinary",
            "binary-lf"
          ],
          "x-dependency": {
            "action": {
              "required": true,
              "value": "expect"
            }
          },
          "x-display-name": "Expect Match"
        },
        "min_recv": {
          "type": "integer",
          "x-dependency": {
            "action": {
              "value": "expect"
            }
          }
        },
        "ok_status": {
          "type": "string",
          "enum": [
            "L7OK",
            "L7OKC",
            "L6OK",
            "L4OK"
          ],
          "x-dependency": {
            "action": {
              "value": "expect"
            }
          }
        },
        "on_error": {
          "type": "string",
          "x-dependency": {
            "action": {
              "value": "expect"
            }
          }
        },
        "on_success": {
          "type": "string",
          "x-dependency": {
            "action": {
              "value": "expect"
            }
          }
        },
        "pattern": {
          "type": "string",
          "x-dependency": {
            "action": {
              "required": true,
              "value": "expect"
            }
          }
        },
        "port": {
          "type": "integer",
          "maximum": 65535,
          "minimum": 1,
          "x-dependency": {
            "action": {
              "value": "connect"
            }
          },
          "x-nullable": true
        },
        "port_string": {
          "type": "string",
          "x-dependency": {
            "action": {
              "value": "connect"
            }
          }
        },
        "proto": {
          "type": "string",
          "x-dependency": {
            "action": {
              "value": "connect"
            }
          },
          "x-nullable": false
        },
        "send_proxy": {
          "type": "boolean",
          "x-dependency": {
            "action": {
              "value": "connect"
            }
          }
        },
        "sni": {
          "type": "string",
          "x-dependency": {
            "action": {
              "value": "connect"
            }
          },
          "x-nullable": false
        },
        "ssl": {
          "type": "boolean",
          "x-dependency": {
            "action": {
              "value": "connect"
            }
          }
        },
        "status-code": {
          "type": "string",
          "x-dependency": {
            "action": {
              "value": "expect"
            }
          }
        },
        "tout_status": {
          "type": "string",
          "enum": [
            "L7TOUT",
            "L6TOUT",
            "L4TOUT"
          ],
          "x-dependency": {
            "action": {
              "value": "expect"
            }
          }
        },
        "var_expr": {
          "type": "string",
          "x-dependency": {
            "action": {
              "required": true,
              "value": [
                "set-var"
              ]
            }
          },
          "x-display-name": "Var Expression"
        },
        "var_fmt": {
          "type": "string",
          "x-dependency": {
            "action": {
              "required": true,
              "value": [
                "set-var-fmt"
              ]
            }
          },
          "x-display-name": "Var Log format"
        },
        "var_name": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "action": {
              "required": true,
              "value": [
                "set-var",
                "set-var-fmt",
                "unset-var"
              ]
            }
          }
        },
        "var_scope": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "action": {
              "required": true,
              "value": [
                "set-var",
                "set-var-fmt",
                "unset-var"
              ]
            }
          }
        },
        "via_socks4": {
          "type": "boolean",
          "x-dependency": {
            "action": {
              "value": "connect"
            }
          }
        }
      }
    },
    "tcp_checks": {
      "type": "array",
      "title": "TCP Checks Array",
      "items": {
        "$ref": "#/definitions/tcp_check"
      }
    },
    "tcp_request_rule": {
      "description": "HAProxy TCP Request Rule configuration (corresponds to tcp-request)",
      "type": "object",
      "title": "TCP Request Rule",
      "required": [
        "type"
      ],
      "properties": {
        "action": {
          "type": "string",
          "enum": [
            "accept",
            "attach-srv",
            "capture",
            "do-resolve",
            "expect-netscaler-cip",
            "expect-proxy",
            "lua",
            "reject",
            "sc-add-gpc",
            "sc-inc-gpc",
            "sc-inc-gpc0",
            "sc-inc-gpc1",
            "sc-set-gpt",
            "sc-set-gpt0",
            "send-spoe-group",
            "set-bandwidth-limit",
            "set-bc-mark",
            "set-bc-tos",
            "set-dst-port",
            "set-dst",
            "set-fc-mark",
            "set-fc-tos",
            "set-log-level",
            "set-mark",
            "set-nice",
            "set-priority-class",
            "set-priority-offset",
            "set-src",
            "set-src-port",
            "set-tos",
            "set-var",
            "set-var-fmt",
            "silent-drop",
            "switch-mode",
            "track-sc",
            "unset-var",
            "use-service"
          ],
          "x-dependency": {
            "type": {
              "required": true,
              "value": [
                "connection",
                "content",
                "session"
              ]
            }
          },
          "x-nullable": false
        },
        "bandwidth_limit_limit": {
          "type": "string",
          "x-dependency": {
            "action": {
              "value": "set-bandwidth-limit"
            },
            "type": {
              "value": "content"
            }
          },
          "x-display-name": "Standard HAProxy expression"
        },
        "bandwidth_limit_name": {
          "type": "string",
          "x-dependency": {
            "action": {
              "value": "set-bandwidth-limit"
            },
            "type": {
              "value": "content"
            }
          },
          "x-display-name": "Bandwidth limit name"
        },
        "bandwidth_limit_period": {
          "type": "string",
          "x-dependency": {
            "action": {
              "value": "set-bandwidth-limit"
            },
            "type": {
              "value": "content"
            }
          },
          "x-display-name": "Standard HAProxy expression"
        },
        "capture_len": {
          "type": "integer",
          "x-dependency": {
            "action": {
              "required": true,
              "value": "capture"
            },
            "type": {
              "required": true,
              "value": [
                "connection",
                "content"
              ]
            }
          },
          "x-display-name": "Capture Length"
        },
        "capture_sample": {
          "type": "string",
          "pattern": "^(?:[A-Za-z]+\\(\"([A-Za-z\\s]+)\"\\)|[A-Za-z]+)",
          "x-dependency": {
            "action": {
              "required": true,
              "value": "capture"
            },
            "type": {
              "required": true,
              "value": [
                "connection",
                "content"
              ]
            }
          },
          "x-display-name": "Capture Sample"
        },
        "cond": {
          "type": "string",
          "enum": [
            "if",
            "unless"
          ],
          "x-dependency": {
            "type": {
              "value": [
                "connection",
                "content",
                "session"
              ]
            }
          },
          "x-display-name": "Condition"
        },
        "cond_test": {
          "type": "string",
          "x-dependency": {
            "cond": {
              "required": true
            },
            "type": {
              "required": true,
              "value": [
                "connection",
                "content",
                "session"
              ]
            }
          },
          "x-display-name": "Condition Test",
          "x-dynamic-enum": {
            "freeFormat": true,
            "operation": "getACLs",
            "property": "acl_name"
          }
        },
        "expr": {
          "type": "string",
          "x-dependency": {
            "action": {
              "required": true,
              "value": [
                "do-resolve",
                "set-bc-mark",
                "set-bc-tos",
                "set-dst",
                "set-dst-port",
                "set-fc-mark",
                "set-fc-tos",
                "set-priority-class",
                "set-priority-offset",
                "set-src",
                "set-src-port",
                "set-var"
              ]
            },
            "type": {
              "value": [
                "session",
                "connection",
                "content"
              ]
            }
          },
          "x-display-name": "Standard HAProxy expression"
        },
        "gpt_value": {
          "type": "string",
          "x-dependency": {
            "action": {
              "required": true,
              "value": "sc-set-gpt0"
            },
            "type": {
              "required": true,
              "value": [
                "connection",
                "content",
                "session"
              ]
            }
          },
          "x-display-name": "Sticky counter value"
        },
        "log_level": {
          "type": "string",
          "enum": [
            "emerg",
            "alert",
            "crit",
            "err",
            "warning",
            "notice",
            "info",
            "debug",
            "silent"
          ],
          "x-dependency": {
            "action": {
              "required": true,
              "value": "set-log-level"
            },
            "type": {
              "value": "content"
            }
          }
        },
        "lua_action": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "action": {
              "required": true,
              "value": "lua"
            },
            "type": {
              "value": [
                "connection",
                "content"
              ]
            }
          },
          "x-display-name": "Lua action name"
        },
        "lua_params": {
          "type": "string",
          "x-dependency": {
            "action": {
              "value": "lua"
            },
            "type": {
              "value": [
                "connection",
                "content"
              ]
            }
          },
          "x-display-name": "Lua action params"
        },
        "mark_value": {
          "type": "string",
          "pattern": "^(0x[0-9A-Fa-f]+|[0-9]+)$",
          "x-dependency": {
            "action": {
              "required": true,
              "value": "set-mark"
            },
            "type": {
              "value": [
                "connection",
                "content"
              ]
            }
          },
          "x-display-name": "Mark Value"
        },
        "nice_value": {
          "type": "integer",
          "maximum": 1024,
          "minimum": -1024,
          "x-dependency": {
            "action": {
              "required": true,
              "value": "set-nice"
            },
            "type": {
              "value": "content"
            }
          },
          "x-display-name": "Nice Value",
          "x-nullable": false
        },
        "resolve_protocol": {
          "type": "string",
          "enum": [
            "ipv4",
            "ipv6"
          ],
          "x-dependency": {
            "action": {
              "required": false,
              "value": "do-resolve"
            },
            "type": {
              "required": true,
              "value": [
                "content"
              ]
            }
          },
          "x-display-name": "Protocol"
        },
        "resolve_resolvers": {
          "type": "string",
          "x-dependency": {
            "action": {
              "required": true,
              "value": "do-resolve"
            },
            "type": {
              "required": true,
              "value": [
                "content"
              ]
            }
          },
          "x-display-name": "Resolvers"
        },
        "resolve_var": {
          "type": "string",
          "x-dependency": {
            "action": {
              "required": true,
              "value": "do-resolve"
            },
            "type": {
              "required": true,
              "value": [
                "content"
              ]
            }
          },
          "x-display-name": "Variable name"
        },
        "rst_ttl": {
          "type": "integer",
          "x-dependency": {
            "type": {
              "required": true,
              "value": [
                "silent-drop"
              ]
            }
          },
          "x-display-name": "RST TTL"
        },
        "sc_idx": {
          "type": "string",
          "x-dependency": {
            "action": {
              "required": true,
              "value": [
                "sc-set-gpt"
              ]
            },
            "type": {
              "required": true,
              "value": [
                "connection",
                "content",
                "session"
              ]
            }
          },
          "x-display-name": "Sticky counter Index"
        },
        "sc_inc_id": {
          "type": "string",
          "x-dependency": {
            "action": {
              "required": true,
              "value": [
                "sc-add-gpc",
                "sc-inc-gpc",
                "sc-inc-gpc0",
                "sc-inc-gpc1",
                "sc-set-gpt",
                "sc-set-gpt0"
              ]
            },
            "type": {
              "required": true,
              "value": [
                "connection",
                "content",
                "session"
              ]
            }
          },
          "x-display-name": "Sticky counter ID"
        },
        "sc_int": {
          "type": "integer",
          "x-dependency": {
            "type": {
              "required": true,
              "value": [
                "sc-add-gpc",
                "sc-set-gpt0"
              ]
            }
          },
          "x-display-name": "ScSet Integer Value",
          "x-nullable": true
        },
        "server_name": {
          "type": "string",
          "x-dependency": {
            "action": {
              "required": true,
              "value": "attach-srv"
            },
            "type": {
              "value": "session"
            }
          },
          "x-display-name": "Server name"
        },
        "service_name": {
          "type": "string",
          "x-dependency": {
            "action": {
              "required": true,
              "value": "use-service"
            },
            "type": {
              "value": "content"
            }
          },
          "x-display-name": "Service name"
        },
        "spoe_engine_name": {
          "type": "string",
          "x-dependency": {
            "action": {
              "required": true,
              "value": "send-spoe-group"
            },
            "type": {
              "required": true,
              "value": [
                "content"
              ]
            }
          },
          "x-display-name": "Engine name"
        },
        "spoe_group_name": {
          "type": "string",
          "x-dependency": {
            "action": {
              "required": true,
              "value": "send-spoe-group"
            },
            "type": {
              "required": true,
              "value": [
                "content"
              ]
            }
          },
          "x-display-name": "Group name"
        },
        "switch_mode_proto": {
          "type": "string",
          "x-dependency": {
            "action": {
              "required": true,
              "value": "switch-mode"
            },
            "type": {
              "value": "content"
            }
          },
          "x-display-name": "Switch Mode Proto"
        },
        "timeout": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-dependency": {
            "type": {
              "required": true,
              "value": "inspect-delay"
            }
          },
          "x-duration": true,
          "x-nullable": true
        },
        "tos_value": {
          "type": "string",
          "pattern": "^(0x[0-9A-Fa-f]+|[0-9]+)$",
          "x-dependency": {
            "action": {
              "required": true,
              "value": "set-tos"
            },
            "type": {
              "value": [
                "connection",
                "content"
              ]
            }
          },
          "x-display-name": "Tos Value"
        },
        "track_key": {
          "type": "string",
          "x-dependency": {
            "action": {
              "required": true,
              "value": [
                "track-sc"
              ]
            },
            "type": {
              "value": [
                "session",
                "connection",
                "content"
              ]
            }
          },
          "x-display-name": "Sample expression rule"
        },
        "track_stick_counter": {
          "type": "integer",
          "x-dependency": {
            "action": {
              "required": false,
              "value": [
                "track-sc"
              ]
            },
            "type": {
              "value": [
                "session",
                "connection",
                "content"
              ]
            }
          },
          "x-display-name": "Track Stick Counter",
          "x-nullable": true
        },
        "track_table": {
          "type": "string",
          "x-dependency": {
            "action": {
              "required": false,
              "value": [
                "track-sc"
              ]
            },
            "type": {
              "value": [
                "session",
                "connection",
                "content"
              ]
            }
          },
          "x-display-name": "Optional table name"
        },
        "type": {
          "type": "string",
          "enum": [
            "connection",
            "content",
            "inspect-delay",
            "session"
          ],
          "x-nullable": false
        },
        "var_format": {
          "type": "string",
          "x-dependency": {
            "action": {
              "required": true,
              "value": "set-var-fmt"
            },
            "type": {
              "value": [
                "session",
                "connection",
                "content"
              ]
            }
          },
          "x-display-name": "Var Format"
        },
        "var_name": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "action": {
              "required": true,
              "value": [
                "set-var",
                "unset-var",
                "set-var-fmt"
              ]
            },
            "type": {
              "value": [
                "session",
                "connection",
                "content"
              ]
            }
          },
          "x-display-name": "Variable name"
        },
        "var_scope": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "action": {
              "required": true,
              "value": [
                "set-var",
                "unset-var",
                "set-var-fmt"
              ]
            },
            "type": {
              "value": [
                "session",
                "connection",
                "content"
              ]
            }
          },
          "x-display-name": "Variable scope"
        }
      },
      "additionalProperties": false,
      "example": {
        "cond": "if",
        "cond_test": "{ src 192.168.0.0/16 }",
        "index": 0,
        "type": "connection"
      }
    },
    "tcp_request_rules": {
      "description": "HAProxy TCP request rules array (corresponds to tcp-request directive)",
      "type": "array",
      "title": "TCP Request Rules Array",
      "items": {
        "$ref": "#/definitions/tcp_request_rule"
      }
    },
    "tcp_response_rule": {
      "description": "HAProxy TCP Response Rule configuration (corresponds to tcp-response)",
      "type": "object",
      "title": "TCP Response Rule",
      "required": [
        "type"
      ],
      "properties": {
        "action": {
          "type": "string",
          "enum": [
            "accept",
            "close",
            "lua",
            "reject",
            "sc-add-gpc",
            "sc-inc-gpc",
            "sc-inc-gpc0",
            "sc-inc-gpc1",
            "sc-set-gpt",
            "sc-set-gpt0",
            "send-spoe-group",
            "set-bandwidth-limit",
            "set-fc-mark",
            "set-fc-tos",
            "set-log-level",
            "set-mark",
            "set-nice",
            "set-tos",
            "set-var",
            "set-var-fmt",
            "silent-drop",
            "unset-var"
          ],
          "x-dependency": {
            "type": {
              "required": true,
              "value": "content"
            }
          },
          "x-nullable": false
        },
        "bandwidth_limit_limit": {
          "type": "string",
          "x-dependency": {
            "action": {
              "value": "set-bandwidth-limit"
            },
            "type": {
              "value": "content"
            }
          },
          "x-display-name": "Standard HAProxy expression"
        },
        "bandwidth_limit_name": {
          "type": "string",
          "x-dependency": {
            "action": {
              "value": "set-bandwidth-limit"
            },
            "type": {
              "value": "content"
            }
          },
          "x-display-name": "Bandwidth limit name"
        },
        "bandwidth_limit_period": {
          "type": "string",
          "x-dependency": {
            "action": {
              "value": "set-bandwidth-limit"
            },
            "type": {
              "value": "content"
            }
          },
          "x-display-name": "Standard HAProxy expression"
        },
        "cond": {
          "type": "string",
          "enum": [
            "if",
            "unless"
          ],
          "x-dependency": {
            "type": {
              "value": "content"
            }
          },
          "x-display-name": "Condition"
        },
        "cond_test": {
          "type": "string",
          "x-dependency": {
            "cond": {
              "required": true
            },
            "type": {
              "value": "content"
            }
          },
          "x-display-name": "Condition Test",
          "x-dynamic-enum": {
            "freeFormat": true,
            "operation": "getACLs",
            "property": "acl_name"
          }
        },
        "expr": {
          "type": "string",
          "x-dependency": {
            "action": {
              "required": true,
              "value": [
                "set-src-port",
                "sc-set-gpt0",
                "set-fc-mark",
                "set-fc-tos"
              ]
            },
            "type": {
              "value": "content"
            }
          },
          "x-display-name": "Standard HAProxy expression"
        },
        "log_level": {
          "type": "string",
          "enum": [
            "emerg",
            "alert",
            "crit",
            "err",
            "warning",
            "notice",
            "info",
            "debug",
            "silent"
          ],
          "x-dependency": {
            "action": {
              "required": true,
              "value": "set-log-level"
            },
            "type": {
              "value": "content"
            }
          }
        },
        "lua_action": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "action": {
              "required": true,
              "value": "lua"
            },
            "type": {
              "value": "content"
            }
          },
          "x-display-name": "Lua action name"
        },
        "lua_params": {
          "type": "string",
          "x-dependency": {
            "action": {
              "value": "lua"
            },
            "type": {
              "value": "content"
            }
          },
          "x-display-name": "Lua action params"
        },
        "mark_value": {
          "type": "string",
          "pattern": "^(0x[0-9A-Fa-f]+|[0-9]+)$",
          "x-dependency": {
            "action": {
              "required": true,
              "value": "set-mark"
            },
            "type": {
              "value": "content"
            }
          },
          "x-display-name": "Mark Value"
        },
        "nice_value": {
          "type": "integer",
          "maximum": 1024,
          "minimum": -1024,
          "x-dependency": {
            "action": {
              "required": true,
              "value": "set-nice"
            },
            "type": {
              "value": "content"
            }
          },
          "x-display-name": "Nice Value",
          "x-nullable": false
        },
        "rst_ttl": {
          "type": "integer",
          "x-dependency": {
            "type": {
              "required": true,
              "value": [
                "silent-drop"
              ]
            }
          },
          "x-display-name": "RST TTL"
        },
        "sc_expr": {
          "type": "string",
          "x-dependency": {
            "action": {
              "required": true,
              "value": [
                "sc-add-gpc",
                "sc-inc-gpc"
              ]
            },
            "type": {
              "value": "content"
            }
          },
          "x-display-name": "ScSet Expression Value"
        },
        "sc_id": {
          "type": "integer",
          "x-dependency": {
            "action": {
              "required": true,
              "value": [
                "sc-add-gpc",
                "sc-inc-gpc",
                "sc-inc-gpc0",
                "sc-inc-gpc1",
                "sc-set-gpt",
                "sc-set-gpt0"
              ]
            },
            "type": {
              "value": "content"
            }
          }
        },
        "sc_idx": {
          "type": "integer",
          "x-dependency": {
            "action": {
              "required": true,
              "value": [
                "sc-add-gpc",
                "sc-set-gpt",
                "sc-inc-gpc"
              ]
            },
            "type": {
              "value": "content"
            }
          }
        },
        "sc_int": {
          "type": "integer",
          "x-dependency": {
            "action": {
              "required": true,
              "value": [
                "sc-add-gpc",
                "sc-inc-gpc"
              ]
            },
            "type": {
              "value": "content"
            }
          },
          "x-display-name": "ScSet Integer Value",
          "x-nullable": true
        },
        "spoe_engine": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "action": {
              "required": true,
              "value": "send-spoe-group"
            },
            "type": {
              "value": "content"
            }
          },
          "x-display-name": "SPOE Engine"
        },
        "spoe_group": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "action": {
              "required": true,
              "value": "send-spoe-group"
            },
            "type": {
              "value": "content"
            }
          },
          "x-display-name": "SPOE Group"
        },
        "timeout": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-dependency": {
            "type": {
              "required": true,
              "value": "inspect-delay"
            }
          },
          "x-duration": true,
          "x-nullable": true
        },
        "tos_value": {
          "type": "string",
          "pattern": "^(0x[0-9A-Fa-f]+|[0-9]+)$",
          "x-dependency": {
            "action": {
              "required": true,
              "value": "set-tos"
            },
            "type": {
              "value": "content"
            }
          },
          "x-display-name": "Tos Value"
        },
        "type": {
          "type": "string",
          "enum": [
            "content",
            "inspect-delay"
          ],
          "x-nullable": false
        },
        "var_format": {
          "type": "string",
          "x-dependency": {
            "action": {
              "required": true,
              "value": "set-var-fmt"
            },
            "type": {
              "value": "content"
            }
          },
          "x-display-name": "Var Format"
        },
        "var_name": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "action": {
              "required": true,
              "value": [
                "unset-var"
              ]
            },
            "type": {
              "value": "content"
            }
          }
        },
        "var_scope": {
          "type": "string",
          "pattern": "^[^\\s]+$",
          "x-dependency": {
            "action": {
              "value": "unset-var"
            },
            "type": {
              "value": "content"
            }
          }
        }
      },
      "additionalProperties": false,
      "example": {
        "cond": "if",
        "cond_test": "{ src 192.168.0.0/16 }",
        "index": 0,
        "type": "content"
      }
    },
    "tcp_response_rules": {
      "description": "HAProxy TCP response rules array (corresponds to tcp-response directive)",
      "type": "array",
      "title": "TCP Response Rules Array",
      "items": {
        "$ref": "#/definitions/tcp_response_rule"
      }
    },
    "transaction": {
      "description": "HAProxy configuration transaction",
      "type": "object",
      "title": "Configuration transaction",
      "properties": {
        "_version": {
          "type": "integer"
        },
        "id": {
          "type": "string",
          "pattern": "^[^\\s]+$"
        },
        "status": {
          "type": "string",
          "enum": [
            "failed",
            "outdated",
            "in_progress",
            "success"
          ]
        }
      },
      "example": {
        "_version": 2,
        "id": "273e3385-2d0c-4fb1-aa27-93cbb31ff203",
        "status": "in_progress"
      }
    },
    "transactions": {
      "description": "Configuration transactions array",
      "type": "array",
      "title": "Transactions array",
      "items": {
        "$ref": "#/definitions/transaction"
      }
    },
    "tune_buffer_options": {
      "type": "object",
      "properties": {
        "buffers_limit": {
          "type": "integer",
          "x-display-name": "Buffers Limit",
          "x-nullable": true
        },
        "buffers_reserve": {
          "type": "integer",
          "minimum": 2,
          "x-display-name": "Buffers Reserve"
        },
        "bufsize": {
          "type": "integer",
          "x-display-name": "Buffer Size"
        },
        "pipesize": {
          "type": "integer",
          "x-display-name": "Pipe Buffer Size"
        },
        "rcvbuf_backend": {
          "type": "integer",
          "x-display-name": "Backend Receive Buffer Size",
          "x-nullable": true
        },
        "rcvbuf_client": {
          "type": "integer",
          "x-display-name": "Client Receive Buffer Size",
          "x-nullable": true
        },
        "rcvbuf_frontend": {
          "type": "integer",
          "x-display-name": "Frontend Receive Buffer Size",
          "x-nullable": true
        },
        "rcvbuf_server": {
          "type": "integer",
          "x-display-name": "Server Receive Buffer Size",
          "x-nullable": true
        },
        "recv_enough": {
          "type": "integer",
          "x-display-name": "Receive Enough Socket Buffer Size"
        },
        "sndbuf_backend": {
          "type": "integer",
          "x-display-name": "Backend Send Buffer Size",
          "x-nullable": true
        },
        "sndbuf_client": {
          "type": "integer",
          "x-display-name": "Client Send Buffer Size",
          "x-nullable": true
        },
        "sndbuf_frontend": {
          "type": "integer",
          "x-display-name": "Frontend Send Buffer Size",
          "x-nullable": true
        },
        "sndbuf_server": {
          "type": "integer",
          "x-display-name": "Server Send Buffer Size",
          "x-nullable": true
        }
      }
    },
    "tune_lua_options": {
      "type": "object",
      "properties": {
        "burst_timeout": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-display-name": "Burst execution timeout",
          "x-duration": true,
          "x-nullable": true
        },
        "forced_yield": {
          "type": "integer",
          "x-display-name": "Lua Forced Yield"
        },
        "log_loggers": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "Send Lua Logs to the Loggers"
        },
        "log_stderr": {
          "type": "string",
          "enum": [
            "auto",
            "enabled",
            "disabled"
          ],
          "x-display-name": "Send Lua Logs to stderr"
        },
        "maxmem": {
          "type": "integer",
          "x-display-name": "Lua Maximum Memory Usage",
          "x-nullable": true
        },
        "service_timeout": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-display-name": "Lua Service timeout",
          "x-duration": true,
          "x-nullable": true
        },
        "session_timeout": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-display-name": "Lua Session Timeout",
          "x-duration": true,
          "x-nullable": true
        },
        "task_timeout": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-display-name": "Lua Task Timeout",
          "x-duration": true,
          "x-nullable": true
        }
      }
    },
    "tune_options": {
      "type": "object",
      "properties": {
        "applet_zero_copy_forwarding": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "Enables of disabled the zero-copy forwarding of data for the applets"
        },
        "comp_maxlevel": {
          "type": "integer",
          "x-display-name": "Maximum Compression Level"
        },
        "disable_zero_copy_forwarding": {
          "type": "boolean",
          "x-display-name": "Disable zero-copy forwarding"
        },
        "events_max_events_at_once": {
          "type": "integer",
          "maximum": 10000,
          "minimum": 1
        },
        "fail_alloc": {
          "type": "boolean",
          "x-display-name": "Failed Allocation Chance"
        },
        "fd_edge_triggered": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "Edge-triggered polling mode"
        },
        "h1_zero_copy_fwd_recv": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "enable or disable the zero-copy receives of data for the HTTP/1 multiplexer"
        },
        "h1_zero_copy_fwd_send": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "enable or disable the zero-copy sends of data for the HTTP/1 multiplexer"
        },
        "h2_be_glitches_threshold": {
          "type": "integer",
          "x-display-name": "Automatically kill a backend connection past a number of glitches",
          "x-nullable": true
        },
        "h2_be_initial_window_size": {
          "type": "integer",
          "x-display-name": "Initial window size for outgoing connections"
        },
        "h2_be_max_concurrent_streams": {
          "type": "integer",
          "x-display-name": "Maximum number of concurrent streams per outgoing connection"
        },
        "h2_fe_glitches_threshold": {
          "type": "integer",
          "x-display-name": "Automatically kill a frontend connection past a number of glitches",
          "x-nullable": true
        },
        "h2_fe_initial_window_size": {
          "type": "integer",
          "x-display-name": "Initial window size for incoming connections"
        },
        "h2_fe_max_concurrent_streams": {
          "type": "integer",
          "x-display-name": "Maximum number of concurrent streams per incoming connection"
        },
        "h2_fe_max_total_streams": {
          "type": "integer",
          "x-display-name": "Maximum number of total streams processed per incoming HTTP/2 connection",
          "x-nullable": true
        },
        "h2_header_table_size": {
          "type": "integer",
          "maximum": 65535,
          "x-display-name": "HTTP/2 Dynamic Header Table Size"
        },
        "h2_initial_window_size": {
          "type": "integer",
          "x-display-name": "HTTP/2 Initial Window Size",
          "x-nullable": true
        },
        "h2_max_concurrent_streams": {
          "type": "integer",
          "x-display-name": "HTTP/2 Maximum Number of Concurrent Streams"
        },
        "h2_max_frame_size": {
          "type": "integer",
          "x-display-name": "HTTP/2 Maximum Frame Size"
        },
        "h2_zero_copy_fwd_send": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "enable or disable the zero-copy sends of data for the HTTP/2 multiplexer"
        },
        "http_cookielen": {
          "type": "integer",
          "x-display-name": "Maximum Cookie Length"
        },
        "http_logurilen": {
          "type": "integer",
          "x-display-name": "Maximum URI Length"
        },
        "http_maxhdr": {
          "type": "integer",
          "maximum": 32767,
          "minimum": 1,
          "x-display-name": "Maximum Number of Headers"
        },
        "idle_pool_shared": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "Share Idle Connections"
        },
        "idletimer": {
          "type": "integer",
          "maximum": 65535,
          "x-default-unit": "ms",
          "x-display-name": "Idle Stream Duration",
          "x-duration": true,
          "x-nullable": true
        },
        "listener_default_shards": {
          "type": "string",
          "enum": [
            "by-process",
            "by-thread",
            "by-group"
          ],
          "x-display-name": "Listener Default Shards"
        },
        "listener_multi_queue": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "Listener Multi Queue Accept"
        },
        "max_checks_per_thread": {
          "type": "integer",
          "x-display-name": "Maximum checks per thread",
          "x-nullable": true
        },
        "maxaccept": {
          "type": "integer",
          "x-display-name": "Maximum Accept Events"
        },
        "maxpollevents": {
          "type": "integer",
          "x-display-name": "Maximum Polled Events"
        },
        "maxrewrite": {
          "type": "integer",
          "x-display-name": "Maximum Rewrite Space"
        },
        "memory_hot_size": {
          "type": "integer",
          "x-display-name": "Per-thread Amount of Memory",
          "x-nullable": true
        },
        "pattern_cache_size": {
          "type": "integer",
          "x-display-name": "Pattern Lookup Cache Size",
          "x-nullable": true
        },
        "peers_max_updates_at_once": {
          "type": "integer",
          "x-display-name": "Maximum number of stick-table updates at once"
        },
        "pool_high_fd_ratio": {
          "type": "integer",
          "x-display-name": "Max Used High FD Ratio"
        },
        "pool_low_fd_ratio": {
          "type": "integer",
          "x-display-name": "Max Used Low FD Ratio"
        },
        "pt_zero_copy_forwarding": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "enable or disable the zero-copy forwarding of data for the pass-through multiplexer"
        },
        "ring_queues": {
          "type": "integer",
          "x-display-name": "Number of write queues in front of ring buffers",
          "x-nullable": true
        },
        "runqueue_depth": {
          "type": "integer",
          "x-display-name": "Max Tasks in Run Queue"
        },
        "sched_low_latency": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "Low Latency Task Scheduler"
        },
        "stick_counters": {
          "type": "integer",
          "x-display-name": "Number of stick-counters",
          "x-nullable": true
        }
      }
    },
    "tune_quic_options": {
      "type": "object",
      "properties": {
        "frontend_conn_tx_buffers_limit": {
          "type": "integer",
          "x-display-name": "QUIC Frontend Connection TX Buffer Limit",
          "x-nullable": true
        },
        "frontend_max_idle_timeout": {
          "type": "integer",
          "x-default-unit": "ms",
          "x-display-name": "QUIC Frontend Max Idle Timeout",
          "x-duration": true,
          "x-nullable": true
        },
        "frontend_max_streams_bidi": {
          "type": "integer",
          "x-display-name": "QUIC Max Number of Bidirectional Streams",
          "x-nullable": true
        },
        "max_frame_loss": {
          "type": "integer",
          "x-display-name": "QUIC Max Limit for Frame Loss",
          "x-nullable": true
        },
        "reorder_ratio": {
          "type": "integer",
          "maximum": 100,
          "x-display-name": "Ratio applied to the packet reordering threshold",
          "x-nullable": true
        },
        "retry_threshold": {
          "type": "integer",
          "x-display-name": "QUIC Retry Threshold",
          "x-nullable": true
        },
        "socket_owner": {
          "type": "string",
          "enum": [
            "listener",
            "connection"
          ],
          "x-display-name": "QUIC Socket Owner"
        },
        "zero_copy_fwd_send": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "Enables or disables the zero-copy sends for the QUIC multiplexer"
        }
      }
    },
    "tune_ssl_options": {
      "type": "object",
      "properties": {
        "cachesize": {
          "type": "integer",
          "x-display-name": "SSL Cache Size",
          "x-nullable": true
        },
        "capture_buffer_size": {
          "type": "integer",
          "x-display-name": "SSL Maximum Size of Cipherlist Buffer",
          "x-nullable": true
        },
        "ctx_cache_size": {
          "type": "integer",
          "x-display-name": "SSL Number of Certificates in Cache"
        },
        "default_dh_param": {
          "type": "integer",
          "x-display-name": "SSL Default DH Parameter Size"
        },
        "force_private_cache": {
          "type": "boolean",
          "x-display-name": "SSL Force Private Cache"
        },
        "keylog": {
          "type": "string",
          "enum": [
            "enabled",
            "disabled"
          ],
          "x-display-name": "SSL Log TLS Keys"
        },
        "lifetime": {
          "type": "integer",
          "x-default-unit": "s",
          "x-display-name": "SSL Session Lifetime",
          "x-duration": true,
          "x-nullable": true
        },
        "maxrecord": {
          "type": "integer",
          "x-display-name": "SSL Maximum Size",
          "x-nullable": true,
          "x-size": false
        },
        "ocsp_update_max_delay": {
          "type": "integer",
          "x-display-name": "SSL Maximum Interval Between Two Automatic Updates of the same OCSP Response",
          "x-nullable": true
        },
        "ocsp_update_min_delay": {
          "type": "integer",
          "x-display-name": "SSL Minimum Interval Between Two Automatic Updates of the same OCSP Response",
          "x-nullable": true
        }
      }
    },
    "tune_vars_options": {
      "type": "object",
      "properties": {
        "global_max_size": {
          "type": "integer",
          "x-display-name": "Variables Global Max Size",
          "x-nullable": true,
          "x-size": false
        },
        "proc_max_size": {
          "type": "integer",
          "x-display-name": "Variables Process Max Size",
          "x-nullable": true,
          "x-size": false
        },
        "reqres_max_size": {
          "type": "integer",
          "x-display-name": "Variables Request/Response Max Size",
          "x-nullable": true,
          "x-size": false
        },
        "sess_max_size": {
          "type": "integer",
          "x-display-name": "Variables Session Max Size",
          "x-nullable": true,
          "x-size": false
        },
        "txn_max_size": {
          "type": "integer",
          "x-display-name": "Variables Transaction Max Size",
          "x-nullable": true,
          "x-size": false
        }
      }
    },
    "tune_zlib_options": {
      "type": "object",
      "properties": {
        "memlevel": {
          "type": "integer",
          "maximum": 9,
          "minimum": 1,
          "x-display-name": "Zlib Memory Level"
        },
        "windowsize": {
          "type": "integer",
          "maximum": 15,
          "minimum": 8,
          "x-display-name": "Zlib Window Size"
        }
      }
    },
    "user": {
      "description": "HAProxy userlist user",
      "title": "User",
      "required": [
        "username",
        "secure_password",
        "password"
      ],
      "properties": {
        "groups": {
          "type": "string",
          "x-nullable": false
        },
        "password": {
          "type": "string",
          "x-nullable": false
        },
        "secure_password": {
          "type": "boolean"
        },
        "username": {
          "type": "string",
          "pattern": "^[A-Za-z0-9-_.:]+$",
          "x-nullable": false
        }
      }
    },
    "userlist": {
      "description": "Userlist with all it's children resources",
      "type": "object",
      "allOf": [
        {
          "$ref": "#/definitions/userlist_base"
        },
        {
          "type": "object",
          "properties": {
            "groups": {
              "additionalProperties": {
                "$ref": "#/definitions/group"
              }
            },
            "users": {
              "additionalProperties": {
                "$ref": "#/definitions/user"
              }
            }
          }
        }
      ],
      "x-go-name": "Userlist"
    },
    "userlist_base": {
      "description": "HAProxy configuration of access control",
      "type": "object",
      "title": "Userlist Base",
      "required": [
        "name"
      ],
      "properties": {
        "name": {
          "type": "string",
          "pattern": "^[A-Za-z0-9-_.:]+$",
          "x-nullable": false
        }
      }
    },
    "userlists": {
      "description": "HAProxy userlists array",
      "type": "array",
      "title": "Userlists",
      "items": {
        "$ref": "#/definitions/userlist"
      }
    },
    "users": {
      "description": "HAProxy userlist users array",
      "type": "array",
      "title": "Users",
      "items": {
        "$ref": "#/definitions/user"
      }
    },
    "wurfl_options": {
      "type": "object",
      "properties": {
        "cache_size": {
          "type": "integer",
          "x-display-name": "Sets the WURFL Useragent cache size"
        },
        "data_file": {
          "type": "string",
          "x-display-name": "The path of the WURFL data file"
        },
        "information_list": {
          "type": "string",
          "x-display-name": "A space-delimited list of WURFL capabilities"
        },
        "information_list_separator": {
          "type": "string",
          "x-display-name": "A char that will be used to separate values in a response header containing WURFL results"
        },
        "patch_file": {
          "type": "string",
          "x-display-name": "A list of WURFL patch file paths"
        }
      }
    }
  },
  "parameters": {
    "force_reload": {
      "type": "boolean",
      "default": false,
      "description": "If set, do a force reload, do not wait for the configured reload-delay. Cannot be used when transaction is specified, as changes in transaction are not applied directly to configuration.",
      "name": "force_reload",
      "in": "query"
    },
    "full_section": {
      "type": "boolean",
      "default": false,
      "description": "Indicates if the action affects the specified child resources as well",
      "name": "full_section",
      "in": "query"
    },
    "parent_name": {
      "type": "string",
      "description": "Parent name",
      "name": "parent_name",
      "in": "path",
      "required": true
    },
    "skip_reload": {
      "type": "boolean",
      "default": false,
      "description": "If set, no reload will be initiated after update",
      "name": "skip_reload",
      "in": "query"
    },
    "transaction_id": {
      "type": "string",
      "x-nullable": false,
      "description": "ID of the transaction where we want to add the operation. Cannot be used when version is specified.",
      "name": "transaction_id",
      "in": "query"
    },
    "version": {
      "type": "integer",
      "x-nullable": false,
      "description": "Version used for checking configuration version. Cannot be used when transaction is specified, transaction has it's own version.",
      "name": "version",
      "in": "query"
    }
  },
  "responses": {
    "AlreadyExists": {
      "description": "The specified resource already exists",
      "schema": {
        "$ref": "#/definitions/error"
      },
      "headers": {
        "Configuration-Version": {
          "type": "string",
          "description": "Configuration file version"
        }
      }
    },
    "BadRequest": {
      "description": "Bad request",
      "schema": {
        "$ref": "#/definitions/error"
      },
      "headers": {
        "Configuration-Version": {
          "type": "string",
          "description": "Configuration file version"
        }
      }
    },
    "DefaultError": {
      "description": "General Error",
      "schema": {
        "$ref": "#/definitions/error"
      },
      "headers": {
        "Configuration-Version": {
          "type": "string",
          "description": "Configuration file version"
        }
      }
    },
    "NotAcceptable": {
      "description": "The specified resource cannot be handled",
      "schema": {
        "$ref": "#/definitions/error"
      },
      "headers": {
        "Configuration-Version": {
          "type": "string",
          "description": "Configuration file version"
        }
      }
    },
    "NotFound": {
      "description": "The specified resource was not found",
      "schema": {
        "$ref": "#/definitions/error"
      },
      "headers": {
        "Configuration-Version": {
          "type": "string",
          "description": "Configuration file version"
        }
      }
    }
  },
  "securityDefinitions": {
    "basic_auth": {
      "type": "basic"
    }
  },
  "security": [
    {
      "basic_auth": []
    }
  ],
  "tags": [
    {
      "name": "ACL"
    },
    {
      "description": "Managing backend configurations (advanced mode)",
      "name": "Backend"
    },
    {
      "name": "BackendSwitchingRule"
    },
    {
      "description": "Managing frontend bind configurations (advanced mode)",
      "name": "Bind"
    },
    {
      "name": "Cache"
    },
    {
      "name": "Cluster"
    },
    {
      "description": "Raw HAProxy configuration management (advanced mode)",
      "name": "Configuration"
    },
    {
      "name": "CrtLoad"
    },
    {
      "name": "CrtStore"
    },
    {
      "name": "DeclareCapture"
    },
    {
      "description": "Managing defaults configuration (advanced mode)",
      "name": "Defaults"
    },
    {
      "name": "DgramBind"
    },
    {
      "description": "API autodiscover endpoints",
      "name": "Discovery"
    },
    {
      "name": "FCGIApp"
    },
    {
      "name": "Filter"
    },
    {
      "description": "Managing frontend configuration (advanced mode)",
      "name": "Frontend"
    },
    {
      "description": "Managing global configuration (advanced mode)",
      "name": "Global"
    },
    {
      "name": "HTTPCheck"
    },
    {
      "name": "HTTPErrorRule"
    },
    {
      "name": "HTTPErrors"
    },
    {
      "name": "HTTPRequestRule"
    },
    {
      "name": "HTTPResponseRule"
    },
    {
      "name": "Information"
    },
    {
      "name": "LogForward"
    },
    {
      "name": "LogTarget"
    },
    {
      "name": "MailerEntry"
    },
    {
      "name": "Mailers"
    },
    {
      "name": "Maps"
    },
    {
      "name": "Nameserver"
    },
    {
      "name": "Peer"
    },
    {
      "name": "PeerEntry"
    },
    {
      "name": "ProcessManager"
    },
    {
      "description": "Checking reload success. To avoid constant reloading we reload in intervals that are configurable when\nwith reload-delay option. When a change to configuration is made and force_reload url query string\nparameter is false we issue a request for reload, and return the reload ID in response header. You can\nthen use reloads endpoints to check the status of that reload ID. If force_reload is true, we override all\nof this and reload immediately.\n",
      "name": "Reloads"
    },
    {
      "name": "Resolver"
    },
    {
      "name": "Ring"
    },
    {
      "description": "Managing backend server configurations (advanced mode)",
      "name": "Server"
    },
    {
      "name": "ServerSwitchingRule"
    },
    {
      "name": "ServerTemplate"
    },
    {
      "name": "ServiceDiscovery"
    },
    {
      "description": "Managing sites (simple configuration mode). Sites are considered as one frontend with multiple backends\nconnected to it via default_backend or use-backend directives.\n",
      "name": "Sites"
    },
    {
      "name": "Specification"
    },
    {
      "name": "SpecificationOpenapiv3"
    },
    {
      "name": "Spoe"
    },
    {
      "name": "SpoeTransactions"
    },
    {
      "description": "Stats container",
      "name": "Stats"
    },
    {
      "name": "StickRule"
    },
    {
      "name": "StickTable"
    },
    {
      "name": "Storage"
    },
    {
      "name": "TCPCheck"
    },
    {
      "name": "TCPRequestRule"
    },
    {
      "name": "TCPResponseRule"
    },
    {
      "name": "Table"
    },
    {
      "description": "Managing transactions. Configuration changes can be grouped in the transaction. You start the\ntransaction with trasactions POST, and call the configuration changes you need with parameter\ntransaction_id. When you want to commit the transaction, you call the transactions PUT and all changes\nin that transaction is committed. If you call a configuration change without the transaction_id,\ntransaction mechanism is implicitly called with one operation in transaction.\n",
      "name": "Transactions"
    },
    {
      "name": "Userlist"
    }
  ],
  "externalDocs": {
    "description": "HAProxy Documentation",
    "url": "https://docs.haproxy.org/"
  }
}`))
	FlatSwaggerJSON = json.RawMessage([]byte(`{
  "consumes": [
    "application/json"
  ],
  "produces": [
    "application/json"
  ],
  "schemes": [
    "http",
    "https"
  ],
  "swagger": "2.0",
  "info": {
    "description": "API for editing and managing haproxy instances. Provides process information, configuration management,\nhaproxy stats and logs.\n",
    "title": "HAProxy Data Plane API",
    "contact": {
      "name": "HAProxy Support",
      "url": "https://my.haproxy.com/portal/cust/login",
      "email": "support@haproxy.com"
    },
    "version": "3.0"
  },
  "basePath": "/v3",
  "paths": {
    "/": {
      "get": {
        "description": "Returns a list of root endpoints.",
        "produces": [
          "application/json"
        ],
        "tags": [
          "Discovery"
        ],
        "summary": "Return list of root endpoints",
        "operationId": "getAPIEndpoints",
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "$ref": "#/definitions/endpoints"
            }
          },
          "default": {
            "description": "General Error",
            "schema": {
              "$ref": "#/definitions/error"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          }
        }
      }
    },
    "/cluster": {
      "get": {
        "description": "Returns cluster data",
        "produces": [
          "application/json"
        ],
        "tags": [
          "Cluster"
        ],
        "summary": "Return cluster data",
        "operationId": "getCluster",
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "$ref": "#/definitions/cluster_settings"
            }
          },
          "default": {
            "description": "General Error",
            "schema": {
              "$ref": "#/definitions/error"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          }
        }
      },
      "put": {
        "description": "Edit cluster settings",
        "tags": [
          "Cluster"
        ],
        "summary": "Edit cluster settings",
        "operationId": "editCluster",
        "parameters": [
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/cluster_settings"
            }
          },
          {
            "type": "integer",
            "x-nullable": false,
            "description": "Version used for checking configuration version. Cannot be used when transaction is specified, transaction has it's own version.",
            "name": "version",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Cluster settings changed",
            "schema": {
              "$ref": "#/definitions/cluster_settings"
            }
          },
          "400": {
            "description": "Bad request",
            "schema": {
              "$ref": "#/definitions/error"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "description": "General Error",
            "schema": {
              "$ref": "#/definitions/error"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          }
        }
      },
      "post": {
        "description": "Post cluster settings",
        "tags": [
          "Cluster"
        ],
        "summary": "Post cluster settings",
        "operationId": "postCluster",
        "parameters": [
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/cluster_settings"
            }
          },
          {
            "enum": [
              "keep"
            ],
            "type": "string",
            "description": "In case of moving to single mode do we keep or clean configuration",
            "name": "configuration",
            "in": "query"
          },
          {
            "type": "string",
            "description": "Force the advertised address when joining a cluster",
            "name": "advertised_address",
            "in": "query"
          },
          {
            "maximum": 65535,
            "minimum": 1,
            "type": "integer",
            "description": "Force the advertised port when joining a cluster",
            "name": "advertised_port",
            "in": "query"
          },
          {
            "type": "integer",
            "x-nullable": false,
            "description": "Version used for checking configuration version. Cannot be used when transaction is specified, transaction has it's own version.",
            "name": "version",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Cluster settings changed",
            "schema": {
              "$ref": "#/definitions/cluster_settings"
            }
          },
          "400": {
            "description": "Bad request",
            "schema": {
              "$ref": "#/definitions/error"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "description": "General Error",
            "schema": {
              "$ref": "#/definitions/error"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          }
        }
      },
      "delete": {
        "description": "Delete cluster settings and move the node back to single mode",
        "tags": [
          "Cluster"
        ],
        "summary": "Delete cluster settings",
        "operationId": "deleteCluster",
        "parameters": [
          {
            "enum": [
              "keep"
            ],
            "type": "string",
            "description": "In case of moving to single mode do we keep or clean configuration",
            "name": "configuration",
            "in": "query"
          },
          {
            "type": "integer",
            "x-nullable": false,
            "description": "Version used for checking configuration version. Cannot be used when transaction is specified, transaction has it's own version.",
            "name": "version",
            "in": "query"
          }
        ],
        "responses": {
          "204": {
            "description": "Cluster settings deleted and node moved to single mode"
          },
          "default": {
            "description": "General Error",
            "schema": {
              "$ref": "#/definitions/error"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          }
        }
      }
    },
    "/cluster/certificate": {
      "post": {
        "description": "Initiates a certificate refresh",
        "tags": [
          "Cluster"
        ],
        "summary": "Initiates a certificate refresh",
        "operationId": "initiateCertificateRefresh",
        "responses": {
          "200": {
            "description": "refresh activated"
          },
          "403": {
            "description": "refresh not possible"
          },
          "default": {
            "description": "General Error",
            "schema": {
              "$ref": "#/definitions/error"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          }
        }
      }
    },
    "/health": {
      "get": {
        "description": "Return managed services health",
        "produces": [
          "application/json"
        ],
        "tags": [
          "Health"
        ],
        "summary": "Return managed services health",
        "operationId": "getHealth",
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "$ref": "#/definitions/health"
            }
          },
          "default": {
            "description": "General Error",
            "schema": {
              "$ref": "#/definitions/error"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          }
        }
      }
    },
    "/info": {
      "get": {
        "description": "Return API, hardware and OS information",
        "produces": [
          "application/json"
        ],
        "tags": [
          "Information"
        ],
        "summary": "Return API, hardware and OS information",
        "operationId": "getInfo",
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "$ref": "#/definitions/info"
            }
          },
          "default": {
            "description": "General Error",
            "schema": {
              "$ref": "#/definitions/error"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          }
        }
      }
    },
    "/service_discovery/aws": {
      "get": {
        "description": "Return all configured AWS regions.",
        "tags": [
          "ServiceDiscovery"
        ],
        "summary": "Return an array of all configured AWS regions",
        "operationId": "getAWSRegions",
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/awsRegions"
            }
          },
          "default": {
            "description": "General Error",
            "schema": {
              "$ref": "#/definitions/error"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          }
        }
      },
      "post": {
        "description": "Add a new AWS region.\nCredentials are not required in case Dataplane API is running in an EC2 instance with proper IAM role attached.",
        "tags": [
          "ServiceDiscovery"
        ],
        "summary": "Add a new AWS region",
        "operationId": "createAWSRegion",
        "parameters": [
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/awsRegion"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Resource created",
            "schema": {
              "$ref": "#/definitions/awsRegion"
            }
          },
          "400": {
            "description": "Bad request",
            "schema": {
              "$ref": "#/definitions/error"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "409": {
            "description": "The specified resource already exists",
            "schema": {
              "$ref": "#/definitions/error"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "description": "General Error",
            "schema": {
              "$ref": "#/definitions/error"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          }
        }
      }
    },
    "/service_discovery/aws/{id}": {
      "get": {
        "description": "Return one AWS Region configuration by it's id.",
        "tags": [
          "ServiceDiscovery"
        ],
        "summary": "Return an AWS region",
        "operationId": "getAWSRegion",
        "parameters": [
          {
            "type": "string",
            "description": "AWS region id",
            "name": "id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/awsRegion"
            }
          },
          "404": {
            "description": "The specified resource was not found",
            "schema": {
              "$ref": "#/definitions/error"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "description": "General Error",
            "schema": {
              "$ref": "#/definitions/error"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          }
        }
      },
      "put": {
        "description": "Replace an AWS region configuration by its id.",
        "tags": [
          "ServiceDiscovery"
        ],
        "summary": "Replace an AWS region",
        "operationId": "replaceAWSRegion",
        "parameters": [
          {
            "type": "string",
            "description": "AWS Region ID",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/awsRegion"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Resource updated",
            "schema": {
              "$ref": "#/definitions/awsRegion"
            }
          },
          "400": {
            "description": "Bad request",
            "schema": {
              "$ref": "#/definitions/error"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "description": "The specified resource was not found",
            "schema": {
              "$ref": "#/definitions/error"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "description": "General Error",
            "schema": {
              "$ref": "#/definitions/error"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          }
        }
      },
      "delete": {
        "description": "Delete an AWS region configuration by it's id.",
        "tags": [
          "ServiceDiscovery"
        ],
        "summary": "Delete an AWS region",
        "operationId": "deleteAWSRegion",
        "parameters": [
          {
            "type": "string",
            "description": "AWS region ID",
            "name": "id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "Resource deleted"
          },
          "404": {
            "description": "The specified resource was not found",
            "schema": {
              "$ref": "#/definitions/error"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "description": "General Error",
            "schema": {
              "$ref": "#/definitions/error"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          }
        }
      }
    },
    "/service_discovery/consul": {
      "get": {
        "description": "Returns all configured Consul servers.",
        "tags": [
          "ServiceDiscovery"
        ],
        "summary": "Return an array of all configured Consul servers",
        "operationId": "getConsuls",
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/consuls"
            }
          },
          "default": {
            "description": "General Error",
            "schema": {
              "$ref": "#/definitions/error"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          }
        }
      },
      "post": {
        "description": "Adds a new Consul server.",
        "tags": [
          "ServiceDiscovery"
        ],
        "summary": "Add a new Consul server",
        "operationId": "createConsul",
        "parameters": [
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/consul"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Consul created",
            "schema": {
              "$ref": "#/definitions/consul"
            }
          },
          "400": {
            "description": "Bad request",
            "schema": {
              "$ref": "#/definitions/error"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "409": {
            "description": "The specified resource already exists",
            "schema": {
              "$ref": "#/definitions/error"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "description": "General Error",
            "schema": {
              "$ref": "#/definitions/error"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          }
        }
      }
    },
    "/service_discovery/consul/{id}": {
      "get": {
        "description": "Returns one Consul server configuration by it's id.",
        "tags": [
          "ServiceDiscovery"
        ],
        "summary": "Return one Consul server",
        "operationId": "getConsul",
        "parameters": [
          {
            "type": "string",
            "description": "Consul server id",
            "name": "id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/consul"
            }
          },
          "404": {
            "description": "The specified resource was not found",
            "schema": {
              "$ref": "#/definitions/error"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "description": "General Error",
            "schema": {
              "$ref": "#/definitions/error"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          }
        }
      },
      "put": {
        "description": "Replaces a Consul server configuration by it's id.",
        "tags": [
          "ServiceDiscovery"
        ],
        "summary": "Replace a Consul server",
        "operationId": "replaceConsul",
        "parameters": [
          {
            "type": "string",
            "description": "Consul Index",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/consul"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Consul server replaced",
            "schema": {
              "$ref": "#/definitions/consul"
            }
          },
          "400": {
            "description": "Bad request",
            "schema": {
              "$ref": "#/definitions/error"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "description": "The specified resource was not found",
            "schema": {
              "$ref": "#/definitions/error"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "description": "General Error",
            "schema": {
              "$ref": "#/definitions/error"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          }
        }
      },
      "delete": {
        "description": "Deletes a Consul server configuration by it's id.",
        "tags": [
          "ServiceDiscovery"
        ],
        "summary": "Delete a Consul server",
        "operationId": "deleteConsul",
        "parameters": [
          {
            "type": "string",
            "description": "Consul server Index",
            "name": "id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "Consul server deleted"
          },
          "404": {
            "description": "The specified resource was not found",
            "schema": {
              "$ref": "#/definitions/error"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "description": "General Error",
            "schema": {
              "$ref": "#/definitions/error"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          }
        }
      }
    },
    "/services": {
      "get": {
        "description": "Returns a list of API managed services endpoints.",
        "produces": [
          "application/json"
        ],
        "tags": [
          "Discovery"
        ],
        "summary": "Return list of service endpoints",
        "operationId": "getServicesEndpoints",
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "$ref": "#/definitions/endpoints"
            }
          },
          "default": {
            "description": "General Error",
            "schema": {
              "$ref": "#/definitions/error"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          }
        }
      }
    },
    "/services/haproxy": {
      "get": {
        "description": "Returns a list of HAProxy related endpoints.",
        "produces": [
          "application/json"
        ],
        "tags": [
          "Discovery"
        ],
        "summary": "Return list of HAProxy related endpoints",
        "operationId": "getHaproxyEndpoints",
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "$ref": "#/definitions/endpoints"
            }
          },
          "default": {
            "description": "General Error",
            "schema": {
              "$ref": "#/definitions/error"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          }
        }
      }
    },
    "/services/haproxy/configuration": {
      "get": {
        "description": "Returns a list of endpoints to be used for advanced configuration of HAProxy objects.",
        "produces": [
          "application/json"
        ],
        "tags": [
          "Discovery"
        ],
        "summary": "Return list of HAProxy advanced configuration endpoints",
        "operationId": "getConfigurationEndpoints",
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "$ref": "#/definitions/endpoints"
            }
          },
          "default": {
            "description": "General Error",
            "schema": {
              "$ref": "#/definitions/error"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          }
        }
      }
    },
    "/services/haproxy/configuration/backends": {
      "get": {
        "description": "Returns an array of all configured backends.",
        "tags": [
          "Backend"
        ],
        "summary": "Return an array of backends",
        "operationId": "getBackends",
        "parameters": [
          {
            "type": "string",
            "x-nullable": false,
            "description": "ID of the transaction where we want to add the operation. Cannot be used when version is specified.",
            "name": "transaction_id",
            "in": "query"
          },
          {
            "type": "boolean",
            "default": false,
            "description": "Indicates if the action affects the specified child resources as well",
            "name": "full_section",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/backends"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "description": "General Error",
            "schema": {
              "$ref": "#/definitions/error"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          }
        }
      },
      "post": {
        "description": "Adds a new backend to the configuration file.",
        "tags": [
          "Backend"
        ],
        "summary": "Add a backend",
        "operationId": "createBackend",
        "parameters": [
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/backend"
            }
          },
          {
            "type": "string",
            "x-nullable": false,
            "description": "ID of the transaction where we want to add the operation. Cannot be used when version is specified.",
            "name": "transaction_id",
            "in": "query"
          },
          {
            "type": "integer",
            "x-nullable": false,
            "description": "Version used for checking configuration version. Cannot be used when transaction is specified, transaction has it's own version.",
            "name": "version",
            "in": "query"
          },
          {
            "type": "boolean",
            "default": false,
            "description": "If set, do a force reload, do not wait for the configured reload-delay. Cannot be used when transaction is specified, as changes in transaction are not applied directly to configuration.",
            "name": "force_reload",
            "in": "query"
          },
          {
            "type": "boolean",
            "default": false,
            "description": "Indicates if the action affects the specified child resources as well",
            "name": "full_section",
            "in": "query"
          }
        ],
        "responses": {
          "201": {
            "description": "Backend created",
            "schema": {
              "$ref": "#/definitions/backend"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/backend"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "description": "Bad request",
            "schema": {
              "$ref": "#/definitions/error"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "409": {
            "description": "The specified resource already exists",
            "schema": {
              "$ref": "#/definitions/error"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "description": "General Error",
            "schema": {
              "$ref": "#/definitions/error"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          }
        }
      }
    },
    "/services/haproxy/configuration/backends/{name}": {
      "get": {
        "description": "Returns one backend configuration by it's name.",
        "tags": [
          "Backend"
        ],
        "summary": "Return a backend",
        "operationId": "getBackend",
        "parameters": [
          {
            "type": "string",
            "description": "Backend name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "x-nullable": false,
            "description": "ID of the transaction where we want to add the operation. Cannot be used when version is specified.",
            "name": "transaction_id",
            "in": "query"
          },
          {
            "type": "boolean",
            "default": false,
            "description": "Indicates if the action affects the specified child resources as well",
            "name": "full_section",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful operation",
            "schema": {
              "$ref": "#/definitions/backend"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "description": "The specified resource was not found",
            "schema": {
              "$ref": "#/definitions/error"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "description": "General Error",
            "schema": {
              "$ref": "#/definitions/error"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          }
        }
      },
      "put": {
        "description": "Replaces a backend configuration by it's name.",
        "tags": [
          "Backend"
        ],
        "summary": "Replace a backend",
        "operationId": "replaceBackend",
        "parameters": [
          {
            "type": "string",
            "description": "Backend name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/backend"
            }
          },
          {
            "type": "string",
            "x-nullable": false,
            "description": "ID of the transaction where we want to add the operation. Cannot be used when version is specified.",
            "name": "transaction_id",
            "in": "query"
          },
          {
            "type": "integer",
            "x-nullable": false,
            "description": "Version used for checking configuration version. Cannot be used when transaction is specified, transaction has it's own version.",
            "name": "version",
            "in": "query"
          },
          {
            "type": "boolean",
            "default": false,
            "description": "If set, do a force reload, do not wait for the configured reload-delay. Cannot be used when transaction is specified, as changes in transaction are not applied directly to configuration.",
            "name": "force_reload",
            "in": "query"
          },
          {
            "type": "boolean",
            "default": false,
            "description": "Indicates if the action affects the specified child resources as well",
            "name": "full_section",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Backend replaced",
            "schema": {
              "$ref": "#/definitions/backend"
            }
          },
          "202": {
            "description": "Configuration change accepted and reload requested",
            "schema": {
              "$ref": "#/definitions/backend"
            },
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "400": {
            "description": "Bad request",
            "schema": {
              "$ref": "#/definitions/error"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "404": {
            "description": "The specified resource was not found",
            "schema": {
              "$ref": "#/definitions/error"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "description": "General Error",
            "schema": {
              "$ref": "#/definitions/error"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          }
        }
      },
      "delete": {
        "description": "Deletes a backend from the configuration by it's name.",
        "tags": [
          "Backend"
        ],
        "summary": "Delete a backend",
        "operationId": "deleteBackend",
        "parameters": [
          {
            "type": "string",
            "description": "Backend name",
            "name": "name",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "x-nullable": false,
            "description": "ID of the transaction where we want to add the operation. Cannot be used when version is specified.",
            "name": "transaction_id",
            "in": "query"
          },
          {
            "type": "integer",
            "x-nullable": false,
            "description": "Version used for checking configuration version. Cannot be used when transaction is specified, transaction has it's own version.",
            "name": "version",
            "in": "query"
          },
          {
            "type": "boolean",
            "default": false,
            "description": "If set, do a force reload, do not wait for the configured reload-delay. Cannot be used when transaction is specified, as changes in transaction are not applied directly to configuration.",
            "name": "force_reload",
            "in": "query"
          }
        ],
        "responses": {
          "202": {
            "description": "Configuration change accepted and reload requested",
            "headers": {
              "Reload-ID": {
                "type": "string",
                "description": "ID of the requested reload"
              }
            }
          },
          "204": {
            "description": "Backend deleted"
          },
          "404": {
            "description": "The specified resource was not found",
            "schema": {
              "$ref": "#/definitions/error"
            },
            "headers": {
              "Configuration-Version": {
                "type": "string",
                "description": "Configuration file version"
              }
            }
          },
          "default": {
            "description": "General