// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package tcp_check

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetAllTCPCheckBackendOKCode is the HTTP code returned for type GetAllTCPCheckBackendOK
const GetAllTCPCheckBackendOKCode int = 200

/*
GetAllTCPCheckBackendOK Successful operation

swagger:response getAllTcpCheckBackendOK
*/
type GetAllTCPCheckBackendOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload models.TCPChecks `json:"body,omitempty"`
}

// NewGetAllTCPCheckBackendOK creates GetAllTCPCheckBackendOK with default headers values
func NewGetAllTCPCheckBackendOK() *GetAllTCPCheckBackendOK {

	return &GetAllTCPCheckBackendOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get all Tcp check backend o k response
func (o *GetAllTCPCheckBackendOK) WithConfigurationVersion(configurationVersion string) *GetAllTCPCheckBackendOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all Tcp check backend o k response
func (o *GetAllTCPCheckBackendOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all Tcp check backend o k response
func (o *GetAllTCPCheckBackendOK) WithPayload(payload models.TCPChecks) *GetAllTCPCheckBackendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all Tcp check backend o k response
func (o *GetAllTCPCheckBackendOK) SetPayload(payload models.TCPChecks) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllTCPCheckBackendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.TCPChecks{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

/*
GetAllTCPCheckBackendDefault General Error

swagger:response getAllTcpCheckBackendDefault
*/
type GetAllTCPCheckBackendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetAllTCPCheckBackendDefault creates GetAllTCPCheckBackendDefault with default headers values
func NewGetAllTCPCheckBackendDefault(code int) *GetAllTCPCheckBackendDefault {
	if code <= 0 {
		code = 500
	}

	return &GetAllTCPCheckBackendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get all TCP check backend default response
func (o *GetAllTCPCheckBackendDefault) WithStatusCode(code int) *GetAllTCPCheckBackendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get all TCP check backend default response
func (o *GetAllTCPCheckBackendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get all TCP check backend default response
func (o *GetAllTCPCheckBackendDefault) WithConfigurationVersion(configurationVersion string) *GetAllTCPCheckBackendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all TCP check backend default response
func (o *GetAllTCPCheckBackendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all TCP check backend default response
func (o *GetAllTCPCheckBackendDefault) WithPayload(payload *models.Error) *GetAllTCPCheckBackendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all TCP check backend default response
func (o *GetAllTCPCheckBackendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllTCPCheckBackendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
