/*
 * Decompiled with CFR 0.152.
 */
package org.hampelratte.svdrp.util;

import java.util.Iterator;
import java.util.List;
import org.hampelratte.svdrp.responses.highlevel.Folder;
import org.hampelratte.svdrp.responses.highlevel.Recording;
import org.hampelratte.svdrp.responses.highlevel.TreeNode;
import org.hampelratte.svdrp.sorting.RecordingSortStrategy;

public class RecordingTreeBuilder {
    public static Folder buildTree(List<Recording> recordings, RecordingSortStrategy sortStrategy) {
        sortStrategy.sort(recordings);
        Folder root = RecordingTreeBuilder.buildTree(recordings);
        RecordingTreeBuilder.mergeConsecutiveFolders(root);
        return root;
    }

    public static Folder buildTree(List<Recording> recordings) {
        Folder root = new Folder("Aufnahmen");
        for (Recording recording : recordings) {
            TreeNode subtree = RecordingTreeBuilder.buildSubTree(recording);
            root.getChildren().add(subtree);
        }
        RecordingTreeBuilder.mergeConsecutiveFolders(root);
        return root;
    }

    private static TreeNode buildSubTree(Recording recording) {
        String title = recording.getTitle();
        String[] folders = title.split("~");
        if (folders.length > 1) {
            Folder subtree;
            Folder currentFolder = subtree = new Folder(folders[0]);
            for (int i = 1; i < folders.length; ++i) {
                if (i < folders.length - 1) {
                    Folder child = new Folder(folders[i]);
                    currentFolder.getChildren().add(child);
                    currentFolder = child;
                    continue;
                }
                currentFolder.getChildren().add(recording);
            }
            return subtree;
        }
        return recording;
    }

    private static void mergeConsecutiveFolders(Folder folder) {
        int merges = 1;
        while (merges > 0) {
            merges = 0;
            Iterator<TreeNode> iter = folder.getChildren().iterator();
            while (iter.hasNext()) {
                TreeNode next;
                TreeNode current = iter.next();
                if (!(current instanceof Folder)) continue;
                Folder currentFolder = (Folder)current;
                RecordingTreeBuilder.mergeConsecutiveFolders(currentFolder);
                if (!iter.hasNext() || !((next = iter.next()) instanceof Folder) || !current.getDisplayTitle().equals(next.getDisplayTitle())) continue;
                ++merges;
                Folder nextFolder = (Folder)next;
                currentFolder.getChildren().addAll(nextFolder.getChildren());
                iter.remove();
            }
        }
    }
}

