# simd

[![MIT licensed][mit-badge]][mit-url]

[mit-badge]: https://img.shields.io/badge/license-MIT-blue.svg
[mit-url]: ./LICENSE

SIMD-accelerated operations

## simd-abstraction

[![Crates.io](https://img.shields.io/crates/v/simd-abstraction.svg)](https://crates.io/crates/simd-abstraction)
[![Docs](https://docs.rs/simd-abstraction/badge.svg)](https://docs.rs/simd-abstraction/)

Abstract SIMD instruction sets

## uuid-simd

[![Crates.io](https://img.shields.io/crates/v/uuid-simd.svg)](https://crates.io/crates/uuid-simd)
[![Docs](https://docs.rs/uuid-simd/badge.svg)](https://docs.rs/uuid-simd/)

SIMD-accelerated UUID operations

## hex-simd

[![Crates.io](https://img.shields.io/crates/v/hex-simd.svg)](https://crates.io/crates/hex-simd)
[![Docs](https://docs.rs/hex-simd/badge.svg)](https://docs.rs/hex-simd/)

SIMD-accelerated hex encoding and decoding.

Inspired by [faster-hex](https://github.com/nervosnetwork/faster-hex)

## base64-simd

[![Crates.io](https://img.shields.io/crates/v/base64-simd.svg)](https://crates.io/crates/base64-simd)
[![Docs](https://docs.rs/base64-simd/badge.svg)](https://docs.rs/base64-simd/)

SIMD-accelerated base64 encoding and decoding.

Inspired by [base64](https://github.com/marshallpierce/rust-base64) and [radix64](https://github.com/ggriffiniii/radix64)

References:

+ <http://0x80.pl/notesen/2016-01-12-sse-base64-encoding.html>
+ <http://0x80.pl/notesen/2016-01-17-sse-base64-decoding.html>
