/*
 * Decompiled with CFR 0.152.
 */
package com.rm5248.dbusjava.nativefd;

import com.rm5248.dbusjava.nativefd.NativeMessageReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import jnr.posix.POSIX;
import jnr.posix.POSIXFactory;
import org.freedesktop.dbus.FileDescriptor;
import org.freedesktop.dbus.messages.Message;
import org.freedesktop.dbus.spi.message.IMessageWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeMessageWriter
implements IMessageWriter {
    private static POSIX POSIX = POSIXFactory.getPOSIX();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final Logger logger_native = LoggerFactory.getLogger(NativeMessageReader.class.getName() + ".native");
    private int m_fd;
    private boolean m_isClosed;
    private int m_nativeHandle;

    public NativeMessageWriter(int fd) {
        this.m_fd = fd;
        this.m_isClosed = false;
        this.m_nativeHandle = this.openNativeHandle(this.m_fd);
    }

    @Override
    public void writeMessage(Message m) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
        int[] fds = new int[m.getFiledescriptors().size()];
        int loc = 0;
        this.logger.debug("<= {}", (Object)m);
        if (null == m.getWireData()) {
            this.logger.warn("Message {} wire-data was null!", (Object)m);
            return;
        }
        for (byte[] buf : m.getWireData()) {
            if (buf == null) break;
            bos.write(buf);
        }
        Object object = m.getFiledescriptors().iterator();
        while (object.hasNext()) {
            FileDescriptor fd = (FileDescriptor)object.next();
            fds[loc++] = fd.getIntFileDescriptor();
        }
        this.writeNative(this.m_nativeHandle, bos.toByteArray(), fds);
    }

    @Override
    public boolean isClosed() {
        return this.m_isClosed;
    }

    @Override
    public void close() throws IOException {
        if (this.m_isClosed) {
            return;
        }
        this.m_isClosed = true;
        POSIX.close(this.m_fd);
        this.closeNativeHandle(this.m_nativeHandle);
    }

    private native int openNativeHandle(int var1);

    private native void closeNativeHandle(int var1);

    private native void writeNative(int var1, byte[] var2, int[] var3) throws IOException;
}

