/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.id;

import java.io.Serializable;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.collection.PersistentCollection;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.id.IdentifierGenerationException;
import net.sf.hibernate.id.IdentifierGenerator;

public class Assigned
implements IdentifierGenerator {
    public static final Assigned INSTANCE = new Assigned();

    public Serializable generate(SessionImplementor session, Object obj) throws HibernateException {
        if (obj instanceof PersistentCollection) {
            throw new IdentifierGenerationException("Illegal use of assigned id generation for a toplevel collection");
        }
        Serializable id = session.getPersister(obj).getIdentifier(obj);
        if (id == null) {
            throw new IdentifierGenerationException("ids for this class must be manually assigned before calling save(): " + obj.getClass().getName());
        }
        return id;
    }
}

