# - Try to find the FriBidi
# Once done this will define
#
#  FRIBIDI_FOUND - system has FriBidi
#  FRIBIDI_INCLUDE_DIRS - The include directory to use for the FriBidi headers
#  FRIBIDI_LIBRARIES - Link these to use FriBidi
#  FRIBIDI_DEFINITIONS - Compiler switches required for using FriBidi
#  FRIBIDI_VERSION - The version of the FriBidi library which was found.

# THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
# IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
# NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
# THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#

mark_as_advanced(FRIBIDI_LIBRARY FRIBIDI_INCLUDE_DIR)

if (FRIBIDI_LIBRARY AND FRIBIDI_INCLUDE_DIR)

  # in cache already
  set(FRIBIDI_FOUND TRUE)

else (FRIBIDI_LIBRARY AND FRIBIDI_INCLUDE_DIR)

  if (NOT MSVC)
    # use pkg-config to get the directories and then use these values
    # in the FIND_PATH() and FIND_LIBRARY() calls
    find_package(PkgConfig QUIET)
    pkg_check_modules(PC_FRIBIDI QUIET fribidi)

    set(FRIBIDI_DEFINITIONS ${PC_FRIBIDI_CFLAGS_OTHER})
    set(FRIBIDI_VERSION ${PC_FRIBIDI_VERSION})
  endif (NOT MSVC)

  find_path(FRIBIDI_INCLUDE_DIR fribidi/fribidi.h
    PATHS
    ${PC_FRIBIDI_INCLUDEDIR}
    ${PC_FRIBIDI_INCLUDE_DIRS}
  )

  find_library(FRIBIDI_LIBRARY NAMES fribidi
    PATHS
    ${PC_FRIBIDI_LIBDIR}
    ${PC_FRIBIDI_LIBRARY_DIRS}
  )

  if (NOT FRIBIDI_VERSION)
    if(EXISTS "${FRIBIDI_INCLUDE_DIR}/fribidi/fribidi-config.h")
      file(STRINGS "${FRIBIDI_INCLUDE_DIR}/fribidi/fribidi-config.h"
        _FRIBIDI_VERSION_MAJOR REGEX "^#define FRIBIDI_MAJOR_VERSION")
      string(REGEX MATCH "[0-9]+" FRIBIDI_VERSION_MAJOR "${_FRIBIDI_VERSION_MAJOR}")
      file(STRINGS "${FRIBIDI_INCLUDE_DIR}/fribidi/fribidi-config.h"
        _FRIBIDI_VERSION_MINOR REGEX "^#define FRIBIDI_MINOR_VERSION")
      string(REGEX MATCH "[0-9]+" FRIBIDI_VERSION_MINOR "${_FRIBIDI_VERSION_MINOR}")
      file(STRINGS "${FRIBIDI_INCLUDE_DIR}/fribidi/fribidi-config.h"
        _FRIBIDI_VERSION_MICRO REGEX "^#define FRIBIDI_MICRO_VERSION")
      string(REGEX MATCH "[0-9]+" FRIBIDI_VERSION_MICRO "${_FRIBIDI_VERSION_MICRO}")
      set(FRIBIDI_VERSION ${FRIBIDI_VERSION_MAJOR}.${FRIBIDI_VERSION_MINOR}.${FRIBIDI_VERSION_MICRO})
    endif()
  endif()

  include(FindPackageHandleStandardArgs)
  find_package_handle_standard_args(FriBidi
    FOUND_VAR FRIBIDI_FOUND
    REQUIRED_VARS
      FRIBIDI_LIBRARY
      FRIBIDI_INCLUDE_DIR
    VERSION_VAR FRIBIDI_VERSION
  )

endif (FRIBIDI_LIBRARY AND FRIBIDI_INCLUDE_DIR)

if(FRIBIDI_FOUND)
  set(FRIBIDI_LIBRARIES ${FRIBIDI_LIBRARY})
  set(FRIBIDI_INCLUDE_DIRS ${FRIBIDI_INCLUDE_DIR})
  if(NOT TARGET FriBidi::FriBidi)
    add_library(FriBidi::FriBidi UNKNOWN IMPORTED)
    set_target_properties(FriBidi::FriBidi PROPERTIES
      IMPORTED_LOCATION "${FRIBIDI_LIBRARIES}"
      INTERFACE_COMPILE_DEFINITIONS "${FRIBIDI_DEFINITIONS}"
      INTERFACE_INCLUDE_DIRECTORIES "${FRIBIDI_INCLUDE_DIRS}"
    )
  endif()
endif(FRIBIDI_FOUND)
