/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.maven.transformer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jfrog.build.extractor.EolDetectingInputStream;
import org.jfrog.build.extractor.maven.reader.ModuleName;
import org.jfrog.build.extractor.maven.transformer.SnapshotNotAllowedException;

public class PomTransformer {
    private final String UNIX_DEFAULT_PARENT_POM_RELATIVE_PATH = "../pom.xml";
    private final String WINDOWS_DEFAULT_PARENT_POM_RELATIVE_PATH = "..\\pom.xml";
    private final String scmUrl;
    private final ModuleName currentModule;
    private final Map<ModuleName, String> versionsByModule;
    private final boolean failOnSnapshot;
    private final boolean dryRun;
    private boolean modified;
    private File pomFile;
    private Map<String, String> pomProperties = new HashMap<String, String>();
    private String nextPomToLoad = null;

    public PomTransformer(ModuleName currentModule, Map<ModuleName, String> versionsByModule, String scmUrl) {
        this(currentModule, versionsByModule, scmUrl, false, false);
    }

    public PomTransformer(ModuleName currentModule, Map<ModuleName, String> versionsByModule, String scmUrl, boolean failOnSnapshot) {
        this(currentModule, versionsByModule, scmUrl, failOnSnapshot, false);
    }

    public PomTransformer(ModuleName currentModule, Map<ModuleName, String> versionsByModule, String scmUrl, boolean failOnSnapshot, boolean dryRun) {
        this.currentModule = currentModule;
        this.versionsByModule = versionsByModule;
        this.scmUrl = scmUrl;
        this.failOnSnapshot = failOnSnapshot;
        this.dryRun = dryRun;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean transform(File pomFile) throws IOException {
        Document document;
        this.pomFile = pomFile;
        if (!pomFile.exists()) {
            throw new IllegalArgumentException("Couldn't find pom file: " + pomFile);
        }
        SAXBuilder saxBuilder = PomTransformer.createSaxBuilder();
        EolDetectingInputStream eolDetectingStream = null;
        InputStreamReader inputStreamReader = null;
        try {
            eolDetectingStream = new EolDetectingInputStream(new FileInputStream(pomFile));
            inputStreamReader = new InputStreamReader((InputStream)eolDetectingStream, "UTF-8");
            document = saxBuilder.build((Reader)inputStreamReader);
        }
        catch (JDOMException e) {
            try {
                throw new IOException("Failed to parse pom: " + pomFile.getAbsolutePath(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStreamReader);
                IOUtils.closeQuietly(eolDetectingStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(inputStreamReader);
        IOUtils.closeQuietly(eolDetectingStream);
        Element rootElement = document.getRootElement();
        Namespace ns = rootElement.getNamespace();
        this.getProperties(rootElement, ns);
        this.changeParentVersion(rootElement, ns);
        this.changeCurrentModuleVersion(rootElement, ns);
        this.changeDependencyManagementVersions(rootElement, ns);
        this.changeDependencyVersions(rootElement, ns);
        if (this.scmUrl != null) {
            this.changeScm(rootElement, ns);
        }
        if (this.modified && !this.dryRun) {
            FileOutputStream fileOutputStream = new FileOutputStream(pomFile);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            try {
                XMLOutputter outputter = new XMLOutputter();
                String eol = eolDetectingStream.getEol();
                if (!"".equals(eol)) {
                    Format format = outputter.getFormat();
                    format.setLineSeparator(eol);
                    format.setTextMode(Format.TextMode.PRESERVE);
                    outputter.setFormat(format);
                }
                outputter.output(document, (Writer)outputStreamWriter);
            }
            finally {
                IOUtils.closeQuietly(outputStreamWriter);
                IOUtils.closeQuietly(fileOutputStream);
            }
        }
        return this.modified;
    }

    private void getProperties(Element root, Namespace ns) {
        Element propertiesElement = root.getChild("properties", ns);
        if (propertiesElement == null) {
            return;
        }
        List children = propertiesElement.getChildren();
        for (Element child : children) {
            String key = child.getName();
            if (this.pomProperties.get(key) != null) continue;
            this.pomProperties.put(key, child.getText());
        }
    }

    private void changeParentVersion(Element root, Namespace ns) {
        Element parentElement = root.getChild("parent", ns);
        if (parentElement == null) {
            return;
        }
        Element relativePath = parentElement.getChild("relativePath", ns);
        String relativeParentPath = relativePath == null ? ".." + File.separator + "pom.xml" : relativePath.getText();
        this.nextPomToLoad = StringUtils.substringBeforeLast(this.pomFile.getAbsolutePath(), File.separator) + File.separator + relativeParentPath;
        ModuleName parentName = this.extractModuleName(parentElement, ns);
        if (this.versionsByModule.containsKey(parentName)) {
            this.setVersion(parentElement, ns, this.versionsByModule.get(parentName));
        }
        this.verifyNonSnapshotVersion(parentName, parentElement, ns);
    }

    private void changeCurrentModuleVersion(Element rootElement, Namespace ns) {
        this.setVersion(rootElement, ns, this.versionsByModule.get(this.currentModule));
        this.verifyNonSnapshotVersion(this.currentModule, rootElement, ns);
    }

    private void changeDependencyManagementVersions(Element rootElement, Namespace ns) {
        Element dependencyManagement = rootElement.getChild("dependencyManagement", ns);
        if (dependencyManagement == null) {
            return;
        }
        Element dependenciesElement = dependencyManagement.getChild("dependencies", ns);
        if (dependenciesElement == null) {
            return;
        }
        List dependencies = dependenciesElement.getChildren("dependency", ns);
        for (Element dependency : dependencies) {
            this.changeDependencyVersion(ns, dependency);
        }
    }

    private void changeDependencyVersions(Element rootElement, Namespace ns) {
        Element dependenciesElement = rootElement.getChild("dependencies", ns);
        if (dependenciesElement == null) {
            return;
        }
        List dependencies = dependenciesElement.getChildren("dependency", ns);
        for (Element dependency : dependencies) {
            this.changeDependencyVersion(ns, dependency);
        }
    }

    private void changeDependencyVersion(Namespace ns, Element dependency) {
        ModuleName moduleName = this.extractModuleName(dependency, ns);
        if (this.versionsByModule.containsKey(moduleName)) {
            this.setVersion(dependency, ns, this.versionsByModule.get(moduleName));
        }
        this.verifyNonSnapshotVersion(moduleName, dependency, ns);
    }

    private void changeScm(Element rootElement, Namespace ns) {
        Element url;
        Element developerConnection;
        Element scm = rootElement.getChild("scm", ns);
        if (scm == null) {
            return;
        }
        Element connection = scm.getChild("connection", ns);
        if (connection != null) {
            connection.setText("scm:svn:" + this.scmUrl);
        }
        if ((developerConnection = scm.getChild("developerConnection", ns)) != null) {
            developerConnection.setText("scm:svn:" + this.scmUrl);
        }
        if ((url = scm.getChild("url", ns)) != null) {
            url.setText(this.scmUrl);
        }
    }

    private void setVersion(Element element, Namespace ns, String version) {
        String currentVersion;
        Element versionElement = element.getChild("version", ns);
        if (versionElement != null && !version.equals(currentVersion = versionElement.getText())) {
            versionElement.setText(version);
            this.modified = true;
        }
    }

    private void verifyNonSnapshotVersion(ModuleName moduleName, Element element, Namespace ns) {
        String currentVersion;
        if (!this.failOnSnapshot) {
            return;
        }
        Element versionElement = element.getChild("version", ns);
        if (versionElement != null && ((currentVersion = versionElement.getText()).endsWith("-SNAPSHOT") || currentVersion.startsWith("${") && currentVersion.endsWith("}") && this.evalExpression(currentVersion) != null && this.evalExpression(currentVersion).endsWith("-SNAPSHOT"))) {
            throw new SnapshotNotAllowedException(String.format("Snapshot detected in file '%s': %s:%s", this.pomFile.getAbsolutePath(), moduleName, currentVersion));
        }
    }

    private String evalExpression(String expr) {
        String expression = this.pomProperties.get(expr.substring(2, expr.lastIndexOf("}")));
        if (expression != null) {
            return expression;
        }
        if (this.loadNextProperties()) {
            return this.evalExpression(expr);
        }
        return null;
    }

    private boolean loadNextProperties() {
        if (this.nextPomToLoad == null) {
            return false;
        }
        MavenXpp3Reader mavenReader = new MavenXpp3Reader();
        try (FileReader reader = new FileReader(this.nextPomToLoad);){
            Model model = mavenReader.read((Reader)reader);
            Properties properties = model.getProperties();
            for (String key : properties.stringPropertyNames()) {
                if (this.pomProperties.get(key) != null) continue;
                this.pomProperties.put(key, properties.getProperty(key));
            }
            Parent parent = model.getParent();
            if (parent != null) {
                String relativePath = parent.getRelativePath();
                if (File.separatorChar == '\\' && "../pom.xml".equals(relativePath)) {
                    relativePath = "..\\pom.xml";
                }
                this.nextPomToLoad = StringUtils.substringBeforeLast(this.nextPomToLoad, File.separator) + File.separator + relativePath;
            } else {
                this.nextPomToLoad = null;
            }
        }
        catch (Exception e) {
            Logger.getLogger(PomTransformer.class.getName()).info("couldn't load pom file at: " + this.nextPomToLoad);
            return false;
        }
        return true;
    }

    private ModuleName extractModuleName(Element element, Namespace ns) {
        String groupId = element.getChildText("groupId", ns);
        String artifactId = element.getChildText("artifactId", ns);
        if (StringUtils.isBlank(groupId) || StringUtils.isBlank(artifactId)) {
            throw new IllegalArgumentException("Couldn't extract module key from: " + element);
        }
        return new ModuleName(groupId, artifactId);
    }

    static SAXBuilder createSaxBuilder() {
        SAXBuilder sb = new SAXBuilder();
        sb.setValidation(false);
        sb.setFeature("http://xml.org/sax/features/validation", false);
        sb.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
        sb.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        return sb;
    }
}

