# Normal Form Grapheme roundtrip tests, generated from NormalizationTests.txt in
# the Unicode database by S15-nfg/test-gen.raku. Check we can take a Uni, turn it
# into an NFG string, and then get codepoints back out of it in NFC.
# NormalizationTest-15.0.0.txt
# Date: 2022-04-02, 01:29:09 GMT

use Test;

plan 500;
ok Uni.new(0x1E0A, 0x323).Str.NFC.list ~~ (0x1E0C, 0x307,), '0x1E0A, 0x323 -> Str -> 0x1E0C, 0x307 NormalizationTest.txt line no 46';
ok Uni.new(0x44, 0x307, 0x323).Str.NFC.list ~~ (0x1E0C, 0x307,), '0x44, 0x307, 0x323 -> Str -> 0x1E0C, 0x307 NormalizationTest.txt line no 48';
ok Uni.new(0x44, 0x323, 0x307).Str.NFC.list ~~ (0x1E0C, 0x307,), '0x44, 0x323, 0x307 -> Str -> 0x1E0C, 0x307 NormalizationTest.txt line no 49';
ok Uni.new(0x1E0A, 0x31B, 0x323).Str.NFC.list ~~ (0x1E0C, 0x31B, 0x307,), '0x1E0A, 0x31B, 0x323 -> Str -> 0x1E0C, 0x31B, 0x307 NormalizationTest.txt line no 52';
ok Uni.new(0x44, 0x31B, 0x307, 0x323).Str.NFC.list ~~ (0x1E0C, 0x31B, 0x307,), '0x44, 0x31B, 0x307, 0x323 -> Str -> 0x1E0C, 0x31B, 0x307 NormalizationTest.txt line no 54';
ok Uni.new(0x44, 0x31B, 0x323, 0x307).Str.NFC.list ~~ (0x1E0C, 0x31B, 0x307,), '0x44, 0x31B, 0x323, 0x307 -> Str -> 0x1E0C, 0x31B, 0x307 NormalizationTest.txt line no 55';
ok Uni.new(0x45, 0x300).Str.NFC.list ~~ (0xC8,), '0x45, 0x300 -> Str -> 0xC8 NormalizationTest.txt line no 58';
ok Uni.new(0x45, 0x304).Str.NFC.list ~~ (0x112,), '0x45, 0x304 -> Str -> 0x112 NormalizationTest.txt line no 59';
ok Uni.new(0x112, 0x300).Str.NFC.list ~~ (0x1E14,), '0x112, 0x300 -> Str -> 0x1E14 NormalizationTest.txt line no 61';
ok Uni.new(0x45, 0x304, 0x300).Str.NFC.list ~~ (0x1E14,), '0x45, 0x304, 0x300 -> Str -> 0x1E14 NormalizationTest.txt line no 63';
ok Uni.new(0x45, 0x300, 0x304).Str.NFC.list ~~ (0xC8, 0x304,), '0x45, 0x300, 0x304 -> Str -> 0xC8, 0x304 NormalizationTest.txt line no 64';
ok Uni.new(0x5B8, 0x5B9, 0x5B1, 0x591, 0x5C3, 0x5B0, 0x5AC, 0x59F).Str.NFC.list ~~ (0x5B1, 0x5B8, 0x5B9, 0x591, 0x5C3, 0x5B0, 0x5AC, 0x59F,), '0x5B8, 0x5B9, 0x5B1, 0x591, 0x5C3, 0x5B0, 0x5AC, 0x59F -> Str -> 0x5B1, 0x5B8, 0x5B9, 0x591, 0x5C3, 0x5B0, 0x5AC, 0x59F NormalizationTest.txt line no 65';
ok Uni.new(0x592, 0x5B7, 0x5BC, 0x5A5, 0x5B0, 0x5C0, 0x5C4, 0x5AD).Str.NFC.list ~~ (0x5B0, 0x5B7, 0x5BC, 0x5A5, 0x592, 0x5C0, 0x5AD, 0x5C4,), '0x592, 0x5B7, 0x5BC, 0x5A5, 0x5B0, 0x5C0, 0x5C4, 0x5AD -> Str -> 0x5B0, 0x5B7, 0x5BC, 0x5A5, 0x592, 0x5C0, 0x5AD, 0x5C4 NormalizationTest.txt line no 66';
ok Uni.new(0x1100, 0xAC00, 0x11A8).Str.NFC.list ~~ (0x1100, 0xAC01,), '0x1100, 0xAC00, 0x11A8 -> Str -> 0x1100, 0xAC01 NormalizationTest.txt line no 67';
ok Uni.new(0x1100, 0xAC00, 0x11A8, 0x11A8).Str.NFC.list ~~ (0x1100, 0xAC01, 0x11A8,), '0x1100, 0xAC00, 0x11A8, 0x11A8 -> Str -> 0x1100, 0xAC01, 0x11A8 NormalizationTest.txt line no 68';
ok Uni.new(0x340).Str.NFC.list ~~ (0x300,), '0x340 -> Str -> 0x300 NormalizationTest.txt line no 377';
ok Uni.new(0x341).Str.NFC.list ~~ (0x301,), '0x341 -> Str -> 0x301 NormalizationTest.txt line no 378';
ok Uni.new(0x343).Str.NFC.list ~~ (0x313,), '0x343 -> Str -> 0x313 NormalizationTest.txt line no 379';
ok Uni.new(0x344).Str.NFC.list ~~ (0x308, 0x301,), '0x344 -> Str -> 0x308, 0x301 NormalizationTest.txt line no 380';
ok Uni.new(0x374).Str.NFC.list ~~ (0x2B9,), '0x374 -> Str -> 0x2B9 NormalizationTest.txt line no 381';
ok Uni.new(0x37E).Str.NFC.list ~~ (0x3B,), '0x37E -> Str -> 0x3B NormalizationTest.txt line no 383';
ok Uni.new(0x387).Str.NFC.list ~~ (0xB7,), '0x387 -> Str -> 0xB7 NormalizationTest.txt line no 387';
ok Uni.new(0x958).Str.NFC.list ~~ (0x915, 0x93C,), '0x958 -> Str -> 0x915, 0x93C NormalizationTest.txt line no 488';
ok Uni.new(0x959).Str.NFC.list ~~ (0x916, 0x93C,), '0x959 -> Str -> 0x916, 0x93C NormalizationTest.txt line no 489';
ok Uni.new(0x95A).Str.NFC.list ~~ (0x917, 0x93C,), '0x95A -> Str -> 0x917, 0x93C NormalizationTest.txt line no 490';
ok Uni.new(0x95B).Str.NFC.list ~~ (0x91C, 0x93C,), '0x95B -> Str -> 0x91C, 0x93C NormalizationTest.txt line no 491';
ok Uni.new(0x95C).Str.NFC.list ~~ (0x921, 0x93C,), '0x95C -> Str -> 0x921, 0x93C NormalizationTest.txt line no 492';
ok Uni.new(0x95D).Str.NFC.list ~~ (0x922, 0x93C,), '0x95D -> Str -> 0x922, 0x93C NormalizationTest.txt line no 493';
ok Uni.new(0x95E).Str.NFC.list ~~ (0x92B, 0x93C,), '0x95E -> Str -> 0x92B, 0x93C NormalizationTest.txt line no 494';
ok Uni.new(0x95F).Str.NFC.list ~~ (0x92F, 0x93C,), '0x95F -> Str -> 0x92F, 0x93C NormalizationTest.txt line no 495';
ok Uni.new(0x9DC).Str.NFC.list ~~ (0x9A1, 0x9BC,), '0x9DC -> Str -> 0x9A1, 0x9BC NormalizationTest.txt line no 498';
ok Uni.new(0x9DD).Str.NFC.list ~~ (0x9A2, 0x9BC,), '0x9DD -> Str -> 0x9A2, 0x9BC NormalizationTest.txt line no 499';
ok Uni.new(0x9DF).Str.NFC.list ~~ (0x9AF, 0x9BC,), '0x9DF -> Str -> 0x9AF, 0x9BC NormalizationTest.txt line no 500';
ok Uni.new(0xA33).Str.NFC.list ~~ (0xA32, 0xA3C,), '0xA33 -> Str -> 0xA32, 0xA3C NormalizationTest.txt line no 501';
ok Uni.new(0xA36).Str.NFC.list ~~ (0xA38, 0xA3C,), '0xA36 -> Str -> 0xA38, 0xA3C NormalizationTest.txt line no 502';
ok Uni.new(0xA59).Str.NFC.list ~~ (0xA16, 0xA3C,), '0xA59 -> Str -> 0xA16, 0xA3C NormalizationTest.txt line no 503';
ok Uni.new(0xA5A).Str.NFC.list ~~ (0xA17, 0xA3C,), '0xA5A -> Str -> 0xA17, 0xA3C NormalizationTest.txt line no 504';
ok Uni.new(0xA5B).Str.NFC.list ~~ (0xA1C, 0xA3C,), '0xA5B -> Str -> 0xA1C, 0xA3C NormalizationTest.txt line no 505';
ok Uni.new(0xA5E).Str.NFC.list ~~ (0xA2B, 0xA3C,), '0xA5E -> Str -> 0xA2B, 0xA3C NormalizationTest.txt line no 506';
ok Uni.new(0xB5C).Str.NFC.list ~~ (0xB21, 0xB3C,), '0xB5C -> Str -> 0xB21, 0xB3C NormalizationTest.txt line no 510';
ok Uni.new(0xB5D).Str.NFC.list ~~ (0xB22, 0xB3C,), '0xB5D -> Str -> 0xB22, 0xB3C NormalizationTest.txt line no 511';
ok Uni.new(0xF43).Str.NFC.list ~~ (0xF42, 0xFB7,), '0xF43 -> Str -> 0xF42, 0xFB7 NormalizationTest.txt line no 534';
ok Uni.new(0xF4D).Str.NFC.list ~~ (0xF4C, 0xFB7,), '0xF4D -> Str -> 0xF4C, 0xFB7 NormalizationTest.txt line no 535';
ok Uni.new(0xF52).Str.NFC.list ~~ (0xF51, 0xFB7,), '0xF52 -> Str -> 0xF51, 0xFB7 NormalizationTest.txt line no 536';
ok Uni.new(0xF57).Str.NFC.list ~~ (0xF56, 0xFB7,), '0xF57 -> Str -> 0xF56, 0xFB7 NormalizationTest.txt line no 537';
ok Uni.new(0xF5C).Str.NFC.list ~~ (0xF5B, 0xFB7,), '0xF5C -> Str -> 0xF5B, 0xFB7 NormalizationTest.txt line no 538';
ok Uni.new(0xF69).Str.NFC.list ~~ (0xF40, 0xFB5,), '0xF69 -> Str -> 0xF40, 0xFB5 NormalizationTest.txt line no 539';
ok Uni.new(0xF73).Str.NFC.list ~~ (0xF71, 0xF72,), '0xF73 -> Str -> 0xF71, 0xF72 NormalizationTest.txt line no 540';
ok Uni.new(0xF75).Str.NFC.list ~~ (0xF71, 0xF74,), '0xF75 -> Str -> 0xF71, 0xF74 NormalizationTest.txt line no 541';
ok Uni.new(0xF76).Str.NFC.list ~~ (0xFB2, 0xF80,), '0xF76 -> Str -> 0xFB2, 0xF80 NormalizationTest.txt line no 542';
ok Uni.new(0xF78).Str.NFC.list ~~ (0xFB3, 0xF80,), '0xF78 -> Str -> 0xFB3, 0xF80 NormalizationTest.txt line no 544';
ok Uni.new(0xF81).Str.NFC.list ~~ (0xF71, 0xF80,), '0xF81 -> Str -> 0xF71, 0xF80 NormalizationTest.txt line no 546';
ok Uni.new(0xF93).Str.NFC.list ~~ (0xF92, 0xFB7,), '0xF93 -> Str -> 0xF92, 0xFB7 NormalizationTest.txt line no 547';
ok Uni.new(0xF9D).Str.NFC.list ~~ (0xF9C, 0xFB7,), '0xF9D -> Str -> 0xF9C, 0xFB7 NormalizationTest.txt line no 548';
ok Uni.new(0xFA2).Str.NFC.list ~~ (0xFA1, 0xFB7,), '0xFA2 -> Str -> 0xFA1, 0xFB7 NormalizationTest.txt line no 549';
ok Uni.new(0xFA7).Str.NFC.list ~~ (0xFA6, 0xFB7,), '0xFA7 -> Str -> 0xFA6, 0xFB7 NormalizationTest.txt line no 550';
ok Uni.new(0xFAC).Str.NFC.list ~~ (0xFAB, 0xFB7,), '0xFAC -> Str -> 0xFAB, 0xFB7 NormalizationTest.txt line no 551';
ok Uni.new(0xFB9).Str.NFC.list ~~ (0xF90, 0xFB5,), '0xFB9 -> Str -> 0xF90, 0xFB5 NormalizationTest.txt line no 552';
ok Uni.new(0x1F71).Str.NFC.list ~~ (0x3AC,), '0x1F71 -> Str -> 0x3AC NormalizationTest.txt line no 1011';
ok Uni.new(0x1F73).Str.NFC.list ~~ (0x3AD,), '0x1F73 -> Str -> 0x3AD NormalizationTest.txt line no 1013';
ok Uni.new(0x1F75).Str.NFC.list ~~ (0x3AE,), '0x1F75 -> Str -> 0x3AE NormalizationTest.txt line no 1015';
ok Uni.new(0x1F77).Str.NFC.list ~~ (0x3AF,), '0x1F77 -> Str -> 0x3AF NormalizationTest.txt line no 1017';
ok Uni.new(0x1F79).Str.NFC.list ~~ (0x3CC,), '0x1F79 -> Str -> 0x3CC NormalizationTest.txt line no 1019';
ok Uni.new(0x1F7B).Str.NFC.list ~~ (0x3CD,), '0x1F7B -> Str -> 0x3CD NormalizationTest.txt line no 1021';
ok Uni.new(0x1F7D).Str.NFC.list ~~ (0x3CE,), '0x1F7D -> Str -> 0x3CE NormalizationTest.txt line no 1023';
ok Uni.new(0x1FBB).Str.NFC.list ~~ (0x386,), '0x1FBB -> Str -> 0x386 NormalizationTest.txt line no 1082';
ok Uni.new(0x1FBE).Str.NFC.list ~~ (0x3B9,), '0x1FBE -> Str -> 0x3B9 NormalizationTest.txt line no 1085';
ok Uni.new(0x1FC9).Str.NFC.list ~~ (0x388,), '0x1FC9 -> Str -> 0x388 NormalizationTest.txt line no 1095';
ok Uni.new(0x1FCB).Str.NFC.list ~~ (0x389,), '0x1FCB -> Str -> 0x389 NormalizationTest.txt line no 1097';
ok Uni.new(0x1FD3).Str.NFC.list ~~ (0x390,), '0x1FD3 -> Str -> 0x390 NormalizationTest.txt line no 1105';
ok Uni.new(0x1FDB).Str.NFC.list ~~ (0x38A,), '0x1FDB -> Str -> 0x38A NormalizationTest.txt line no 1111';
ok Uni.new(0x1FE3).Str.NFC.list ~~ (0x3B0,), '0x1FE3 -> Str -> 0x3B0 NormalizationTest.txt line no 1118';
ok Uni.new(0x1FEB).Str.NFC.list ~~ (0x38E,), '0x1FEB -> Str -> 0x38E NormalizationTest.txt line no 1126';
ok Uni.new(0x1FEE).Str.NFC.list ~~ (0x385,), '0x1FEE -> Str -> 0x385 NormalizationTest.txt line no 1129';
ok Uni.new(0x1FEF).Str.NFC.list ~~ (0x60,), '0x1FEF -> Str -> 0x60 NormalizationTest.txt line no 1130';
ok Uni.new(0x1FF9).Str.NFC.list ~~ (0x38C,), '0x1FF9 -> Str -> 0x38C NormalizationTest.txt line no 1137';
ok Uni.new(0x1FFB).Str.NFC.list ~~ (0x38F,), '0x1FFB -> Str -> 0x38F NormalizationTest.txt line no 1139';
ok Uni.new(0x1FFD).Str.NFC.list ~~ (0xB4,), '0x1FFD -> Str -> 0xB4 NormalizationTest.txt line no 1141';
ok Uni.new(0x2000).Str.NFC.list ~~ (0x2002,), '0x2000 -> Str -> 0x2002 NormalizationTest.txt line no 1143';
ok Uni.new(0x2001).Str.NFC.list ~~ (0x2003,), '0x2001 -> Str -> 0x2003 NormalizationTest.txt line no 1144';
ok Uni.new(0x2126).Str.NFC.list ~~ (0x3A9,), '0x2126 -> Str -> 0x3A9 NormalizationTest.txt line no 1243';
ok Uni.new(0x212A).Str.NFC.list ~~ (0x4B,), '0x212A -> Str -> 0x4B NormalizationTest.txt line no 1245';
ok Uni.new(0x212B).Str.NFC.list ~~ (0xC5,), '0x212B -> Str -> 0xC5 NormalizationTest.txt line no 1246';
ok Uni.new(0x2329).Str.NFC.list ~~ (0x3008,), '0x2329 -> Str -> 0x3008 NormalizationTest.txt line no 1367';
ok Uni.new(0x232A).Str.NFC.list ~~ (0x3009,), '0x232A -> Str -> 0x3009 NormalizationTest.txt line no 1368';
ok Uni.new(0x2ADC).Str.NFC.list ~~ (0x2ADD, 0x338,), '0x2ADC -> Str -> 0x2ADD, 0x338 NormalizationTest.txt line no 1512';
ok Uni.new(0xF900).Str.NFC.list ~~ (0x8C48,), '0xF900 -> Str -> 0x8C48 NormalizationTest.txt line no 13594';
ok Uni.new(0xF901).Str.NFC.list ~~ (0x66F4,), '0xF901 -> Str -> 0x66F4 NormalizationTest.txt line no 13595';
ok Uni.new(0xF902).Str.NFC.list ~~ (0x8ECA,), '0xF902 -> Str -> 0x8ECA NormalizationTest.txt line no 13596';
ok Uni.new(0xF903).Str.NFC.list ~~ (0x8CC8,), '0xF903 -> Str -> 0x8CC8 NormalizationTest.txt line no 13597';
ok Uni.new(0xF904).Str.NFC.list ~~ (0x6ED1,), '0xF904 -> Str -> 0x6ED1 NormalizationTest.txt line no 13598';
ok Uni.new(0xF905).Str.NFC.list ~~ (0x4E32,), '0xF905 -> Str -> 0x4E32 NormalizationTest.txt line no 13599';
ok Uni.new(0xF906).Str.NFC.list ~~ (0x53E5,), '0xF906 -> Str -> 0x53E5 NormalizationTest.txt line no 13600';
ok Uni.new(0xF907).Str.NFC.list ~~ (0x9F9C,), '0xF907 -> Str -> 0x9F9C NormalizationTest.txt line no 13601';
ok Uni.new(0xF908).Str.NFC.list ~~ (0x9F9C,), '0xF908 -> Str -> 0x9F9C NormalizationTest.txt line no 13602';
ok Uni.new(0xF909).Str.NFC.list ~~ (0x5951,), '0xF909 -> Str -> 0x5951 NormalizationTest.txt line no 13603';
ok Uni.new(0xF90A).Str.NFC.list ~~ (0x91D1,), '0xF90A -> Str -> 0x91D1 NormalizationTest.txt line no 13604';
ok Uni.new(0xF90B).Str.NFC.list ~~ (0x5587,), '0xF90B -> Str -> 0x5587 NormalizationTest.txt line no 13605';
ok Uni.new(0xF90C).Str.NFC.list ~~ (0x5948,), '0xF90C -> Str -> 0x5948 NormalizationTest.txt line no 13606';
ok Uni.new(0xF90D).Str.NFC.list ~~ (0x61F6,), '0xF90D -> Str -> 0x61F6 NormalizationTest.txt line no 13607';
ok Uni.new(0xF90E).Str.NFC.list ~~ (0x7669,), '0xF90E -> Str -> 0x7669 NormalizationTest.txt line no 13608';
ok Uni.new(0xF90F).Str.NFC.list ~~ (0x7F85,), '0xF90F -> Str -> 0x7F85 NormalizationTest.txt line no 13609';
ok Uni.new(0xF910).Str.NFC.list ~~ (0x863F,), '0xF910 -> Str -> 0x863F NormalizationTest.txt line no 13610';
ok Uni.new(0xF911).Str.NFC.list ~~ (0x87BA,), '0xF911 -> Str -> 0x87BA NormalizationTest.txt line no 13611';
ok Uni.new(0xF912).Str.NFC.list ~~ (0x88F8,), '0xF912 -> Str -> 0x88F8 NormalizationTest.txt line no 13612';
ok Uni.new(0xF913).Str.NFC.list ~~ (0x908F,), '0xF913 -> Str -> 0x908F NormalizationTest.txt line no 13613';
ok Uni.new(0xF914).Str.NFC.list ~~ (0x6A02,), '0xF914 -> Str -> 0x6A02 NormalizationTest.txt line no 13614';
ok Uni.new(0xF915).Str.NFC.list ~~ (0x6D1B,), '0xF915 -> Str -> 0x6D1B NormalizationTest.txt line no 13615';
ok Uni.new(0xF916).Str.NFC.list ~~ (0x70D9,), '0xF916 -> Str -> 0x70D9 NormalizationTest.txt line no 13616';
ok Uni.new(0xF917).Str.NFC.list ~~ (0x73DE,), '0xF917 -> Str -> 0x73DE NormalizationTest.txt line no 13617';
ok Uni.new(0xF918).Str.NFC.list ~~ (0x843D,), '0xF918 -> Str -> 0x843D NormalizationTest.txt line no 13618';
ok Uni.new(0xF919).Str.NFC.list ~~ (0x916A,), '0xF919 -> Str -> 0x916A NormalizationTest.txt line no 13619';
ok Uni.new(0xF91A).Str.NFC.list ~~ (0x99F1,), '0xF91A -> Str -> 0x99F1 NormalizationTest.txt line no 13620';
ok Uni.new(0xF91B).Str.NFC.list ~~ (0x4E82,), '0xF91B -> Str -> 0x4E82 NormalizationTest.txt line no 13621';
ok Uni.new(0xF91C).Str.NFC.list ~~ (0x5375,), '0xF91C -> Str -> 0x5375 NormalizationTest.txt line no 13622';
ok Uni.new(0xF91D).Str.NFC.list ~~ (0x6B04,), '0xF91D -> Str -> 0x6B04 NormalizationTest.txt line no 13623';
ok Uni.new(0xF91E).Str.NFC.list ~~ (0x721B,), '0xF91E -> Str -> 0x721B NormalizationTest.txt line no 13624';
ok Uni.new(0xF91F).Str.NFC.list ~~ (0x862D,), '0xF91F -> Str -> 0x862D NormalizationTest.txt line no 13625';
ok Uni.new(0xF920).Str.NFC.list ~~ (0x9E1E,), '0xF920 -> Str -> 0x9E1E NormalizationTest.txt line no 13626';
ok Uni.new(0xF921).Str.NFC.list ~~ (0x5D50,), '0xF921 -> Str -> 0x5D50 NormalizationTest.txt line no 13627';
ok Uni.new(0xF922).Str.NFC.list ~~ (0x6FEB,), '0xF922 -> Str -> 0x6FEB NormalizationTest.txt line no 13628';
ok Uni.new(0xF923).Str.NFC.list ~~ (0x85CD,), '0xF923 -> Str -> 0x85CD NormalizationTest.txt line no 13629';
ok Uni.new(0xF924).Str.NFC.list ~~ (0x8964,), '0xF924 -> Str -> 0x8964 NormalizationTest.txt line no 13630';
ok Uni.new(0xF925).Str.NFC.list ~~ (0x62C9,), '0xF925 -> Str -> 0x62C9 NormalizationTest.txt line no 13631';
ok Uni.new(0xF926).Str.NFC.list ~~ (0x81D8,), '0xF926 -> Str -> 0x81D8 NormalizationTest.txt line no 13632';
ok Uni.new(0xF927).Str.NFC.list ~~ (0x881F,), '0xF927 -> Str -> 0x881F NormalizationTest.txt line no 13633';
ok Uni.new(0xF928).Str.NFC.list ~~ (0x5ECA,), '0xF928 -> Str -> 0x5ECA NormalizationTest.txt line no 13634';
ok Uni.new(0xF929).Str.NFC.list ~~ (0x6717,), '0xF929 -> Str -> 0x6717 NormalizationTest.txt line no 13635';
ok Uni.new(0xF92A).Str.NFC.list ~~ (0x6D6A,), '0xF92A -> Str -> 0x6D6A NormalizationTest.txt line no 13636';
ok Uni.new(0xF92B).Str.NFC.list ~~ (0x72FC,), '0xF92B -> Str -> 0x72FC NormalizationTest.txt line no 13637';
ok Uni.new(0xF92C).Str.NFC.list ~~ (0x90CE,), '0xF92C -> Str -> 0x90CE NormalizationTest.txt line no 13638';
ok Uni.new(0xF92D).Str.NFC.list ~~ (0x4F86,), '0xF92D -> Str -> 0x4F86 NormalizationTest.txt line no 13639';
ok Uni.new(0xF92E).Str.NFC.list ~~ (0x51B7,), '0xF92E -> Str -> 0x51B7 NormalizationTest.txt line no 13640';
ok Uni.new(0xF92F).Str.NFC.list ~~ (0x52DE,), '0xF92F -> Str -> 0x52DE NormalizationTest.txt line no 13641';
ok Uni.new(0xF930).Str.NFC.list ~~ (0x64C4,), '0xF930 -> Str -> 0x64C4 NormalizationTest.txt line no 13642';
ok Uni.new(0xF931).Str.NFC.list ~~ (0x6AD3,), '0xF931 -> Str -> 0x6AD3 NormalizationTest.txt line no 13643';
ok Uni.new(0xF932).Str.NFC.list ~~ (0x7210,), '0xF932 -> Str -> 0x7210 NormalizationTest.txt line no 13644';
ok Uni.new(0xF933).Str.NFC.list ~~ (0x76E7,), '0xF933 -> Str -> 0x76E7 NormalizationTest.txt line no 13645';
ok Uni.new(0xF934).Str.NFC.list ~~ (0x8001,), '0xF934 -> Str -> 0x8001 NormalizationTest.txt line no 13646';
ok Uni.new(0xF935).Str.NFC.list ~~ (0x8606,), '0xF935 -> Str -> 0x8606 NormalizationTest.txt line no 13647';
ok Uni.new(0xF936).Str.NFC.list ~~ (0x865C,), '0xF936 -> Str -> 0x865C NormalizationTest.txt line no 13648';
ok Uni.new(0xF937).Str.NFC.list ~~ (0x8DEF,), '0xF937 -> Str -> 0x8DEF NormalizationTest.txt line no 13649';
ok Uni.new(0xF938).Str.NFC.list ~~ (0x9732,), '0xF938 -> Str -> 0x9732 NormalizationTest.txt line no 13650';
ok Uni.new(0xF939).Str.NFC.list ~~ (0x9B6F,), '0xF939 -> Str -> 0x9B6F NormalizationTest.txt line no 13651';
ok Uni.new(0xF93A).Str.NFC.list ~~ (0x9DFA,), '0xF93A -> Str -> 0x9DFA NormalizationTest.txt line no 13652';
ok Uni.new(0xF93B).Str.NFC.list ~~ (0x788C,), '0xF93B -> Str -> 0x788C NormalizationTest.txt line no 13653';
ok Uni.new(0xF93C).Str.NFC.list ~~ (0x797F,), '0xF93C -> Str -> 0x797F NormalizationTest.txt line no 13654';
ok Uni.new(0xF93D).Str.NFC.list ~~ (0x7DA0,), '0xF93D -> Str -> 0x7DA0 NormalizationTest.txt line no 13655';
ok Uni.new(0xF93E).Str.NFC.list ~~ (0x83C9,), '0xF93E -> Str -> 0x83C9 NormalizationTest.txt line no 13656';
ok Uni.new(0xF93F).Str.NFC.list ~~ (0x9304,), '0xF93F -> Str -> 0x9304 NormalizationTest.txt line no 13657';
ok Uni.new(0xF940).Str.NFC.list ~~ (0x9E7F,), '0xF940 -> Str -> 0x9E7F NormalizationTest.txt line no 13658';
ok Uni.new(0xF941).Str.NFC.list ~~ (0x8AD6,), '0xF941 -> Str -> 0x8AD6 NormalizationTest.txt line no 13659';
ok Uni.new(0xF942).Str.NFC.list ~~ (0x58DF,), '0xF942 -> Str -> 0x58DF NormalizationTest.txt line no 13660';
ok Uni.new(0xF943).Str.NFC.list ~~ (0x5F04,), '0xF943 -> Str -> 0x5F04 NormalizationTest.txt line no 13661';
ok Uni.new(0xF944).Str.NFC.list ~~ (0x7C60,), '0xF944 -> Str -> 0x7C60 NormalizationTest.txt line no 13662';
ok Uni.new(0xF945).Str.NFC.list ~~ (0x807E,), '0xF945 -> Str -> 0x807E NormalizationTest.txt line no 13663';
ok Uni.new(0xF946).Str.NFC.list ~~ (0x7262,), '0xF946 -> Str -> 0x7262 NormalizationTest.txt line no 13664';
ok Uni.new(0xF947).Str.NFC.list ~~ (0x78CA,), '0xF947 -> Str -> 0x78CA NormalizationTest.txt line no 13665';
ok Uni.new(0xF948).Str.NFC.list ~~ (0x8CC2,), '0xF948 -> Str -> 0x8CC2 NormalizationTest.txt line no 13666';
ok Uni.new(0xF949).Str.NFC.list ~~ (0x96F7,), '0xF949 -> Str -> 0x96F7 NormalizationTest.txt line no 13667';
ok Uni.new(0xF94A).Str.NFC.list ~~ (0x58D8,), '0xF94A -> Str -> 0x58D8 NormalizationTest.txt line no 13668';
ok Uni.new(0xF94B).Str.NFC.list ~~ (0x5C62,), '0xF94B -> Str -> 0x5C62 NormalizationTest.txt line no 13669';
ok Uni.new(0xF94C).Str.NFC.list ~~ (0x6A13,), '0xF94C -> Str -> 0x6A13 NormalizationTest.txt line no 13670';
ok Uni.new(0xF94D).Str.NFC.list ~~ (0x6DDA,), '0xF94D -> Str -> 0x6DDA NormalizationTest.txt line no 13671';
ok Uni.new(0xF94E).Str.NFC.list ~~ (0x6F0F,), '0xF94E -> Str -> 0x6F0F NormalizationTest.txt line no 13672';
ok Uni.new(0xF94F).Str.NFC.list ~~ (0x7D2F,), '0xF94F -> Str -> 0x7D2F NormalizationTest.txt line no 13673';
ok Uni.new(0xF950).Str.NFC.list ~~ (0x7E37,), '0xF950 -> Str -> 0x7E37 NormalizationTest.txt line no 13674';
ok Uni.new(0xF951).Str.NFC.list ~~ (0x964B,), '0xF951 -> Str -> 0x964B NormalizationTest.txt line no 13675';
ok Uni.new(0xF952).Str.NFC.list ~~ (0x52D2,), '0xF952 -> Str -> 0x52D2 NormalizationTest.txt line no 13676';
ok Uni.new(0xF953).Str.NFC.list ~~ (0x808B,), '0xF953 -> Str -> 0x808B NormalizationTest.txt line no 13677';
ok Uni.new(0xF954).Str.NFC.list ~~ (0x51DC,), '0xF954 -> Str -> 0x51DC NormalizationTest.txt line no 13678';
ok Uni.new(0xF955).Str.NFC.list ~~ (0x51CC,), '0xF955 -> Str -> 0x51CC NormalizationTest.txt line no 13679';
ok Uni.new(0xF956).Str.NFC.list ~~ (0x7A1C,), '0xF956 -> Str -> 0x7A1C NormalizationTest.txt line no 13680';
ok Uni.new(0xF957).Str.NFC.list ~~ (0x7DBE,), '0xF957 -> Str -> 0x7DBE NormalizationTest.txt line no 13681';
ok Uni.new(0xF958).Str.NFC.list ~~ (0x83F1,), '0xF958 -> Str -> 0x83F1 NormalizationTest.txt line no 13682';
ok Uni.new(0xF959).Str.NFC.list ~~ (0x9675,), '0xF959 -> Str -> 0x9675 NormalizationTest.txt line no 13683';
ok Uni.new(0xF95A).Str.NFC.list ~~ (0x8B80,), '0xF95A -> Str -> 0x8B80 NormalizationTest.txt line no 13684';
ok Uni.new(0xF95B).Str.NFC.list ~~ (0x62CF,), '0xF95B -> Str -> 0x62CF NormalizationTest.txt line no 13685';
ok Uni.new(0xF95C).Str.NFC.list ~~ (0x6A02,), '0xF95C -> Str -> 0x6A02 NormalizationTest.txt line no 13686';
ok Uni.new(0xF95D).Str.NFC.list ~~ (0x8AFE,), '0xF95D -> Str -> 0x8AFE NormalizationTest.txt line no 13687';
ok Uni.new(0xF95E).Str.NFC.list ~~ (0x4E39,), '0xF95E -> Str -> 0x4E39 NormalizationTest.txt line no 13688';
ok Uni.new(0xF95F).Str.NFC.list ~~ (0x5BE7,), '0xF95F -> Str -> 0x5BE7 NormalizationTest.txt line no 13689';
ok Uni.new(0xF960).Str.NFC.list ~~ (0x6012,), '0xF960 -> Str -> 0x6012 NormalizationTest.txt line no 13690';
ok Uni.new(0xF961).Str.NFC.list ~~ (0x7387,), '0xF961 -> Str -> 0x7387 NormalizationTest.txt line no 13691';
ok Uni.new(0xF962).Str.NFC.list ~~ (0x7570,), '0xF962 -> Str -> 0x7570 NormalizationTest.txt line no 13692';
ok Uni.new(0xF963).Str.NFC.list ~~ (0x5317,), '0xF963 -> Str -> 0x5317 NormalizationTest.txt line no 13693';
ok Uni.new(0xF964).Str.NFC.list ~~ (0x78FB,), '0xF964 -> Str -> 0x78FB NormalizationTest.txt line no 13694';
ok Uni.new(0xF965).Str.NFC.list ~~ (0x4FBF,), '0xF965 -> Str -> 0x4FBF NormalizationTest.txt line no 13695';
ok Uni.new(0xF966).Str.NFC.list ~~ (0x5FA9,), '0xF966 -> Str -> 0x5FA9 NormalizationTest.txt line no 13696';
ok Uni.new(0xF967).Str.NFC.list ~~ (0x4E0D,), '0xF967 -> Str -> 0x4E0D NormalizationTest.txt line no 13697';
ok Uni.new(0xF968).Str.NFC.list ~~ (0x6CCC,), '0xF968 -> Str -> 0x6CCC NormalizationTest.txt line no 13698';
ok Uni.new(0xF969).Str.NFC.list ~~ (0x6578,), '0xF969 -> Str -> 0x6578 NormalizationTest.txt line no 13699';
ok Uni.new(0xF96A).Str.NFC.list ~~ (0x7D22,), '0xF96A -> Str -> 0x7D22 NormalizationTest.txt line no 13700';
ok Uni.new(0xF96B).Str.NFC.list ~~ (0x53C3,), '0xF96B -> Str -> 0x53C3 NormalizationTest.txt line no 13701';
ok Uni.new(0xF96C).Str.NFC.list ~~ (0x585E,), '0xF96C -> Str -> 0x585E NormalizationTest.txt line no 13702';
ok Uni.new(0xF96D).Str.NFC.list ~~ (0x7701,), '0xF96D -> Str -> 0x7701 NormalizationTest.txt line no 13703';
ok Uni.new(0xF96E).Str.NFC.list ~~ (0x8449,), '0xF96E -> Str -> 0x8449 NormalizationTest.txt line no 13704';
ok Uni.new(0xF96F).Str.NFC.list ~~ (0x8AAA,), '0xF96F -> Str -> 0x8AAA NormalizationTest.txt line no 13705';
ok Uni.new(0xF970).Str.NFC.list ~~ (0x6BBA,), '0xF970 -> Str -> 0x6BBA NormalizationTest.txt line no 13706';
ok Uni.new(0xF971).Str.NFC.list ~~ (0x8FB0,), '0xF971 -> Str -> 0x8FB0 NormalizationTest.txt line no 13707';
ok Uni.new(0xF972).Str.NFC.list ~~ (0x6C88,), '0xF972 -> Str -> 0x6C88 NormalizationTest.txt line no 13708';
ok Uni.new(0xF973).Str.NFC.list ~~ (0x62FE,), '0xF973 -> Str -> 0x62FE NormalizationTest.txt line no 13709';
ok Uni.new(0xF974).Str.NFC.list ~~ (0x82E5,), '0xF974 -> Str -> 0x82E5 NormalizationTest.txt line no 13710';
ok Uni.new(0xF975).Str.NFC.list ~~ (0x63A0,), '0xF975 -> Str -> 0x63A0 NormalizationTest.txt line no 13711';
ok Uni.new(0xF976).Str.NFC.list ~~ (0x7565,), '0xF976 -> Str -> 0x7565 NormalizationTest.txt line no 13712';
ok Uni.new(0xF977).Str.NFC.list ~~ (0x4EAE,), '0xF977 -> Str -> 0x4EAE NormalizationTest.txt line no 13713';
ok Uni.new(0xF978).Str.NFC.list ~~ (0x5169,), '0xF978 -> Str -> 0x5169 NormalizationTest.txt line no 13714';
ok Uni.new(0xF979).Str.NFC.list ~~ (0x51C9,), '0xF979 -> Str -> 0x51C9 NormalizationTest.txt line no 13715';
ok Uni.new(0xF97A).Str.NFC.list ~~ (0x6881,), '0xF97A -> Str -> 0x6881 NormalizationTest.txt line no 13716';
ok Uni.new(0xF97B).Str.NFC.list ~~ (0x7CE7,), '0xF97B -> Str -> 0x7CE7 NormalizationTest.txt line no 13717';
ok Uni.new(0xF97C).Str.NFC.list ~~ (0x826F,), '0xF97C -> Str -> 0x826F NormalizationTest.txt line no 13718';
ok Uni.new(0xF97D).Str.NFC.list ~~ (0x8AD2,), '0xF97D -> Str -> 0x8AD2 NormalizationTest.txt line no 13719';
ok Uni.new(0xF97E).Str.NFC.list ~~ (0x91CF,), '0xF97E -> Str -> 0x91CF NormalizationTest.txt line no 13720';
ok Uni.new(0xF97F).Str.NFC.list ~~ (0x52F5,), '0xF97F -> Str -> 0x52F5 NormalizationTest.txt line no 13721';
ok Uni.new(0xF980).Str.NFC.list ~~ (0x5442,), '0xF980 -> Str -> 0x5442 NormalizationTest.txt line no 13722';
ok Uni.new(0xF981).Str.NFC.list ~~ (0x5973,), '0xF981 -> Str -> 0x5973 NormalizationTest.txt line no 13723';
ok Uni.new(0xF982).Str.NFC.list ~~ (0x5EEC,), '0xF982 -> Str -> 0x5EEC NormalizationTest.txt line no 13724';
ok Uni.new(0xF983).Str.NFC.list ~~ (0x65C5,), '0xF983 -> Str -> 0x65C5 NormalizationTest.txt line no 13725';
ok Uni.new(0xF984).Str.NFC.list ~~ (0x6FFE,), '0xF984 -> Str -> 0x6FFE NormalizationTest.txt line no 13726';
ok Uni.new(0xF985).Str.NFC.list ~~ (0x792A,), '0xF985 -> Str -> 0x792A NormalizationTest.txt line no 13727';
ok Uni.new(0xF986).Str.NFC.list ~~ (0x95AD,), '0xF986 -> Str -> 0x95AD NormalizationTest.txt line no 13728';
ok Uni.new(0xF987).Str.NFC.list ~~ (0x9A6A,), '0xF987 -> Str -> 0x9A6A NormalizationTest.txt line no 13729';
ok Uni.new(0xF988).Str.NFC.list ~~ (0x9E97,), '0xF988 -> Str -> 0x9E97 NormalizationTest.txt line no 13730';
ok Uni.new(0xF989).Str.NFC.list ~~ (0x9ECE,), '0xF989 -> Str -> 0x9ECE NormalizationTest.txt line no 13731';
ok Uni.new(0xF98A).Str.NFC.list ~~ (0x529B,), '0xF98A -> Str -> 0x529B NormalizationTest.txt line no 13732';
ok Uni.new(0xF98B).Str.NFC.list ~~ (0x66C6,), '0xF98B -> Str -> 0x66C6 NormalizationTest.txt line no 13733';
ok Uni.new(0xF98C).Str.NFC.list ~~ (0x6B77,), '0xF98C -> Str -> 0x6B77 NormalizationTest.txt line no 13734';
ok Uni.new(0xF98D).Str.NFC.list ~~ (0x8F62,), '0xF98D -> Str -> 0x8F62 NormalizationTest.txt line no 13735';
ok Uni.new(0xF98E).Str.NFC.list ~~ (0x5E74,), '0xF98E -> Str -> 0x5E74 NormalizationTest.txt line no 13736';
ok Uni.new(0xF98F).Str.NFC.list ~~ (0x6190,), '0xF98F -> Str -> 0x6190 NormalizationTest.txt line no 13737';
ok Uni.new(0xF990).Str.NFC.list ~~ (0x6200,), '0xF990 -> Str -> 0x6200 NormalizationTest.txt line no 13738';
ok Uni.new(0xF991).Str.NFC.list ~~ (0x649A,), '0xF991 -> Str -> 0x649A NormalizationTest.txt line no 13739';
ok Uni.new(0xF992).Str.NFC.list ~~ (0x6F23,), '0xF992 -> Str -> 0x6F23 NormalizationTest.txt line no 13740';
ok Uni.new(0xF993).Str.NFC.list ~~ (0x7149,), '0xF993 -> Str -> 0x7149 NormalizationTest.txt line no 13741';
ok Uni.new(0xF994).Str.NFC.list ~~ (0x7489,), '0xF994 -> Str -> 0x7489 NormalizationTest.txt line no 13742';
ok Uni.new(0xF995).Str.NFC.list ~~ (0x79CA,), '0xF995 -> Str -> 0x79CA NormalizationTest.txt line no 13743';
ok Uni.new(0xF996).Str.NFC.list ~~ (0x7DF4,), '0xF996 -> Str -> 0x7DF4 NormalizationTest.txt line no 13744';
ok Uni.new(0xF997).Str.NFC.list ~~ (0x806F,), '0xF997 -> Str -> 0x806F NormalizationTest.txt line no 13745';
ok Uni.new(0xF998).Str.NFC.list ~~ (0x8F26,), '0xF998 -> Str -> 0x8F26 NormalizationTest.txt line no 13746';
ok Uni.new(0xF999).Str.NFC.list ~~ (0x84EE,), '0xF999 -> Str -> 0x84EE NormalizationTest.txt line no 13747';
ok Uni.new(0xF99A).Str.NFC.list ~~ (0x9023,), '0xF99A -> Str -> 0x9023 NormalizationTest.txt line no 13748';
ok Uni.new(0xF99B).Str.NFC.list ~~ (0x934A,), '0xF99B -> Str -> 0x934A NormalizationTest.txt line no 13749';
ok Uni.new(0xF99C).Str.NFC.list ~~ (0x5217,), '0xF99C -> Str -> 0x5217 NormalizationTest.txt line no 13750';
ok Uni.new(0xF99D).Str.NFC.list ~~ (0x52A3,), '0xF99D -> Str -> 0x52A3 NormalizationTest.txt line no 13751';
ok Uni.new(0xF99E).Str.NFC.list ~~ (0x54BD,), '0xF99E -> Str -> 0x54BD NormalizationTest.txt line no 13752';
ok Uni.new(0xF99F).Str.NFC.list ~~ (0x70C8,), '0xF99F -> Str -> 0x70C8 NormalizationTest.txt line no 13753';
ok Uni.new(0xF9A0).Str.NFC.list ~~ (0x88C2,), '0xF9A0 -> Str -> 0x88C2 NormalizationTest.txt line no 13754';
ok Uni.new(0xF9A1).Str.NFC.list ~~ (0x8AAA,), '0xF9A1 -> Str -> 0x8AAA NormalizationTest.txt line no 13755';
ok Uni.new(0xF9A2).Str.NFC.list ~~ (0x5EC9,), '0xF9A2 -> Str -> 0x5EC9 NormalizationTest.txt line no 13756';
ok Uni.new(0xF9A3).Str.NFC.list ~~ (0x5FF5,), '0xF9A3 -> Str -> 0x5FF5 NormalizationTest.txt line no 13757';
ok Uni.new(0xF9A4).Str.NFC.list ~~ (0x637B,), '0xF9A4 -> Str -> 0x637B NormalizationTest.txt line no 13758';
ok Uni.new(0xF9A5).Str.NFC.list ~~ (0x6BAE,), '0xF9A5 -> Str -> 0x6BAE NormalizationTest.txt line no 13759';
ok Uni.new(0xF9A6).Str.NFC.list ~~ (0x7C3E,), '0xF9A6 -> Str -> 0x7C3E NormalizationTest.txt line no 13760';
ok Uni.new(0xF9A7).Str.NFC.list ~~ (0x7375,), '0xF9A7 -> Str -> 0x7375 NormalizationTest.txt line no 13761';
ok Uni.new(0xF9A8).Str.NFC.list ~~ (0x4EE4,), '0xF9A8 -> Str -> 0x4EE4 NormalizationTest.txt line no 13762';
ok Uni.new(0xF9A9).Str.NFC.list ~~ (0x56F9,), '0xF9A9 -> Str -> 0x56F9 NormalizationTest.txt line no 13763';
ok Uni.new(0xF9AA).Str.NFC.list ~~ (0x5BE7,), '0xF9AA -> Str -> 0x5BE7 NormalizationTest.txt line no 13764';
ok Uni.new(0xF9AB).Str.NFC.list ~~ (0x5DBA,), '0xF9AB -> Str -> 0x5DBA NormalizationTest.txt line no 13765';
ok Uni.new(0xF9AC).Str.NFC.list ~~ (0x601C,), '0xF9AC -> Str -> 0x601C NormalizationTest.txt line no 13766';
ok Uni.new(0xF9AD).Str.NFC.list ~~ (0x73B2,), '0xF9AD -> Str -> 0x73B2 NormalizationTest.txt line no 13767';
ok Uni.new(0xF9AE).Str.NFC.list ~~ (0x7469,), '0xF9AE -> Str -> 0x7469 NormalizationTest.txt line no 13768';
ok Uni.new(0xF9AF).Str.NFC.list ~~ (0x7F9A,), '0xF9AF -> Str -> 0x7F9A NormalizationTest.txt line no 13769';
ok Uni.new(0xF9B0).Str.NFC.list ~~ (0x8046,), '0xF9B0 -> Str -> 0x8046 NormalizationTest.txt line no 13770';
ok Uni.new(0xF9B1).Str.NFC.list ~~ (0x9234,), '0xF9B1 -> Str -> 0x9234 NormalizationTest.txt line no 13771';
ok Uni.new(0xF9B2).Str.NFC.list ~~ (0x96F6,), '0xF9B2 -> Str -> 0x96F6 NormalizationTest.txt line no 13772';
ok Uni.new(0xF9B3).Str.NFC.list ~~ (0x9748,), '0xF9B3 -> Str -> 0x9748 NormalizationTest.txt line no 13773';
ok Uni.new(0xF9B4).Str.NFC.list ~~ (0x9818,), '0xF9B4 -> Str -> 0x9818 NormalizationTest.txt line no 13774';
ok Uni.new(0xF9B5).Str.NFC.list ~~ (0x4F8B,), '0xF9B5 -> Str -> 0x4F8B NormalizationTest.txt line no 13775';
ok Uni.new(0xF9B6).Str.NFC.list ~~ (0x79AE,), '0xF9B6 -> Str -> 0x79AE NormalizationTest.txt line no 13776';
ok Uni.new(0xF9B7).Str.NFC.list ~~ (0x91B4,), '0xF9B7 -> Str -> 0x91B4 NormalizationTest.txt line no 13777';
ok Uni.new(0xF9B8).Str.NFC.list ~~ (0x96B8,), '0xF9B8 -> Str -> 0x96B8 NormalizationTest.txt line no 13778';
ok Uni.new(0xF9B9).Str.NFC.list ~~ (0x60E1,), '0xF9B9 -> Str -> 0x60E1 NormalizationTest.txt line no 13779';
ok Uni.new(0xF9BA).Str.NFC.list ~~ (0x4E86,), '0xF9BA -> Str -> 0x4E86 NormalizationTest.txt line no 13780';
ok Uni.new(0xF9BB).Str.NFC.list ~~ (0x50DA,), '0xF9BB -> Str -> 0x50DA NormalizationTest.txt line no 13781';
ok Uni.new(0xF9BC).Str.NFC.list ~~ (0x5BEE,), '0xF9BC -> Str -> 0x5BEE NormalizationTest.txt line no 13782';
ok Uni.new(0xF9BD).Str.NFC.list ~~ (0x5C3F,), '0xF9BD -> Str -> 0x5C3F NormalizationTest.txt line no 13783';
ok Uni.new(0xF9BE).Str.NFC.list ~~ (0x6599,), '0xF9BE -> Str -> 0x6599 NormalizationTest.txt line no 13784';
ok Uni.new(0xF9BF).Str.NFC.list ~~ (0x6A02,), '0xF9BF -> Str -> 0x6A02 NormalizationTest.txt line no 13785';
ok Uni.new(0xF9C0).Str.NFC.list ~~ (0x71CE,), '0xF9C0 -> Str -> 0x71CE NormalizationTest.txt line no 13786';
ok Uni.new(0xF9C1).Str.NFC.list ~~ (0x7642,), '0xF9C1 -> Str -> 0x7642 NormalizationTest.txt line no 13787';
ok Uni.new(0xF9C2).Str.NFC.list ~~ (0x84FC,), '0xF9C2 -> Str -> 0x84FC NormalizationTest.txt line no 13788';
ok Uni.new(0xF9C3).Str.NFC.list ~~ (0x907C,), '0xF9C3 -> Str -> 0x907C NormalizationTest.txt line no 13789';
ok Uni.new(0xF9C4).Str.NFC.list ~~ (0x9F8D,), '0xF9C4 -> Str -> 0x9F8D NormalizationTest.txt line no 13790';
ok Uni.new(0xF9C5).Str.NFC.list ~~ (0x6688,), '0xF9C5 -> Str -> 0x6688 NormalizationTest.txt line no 13791';
ok Uni.new(0xF9C6).Str.NFC.list ~~ (0x962E,), '0xF9C6 -> Str -> 0x962E NormalizationTest.txt line no 13792';
ok Uni.new(0xF9C7).Str.NFC.list ~~ (0x5289,), '0xF9C7 -> Str -> 0x5289 NormalizationTest.txt line no 13793';
ok Uni.new(0xF9C8).Str.NFC.list ~~ (0x677B,), '0xF9C8 -> Str -> 0x677B NormalizationTest.txt line no 13794';
ok Uni.new(0xF9C9).Str.NFC.list ~~ (0x67F3,), '0xF9C9 -> Str -> 0x67F3 NormalizationTest.txt line no 13795';
ok Uni.new(0xF9CA).Str.NFC.list ~~ (0x6D41,), '0xF9CA -> Str -> 0x6D41 NormalizationTest.txt line no 13796';
ok Uni.new(0xF9CB).Str.NFC.list ~~ (0x6E9C,), '0xF9CB -> Str -> 0x6E9C NormalizationTest.txt line no 13797';
ok Uni.new(0xF9CC).Str.NFC.list ~~ (0x7409,), '0xF9CC -> Str -> 0x7409 NormalizationTest.txt line no 13798';
ok Uni.new(0xF9CD).Str.NFC.list ~~ (0x7559,), '0xF9CD -> Str -> 0x7559 NormalizationTest.txt line no 13799';
ok Uni.new(0xF9CE).Str.NFC.list ~~ (0x786B,), '0xF9CE -> Str -> 0x786B NormalizationTest.txt line no 13800';
ok Uni.new(0xF9CF).Str.NFC.list ~~ (0x7D10,), '0xF9CF -> Str -> 0x7D10 NormalizationTest.txt line no 13801';
ok Uni.new(0xF9D0).Str.NFC.list ~~ (0x985E,), '0xF9D0 -> Str -> 0x985E NormalizationTest.txt line no 13802';
ok Uni.new(0xF9D1).Str.NFC.list ~~ (0x516D,), '0xF9D1 -> Str -> 0x516D NormalizationTest.txt line no 13803';
ok Uni.new(0xF9D2).Str.NFC.list ~~ (0x622E,), '0xF9D2 -> Str -> 0x622E NormalizationTest.txt line no 13804';
ok Uni.new(0xF9D3).Str.NFC.list ~~ (0x9678,), '0xF9D3 -> Str -> 0x9678 NormalizationTest.txt line no 13805';
ok Uni.new(0xF9D4).Str.NFC.list ~~ (0x502B,), '0xF9D4 -> Str -> 0x502B NormalizationTest.txt line no 13806';
ok Uni.new(0xF9D5).Str.NFC.list ~~ (0x5D19,), '0xF9D5 -> Str -> 0x5D19 NormalizationTest.txt line no 13807';
ok Uni.new(0xF9D6).Str.NFC.list ~~ (0x6DEA,), '0xF9D6 -> Str -> 0x6DEA NormalizationTest.txt line no 13808';
ok Uni.new(0xF9D7).Str.NFC.list ~~ (0x8F2A,), '0xF9D7 -> Str -> 0x8F2A NormalizationTest.txt line no 13809';
ok Uni.new(0xF9D8).Str.NFC.list ~~ (0x5F8B,), '0xF9D8 -> Str -> 0x5F8B NormalizationTest.txt line no 13810';
ok Uni.new(0xF9D9).Str.NFC.list ~~ (0x6144,), '0xF9D9 -> Str -> 0x6144 NormalizationTest.txt line no 13811';
ok Uni.new(0xF9DA).Str.NFC.list ~~ (0x6817,), '0xF9DA -> Str -> 0x6817 NormalizationTest.txt line no 13812';
ok Uni.new(0xF9DB).Str.NFC.list ~~ (0x7387,), '0xF9DB -> Str -> 0x7387 NormalizationTest.txt line no 13813';
ok Uni.new(0xF9DC).Str.NFC.list ~~ (0x9686,), '0xF9DC -> Str -> 0x9686 NormalizationTest.txt line no 13814';
ok Uni.new(0xF9DD).Str.NFC.list ~~ (0x5229,), '0xF9DD -> Str -> 0x5229 NormalizationTest.txt line no 13815';
ok Uni.new(0xF9DE).Str.NFC.list ~~ (0x540F,), '0xF9DE -> Str -> 0x540F NormalizationTest.txt line no 13816';
ok Uni.new(0xF9DF).Str.NFC.list ~~ (0x5C65,), '0xF9DF -> Str -> 0x5C65 NormalizationTest.txt line no 13817';
ok Uni.new(0xF9E0).Str.NFC.list ~~ (0x6613,), '0xF9E0 -> Str -> 0x6613 NormalizationTest.txt line no 13818';
ok Uni.new(0xF9E1).Str.NFC.list ~~ (0x674E,), '0xF9E1 -> Str -> 0x674E NormalizationTest.txt line no 13819';
ok Uni.new(0xF9E2).Str.NFC.list ~~ (0x68A8,), '0xF9E2 -> Str -> 0x68A8 NormalizationTest.txt line no 13820';
ok Uni.new(0xF9E3).Str.NFC.list ~~ (0x6CE5,), '0xF9E3 -> Str -> 0x6CE5 NormalizationTest.txt line no 13821';
ok Uni.new(0xF9E4).Str.NFC.list ~~ (0x7406,), '0xF9E4 -> Str -> 0x7406 NormalizationTest.txt line no 13822';
ok Uni.new(0xF9E5).Str.NFC.list ~~ (0x75E2,), '0xF9E5 -> Str -> 0x75E2 NormalizationTest.txt line no 13823';
ok Uni.new(0xF9E6).Str.NFC.list ~~ (0x7F79,), '0xF9E6 -> Str -> 0x7F79 NormalizationTest.txt line no 13824';
ok Uni.new(0xF9E7).Str.NFC.list ~~ (0x88CF,), '0xF9E7 -> Str -> 0x88CF NormalizationTest.txt line no 13825';
ok Uni.new(0xF9E8).Str.NFC.list ~~ (0x88E1,), '0xF9E8 -> Str -> 0x88E1 NormalizationTest.txt line no 13826';
ok Uni.new(0xF9E9).Str.NFC.list ~~ (0x91CC,), '0xF9E9 -> Str -> 0x91CC NormalizationTest.txt line no 13827';
ok Uni.new(0xF9EA).Str.NFC.list ~~ (0x96E2,), '0xF9EA -> Str -> 0x96E2 NormalizationTest.txt line no 13828';
ok Uni.new(0xF9EB).Str.NFC.list ~~ (0x533F,), '0xF9EB -> Str -> 0x533F NormalizationTest.txt line no 13829';
ok Uni.new(0xF9EC).Str.NFC.list ~~ (0x6EBA,), '0xF9EC -> Str -> 0x6EBA NormalizationTest.txt line no 13830';
ok Uni.new(0xF9ED).Str.NFC.list ~~ (0x541D,), '0xF9ED -> Str -> 0x541D NormalizationTest.txt line no 13831';
ok Uni.new(0xF9EE).Str.NFC.list ~~ (0x71D0,), '0xF9EE -> Str -> 0x71D0 NormalizationTest.txt line no 13832';
ok Uni.new(0xF9EF).Str.NFC.list ~~ (0x7498,), '0xF9EF -> Str -> 0x7498 NormalizationTest.txt line no 13833';
ok Uni.new(0xF9F0).Str.NFC.list ~~ (0x85FA,), '0xF9F0 -> Str -> 0x85FA NormalizationTest.txt line no 13834';
ok Uni.new(0xF9F1).Str.NFC.list ~~ (0x96A3,), '0xF9F1 -> Str -> 0x96A3 NormalizationTest.txt line no 13835';
ok Uni.new(0xF9F2).Str.NFC.list ~~ (0x9C57,), '0xF9F2 -> Str -> 0x9C57 NormalizationTest.txt line no 13836';
ok Uni.new(0xF9F3).Str.NFC.list ~~ (0x9E9F,), '0xF9F3 -> Str -> 0x9E9F NormalizationTest.txt line no 13837';
ok Uni.new(0xF9F4).Str.NFC.list ~~ (0x6797,), '0xF9F4 -> Str -> 0x6797 NormalizationTest.txt line no 13838';
ok Uni.new(0xF9F5).Str.NFC.list ~~ (0x6DCB,), '0xF9F5 -> Str -> 0x6DCB NormalizationTest.txt line no 13839';
ok Uni.new(0xF9F6).Str.NFC.list ~~ (0x81E8,), '0xF9F6 -> Str -> 0x81E8 NormalizationTest.txt line no 13840';
ok Uni.new(0xF9F7).Str.NFC.list ~~ (0x7ACB,), '0xF9F7 -> Str -> 0x7ACB NormalizationTest.txt line no 13841';
ok Uni.new(0xF9F8).Str.NFC.list ~~ (0x7B20,), '0xF9F8 -> Str -> 0x7B20 NormalizationTest.txt line no 13842';
ok Uni.new(0xF9F9).Str.NFC.list ~~ (0x7C92,), '0xF9F9 -> Str -> 0x7C92 NormalizationTest.txt line no 13843';
ok Uni.new(0xF9FA).Str.NFC.list ~~ (0x72C0,), '0xF9FA -> Str -> 0x72C0 NormalizationTest.txt line no 13844';
ok Uni.new(0xF9FB).Str.NFC.list ~~ (0x7099,), '0xF9FB -> Str -> 0x7099 NormalizationTest.txt line no 13845';
ok Uni.new(0xF9FC).Str.NFC.list ~~ (0x8B58,), '0xF9FC -> Str -> 0x8B58 NormalizationTest.txt line no 13846';
ok Uni.new(0xF9FD).Str.NFC.list ~~ (0x4EC0,), '0xF9FD -> Str -> 0x4EC0 NormalizationTest.txt line no 13847';
ok Uni.new(0xF9FE).Str.NFC.list ~~ (0x8336,), '0xF9FE -> Str -> 0x8336 NormalizationTest.txt line no 13848';
ok Uni.new(0xF9FF).Str.NFC.list ~~ (0x523A,), '0xF9FF -> Str -> 0x523A NormalizationTest.txt line no 13849';
ok Uni.new(0xFA00).Str.NFC.list ~~ (0x5207,), '0xFA00 -> Str -> 0x5207 NormalizationTest.txt line no 13850';
ok Uni.new(0xFA01).Str.NFC.list ~~ (0x5EA6,), '0xFA01 -> Str -> 0x5EA6 NormalizationTest.txt line no 13851';
ok Uni.new(0xFA02).Str.NFC.list ~~ (0x62D3,), '0xFA02 -> Str -> 0x62D3 NormalizationTest.txt line no 13852';
ok Uni.new(0xFA03).Str.NFC.list ~~ (0x7CD6,), '0xFA03 -> Str -> 0x7CD6 NormalizationTest.txt line no 13853';
ok Uni.new(0xFA04).Str.NFC.list ~~ (0x5B85,), '0xFA04 -> Str -> 0x5B85 NormalizationTest.txt line no 13854';
ok Uni.new(0xFA05).Str.NFC.list ~~ (0x6D1E,), '0xFA05 -> Str -> 0x6D1E NormalizationTest.txt line no 13855';
ok Uni.new(0xFA06).Str.NFC.list ~~ (0x66B4,), '0xFA06 -> Str -> 0x66B4 NormalizationTest.txt line no 13856';
ok Uni.new(0xFA07).Str.NFC.list ~~ (0x8F3B,), '0xFA07 -> Str -> 0x8F3B NormalizationTest.txt line no 13857';
ok Uni.new(0xFA08).Str.NFC.list ~~ (0x884C,), '0xFA08 -> Str -> 0x884C NormalizationTest.txt line no 13858';
ok Uni.new(0xFA09).Str.NFC.list ~~ (0x964D,), '0xFA09 -> Str -> 0x964D NormalizationTest.txt line no 13859';
ok Uni.new(0xFA0A).Str.NFC.list ~~ (0x898B,), '0xFA0A -> Str -> 0x898B NormalizationTest.txt line no 13860';
ok Uni.new(0xFA0B).Str.NFC.list ~~ (0x5ED3,), '0xFA0B -> Str -> 0x5ED3 NormalizationTest.txt line no 13861';
ok Uni.new(0xFA0C).Str.NFC.list ~~ (0x5140,), '0xFA0C -> Str -> 0x5140 NormalizationTest.txt line no 13862';
ok Uni.new(0xFA0D).Str.NFC.list ~~ (0x55C0,), '0xFA0D -> Str -> 0x55C0 NormalizationTest.txt line no 13863';
ok Uni.new(0xFA10).Str.NFC.list ~~ (0x585A,), '0xFA10 -> Str -> 0x585A NormalizationTest.txt line no 13864';
ok Uni.new(0xFA12).Str.NFC.list ~~ (0x6674,), '0xFA12 -> Str -> 0x6674 NormalizationTest.txt line no 13865';
ok Uni.new(0xFA15).Str.NFC.list ~~ (0x51DE,), '0xFA15 -> Str -> 0x51DE NormalizationTest.txt line no 13866';
ok Uni.new(0xFA16).Str.NFC.list ~~ (0x732A,), '0xFA16 -> Str -> 0x732A NormalizationTest.txt line no 13867';
ok Uni.new(0xFA17).Str.NFC.list ~~ (0x76CA,), '0xFA17 -> Str -> 0x76CA NormalizationTest.txt line no 13868';
ok Uni.new(0xFA18).Str.NFC.list ~~ (0x793C,), '0xFA18 -> Str -> 0x793C NormalizationTest.txt line no 13869';
ok Uni.new(0xFA19).Str.NFC.list ~~ (0x795E,), '0xFA19 -> Str -> 0x795E NormalizationTest.txt line no 13870';
ok Uni.new(0xFA1A).Str.NFC.list ~~ (0x7965,), '0xFA1A -> Str -> 0x7965 NormalizationTest.txt line no 13871';
ok Uni.new(0xFA1B).Str.NFC.list ~~ (0x798F,), '0xFA1B -> Str -> 0x798F NormalizationTest.txt line no 13872';
ok Uni.new(0xFA1C).Str.NFC.list ~~ (0x9756,), '0xFA1C -> Str -> 0x9756 NormalizationTest.txt line no 13873';
ok Uni.new(0xFA1D).Str.NFC.list ~~ (0x7CBE,), '0xFA1D -> Str -> 0x7CBE NormalizationTest.txt line no 13874';
ok Uni.new(0xFA1E).Str.NFC.list ~~ (0x7FBD,), '0xFA1E -> Str -> 0x7FBD NormalizationTest.txt line no 13875';
ok Uni.new(0xFA20).Str.NFC.list ~~ (0x8612,), '0xFA20 -> Str -> 0x8612 NormalizationTest.txt line no 13876';
ok Uni.new(0xFA22).Str.NFC.list ~~ (0x8AF8,), '0xFA22 -> Str -> 0x8AF8 NormalizationTest.txt line no 13877';
ok Uni.new(0xFA25).Str.NFC.list ~~ (0x9038,), '0xFA25 -> Str -> 0x9038 NormalizationTest.txt line no 13878';
ok Uni.new(0xFA26).Str.NFC.list ~~ (0x90FD,), '0xFA26 -> Str -> 0x90FD NormalizationTest.txt line no 13879';
ok Uni.new(0xFA2A).Str.NFC.list ~~ (0x98EF,), '0xFA2A -> Str -> 0x98EF NormalizationTest.txt line no 13880';
ok Uni.new(0xFA2B).Str.NFC.list ~~ (0x98FC,), '0xFA2B -> Str -> 0x98FC NormalizationTest.txt line no 13881';
ok Uni.new(0xFA2C).Str.NFC.list ~~ (0x9928,), '0xFA2C -> Str -> 0x9928 NormalizationTest.txt line no 13882';
ok Uni.new(0xFA2D).Str.NFC.list ~~ (0x9DB4,), '0xFA2D -> Str -> 0x9DB4 NormalizationTest.txt line no 13883';
ok Uni.new(0xFA2E).Str.NFC.list ~~ (0x90DE,), '0xFA2E -> Str -> 0x90DE NormalizationTest.txt line no 13884';
ok Uni.new(0xFA2F).Str.NFC.list ~~ (0x96B7,), '0xFA2F -> Str -> 0x96B7 NormalizationTest.txt line no 13885';
ok Uni.new(0xFA30).Str.NFC.list ~~ (0x4FAE,), '0xFA30 -> Str -> 0x4FAE NormalizationTest.txt line no 13886';
ok Uni.new(0xFA31).Str.NFC.list ~~ (0x50E7,), '0xFA31 -> Str -> 0x50E7 NormalizationTest.txt line no 13887';
ok Uni.new(0xFA32).Str.NFC.list ~~ (0x514D,), '0xFA32 -> Str -> 0x514D NormalizationTest.txt line no 13888';
ok Uni.new(0xFA33).Str.NFC.list ~~ (0x52C9,), '0xFA33 -> Str -> 0x52C9 NormalizationTest.txt line no 13889';
ok Uni.new(0xFA34).Str.NFC.list ~~ (0x52E4,), '0xFA34 -> Str -> 0x52E4 NormalizationTest.txt line no 13890';
ok Uni.new(0xFA35).Str.NFC.list ~~ (0x5351,), '0xFA35 -> Str -> 0x5351 NormalizationTest.txt line no 13891';
ok Uni.new(0xFA36).Str.NFC.list ~~ (0x559D,), '0xFA36 -> Str -> 0x559D NormalizationTest.txt line no 13892';
ok Uni.new(0xFA37).Str.NFC.list ~~ (0x5606,), '0xFA37 -> Str -> 0x5606 NormalizationTest.txt line no 13893';
ok Uni.new(0xFA38).Str.NFC.list ~~ (0x5668,), '0xFA38 -> Str -> 0x5668 NormalizationTest.txt line no 13894';
ok Uni.new(0xFA39).Str.NFC.list ~~ (0x5840,), '0xFA39 -> Str -> 0x5840 NormalizationTest.txt line no 13895';
ok Uni.new(0xFA3A).Str.NFC.list ~~ (0x58A8,), '0xFA3A -> Str -> 0x58A8 NormalizationTest.txt line no 13896';
ok Uni.new(0xFA3B).Str.NFC.list ~~ (0x5C64,), '0xFA3B -> Str -> 0x5C64 NormalizationTest.txt line no 13897';
ok Uni.new(0xFA3C).Str.NFC.list ~~ (0x5C6E,), '0xFA3C -> Str -> 0x5C6E NormalizationTest.txt line no 13898';
ok Uni.new(0xFA3D).Str.NFC.list ~~ (0x6094,), '0xFA3D -> Str -> 0x6094 NormalizationTest.txt line no 13899';
ok Uni.new(0xFA3E).Str.NFC.list ~~ (0x6168,), '0xFA3E -> Str -> 0x6168 NormalizationTest.txt line no 13900';
ok Uni.new(0xFA3F).Str.NFC.list ~~ (0x618E,), '0xFA3F -> Str -> 0x618E NormalizationTest.txt line no 13901';
ok Uni.new(0xFA40).Str.NFC.list ~~ (0x61F2,), '0xFA40 -> Str -> 0x61F2 NormalizationTest.txt line no 13902';
ok Uni.new(0xFA41).Str.NFC.list ~~ (0x654F,), '0xFA41 -> Str -> 0x654F NormalizationTest.txt line no 13903';
ok Uni.new(0xFA42).Str.NFC.list ~~ (0x65E2,), '0xFA42 -> Str -> 0x65E2 NormalizationTest.txt line no 13904';
ok Uni.new(0xFA43).Str.NFC.list ~~ (0x6691,), '0xFA43 -> Str -> 0x6691 NormalizationTest.txt line no 13905';
ok Uni.new(0xFA44).Str.NFC.list ~~ (0x6885,), '0xFA44 -> Str -> 0x6885 NormalizationTest.txt line no 13906';
ok Uni.new(0xFA45).Str.NFC.list ~~ (0x6D77,), '0xFA45 -> Str -> 0x6D77 NormalizationTest.txt line no 13907';
ok Uni.new(0xFA46).Str.NFC.list ~~ (0x6E1A,), '0xFA46 -> Str -> 0x6E1A NormalizationTest.txt line no 13908';
ok Uni.new(0xFA47).Str.NFC.list ~~ (0x6F22,), '0xFA47 -> Str -> 0x6F22 NormalizationTest.txt line no 13909';
ok Uni.new(0xFA48).Str.NFC.list ~~ (0x716E,), '0xFA48 -> Str -> 0x716E NormalizationTest.txt line no 13910';
ok Uni.new(0xFA49).Str.NFC.list ~~ (0x722B,), '0xFA49 -> Str -> 0x722B NormalizationTest.txt line no 13911';
ok Uni.new(0xFA4A).Str.NFC.list ~~ (0x7422,), '0xFA4A -> Str -> 0x7422 NormalizationTest.txt line no 13912';
ok Uni.new(0xFA4B).Str.NFC.list ~~ (0x7891,), '0xFA4B -> Str -> 0x7891 NormalizationTest.txt line no 13913';
ok Uni.new(0xFA4C).Str.NFC.list ~~ (0x793E,), '0xFA4C -> Str -> 0x793E NormalizationTest.txt line no 13914';
ok Uni.new(0xFA4D).Str.NFC.list ~~ (0x7949,), '0xFA4D -> Str -> 0x7949 NormalizationTest.txt line no 13915';
ok Uni.new(0xFA4E).Str.NFC.list ~~ (0x7948,), '0xFA4E -> Str -> 0x7948 NormalizationTest.txt line no 13916';
ok Uni.new(0xFA4F).Str.NFC.list ~~ (0x7950,), '0xFA4F -> Str -> 0x7950 NormalizationTest.txt line no 13917';
ok Uni.new(0xFA50).Str.NFC.list ~~ (0x7956,), '0xFA50 -> Str -> 0x7956 NormalizationTest.txt line no 13918';
ok Uni.new(0xFA51).Str.NFC.list ~~ (0x795D,), '0xFA51 -> Str -> 0x795D NormalizationTest.txt line no 13919';
ok Uni.new(0xFA52).Str.NFC.list ~~ (0x798D,), '0xFA52 -> Str -> 0x798D NormalizationTest.txt line no 13920';
ok Uni.new(0xFA53).Str.NFC.list ~~ (0x798E,), '0xFA53 -> Str -> 0x798E NormalizationTest.txt line no 13921';
ok Uni.new(0xFA54).Str.NFC.list ~~ (0x7A40,), '0xFA54 -> Str -> 0x7A40 NormalizationTest.txt line no 13922';
ok Uni.new(0xFA55).Str.NFC.list ~~ (0x7A81,), '0xFA55 -> Str -> 0x7A81 NormalizationTest.txt line no 13923';
ok Uni.new(0xFA56).Str.NFC.list ~~ (0x7BC0,), '0xFA56 -> Str -> 0x7BC0 NormalizationTest.txt line no 13924';
ok Uni.new(0xFA57).Str.NFC.list ~~ (0x7DF4,), '0xFA57 -> Str -> 0x7DF4 NormalizationTest.txt line no 13925';
ok Uni.new(0xFA58).Str.NFC.list ~~ (0x7E09,), '0xFA58 -> Str -> 0x7E09 NormalizationTest.txt line no 13926';
ok Uni.new(0xFA59).Str.NFC.list ~~ (0x7E41,), '0xFA59 -> Str -> 0x7E41 NormalizationTest.txt line no 13927';
ok Uni.new(0xFA5A).Str.NFC.list ~~ (0x7F72,), '0xFA5A -> Str -> 0x7F72 NormalizationTest.txt line no 13928';
ok Uni.new(0xFA5B).Str.NFC.list ~~ (0x8005,), '0xFA5B -> Str -> 0x8005 NormalizationTest.txt line no 13929';
ok Uni.new(0xFA5C).Str.NFC.list ~~ (0x81ED,), '0xFA5C -> Str -> 0x81ED NormalizationTest.txt line no 13930';
ok Uni.new(0xFA5D).Str.NFC.list ~~ (0x8279,), '0xFA5D -> Str -> 0x8279 NormalizationTest.txt line no 13931';
ok Uni.new(0xFA5E).Str.NFC.list ~~ (0x8279,), '0xFA5E -> Str -> 0x8279 NormalizationTest.txt line no 13932';
ok Uni.new(0xFA5F).Str.NFC.list ~~ (0x8457,), '0xFA5F -> Str -> 0x8457 NormalizationTest.txt line no 13933';
ok Uni.new(0xFA60).Str.NFC.list ~~ (0x8910,), '0xFA60 -> Str -> 0x8910 NormalizationTest.txt line no 13934';
ok Uni.new(0xFA61).Str.NFC.list ~~ (0x8996,), '0xFA61 -> Str -> 0x8996 NormalizationTest.txt line no 13935';
ok Uni.new(0xFA62).Str.NFC.list ~~ (0x8B01,), '0xFA62 -> Str -> 0x8B01 NormalizationTest.txt line no 13936';
ok Uni.new(0xFA63).Str.NFC.list ~~ (0x8B39,), '0xFA63 -> Str -> 0x8B39 NormalizationTest.txt line no 13937';
ok Uni.new(0xFA64).Str.NFC.list ~~ (0x8CD3,), '0xFA64 -> Str -> 0x8CD3 NormalizationTest.txt line no 13938';
ok Uni.new(0xFA65).Str.NFC.list ~~ (0x8D08,), '0xFA65 -> Str -> 0x8D08 NormalizationTest.txt line no 13939';
ok Uni.new(0xFA66).Str.NFC.list ~~ (0x8FB6,), '0xFA66 -> Str -> 0x8FB6 NormalizationTest.txt line no 13940';
ok Uni.new(0xFA67).Str.NFC.list ~~ (0x9038,), '0xFA67 -> Str -> 0x9038 NormalizationTest.txt line no 13941';
ok Uni.new(0xFA68).Str.NFC.list ~~ (0x96E3,), '0xFA68 -> Str -> 0x96E3 NormalizationTest.txt line no 13942';
ok Uni.new(0xFA69).Str.NFC.list ~~ (0x97FF,), '0xFA69 -> Str -> 0x97FF NormalizationTest.txt line no 13943';
ok Uni.new(0xFA6A).Str.NFC.list ~~ (0x983B,), '0xFA6A -> Str -> 0x983B NormalizationTest.txt line no 13944';
ok Uni.new(0xFA6B).Str.NFC.list ~~ (0x6075,), '0xFA6B -> Str -> 0x6075 NormalizationTest.txt line no 13945';
ok Uni.new(0xFA6C).Str.NFC.list ~~ (0x242EE,), '0xFA6C -> Str -> 0x242EE NormalizationTest.txt line no 13946';
ok Uni.new(0xFA6D).Str.NFC.list ~~ (0x8218,), '0xFA6D -> Str -> 0x8218 NormalizationTest.txt line no 13947';
ok Uni.new(0xFA70).Str.NFC.list ~~ (0x4E26,), '0xFA70 -> Str -> 0x4E26 NormalizationTest.txt line no 13948';
ok Uni.new(0xFA71).Str.NFC.list ~~ (0x51B5,), '0xFA71 -> Str -> 0x51B5 NormalizationTest.txt line no 13949';
ok Uni.new(0xFA72).Str.NFC.list ~~ (0x5168,), '0xFA72 -> Str -> 0x5168 NormalizationTest.txt line no 13950';
ok Uni.new(0xFA73).Str.NFC.list ~~ (0x4F80,), '0xFA73 -> Str -> 0x4F80 NormalizationTest.txt line no 13951';
ok Uni.new(0xFA74).Str.NFC.list ~~ (0x5145,), '0xFA74 -> Str -> 0x5145 NormalizationTest.txt line no 13952';
ok Uni.new(0xFA75).Str.NFC.list ~~ (0x5180,), '0xFA75 -> Str -> 0x5180 NormalizationTest.txt line no 13953';
ok Uni.new(0xFA76).Str.NFC.list ~~ (0x52C7,), '0xFA76 -> Str -> 0x52C7 NormalizationTest.txt line no 13954';
ok Uni.new(0xFA77).Str.NFC.list ~~ (0x52FA,), '0xFA77 -> Str -> 0x52FA NormalizationTest.txt line no 13955';
ok Uni.new(0xFA78).Str.NFC.list ~~ (0x559D,), '0xFA78 -> Str -> 0x559D NormalizationTest.txt line no 13956';
ok Uni.new(0xFA79).Str.NFC.list ~~ (0x5555,), '0xFA79 -> Str -> 0x5555 NormalizationTest.txt line no 13957';
ok Uni.new(0xFA7A).Str.NFC.list ~~ (0x5599,), '0xFA7A -> Str -> 0x5599 NormalizationTest.txt line no 13958';
ok Uni.new(0xFA7B).Str.NFC.list ~~ (0x55E2,), '0xFA7B -> Str -> 0x55E2 NormalizationTest.txt line no 13959';
ok Uni.new(0xFA7C).Str.NFC.list ~~ (0x585A,), '0xFA7C -> Str -> 0x585A NormalizationTest.txt line no 13960';
ok Uni.new(0xFA7D).Str.NFC.list ~~ (0x58B3,), '0xFA7D -> Str -> 0x58B3 NormalizationTest.txt line no 13961';
ok Uni.new(0xFA7E).Str.NFC.list ~~ (0x5944,), '0xFA7E -> Str -> 0x5944 NormalizationTest.txt line no 13962';
ok Uni.new(0xFA7F).Str.NFC.list ~~ (0x5954,), '0xFA7F -> Str -> 0x5954 NormalizationTest.txt line no 13963';
ok Uni.new(0xFA80).Str.NFC.list ~~ (0x5A62,), '0xFA80 -> Str -> 0x5A62 NormalizationTest.txt line no 13964';
ok Uni.new(0xFA81).Str.NFC.list ~~ (0x5B28,), '0xFA81 -> Str -> 0x5B28 NormalizationTest.txt line no 13965';
ok Uni.new(0xFA82).Str.NFC.list ~~ (0x5ED2,), '0xFA82 -> Str -> 0x5ED2 NormalizationTest.txt line no 13966';
ok Uni.new(0xFA83).Str.NFC.list ~~ (0x5ED9,), '0xFA83 -> Str -> 0x5ED9 NormalizationTest.txt line no 13967';
ok Uni.new(0xFA84).Str.NFC.list ~~ (0x5F69,), '0xFA84 -> Str -> 0x5F69 NormalizationTest.txt line no 13968';
ok Uni.new(0xFA85).Str.NFC.list ~~ (0x5FAD,), '0xFA85 -> Str -> 0x5FAD NormalizationTest.txt line no 13969';
ok Uni.new(0xFA86).Str.NFC.list ~~ (0x60D8,), '0xFA86 -> Str -> 0x60D8 NormalizationTest.txt line no 13970';
ok Uni.new(0xFA87).Str.NFC.list ~~ (0x614E,), '0xFA87 -> Str -> 0x614E NormalizationTest.txt line no 13971';
ok Uni.new(0xFA88).Str.NFC.list ~~ (0x6108,), '0xFA88 -> Str -> 0x6108 NormalizationTest.txt line no 13972';
ok Uni.new(0xFA89).Str.NFC.list ~~ (0x618E,), '0xFA89 -> Str -> 0x618E NormalizationTest.txt line no 13973';
ok Uni.new(0xFA8A).Str.NFC.list ~~ (0x6160,), '0xFA8A -> Str -> 0x6160 NormalizationTest.txt line no 13974';
ok Uni.new(0xFA8B).Str.NFC.list ~~ (0x61F2,), '0xFA8B -> Str -> 0x61F2 NormalizationTest.txt line no 13975';
ok Uni.new(0xFA8C).Str.NFC.list ~~ (0x6234,), '0xFA8C -> Str -> 0x6234 NormalizationTest.txt line no 13976';
ok Uni.new(0xFA8D).Str.NFC.list ~~ (0x63C4,), '0xFA8D -> Str -> 0x63C4 NormalizationTest.txt line no 13977';
ok Uni.new(0xFA8E).Str.NFC.list ~~ (0x641C,), '0xFA8E -> Str -> 0x641C NormalizationTest.txt line no 13978';
ok Uni.new(0xFA8F).Str.NFC.list ~~ (0x6452,), '0xFA8F -> Str -> 0x6452 NormalizationTest.txt line no 13979';
ok Uni.new(0xFA90).Str.NFC.list ~~ (0x6556,), '0xFA90 -> Str -> 0x6556 NormalizationTest.txt line no 13980';
ok Uni.new(0xFA91).Str.NFC.list ~~ (0x6674,), '0xFA91 -> Str -> 0x6674 NormalizationTest.txt line no 13981';
ok Uni.new(0xFA92).Str.NFC.list ~~ (0x6717,), '0xFA92 -> Str -> 0x6717 NormalizationTest.txt line no 13982';
ok Uni.new(0xFA93).Str.NFC.list ~~ (0x671B,), '0xFA93 -> Str -> 0x671B NormalizationTest.txt line no 13983';
ok Uni.new(0xFA94).Str.NFC.list ~~ (0x6756,), '0xFA94 -> Str -> 0x6756 NormalizationTest.txt line no 13984';
ok Uni.new(0xFA95).Str.NFC.list ~~ (0x6B79,), '0xFA95 -> Str -> 0x6B79 NormalizationTest.txt line no 13985';
ok Uni.new(0xFA96).Str.NFC.list ~~ (0x6BBA,), '0xFA96 -> Str -> 0x6BBA NormalizationTest.txt line no 13986';
ok Uni.new(0xFA97).Str.NFC.list ~~ (0x6D41,), '0xFA97 -> Str -> 0x6D41 NormalizationTest.txt line no 13987';
ok Uni.new(0xFA98).Str.NFC.list ~~ (0x6EDB,), '0xFA98 -> Str -> 0x6EDB NormalizationTest.txt line no 13988';
ok Uni.new(0xFA99).Str.NFC.list ~~ (0x6ECB,), '0xFA99 -> Str -> 0x6ECB NormalizationTest.txt line no 13989';
ok Uni.new(0xFA9A).Str.NFC.list ~~ (0x6F22,), '0xFA9A -> Str -> 0x6F22 NormalizationTest.txt line no 13990';
ok Uni.new(0xFA9B).Str.NFC.list ~~ (0x701E,), '0xFA9B -> Str -> 0x701E NormalizationTest.txt line no 13991';
ok Uni.new(0xFA9C).Str.NFC.list ~~ (0x716E,), '0xFA9C -> Str -> 0x716E NormalizationTest.txt line no 13992';
ok Uni.new(0xFA9D).Str.NFC.list ~~ (0x77A7,), '0xFA9D -> Str -> 0x77A7 NormalizationTest.txt line no 13993';
ok Uni.new(0xFA9E).Str.NFC.list ~~ (0x7235,), '0xFA9E -> Str -> 0x7235 NormalizationTest.txt line no 13994';
ok Uni.new(0xFA9F).Str.NFC.list ~~ (0x72AF,), '0xFA9F -> Str -> 0x72AF NormalizationTest.txt line no 13995';
ok Uni.new(0xFAA0).Str.NFC.list ~~ (0x732A,), '0xFAA0 -> Str -> 0x732A NormalizationTest.txt line no 13996';
ok Uni.new(0xFAA1).Str.NFC.list ~~ (0x7471,), '0xFAA1 -> Str -> 0x7471 NormalizationTest.txt line no 13997';
ok Uni.new(0xFAA2).Str.NFC.list ~~ (0x7506,), '0xFAA2 -> Str -> 0x7506 NormalizationTest.txt line no 13998';
ok Uni.new(0xFAA3).Str.NFC.list ~~ (0x753B,), '0xFAA3 -> Str -> 0x753B NormalizationTest.txt line no 13999';
ok Uni.new(0xFAA4).Str.NFC.list ~~ (0x761D,), '0xFAA4 -> Str -> 0x761D NormalizationTest.txt line no 14000';
ok Uni.new(0xFAA5).Str.NFC.list ~~ (0x761F,), '0xFAA5 -> Str -> 0x761F NormalizationTest.txt line no 14001';
ok Uni.new(0xFAA6).Str.NFC.list ~~ (0x76CA,), '0xFAA6 -> Str -> 0x76CA NormalizationTest.txt line no 14002';
ok Uni.new(0xFAA7).Str.NFC.list ~~ (0x76DB,), '0xFAA7 -> Str -> 0x76DB NormalizationTest.txt line no 14003';
ok Uni.new(0xFAA8).Str.NFC.list ~~ (0x76F4,), '0xFAA8 -> Str -> 0x76F4 NormalizationTest.txt line no 14004';
ok Uni.new(0xFAA9).Str.NFC.list ~~ (0x774A,), '0xFAA9 -> Str -> 0x774A NormalizationTest.txt line no 14005';
ok Uni.new(0xFAAA).Str.NFC.list ~~ (0x7740,), '0xFAAA -> Str -> 0x7740 NormalizationTest.txt line no 14006';
ok Uni.new(0xFAAB).Str.NFC.list ~~ (0x78CC,), '0xFAAB -> Str -> 0x78CC NormalizationTest.txt line no 14007';

