/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.helper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import okio.ByteString;
import org.asamk.signal.manager.api.CaptchaRequiredException;
import org.asamk.signal.manager.api.DeviceLinkUrl;
import org.asamk.signal.manager.api.IncorrectPinException;
import org.asamk.signal.manager.api.NonNormalizedPhoneNumberException;
import org.asamk.signal.manager.api.Pair;
import org.asamk.signal.manager.api.PinLockMissingException;
import org.asamk.signal.manager.api.PinLockedException;
import org.asamk.signal.manager.api.RateLimitException;
import org.asamk.signal.manager.api.VerificationMethodNotAvailableException;
import org.asamk.signal.manager.config.ServiceConfig;
import org.asamk.signal.manager.helper.Context;
import org.asamk.signal.manager.internal.SignalDependencies;
import org.asamk.signal.manager.jobs.SyncStorageJob;
import org.asamk.signal.manager.storage.SignalAccount;
import org.asamk.signal.manager.util.KeyUtils;
import org.asamk.signal.manager.util.NumberVerificationUtils;
import org.asamk.signal.manager.util.Utils;
import org.signal.core.util.Base64;
import org.signal.libsignal.protocol.IdentityKeyPair;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.protocol.SignalProtocolAddress;
import org.signal.libsignal.protocol.ecc.ECPrivateKey;
import org.signal.libsignal.protocol.state.KyberPreKeyRecord;
import org.signal.libsignal.protocol.state.SignedPreKeyRecord;
import org.signal.libsignal.protocol.util.KeyHelper;
import org.signal.libsignal.usernames.BaseUsernameException;
import org.signal.libsignal.usernames.Username;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.signalservice.api.SignalServiceAccountDataStore;
import org.whispersystems.signalservice.api.SignalServiceAccountManager;
import org.whispersystems.signalservice.api.SignalServiceMessageSender;
import org.whispersystems.signalservice.api.account.AccountApi;
import org.whispersystems.signalservice.api.account.ChangePhoneNumberRequest;
import org.whispersystems.signalservice.api.crypto.UntrustedIdentityException;
import org.whispersystems.signalservice.api.kbs.MasterKey;
import org.whispersystems.signalservice.api.link.LinkDeviceApi;
import org.whispersystems.signalservice.api.link.LinkedDeviceVerificationCodeResponse;
import org.whispersystems.signalservice.api.push.ServiceId;
import org.whispersystems.signalservice.api.push.ServiceIdType;
import org.whispersystems.signalservice.api.push.SignedPreKeyEntity;
import org.whispersystems.signalservice.api.push.UsernameLinkComponents;
import org.whispersystems.signalservice.api.push.exceptions.AlreadyVerifiedException;
import org.whispersystems.signalservice.api.push.exceptions.AuthorizationFailedException;
import org.whispersystems.signalservice.api.push.exceptions.DeprecatedVersionException;
import org.whispersystems.signalservice.api.push.exceptions.UsernameIsNotReservedException;
import org.whispersystems.signalservice.api.push.exceptions.UsernameMalformedException;
import org.whispersystems.signalservice.api.push.exceptions.UsernameTakenException;
import org.whispersystems.signalservice.api.registration.RegistrationApi;
import org.whispersystems.signalservice.api.util.DeviceNameUtil;
import org.whispersystems.signalservice.internal.push.DeviceLimitExceededException;
import org.whispersystems.signalservice.internal.push.KyberPreKeyEntity;
import org.whispersystems.signalservice.internal.push.OutgoingPushMessage;
import org.whispersystems.signalservice.internal.push.ReserveUsernameResponse;
import org.whispersystems.signalservice.internal.push.SyncMessage;
import org.whispersystems.signalservice.internal.push.VerifyAccountResponse;
import org.whispersystems.signalservice.internal.push.WhoAmIResponse;
import org.whispersystems.signalservice.internal.push.exceptions.MismatchedDevicesException;
import org.whispersystems.signalservice.internal.util.Util;

public class AccountHelper {
    private static final Logger logger = LoggerFactory.getLogger(AccountHelper.class);
    private final Context context;
    private final SignalAccount account;
    private final SignalDependencies dependencies;
    private Callable unregisteredListener;
    public static final int USERNAME_MIN_LENGTH = 3;
    public static final int USERNAME_MAX_LENGTH = 32;

    public AccountHelper(Context context) {
        this.account = context.getAccount();
        this.dependencies = context.getDependencies();
        this.context = context;
    }

    public void setUnregisteredListener(Callable unregisteredListener) {
        this.unregisteredListener = unregisteredListener;
    }

    public void checkAccountState() throws IOException {
        if (this.account.getLastReceiveTimestamp() == 0L) {
            logger.info("The Signal protocol expects that incoming messages are regularly received.");
        } else {
            long diffInMilliseconds = System.currentTimeMillis() - this.account.getLastReceiveTimestamp();
            long days = TimeUnit.DAYS.convert(diffInMilliseconds, TimeUnit.MILLISECONDS);
            if (days > 7L) {
                logger.warn("Messages have been last received {} days ago. The Signal protocol expects that incoming messages are regularly received.", (Object)days);
            }
        }
        try {
            this.updateAccountAttributes();
            if (this.account.getPreviousStorageVersion() < 9) {
                this.context.getPreKeyHelper().forceRefreshPreKeys();
            } else {
                this.context.getPreKeyHelper().refreshPreKeysIfNecessary();
            }
            if (this.account.getAci() == null || this.account.getPni() == null) {
                this.checkWhoAmiI();
            }
            if (!this.account.isPrimaryDevice() && this.account.getPniIdentityKeyPair() == null) {
                throw new IOException("Missing PNI identity key, relinking required");
            }
            if (this.account.getPreviousStorageVersion() < 10 && this.account.isPrimaryDevice() && this.account.getRegistrationLockPin() != null) {
                this.migrateRegistrationPin();
            }
            if (this.account.getUsername() != null && this.account.getUsernameLink() == null) {
                try {
                    this.tryToSetUsernameLink(new Username(this.account.getUsername()));
                }
                catch (BaseUsernameException e) {
                    logger.debug("Invalid local username");
                }
            }
        }
        catch (DeprecatedVersionException e) {
            logger.debug("Signal-Server returned deprecated version exception", (Throwable)e);
            throw e;
        }
        catch (AuthorizationFailedException e) {
            this.account.setRegistered(false);
            throw e;
        }
    }

    public void checkWhoAmiI() throws IOException {
        WhoAmIResponse whoAmI = this.dependencies.getAccountManager().getWhoAmI();
        String number = whoAmI.getNumber();
        ServiceId.ACI aci = ServiceId.ACI.parseOrThrow((String)whoAmI.getAci());
        ServiceId.PNI pni = ServiceId.PNI.parseOrThrow((String)whoAmI.getPni());
        if (number.equals(this.account.getNumber()) && aci.equals((Object)this.account.getAci()) && pni.equals((Object)this.account.getPni())) {
            return;
        }
        this.updateSelfIdentifiers(number, aci, pni);
    }

    private void updateSelfIdentifiers(String number, ServiceId.ACI aci, ServiceId.PNI pni) {
        this.account.setNumber(number);
        this.account.setAci(aci);
        this.account.setPni(pni);
        if (this.account.isPrimaryDevice() && this.account.getPniIdentityKeyPair() == null) {
            this.account.setPniIdentityKeyPair(KeyUtils.generateIdentityKeyPair());
        }
        this.account.getRecipientTrustedResolver().resolveSelfRecipientTrusted(this.account.getSelfRecipientAddress());
        this.context.getUnidentifiedAccessHelper().rotateSenderCertificates();
        this.dependencies.resetAfterAddressChange();
        this.context.getGroupV2Helper().clearAuthCredentialCache();
        this.context.getAccountFileUpdater().updateAccountIdentifiers(this.account.getNumber(), this.account.getAci());
        this.context.getJobExecutor().enqueueJob(new SyncStorageJob());
    }

    public void setPni(ServiceId.PNI updatedPni, IdentityKeyPair pniIdentityKeyPair, String number, int localPniRegistrationId, SignedPreKeyRecord pniSignedPreKey, KyberPreKeyRecord lastResortKyberPreKey) throws IOException {
        this.updateSelfIdentifiers(number != null ? number : this.account.getNumber(), this.account.getAci(), updatedPni);
        this.account.setNewPniIdentity(pniIdentityKeyPair, pniSignedPreKey, lastResortKyberPreKey, localPniRegistrationId);
        this.context.getPreKeyHelper().refreshPreKeysIfNecessary(ServiceIdType.PNI);
    }

    public void startChangeNumber(String newNumber, boolean voiceVerification, String captcha) throws IOException, CaptchaRequiredException, NonNormalizedPhoneNumberException, RateLimitException, VerificationMethodNotAvailableException {
        SignalServiceAccountManager accountManager = this.dependencies.createUnauthenticatedAccountManager(newNumber, this.account.getPassword());
        RegistrationApi registrationApi = accountManager.getRegistrationApi();
        String sessionId = NumberVerificationUtils.handleVerificationSession(registrationApi, this.account.getSessionId(newNumber), id -> this.account.setSessionId(newNumber, (String)id), voiceVerification, captcha);
        NumberVerificationUtils.requestVerificationCode(registrationApi, sessionId, voiceVerification);
    }

    public void finishChangeNumber(String newNumber, String verificationCode, String pin) throws IncorrectPinException, PinLockedException, IOException, PinLockMissingException {
        for (int attempts = 0; attempts < 5; ++attempts) {
            try {
                this.finishChangeNumberInternal(newNumber, verificationCode, pin);
                break;
            }
            catch (MismatchedDevicesException e) {
                logger.debug("Change number failed with mismatched devices, retrying.");
                try {
                    this.dependencies.getMessageSender().handleChangeNumberMismatchDevices(e.getMismatchedDevices());
                    continue;
                }
                catch (UntrustedIdentityException ex) {
                    throw new AssertionError((Object)ex);
                }
            }
        }
    }

    private void finishChangeNumberInternal(String newNumber, String verificationCode, String pin) throws IncorrectPinException, PinLockedException, IOException, PinLockMissingException {
        IdentityKeyPair pniIdentity = KeyUtils.generateIdentityKeyPair();
        ArrayList<OutgoingPushMessage> encryptedDeviceMessages = new ArrayList<OutgoingPushMessage>();
        HashMap<Integer, SignedPreKeyEntity> devicePniSignedPreKeys = new HashMap<Integer, SignedPreKeyEntity>();
        HashMap<Integer, KyberPreKeyEntity> devicePniLastResortKyberPreKeys = new HashMap<Integer, KyberPreKeyEntity>();
        HashMap<Integer, Integer> pniRegistrationIds = new HashMap<Integer, Integer>();
        int selfDeviceId = this.account.getDeviceId();
        SyncMessage.PniChangeNumber selfChangeNumber = null;
        ArrayList<Integer> deviceIds = new ArrayList<Integer>();
        deviceIds.add(1);
        ServiceId.ACI aci = this.account.getAci();
        SignalServiceAccountDataStore accountDataStore = this.account.getSignalServiceDataStore().aci();
        List<Integer> subDeviceSessions = accountDataStore.getSubDeviceSessions(aci.toString()).stream().filter(deviceId -> accountDataStore.containsSession(new SignalProtocolAddress(aci.toString(), deviceId.intValue()))).toList();
        deviceIds.addAll(subDeviceSessions);
        SignalServiceMessageSender messageSender = this.dependencies.getMessageSender();
        for (Integer deviceId2 : deviceIds) {
            KyberPreKeyRecord lastResortKyberPreKeyRecord;
            SignedPreKeyRecord signedPreKeyRecord;
            try {
                signedPreKeyRecord = KeyUtils.generateSignedPreKeyRecord(KeyUtils.getRandomInt(ServiceConfig.PREKEY_MAXIMUM_ID), pniIdentity.getPrivateKey());
                SignedPreKeyEntity signedPreKeyEntity = new SignedPreKeyEntity(signedPreKeyRecord.getId(), signedPreKeyRecord.getKeyPair().getPublicKey(), signedPreKeyRecord.getSignature());
                devicePniSignedPreKeys.put(deviceId2, signedPreKeyEntity);
            }
            catch (InvalidKeyException e) {
                throw new AssertionError("unexpected invalid key", e);
            }
            try {
                lastResortKyberPreKeyRecord = KeyUtils.generateKyberPreKeyRecord(KeyUtils.getRandomInt(ServiceConfig.PREKEY_MAXIMUM_ID), pniIdentity.getPrivateKey());
                KyberPreKeyEntity kyberPreKeyEntity = new KyberPreKeyEntity(lastResortKyberPreKeyRecord.getId(), lastResortKyberPreKeyRecord.getKeyPair().getPublicKey(), lastResortKyberPreKeyRecord.getSignature());
                devicePniLastResortKyberPreKeys.put(deviceId2, kyberPreKeyEntity);
            }
            catch (InvalidKeyException e) {
                throw new AssertionError("unexpected invalid key", e);
            }
            int pniRegistrationId = -1;
            while (pniRegistrationId < 0 || pniRegistrationIds.containsValue(pniRegistrationId)) {
                pniRegistrationId = KeyHelper.generateRegistrationId((boolean)false);
            }
            pniRegistrationIds.put(deviceId2, pniRegistrationId);
            SyncMessage.PniChangeNumber pniChangeNumber = new SyncMessage.PniChangeNumber.Builder().identityKeyPair(ByteString.of((byte[])pniIdentity.serialize())).signedPreKey(ByteString.of((byte[])signedPreKeyRecord.serialize())).lastResortKyberPreKey(ByteString.of((byte[])lastResortKyberPreKeyRecord.serialize())).registrationId(Integer.valueOf(pniRegistrationId)).newE164(newNumber).build();
            if (deviceId2 == selfDeviceId) {
                selfChangeNumber = pniChangeNumber;
                continue;
            }
            try {
                OutgoingPushMessage message = messageSender.getEncryptedSyncPniInitializeDeviceMessage(deviceId2.intValue(), pniChangeNumber);
                encryptedDeviceMessages.add(message);
            }
            catch (IOException | InvalidKeyException | UntrustedIdentityException e) {
                throw new RuntimeException(e);
            }
        }
        String sessionId = this.account.getSessionId(newNumber);
        Pair<VerifyAccountResponse, MasterKey> result = NumberVerificationUtils.verifyNumber(sessionId, verificationCode, pin, this.context.getPinHelper(), (sessionId1, verificationCode1, registrationLock) -> {
            RegistrationApi registrationApi = this.dependencies.getRegistrationApi();
            AccountApi accountApi = this.dependencies.getAccountApi();
            try {
                Utils.handleResponseException(registrationApi.verifyAccount(sessionId1, verificationCode1));
            }
            catch (AlreadyVerifiedException alreadyVerifiedException) {
                // empty catch block
            }
            return (VerifyAccountResponse)Utils.handleResponseException(accountApi.changeNumber(new ChangePhoneNumberRequest(sessionId1, null, newNumber, registrationLock, pniIdentity.getPublicKey(), (List)encryptedDeviceMessages, Utils.mapKeys(devicePniSignedPreKeys, Object::toString), Utils.mapKeys(devicePniLastResortKyberPreKeys, Object::toString), Utils.mapKeys(pniRegistrationIds, Object::toString))));
        });
        ServiceId.PNI updatePni = ServiceId.PNI.parseOrThrow((String)result.first().getPni());
        if (updatePni.equals((Object)this.account.getPni())) {
            logger.debug("PNI is unchanged after change number");
            return;
        }
        this.handlePniChangeNumberMessage(selfChangeNumber, updatePni);
    }

    public void handlePniChangeNumberMessage(SyncMessage.PniChangeNumber pniChangeNumber, ServiceId.PNI updatedPni) {
        if (pniChangeNumber.identityKeyPair != null && pniChangeNumber.registrationId != null && pniChangeNumber.signedPreKey != null) {
            logger.debug("New PNI: {}", (Object)updatedPni);
            try {
                this.setPni(updatedPni, new IdentityKeyPair(pniChangeNumber.identityKeyPair.toByteArray()), pniChangeNumber.newE164, pniChangeNumber.registrationId, new SignedPreKeyRecord(pniChangeNumber.signedPreKey.toByteArray()), pniChangeNumber.lastResortKyberPreKey != null ? new KyberPreKeyRecord(pniChangeNumber.lastResortKyberPreKey.toByteArray()) : null);
            }
            catch (Exception e) {
                logger.warn("Failed to handle change number message", (Throwable)e);
            }
        }
    }

    public void reserveUsernameFromNickname(String nickname) throws IOException, BaseUsernameException {
        String currentNickname;
        String currentUsername = this.account.getUsername();
        if (currentUsername != null && (currentNickname = currentUsername.substring(0, currentUsername.indexOf(46))).equals(nickname)) {
            try {
                this.refreshCurrentUsername();
                return;
            }
            catch (IOException | BaseUsernameException e) {
                logger.warn("[reserveUsername] Failed to refresh current username, trying to claim new username");
            }
        }
        List candidates = Username.candidatesFrom((String)nickname, (int)3, (int)32);
        this.reserveUsername(candidates);
    }

    public void reserveExactUsername(String username) throws IOException, BaseUsernameException {
        String currentUsername = this.account.getUsername();
        if (currentUsername != null && currentUsername.equals(username)) {
            try {
                this.refreshCurrentUsername();
                return;
            }
            catch (IOException | BaseUsernameException e) {
                logger.warn("[reserveUsername] Failed to refresh current username, trying to claim new username");
            }
        }
        List<Username> candidates = List.of(new Username(username));
        this.reserveUsername(candidates);
    }

    private void reserveUsername(List<Username> candidates) throws IOException {
        ArrayList<String> candidateHashes = new ArrayList<String>();
        for (Username candidate : candidates) {
            candidateHashes.add(Base64.encodeUrlSafeWithoutPadding((byte[])candidate.getHash()));
        }
        ReserveUsernameResponse response = (ReserveUsernameResponse)Utils.handleResponseException(this.dependencies.getAccountApi().reserveUsername(candidateHashes));
        int hashIndex = candidateHashes.indexOf(response.getUsernameHash());
        if (hashIndex == -1) {
            logger.warn("[reserveUsername] The response hash could not be found in our set of candidateHashes.");
            throw new IOException("Unexpected username response");
        }
        logger.debug("[reserveUsername] Successfully reserved username.");
        Username username = candidates.get(hashIndex);
        UsernameLinkComponents linkComponents = this.confirmUsernameAndCreateNewLink(username);
        this.account.setUsername(username.getUsername());
        this.account.setUsernameLink(linkComponents);
        this.account.getRecipientStore().resolveSelfRecipientTrusted(this.account.getSelfRecipientAddress());
        this.account.getRecipientStore().rotateSelfStorageId();
        logger.debug("[confirmUsername] Successfully confirmed username.");
    }

    public UsernameLinkComponents createUsernameLink(Username username) throws IOException {
        try {
            Username.UsernameLink link = username.generateLink();
            return (UsernameLinkComponents)Utils.handleResponseException(this.dependencies.getAccountApi().createUsernameLink(link));
        }
        catch (BaseUsernameException e) {
            throw new AssertionError((Object)e);
        }
    }

    private UsernameLinkComponents confirmUsernameAndCreateNewLink(Username username) throws IOException {
        try {
            Username.UsernameLink link = username.generateLink();
            UUID serverId = (UUID)Utils.handleResponseException(this.dependencies.getAccountApi().confirmUsername(username, link));
            return new UsernameLinkComponents(link.getEntropy(), serverId);
        }
        catch (BaseUsernameException e) {
            throw new AssertionError((Object)e);
        }
    }

    private UsernameLinkComponents reclaimUsernameAndLink(Username username, UsernameLinkComponents linkComponents) throws IOException {
        try {
            Username.UsernameLink link = username.generateLink(linkComponents.getEntropy());
            UUID serverId = (UUID)Utils.handleResponseException(this.dependencies.getAccountApi().confirmUsername(username, link));
            return new UsernameLinkComponents(link.getEntropy(), serverId);
        }
        catch (BaseUsernameException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void refreshCurrentUsername() throws IOException, BaseUsernameException {
        String localUsername = this.account.getUsername();
        if (localUsername == null) {
            return;
        }
        WhoAmIResponse whoAmIResponse = this.dependencies.getAccountManager().getWhoAmI();
        String serverUsernameHash = whoAmIResponse.getUsernameHash();
        boolean hasServerUsername = !Util.isEmpty((String)serverUsernameHash);
        Username username = new Username(localUsername);
        String localUsernameHash = Base64.encodeUrlSafeWithoutPadding((byte[])username.getHash());
        if (!hasServerUsername) {
            logger.debug("No remote username is set.");
        }
        if (!Objects.equals(localUsernameHash, serverUsernameHash)) {
            logger.debug("Local username hash does not match server username hash.");
        }
        if (!hasServerUsername || !Objects.equals(localUsernameHash, serverUsernameHash)) {
            logger.debug("Attempting to resynchronize username.");
            try {
                this.tryReserveConfirmUsername(username);
            }
            catch (UsernameIsNotReservedException | UsernameMalformedException | UsernameTakenException e) {
                logger.debug("[confirmUsername] Failed to reserve confirm username: {} ({})", (Object)e.getMessage(), (Object)e.getClass().getSimpleName());
                this.account.setUsername(null);
                this.account.setUsernameLink(null);
                this.account.getRecipientStore().rotateSelfStorageId();
                throw e;
            }
        } else {
            logger.debug("Username already set, not refreshing.");
        }
    }

    private void tryReserveConfirmUsername(Username username) throws IOException {
        UsernameLinkComponents usernameLink = this.account.getUsernameLink();
        if (usernameLink == null) {
            Utils.handleResponseException(this.dependencies.getAccountApi().reserveUsername(List.of(Base64.encodeUrlSafeWithoutPadding((byte[])username.getHash()))));
            logger.debug("[reserveUsername] Successfully reserved existing username.");
            UsernameLinkComponents linkComponents = this.confirmUsernameAndCreateNewLink(username);
            this.account.setUsernameLink(linkComponents);
            logger.debug("[confirmUsername] Successfully confirmed existing username.");
        } else {
            UsernameLinkComponents linkComponents = this.reclaimUsernameAndLink(username, usernameLink);
            this.account.setUsernameLink(linkComponents);
            logger.debug("[confirmUsername] Successfully reclaimed existing username and link.");
        }
        this.account.getRecipientStore().rotateSelfStorageId();
    }

    private void tryToSetUsernameLink(Username username) {
        for (int i = 1; i < 4; ++i) {
            try {
                UsernameLinkComponents linkComponents = this.createUsernameLink(username);
                this.account.setUsernameLink(linkComponents);
                break;
            }
            catch (IOException e) {
                logger.debug("[tryToSetUsernameLink] Failed with IOException on attempt {}/3", (Object)i, (Object)e);
                continue;
            }
        }
    }

    public void deleteUsername() throws IOException {
        Utils.handleResponseException(this.dependencies.getAccountApi().deleteUsername());
        this.account.setUsernameLink(null);
        this.account.setUsername(null);
        logger.debug("[deleteUsername] Successfully deleted the username.");
    }

    public void setDeviceName(String deviceName) {
        ECPrivateKey privateKey = this.account.getAciIdentityKeyPair().getPrivateKey();
        String encryptedDeviceName = DeviceNameUtil.encryptDeviceName((String)deviceName, (ECPrivateKey)privateKey);
        this.account.setEncryptedDeviceName(encryptedDeviceName);
    }

    public void updateAccountAttributes() throws IOException {
        Utils.handleResponseException(this.dependencies.getAccountApi().setAccountAttributes(this.account.getAccountAttributes(null)));
    }

    public void addDevice(DeviceLinkUrl deviceLinkInfo) throws IOException, org.asamk.signal.manager.api.DeviceLimitExceededException {
        LinkedDeviceVerificationCodeResponse verificationCode;
        LinkDeviceApi linkDeviceApi = this.dependencies.getLinkDeviceApi();
        try {
            verificationCode = (LinkedDeviceVerificationCodeResponse)Utils.handleResponseException(linkDeviceApi.getDeviceVerificationCode());
        }
        catch (DeviceLimitExceededException e) {
            throw new org.asamk.signal.manager.api.DeviceLimitExceededException("Too many linked devices", e);
        }
        Utils.handleResponseException(this.dependencies.getLinkDeviceApi().linkDevice(this.account.getNumber(), this.account.getAci(), this.account.getPni(), deviceLinkInfo.deviceIdentifier(), deviceLinkInfo.deviceKey(), this.account.getAciIdentityKeyPair(), this.account.getPniIdentityKeyPair(), this.account.getProfileKey(), this.account.getOrCreateAccountEntropyPool(), this.account.getOrCreatePinMasterKey(), this.account.getOrCreateMediaRootBackupKey(), verificationCode.getVerificationCode(), null));
        this.account.setMultiDevice(true);
        this.context.getJobExecutor().enqueueJob(new SyncStorageJob());
    }

    public void removeLinkedDevices(int deviceId) throws IOException {
        Utils.handleResponseException(this.dependencies.getLinkDeviceApi().removeDevice(deviceId));
        List devices = (List)Utils.handleResponseException(this.dependencies.getLinkDeviceApi().getDevices());
        this.account.setMultiDevice(devices.size() > 1);
    }

    public void migrateRegistrationPin() throws IOException {
        MasterKey masterKey = this.account.getOrCreatePinMasterKey();
        this.context.getPinHelper().migrateRegistrationLockPin(this.account.getRegistrationLockPin(), masterKey);
        Utils.handleResponseException(this.dependencies.getAccountApi().enableRegistrationLock(masterKey.deriveRegistrationLock()));
    }

    public void setRegistrationPin(String pin) throws IOException {
        MasterKey masterKey = this.account.getOrCreatePinMasterKey();
        this.context.getPinHelper().setRegistrationLockPin(pin, masterKey);
        Utils.handleResponseException(this.dependencies.getAccountApi().enableRegistrationLock(masterKey.deriveRegistrationLock()));
        this.account.setRegistrationLockPin(pin);
        this.updateAccountAttributes();
    }

    public void removeRegistrationPin() throws IOException {
        this.context.getPinHelper().removeRegistrationLockPin();
        Utils.handleResponseException(this.dependencies.getAccountApi().disableRegistrationLock());
        this.account.setRegistrationLockPin(null);
    }

    public void unregister() throws IOException {
        Utils.handleResponseException(this.dependencies.getAccountApi().clearFcmToken());
        this.account.setRegistered(false);
        this.unregisteredListener.call();
    }

    public void deleteAccount() throws IOException {
        try {
            this.context.getPinHelper().removeRegistrationLockPin();
        }
        catch (IOException e) {
            logger.warn("Failed to remove registration lock pin");
        }
        this.account.setRegistrationLockPin(null);
        Utils.handleResponseException(this.dependencies.getAccountApi().deleteAccount());
        this.account.setRegistered(false);
        this.unregisteredListener.call();
    }

    public static interface Callable {
        public void call();
    }
}

